---
layout: post
title: "Projects: Holographic Imaging of Suspended Particles"
description: ""
category: sediment, optics
tags: [holo]
---
{% include JB/setup %}

Collaborators: [Alex Nimmo Smith](http://www.plymouth.ac.uk/staff/animmosmith) & [Daniel Conley](http://www.plymouth.ac.uk/staff/dconley), Plymouth University, UK

Estimating sediment concentrations and size/shape using digital holography. In focus silhouettes of particle suspensions from submerged holographic imaging systems.

We are using [holoproc software](http://www.marinephysics.org/holoproc) to automatically process holographic images. We're working on validating these methods and developing improved automated particle classification methods.

We also collected holograms near the sand bed in the surf zone of a beach, over a wide range of wave energy conditions. Some montages of focused randomly selected particles during different time periods are shown below.

This example is from an especially aerated flow in the shallow surf zone:
![center](/figs/2013-02-24-holo/montage_5proc1.jpg)  

This example is from a period when lots of sand grains were suspended:
![center](/figs/2013-02-24-holo/montage_5proc2.jpg)  

This example is from a period of time where there are relatively large numbers of diatom chains in the water:
![center](/figs/2013-02-24-holo/montage_24proc3.jpg)  

We are using this data to test the performance of a co-located acoustic backscatter system and algorithms designed for deriving suspended sediment concentrations, of particles poessing a wide particle size distribution in turbulent water and in the presence of bubbles and diatoms. Measures of bubbles, diatoms and sand grains are being obtained from the holograms [see here](http://dbuscombe-usgs.github.com/sediment,%20acoustics/2013/02/24/abs/). For preliminary analysis, please see our 2012 International Conference on Coastal Engineering paper [pdf](/docs/ConleyEtAl_ICCE_2012.pdf)

More more info on in-line particle holography for imaging marine particles, please see:

Graham, G.W., Nimmo-Smith, W.A.M. (2010) The application of holography to the analysis of size and settling velocity of suspended cohesive sediments. Limnology and Oceanography: Methods

Davies, E.J., Nimmo-Smith, W.A.M., Agrawal, Y.C., and Souza, A.J. (2011) Scattering signatures of suspended particles: an integrated system for combining digital holography and laser diffraction. Optics Express 19, 25488-25499


<!--![center](/figs/2013-02-24-dgs/nicegrains1.jpg)  -->
<!--![center](/figs/2013-02-24-dgs/nicegrains2.jpg)  -->
<!--![center](/figs/2013-02-24-dgs/nicegrains3.jpg)  -->
