---
layout: post
title: "Projects: Grain Size from Sediment Photographs"
description: ""
category: sediment, optics
tags: [dgs]
---
{% include JB/setup %}

Collaborators: [David M Rubin](https://profile.usgs.gov/drubin) & [Jonathan Warrick](http://walrus.wr.usgs.gov/staff/jwarrick/), USGS Santa Cruz

Estimating grain size from digital images of sediment using automated analyses. Ours are statistical methods which do not rely on identifying and successfully segmenting each individual grain. Instead, they use the autorrelation or the spectral signature of the image to estimate grain size. This is an example of what we mean by 'an image of sediment'

![center](/figs/2013-02-24-dgs/nicegrains1.jpg)  
<!--![center](/figs/2013-02-24-dgs/nicegrains2.jpg)  -->
<!--![center](/figs/2013-02-24-dgs/nicegrains3.jpg)  -->

This is a well sorted sand, but the goal is to develop an accurate and automated method which works on as wide a range of sediments as possible. We develop and deploy systems which takes well-resolved images of bed sediment, for the purposes of sediment monitoring and sediment transport research.

The latest algorithm, downloadable [here](https://github.com/dbuscombe-usgs/), uses wavelet methods to estimate the grain size distribution of a very wide variety of sediment types, and even images of non-sedimentary 'granular' material such as [pancake ice] (http://en.wikipedia.org/wiki/Pancake_ice), cracked earth, and [polygonal patterned ground] (http://en.wikipedia.org/wiki/Patterned_ground). Paper forthcoming!

Various great collections of digital images of sediment can be found here:
[Sand Atlas](http://www.sandatlas.org/sand-types)
[Rob Holman](http://cil-www.oce.orst.edu)
[The International Sand Collectors Society](http://www.sandcollectors.org/Picture_Gallex.html)
[Christoph Huebeck](http://wikis.fu-berlin.de/display/geowisssand/Home)

Please let me know of any more to add to the list!

References which chart algorithm development:

- **Buscombe, D.**, 2008, Estimation of Grain Size Distributions and Associated Parameters from Digital Images of Sediment. Sedimentary Geology 210, 1-10. [pdf](/docs/Buscombe2008_SedGeol.pdf)

- **Buscombe, D.**, and Masselink, G., 2009, Grain Size Information from the Statistical Properties of Digital Images of Sediment. Sedimentology 56, 421-438. [pdf](/docs/BuscombeMasselink_Sedimentology2009.pdf)

- Warrick, J.A., Rubin, D.M., Ruggiero, P., Harney, J., Draut, A.E., and **Buscombe, D.**, 2009, Cobble Cam: Grain-size Measurements of Sand to Boulder from Digital Photographs and Autocorrelation Analyses. Earth Surface Processes and Landforms 34, 1811-1821.[pdf](/docs/WarrickEtAl_ESPL2009.pdf)

- **Buscombe, D.**, Rubin, D.M., and Warrick, J.A., 2010, Universal Approximation of Grain Size from Images of Non-Cohesive Sediment. Journal of Geophysical Research - Earth Surface 115, F02015, doi:10.1029/2009JF001477 [pdf](/docs/BuscombeEtAl_JGR2010.pdf)

- **Buscombe, D.**, and Rubin, D.M., 2012, Advances in the Simulation and Automated Measurement of Well-Sorted Granular Material, Part 1: Simulations. Journal of Geophysical Research - Earth Surface 117, F02001. doi:10.1029/2011JF001974.[pdf](/docs/BuscombeRubin2012_part1_2011JF001974.pdf)

- **Buscombe, D.**, and Rubin, D.M., 2012, Advances in the Simulation and Automated Measurement of Well-Sorted Granular Material, Part 2: Direct Measures of Particle Properties. Journal of Geophysical Research - Earth Surface 117, F02002. doi:10.1029/2011JF001975. [pdf](/docs/BuscombeRubin2012_part2_2011JF001975.pdf)

- **Buscombe, D.**, forthcoming!, Transferable Wavelet Method for Grain Size-Distribution from Images of Sediment Surfaces and Thin Sections, and Other Natural Granular Patterns. Submitted to Sedimentology

See [this website](http://walrus.wr.usgs.gov/seds/grainsize/code.html), for example images, example hardware, and further info (including the code for the algorithm which implements the algorithms of Buscombe et al 2010, and Buscombe and Rubin 2012b)



