---
layout: post
title: "Projects: Sediment Suspensions from Acoustic Backscatter"
description: ""
category: sediment, acoustics
tags: [abs]
---
{% include JB/setup %}

Collaborators: [Daniel Conley](http://www.plymouth.ac.uk/staff/dconley) & [Alex Nimmo Smith](http://www.plymouth.ac.uk/staff/animmosmith), Plymouth University, UK

Estimating suspended sediment concentrations using high-frequency acoustic backscatter sensors. Acoustic backscatter has great potential for measuring the concentration and size of sediment suspensions in water. We have been testing existing methods for deriving near-bed suspended sand concentrations.

In a controlled laboratory setting, glass spheres of various sizes were suspended in homogeneous turbulence. We used a 1,2, and 4 MHz system to measure suspensions in 5mm bins at sample frequencies up to 64Hz. Initial tests suggest that concentrations derived using existing algorithms, when averaged in time, performed well compared with concentrations from filtered samples. For preliminary analysis, please see our 2012 International Conference on Coastal Engineering paper [pdf](/docs/Buscombe_Conley_ICCE_2012.pdf)

We also collected acoustic backscatter data in the surf zone of a sand beach, over a wide range of wave energy conditions. We are testing the performance of the acoustic backscatter system and algorithms designed for deriving suspended sediment concentrations, of particles poessing a wide particle size distribution in turbulent water and in the presence of bubbles and diatoms. Measures of bubbles, diatoms and sand grains are being obtained using submersible particle holography [see here](http://dbuscombe-usgs.github.com/sediment,%20optics/2013/02/24/holo/). For preliminary analysis, please see our 2012 International Conference on Coastal Engineering paper [pdf](/docs/ConleyEtAl_ICCE_2012.pdf)


<!--![center](/figs/2013-02-24-dgs/nicegrains1.jpg)  -->
<!--![center](/figs/2013-02-24-dgs/nicegrains2.jpg)  -->
<!--![center](/figs/2013-02-24-dgs/nicegrains3.jpg)  -->
