"""
This script extracts example sampling pattern(s) for the ASPMCI
paper from a specified experiment results HDF5 file.

"""

from __future__ import division
import itertools

import matplotlib.pyplot as plt
import numpy as np
import tables as tb
from os import makedirs
import errno

import magni

# Setup - the following path can be changed if the result file is in a
# different location. This should correspond to the `result_folder`
# variable in 'aspmci_reconstructions.py', line 488:
data_path = './aspmci_reconstructions/'
hdf_database_name = 'aspmci_reconstructions.hdf5'

imsize = 128
sampling_patterns = ('rect_spiral',)
undersampling_ratios = (0.1,)

# Extract example sampling pattern(s), plot, and save
with tb.File(data_path + hdf_database_name, mode='r') as h5_file:
    try:
        makedirs('../figures/fig2/')
    except OSError, e:
        if e.errno != errno.EEXIST:
            throw
    for ur in undersampling_ratios:
        for pattern in sampling_patterns:
            img_coords = (h5_file.get_node('/simulation_results/{}/{}/d{}/{}/'.format(
                'image_0_mi', pattern,
                str(ur).replace('.', '_'), 'cubic_interpolation'),
                                           name='img_coords').read())
            disp_img = magni.imaging.measurements.unique_pixels(img_coords)
            plt.figure(figsize=(1,1)) # figsize chosen arbitrarily, but match it to dpi in line 48
            magni.imaging.measurements.plot_pixel_mask(imsize, imsize, disp_img)
            # Axis modification suggested in http://stackoverflow.com/a/26610602/865169
            plt.axis('off')
            plt.gcf().axes[0].get_xaxis().set_visible(False)
            plt.gcf().axes[0].get_yaxis().set_visible(False)
            plt.savefig('../figures/fig2/pattern-{}-{}.png'.format(pattern, str(ur).replace('.','_')), bbox_inches='tight', pad_inches=0, dpi=165.5) # dpi was chosen to match figzise in line 42 to obtain 128x128 resolution
