"""
CLi9 XYZ Export Script
Purpose: Generates the structural blueprint for the CLi9 metastable allotrope.
Format: Standard XYZ (compatible with Avogadro, VESTA, Jmol, and RDKit).
"""

# Final 'Hard-Deck' Coordinates (Angstroms)
cli9_geometry = [
    ('C',  -0.000012,  0.000014, -0.012733),
    ('Li',  1.571713,  0.003636, -0.011163),
    ('Li', -1.571736, -0.003555, -0.011154),
    ('Li',  0.003581,  1.571705, -0.011031),
    ('Li', -0.003596, -1.571744, -0.011286),
    ('Li',  0.788718,  0.788594,  1.094337),
    ('Li', -0.788619, -0.788750,  1.094242),
    ('Li',  0.777571, -0.777534, -1.115765),
    ('Li', -0.777687,  0.777717, -1.115532),
    ('Li',  0.000069, -0.000114,  1.716337)
]

def generate_xyz(coords, filename="CLi9.xyz"):
    try:
        with open(filename, 'w') as f:
            # Line 1: Number of atoms
            f.write(f"{len(coords)}\n")
            # Line 2: Comment/Metadata
            f.write("CLi9 Metastable Allotrope - UFT-F Resonance Lock - 845 GPa Bulk Modulus\n")
            # Atoms and Positions
            for atom, x, y, z in coords:
                f.write(f"{atom:<2} {x:14.8f} {y:14.8f} {z:14.8f}\n")
        
        print(f"Successfully generated: {filename}")
        print("You can now import this file into Avogadro or VESTA for rendering.")
    except Exception as e:
        print(f"Error generating file: {e}")

if __name__ == "__main__":
    generate_xyz(cli9_geometry)