/* Copyright (c) 2017-2026, United States Government, as represented by the
 * Administrator of the National Aeronautics and Space Administration.
 * 
 * All rights reserved.
 * 
 * The Astrobee platform is licensed under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

#ifndef ASP_RIG_CAMERA_UTILS_H
#define ASP_RIG_CAMERA_UTILS_H

#include <Eigen/Core>
#include <Eigen/Geometry>

#include <string>
#include <vector>
#include <algorithm>

// forward decl
namespace vw { namespace camera {
  class PinholeModel;
}}  // namespace vw::camera

namespace rig {

class CameraParameters;
class cameraImage;

// A utility for creating a pinhole camera model
void createPinholeCamera(rig::CameraParameters const& cam_params,
                         Eigen::Affine3d const& world_to_cam,
                         vw::camera::PinholeModel& pinhole_cam);

// A utility for saving a camera in a format ASP understands. For now do not save
// the distortion.
void writePinholeCamera(rig::CameraParameters const& cam_params,
                        Eigen::Affine3d          const& world_to_cam,
                        std::string              const& filename);
  
// Save the optimized cameras in ASP's Pinhole format. For now do not save
// the distortion model.
void writePinholeCameras(std::vector<std::string>              const& cam_names,
                         std::vector<rig::CameraParameters> const& cam_params,
                         std::vector<rig::cameraImage>         const& cams,
                         std::vector<Eigen::Affine3d>          const& world_to_cam,
                         std::string                           const& out_dir);

// Calculate camera center and ray direction in world coordinates from a distorted pixel
void calcCamCtrDir(rig::CameraParameters const& cam_params,
                   Eigen::Vector2d const& dist_pix,
                   Eigen::Affine3d const& world_to_cam,
                   // Output
                   Eigen::Vector3d& cam_ctr,
                   Eigen::Vector3d& world_ray);

}  // namespace rig

#endif  // ASP_RIG_CAMERA_UTILS_H
