# Supplementary Notes

## Scope
These notes retain extended mechanistic detail from the draft that was compressed out of the main manuscript to maintain IMRaD concision and reviewer-facing claim discipline.

## Extended node annotations

### NOD2 (extended)
The draft contains a stronger emphasis on NOD2 as both a microbial sensor and a tolerance calibrator than can be carried in main-text node summaries. Beyond NF-kB activation, NOD2 can engage negative regulatory programs (for example via IRF4-linked pathways in cited literature) that limit excessive TLR-driven inflammation [19,46,47,117]. This dual role helps explain why NOD2 loss is not simply "less inflammation" but can instead produce dysregulated or persistent inflammatory signaling under high microbial load. The stricturing association may therefore reflect repeated unresolved injury cycles rather than a direct pro-fibrotic biochemical instruction from NOD2 itself [84,85].

### ATG16L1/IRGM (extended)
The source draft includes substantial detail on Paneth-granule abnormalities and virus-gene interaction phenomena in Atg16l1 systems [7,29]. These details are important for biological plausibility but can dominate the narrative if presented without causal triage. In the streamlined manuscript they are treated as mechanistic reinforcement for autophagic fragility rather than as independent causal claims. IRGM is retained as a branch partner but with explicit heterogeneity caveats across populations and study designs.

### XBP1 (extended)
The draft places XBP1 at a mechanistic crossroads between secretory-cell survival and immune amplification, with mouse knockout data as major support [8]. In the compressed main text, this is preserved as a stress-bridge role, but not over-promoted as a dominant human genetic driver. The supplementary view emphasizes that XBP1 insufficiency may become most visible under combined pressure (autophagy defects, microbial challenge, and inflammatory cytokine exposure), which can make pure single-node human inference difficult. This is why the edge to IL23R is retained but marked as partly inferred.

### IL23R (extended)
The draft includes detailed cytokine biology where IL-23, IL-17, and IL-22 effects can be context- and time-dependent [40,50,69,70]. To avoid over-simplifying this in the main text, IL23R is described as an amplifier node rather than a universally pathological switch. The negative secukinumab signal is interpreted as evidence of network-position mismatch, not as evidence that IL-17 biology is uniformly protective [49,50]. This distinction matters for reviewer-facing logic because it separates pathway topology from simplistic cytokine-good/cytokine-bad framing.

### MUC2/barrier node (extended)
The draft extends barrier discussion beyond MUC2 genetics to barrier-supporting loci, mucus continuity measurements, and bacterial proximity effects [51-63]. In the main text, MUC2 is used as an operational barrier node to keep the model compact. The supplementary framing clarifies that this node can be replaced by a broader "barrier integrity module" in future revisions if direct Crohn-specific MUC2 causality remains weak. The retained feedback concept is therefore biological rather than gene-exclusive.

## Extended edge logic

### `ATG16L1/IRGM -> XBP1`
This edge is vulnerable because the chain from autophagic failure to UPR decompensation is supported by strong mechanistic plausibility and model systems, but limited direct intervention sequencing in human tissue [5,7,8,76]. The draft's stronger rhetoric was softened in the main text to "inferred" status with a direct falsification path. A practical experiment is paired rescue: restore autophagy function first, then test whether UPR signatures normalize under controlled microbial challenge.

### `IL23R -> MUC2`
The draft text includes nuance that IL-22 can transiently support barrier recovery, while chronic inflammatory context can drive goblet depletion or exhaustion [69,70]. The main manuscript keeps this edge but explicitly rejects monotonic interpretation. The edge should be treated as chronic-state directional tendency, not as a universal response to any IL-23-axis activity.

### `MUC2 -> NOD2` feedback
Barrier-first feedback is one of the most intuitive elements clinically, but direct ileal quantitative proof is less mature than for upstream genetics. The main manuscript therefore labels it moderate-confidence and keeps it because removing feedback makes relapse dynamics harder to explain mechanistically. This is a model utility argument, not a final proof argument.

## Extended therapeutic considerations
The draft included broad discussion of prime editing and node-by-node correction. Main text compresses this into falsifiable strategy language to avoid therapeutic over-promise [94,115,116]. Supplementary emphasis:
- Gene correction should be framed first as causal perturbation testing.
- Pharmacologic biologics remain the current standard and likely bridge therapy even in future correction-based designs.
- Durable drug-free remission is a hypothesis endpoint, not an expected near-term outcome.

## Additional alternative explanations (expanded)
1. A subset may be driven by adaptive antigen-specific loops where epithelial defects are secondary.
2. Mesenchymal priming could independently increase fibrosis liability in some patients.
3. Environmental initiation events (smoking, infection, dysbiosis shifts) may bypass portions of the proposed order [123,124].
4. Some non-core loci may prove to be context-specific initiators in stratified subgroups rather than amplifiers.

These alternatives do not negate the current model but define high-priority comparisons for future revisions.
