# Figure Manifest

## Figure 1
- **Filename:** `fig1_minimal_circuit.png`, `fig1_minimal_circuit.svg`
- **Title:** Minimal five-node causal circuit for ileal-predominant Crohn's disease
- **Provenance:** Conceptual schematic (not direct dataset output).
- **Hypothesis:** A compact directed topology captures dominant ileal Crohn mechanistic flow while keeping falsification explicit.
- **Data source:** Conceptual topology from manuscript synthesis.
- **Methods:** Scripted schematic rendering in `output/figures/code/generate_figures.py`.
- **Caption:** This schematic defines the testable causal topology: `NOD2 -> ATG16L1/IRGM -> XBP1 -> IL23R -> MUC2`, with feedback `MUC2 -> NOD2`. The figure is intentionally structural and does not encode effect sizes. Edge strength and uncertainty are quantified separately in Fig. 3.
- **Limitation:** Topology-only view; no dynamic timing or effect-magnitude information.

## Figure 2
- **Filename:** `fig2_node_leverage.png`, `fig2_node_leverage.svg`
- **Title:** Node leverage ranking from real genetics, network, and ileal single-cell data
- **Provenance:** Real-data-derived.
- **Hypothesis:** Core nodes differ in leverage and can be ranked reproducibly from explicit multi-source metrics.
- **Data source:** `output/tables/node_rank_table.csv` built from Open Targets + STRING + CELLxGENE TI Crohn/normal datasets.
- **Methods:** Additive 0-14 score: Open Targets genetic support (0-3), Open Targets literature support (0-3), STRING convergence (0-3), Crohn-cell activity (0-3), Open Targets overall association (0-2).
- **Caption:** NOD2 ranks highest, followed by ATG16L1/IRGM and IL23R, with XBP1 and MUC2 lower under this integrated real-data rubric. XBP1 and MUC2 nonetheless retain strong epithelial activity components, indicating that aggregate leverage and tissue-state intensity capture complementary dimensions. Error bars represent uncertainty qualifiers from source completeness and modeling assumptions, not inferential confidence intervals.
- **Limitation:** Weighting of the additive rubric remains investigator-defined even though all underlying inputs are real and reproducible.

## Figure 3
- **Filename:** `fig3_edge_evidence_heatmap.png`, `fig3_edge_evidence_heatmap.svg`
- **Title:** Edge-level evidence matrix from genetics, disease-state coupling, functional coupling, and literature support
- **Provenance:** Real-data-derived.
- **Hypothesis:** Directed edges retain unequal support and should be shown as a graded matrix, not binary kept/removed links.
- **Data source:** `output/tables/edge_evidence_scores.csv` (Open Targets + Crohn/normal scRNA coupling + STRING + literature channel).
- **Methods:** 0-2 per channel, summed to 0-8 total per edge. Disease-state coupling combines Crohn cell-type module correlation with Crohn-normal delta consistency.
- **Caption:** The strongest edge remains `NOD2 -> ATG16L1/IRGM`. Middle and distal edges are retained but show lower total support and remain priority falsification targets; for `MUC2 -> NOD2`, support is driven more by barrier literature and functional coupling than by disease-state coupling scores. The heatmap is intended as an uncertainty map, not proof of unidirectional causality.
- **Limitation:** Correlation-based disease-coupling metrics are supportive, not interventional proof.

## Figure 4
- **Filename:** `fig4_phenotype_mapping.png`, `fig4_phenotype_mapping.svg`
- **Title:** Node-to-phenotype mapping from Crohn/normal ileal single-cell module profiles
- **Provenance:** Real-data-derived.
- **Hypothesis:** Phenotype alignment can be represented conservatively as graded support from real module-level data.
- **Data source:** `output/tables/phenotype_mapping_scores.csv`, with raw values in `output/tables/phenotype_mapping_raw_metrics.csv`.
- **Methods:** Relative tiering from real features (1-3 for observed values; 0 reserved for missing): epithelial enrichment, Paneth-associated signal, fibrosis-module coupling, TNF-axis coupling, and IL-23-axis coupling.
- **Caption:** The map summarizes conservative support gradients for ileal localization, Paneth pathology, stricturing/fibrosis tendency, and therapy-response dimensions. Scores are within-column relative tiers, so a lower tier indicates lower relative support in that dimension rather than biological absence. The panel is designed for hypothesis stratification, not deterministic subtype assignment, and should be interpreted alongside the genetics-weighted node-leverage ranking.
- **Limitation:** Tiering compresses effect-size information and should be interpreted with the raw metric table.
