# Data Sources

## Primary external sources used for quantitative analyses
1. **Open Targets Platform (Crohn target evidence)**
- Endpoint: `https://api.platform.opentargets.org/api/v4/graphql`
- Disease identifier: `EFO_0000384`
- Used for: genetics/literature/overall target evidence in node and edge scoring.

2. **STRING v12 (functional coupling)**
- Endpoint: `https://string-db.org/api/json/network`
- Species: `9606` (Homo sapiens)
- Used for: pairwise functional coupling and node network-convergence metrics.

3. **CELLxGENE TI epithelial Crohn/normal scRNA**
- URL: `https://datasets.cellxgene.cziscience.com/b7c3c27c-97c2-4983-97df-1d537d138a43.h5ad`
- Local cache: `output/data/ti_epithelial_crohns_normal.h5ad`

4. **CELLxGENE TI immune Crohn/normal scRNA**
- URL: `https://datasets.cellxgene.cziscience.com/6cfb8c33-9cfb-4e16-b868-18aff944e55a.h5ad`
- Local cache: `output/data/ti_immune_crohns_normal.h5ad`

5. **CELLxGENE TI stromal Crohn/normal scRNA**
- URL: `https://datasets.cellxgene.cziscience.com/1a640ddc-ea3c-4711-ba8e-07084cc40a88.h5ad`
- Local cache: `output/data/ti_stromal_crohns_normal.h5ad`

## Output provenance (what is data-derived vs curated)
### Real-data-derived (reproducible from public data + scripts)
- `output/tables/node_rank_table.csv`
- `output/tables/edge_evidence_scores.csv`
- `output/tables/phenotype_mapping_raw_metrics.csv`
- `output/tables/phenotype_mapping_scores.csv`
- `output/figures/fig2_node_leverage.(png|svg)`
- `output/figures/fig3_edge_evidence_heatmap.(png|svg)`
- `output/figures/fig4_phenotype_mapping.(png|svg)`

### Curated / conceptual (not fabricated measurements, but not direct dataset outputs)
- `output/tables/claims_evidence_table.csv` (manual claim evidence grading from cited literature)
- `output/tables/therapy_alignment_table.csv` (manual therapy-to-circuit mapping from trial literature)
- `output/figures/fig1_minimal_circuit.(png|svg)` (conceptual causal schematic)

## Local intermediate artifacts generated during execution
- `output/data/opentargets_crohns_associated_targets.csv`
- `output/data/string_pair_scores.csv`
- `output/data/crohn_normal_celltype_means.csv`
- `output/data/crohn_minus_normal_celltype_deltas.csv`
- `output/data/scRNA_dataset_manifest.csv`
- `output/data/missing_genes_in_scrna.json`

## Source-of-truth manuscript input
- Root-level draft PDF was used as text/citation source-of-truth for manuscript restructuring.
