# Eolisa Space - Wormhole Research Documentation
## Supplementary Data and Analysis Notes

---

## Data Products

### 1. EHT Observations (2017)

**Source**: Event Horizon Telescope Collaboration  
**Observing Date**: April 6-11, 2017  
**Frequency**: 230 GHz (1.3 mm)  
**Resolution**: ~20 μas  

**Key Measurements**:
- Ring diameter: 51.8 ± 2.3 μas (68% CI)
- Brightness temperature: >10^9 K
- Variability timescale: <1 hour
- Fractional ring width: 0.4-0.5

**Data Access**:
- Public release: https://eventhorizontelescope.org/data/sgra-2017
- FITS format images and visibility data
- Calibrated with HOPS and EHT-HOPS pipelines

**Limitations**:
- Limited uv-coverage (~4-8 hours per day)
- Reconstruction-dependent
- Temporal variability complicates static imaging
- Sensitivity: ~0.5 mJy (5σ)

---

### 2. GRAVITY Near-IR Flares

**Source**: GRAVITY Collaboration / ESO VLT  
**Instrument**: GRAVITY interferometer  
**Wavelength**: K-band (2.2 μm)  
**Resolution**: ~4 mas (astrometric: ~10 μas)  

**Observed Flare Properties**:
- Duration: 40-120 minutes
- Peak flux: ~5-20 mJy (above quiescent)
- Quasi-periodic modulation: P ~ 45-70 minutes
- Astrometric motion: orbital signatures detected

**Key Publications**:
- GRAVITY Collaboration (2018): ApJ 863, L10
- GRAVITY Collaboration (2020): A&A 643, A56
- GRAVITY Collaboration (2022): A&A 657, L12

**Data Characteristics**:
- Temporal resolution: ~30 seconds
- Astrometric precision: ~10 μas
- Large orbit-to-orbit variability
- Interpretation debated: hot spot vs turbulent eddies

---

### 3. GRMHD Simulation Library

**Purpose**: Test observational signatures against theoretical black hole models

**Parameter Space**:
- Black hole spin: a* ∈ [0.0, 0.998]
- Disk tilt: θ ∈ [0°, 80°]
- Viewing angle: i ∈ [10°, 90°]
- Electron temperature: thermal, power-law, hybrid
- Magnetic flux: SANE, MAD, super-MAD

**Total Configurations**: 24,000 (focused on extreme Kerr)

**Simulation Details**:
- Code: HARM3D / Athena++ / KORAL (equivalent)
- Ray-tracing: BHOSS / ipole / eht-imaging
- Resolution: ~10 cells per r_g
- Run time: ~1000 M per snapshot

**Comparison Metrics**:
- χ² goodness-of-fit
- Morphological features: asymmetry, fractal dimension
- Ring geometry: diameter, width, centroid
- Statistical significance: p-values and σ levels

---

## Methodology Notes

### Image Enhancement Pipeline

**Purpose**: Reveal fine morphological structure in EHT images

**Steps**:
1. **Adaptive Histogram Equalization**
   - Enhances local contrast
   - Preserves global structure
   - Kernel size: image_width / 8

2. **Multi-Scale Decomposition**
   - Gaussian pyramid: scales = [2, 4, 8, 16] pixels
   - Extract detail components at each scale
   - Weighted recombination

3. **Structure Enhancement**
   - Edge detection: Sobel filter
   - Ridge detection: Sato vesselness filter
   - Combine: enhanced = original + 0.5*edges + 0.3*ridges

**Adversarial Testing** (Section 3.6):
- Apply anti-wormhole priors:
  - Strong Gaussian smoothing (σ = 3 pixels)
  - Azimuthal averaging (70% weight)
  - Suppress multi-lobed asymmetries
- Test feature persistence
- Acceptance criterion: features remain >60% of original amplitude

**Validation**:
- Tested on validation data with known input
- Recovery accuracy: >95% for features above 3σ
- False positive rate: <5% on pure noise images

---

### Feature Extraction

#### 1. Tri-Lobed Asymmetry (m=3 Mode)

**Method**: Fourier decomposition in azimuthal direction

**Formula**:
```
A_m = |∑ I(θ) exp(-imθ)| / ∑ I(θ)
```

where:
- I(θ) = intensity at azimuthal angle θ
- m = 3 for tri-lobed mode
- Sum over ring region (40-60 μas)

**Interpretation**:
- A_m ~ 0.05-0.08: typical for black holes
- A_m ~ 0.12-0.15: enhanced asymmetry (wormhole signature)

**Uncertainty**: Bootstrap resampling (N=1000)

---

#### 2. Fractal Dimension

**Method**: Box-counting algorithm

**Procedure**:
1. Binarize image at Otsu threshold
2. Count occupied boxes at scales s = [2, 4, 8, 16, 32] pixels
3. Fit log(N) vs log(1/s)
4. D_f = -slope

**Interpretation**:
- D_f ~ 1.3-1.5: simple ring structure (black holes)
- D_f ~ 1.7-1.9: complex, irregular structure (wormholes)

**Reference Values**:
- Perfect circle: D_f = 1.0
- Koch snowflake: D_f = 1.26
- Brownian motion: D_f = 2.0

---

#### 3. Centroid Confinement

**Method**: Measure centroid variation across azimuthal sectors

**Procedure**:
1. Divide image into N=8 azimuthal sectors
2. Compute intensity-weighted centroid in each sector
3. Calculate standard deviation of centroid positions

**Interpretation**:
- High variation (>15 pixels): black hole with strong asymmetries
- Low variation (<10 pixels): confined, symmetric structure (wormhole)

**Physics**: Wormhole throat acts as gravitational anchor, reducing centroid motion

---

### Statistical Framework

#### Chi-Squared Test

**Formula**:
```
χ² = ∑ [(O_i - E_i)² / σ_i²]
```

where:
- O_i = observed feature value
- E_i = model expectation
- σ_i = combined uncertainty (observational + theoretical)

**Degrees of Freedom**: dof = N_features - N_parameters

**Rejection Criterion**: 
- 2σ (95% CL): χ² > χ²_0.95(dof)
- 5σ (99.9999% CL): χ² >> χ²_0.999999(dof)

---

#### Bayesian Model Comparison

**Bayes Factor**:
```
B_WH/BH = P(D|WH) / P(D|BH)
```

where:
- P(D|M) = ∫ P(D|θ,M) P(θ|M) dθ (marginalized likelihood)
- D = observed data
- θ = model parameters

**Interpretation** (Kass & Raftery 1995):
- log₁₀(B) < 0.5: weak/no evidence
- 0.5 < log₁₀(B) < 1.0: moderate evidence
- log₁₀(B) > 1.0: strong evidence
- log₁₀(B) > 2.0: very strong evidence

**Our Result**: log₁₀(B_WH/BH) = 2.3 ± 0.5 → strong to very strong evidence

---

## Systematic Uncertainties

### Observational Systematics

1. **EHT Reconstruction**:
   - Different imaging algorithms (eht-imaging, SMILI, PRIMO)
   - Prior dependence: regularization, field-of-view
   - Scatter in ring diameter: ±10%
   - **Mitigation**: Test multiple reconstructions, report range

2. **GRAVITY Calibration**:
   - Atmospheric effects: seeing, coherence time
   - Instrumental: baseline errors, phase referencing
   - Variability: flare-to-flare differences (factor ~2)
   - **Mitigation**: Use only high-quality flares, bootstrap statistics

3. **Enhancement Pipeline**:
   - Parameter choices: smoothing scales, enhancement strength
   - Artifact risk: spurious features from processing
   - **Mitigation**: Adversarial testing, multiple parameter sets

---

### Theoretical Systematics

1. **GRMHD Models**:
   - Grid resolution: ~10 cells/r_g (limited)
   - Electron thermodynamics: uncertain prescriptions
   - Magnetic field topology: initial conditions
   - **Mitigation**: 24,000 configurations, wide parameter space

2. **Ray-Tracing**:
   - Emission model: synchrotron, Compton scattering
   - Absorption: self-absorption, Faraday rotation
   - **Mitigation**: Multiple codes, cross-validation

3. **Wormhole Models**:
   - Metric choice: Simpson-Visser (one family among many)
   - Rotation: extended to rotating case (phenomenological)
   - Stability: not addressed (beyond scope)
   - **Mitigation**: Report model-independent features, test alternatives

---

## Falsification Criteria

### How to Disprove This Hypothesis

**1. High-Resolution Imaging (ngEHT)**:
- **Prediction**: 4 distinct image tracks inside critical curve
- **Falsification**: Observe only 2 tracks (black hole signature)
- **Timeline**: 2027-2030

**2. Astrometric Precision (GRAVITY+)**:
- **Prediction**: Periastron precession 0.8-1.0°/orbit
- **Falsification**: Precession <0.5°/orbit (consistent with Schwarzschild)
- **Timeline**: 2026-2029

**3. Multi-Wavelength Tests**:
- **Prediction**: Faraday rotation anomaly Δθ ~ 8° (X-ray vs NIR)
- **Falsification**: No detectable rotation difference
- **Timeline**: 2025-2027 (IXPE + GRAVITY)

**4. Independent Pipelines**:
- **Prediction**: Features persist across reconstruction methods
- **Falsification**: Features vanish with alternative imaging algorithms
- **Timeline**: Immediate (community re-analysis)

**5. Stellar Orbit Tests**:
- **Prediction**: S-stars show deviations at apocenter (α < 5 r_G)
- **Falsification**: Perfect Keplerian orbits throughout
- **Timeline**: 2026-2030 (S0-2 + closer stars)

---

## Known Limitations

### Current Analysis

1. **Data Quality**:
   - Limited temporal coverage (~4 hours/day)
   - Reconstruction ambiguities
   - Low SNR in fine structure (<5σ)

2. **Test Size**:
   - Single source (Sgr A*)
   - Few GRAVITY flares with clear periodicity
   - No independent verification

3. **Model Space**:
   - Wormhole vs other exotic objects not fully distinguished
   - Boson stars, gravastars, fuzzballs under-explored
   - Rotating wormhole treatment phenomenological

---

### Interpretive Cautions

1. **5.1σ Tension**:
   - Astrophysical σ (model-dependent)
   - NOT particle-physics-grade discovery threshold
   - Subject to systematic uncertainties

2. **Enhancement Pipeline**:
   - Risk of artifacts despite adversarial testing
   - Independent validation needed

3. **Paradigm Shift**:
   - Extraordinary claim requires extraordinary evidence
   - Current evidence: suggestive, not definitive
   - Community skepticism expected and healthy

---

## Data Availability

All analysis code, validation data, and results are publicly available:

**Zenodo Repository**: https://doi.org/10.5281/zenodo.16511064

Contents:
- `/code/`: Python analysis scripts
- `/data/`: Test data and simulation outputs
- `/documentation/`: This file and method details
- `/results/`: Analysis outputs and figures

**GitHub Repository**: https://github.com/eolisa-space/sgra-wormhole-analysis

Contents:
- Full analysis pipeline
- Jupyter notebooks for interactive exploration
- Issue tracker for bug reports and discussions

---

## Citation

If you use this data or analysis code, please cite:

**Manuscript**:
```
Eolisa Space Research Division (2025). "Observational Signatures of 
Exotic Compact Objects in Sagittarius A*: A Comprehensive Wormhole 
Analysis." Submitted to ApJ. arXiv:10.5281/zenodo.18528732
```

**Data & Code**:
```
Eolisa Space Research Division (2025). "Sgr A* Wormhole Analysis: 
Data and Code Release." Zenodo. https://doi.org/10.5281/zenodo.16511064
```

---

## Contact

**Eolisa Space LLC**  
1209 Mountain Road Pl NE  
Albuquerque, New Mexico 87110, USA

**Email**: sentinelalpha@eolisaspace.com  
**Web**: https://www.eolisaspace.com  
**Phone**: +1 (438) 701-7206

**Lead Researcher**: Onur H. Evgin, President

---

## Acknowledgments

This research made use of:
- Event Horizon Telescope data (public release)
- GRAVITY observations (ESO Archive)
- NASA Astrophysics Data System
- NumPy, SciPy, Astropy communities
- arXiv preprint service

We thank the EHT and GRAVITY collaborations for making their data publicly available, enabling independent scientific analysis.

---

## Version History

- **v1.0** (2025-08): Initial public release with manuscript submission
- Data freeze date: 2025-07-31
- Analysis pipeline version: 1.0.0

---

*Last updated: 2025-08-15*  
*Document maintained by: Eolisa Space Research Division*
