# TaylorIntegration.jl

ODE integration using Taylor's method in [Julia](http://julialang.org).

Latest release:
[![version](https://juliahub.com/docs/General/TaylorIntegration/stable/version.svg)](https://juliahub.com/ui/Packages/General/TaylorIntegration)

PkgEval:
[![pkgeval](https://juliahub.com/docs/General/TaylorIntegration/stable/pkgeval.svg)](https://juliahub.com/ui/Packages/General/TaylorIntegration)

Build status:
[![Build status](https://github.com/PerezHz/TaylorIntegration.jl/workflows/CI/badge.svg)](https://github.com/PerezHz/TaylorIntegration.jl/actions)

Coverage:
[![Coverage Status](https://coveralls.io/repos/github/PerezHz/TaylorIntegration.jl/badge.svg?branch=main)](https://coveralls.io/github/PerezHz/TaylorIntegration.jl?branch=main) [![codecov](https://codecov.io/gh/PerezHz/TaylorIntegration.jl/branch/main/graph/badge.svg)](https://codecov.io/gh/PerezHz/TaylorIntegration.jl)

Documentation:
[![](https://img.shields.io/badge/docs-latest-blue.svg)](https://PerezHz.github.io/TaylorIntegration.jl/latest) [![](https://img.shields.io/badge/docs-stable-blue.svg)](https://PerezHz.github.io/TaylorIntegration.jl/stable)

DOI (Zenodo):
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.2562352.svg)](https://doi.org/10.5281/zenodo.2562352)

## Authors

- [Jorge A. Pérez](https://github.com/PerezHz),
Instituto de Ciencias Físicas, Universidad Nacional Autónoma de México (UNAM)
- [Luis Benet](http://www.cicc.unam.mx/~benet/),
Instituto de Ciencias Físicas, Universidad Nacional Autónoma de México (UNAM)

Comments, suggestions, contributions and improvements are welcome and appreciated.

## Examples

+ [x'=x^2](http://nbviewer.jupyter.org/github/PerezHz/TaylorIntegration.jl/blob/main/examples/x-dot-equals-x-squared.ipynb)
+ [Kepler problem](http://nbviewer.jupyter.org/github/PerezHz/TaylorIntegration.jl/blob/main/examples/Kepler-problem.ipynb)
+ [High-order polynomial approximations to special functions and integral transforms](http://nbviewer.jupyter.org/github/PerezHz/TaylorIntegration.jl/blob/main/examples/Polynomial-approx-special-functions-integral-transforms.ipynb)
+ [Damped, driven linear oscillator](http://nbviewer.jupyter.org/github/PerezHz/TaylorIntegration.jl/blob/main/examples/Damped-driven-linear-oscillator.ipynb)
+ [The Lyapunov spectrum of the Lorenz system](http://nbviewer.jupyter.org/github/PerezHz/TaylorIntegration.jl/blob/main/examples/Lorenz-Lyapunov-spectrum.ipynb)
+ TaylorIntegration @ JuliaCon 2017 [(slides)](http://nbviewer.jupyter.org/format/slides/github/PerezHz/TaylorIntegration.jl/blob/main/examples/JuliaCon2017/TaylorIntegration_JuliaCon.ipynb)

## License

`TaylorIntegration` is licensed under the [MIT "Expat" license](./LICENSE.md).

## Acknowledgments

We acknowledge financial support from DGAPA-PAPIIT grants IG-100616, IG-100819 and IG-101122.
