# Replication Materials: Autocrats and Their Business Allies

**Author:** Semuhi Sinanoğlu
**Date:** April 2025

## Overview

This repository contains the replication code and data for "Autocrats and Their Business Allies: The Informal Politics of Defection and Co-optation." Why do business allies (not) defect from authoritarian regimes? An emerging scholarship shows that connected businesses face high political risk, and the autocrat can financially pressure business allies during economic crises. And yet, despite their disruptive power, the business elite rarely switch to opposition. I argue that this unexpected loyalty does not always stem from credible power-sharing. The more material quid pro quo the business elite engage in with the dictator, the less they can credibly threaten the dictator with defection. I present a bargaining game between the dictatorship and its business allies and test it using a country-year-level dataset of 76 countries for 1992–2019. The results indicate that higher degrees of patrimonial co-optation lower the risk of business opposition. This effect is partly mediated through the government’s control over the media landscape. These findings suggest that even informal, non-institutional tools of co-optation can effectively deter defection.

## Software Requirements

- **R** (version used by the author recorded in `session_info.txt`)
- All required packages are installed automatically via `pacman::p_load()` in `0-master.R`:
  - `tidyverse`, `kableExtra`, `readxl`, `panelView`, `brms`, `stargazer`, `DataExplorer`, `ggeffects`, `ggstatsplot`, `brglm2`, `sjPlot`, `patchwork`, `vtable`, `ggdist`, `glmmTMB`, `texreg`, `brglm`, `plm`
- See `session_info.txt` for exact package versions used.

## Data

| File | Description | Source |
|------|-------------|--------|
| `data/vdem.sub.RData` | Pre-processed analytical subset | Derived from V-Dem v13 (see below) |
| `data/crisis2.xlsx` | Economic crisis indicators | See paper for details |
| `data/private.xlsx` | Gross fixed capital formation, private sector (% of GDP) | See paper for details |

**V-Dem data:** The full V-Dem Country-Year dataset (v13) is required only if you want to re-run the data construction step (`2-data.R`). It is not included here due to its size (~31 MB). Download it from [https://v-dem.net/data/](https://v-dem.net/data/) and place the file `V-Dem-CY-Full+Others-v13.rds` in the `data/` folder. If you use the included `vdem.sub.RData`, you can skip this step.

## How to Replicate

### Full replication (from raw data)

1. Download V-Dem v13 and place it in `data/` as described above.
2. Open R and set your working directory to this folder.
3. Run `source("0-master.R")` — this executes all scripts in sequence.

**Note:** The Bayesian mediation models in `3-analysis.R` (using `brms`) may take considerable time to run depending on your hardware. Results are stochastic; `set.seed(124)` is set in the master script for reproducibility.

## File Descriptions

| Script | Purpose | Outputs |
|--------|---------|---------|
| `0-master.R` | Master script — runs all code in sequence | — |
| `1-utils.R` | Helper functions (GLM-FE, GLMM, linear FE wrappers) | — |
| `2-data.R` | Data loading, cleaning, merging, and variable construction | `data/vdem.sub.RData` |
| `3-analysis.R` | Main models, coefficient plots, AME plots, mediation analysis | Table C1, Figures 2–4 |
| `4-robustness.R` | Robustness checks (alternative specifications, GLMM, linear FE, interactions) | Tables C2–C15, Figure B7 |
| `5-descriptives.R` | Descriptive statistics, panel plots, country-level summaries | Tables B1–B3, Figures B1–B6 |

## Output Mapping

### Main paper figures
- **Figure 2** (Coefficient plot): `output/Figure 2-coef.plot.png` ← `3-analysis.R`
- **Figure 3** (Average marginal effects): `output/Figure 3-ame.jpeg` ← `3-analysis.R`
- **Figure 4** (Mediation analysis): `output/Figure 4 - mediation.jpeg` ← `3-analysis.R`

### Appendix tables
- **Table B2** (Descriptive statistics): `output/Table B2 - Descriptives.tex` ← `5-descriptives.R`
- **Table B3** (Private sector): `output/Table B3.tex` ← `5-descriptives.R`
- **Table C1** (Main models): `output/TableC1-main-models.html` ← `3-analysis.R`
- **Tables C2–C15** (Robustness): `output/TableC2-*.html` through `output/TableC15-*.html` ← `4-robustness.R`

### Appendix figures
- **Figures B1–B6** (Descriptive panels): `output/Figure B1-*.jpeg` through `output/Figure B6-*.jpeg` ← `5-descriptives.R`
- **Figure B7** (Predictive check): `output/Figure B7 - predictive check.jpeg` ← `4-robustness.R`

## License

This project is licensed under the MIT License. See `LICENSE` for details.
