### Autocrats and their business allies ###
### April 2025                          ###
### Semuhi Sinanoglu                    ###
### Descriptives                        ###


### Table B1: List of countries ------------------------------------------------
vdem.sub %>% select(country_name) %>% unique() %>% 
  rownames_to_column(var = "Row")%>% dplyr::select(!Row) %>% kbl()

### Table B2: Descriptive Stats ------------------------------------------------
desc <- vdem.sub |>
  select(business.op, business, v2exbribe, v2x_neopat,
         v2cacamps, v2x_polyarchy, v2x_jucon, v2regsupgroupssize,
         v2regoppgroupssize, v2cltort, v2clkill, v2clstown, v2cademmob,
         v2caautmob, c_debt, v2regdur2) |> rename_with(~ gsub("_", "", .x)) |>
  mutate(business.op = factor(business.op)) |>
  mutate(business = factor(business)) |>
  mutate(cdebt = factor(cdebt))

vtable::sumtable(desc, digits = 2, factor.percent = T, 
                 factor.numeric = T,
                 title = "", 
                 out = "latex",
                 labels = c("Business opposition",
                            "Business support",
                            "Executive bribery",
                            "Neopatrimonialism",
                            "Polarization",
                            "Polyarchy",
                            "Judicial constraints",
                            "Support group size",
                            "Opposition group size",
                            "Freedom from torture",
                            "Freedom from killing",
                            "State ownership",
                            "Pro-democracy mobilization",
                            "Pro-autocracy mobilization",
                            "Debt crisis",
                            "Regime duration"),
                 file = "output/Table B2 - Descriptives")

### Figure B1: Business elite in opposition ------------------------------------

vdem.sub |> select(country_name, year, business.op) |>
  group_by(year) |>
  mutate(avg = sum(business.op, na.rm=T)) |>
  select(year, avg) |> 
  ggplot(aes(x = year, y = avg)) +
  geom_line() + theme_bw() + 
  ylim(0, 20) +
  scale_x_continuous(breaks = seq(1992, 2019, by = 3)) +
  labs(x = "", y = "The # countries with business in opposition")
ggsave(filename = "output/Figure B1-business opposition.jpeg", dpi = 300,
       height = 5, width = 5)

### Figure B2: Business elite in opposition by countries ----------------------

vdem.sub2 <- vdem.sub |> filter(v2x_regime == 1)

panelView::panelview(1 ~ business.op, data = vdem.sub2, index = c("country_name", "year"),
                     by.timing = T, cex.axis= 8) +
  labs(title = "", x = "", y = "") + theme_bw() +
  theme(axis.text.x = element_text(angle = 90, hjust = 1),
        legend.position = "none") 
ggsave(filename = "output/Figure B2 - business opposition by countries.jpeg", dpi = 300,
       height = 10, width = 10)

### Figure B3: Business elite support ------------------------------------------

vdem.sub |> select(country_name, year, business) |>
  group_by(year) |>
  mutate(avg = sum(business, na.rm=T)) |>
  select(year, avg) |> 
  ggplot(aes(x = year, y = avg)) +
  geom_line() + theme_bw() + 
  ylim(0, 50) +
  scale_x_continuous(breaks = seq(1992, 2019, by = 3)) +
  labs(x = "", y = "The # countries with business as support group")
ggsave(filename = "output/Figure B3 - business support.jpeg", dpi = 300,
       height = 5, width = 5)

### Figure B4: Business elite support by country-------------------------------

panelView::panelview(1 ~ business, data = vdem.sub2, index = c("country_name", "year"),
                     by.timing = T, cex.axis= 8) +
  labs(title = "", x = "", y = "") + theme_bw() +
  theme(axis.text.x = element_text(angle = 90, hjust = 1),
        legend.position = "none") 
ggsave(filename = "output/Figure B4 - Business support by country.jpeg", dpi = 300,
       height = 10, width = 10)

### Figure B5: Periods of crises -----------------------------------------------
panelView::panelview(1 ~ c_debt, data = vdem.sub, index = c("country_name", "year"),
                     by.timing = T, cex.axis= 8) +
  labs(title = "", x = "", y = "") + theme_bw() +
  theme(axis.text.x = element_text(angle = 90, hjust = 1),
        legend.position = "none") 
ggsave(filename = "output/Figure B5 - Periods of crisis.jpeg", dpi = 300,
       height = 10, width = 10)

### Figure B6: Distribution of bribery measure ---------------------------------
vdem.sub |>
  filter(year==2019) |>
  select(country_name, v2exbribe, v2exbribe_sd) |> 
  arrange(v2exbribe, "increasing") |> 
  mutate(low = v2exbribe - 1.96*v2exbribe_sd) |>
  mutate(high = v2exbribe + 1.96*v2exbribe_sd) |>
  ggplot(aes(x = v2exbribe, y = reorder(country_name, v2exbribe))) +
  geom_point() +
  geom_errorbar(aes(xmin = low, xmax = high)) + theme_bw() +
  labs(y = "", x = "Executive bribery and corruption")
ggsave(filename = "output/Figure B6 - bribery.jpeg", dpi = 300, width = 10, height = 10)




private <- readxl::read_excel("data/private.xlsx")
private <- private |>
  mutate(country_name = ifelse(country_name == "Congo, Dem. Rep.", "Democratic Republic of the Congo", country_name)) |>
  mutate(country_name = ifelse(country_name == "Egypt, Arab Rep.", "Egypt", country_name)) |>
  mutate(country_name = ifelse(country_name == "Cote d'Ivoire", "Ivory Coast", country_name)) |>
  mutate(country_name = ifelse(country_name == "Gambia, The", "The Gambia", country_name)) 
  
vdem.pr <- vdem.sub |> select(country_name) |> distinct()
vdem.pr <- left_join(vdem.pr, private, by = "country_name")

latex_code <- vdem.pr %>%
  drop_na() %>%
  arrange(desc(private)) |>
  kbl(
    format = "latex",
    digits = 2,
    caption = "",
    col.names = c("Country", "Private Sector"),
    booktabs = T
  )
writeLines(latex_code, "output/Table B3.tex")

vdem.sub |>
  filter(v2regpower == 3) |>
  select(country_name) |> distinct()

