### Autocrats and their business allies ###
### April 2025                          ###
### Semuhi Sinanoglu                    ###
### Robustness Check                    ###

## GLM FE Models for business opp. --------------------------------------------- 

## **Executive bribery as co-optation measure ####

form0 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "",
                       "factor(country_name)", sep="+"))

form1 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                       "factor(country_name)", sep="+"))

form2 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                       "factor(country_name)", sep="+"))

form3 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                       "factor(country_name)", sep="+"))

form4 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                       "factor(country_name)", sep="+"))

form5 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                       "factor(country_name)", sep="+"))

form6 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                       "factor(country_name)", sep="+"))

form7 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                       "factor(country_name)", sep="+"))

form8 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                       "factor(country_name)", sep="+"))

form9 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                       "factor(country_name)", sep="+"))

form10 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                        "factor(country_name)", sep="+"))

form11 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                        "factor(country_name)", sep="+"))

form12 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                        "factor(country_name)", sep="+"))

form13 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form14 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form15 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form16 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form17 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form18 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form19 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form20 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form21 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                        "factor(country_name)", sep="+"))

form22 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                        "factor(country_name)", sep="+"))

form23 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                        "factor(country_name)", sep="+"))

form24 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                        "factor(country_name)", sep="+"))


f.list <- cbind(paste0(rep("form", 24),seq(0,24,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results <- list()
results <- lapply(f.list2, f.brglm)
aic_values <- sapply(results, AIC)
order_index <- order(aic_values)
sorted_models <- results[order_index]
final.list <- sorted_models[1:15]

## **Table C2 - Business Opposition GLM FE w executive bribery ####
texreg::texreg(final.list, 
               file = "output/TableC2-business-opp.html", 
               omit.coef = "(factor)|(lag)", 
               custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis",
                                     "Freedom from killing",
                                     "Support group size", 
                                     "Pro-autocracy mobilization",
                                     "Opposition Autonomy",
                                     "Regime duration",
                                     "State ownership",
                                     "Judicial constraints",
                                     "Polyarchy",
                                     "Polarization",
                                     "Opposition group size",
                                     "Legislative constraints",
                                     "Freedom from torture",
                                     "Pro-democracy mobilization"),
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                                      "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               digits = 2
)


## **Neopatrimonialism as co-optation measure ####

form25 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "",
                        "factor(country_name)", sep="+"))

form26 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form27 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form28 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form29 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form30 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form31 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form32 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form33 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form34 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy",
                        "factor(country_name)", sep="+"))

form35 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy",
                        "factor(country_name)", sep="+"))

form36 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown  + v2cacamps",
                        "factor(country_name)", sep="+"))

form37 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form38 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form39 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form40 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form41 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form42 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form43 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form44 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy + v2cacamps",
                        "factor(country_name)", sep="+"))

form45 <- formula(paste("business.op ~ lag(business.op,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy + v2cacamps",
                        "factor(country_name)", sep="+"))

f.list <- cbind(paste0(rep("form", 21),seq(25,45,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results2 <- list()
results2 <- lapply(f.list2, f.brglm)

aic_values <- sapply(results2, AIC)
order_index <- order(aic_values)
sorted_models <- results2[order_index]
final.list <- sorted_models[1:15]

## **Table C3 - Business Opposition GLM FE w neopatrimonial ####
texreg::texreg(final.list, 
               file = "output/TableC3-business-opp.html", 
               omit.coef = "(factor)|(lag)", 
               custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis",
                                     "Freedom from killing",
                                     "Support group size",
                                     "Pro-autocracy mobilization",
                                     "Opposition Autonomy",
                                     "Regime duration",
                                     "State ownership",
                                     "Freedom from torture",
                                     "Pro-democracy mobilization",
                                     "Polyarchy",
                                     "Polarization",
                                     "Opposition group size"),
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                                      "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               digits = 2
)

## GLM FE Models for business sup. --------------------------------------------- 

## **Executive bribery as co-optation measure ####
form50 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "",
                        "factor(country_name)", sep="+"))

form51 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form52 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form53 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form54 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form55 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form56 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form57 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form58 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form59 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                        "factor(country_name)", sep="+"))

form60 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                        "factor(country_name)", sep="+"))

form61 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                        "factor(country_name)", sep="+"))

form62 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                        "factor(country_name)", sep="+"))

form63 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form64 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form65 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form66 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form67 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form68 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form69 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form70 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form71 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                        "factor(country_name)", sep="+"))

form72 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                        "factor(country_name)", sep="+"))

form73 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                        "factor(country_name)", sep="+"))

form74 <- formula(paste("business ~ lag(business,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                        "factor(country_name)", sep="+"))

f.list <- cbind(paste0(rep("form", 25),seq(50,74,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results3 <- list()
results3 <- lapply(f.list2, f.brglm)

aic_values <- sapply(results3, AIC)
order_index <- order(aic_values)
sorted_models <- results3[order_index]
sorted_models <- sorted_models[1:15]

## **Table C4 - Business Support GLM FE w executive bribery ####

texreg::texreg(sorted_models,
               file = "output/TableC4-business-sup.html", 
               omit.coef = "(factor)|(lag)", 
               custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis", "Freedom from killing",
                     "Support group size",
                     "Pro-autocracy mobilization",  "Opposition autonomy", "Regime duration", 
                     "State ownership of economy",  "Judicial constraints",
                     "Polyarchy", "Legislative constraints", "Polarization",
                     "Freedom from torture",
                     "Opposition group size", "Pro-democracy mobilization"
                      ),
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                                      "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               digits = 2)

## **Neo-patrimonialism as co-optation measure ####
form80 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "",
                        "factor(country_name)", sep="+"))

form81 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form82 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form83 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form84 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form85 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form86 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form87 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form88 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown",
                        "factor(country_name)", sep="+"))

form89 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy",
                        "factor(country_name)", sep="+"))

form90 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy",
                        "factor(country_name)", sep="+"))

form91 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown  + v2cacamps",
                        "factor(country_name)", sep="+"))

form92 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form93 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form94 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form95 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form96 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form97 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form98 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps",
                        "factor(country_name)", sep="+"))

form99 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy + v2cacamps",
                        "factor(country_name)", sep="+"))

form100 <- formula(paste("business ~ lag(business,1) + v2x_neopat + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy + v2cacamps",
                         "factor(country_name)", sep="+"))

f.list <- cbind(paste0(rep("form", 21),seq(80,100,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results4 <- list()
results4 <- lapply(f.list2, f.brglm)

aic_values <- sapply(results4, AIC)
order_index <- order(aic_values)
sorted_models <- results4[order_index]
sorted_models <- sorted_models[1:15]

## **Table C5 - Business Support GLM FE w neo-patrimonial ####

texreg::texreg(sorted_models,
               file = "output/TableC5-business-sup.html", 
               omit.coef = "(factor)|(lag)", 
               custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis", "Freedom from killing",
                                     "Support group size",
                                     "Pro-autocracy mobilization",  "Opposition autonomy", "Regime duration",
                                     "State ownership of economy", "Polyarchy",  
                                     "Polarization", "Freedom from torture",
                                     "Opposition group size", 
                                     "Pro-democracy mobilization"
               ),
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                                      "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               digits = 2)

## GLMM Models for business opp. -----------------------------------------------

## **Executive bribery as co-optation measure ####

form101 <- formula(paste("business.op ~ v2exbribe + c_debt", 
                         "(1 | country_name + year2) + year2", sep="+"))

form102 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form103 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form104 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form105 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form106 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form107 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form108 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form109 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form110 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                         "(1 | country_name + year2) + year2", sep="+"))

form111 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                         "(1 | country_name + year2) + year2", sep="+"))

form112 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                         "(1 | country_name + year2) + year2", sep="+"))

form113 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                         "(1 | country_name + year2) + year2", sep="+"))

form114 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form115 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form116 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form117 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form118 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form119 <- formula(paste("business.op ~  v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form120 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form121 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form122 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form123 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form124 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form125 <- formula(paste("business.op ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

f.list <- cbind(paste0(rep("form", 25),seq(101,125,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results5 <- list()
results5 <- lapply(f.list2, f.glmm)

aic_values <- sapply(results5, AIC)
order_index <- order(aic_values)
sorted_models <- results5[order_index]
sorted_models <- sorted_models[1:15]

## **Table C6: GLMM for business opposition with executive bribe ####
texreg(sorted_models, omit.coef = "^year",
       file = "output/TableC6-GLMM-business-opp.html", 
       custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis",
                             "Freedom from torture",
                             "Opposition group size",
                             "Pro-democracy mobilization",
                             "Opposition Autonomy",
                             "Regime duration",
                             "State ownership",
                             "Judicial constraints",
                             "Polyarchy",
                             "Polarization",
                             "Legislative constraints",
                             "Freedom from killing",
                             "Support group size",
                             "Pro-autocracy mobilization"
       ),
       custom.gof.names = c("AIC", "Log Likelihood", "Num. obs.",
                            "Num. groups: Country", "Num. groups: Year",
                            "Country (Intercept)", "Year (Intercept)"),
       custom.gof.rows = list("Year FE" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
       digits = 2)

## GLMM Models for business sup. -----------------------------------------------

## **Executive bribery as co-optation measure ####
form126 <- formula(paste("business ~ v2exbribe + c_debt", 
                         "(1 | country_name + year2) + year2", sep="+"))

form127 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form128 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form129 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form130 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form131 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form132 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form133 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2xlg_legcon",
                         "(1 | country_name + year2) + year2", sep="+"))

form134 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2xlg_legcon",
                         "(1 | country_name + year2) + year2", sep="+"))

form135 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy + v2x_jucon + v2xlg_legcon",
                         "(1 | country_name + year2) + year2", sep="+"))

form136 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy + v2x_jucon + v2xlg_legcon",
                         "(1 | country_name + year2) + year2", sep="+"))

form137 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form138 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form139 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form140 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form141 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form142 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps + v2x_jucon + v2xlg_legcon",
                         "(1 | country_name + year2) + year2", sep="+"))

form143 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps + v2x_jucon + v2xlg_legcon",
                         "(1 | country_name + year2) + year2", sep="+"))

form144 <- formula(paste("business ~  v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps + v2x_jucon + v2xlg_legcon",
                         "(1 | country_name + year2) + year2", sep="+"))

form145 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown+ v2cacamps + v2x_jucon + v2xlg_legcon",
                         "(1 | country_name + year2) + year2", sep="+"))

form146 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2cacamps + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

form147 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form148 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy + v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form149 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy +
                         v2cacamps",
                         "(1 | country_name + year2) + year2", sep="+"))

form150 <- formula(paste("business ~ v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_polyarchy +
                         v2cacamps + v2x_jucon",
                         "(1 | country_name + year2) + year2", sep="+"))

f.list <- cbind(paste0(rep("form", 25),seq(126,150,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results6 <- list()
results6 <- lapply(f.list2, f.glmm)

aic_values <- sapply(results6, AIC)
order_index <- order(aic_values)
sorted_models <- results6[order_index]
sorted_models <- sorted_models[1:15]
sorted_models <- sorted_models[-8] ## repetitive model specification

## **Table C7: GLMM for business support with executive bribe ####

texreg(sorted_models, omit.coef = "^year",
       file = "output/TableC7-GLMM-business-sup.html", 
       custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis",
                             "Freedom from killing",
                             "Opposition group size",
                             "Pro-autocracy mobilization",
                             "Opposition Autonomy",
                             "Regime duration",
                             "State ownership",
                             "Polarization",
                             "Judicial constraints",
                             "Legislative constraints",
                             "Freedom from torture",
                             "Support group size",
                             "Pro-democracy mobilization",
                             "Polyarchy"
       ),
       custom.gof.names = c("AIC", "Log Likelihood", "Num. obs.",
                            "Num. groups: Country", "Num. groups: Year",
                            "Country (Intercept)", "Year (Intercept)"),
       custom.gof.rows = list("Year FE" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
       digits = 2)


## Conservative threshold for opposition/support -------------------------------

## **Business opposition ####
form201 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "",
                         "factor(country_name)", sep="+"))

form202 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form203 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form204 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form205 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form206 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form207 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form208 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form209 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form210 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                         "factor(country_name)", sep="+"))

form211 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                         "factor(country_name)", sep="+"))

form212 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                         "factor(country_name)", sep="+"))

form213 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                         "factor(country_name)", sep="+"))

form214 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form215 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form216 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form217 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form218 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form219 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form220 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form221 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form222 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                         "factor(country_name)", sep="+"))

form223 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                         "factor(country_name)", sep="+"))

form224 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                         "factor(country_name)", sep="+"))

form225 <- formula(paste("business.op2 ~ lag(business.op2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                         "factor(country_name)", sep="+"))

f.list <- cbind(paste0(rep("form", 25),seq(201,225,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results9 <- list()
results9 <- lapply(f.list2, f.brglm)

aic_values <- sapply(results9, AIC)
order_index <- order(aic_values)
sorted_models <- results9[order_index]
sorted_models <- sorted_models[1:15]

## **Table C10: GLM PL-FE models of conservative measure of business opp. #### 
texreg::texreg(sorted_models,
               file = "output/TableC10-business-opp-conservative.html", 
               omit.coef = "(factor)|(lag)", 
               custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis", "Freedom from torture",
                                     "Opposition group size", "Pro-autocracy mobilization",
                                     "Opposition autonomy", "Regime duration",
                                     "State ownership of economy", "Judicial constraints",
                                     "Support group size", 
                                      
                                     "Pro-democracy mobilization",
                                     "Polyarchy",
                                     "Freedom from killing",
                                     "Polarization",
                                     "Legislative constraints"
               ),
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                                      "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               digits = 3)

## **Business support ####
form226 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "",
                         "factor(country_name)", sep="+"))

form227 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form228 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form229 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form230 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form231 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form232 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form233 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form234 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form235 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                         "factor(country_name)", sep="+"))

form236 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                         "factor(country_name)", sep="+"))

form237 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                         "factor(country_name)", sep="+"))

form238 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                         "factor(country_name)", sep="+"))

form239 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form240 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form241 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form242 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form243 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form244 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form245 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form246 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form247 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                         "factor(country_name)", sep="+"))

form248 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                         "factor(country_name)", sep="+"))

form249 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                         "factor(country_name)", sep="+"))

form250 <- formula(paste("business2 ~ lag(business2,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                         "factor(country_name)", sep="+"))

f.list <- cbind(paste0(rep("form", 25),seq(226,250,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results10 <- list()
results10 <- lapply(f.list2, f.brglm)

aic_values <- sapply(results10, AIC)
order_index <- order(aic_values)
sorted_models <- results10[order_index]
sorted_models <- sorted_models[1:15]

## **Table C11: GLM PL-FE models of conservative measure of business sup. #### 
texreg::texreg(sorted_models,
               file = "output/TableC11-business-sup-conservative.html", 
               omit.coef = "(factor)|(lag)", 
               custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis",   "Freedom from killing",
                                     "Opposition group size", "Pro-autocracy mobilization",
                                     "Opposition autonomy",    "Regime duration",
                                     "State ownership of economy", "Judicial constraints",
                                     "Freedom from torture", "Polarization",
                                     "Support group size", "Polyarchy",
                                    "Legislative constraints",
                                      "Pro-democracy mobilization"
               ),
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                                      "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               digits = 3)

## Table C12: Main models without lagged DV ------------------------------------
full11 <- brglm::brglm(business.op ~ v2exbribe + c_debt +
                        v2cltort + v2clstown + v2cademmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regoppgroupssize + v2regdur2 
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit", pl = T)

full12 <- brglm::brglm(business.op ~ v2exbribe + c_debt +
                        v2cltort + v2clstown + v2cademmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regoppgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit", pl = T)

full13 <- brglm::brglm(business.op ~ v2exbribe + c_debt +
                        v2clkill + v2clstown + v2caautmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regsupgroupssize + v2regdur2 
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit", pl = T)

full14 <- brglm::brglm(business.op ~ v2exbribe + c_debt +
                        v2clkill + v2clstown + v2caautmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regsupgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit", pl = T)

full15 <- brglm::brglm(business ~ v2exbribe + c_debt +
                        v2cltort + v2clstown + v2cademmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regoppgroupssize + v2regdur2 
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit")

full16 <- brglm::brglm(business ~ v2exbribe + c_debt +
                        v2cltort + v2clstown + v2cademmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regoppgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit")

full17 <- brglm::brglm(business ~ v2exbribe + c_debt +
                        v2clkill + v2clstown + v2caautmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regsupgroupssize + v2regdur2 
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit")

full18 <- brglm::brglm(business ~ v2exbribe + c_debt +
                        v2clkill + v2clstown + v2caautmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regsupgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit")

full.list <- list(full11, full12, full13, full14, full15, full16, full17, full18)

texreg::texreg(full.list, omit.coef = "(factor)", 
               custom.header = list("Opposition" = 1:4,
                                    "Support" = 5:8),
               custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis",
                                     "Freedom from torture",
                                     "State ownership",
                                     "Pro-democracy mobilization",
                                     "Polarization",
                                     "Judicial constraints",
                                     "Opposition Autonomy",
                                     "Opposition group size",
                                     "Regime duration",
                                     "Legislative constraints",
                                     "Polyarchy",
                                     "Freedom from killing",
                                     "Pro-autocracy mobilization",
                                     "Support group size"),
               file = "output/TableC12-without-lag.html", 
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               digits = 2
)


### Interaction w Explanatory Variables ----------------------------------------

## **Business opposition ####

form251 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "",
                        "factor(country_name)", sep="+"))

form252 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form253 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form254 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form255 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form256 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form257 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form258 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form259 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                        "factor(country_name)", sep="+"))

form260 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                        "factor(country_name)", sep="+"))

form261 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                        "factor(country_name)", sep="+"))

form262 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                        "factor(country_name)", sep="+"))

form263 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                        "factor(country_name)", sep="+"))

form264 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form265 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form266 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form267 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form268 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form269 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form270 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form271 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                        "factor(country_name)", sep="+"))

form272 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                        "factor(country_name)", sep="+"))

form273 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                        "factor(country_name)", sep="+"))

form274 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                        "factor(country_name)", sep="+"))

form275 <- formula(paste("business.op ~ lag(business.op,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                        "factor(country_name)", sep="+"))

f.list <- cbind(paste0(rep("form", 25),seq(251,275,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results11 <- list()
results11 <- lapply(f.list2, f.brglm)

aic_values <- sapply(results11, AIC)
order_index <- order(aic_values)
sorted_models <- results11[order_index]
sorted_models <- sorted_models[1:15]

### **Table C13: Business opposition with interaction variable ####

texreg::texreg(sorted_models,
               file = "output/TableC13-business-opp-interaction.html", 
               omit.coef = "(factor)|(lag)", 
               custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis", 
                                     "Freedom from killing",   "Support group size", 
                                     "Pro-autocracy mobilization", "Opposition autonomy",
                                     "Regime duration",  "State ownership of economy",
                                     "Judicial constraints", 
                                     "Co-optation*crisis", 
                                     "Polyarchy",   "Polarization", "Opposition group size",
                                     "Legislative constraints",
                                     "Freedom from torture", 
                                     "Pro-democracy mobilization"
               ),
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                                      "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               digits = 3)


## **Business support ####

form276 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "",
                         "factor(country_name)", sep="+"))

form277 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form278 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form279 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form280 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form281 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form282 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form283 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form284 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form285 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                         "factor(country_name)", sep="+"))

form286 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy",
                         "factor(country_name)", sep="+"))

form287 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                         "factor(country_name)", sep="+"))

form288 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon",
                         "factor(country_name)", sep="+"))

form289 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form290 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form291 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form292 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form293 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form294 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form295 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form296 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form297 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                         "factor(country_name)", sep="+"))

form298 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps",
                         "factor(country_name)", sep="+"))

form299 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                         "factor(country_name)", sep="+"))

form300 <- formula(paste("business ~ lag(business,1) + v2exbribe*c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps",
                         "factor(country_name)", sep="+"))

f.list <- cbind(paste0(rep("form", 25),seq(276,300,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results12 <- list()
results12 <- lapply(f.list2, f.brglm)

aic_values <- sapply(results12, AIC)
order_index <- order(aic_values)
sorted_models <- results12[order_index]
sorted_models <- sorted_models[1:15]

### **Table C14: Business support with interaction variable ####

texreg::texreg(sorted_models,
               file = "output/TableC14-business-sup-interaction.html", 
               omit.coef = "(factor)|(lag)", 
               custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis", "Freedom from killing",
                                     "Support group size", "Pro-autocracy mobilization",
                                     "Opposition autonomy", "Regime duration", 
                                     "State ownership of economy", "Judicial constraints",  
                                     "Polyarchy", "Legislative constraints",
                                     "Polarization",
                                     "Co-optation*crisis",
                                     "Freedom from torture", "Opposition group size",   
                                     "Pro-democracy mobilization"
               ),
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                                      "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               digits = 3)


### Posterior Checks for Mediation Analysis ------------------------------------
bayes1 <- pp_check(y_mod, type = "dens_overlay", ndraws = 200) + theme_bw() + labs(subtitle = "Outcome")
bayes2 <- pp_check(m_mod, type = "dens_overlay", ndraws = 200) + theme_bw() + labs(subtitle = "Mediator")

bayes1 + bayes2 + patchwork::plot_layout(guides = "collect")
ggsave(filename = "output/Figure C1 - predictive check.jpeg", dpi = 600)

### Institutional Co-optation --------------------------------------------------

### **VDEM Access to Jobs ####
full21 <- brglm::brglm(business.op ~ lag(business.op,1) + v2exbribe + c_debt + v2peasjpol + 
                         v2cltort + v2clstown + v2cademmob +
                         v2cacamps + v2x_jucon + v2psoppaut +
                         v2regoppgroupssize + v2regdur2 
                       +factor(country_name),
                       family = binomial, data = vdem.sub, na.action = na.omit,
                       method = "brglm.fit", pl = T)

full22 <- brglm::brglm(business.op ~ lag(business.op,1) + v2exbribe + c_debt + v2peasjpol + 
                         v2cltort + v2clstown + v2cademmob +
                         v2cacamps + v2x_jucon + v2psoppaut +
                         v2regoppgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                       +factor(country_name),
                       family = binomial, data = vdem.sub, na.action = na.omit,
                       method = "brglm.fit", pl = T)

full23 <- brglm::brglm(business.op ~ lag(business.op,1) + v2exbribe + c_debt + v2peasjpol + 
                         v2clkill + v2clstown + v2caautmob +
                         v2cacamps + v2x_jucon + v2psoppaut +
                         v2regsupgroupssize + v2regdur2 
                       +factor(country_name),
                       family = binomial, data = vdem.sub, na.action = na.omit,
                       method = "brglm.fit", pl = T)

full24 <- brglm::brglm(business.op ~ lag(business.op,1) + v2exbribe + c_debt + v2peasjpol + 
                         v2clkill + v2clstown + v2caautmob +
                         v2cacamps + v2x_jucon + v2psoppaut +
                         v2regsupgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                       +factor(country_name),
                       family = binomial, data = vdem.sub, na.action = na.omit,
                       method = "brglm.fit", pl = T)

full25 <- brglm::brglm(business ~ lag(business,1) + v2exbribe + c_debt + v2peasjpol + 
                         v2cltort + v2clstown + v2cademmob +
                         v2cacamps + v2x_jucon + v2psoppaut +
                         v2regoppgroupssize + v2regdur2 
                       +factor(country_name),
                       family = binomial, data = vdem.sub, na.action = na.omit,
                       method = "brglm.fit")

full26 <- brglm::brglm(business ~ lag(business,1) +v2exbribe + c_debt + v2peasjpol + 
                         v2cltort + v2clstown + v2cademmob +
                         v2cacamps + v2x_jucon + v2psoppaut +
                         v2regoppgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                       +factor(country_name),
                       family = binomial, data = vdem.sub, na.action = na.omit,
                       method = "brglm.fit")

full27 <- brglm::brglm(business ~ lag(business,1) + v2exbribe + c_debt + v2peasjpol + 
                         v2clkill + v2clstown + v2caautmob +
                         v2cacamps + v2x_jucon + v2psoppaut +
                         v2regsupgroupssize + v2regdur2 
                       +factor(country_name),
                       family = binomial, data = vdem.sub, na.action = na.omit,
                       method = "brglm.fit")

full28 <- brglm::brglm(business ~ lag(business,1) + v2exbribe + c_debt + v2peasjpol + 
                         v2clkill + v2clstown + v2caautmob +
                         v2cacamps + v2x_jucon + v2psoppaut +
                         v2regsupgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                       +factor(country_name),
                       family = binomial, data = vdem.sub, na.action = na.omit,
                       method = "brglm.fit")

full.list <- list(full21, full22, full23, full24, full25, full26, full27, full28)

## **Table C15: Institutional Cooptation Measure I ####
texreg::texreg(full.list, omit.coef = "(factor)|(lag)", 
               custom.header = list("Opposition" = 1:4,
                                    "Support" = 5:8),
               custom.coef.names = c("(Intercept)", "Co-optation", "Debt crisis",
                                     "Access to state jobs",
                                     "Freedom from torture",
                                     "State ownership",
                                     "Pro-democracy mobilization",
                                     "Polarization",
                                     "Judicial constraints",
                                     "Opposition Autonomy",
                                     "Opposition group size",
                                     "Regime duration",
                                     "Legislative constraints",
                                     "Polyarchy",
                                     "Freedom from killing",
                                     "Pro-autocracy mobilization",
                                     "Support group size"),
               file = "output/TableC15-institutional.html", 
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                                      "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               digits = 2
)

### Linear FE Models ------------------------------------------------------------

pacman::p_load("plm")
### **Business support ##########
form151 <- formula("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt")

form152 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form153 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form154 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form155 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form156 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form157 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form158 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form159 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form160 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy", sep="+"))

form161 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy", sep="+"))

form162 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon", 
                         sep="+"))

form163 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon", 
                         sep="+"))

form164 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form165 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form166 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form167 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form168 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form169 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form170 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form171 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form172 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps", sep="+"))

form173 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps", sep="+"))

form174 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps", sep="+"))

form175 <- formula(paste("v2regsupgroups_3 ~ lag(v2regsupgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps", sep="+"))

f.list <- cbind(paste0(rep("form", 25),seq(151,175,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results7 <- list()
results7 <- lapply(f.list2, f.plm)

aic_values <- sapply(results7, AIC)
order_index <- order(aic_values)
sorted_models <- results7[order_index]
sorted_models <- sorted_models[1:15]

## **Table C8: Linear FE for business support ####

texreg(sorted_models, 
       omit.coef = "(lag)",
       file = "output/TableC8-Linear FE-business sup.html", 
       custom.coef.names = c("Co-optation", "Debt crisis",
                             "Freedom from killing",
                             "Support group size",
                             "Pro-autocracy mobilization",
                             "Opposition Autonomy",
                             "Regime duration",
                             "State ownership",
                             "Judicial constraints",
                             "Polyarchy",
                             "Polarization",
                             "Opposition group size",
                             "Freedom from torture",
                             "Pro-democracy mobilization"
       ),
       custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                              "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
       digits = 3)

## **Business opposition ####

form176 <- formula("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt")

form177 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form178 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form179 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form180 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form181 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form182 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon",
                         "factor(country_name)", sep="+"))

form183 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form184 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon", sep="+"))

form185 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy", sep="+"))

form186 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy", sep="+"))

form187 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon", 
                         sep="+"))

form188 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon", 
                         sep="+"))

form189 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form190 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form191 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form192 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form193 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps",
                         "factor(country_name)", sep="+"))

form194 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regoppgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form195 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form196 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2cacamps", sep="+"))

form197 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps", sep="+"))

form198 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2cacamps", sep="+"))

form199 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2clkill + v2regsupgroupssize + v2caautmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps", sep="+"))

form200 <- formula(paste("v2regoppgroups_3 ~ lag(v2regoppgroups_3,1) + v2exbribe + c_debt", "
                       v2cltort + v2regoppgroupssize + v2cademmob + v2psoppaut +
                       v2regdur2 + v2clstown + v2x_jucon + v2x_polyarchy + v2xlg_legcon +
                         v2cacamps", sep="+"))

f.list <- cbind(paste0(rep("form", 25),seq(176,200,by=1)))
f.list2 <- list()
f.list2 <- lapply(f.list, f.names)

results8 <- list()
results8 <- lapply(f.list2, f.plm)

aic_values <- sapply(results8, AIC)
order_index <- order(aic_values)
sorted_models <- results8[order_index]
sorted_models <- sorted_models[1:15]

## **Table C9: Linear FE for business opp. ####

texreg(sorted_models, 
       omit.coef = "(lag)",
       file = "output/TableC9-Linear FE-business opp.html", 
       custom.coef.names = c("Co-optation", "Debt crisis",
                             "Freedom from killing",
                             "Support group size",
                             "Pro-autocracy mobilization",
                             "Opposition Autonomy",
                             "Regime duration",
                             "State ownership",
                             "Judicial constraints",
                             "Polyarchy",
                             "Polarization",
                             "Freedom from torture",
                             "Pro-democracy mobilization",
                             "Opposition group size"
                             
       ),
       custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes"),
                              "Lagged DV" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
       digits = 3)
detach("package:plm", unload = TRUE)