### Autocrats and their business allies ###
### April 2025                          ###
### Semuhi Sinanoglu                    ###
### Main Analysis                       ###

### Main Models ----------------------------------------------------------------
full1 <- brglm::brglm(business.op ~ lag(business.op,1) + v2exbribe + c_debt +
                 v2cltort + v2clstown + v2cademmob +
                 v2cacamps + v2x_jucon + v2psoppaut +
                 v2regoppgroupssize + v2regdur2 
                 +factor(country_name),
               family = binomial, data = vdem.sub, na.action = na.omit,
                        method = "brglm.fit", pl = T)

full2 <- brglm::brglm(business.op ~ lag(business.op,1) + v2exbribe + c_debt +
                        v2cltort + v2clstown + v2cademmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regoppgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit", pl = T)

full3 <- brglm::brglm(business.op ~ lag(business.op,1) + v2exbribe + c_debt +
                        v2clkill + v2clstown + v2caautmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regsupgroupssize + v2regdur2 
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit", pl = T)

full4 <- brglm::brglm(business.op ~ lag(business.op,1) + v2exbribe + c_debt +
                        v2clkill + v2clstown + v2caautmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regsupgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit", pl = T)

full5 <- brglm::brglm(business ~ lag(business,1) + v2exbribe + c_debt +
                        v2cltort + v2clstown + v2cademmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regoppgroupssize + v2regdur2 
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit")

full6 <- brglm::brglm(business ~ lag(business,1) + v2exbribe + c_debt +
                        v2cltort + v2clstown + v2cademmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regoppgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit")

full7 <- brglm::brglm(business ~ lag(business,1) + v2exbribe + c_debt +
                        v2clkill + v2clstown + v2caautmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regsupgroupssize + v2regdur2 
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit")

full8 <- brglm::brglm(business ~ lag(business,1) + v2exbribe + c_debt +
                        v2clkill + v2clstown + v2caautmob +
                        v2cacamps + v2x_jucon + v2psoppaut +
                        v2regsupgroupssize + v2regdur2 + v2xlg_legcon + v2x_polyarchy
                      +factor(country_name),
                      family = binomial, data = vdem.sub, na.action = na.omit,
                      method = "brglm.fit")

full.list <- list(full1, full2, full3, full4, full5, full6, full7, full8)

## **Table C1 ####
texreg::texreg(full.list, 
               file = "output/TableC1-main-models.html", 
               omit.coef = "(factor)", 
               custom.header = list("Opposition" = 1:4,
                                    "Support" = 5:8),
               custom.coef.names = c("(Intercept)", "Lagged Business Opp.", "Co-optation", "Debt crisis",
                                     "Freedom from torture", 
                                     "State ownership",
                                     "Pro-democracy mobilization",
                                     "Polarization",
                                     "Judicial constraints",
                                     "Opposition Autonomy",
                                     "Opposition group size",
                                     "Regime duration",
                                     "Legislative constraints",
                                     "Polyarchy",
                                     "Freedom from killing",
                                     "Pro-autocracy mobilization",
                                     "Support group size", "Lagged Business Sup."),
               digits = 2,
               custom.gof.rows = list("Fixed Effects" = c("Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes", "Yes")),
               )

## **Figure 2 ####
varlist <- c("Cooptation", "Debt crisis")
names(varlist) <- c("v2exbribe", "c_debt")
p <- plot_models(full1, full2, full3, full4, full5, full6, full7, full8,
                 axis.lim = c(-10, 10))
vars <- paste(unique(p$data$term))

p <- sjPlot::plot_models(full1, full2, full3, full4, full5,
                    full6, full7, full8, transform = "exp",
            auto.label = T, vline.color = "black",
            legend.title = "",
            show.values = TRUE, 
            rm.terms = vars[-c(2,3)],
            colors = "bw", 
            dot.size = 2, value.size = 3, line.size = 0.5,
            spacing = 0.9, 
            axis.labels = varlist, 
            axis.title = "Odds-Incidence Rate Ratios") +
  aes(linetype = group) + 
  scale_linetype_manual(guide = "none", name = "", values = c("solid", "solid", "solid", "solid", "dashed", "dashed", "dashed", "dashed")) +
  theme_bw() + theme(legend.position = "none") 

p + annotate("rect", xmin = 0.4, xmax = 0.7, ymin = 25, ymax = 100, fill = "grey90", color = "black") +
  annotate("segment", y = 30, yend = 55, x = 0.6, xend = 0.6, colour = "black", size = 1, linetype = "solid") +
  annotate("text", y = 55, x = 0.6, label = "Support", hjust = 0, size = 2.8) +
  annotate("segment", y = 30, yend = 55, x = 0.5, xend = 0.5, colour = "black", size = 1, linetype = "dashed") +
  annotate("text", y = 55, x = 0.5, label = "Opposition", hjust = 0, size = 2.8) 

ggsave("output/Figure 2-coef.plot.png", dpi = 600,
       width = 25, height = 15, units = "cm")

## **Figure 3: Average marginal effects ####

p1 <- ggeffects::predict_response(full1, terms="v2exbribe [all]",
                            margin = "average",
                            condition = c(c_debt = 1)) %>% 
  plot() + 
  geom_rug(data = full1$model, aes(x = v2exbribe), inherit.aes = FALSE, alpha = 0.3) +
  labs(x = "",
                y = "Business opposition",
                title = "Average marginal effects") +
  theme_bw()

p2 <- ggeffects::predict_response(full8, terms="v2exbribe [all]",
                            margin = "average",
                            condition = c(c_debt = 1)) %>% 
  plot() + 
  geom_rug(data = full1$model, aes(x = v2exbribe), inherit.aes = FALSE, alpha = 0.3) +
  labs(x = "Co-optation",
                y = "Business support",
                title = "") +
  theme_bw()

p1 / p2 + plot_layout(guides = 'collect', 
                      axes = 'collect')
ggsave("output/Figure 3-ame.jpeg", dpi = 600)

### Mediation Analysis / Indirect Effects -------------------------------

vdem.lagged <- vdem.sub %>%
  arrange(country_name, year) %>%
  group_by(country_name) %>%
  mutate(
    v2exbribe_lag = dplyr::lag(v2exbribe, 1),
    business.op_lead = dplyr::lead(business.op, 1),
    business_lead = dplyr::lead(business, 1),
    v2regdur2_lag = dplyr::lag(v2regdur2, 1),
    v2clstown_lag = dplyr::lag(v2clstown, 1),
    v2x_jucon_lag = dplyr::lag(v2x_jucon, 1),
    v2cacamps_lag = dplyr::lag(v2cacamps, 1),
    v2regsupgroupssize_lag = dplyr::lag(v2regsupgroupssize, 1)
  ) %>%
  ungroup() %>%
  filter(
    !is.na(v2exbribe_lag), !is.na(business.op_lead), !is.na(business_lead), !is.na(v2merange),
    !is.na(v2regdur2_lag), !is.na(v2clstown_lag), !is.na(v2x_jucon_lag),
    !is.na(v2regsupgroupssize_lag), !is.na(v2cacamps_lag)
  )

### **Propaganda #####

m_mod <- brms::brm(
  v2merange ~ v2exbribe_lag +
    v2regdur2_lag + v2clstown_lag + v2x_jucon_lag +
    v2regsupgroupssize_lag + v2cacamps_lag +
    (1 | country_name) + (1 | year),
  data = vdem.lagged,
  family = gaussian(),
  chains = 4, cores = 4, iter = 2000
)


y_mod <- brms::brm(
  business.op_lead ~ v2exbribe_lag + v2merange + (1 | country_name) + (1 | year),
  data = vdem.lagged,
  family = bernoulli(link = "logit"),
  chains = 4, cores = 4, iter = 2000
)

post_m <- posterior_samples(m_mod, pars = "b_v2exbribe_lag")
post_y <- posterior_samples(y_mod, pars = c("b_v2exbribe_lag", "b_v2merange"))

a <- post_m$b_v2exbribe_lag
b <- post_y$b_v2merange
c_prime <- post_y$b_v2exbribe_lag

indirect <- a * b
total <- indirect + c_prime
effects_df <- data.frame(
  value = c(indirect, c_prime, total),
  type = factor(rep(c("Indirect", "Direct", "Total"), each = length(indirect)),
                levels = c("Indirect", "Direct", "Total"))
)

med_summary <- data.frame(
  Effect = c("Indirect", "Direct", "Total"),
  Estimate = c(median(indirect), median(c_prime), median(total)),
  `2.5%` = c(quantile(indirect, 0.025), quantile(c_prime, 0.025), quantile(total, 0.025)),
  `97.5%` = c(quantile(indirect, 0.975), quantile(c_prime, 0.975), quantile(total, 0.975))
)
print(med_summary)

ggplot(effects_df, aes(x = value, y = type, fill = type)) +
  stat_halfeye(
    .width = 0.95,
    point_interval = median_qi,
    slab_alpha = 0.7,
    slab_color = NA
  ) +
  geom_vline(xintercept = 0, linetype = "dashed", color = "grey30") +
  scale_fill_grey(start = 0.3, end = 0.7) +
  theme_minimal(base_size = 14) +
  theme(
    legend.position = "none",
    axis.title = element_text(size = 11),
    plot.caption = element_text(size = 10)
  ) + 
  labs(
    x = "Effect size",
    y = NULL
  ) 
ggsave(filename = "output/Figure 4 - mediation.jpeg", dpi = 600, width = 20, height = 10, 
       units = "cm")







