### Autocrats and their business allies ###
### April 2025                          ###
### Semuhi Sinanoglu                    ###
### Data Setup                          ###

### Setup ----------------------------------------------------------------------
vdem <- readRDS("data/V-Dem-CY-Full+Others-v13.rds")

### VDEM Case selection --------------------------------------------------------

clist <- vdem %>%
  filter(year > 1991) %>%
  filter(v2x_regime < 2) %>%
  filter(v2svindep == 1) %>%
  filter(!country_name %in% c("Seychelles", "Maldives",
                              "Solomon Islands", "Comoros")) %>% 
  select(country_name) %>% unique() %>% arrange(country_name)

## **Drop small countries ####
clist.small <- vdem %>% filter(year == 2000 & e_mipopula < 500) %>%
  select(country_name) %>% unique() %>% arrange(country_name) %>% as.list()

clist <- clist %>%
  filter(!country_name %in% clist.small$country_name)
rm(clist.small)

## **Drop oil-rich regimes ####
clist.oil <- vdem %>%
  filter(year > 1991) %>%
  filter(e_total_fuel_income_pc > 500) %>% 
  select(country_name) %>% unique() 

clist <- clist %>%
  filter(!country_name %in% clist.oil$country_name)
rm(clist.oil)

## **Include regimes with multi-party elections ####
clist.party <- vdem %>%
  filter(year > 1991) %>%
  filter(v2elmulpar_ord >=4 ) %>%
  select(country_name) %>% unique() 

clist <- clist %>%
  filter(country_name %in% clist.party$country_name)
rm(clist.party)

## **Final VDEM subset ####
vdem.final <- vdem %>%
  filter(year > 1991 & year < 2020 & country_name %in% clist$country_name)

rm(list = ls(pattern="clist"))

## Crisis Data -----------------------------------------------------------------
crisis <- readxl::read_xlsx("data/crisis2.xlsx")

crisis <- crisis %>%
  mutate(country_name=replace(country_name, country_name=="Congo, Dem. Rep.", "Democratic Republic of the Congo")) %>%
  mutate(country_name=replace(country_name, country_name=="Myanmar", "Burma/Myanmar")) %>%
  mutate(country_name=replace(country_name, country_name=="Cote d'Ivoire", "Ivory Coast")) %>%
  mutate(country_name=replace(country_name, country_name=="Egypt, Arab Rep.", "Egypt")) %>%
  mutate(country_name=replace(country_name, country_name=="Gambia, The", "The Gambia")) %>%
  mutate(country_name=replace(country_name, country_name=="Iran, Islamic Rep.", "Iran")) %>%
  mutate(country_name=replace(country_name, country_name=="Kyrgyz Republic", "Kyrgyzstan")) %>%
  mutate(country_name=replace(country_name, country_name=="Russian Federation", "Russia")) %>%
  mutate(country_name=replace(country_name, country_name=="Syrian Arab Republic", "Syria")) %>%
  mutate(country_name=replace(country_name, country_name=="Venezuela, RB", "Venezuela")) %>%
  mutate(country_name=replace(country_name, country_name=="Yemen, Rep.", "Yemen")) %>%
  mutate(country_name=replace(country_name, country_name=="Congo, Rep.", "Republic of the Congo")) %>%
  mutate(country_name = replace(country_name, country_name == "Lao PDR", "Laos")) %>%
  mutate(country_name = replace(country_name, country_name == "Slovak Republic", "Slovakia")) %>%
  mutate(country_name = replace(country_name, country_name == "Taiwan, China", "Taiwan"))

vdem.final <- left_join(vdem.final, crisis, 
                        by = c("country_name", "year"))
rm(list = ls(pattern = "crisis"))

## Final Subset ----------------------------------------------------------------
vdem.sub <- vdem.final %>%
  select(country_name, year, v2cacamps, v2cacamps_ord, 
         v2cacamps_codelow, v2cacamps_codehigh, v2cacamps_mean, v2merange, v2x_polyarchy, v2x_regime, v2x_jucon, v2xlg_legcon, v2elmulpar, v2elmulpar_ord, v2elintim,
         v2elfrfair, v2psoppaut, v2psnatpar, v2exrescon, v2exbribe, v2exbribe_sd, v2exembez, v2excrptps,
         v2regdur, v2regsupgroups_3, v2regoppgroupsact_3, v2regsupgroups_9, v2regsupgroupssize, v2regoppgroupssize,
         v2regoppgroups_3, v2regoppgroups_9, v2x_neopat, v2x_neopat_sd, v2jupurge, v2jupoatck, v2juhcind, v2cltort, v2clkill, v2cltrnslw, v2clrspct, 
         v2cldiscm, v2clacfree, v2clstown, v2mecenefm, v2mecenefi, v2mecrit, v2meharjrn, v2meslfcen,
         v2mecorrpt, v2pepwrses, v2peasbecon, v2peasjpol, v2peasbepol, v2exl_legitperf, v2exl_legitratio, v2caviol, v2cademmob, v2regimpgroup, v2regpower,
         v2caautmob, starts_with("c_")) %>%
  arrange(country_name, year)
rm(vdem.final)
rm(vdem)

## Variable transformations ----------------------------------------------------

## **Regime duration scaled ####
vdem.sub <- vdem.sub %>% mutate(v2regdur2 = scale(v2regdur)[,1]) %>%
  select(-v2regdur)

## **Binary support/opposition measure ####
vdem.sub <- vdem.sub %>%
  mutate(business = ifelse(v2regsupgroups_3 >= 0.5, 1, 0)) %>%
  mutate(business.op = ifelse(v2regoppgroups_3 >= 0.5, 1, 0)) 

## **Conservative threshold ####
vdem.sub <- vdem.sub %>% mutate(business.op2 = 
                                  ifelse(v2regoppgroups_3 >= 0.75, 1, 0)) %>%
  mutate(business2 = ifelse(v2regsupgroups_3 >= 0.75, 1, 0)) %>%
  mutate(business.op2 = factor(business.op2)) %>%
  mutate(business2 = factor(business2))

## **Reverse co-optation ####
vdem.sub <- vdem.sub %>%
  mutate(v2exbribe = -v2exbribe) 

## **Reverse access ####
vdem.sub <- vdem.sub %>%
  mutate(v2peasbepol = -v2peasbepol) 

## **Media control ####
vdem.sub <- vdem.sub |>
  mutate(v2merange = -v2merange)

## **Other ####
vdem.sub$year2 <- factor(vdem.sub$year)

## Final Data ------------------------------------------------------------------
save(vdem.sub, file = "data/vdem.sub.RData")

