### Autocrats and their business allies ###
### April 2025                          ###
### Semuhi Sinanoglu                    ###
### Utils.                              ###

### GLM-FE function ------------------------------------------------------------
f.brglm <- function(x) {
  out <- brglm(x,
               family = binomial, data = vdem.sub, na.action = na.omit,
               method = "brglm.fit", pl = T)
  return(out)
}

### Model names ----------------------------------------------------------------
f.names <- function(name) {
  eval(as.symbol(name), envir = .GlobalEnv)
}

### GLMM function --------------------------------------------------------------
f.glmm <- function(x) {
  out <- glmmTMB(x,
                 data = vdem.sub, family = binomial(link = "logit"),
                 control=glmmTMBControl(parallel = 2))
  return(out)
}

### Linear FE function ---------------------------------------------------------
f.plm <- function(x) {
  out <- plm(x,
             data = vdem.sub,na.action = na.omit,
             model = "within", effect = "twoways", index = c("country_name",
                                                             "year"))
  return(out)
}