# LFM-PAPER-059: Frame-Dragging from Substrate Momentum Flux: Gravitomagnetism Without Extension

## Zenodo Data Package

**Paper Title**: Frame-Dragging from Substrate Momentum Flux: Gravitomagnetism Without Extension

**Authors**: Greg D. Partin

**Date**: February 2026

**Paper ID**: LFM-PAPER-059

---

## Abstract

A persistent challenge for the Lattice Field Medium (LFM) framework has been explaining frame-dragging (Lense-Thirring precession), since the scalar χ field has ∇×∇χ ≡ 0 by identity. Previous attempts using χ-retardation produced precession with the wrong sign. We resolve this by demonstrating that the real E field already contains momentum information via the stress-energy tensor component T^{0i} = (∂E/∂t)(∂E/∂x_i). Rotating matter creates circulating momentum flux, which we decompose using the Helmholtz theorem into curl-free and divergence-free components. The divergence-free part defines a gravitomagnetic vector potential A_g with non-zero curl B_g = ∇×A_g. This induces a velocity-dependent Lorentz-like force F_gm = m(v×B_g) that drags both prograde and retrograde orbits in the direction of source rotation—exactly matching general relativity's Lense-Thirring prediction. We verify this numerically, finding prograde precession shift Δθ = +0.033 rad and retrograde shift Δθ = +0.046 rad, both with correct sign. This resolves frame-dragging without requiring complex fields or vector χ extensions.

---

## Package Contents

### `/manuscript/`
Publication-ready manuscript and source files:
- `manuscript.tex` — LaTeX source
- `refs.bib` — Bibliography
- `metadata.json` — Paper metadata
- `CITATION.cff` — Citation file
- `LICENSE.txt` — License

### `/experiments/`
Python scripts for validation experiments:
- `lfm_gravitomagnetic_frame_dragging.py` — Main frame-dragging experiment

### `/results/`
Experiment output data and plots:

| Experiment | Description | Directory |
|------------|-------------|-----------|
| Frame-Dragging | Helmholtz decomposition + orbit simulation | `frame_dragging/` |

---

## Key Results

| Metric | Value |
|--------|-------|
| Prograde precession shift | **+0.033 rad** |
| Retrograde precession shift | **+0.046 rad** |
| Sign check | ✓ **CORRECT** (both dragged with rotation) |
| Peak gravitomagnetic field | 2.46 × 10⁻⁴ |

---

## The Breakthrough

**Previous understanding**: Scalar χ cannot produce frame-dragging because ∇×∇χ ≡ 0

**New insight**: The momentum flux T^{0i} = (∂E/∂t)(∂E/∂x_i) contains directional information. Helmholtz decomposition extracts the divergence-free component, giving gravitomagnetic field B_g with non-zero curl.

**Result**: Frame-dragging emerges from GOV-01 + GOV-02 without any extension!

---

## Reproducibility

To reproduce experiments:

```bash
cd experiments
python lfm_gravitomagnetic_frame_dragging.py
```

**Requirements**: Python 3.9+, NumPy, SciPy, Matplotlib

---

## Citation

```bibtex
@article{LFMPAPER059,
  author  = {Greg D. Partin},
  title   = {Frame-Dragging from Substrate Momentum Flux: Gravitomagnetism Without Extension},
  journal = {Preprint},
  year    = {2026},
  note    = {LFM-PAPER-059}
}
```

---

## License

This work is licensed under Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International (CC BY-NC-ND 4.0). See `manuscript/LICENSE.txt`.
