<!-- 5. HUMAN HEALTH HAZARD ASSESSMENT template file -->

<!----------------------------------------------------------------------------------
------------------------------------------------------------------------------------
study table that captures all related Ecotoxicological endpoint study records
-----------------------------------------------------------------------------------
----------------------------------------------------------------------------------->

<!-----------------------------------------------------------------------------
-------------------------------------------------------------------------------
_subject is root entity
docType is a hardcoded document type string
docSubType is a hardcoded document sub type string
columnHeaders is a list of strings that represent column headers
numberOfColumns is a calculation of the size.number of headers in columnHeaders
-------------------------------------------------------------------------------
------------------------------------------------------------------------------->

<#macro getSectionDocuments parent docDefIds>
    <#assign resultStudyList = [] />
    <#assign docType = [] />
    <#assign docSubType = [] />
    <#assign docsForType = [] />
    <#assign tocNodeTitle = []/>
	<#assign currentDocDefIds = []/>

    <#list docDefIds as docDefId>
        <#local split = docDefId?split(".") />
        <#assign docType = split[0] />
        <#assign docSubType = split[1] />
        <#assign docsForType = iuclid.getSectionDocumentsForParentKey(parent.documentKey, docType, docSubType) />
        <#list docsForType as doc>
			<#-- get the *resultStudyList for iteration laters -->
            <#assign resultStudyList = com.addDocumentToSequence(doc, resultStudyList) />
        </#list>
        <#-- get the table of contents node name for the relevant document -->
        <#assign tocNodeTitle = com.tableOfContentsNodeTitle("${docType}", "${docSubType}")/>    
    </#list>
</#macro>

<#macro studyTable _subject docType docSubType columnHeaders numberOfColumns columnWidths humanHealthDocuments titleText="" docFilter="">
<#compress>

	<#-- firstly iterate human studies -->
	<#if docFilter=="toxicokinetics" || docFilter=="acuteToxicity" || docFilter=="skinIrritation"
	|| docFilter=="eyeIrritation" || docFilter=="respiratoryIrritation" || docFilter=="corrosivity" 
	|| docFilter=="skinSensitisation" || docFilter=="respiratorySystem" || docFilter=="repeatedDose" 
	|| docFilter=="mutagenicity" || docFilter=="carcinogenicity" || docFilter=="toxicityToReproduction" 
	|| docFilter=="developmentalToxicity" || docFilter=="otherEffectsNeurotoxicity" || docFilter=="otherEffectsImmunotoxicity"
	|| docFilter=="otherEffectsNotSpecified">
	<#-------------------------------------------------------------->
	<#-- activate macro to get *resultStudyList and *tocNodeTitle -->
	<#-------------------------------------------------------------->
	<@getSectionDocuments _subject humanHealthDocuments/>
	<#-------------------------------------------->
	<#-- Check relevance and sort human studies -->
	<#-------------------------------------------->
	<#assign humanStudyListFiltered = getRelevantHumanHealthStudies(resultStudyList, docFilter)/>

	<#-- Sort pre filtered human studues and populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists humanStudyListFiltered />	

	<#else>

		<!-- docType and docSubType dynamically fetched when getting section documents for root entity -->
		<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "${docType}", "${docSubType}") />

		<!-- get the table of contents node name for the relevant document -->
		<#assign tocNodeTitle = com.tableOfContentsNodeTitle("${docType}", "${docSubType}")/>

		<#-- Get irritationSkin studies -->
		<#if docSubType=="SkinIrritationCorrosion" && docFilter=="irritationSkin">
			<#assign studyListFiltered = getRelevantNonHumanStudies(studyList, ["skin irritation: in vitro / ex vivo", "skin irritation: in vivo", "skin irritation / corrosion, other"])>				
		<#-- Get irritationCorrosion studies -->
		<#elseif docSubType=="SkinIrritationCorrosion" && docFilter=="irritationCorrosion">
			<#assign studyListFiltered = getRelevantNonHumanStudies(studyList, ["skin corrosion: in vitro / ex vivo", "skin irritation / corrosion.*"] ) />
		<#-- Get carcinogenicity: oral studies -->
		<#elseif docSubType=="Carcinogenicity" && docFilter=="carcinogenicityOral">
			<#assign studyListFiltered = getRelevantNonHumanStudies(studyList, ["carcinogenicity: oral"] ) />	
		<#-- Get carcinogenicity: inhalation studies -->
		<#elseif docSubType=="Carcinogenicity" && docFilter=="carcinogenicityInhalation">
			<#assign studyListFiltered = getRelevantNonHumanStudies(studyList, ["carcinogenicity: inhalation"] ) />	
		<#-- Get carcinogenicity: dermal studies -->
		<#elseif docSubType=="Carcinogenicity" && docFilter=="carcinogenicityDermal">
			<#assign studyListFiltered = getRelevantNonHumanStudies(studyList, ["carcinogenicity: dermal"] ) />
		<#-- Get carcinogenicity: other studies -->
		<#elseif docSubType=="Carcinogenicity" && docFilter=="carcinogenicityOtherRoutes">
			<#assign studyListFiltered = getRelevantNonHumanStudies(studyList, ["carcinogenicity, other"] ) />

		<#-- Sort pre filtered non-human studues and populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
		<@populateResultAndDataWaivingAndTestingProposalStudyLists studyListFiltered />				

		<#else>

		<#-- Sort non-human studues and populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
		<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList />

		</#if>
	</#if>
	
		<#-- Study results -->
		<#if resultStudyList?has_content>

			The studies on <emphasis role="bold">${tocNodeTitle}</emphasis> are summarized in the following table:

				<table border="1">

				<title>
					<#if titleText?has_content>
						${titleText}
					<#else>				
						Studies on ${tocNodeTitle}
					</#if>
				</title>

					<#list columnWidths as width>
					<#assign columnIndexWidth = width?index>
						<col width="${columnWidths[columnIndexWidth]}">${width}</col>
					</#list>
					<tbody>
					<tr>
						<#list columnHeaders as header>
							<#assign columnIndexHeader = header?index>
							<?dbfo bgcolor="#FBDDA6" ?><th width="${columnWidths[columnIndexHeader]}"><emphasis role="bold">${header}</emphasis></th>
						</#list>
					</tr>	
					<#list resultStudyList as study>
						<tr>
							<#list 0..numberOfColumns-1 as columnNum>
								<td>
								<#if columnNum == 0><!-- CSR Column 1 *Method -->

									<#-- QSAR related information in materials and methods -->
									<@studyandsummaryCom.qsarModel study/>

									<#-- CSR EyeIrritation -->
									<#if docSubType=="EyeIrritation" && com.picklistValueMatchesPhrases(study.AdministrativeData.Endpoint, ["eye irritation: in vitro / ex vivo"])>
										<para>in vitro study</para>
									</#if>

									<#-- CSR RespiratoryTract -->
									<#if  docSubType=="RespiratoryTract" && com.picklistValueMatchesPhrases(study.AdministrativeData.Endpoint, ["respiratory sensitisation: in vitro", "respiratory sensitisation: in chemico"])>
										<para>in vitro study</para>							
									</#if>

									<#-- CSR BasicToxicokinetics | DermalAbsorption | AcuteToxicityOral | AcuteToxicityInhalation 
									| AcuteToxicityOtherRoutes | SkinIrritationCorrosion | EyeIrritation | RespiratorySensitisation
									| SkinSensitisation | RepeatedDoseToxicityOral   -->
									<#if docSubType=="BasicToxicokinetics" 
									|| docSubType=="DermalAbsorption"
									|| docSubType=="AcuteToxicityOral"
									|| docSubType=="AcuteToxicityInhalation"
									|| docSubType=="AcuteToxicityDermal"
									|| docSubType=="AcuteToxicityOtherRoutes"
									|| docSubType=="SkinIrritationCorrosion"
									|| docSubType=="EyeIrritation"
									|| docSubType=="RespiratorySensitisation"
									|| docSubType=="SkinSensitisation"
									|| docSubType=="RepeatedDoseToxicityOral"
									|| docSubType=="RepeatedDoseToxicityInhalation"
									|| docSubType=="RepeatedDoseToxicityDermal"
									|| docSubType=="RepeatedDoseToxicityOther"
									|| docSubType=="GeneticToxicityVitro"
									|| docSubType=="GeneticToxicityVivo"
									|| docSubType=="Carcinogenicity"
									|| docSubType=="ToxicityReproduction"
									|| docSubType=="ToxicityReproductionOther"
									|| docSubType=="DevelopmentalToxicityTeratogenicity"
									|| docSubType=="Neurotoxicity"
									|| docSubType=="Immunotoxicity"
									|| docSubType=="SpecificInvestigations"
									|| docSubType=="AdditionalToxicologicalInformation">
									<para>${tocNodeTitle} study</para>
									<@nonHumanStudyMethod study />	
									</#if>

									<#-- CSR HealthSurveillanceData | EpidemiologicalData | DirectObservationsClinicalCases | ExposureRelatedObservationsOther | SensitisationData -->
									<#if docFilter=="toxicokinetics" || docFilter=="acuteToxicity" || docFilter=="skinIrritation"
									|| docFilter=="eyeIrritation" || docFilter=="respiratoryIrritation" || docFilter=="corrosivity" 
									|| docFilter=="skinSensitisation" || docFilter=="respiratorySystem" || docFilter=="repeatedDose" 
									|| docFilter=="mutagenicity" || docFilter=="carcinogenicity" || docFilter=="toxicityToReproduction" 
									|| docFilter=="developmentalToxicity" || docFilter=="otherEffectsNeurotoxicity" || docFilter=="otherEffectsImmunotoxicity"
									|| docFilter=="otherEffectsNotSpecified">
									<@humanStudyMethod study/>
									</#if>	

								<#elseif columnNum == 1><!-- CSR Column 1 *Results -->

									<#-- QSAR based results -->
									<@studyandsummaryCom.qsarResultsAndDiscussion study />
									
									<#-- CSR BasicToxicokinetics -->
									<#if docSubType=="BasicToxicokinetics">
										<para>Main ADME results: <@ADMEList study.ResultsAndDiscussion.MainAdmeResults/></para>
										
										<#-- CSR BasicToxicokinetics -->
										<para><@TransferList study.ResultsAndDiscussion.PharmacokineticStudies.TransferIntoOrgans/></para>

										<#-- CSR BasicToxicokinetics -->
										<para>Toxicokinetic parameters: <@ToxicokineticParametersList study.ResultsAndDiscussion.PharmacokineticStudies.ToxicokineticParameters/></para>

										<#-- CSR BasicToxicokinetics -->
										<para>Absorption: <@com.text study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnAbsorption/></para>

										<#-- CSR BasicToxicokinetics -->
										<para>Distribution: <@com.text study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnDistribution/></para>

										<#-- CSR BasicToxicokinetics -->
										<para>Excretion: <@com.text study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnExcretion/></para>

										<#-- CSR BasicToxicokinetics -->
										<para>Metabolites identified: <@com.value study.ResultsAndDiscussion.MetaboliteCharacterisationStudies.MetabolitesIdentified/></para>

										<#-- CSR BasicToxicokinetics -->
										<para>Details on metabolites: <@com.text study.ResultsAndDiscussion.MetaboliteCharacterisationStudies.DetailsOnMetabolites/></para>
									</#if>

									<#if docSubType=="DermalAbsorption">
									<para>
										<#-- CSR DermalAbsorption | -->
										<@com.text study.ResultsAndDiscussion.AbsorptionMatrices/>
									</para>

									<para>
										<#-- CSR DermalAbsorption | -->
										Total recovery: <@com.text study.ResultsAndDiscussion.TotalRecovery/>
									</para>

									<para>
										<#-- CSR DermalAbsorption | -->
										<#if study.ResultsAndDiscussion.Absorption?has_content>
											Percutaneous absorption rate: <@PercutaneousAbsorptionRateList study.ResultsAndDiscussion.Absorption/>
										</#if>
									</para>
									</#if>

									<#-- CSR AcuteToxicityOral | AcuteToxicityInhalation | AcuteToxicityDermal | AcuteToxicityOtherRoutes -->
									<#if docSubType=="AcuteToxicityOral" 
									|| docSubType=="AcuteToxicityInhalation"
									|| docSubType=="AcuteToxicityDermal"
									|| docSubType=="AcuteToxicityOtherRoutes">
										<para>
											<@EffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels)/>											
										</para>
									</#if>

									<#-- CSR SkinIrritationCorrosion -->
									<#if docSubType=="SkinIrritationCorrosion">
										<para>
											<@com.value study.ApplicantSummaryAndConclusion.InterpretationOfResults/>
										</para>

										<para>
											<@inVitroList study.ResultsAndDiscussion.InVitro.Results/>
										</para>

										<para>
											<@inVivoList study.ResultsAndDiscussion.InVivo.Results/>
										</para>
									</#if>

									<#-- CSR EyeIrritation  -->
									<#if docSubType=="EyeIrritation">
										<para>
											<@com.value study.ApplicantSummaryAndConclusion.InterpretationOfResults/>
										</para>
										
										<@EyeIrritationInVitroList study.ResultsAndDiscussion.InVitro.ResultsOfExVivoInVitroStudy/>
										
										<@EyeIrritationInVivoList study.ResultsAndDiscussion.InVivo.IrritationCorrosionResults/>
									</#if>
									
									<#-- CSR RespiratorySensitisation -->
									<#if docSubType=="RespiratorySensitisation">
										<para>
											<@com.value study.ApplicantSummaryAndConclusion.InterpretationOfResults/>
										</para>

										<para>
											<@com.text study.ResultsAndDiscussion.Results/>
										</para>
									</#if>

									<#-- CSR SkinSensitisation -->
									<#if docSubType=="SkinSensitisation">

										<para>
										<@com.value study.ApplicantSummaryAndConclusion.InterpretationOfResults/>
										</para>
										
										<para>
										<#local endpoint><@com.value study.AdministrativeData.Endpoint/></#local>
											<#if study.ResultsAndDiscussion.InVivoLLNA.Results?has_content>								
											<@inVivoLLNAList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.InVivoLLNA.Results) endpoint />
											</#if>
										</para>

										<para>
											<@inVivoNonLLNAList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TraditionalSensitisationTest.ResultsOfTest) endpoint/>
										</para>

										<para>
											<@inVitroLLNAList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.InVitroInChemico.Results) endpoint />
										</para>
									</#if>

									<#-- CSR RepeatedDoseToxicityOral  -->
									<#if docSubType=="RepeatedDoseToxicityOral" 
									|| docSubType=="RepeatedDoseToxicityInhalation" 
									|| docSubType=="RepeatedDoseToxicityDermal" 
									|| docSubType=="RepeatedDoseToxicityOther">
										<para>
											<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
										</para>

										<para>
											<@TargetSystemOrganToxList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TargetSystemOrganToxicity.TargetSystemOrganToxicity)/>
										</para>
									</#if>

									<#-- CSR GeneticToxicityVitro -->
									<#if docSubType=="GeneticToxicityVitro">
										<para>								
										<@TestResultsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TestRs)/>
										
											<#assign remarksOnResults = study.ResultsAndDiscussion.RemarksOnResults>
											<#if remarksOnResults?has_content>
												Remarks: <@com.value study.ResultsAndDiscussion.RemarksOnResults/>
											</#if>
										</para>
									</#if>

									<#-- CSR GeneticToxicityVivo -->
									<#if docSubType=="GeneticToxicityVivo">
										<para>
											<@TestResultsInVivoList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TestRs)/>
										</para>
									</#if>

									<#-- CSR Carcinogenicity oral and inhalation and dermal and other routes -->
									<#if docSubType=="Carcinogenicity">
										<para>
											<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
										</para>
									</#if>

									<#-- CSR ToxicityReproduction -->
									<#if docSubType=="ToxicityReproduction">

										<#if study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.EffectLevelsP0.Efflevel?has_content || study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.TargetSystemOrganToxicityP0.TargetSystemOrganToxicity?has_content>
										<para>
										<emphasis role="bold">First parental generation (P0)</emphasis>
										</para>
											<#if study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.EffectLevelsP0.Efflevel?has_content>
											<para>
											<@EffectLevelsPoList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.EffectLevelsP0.Efflevel)/>
											</para>
											</#if>
											<#if study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.TargetSystemOrganToxicityP0.TargetSystemOrganToxicity?has_content>
											<para>
											<@TargetSystemOrganToxforEffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.TargetSystemOrganToxicityP0.TargetSystemOrganToxicity)/>
											</para>
											</#if>
										</#if>
										

										<#if study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.EffectLevelsP1.Efflevel?has_content || study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.TargetSystemOrganToxicityP1.TargetSystemOrganToxicity?has_content>
										<para>
										<emphasis role="bold">Second parental generation (P1)</emphasis>
										</para>
											<#if study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.EffectLevelsP1.Efflevel?has_content>
											<para>
											<@SecondparentalGenerationP1List studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.EffectLevelsP1.Efflevel)/>
											</para>
											</#if>
											<#if study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.TargetSystemOrganToxicityP1.TargetSystemOrganToxicity?has_content>
											<para>
											<@TargetSystemOrganToxforEffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.TargetSystemOrganToxicityP1.TargetSystemOrganToxicity)/>
											</para>
											</#if>
										</#if>				


										<#if study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.EffectLevelsF1.Efflevel?has_content || study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.TargetSystemOrganToxicityF1.TargetSystemOrganToxicity?has_content>
										<para>
										<emphasis role="bold">F1 generation</emphasis>
										</para>
											<#if study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.EffectLevelsF1.Efflevel?has_content>
											<para>
											<@FgenerationList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.EffectLevelsF1.Efflevel)/>
											</para>
											</#if>
											<#if study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.TargetSystemOrganToxicityF1.TargetSystemOrganToxicity?has_content>
											<para>
											<@TargetSystemOrganToxforEffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.TargetSystemOrganToxicityF1.TargetSystemOrganToxicity)/>
											</para>
											</#if>
										</#if>	

										<#if study.ResultsAndDiscussion.ResultsF2Generation.EffectLevelsF2.Efflevel?has_content>
											<para>
											<emphasis role="bold">F2 generation</emphasis>
											</para>
											<para>
											<@FgenerationList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsF2Generation.EffectLevelsF2.Efflevel)/>
											</para>
										</#if>	
										
										<#if study.ResultsAndDiscussion.ReproductiveToxicity.ReproductiveToxicity?has_content>
											<para>
											<emphasis role="bold">Overall reproductive toxicity</emphasis>
											</para>
											<para>
											<@OverallReproductiveToxicityList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ReproductiveToxicity.ReproductiveToxicity)/>
											</para>
										</#if>
									</#if>

									<#-- CSR ToxicityReproductionOther -->
									<#if docSubType=="ToxicityReproductionOther">
									<para>
										<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
									</para>
									</#if>

									<#-- CSR DevelopmentalToxicityTeratogenicity -->
									<#if docSubType=="DevelopmentalToxicityTeratogenicity">
										<para>
										<emphasis role="bold">Maternal animals:</emphasis>
										</para>

										<para>
										<@MatAbnormalitiesList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsMaternalAnimals.MaternalAbnormalities.MaternalAbnormalities)/>
										</para>

										<para>
										<@EffectLevelsMatAbnormalitiesList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsMaternalAnimals.EffectLevelsMaternalAnimals.Efflevel)/>
										</para>

										<para>
										<emphasis role="bold">Fetuses:</emphasis>
										</para>

										<para>
										<@FetalAbnormalitiesList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsFetuses.FetalAbnormalities.FetalAbnormalities)/>
										</para>

										<para>
										<@EffectLevelsFetusesList study.ResultsAndDiscussion.ResultsFetuses.EffectLevelsFetuses.Efflevel/>
										</para>

										<para>
										<emphasis role="bold">Overall developmental toxicity:</emphasis>
										</para>

										<para>
										<@OverallDevToxList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.DevelopmentalToxicity.DevelopmentalToxicity)/>
										</para>
									</#if>

									<#-- CSR Neurotoxicity |  Immunotoxicity -->
									<#if docSubType=="Neurotoxicity" || docSubType=="Immunotoxicity">
										<para>
										<@EffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
										</para>
									</#if>

									<#-- CSR SpecificInvestigations -->
									<#if docSubType=="SpecificInvestigations">
										<para>
										<@com.text study.ResultsAndDiscussion.ResultsDetails/>
										</para>
									</#if>

									<#-- CSR AdditionalToxicologicalInformation -->
									<#if docSubType=="AdditionalToxicologicalInformation">
										<para>
											Applicant’s summary and conclusion: <@com.text study.ApplicantSummaryAndConclusion.Conclusions/>
										</para>
									</#if>
									
									<#-- Human data: HealthSurveillanceData | EpidemiologicalData | DirectObservationsClinicalCases | ExposureRelatedObservationsOther | SensitisationData -->
									<#if docFilter=="toxicokinetics" || docFilter=="acuteToxicity" || docFilter=="skinIrritation"
									|| docFilter=="eyeIrritation" || docFilter=="respiratoryIrritation" || docFilter=="corrosivity" 
									|| docFilter=="skinSensitisation" || docFilter=="respiratorySystem" || docFilter=="repeatedDose" 
									|| docFilter=="mutagenicity" || docFilter=="carcinogenicity" || docFilter=="toxicityToReproduction" 
									|| docFilter=="developmentalToxicity" || docFilter=="otherEffectsNeurotoxicity" || docFilter=="otherEffectsImmunotoxicity"
									|| docFilter=="otherEffectsNotSpecified">

										<#if study.hasElement("ResultsAndDiscussion.Results")>
											<para><@com.text study.ResultsAndDiscussion.Results/></para>
										</#if>

										<#if study.hasElement("ResultsAndDiscussion.RsExaminations")>
											<para>
												<@com.text study.ResultsAndDiscussion.RsExaminations/>
											</para>
										</#if>

										<#if study.hasElement("ResultsAndDiscussion.Outcome")>
											<para>
											Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
											</para>
										</#if>

									</#if>
								
								<#elseif columnNum == 2><!-- CSR Column 1 *Remarks -->
									<@studyandsummaryCom.studyRemarksColumn study/>
								</#if>
								</td>
							</#list>
						</tr>
						<#-- HealthSurveillanceData | EpidemiologicalData | DirectObservationsClinicalCases | ExposureRelatedObservationsOther 
						| AcuteToxicityOral | AcuteToxicityInhalation | AcuteToxicityDermal | AcuteToxicityOtherRoutes 
						| SkinIrritationCorrosion | EyeIrritation | RespiratorySensitisation | SkinSensitisation | RepeatedDoseToxicityOral
						| repeatedDoseToxicityInhalationStudies | RepeatedDoseToxicityDermal | RepeatedDoseToxicityOther | GeneticToxicityVitro 
						| GeneticToxicityVivo | Carcinogenicity | ToxicityReproduction | DevelopmentalToxicityTeratogenicity | Neurotoxicity 
						|  Immunotoxicity | SpecificInvestigations | AdditionalToxicologicalInformation | HealthSurveillanceData | EpidemiologicalData 
						| DirectObservationsClinicalCases | ExposureRelatedObservationsOther | SensitisationData -->		
						<#if docSubType=="AcuteToxicityOral" 
						|| docSubType=="AcuteToxicityInhalation"
						|| docSubType=="AcuteToxicityDermal"
						|| docSubType=="AcuteToxicityOtherRoutes"
						|| docSubType=="SkinIrritationCorrosion"
						|| docSubType=="EyeIrritation"
						|| docSubType=="RespiratorySensitisation"
						|| docSubType=="SkinSensitisation"
						|| docSubType=="RepeatedDoseToxicityOral"
						|| docSubType=="repeatedDoseToxicityInhalationStudies"
						|| docSubType=="RepeatedDoseToxicityDermal"
						|| docSubType=="RepeatedDoseToxicityOther"
						|| docSubType=="GeneticToxicityVitro"
						|| docSubType=="GeneticToxicityVivo"
						|| docSubType=="Carcinogenicity"
						|| docSubType=="ToxicityReproduction"
						|| docSubType=="DevelopmentalToxicityTeratogenicity"
						|| docSubType=="Neurotoxicity"
						|| docSubType=="Immunotoxicity"
						|| docSubType=="SpecificInvestigations"
						|| docSubType=="AdditionalToxicologicalInformation" 
						|| docFilter??>
							<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
						</#if>
					</#list>
					</tbody>
				</table>
			
		<#elseif !(dataWaivingStudyList?has_content || testingProposalStudyList?has_content)>
			No relevant information available.
		</#if>

		<#if dataWaivingStudyList?has_content || testingProposalStudyList?has_content>
	
			<#if csrRelevant??>
				<!-- Data waiving -->
				<#if dataWaivingStudyList?has_content>
				<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Data waiving</emphasis></para>
				<@studyandsummaryCom.dataWaiving dataWaivingStudyList "${tocNodeTitle}" false/>
				</#if>

				<!-- Testing proposal -->
				<#if testingProposalStudyList?has_content>
				<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
				<@studyandsummaryCom.testingProposal testingProposalStudyList "${tocNodeTitle}" false/>
				</#if>
			</#if>
		
		</#if>

		</#compress>
		</#macro>

		<#macro summaryTable _subject docType docSubType titleText discussionText>
		<#compress>

			<!-- docType and docSubType dynamically fetched when getting section documents for root entity -->
			<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "${docType}", "${docSubType}") />
			<#if summaryList?has_content>

				<!-- get the table of contents node name for the relevant document -->
				<#assign tocNodeTitle = com.tableOfContentsNodeTitle("${docType}", "${docSubType}")/>
				
				<!-- CSR EnvironmentalFateAndPathways | EnvironmentalFateAndPathways -->
				<#if docSubType="GeneticToxicity">
				<!-- Add hardcoded sub-title text from user defined macro *titleText -->
				<para><emphasis role="underline"><emphasis role="bold">${titleText} (${tocNodeTitle}):</emphasis></emphasis></para>
				</#if>

				<!-- Only print name of doc if more than one Endpoint Summary -->
				<#assign printSummaryName = summaryList?size gt 1 />

				<#list summaryList as summary>

				<!-- Check if continue to iterate Summary document if KeyInformation is entered -->
				<#assign summaryValue = checkSummaryInfo(summary)/>

					<#if summaryValue?has_content>

						<!-- Add hardcoded Discussion text from user defined macro *discussionText -->
						<@CSAValueText summary "${discussionText}" "The following information is taken into account for any hazard / risk / persistency assessment:" />

						<#if summary?has_content>

							<#if docSubType=="ToxicityToReproduction" && summary.KeyValueForChemicalSafetyAssessment.ToxicEffectType?has_content>
							<@com.emptyLine/>
								Toxic effect type (for all routes and effects - fertility / developmental toxicity): <@com.value summary.KeyValueForChemicalSafetyAssessment.ToxicEffectType/>
							</#if>				
						
							<#-- print the key information, summary name if applicable, and assessment entity -->
							<@studyandsummaryCom.endpointSummary summary "" "${docSubType}" printSummaryName/>

							<#-- print the table of summary values where applicable -->
							<@toxCSAtable summary/>
							
							<para>
								<!-- mode of action relevant to CSR only -->
								<#if csrRelevant?? && docSubType=="RepeatedDoseToxicity">
								<@studyandsummaryCom.modeOfActionRepeatedDoseToxicity summary />	
								</#if>

								<!-- relevant to CSR only -->
								<#if csrRelevant?? && docSubType=="Carcinogenicity">
								<@studyandsummaryCom.modeOfActionOtherCarcinogenicity summary />
								</#if>

								<!-- relevant to CSR only -->
								<#if csrRelevant?? && docSubType=="ToxicityToReproduction">
								<@studyandsummaryCom.modeOfActionOtherReproductiveTox summary />	
								</#if>

								<!-- relevant to CSR only -->
								<#if csrRelevant?? && docSubType=="GeneticToxicity">
								<@studyandsummaryCom.modeOfActionOtherGenetic summary />	
								</#if>
							</para>

							<#-- justification for GHS -->
							<#if csrRelevant?? && summary.hasElement("Justification") && docSubType!="AcuteToxicity">

								<#if summary.hasElement("Justification")>
									<@studyandsummaryCom.justification summary "Justification.JustifClassif"/>
								</#if>

							<#elseif csrRelevant?? && docSubType=="AcuteToxicity" && summary.hasElement("Justification")>

								<@studyandsummaryCom.justification summary "Justification.JustifClassif"/>
								<@studyandsummaryCom.justification summary "Justification.JustifClassif_STOTSE"/>	
								
							</#if>
							
							<!-- endpoint summary discussion -->
							<#if summary.hasElement("Discussion")>
								<@studyandsummaryCom.summaryAdditionalInformation summary/>
							</#if>

						</#if>
					</#if>
				</#list>

					<#if docSubType=="AcuteToxicity" && csrRelevant??>
								<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
								See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
					</#if>
			</#if>		
		</#compress>
		</#macro>


		<!-- Summary Discussion of Toxicokinetics (absorption, metabolism, distribution and elimination) -->
		<#macro toxicokineticsSummary _subject>
		<#compress>
			<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "ExposureRelatedObservationsHumans") />

			<#if summaryList?has_content>
				<para><emphasis role="HEAD-WoutNo">Summary and discussion of human information</emphasis></para>
				
					<!-- relevant to CSR only -->
					<#if csrRelevant??>
						<para>
							(Note: The following summary has been extracted from the endpoint summary of IUCLID section 7.10 Exposure related observations in humans. It may be appropriate to manually move or copy relevant part(s) to the "Summary and discussion" part of the corresponding CSR chapter(s).)
						</para>
					</#if>
				
				<#assign printSummaryName = summaryList?size gt 1 />
				<#list summaryList as summary>
					<@studyandsummaryCom.relevantStudies summary 'placeholder'/>
				</#list>
			</#if>
		</#compress>
		</#macro>

		<!-- Non-human information: for CSR basic toxicokinetics and dermal absorption but for non-CSR basic toxicokinetics only -->
		<#macro nonhumanInformationToxicokineticsStudies _subject>
		<#compress>

			<#assign studyListBasic = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "BasicToxicokinetics") />
			<#assign studyListDermal = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DermalAbsorption") />

			<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
			
			<@populateResultAndDataWaivingAndTestingProposalStudyLists studyListBasic/>
			<#assign resultStudyListBasic = resultStudyList/>
			<#assign dataWaivingStudyListBasic = dataWaivingStudyList/>
			<#assign testingProposalStudyListBasic = testingProposalStudyList/>
			
			<@populateResultAndDataWaivingAndTestingProposalStudyLists studyListDermal/>
			<#assign resultStudyListDermal = resultStudyList/>
			<#assign dataWaivingStudyListDermal = dataWaivingStudyList/>
			<#assign testingProposalStudyListDermal = testingProposalStudyList/>

			<!-- Study results -->
			<#if (csrRelevant?? && !(resultStudyListBasic?has_content || resultStudyListDermal?has_content)) || (!(csrRelevant??) && !(resultStudyListBasic?has_content))>
				No relevant information available.
			
			<#else/>			
				The results are summarised in the following table:
					
				<@com.emptyLine/>
				<table border="1">
				<#if csrRelevant??>
				<title>Studies on absorption, metabolism, distribution and elimination</title>
					<#else>
					<title>Studies on basic toxicokinetics</title>
				</#if>
					<col width="39%" />
					<col width="41%" />
					<col width="20%" />
					<tbody>
						<tr>
							<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
							<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
							<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
						</tr>

						<#list resultStudyListBasic as study>
							<tr>
								<!-- Method -->
								<td>
									<para>Basic toxicokinetics study</para>
									<@nonHumanStudyMethod study />
								</td>
								<!-- Results -->
								<td>
									<para>
									Main ADME results: <@ADMEList study.ResultsAndDiscussion.MainAdmeResults/>
									</para>

									<para>
									<@TransferList study.ResultsAndDiscussion.PharmacokineticStudies.TransferIntoOrgans/>
									</para>

									<para>
										Toxicokinetic parameters: <@ToxicokineticParametersList study.ResultsAndDiscussion.PharmacokineticStudies.ToxicokineticParameters/>
									</para>

									<para>
										Absorption: <@com.text study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnAbsorption/>
									</para>

									<para>
										Distribution: <@com.text study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnDistribution/>
									</para>

									<para>
										Excretion: <@com.text study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnExcretion/>
									</para>

									<para>
										Metabolites identified: <@com.value study.ResultsAndDiscussion.MetaboliteCharacterisationStudies.MetabolitesIdentified/>
									</para>

									<para>
										Details on metabolites: <@com.text study.ResultsAndDiscussion.MetaboliteCharacterisationStudies.DetailsOnMetabolites/>
									</para>

									<!--
									<para>
										TO DO - Evaluation of results: 	INTERPRETATION OF RESULTS NOT IN DOC - WHAT FIELD TO USE?
									</para>
									-->
								</td>
								<!-- Remarks -->
								<td>
									<@studyandsummaryCom.studyRemarksColumn study/>
								</td>
							</tr>
							
							<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
						</#list>
					
					<#if csrRelevant??>			
						<#list resultStudyListDermal as study>
							<tr>
								<!-- Method -->
								<td>
									<para>Dermal absorption study</para>
								<@nonHumanStudyMethod study/>

								</td>
								<!-- Results -->
								<td>
									<para>
										<@com.text study.ResultsAndDiscussion.AbsorptionMatrices/>
									</para>

									<para>
										Total recovery: <@com.text study.ResultsAndDiscussion.TotalRecovery/>
									</para>

									<para>
										<#if study.ResultsAndDiscussion.Absorption?has_content>
											Percutaneous absorption rate: <@PercutaneousAbsorptionRateList study.ResultsAndDiscussion.Absorption/>
										</#if>
									</para>
								</td>
								<!-- Remarks -->
								<td>
									<@studyandsummaryCom.studyRemarksColumn study/>
								</td>
							</tr>
							
							<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
						</#list>
					</#if>
					
					</tbody>
				</table>
			</#if>

			<!-- Data waiving -->
			<#if csrRelevant??>
				<#if dataWaivingStudyListBasic?has_content || dataWaivingStudyListDermal?has_content>
				<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Data waiving</emphasis></para>
				<@studyandsummaryCom.dataWaiving dataWaivingStudyListBasic "Basic toxicokinetics" false/>
				<@studyandsummaryCom.dataWaiving dataWaivingStudyListDermal "Dermal Absorption" false/>
				</#if>
				<#else/>
					<#if dataWaivingStudyListBasic?has_content>
					<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Data waiving</emphasis></para>
					<@studyandsummaryCom.dataWaiving dataWaivingStudyListBasic "Basic toxicokinetics" false/>
					</#if>
			</#if>

			<!-- Testing proposal -->
			<#if csrRelevant??>
				<#if testingProposalStudyListBasic?has_content || testingProposalStudyListDermal?has_content>
				<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
				<@studyandsummaryCom.testingProposal testingProposalStudyListBasic "Basic Toxicokinetics" false/>
				<@studyandsummaryCom.testingProposal testingProposalStudyListDermal "Dermal Absorption" false/>
				</#if>
				<#else/>
					<#if testingProposalStudyListBasic?has_content>
					<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
					<@studyandsummaryCom.testingProposal testingProposalStudyListBasic "Basic Toxicokinetics" false/>
					</#if>
			</#if>	

			<#assign studyListBasic = [] />
			<#assign studyListDermal = [] />
			<#assign resultStudyListBasic = []/>
			<#assign dataWaivingStudyListBasic = []/>
			<#assign testingProposalStudyListBasic = []/>
			<#assign resultStudyListDermal = []/>
			<#assign dataWaivingStudyListDermal = []/>
			<#assign testingProposalStudyListDermal = []/>
				
		</#compress>
		</#macro>

		<!-- Non-human information for dermal absorption only -->
		<#macro nonhumanInformationDermalAbsorptionStudies _subject>
		<#compress>

			<#assign studyListDermal = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DermalAbsorption") />

			<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
			
			<@populateResultAndDataWaivingAndTestingProposalStudyLists studyListDermal/>
			<#assign resultStudyListDermal = resultStudyList/>
			<#assign dataWaivingStudyListDermal = dataWaivingStudyList/>
			<#assign testingProposalStudyListDermal = testingProposalStudyList/>

			<!-- Study results -->
			<#if !csrRelevant?? && !resultStudyListDermal?has_content>
				No relevant information available.		
				<#else/>
					The results of studies on dermal absorption are summarised in the following table:
					
				<@com.emptyLine/>
				<table border="1">
				<title>Studies on dermal absorption</title>			
					<col width="39%" />
					<col width="41%" />
					<col width="20%" />
					<tbody>
						<tr>
							<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
							<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
							<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
						</tr>
								
						<#list resultStudyListDermal as study>
							<tr>
								<!-- Method -->
								<td>
									<para>Dermal absorption study</para>
									<@nonHumanStudyMethod study/>

								</td>
								<!-- Results -->
								<td>
									<para>
										<@com.text study.ResultsAndDiscussion.AbsorptionMatrices/>
									</para>

									<para>
										Total recovery: <@com.text study.ResultsAndDiscussion.TotalRecovery/>
									</para>

									<para>
										<#if study.ResultsAndDiscussion.Absorption?has_content>
											Percutaneous absorption rate: <@PercutaneousAbsorptionRateList study.ResultsAndDiscussion.Absorption/>
										</#if>
									</para>
								</td>
								<!-- Remarks -->
								<td>
									<@studyandsummaryCom.studyRemarksColumn study/>
								</td>
							</tr>
							
							<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
						</#list>
					</tbody>
				</table>
			</#if>

			<!-- Data waiving -->
			<#if dataWaivingStudyListDermal?has_content>
				<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Data waiving</emphasis></para>
				<@studyandsummaryCom.dataWaiving dataWaivingStudyListDermal "Dermal Absorption" false/>
			</#if>

			<!-- Testing proposal -->
			<#if testingProposalStudyListDermal?has_content>
				<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
				<@studyandsummaryCom.testingProposal testingProposalStudyListDermal "Dermal Absorption" false/>
			</#if>

			<#assign studyListDermal = [] />
			<#assign resultStudyListDermal = []/>
			<#assign dataWaivingStudyListDermal = []/>
			<#assign testingProposalStudyListDermal = []/>
				
		</#compress>
		</#macro>
				
		<!-- Human information health surveillance, epidemiological data, direct observation in clinical cases, exposure observations -->
		<#macro humanInformationToxicokineticsStudies _subject>
		<#compress>

				<#assign studyList1 = getSortedBasicToxicokineticsOrDermalAbsorption(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
				<#assign studyList2 = getSortedBasicToxicokineticsOrDermalAbsorption(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
				<#assign studyList3 = getSortedBasicToxicokineticsOrDermalAbsorption(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
				<#assign studyList4 = getSortedBasicToxicokineticsOrDermalAbsorption(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />

				<!-- Study results -->
				<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
					No relevant information available.
				<#else/>
					The exposure-related observations in humans are summarised in the following table:
					<@com.emptyLine/>
					<table border="1">
						<title>Exposure-related observations on basic toxicokinetics and/or dermal absorption in humans</title>
						<col width="39%" />
						<col width="41%" />
						<col width="20%" />
						<tbody>
							<tr>
								<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
								<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
								<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
							</tr>

							<#list studyList1 as study>
								<tr>
									<!-- Method -->
									<td>
										<@humanStudyMethod study/>
									</td>
									<!-- Results -->
									<td>
										<para>
											<@com.text study.ResultsAndDiscussion.Results/>
										</para>
									</td>
									<!-- Remarks -->
									<td>
										<@studyandsummaryCom.studyRemarksColumn study/>
									</td>
								</tr>
								<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
							</#list>
							<#list studyList2 as study>
								<tr>
									<!-- Method -->
									<td>
										<@humanStudyMethod study/>

									</td>
									<!-- Results -->
									<td>
										<para>
											<@com.text study.ResultsAndDiscussion.Results/>
										</para>
									</td>
									<!-- Remarks -->
									<td>
										<@studyandsummaryCom.studyRemarksColumn study/>
									</td>
								</tr>
								<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
							</#list>
							<#list studyList3 as study>
								<tr>
									<!-- Method -->
									<td>
										<@humanStudyMethod study/>
									</td>
									<!-- Results -->
									<td>
										<para>
											<@com.text study.ResultsAndDiscussion.RsExaminations/>
										</para>

										<para>
										Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
										</para>
									</td>
									<!-- Remarks -->
									<td>
										<@studyandsummaryCom.studyRemarksColumn study/>
									</td>
								</tr>
								<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
							</#list>
							<#list studyList4 as study>
								<tr>
									<!-- Method -->
									<td>
										<@humanStudyMethod study/>
									</td>
									<!-- Results -->
									<td>
										<para>
											<@com.text study.ResultsAndDiscussion.Results/>
										</para>
									</td>
									<!-- Remarks -->
									<td>
										<@studyandsummaryCom.studyRemarksColumn study/>
									</td>
								</tr>
								<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
							</#list>
						</tbody>
					</table>
				</#if>

				<#assign studyList1 = [] />
				<#assign studyList2 = [] />
				<#assign studyList3 = [] />
				<#assign studyList4 = [] />
				
		</#compress>
		</#macro>

		<!-- Summary and discussion of toxicokinetics -->
		<#macro toxicokineticsSummaryAndDiscussion _subject>
		<#compress>
			
			<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "Toxicokinetics") />

			<#if summaryList?has_content>	
			<#assign printSummaryName = summaryList?size gt 1 />

				<#list summaryList as summary>
					<#if summary.KeyInformation?has_content>
						<para><@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis></para>
					</#if>
					<@com.emptyLine/>					
						
					<#if printSummaryName>
						<para><emphasis role="bold"><@com.text summary.name/></emphasis></para>
					</#if>

					<para><@studyandsummaryCom.summaryKeyInformation summary/></para>
					
					<#if summary.KeyValue.Bioaccumulation.Bioaccumulation?has_content ||
					summary.KeyValue.AbsorptionOral?has_content ||
					summary.KeyValue.AbsorptionDerm?has_content ||
					summary.KeyValue.AbsorptionInhal?has_content>
					
						<@com.emptyLine/>
						<@toxCSAtable summary/>
					
					</#if>
								
					<para><@studyandsummaryCom.summaryAdditionalInformation summary/></para>
					
				</#list>
				
				<!-- relevant to CSR only -->
				<#if csrRelevant??>
					<#assign studyList1 = getSortedBasicToxicokineticsOrDermalAbsorption(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
					<#assign studyList2 = getSortedBasicToxicokineticsOrDermalAbsorption(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
					<#assign studyList3 = getSortedBasicToxicokineticsOrDermalAbsorption(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
					<#assign studyList4 = getSortedBasicToxicokineticsOrDermalAbsorption(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />

					<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
						<#else/>
						<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
						See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
						<!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
					</#if>
				</#if>

			</#if>
			
		</#compress>
		</#macro>

		<!-- Acute toxicity oral study table -->
		<#macro acuteToxicityOralStudies _subject>
		<#compress>
					
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "AcuteToxicityOral") />

			<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
			<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

			<!-- Study results -->
			<#if !resultStudyList?has_content>
				No relevant information available.
			<#else/>
				The results of studies on acute toxicity after oral administration are summarised in the following table:
				
				<@com.emptyLine/>
				<table border="1">
					<title>Studies on acute toxicity after oral administration</title>
					<col width="39%" />
					<col width="41%" />
					<col width="20%" />
					<tbody>
						<tr>
							<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
							<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
							<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
						</tr>

						<#list resultStudyList as study>
							<tr>
								<!-- Method -->
								<td>
									<@nonHumanStudyMethod study/>
								</td>
								<!-- Results -->
								<td>
									<para>
										<@EffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels)/>
									</para>
								</td>
								<!-- Remarks -->
								<td>
									<@studyandsummaryCom.studyRemarksColumn study/>
								</td>
							</tr>
							<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
						</#list>
					</tbody>
				</table>
			</#if>

			<!-- Data waiving -->
			<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Acute toxicity after oral administration"/>

			<!-- Testing proposal -->
			<@studyandsummaryCom.testingProposal testingProposalStudyList "Acute toxicity after oral administration"/>
	

</#compress>
</#macro>

<!-- Acute toxicity: inhalation study table -->
<#macro acuteToxicityInhalationStudies _subject>
<#compress>		

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "AcuteToxicityInhalation") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
		No relevant information available.
	<#else/>
		The results of studies on acute toxicity after inhalation exposure are summarised in the following table:
		<@com.emptyLine/>
		<table border="1">
			<title>Studies on acute toxicity after inhalation exposure</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
						<@nonHumanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Acute toxicity after inhalation exposure"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Acute toxicity after inhalation exposure"/>

</#compress>
</#macro>

<!-- Acute toxicity: dermal study table -->
<#macro acuteToxicityDermalStudies _subject>
<#compress>

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "AcuteToxicityDermal") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
		No relevant information available.
	<#else/>
		The results of studies on acute toxicity after dermal administration are summarised in the following table:
		
		<@com.emptyLine/>
		<table border="1">
			<title>Studies on acute toxicity after dermal administration</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Acute toxicity after dermal administration"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Acute toxicity after dermal administration"/>

</#compress>
</#macro>

<!-- Acute toxicity: other routes study table -->
<#macro acuteToxicityOtherRoutesStudies _subject> 
<#compress>		
			
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "AcuteToxicityOtherRoutes") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
		No relevant information available.
	<#else/>
		The results of studies on acute toxicity (other routes) are summarised in the following table:
		
		<@com.emptyLine/>
		<table border="1">
			<title>Studies on acute toxicity (other routes)</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Acute toxicity (other routes)"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Acute toxicity (other routes)"/>

</#compress>
</#macro>

<!-- Human information acute toxicity -->
<#macro acuteToxicityHumanInformationStudies _subject> 
<#compress>		

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedAcuteToxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedAcuteToxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedAcuteToxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedAcuteToxicity(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
		No relevant information available.
	<#else/>
		The exposure-related observations in humans are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations on acute toxicity in humans</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>

						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
							 Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>
	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />

</#compress>
</#macro>

<!-- Summary and discussion of acute toxicity -->
<#macro acuteToxicitySummaryStudies _subject>
<#compress>

	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "AcuteToxicity") />
	<#if summaryList?has_content>
	<#list summaryList as summary>
	<#assign printSummaryName = summaryList?size gt 1 />
	
		<#if summary.KeyInformation.KeyInformation?has_content>
			<@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis>
		</#if>	

		<#if printSummaryName>
			<emphasis role="bold"><@com.text summary.name/></emphasis>
		</#if>

		<@studyandsummaryCom.summaryKeyInformation summary/>

		<!-- get CSA values for each route -->
		<@toxCSAtable summary/>

		<@studyandsummaryCom.summaryAdditionalInformation summary/>
		<@justification summary "Justification.JustifClassif"/>
	</#list>	
	
		<!-- relevant to CSR only -->
		<#if csrRelevant??>	
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
			<#assign studyList1 = getSortedAcuteToxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
			<#assign studyList2 = getSortedAcuteToxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
			<#assign studyList3 = getSortedAcuteToxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
			<#assign studyList4 = getSortedAcuteToxicity(studyList) />

			<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
				<#else/>
					<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
					See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
					<!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
			</#if>
		</#if>

	</#if>
	
</#compress>
</#macro>

<!-- Skin irritation non-human information study table -->
<#macro skinIrritationNonHumanStudies _subject>
<#compress>

	<#assign studyListUnsorted = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "SkinIrritationCorrosion") />
	<#assign studyList = getSortedSkinIrritationNonHuman(studyListUnsorted, ["skin irritation: in vitro / ex vivo", "skin irritation: in vivo", "skin irritation / corrosion, other"] ) />			
	
	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
		No relevant information available.
		<#else/>
			The results of studies on skin irritation are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on skin irritation</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

					<#list resultStudyList as study>

					<#--TODO Could be possible improved with incorporating the condition in the previous call, i.e. populateResultAndDataWaivingAndTestingProposalStudyLists. It prints empty tables if none of the studies are Irrotation -->
						<tr>
							<!-- Method -->
							<td>
								<@nonHumanStudyMethod study />
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.value study.ApplicantSummaryAndConclusion.InterpretationOfResults/>
								</para>

								<para>
									<@inVitroList study.ResultsAndDiscussion.InVitro.Results/>
								</para>

								<para>
									<@inVivoList study.ResultsAndDiscussion.InVivo.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
			</tbody>
		</table>

		<#list resultStudyList as study>
			<para>
				Studies with results indicating corrosivity to the skin are summarised in section 5.4 Corrosivity.
			</para>
			<#break>
		</#list>

	</#if>

	<!-- Data waiving -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyListUnsorted/>
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Skin Irritation"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Skin Irritation"/>

</#compress>
</#macro>		

<!-- Human information Skin irritation -->
<#macro skinIrritationHumanStudies _subject>
<#compress>
		
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedSkinIrritation(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedSkinIrritation(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedSkinIrritation(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedSkinIrritation(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
		No relevant information available.
	<#else/>
		The exposure-related observations in humans are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations on skin irritation in humans</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
							 Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<para>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</para>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>
	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />

</#compress>
</#macro>	
	
<!-- Eye irritation non-human information study table -->
<#macro eyeIrritationNonHumanStudies _subject>
<#compress>
	
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EyeIrritation") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
		No relevant information available.
		<#else/>
			The results of studies on eye irritation are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on eye irritation</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
				
					<tr>
						<!-- Method -->
						<td>
							<#if com.picklistValueMatchesPhrases(study.AdministrativeData.Endpoint, ["eye irritation: in vitro / ex vivo"])>
							<para>in vitro study</para>
							</#if>

							<@nonHumanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.value study.ApplicantSummaryAndConclusion.InterpretationOfResults/>
							</para>
							
							<@EyeIrritationInVitroList study.ResultsAndDiscussion.InVitro.ResultsOfExVivoInVitroStudy/>
							
							<@EyeIrritationInVivoList study.ResultsAndDiscussion.InVivo.IrritationCorrosionResults/>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Eye Irritation"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Eye Irritation"/>

</#compress>
</#macro>

<!-- Eye irritation Human information -->
<#macro eyeIrritationHumanStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedEyeIrritation(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedEyeIrritation(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedEyeIrritation(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedEyeIrritation(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
	No relevant information available.
	<#else/>
		The exposure-related observations in humans are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations on eye irritation in humans</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
							 Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>
	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />
	
</#compress>
</#macro>

<!-- Human information Respiratory tract human information -->
<#macro respiratoryTractHumanStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedRespiratoryTract(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedRespiratoryTract(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedRespiratoryTract(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedRespiratoryTract(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
		No relevant information available.
	<#else/>
		The exposure-related observations in humans are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations on respiratory irritation in humans</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>

						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
							 Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>
	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />

</#compress>
</#macro>

<!-- Summary and discussion of irritation -->
<#macro irritationSummary _subject>
<#compress>	

	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "IrritationCorrosion") />

	<#if summaryList?has_content>
	<#assign printSummaryName = summaryList?size gt 1 />

		<#list summaryList as summary>
			
			<#if summary.KeyInformation.KeyInformation?has_content>
				<para><@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis></para>
			</#if>
			<@com.emptyLine/>
			
			<#if printSummaryName>
				<para><emphasis role="bold"><@com.text summary.name/></emphasis></para>
			</#if>

			<para><@studyandsummaryCom.summaryKeyInformation summary/></para>

			<!-- get CSA values for each route -->
			<@toxCSAtable summary/>

			<#if summary.hasElement("Discussion")>
				<@studyandsummaryCom.summaryAdditionalInformation summary/>
			</#if>	

			<@justification summary "Remarks"/>

		</#list>
		
		<!-- relevant to CSR only -->
		<#if csrRelevant??>
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
			<#assign studyList1 = getSortedRespiratoryTract(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
			<#assign studyList2 = getSortedRespiratoryTract(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
			<#assign studyList3 = getSortedRespiratoryTract(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
			<#assign studyList4 = getSortedRespiratoryTract(studyList) />

			<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
				<#else/>
					<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
					See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
					<!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
			</#if>
		</#if>
		
	</#if>

</#compress>
</#macro>

<!-- Corrosivity non human information study table -->
<#macro corrosivityNonHumanStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "SkinIrritationCorrosion") />
	<#assign studyList = getSortedSkinCorrosionNonHuman(studyList, ["skin corrosion: in vitro / ex vivo", "skin irritation / corrosion.*"] ) />
	
	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
		No relevant information available.
		<#else/>
			The results of studies on skin irritation related to corrosivity are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on skin irritation related to corrosivity</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

					<#list resultStudyList as study>

					<#--TODO Could be possible improved with incorporating the condition in the previous call, i.e. populateResultAndDataWaivingAndTestingProposalStudyLists. It prints empty tables if none of the studies are Irrotation -->
						<tr>
							<!-- Method -->
							<td>
								<@nonHumanStudyMethod study/>
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.value study.ApplicantSummaryAndConclusion.InterpretationOfResults/>
								</para>

								<para>
									<@inVitroList study.ResultsAndDiscussion.InVitro.Results/>
								</para>

								<para>
									<@inVivoList study.ResultsAndDiscussion.InVivo.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
			</tbody>
		</table>

	</#if>
	
	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Skin irritation"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Skin irritation"/>
			
</#compress>
</#macro>

<!-- Human information Corrosivity -->
<#macro corrosivityHumanStudies _subject>
<#compress>

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "SkinIrritationCorrosion") />
	<#assign studyList1 = getSortedSkinCorrosionNonHuman(studyList, ["skin corrosion: in vitro / ex vivo"]) />		
	
	<#if !(studyList1?has_content)>
		No relevant information available.
		<#else/>			
	
		<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
		<#assign studyList2 = getSortedSkinCorrosion(studyList) />		
		<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
		<#assign studyList3 = getSortedSkinCorrosion(studyList) />		
		<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
		<#assign studyList4 = getSortedSkinCorrosion(studyList) />		
		<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
		<#assign studyList5 = getSortedSkinCorrosion(studyList) />			
				
		<!-- Study results -->
		<#if !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content) && !(studyList5?has_content)>
		No relevant information available.
			
			<#else/>
			The exposure-related observations in humans are summarised in the following table:

			<@com.emptyLine/>
			<table border="1">
				<title>Exposure-related observations on corrosivity in humans</title>
				<col width="39%" />
				<col width="41%" />
				<col width="20%" />
				<tbody>
					<tr>
						<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
						<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
						<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
					</tr>							
					
					<#list studyList2 as study>
						<tr>
							<!-- Method -->
							<td>
								<@humanStudyMethod study/>
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
					<#list studyList3 as study>
						<tr>
							<!-- Method -->
							<td>
								<@humanStudyMethod study/>

							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
					<#list studyList4 as study>
						<tr>
							<!-- Method -->
							<td>
								<@humanStudyMethod study/>
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.RsExaminations/>
								</para>

								<para>
								 Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
					<#list studyList5 as study>
						<tr>
							<!-- Method -->
							<td>
								<@humanStudyMethod study/>
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
				</tbody>
			</table>
		</#if>
	</#if>
		
	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />
	<#assign studyList5 = [] />
		
</#compress>
</#macro>

<!-- Summary and discussion of corrosion -->
<#macro corrosivitySummary _subject>
<#compress>

	<!-- relevant to CSR only -->
	<#if csrRelevant??>

		<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "SkinIrritationCorrosion") />	

		<#if studyList?has_content>
			<#list studyList as study>
			<@com.text study.name/>
				<para>
					The studies with results indicating corrosivity are discussed in section 5.3.4 Summary and discussion of irritation.
				</para>
				<#break>
			</#list>
		</#if>

		<#else>
			<!-- for non CSR users, the summary for corrosion is part of macro irritationSummary -->
			The studies with results indicating corrosivity are discussed in the Summary and discussion of irritation.
	</#if>
	
</#compress>
</#macro>

<!-- Sensitisation study table -->
<#macro skinSensitisationNonHumanStudies _subject>
<#compress>

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "SkinSensitisation") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	 No relevant information available.
	<@com.emptyLine/>
	<#else/>
		The results of studies on skin sensitisation are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on skin sensitisation</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.value study.ApplicantSummaryAndConclusion.InterpretationOfResults/>
							</para>

							<para>
							<#local endpoint><@com.value study.AdministrativeData.Endpoint/></#local>
								<#if study.ResultsAndDiscussion.InVivoLLNA.Results?has_content>								
								 <@inVivoLLNAList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.InVivoLLNA.Results) endpoint />
								</#if>
							</para>

							<para>
								<@inVivoNonLLNAList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TraditionalSensitisationTest.ResultsOfTest) endpoint/>
							</para>

							<para>
								<@inVitroLLNAList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.InVitroInChemico.Results) endpoint />
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Skin Sensitisation"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Skin Sensitisation"/>

</#compress>
</#macro>

<!-- Human information Skin sensitisation -->
<#macro skinSensitisationHumanStudies _subject>
<#compress>
      
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "SensitisationData") />
	<#assign studyList1 = getSortedSkinSensitisation(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList2 = getSortedSkinSensitisationEndpoint(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList3 = getSortedSkinSensitisationEndpoint(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList4 = getSortedSkinSensitisationEndpoint(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList5 = getSortedSkinSensitisationEndpoint(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content) && !(studyList5?has_content)>
	 No relevant information available.
	<@com.emptyLine/>
	<#else/>
		The exposure-related observations in humans are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations on skin sensitisation in humans</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
						<@humanStudyMethod study/>

						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
							 Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList5 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>
	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />
	<#assign studyList5 = [] />

</#compress>
</#macro>

<!-- Respiratory system non human study table -->
<#macro respiratorySensitisationNonHumanStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "RespiratorySensitisation") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<#else/>
		The results of studies on respiratory sensitisation are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on respiratory sensitisation</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
						<#if com.picklistValueMatchesPhrases(study.AdministrativeData.Endpoint, ["respiratory sensitisation: in vitro", "respiratory sensitisation: in chemico"])>
							<para>in vitro study</para>							
						</#if>

						<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.value study.ApplicantSummaryAndConclusion.InterpretationOfResults/>
							</para>

							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Respiratory Sensitisation"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Respiratory Sensitisation"/>

</#compress>
</#macro>

<!-- Human information Respiratory sensitisation -->
<#macro respiratorySensitisationHumanStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "SensitisationData") />
	<#assign studyList1 = getSortedSkinSensitisationRespiratory(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList2 = getSortedRespiratorySensitisationEndpoint(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList3 = getSortedRespiratorySensitisationEndpoint(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList4 = getSortedRespiratorySensitisationEndpoint(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList5 = getSortedRespiratorySensitisationEndpoint(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content) && !(studyList5?has_content)>
	No relevant information available.
	<#else/>
		The exposure-related observations in humans are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations on respiratory sensitisation in humans</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>

						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
							 Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList5 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>
	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />
	<#assign studyList5 = [] />

</#compress>
</#macro>

<!-- Summary and discussion of sensitisation -->
<#macro sensitisationSummary _subject>
<#compress>	

	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "Sensitisation") />

	<#if summaryList?has_content>
	<#assign printSummaryName = summaryList?size gt 1 />
            
		<#list summaryList as summary>
			
			<#if summary.KeyInformation.KeyInformation?has_content>
			<para><@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis></para>	
				<@studyandsummaryCom.summaryKeyInformation summary/>
			</#if>

		</#list>
	
		<!-- relevant to CSR only -->
		<#if csrRelevant??>        
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "SensitisationData") />
			<#assign studyList1 = getSortedSkinSensitisationRespiratory(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
			<#assign studyList2 = getSortedRespiratorySensitisationEndpoint(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
			<#assign studyList3 = getSortedRespiratorySensitisationEndpoint(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
			<#assign studyList4 = getSortedRespiratorySensitisationEndpoint(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
			<#assign studyList5 = getSortedRespiratorySensitisationEndpoint(studyList) />

			<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content) && !(studyList5?has_content)>
				<#else/>
				<@com.emptyLine/>
					<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
					See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
					<!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
			</#if>
		</#if>
	
		<#if summaryList?has_content>
			<#assign printSummaryName = summaryList?size gt 1 />
			
			<#list summaryList as summary>
				<#if summary.KeyInformation.KeyInformation?has_content>
					<@com.emptyLine/>
					<para><@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis></para>
				</#if>
				
				<!-- get CSA values for each route -->
				<@toxCSAtable summary/>

				<#if summary.hasElement("Discussion")>
					<@studyandsummaryCom.summaryAdditionalInformation summary/>
				</#if>	

				<@justification summary "Remarks"/>
			</#list>
		</#if>

		<!-- relevant to CSR only -->
		<#if csrRelevant??>		
			<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content) && !(studyList5?has_content)>
				<#else/>
					<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
					See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
					<!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
			</#if>		
		</#if>
		
	</#if>

</#compress>
</#macro>

<!-- Repeated dose toxicity study table -->
<#macro repeatedDoseToxicityOralStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "RepeatedDoseToxicityOral") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<#else/>
		The results of studies are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on repeated dose toxicity after oral administration</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>

							<para>
								<@TargetSystemOrganToxList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TargetSystemOrganToxicity.TargetSystemOrganToxicity)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<#list dataWaivingStudyList as study>
		<#assign endpoint = determineEndpointTextRepeatedDose(study.AdministrativeData.Endpoint, ["short-term repeated dose toxicity: oral", "sub-chronic toxicity: oral"], ["short-term toxicity study (28 days) (oral)", "sub-chronic toxicity study (90 days) (oral)"], "Repeated dose toxicity after oral administration" )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Data waiving</emphasis></para>
		<@studyandsummaryCom.dataWaivingRecord study endpoint/>
	</#list>

	<!-- Testing proposal -->
	<#list testingProposalStudyList as study>
		<#assign endpoint = determineEndpointTextRepeatedDose(study.AdministrativeData.Endpoint, ["short-term repeated dose toxicity: oral", "sub-chronic toxicity: oral", "chronic toxicity: oral"], ["short-term toxicity study (28 days) (oral)", "sub-chronic toxicity study (90 days) (oral)", "chronic toxicity study (oral)"], "Repeated dose toxicity after oral administration" )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
		<@studyandsummaryCom.testingProposalRecord study endpoint/>
	</#list>

</#compress>
</#macro>

<!-- Repeated dose toxicity inhalation study table -->
<#macro repeatedDoseToxicityInhalationStudies _subject>
<#compress>			
		
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "RepeatedDoseToxicityInhalation") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<@com.emptyLine/>
	<#else/>
		The results of studies are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on repeated dose toxicity after inhalation exposure</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>

							<para>
								<@TargetSystemOrganToxList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TargetSystemOrganToxicity.TargetSystemOrganToxicity)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<#list dataWaivingStudyList as study>
		<#assign endpoint = determineEndpointTextRepeatedDose(study.AdministrativeData.Endpoint, ["short-term repeated dose toxicity: inhalation", "sub-chronic toxicity: inhalation"], ["short-term toxicity study (28 days) (inhalation)", "sub-chronic toxicity study (90 days) (inhalation)"], "Repeated dose toxicity after inhalation exposure" )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Data waiving</emphasis></para>
		<@studyandsummaryCom.dataWaivingRecord study endpoint/>
	</#list>

	<!-- Testing proposal -->
	<#list testingProposalStudyList as study>
		<#assign endpoint = determineEndpointTextRepeatedDose(study.AdministrativeData.Endpoint, ["short-term repeated dose toxicity: inhalation", "sub-chronic toxicity: inhalation", "chronic toxicity: inhalation"], ["short-term toxicity study (28 days) (inhalation)", "sub-chronic toxicity study (90 days) (inhalation)", "chronic toxicity study (inhalation)"], "Repeated dose toxicity after inhalation exposure" )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
		<@studyandsummaryCom.testingProposalRecord study endpoint/>
	</#list>

</#compress>
</#macro>

<!-- Repeated dose toxicity dermal study table -->
<#macro repeatedDoseToxicityDermalStudies _subject>
<#compress>		
						
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "RepeatedDoseToxicityDermal") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.

	<#else/>
		The results of studies are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on repeated dose toxicity after dermal administration</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>

							<para>
								<@TargetSystemOrganToxList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TargetSystemOrganToxicity.TargetSystemOrganToxicity)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<#list dataWaivingStudyList as study>
		<#assign endpoint = determineEndpointTextRepeatedDose(study.AdministrativeData.Endpoint, ["short-term repeated dose toxicity: dermal", "sub-chronic toxicity: dermal"], ["short-term toxicity study (28 days) (dermal)", "sub-chronic toxicity study (90 days) (dermal)"], "Repeated dose toxicity after dermal administration" )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Data waiving</emphasis></para>
		<@studyandsummaryCom.dataWaivingRecord study endpoint/>
	</#list>

	<!-- Testing proposal -->
	<#list testingProposalStudyList as study>
		<#assign endpoint = determineEndpointTextRepeatedDose(study.AdministrativeData.Endpoint, ["short-term repeated dose toxicity: dermal", "sub-chronic toxicity: dermal", "chronic toxicity: dermal"], ["short-term toxicity study (28 days) (dermal)", "sub-chronic toxicity study (90 days) (dermal)", "chronic toxicity study (dermal)"], "Repeated dose toxicity after dermal administration" )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
		<@studyandsummaryCom.testingProposalRecord study endpoint/>
	</#list>

</#compress>
</#macro>

<!-- Repeated dose toxicity: other routes study table -->
<#macro repeatedDoseToxicityOtherRoutesStudies _subject>
<#compress>			

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "RepeatedDoseToxicityOther") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<@com.emptyLine/>
	<#else/>
		The results of studies on repeated dose toxicity (other routes) are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on repeated dose toxicity (other routes)</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>

							<para>
								<@TargetSystemOrganToxList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TargetSystemOrganToxicity.TargetSystemOrganToxicity)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Repeated Dose Toxicity"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Repeated Dose Toxicity"/>

</#compress>
</#macro>

<!-- Human information Repeated dose toxicity -->
<#macro repeatedDoseToxicityHumanStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedRepeatedDoseToxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedRepeatedDoseToxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedRepeatedDoseToxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedRepeatedDoseToxicity(studyList) />

		<!-- Study results -->
		<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content) >
		No relevant information available.
		<#else/>
			The exposure-related observations in humans are summarised in the following table:

			<@com.emptyLine/>
			<table border="1">
				<title>Exposure-related observations on repeated dose toxicity in humans</title>
				<col width="39%" />
				<col width="41%" />
				<col width="20%" />
				<tbody>
					<tr>
						<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
						<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
						<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
					</tr>

					<#list studyList1 as study>
						<tr>
							<!-- Method -->
							<td>
								<@humanStudyMethod study/>
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
					<#list studyList2 as study>
						<tr>
							<!-- Method -->
							<td>
								<@humanStudyMethod study/>
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
					<#list studyList3 as study>
						<tr>
							<!-- Method -->
							<td>
								<@humanStudyMethod study/>

							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.RsExaminations/>
								</para>

								<para>
								 Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
					<#list studyList4 as study>
						<tr>
							<!-- Method -->
							<td>
								<@humanStudyMethod study/>
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
				</tbody>
			</table>
		</#if>
		
		<#assign studyList1 = [] />
		<#assign studyList2 = [] />
		<#assign studyList3 = [] />
		<#assign studyList4 = [] />

</#compress>
</#macro>

<!-- Summary and discussion of repeated dose toxicity -->
<#macro repeatedDoseToxicitySummary _subject>
<#compress>	

	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "RepeatedDoseToxicity") />

	<#if summaryList?has_content>
	<#assign printSummaryName = summaryList?size gt 1 />	

		<#list summaryList as summary>
		
		<#if summary.KeyInformation.KeyInformation?has_content>
		<para><@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis></para>
		</#if>
		<@com.emptyLine/>
						
				<@studyandsummaryCom.summaryKeyInformation summary/>
			
				
				<#if summary.KeyValueForChemicalSafetyAssessment.ToxicEffectType?has_content>
				<@com.emptyLine/>
				Toxic effect type (for all routes and effects): <#assign toxicEffect><@com.value summary.KeyValueForChemicalSafetyAssessment.ToxicEffectType/></#assign>${toxicEffect}
				</#if>

				<!-- get CSA values for each route -->
				<@toxCSAtable summary/>

			<para>
				<@justification summary "Remarks"/>					
			</para>			
				
				<!-- relevant to CSR only -->
				<#if csrRelevant??>
				<@studyandsummaryCom.modeOfActionRepeatedDoseToxicity summary />	
				</#if>

				<#if summary.hasElement("Discussion")>
				<@studyandsummaryCom.summaryAdditionalInformation summary/>
				</#if>
		</#list>		
		
		<!-- relevant to CSR only -->
		<#if csrRelevant??>
		
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
			<#assign studyList1 = getSortedRepeatedDoseToxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
			<#assign studyList2 = getSortedRepeatedDoseToxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
			<#assign studyList3 = getSortedRepeatedDoseToxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
			<#assign studyList4 = getSortedRepeatedDoseToxicity(studyList) />

			<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
				<#else/>
					<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
					See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
					<!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
			</#if>
		
		</#if>

	</#if>

</#compress>
</#macro>	
	
<!-- Mutagenicity non human information in vitro study table -->
<#macro mutagenicityNonHumanInVitroStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "GeneticToxicityVitro") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<#else/>
		The results of in vitro genotoxicity studies are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>In vitro genotoxicity studies:</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>	
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@TestResultsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TestRs)/>
								<#assign remarksOnResults = study.ResultsAndDiscussion.RemarksOnResults>
									<#if remarksOnResults?has_content>
									Remarks: <@com.value study.ResultsAndDiscussion.RemarksOnResults/>
									</#if>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<#list dataWaivingStudyList as study>
		<#assign endpoint = determineEndpointTextTypeOfAssay(study, "In vitro genotoxicity: " )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Data waiving</emphasis></para>
		<@studyandsummaryCom.dataWaivingRecord study endpoint/>
	</#list>

	<!-- Testing proposal -->
	<#list testingProposalStudyList as study>
		<#assign endpoint = determineEndpointTextTypeOfAssay(study, "In vitro genotoxicity: " )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
		<@studyandsummaryCom.testingProposalRecord study endpoint/>
	</#list>

</#compress>
</#macro>

<!-- Mutagenicity non human information in vivo study table -->
<#macro mutagenicityNonHumanInVivoStudies _subject>
<#compress>		

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "GeneticToxicityVivo") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<#else/>
		The results of in vivo genotoxicity studies are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>In vivo genotoxicity studies</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@TestResultsInVivoList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TestRs)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<#list dataWaivingStudyList as study>
		<#assign endpoint = determineEndpointTextStudyType(study, "In vivo genotoxicity: " )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Data waiving</emphasis></para>
		<@studyandsummaryCom.dataWaivingRecord study endpoint/>
	</#list>

	<!-- Testing proposal -->
	<#list testingProposalStudyList as study>
		<#assign endpoint = determineEndpointTextStudyType(study, "In vivo genotoxicity: " )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
		<@studyandsummaryCom.testingProposalRecord study endpoint/>
	</#list>

</#compress>
</#macro>

<!-- Human information Mutagenicity -->
<#macro mutagenicityHumanStudies _subject>
<#compress>	

<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
<#assign studyList1 = getSortedGeneticToxicity(studyList) />
<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
<#assign studyList2 = getSortedGeneticToxicity(studyList) />
<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
<#assign studyList3 = getSortedGeneticToxicity(studyList) />
<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
<#assign studyList4 = getSortedGeneticToxicity(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
	No relevant information available.
	<#else/>
		The exposure-related observations in humans are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations genetic toxicity in humans</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>

						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
								Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study/>
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />

</#compress>
</#macro>

<!-- Summary and discussion of mutagenicity -->
<#macro mutagenicitySummary _subject>
<#compress>	

	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "GeneticToxicity") />

	<#if summaryList?has_content>
	<#assign printSummaryName = summaryList?size gt 1 />
	
		<#list summaryList as summary>
			<#if printSummaryName>
				<para><emphasis role="bold"><@com.text summary.name/></emphasis></para>
			</#if>
			
			<!-- in vitro -->
			
			<#if summary.KeyInformation.KeyInformation?has_content>
			<para><emphasis role="underline">The following information is taken into account for any hazard / risk assessment (genetic toxicity in vitro):</emphasis></para>
				<para><@com.richText summary.KeyInformation.KeyInformation/></para>
			</#if>
			
			<!-- in vivo -->				
			
			<#if summary.KeyInformation.KeyInformation?has_content>
			<para><emphasis role="underline">The following information is taken into account for any hazard / risk assessment (genetic toxicity in vivo):</emphasis></para>
				<para><@com.richText summary.KeyInformation.KeyInformation/></para>
			</#if>

			<!-- get CSA values for each route -->
			<@toxCSAtable summary/>
				
			<#if summary.Justification.JustifClassif?has_content>
			<@com.emptyLine/>
				<para><emphasis role="bold"><emphasis role="underline">Justification for classification or non classification</emphasis></emphasis></para>
				<para><@com.richText summary.Justification.JustifClassif/></para>
			</#if>
			
			<#if summary.Discussion.Discussion?has_content>
				<para>
					<emphasis role="underline">Additional information:</emphasis>
					<@com.richText summary.Discussion.Discussion/>
				</para>
			</#if>
			
				<!-- relevant to CSR only -->
				<#if csrRelevant??>
				<@studyandsummaryCom.modeOfActionOtherGenetic summary />
				</#if>
		
		</#list>
			
			<!-- relevant to CSR only -->
			<#if csrRelevant??>						
				<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
				<#assign studyList1 = getSortedGeneticToxicity(studyList) />
				<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
				<#assign studyList2 = getSortedGeneticToxicity(studyList) />
				<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
				<#assign studyList3 = getSortedGeneticToxicity(studyList) />
				<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
				<#assign studyList4 = getSortedGeneticToxicity(studyList) />

				<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
					<#else/>
						<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
						See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
						<!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
				</#if>				
			</#if>
		
	</#if>

</#compress>
</#macro>

<!-- Carcinogenicity non human oral study table -->
<#macro carcinogenicityNonHumanOralStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "Carcinogenicity") />
	<#assign studyList1 = getSortedCarcinogenicityOral(studyList) />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList1/>
		
	<!-- Study results -->
	<#if !(resultStudyList?has_content)>
	No relevant information available.
	<#else/>
		The results of studies on carcinogenicity after oral administration are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on carcinogenicity after oral administration</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
				<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>
	
	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Carcinogenicity after oral administration" true/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Carcinogenicity after oral administration" true/>
	
	<#assign studyList = [] />
	<#assign studyList1 = [] />
	
</#compress>
</#macro>

<!-- Carcinogenicity non human inhalation study table -->
<#macro carcinogenicityNonHumanInhalationStudies _subject>
<#compress>			

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "Carcinogenicity") />
	<#assign studyList = getSortedCarcinogenicityInhalation(studyList) />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !(resultStudyList?has_content)>
	No relevant information available.
	<#else/>
		The results of studies on carcinogenicity after inhalation exposure are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on carcinogenicity after inhalation exposure</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Carcinogenicity after inhalation exposure"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Carcinogenicity after inhalation exposure"/>

	<#assign studyList = [] />

</#compress>
</#macro>

<!-- Carcinogenicity non human dermal study table -->
<#macro carcinogenicityNonHumanDermalStudies _subject>
<#compress>
		
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "Carcinogenicity") />
	<#assign studyList = getSortedCarcinogenicityDermal(studyList) />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !(resultStudyList?has_content)>
	No relevant information available.
	<#else/>
		The results of studies on carcinogenicity after dermal administration are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on carcinogenicity after dermal administration</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Carcinogenicity after dermal administration"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Carcinogenicity after dermal administration"/>

	<#assign studyList = [] />

</#compress>
</#macro>

<!-- Carcinogenicity non human other routes study table -->
<#macro carcinogenicityNonHumanOtherRoutesStudies _subject>
<#compress>

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "Carcinogenicity") />
	<#assign studyList = getSortedCarcinogenicityOther(studyList) />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !(resultStudyList?has_content)>
	No relevant information available.
	<#else/>
		The results of studies on carcinogenicity (other routes) are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on carcinogenicity (other routes)</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Carcinogenicity (other routes)"/>

	<!-- Testing proposal -->
	<#list testingProposalStudyList as study>
		<#assign endpoint = determineEndpointTextRouteOfAdministration(study, "Carcinogenicity " )/>
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
		<@studyandsummaryCom.testingProposalRecord study endpoint/>
	</#list>

	<#assign studyList = [] />

</#compress>
</#macro>

<!-- Human information Carcinogenicity -->
<#macro carcinogenicityHumanStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedCarcinogenicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedCarcinogenicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedCarcinogenicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedCarcinogenicity(studyList) />

		<!-- Study results -->
		<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
		No relevant information available.
		<#else/>
			The exposure-related observations in humans are summarised in the following table:

			<@com.emptyLine/>
			<table border="1">
				<title>Exposure-related observations on carcinogenicity in humans</title>
				<col width="39%" />
				<col width="41%" />
				<col width="20%" />
				<tbody>
					<tr>
						<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
						<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
						<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
					</tr>

					<#list studyList1 as study>
						<tr>
							<!-- Method -->
							<td>
								
								<@humanStudyMethod study />
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
					<#list studyList2 as study>
						<tr>
							<!-- Method -->
							<td>
								
								<@humanStudyMethod study />
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
					<#list studyList3 as study>
						<tr>
							<!-- Method -->
							<td>
								
								<@humanStudyMethod study />
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.RsExaminations/>
								</para>

								<para>
									Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
					<#list studyList4 as study>
						<tr>
							<!-- Method -->
							<td>
								
								<@humanStudyMethod study />
							</td>
							<!-- Results -->
							<td>
								<para>
									<@com.text study.ResultsAndDiscussion.Results/>
								</para>
							</td>
							<!-- Remarks -->
							<td>
								<@studyandsummaryCom.studyRemarksColumn study/>
							</td>
						</tr>
						<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
					</#list>
				</tbody>
			</table>
		</#if>

		<#assign studyList1 = [] />
		<#assign studyList2 = [] />
		<#assign studyList3 = [] />
		<#assign studyList4 = [] />

</#compress>
</#macro>

<!-- Summary and discussion of carcinogenicity -->
<#macro carcinogenicitySummary _subject>
<#compress>	

	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "Carcinogenicity") />

	<#if summaryList?has_content>
	<#assign printSummaryName = summaryList?size gt 1 />
	
		<#list summaryList as summary>
		<#if summary?has_content>
		
			<#if summary.KeyInformation.KeyInformation?has_content>
			<para><@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis></para>
			</#if>
			
			<#if printSummaryName>
			<emphasis role="bold"><@com.text summary.name/></emphasis>
			</#if>
		
			<para>
				<@com.richText summary.KeyInformation.KeyInformation/>
			</para>			
			
				<!-- get CSA values for each route -->
				<@toxCSAtable summary/>
				
			<@justification summary "Justification.JustifClassif"/>

			<#if summary.hasElement("Discussion")>
				<@studyandsummaryCom.summaryAdditionalInformation summary/>
			</#if>	
				
			<!-- relevant to CSR only -->
			<#if csrRelevant??>
			<@studyandsummaryCom.modeOfActionOtherCarcinogenicity summary />
			</#if>
			
		</#if>	
		</#list>
		
		<!-- relevant to CSR only -->
		<#if csrRelevant??>        
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
			<#assign studyList1 = getSortedCarcinogenicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
			<#assign studyList2 = getSortedCarcinogenicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
			<#assign studyList3 = getSortedCarcinogenicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
			<#assign studyList4 = getSortedCarcinogenicity(studyList) />

			<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
				<#else/>
					<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
					See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
					<!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
			</#if>			
		</#if>

	</#if>

</#compress>
</#macro>

<!-- Toxicity for reproduction non human, studies on fertility -->
<#macro toxicityForReproductionFertilityNonHumanStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ToxicityReproduction") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<#else/>
		The results of studies on fertility are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on fertility</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<#if study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.EffectLevelsP0.Efflevel?has_content || study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.TargetSystemOrganToxicityP0.TargetSystemOrganToxicity?has_content>
							<para>
							<emphasis role="bold">First parental generation (P0)</emphasis>
							</para>
								<#if study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.EffectLevelsP0.Efflevel?has_content>
								<para>
								<@EffectLevelsPoList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.EffectLevelsP0.Efflevel)/>
								</para>
								</#if>
								<#if study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.TargetSystemOrganToxicityP0.TargetSystemOrganToxicity?has_content>
								<para>
								<@TargetSystemOrganToxforEffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration.TargetSystemOrganToxicityP0.TargetSystemOrganToxicity)/>
								</para>
								</#if>
							</#if>
							

							<#if study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.EffectLevelsP1.Efflevel?has_content || study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.TargetSystemOrganToxicityP1.TargetSystemOrganToxicity?has_content>
							<para>
							<emphasis role="bold">Second parental generation (P1)</emphasis>
							</para>
								<#if study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.EffectLevelsP1.Efflevel?has_content>
								<para>
								<@SecondparentalGenerationP1List studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.EffectLevelsP1.Efflevel)/>
								</para>
								</#if>
								<#if study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.TargetSystemOrganToxicityP1.TargetSystemOrganToxicity?has_content>
								<para>
								<@TargetSystemOrganToxforEffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration.TargetSystemOrganToxicityP1.TargetSystemOrganToxicity)/>
								</para>
								</#if>
							</#if>				


							<#if study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.EffectLevelsF1.Efflevel?has_content || study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.TargetSystemOrganToxicityF1.TargetSystemOrganToxicity?has_content>
							<para>
							<emphasis role="bold">F1 generation</emphasis>
							</para>
								<#if study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.EffectLevelsF1.Efflevel?has_content>
								<para>
								<@FgenerationList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.EffectLevelsF1.Efflevel)/>
								</para>
								</#if>
								<#if study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.TargetSystemOrganToxicityF1.TargetSystemOrganToxicity?has_content>
								<para>
								<@TargetSystemOrganToxforEffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsOfExaminationsOffspring.TargetSystemOrganToxicityF1.TargetSystemOrganToxicity)/>
								</para>
								</#if>
							</#if>	

							<#if study.ResultsAndDiscussion.ResultsF2Generation.EffectLevelsF2.Efflevel?has_content>
								<para>
								<emphasis role="bold">F2 generation</emphasis>
								</para>
								<para>
								<@FgenerationList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsF2Generation.EffectLevelsF2.Efflevel)/>
								</para>
							</#if>	
							
							<#if study.ResultsAndDiscussion.ReproductiveToxicity.ReproductiveToxicity?has_content>
								<para>
								<emphasis role="bold">Overall reproductive toxicity</emphasis>
								</para>
								<para>
								<@OverallReproductiveToxicityList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ReproductiveToxicity.ReproductiveToxicity)/>
								</para>
							</#if>	
						</td>
						
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
				<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Toxicity for reproduction / fertility"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Toxicity for reproduction "/>
			
</#compress>
</#macro>

<!-- Toxicity to reproduction other studies study table -->	
<#macro toxicityForReproductionOtherStudiesNonHumanStudies _subject>
<#compress>	
			
<#assign resultstudyListOther = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ToxicityReproductionOther") />
	<#if !(resultstudyListOther?has_content)>
	No relevant information available.
	<#else/>
		The results of studies on the toxicity to reproduction (other studies) are summarised in the following table:
		
		<!-- Study results -->
		<@com.emptyLine/>
		<table border="1">
			<title>Studies on the toxicity to reproduction (other studies)</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultstudyListOther as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					
				</#list>
			</tbody>
		</table>
	</#if>

</#compress>
</#macro>

<!-- Human information Toxicity to reproduction -->	
<#macro toxicityForReproductionHumanStudies _subject>
<#compress>	
			
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedToxicityToReproInHumans(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedToxicityToReproInHumans(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedToxicityToReproInHumans(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedToxicityToReproInHumans(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
	No relevant information available.
	<#else/>
		The exposure-related observations in humans are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations on toxicity to reproduction / fertility in humans</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
								<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
								<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
								<@humanStudyMethod study />

						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
								Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
								<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />

</#compress>
</#macro>

<!-- Developmental toxicity non human study table -->
<#macro developmentalToxicityNonHumanStudies _subject>
<#compress>		
	
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DevelopmentalToxicityTeratogenicity") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<#else/>
		The results of studies on developmental toxicity are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on developmental toxicity</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
							<emphasis role="bold">Maternal animals:</emphasis>
							</para>

							<para>
							<@MatAbnormalitiesList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsMaternalAnimals.MaternalAbnormalities.MaternalAbnormalities)/>
							</para>

							<para>
							<@EffectLevelsMatAbnormalitiesList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsMaternalAnimals.EffectLevelsMaternalAnimals.Efflevel)/>
							</para>

							<para>
							<emphasis role="bold">Fetuses:</emphasis>
							</para>

							<para>
							<@FetalAbnormalitiesList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ResultsFetuses.FetalAbnormalities.FetalAbnormalities)/>
							</para>

							<para>
							<@EffectLevelsFetusesList study.ResultsAndDiscussion.ResultsFetuses.EffectLevelsFetuses.Efflevel/>
							</para>

							<para>
							<emphasis role="bold">Overall developmental toxicity:</emphasis>
							</para>

							<para>
							<@OverallDevToxList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.DevelopmentalToxicity.DevelopmentalToxicity)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Developmental Toxicity / teratogenicity"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Developmental Toxicity / teratogenicity"/>

</#compress>
</#macro>

<!-- Human information Developmental toxicity -->
<#macro developmentalToxicityHumanStudies _subject>
<#compress>			

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedDevelopmentToxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedDevelopmentToxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedDevelopmentToxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedDevelopmentToxicity(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
	No relevant information available.
	<#else/>
		The exposure-related observations in humans are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations on the developmental toxicity in humans</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />

						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
								Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
						<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />

</#compress>
</#macro>

<!-- Summary and discussion of reproductive and developmental toxicity -->
<#macro developmentalAndReproductiveToxicitySummary _subject>
<#compress>	

	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "ToxicityToReproduction") />

	<#if summaryList?has_content>	
	<#assign printSummaryName = summaryList?size gt 1 />
	
	<#list summaryList as summary>

		<#if summary.KeyValueForChemicalSafetyAssessment.ToxicEffectType?has_content>
		<@com.emptyLine/>
		Toxic effect type (for all routes and effects - fertility / developmental toxicity): <@com.value summary.KeyValueForChemicalSafetyAssessment.ToxicEffectType/>
		<@com.emptyLine/>
		</#if>	
						
			<#if summary.KeyInformation.KeyInformation?has_content>
				<para><@com.emptyLine/>
				<emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis>
				</para>
								
				<para><@com.emptyLine/>
				<@com.richText summary.KeyInformation.KeyInformation/>
				</para>
			</#if>

				<!-- get CSA values for each route -->
				<@toxCSAtable summary/>

				<@justification summary "JustificationForClassificationOrNonClassification"/>
			
				<!-- relevant to CSR only -->
				<#if csrRelevant??>
				<@studyandsummaryCom.modeOfActionOtherReproductiveTox summary />	
				</#if>

				<#if summary.hasElement("Discussion")>
				<@studyandsummaryCom.summaryAdditionalInformation summary/>
				</#if>		

			<#if csrRelevant??>
			   <#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
                <#assign studyList1 = getSortedDevelopmentToxicity(studyList) />
                <#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
                <#assign studyList2 = getSortedDevelopmentToxicity(studyList) />
                <#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
                <#assign studyList3 = getSortedDevelopmentToxicity(studyList) />
                <#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
                <#assign studyList4 = getSortedDevelopmentToxicity(studyList) />

                <#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
                    <#else/>
                        <para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
                        See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
                        <!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
                </#if>
				<@com.emptyLine/>
			</#if>

	</#list>
	</#if>
	
</#compress>
</#macro>

<!-- Neurotoxicity other effects study table -->
<#macro neurotoxicityOtherEffectsStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "Neurotoxicity") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<#else/>
		The results of studies on neurotoxicity are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on neurotoxicity</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
							<@EffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Neurotoxicity"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Neurotoxicity"/>

</#compress>
</#macro>

<!-- Immunotoxicity other effects study table -->
<#macro immunotoxicityOtherEffectsStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "Immunotoxicity") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<#else/>
		The results of studies on immunotoxicity are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Studies on immunotoxicity</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
							<@EffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Immunotoxicity"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Immunotoxicity"/>

</#compress>
</#macro>

<!-- Specific investigations: other studies study table -->
<#macro specificInvestigationsOtherStudies _subject>
<#compress>	
		
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "SpecificInvestigations") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<#else/>
		The results of specific investigations (other studies) are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Specific investigations: other studies</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method -->
						<td>
							<@nonHumanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
							<@com.text study.ResultsAndDiscussion.ResultsDetails/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Specific investigations: other studies"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Specific investigations: other studies"/>

</#compress>
</#macro>
	
<!-- Additional toxicological effects study table -->
<#macro additionalToxicologicalInformation _subject>
<#compress>			

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "AdditionalToxicologicalInformation") />

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList/>

	<!-- Study results -->
	<#if !resultStudyList?has_content>
	No relevant information available.
	<#else/>
		The results of specific investigations (other studies) are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Specific investigations: other studies</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list resultStudyList as study>
					<tr>
						<!-- Method TO TRANSFER TO MACRO -->
						<td>
						<@nonHumanStudyMethod study />
							
						</td>
						
						<!-- Results -->
						<td>
							<para>
								Applicant’s summary and conclusion: <@com.text study.ApplicantSummaryAndConclusion.Conclusions/>
							</para>
						</td>
						
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<!-- Data waiving -->
	<@studyandsummaryCom.dataWaiving dataWaivingStudyList "Specific investigations: other studies"/>

	<!-- Testing proposal -->
	<@studyandsummaryCom.testingProposal testingProposalStudyList "Specific investigations: other studies"/>

</#compress>
</#macro>
	
<!-- Human information Other effects -->
<#macro otherEffectsHumanStudies _subject>
<#compress>	

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedNeurotoxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedNeurotoxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedNeurotoxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedNeurotoxicity(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
	No relevant information available.
	<@com.emptyLine/>
	<#else/>
		The exposure-related observations in humans are summarised in the following table:

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations on neurotoxicity</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
						<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />

						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
								Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedImmunotoxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedImmunotoxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedImmunotoxicity(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedImmunotoxicity(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
		<#else/>

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations on immunotoxicity</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />

						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
								Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />

	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
	<#assign studyList1 = getSortedEndpointNotSpecified(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
	<#assign studyList2 = getSortedEndpointNotSpecified(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
	<#assign studyList3 = getSortedEndpointNotSpecified(studyList) />
	<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
	<#assign studyList4 = getSortedEndpointNotSpecified(studyList) />

	<!-- Study results -->
	<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
	<#else/>

		<@com.emptyLine/>
		<table border="1">
			<title>Exposure-related observations: endpoint not specified</title>
			<col width="39%" />
			<col width="41%" />
			<col width="20%" />
			<tbody>
				<tr>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Method</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Results</emphasis></th>
					<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Remarks</emphasis></th>
				</tr>

				<#list studyList1 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList2 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList3 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />

						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.RsExaminations/>
							</para>

							<para>
								Outcome of incidence: <@com.text study.ResultsAndDiscussion.Outcome/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
				<#list studyList4 as study>
					<tr>
						<!-- Method -->
						<td>
							<@humanStudyMethod study />
						</td>
						<!-- Results -->
						<td>
							<para>
								<@com.text study.ResultsAndDiscussion.Results/>
							</para>
						</td>
						<!-- Remarks -->
						<td>
							<@studyandsummaryCom.studyRemarksColumn study/>
						</td>
					</tr>
					<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
				</#list>
			</tbody>
		</table>
	</#if>

	<#assign studyList1 = [] />
	<#assign studyList2 = [] />
	<#assign studyList3 = [] />
	<#assign studyList4 = [] />

</#compress>
</#macro>

<!-- Summary and discussion of other effects -->
<#macro otherEffectsSummary _subject>
<#compress>

	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "Neurotoxicity") />

	<#if summaryList?has_content>
	<#assign printSummaryName = summaryList?size gt 1 />

		<para><emphasis role="bold">Neurotoxicity</emphasis></para>
	   
		<#list summaryList as summary>
		
			<#if summary.KeyInformation.KeyInformation?has_content>
			 <para><@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis></para>
			</#if>
			<@com.emptyLine/>
			
			<para>
			<@com.richText summary.KeyInformation.KeyInformation/>
			</para>

			<!-- get CSA values for each route -->
			<@toxCSAtable summary/>

			<@justification summary "Justification.JustifClassif"/>

			<#if summary.hasElement("Discussion")>
				<@studyandsummaryCom.summaryAdditionalInformation summary/>
			</#if>
		</#list>	
	</#if>
		
		<#if csrRelevant??>	
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
			<#assign studyList1 = getSortedNeurotoxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
			<#assign studyList2 = getSortedNeurotoxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
			<#assign studyList3 = getSortedNeurotoxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
			<#assign studyList4 = getSortedNeurotoxicity(studyList) />

			<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
				<#else/>
					<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
					See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
					<!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
			</#if>
		</#if>

	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "Immunotoxicity") />

	<#if summaryList?has_content>
		<@com.emptyLine/>
		<para><emphasis role="bold">Immunotoxicity</emphasis></para>
		   
		<#list summaryList as summary>
			
			<#if summary.KeyInformation.KeyInformation?has_content>
			 <para><@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis></para>
			</#if>
			<@com.emptyLine/>
			
			<para>
			<@com.richText summary.KeyInformation.KeyInformation/>
			</para>
			
			<!-- get CSA values for each route -->
			<@toxCSAtable summary/>

			<@justification summary "Justification.JustifClassif"/>

			<#if summary.hasElement("Discussion")>
				<@studyandsummaryCom.summaryAdditionalInformation summary/>
			</#if>	
		</#list>
	</#if>

		<#if csrRelevant??>
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "HealthSurveillanceData") />
			<#assign studyList1 = getSortedImmunotoxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "EpidemiologicalData") />
			<#assign studyList2 = getSortedImmunotoxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "DirectObservationsClinicalCases") />
			<#assign studyList3 = getSortedImmunotoxicity(studyList) />
			<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_STUDY_RECORD", "ExposureRelatedObservationsOther") />
			<#assign studyList4 = getSortedImmunotoxicity(studyList) />

			<#if !(studyList1?has_content) && !(studyList2?has_content) && !(studyList3?has_content) && !(studyList4?has_content)>
				<#else/>
					<para><@com.emptyLine/><emphasis role="underline">Discussion of human information:</emphasis></para>
					See "Summary and discussion of human information" in chapter 5 HUMAN HEALTH HAZARD ASSESSMENT
					<!-- TO DO - TO FIND WHAT INFO GOES HERE - WITH ROBERTA -->
			</#if>
		</#if>

	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "SpecificInvestigationsOtherStudies") />

	<#if summaryList?has_content>
		<@com.emptyLine/>
		<emphasis role="bold">Specific investigations: other studies </emphasis>
			
		<#list summaryList as summary>
			
			<#if summary.KeyInformation.KeyInformation?has_content>
				<para><@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis></para>
			</#if>
			<@com.emptyLine/>
		
			<para>
				<@com.richText summary.KeyInformation.KeyInformation/>
			</para>
			
			<para><@studyandsummaryCom.relevantStudies summary "placeholder"/></para>	
			
			<para>
			<#if summary.hasElement("Discussion")>
					<@studyandsummaryCom.summaryAdditionalInformation summary/>
			</#if>
			</para>
		</#list>
	</#if>
	
	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "AdditionalToxicologicalInformation") />

	<#if summaryList?has_content>
		<@com.emptyLine/>
		<emphasis role="bold">Additional toxicological information </emphasis>
			
		<#list summaryList as summary>
		
			<#if summary.KeyInformation.KeyInformation?has_content>
				<para><@com.emptyLine/><emphasis role="underline">The following information is taken into account for any hazard / risk assessment:</emphasis></para>
			</#if>
			<@com.emptyLine/>
		
			<para>
				<@com.richText summary.KeyInformation.KeyInformation/>
			</para>
			
			<para><@studyandsummaryCom.relevantStudies summary "placeholder"/></para>	
			
			<para>
				<#if summary.hasElement("Discussion")>
					<@studyandsummaryCom.summaryAdditionalInformation summary/>
				</#if>	
			</para>
		</#list>
	</#if>

</#compress>
</#macro>

<#-- NEW FUNCTION TO REPLACE SORTING OF HUMAN HEALTH -->
<#function getRelevantHumanHealthStudies studyList documentId="">

	<#assign returnList = []/>
	<#assign endpointAddressed = []/>
	<#assign typeOfSensitisationStudied = []/>
	
	<#if !(studyList?has_content)>
		<#return []>
	</#if>

	<#list studyList as study>
	
		<#if study.hasElement("MaterialsAndMethods.EndpointAddressed") && study.MaterialsAndMethods.EndpointAddressed?has_content>
			<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		</#if>
		<#if study.hasElement("MaterialsAndMethods.TypeOfSensitisationStudied") && study.MaterialsAndMethods.TypeOfSensitisationStudied?has_content>			
			<#local typeOfSensitisationStudied = study.MaterialsAndMethods.TypeOfSensitisationStudied />
		</#if>

			<#if documentId=="acuteToxicity" && endpointAddressed?has_content>
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["acute toxicity: oral", "acute toxicity: inhalation", "acute toxicity: dermal"])>
					<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="toxicokinetics" && endpointAddressed?has_content>
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["basic toxicokinetics", "dermal absorption"])>
					<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="skinIrritation" && endpointAddressed?has_content>
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["skin irritation / corrosion"])>
					<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="eyeIrritation" && endpointAddressed?has_content>
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["eye irritation"])>
				<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="respiratoryIrritation" && endpointAddressed?has_content>
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["respiratory irritation"])>
				<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="corrosivity" && endpointAddressed?has_content>
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["skin irritation / corrosion"])>
				<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="skinSensitisation">
				<#if study.hasElement("MaterialsAndMethods.EndpointAddressed") && com.picklistMultipleValueMatchesPhrases(study.MaterialsAndMethods.EndpointAddressed, ["skin sensitisation"]) 
				|| study.hasElement("MaterialsAndMethods.TypeOfSensitisationStudied") && com.picklistMultipleValueMatchesPhrases(study.MaterialsAndMethods.TypeOfSensitisationStudied, ["skin"])>
					<#local returnList = returnList + [study] />					
				</#if>

			<#elseif documentId=="respiratorySystem">
				<#if study.hasElement("MaterialsAndMethods.EndpointAddressed") && com.picklistMultipleValueMatchesPhrases(study.MaterialsAndMethods.EndpointAddressed, ["respiratory sensitisation"]) 
				|| study.hasElement("MaterialsAndMethods.TypeOfSensitisationStudied") && com.picklistMultipleValueMatchesPhrases(study.MaterialsAndMethods.TypeOfSensitisationStudied, ["respiratory"])>
					<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="repeatedDose">
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["repeated dose toxicity: oral", "repeated dose toxicity: inhalation", "repeated dose toxicity: dermal"])>
					<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="mutagenicity">
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["genetic toxicity"])>
					<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="carcinogenicity">
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["carcinogenicity"])>
					<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="toxicityToReproduction">
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["toxicity to reproduction / fertility"])>
					<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="developmentalToxicity">
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["developmental toxicity / teratogenicity"])>
					<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="otherEffectsNeurotoxicity">
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["neurotoxicity"])>			
					<#local returnList = returnList + [study] />
				</#if>

			<#elseif documentId=="otherEffectsImmunotoxicity">
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["immunotoxicity"])>
					<#local returnList = returnList + [study] />
				</#if>
			
			<#elseif documentId=="otherEffectsNotSpecified">
				<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["not applicable"])>
					<#local returnList = returnList + [study] />
				</#if>
			</#if>
	</#list>
	
	<#return returnList />

</#function>

<#function getRelevantNonHumanStudies studyList endpointValueList documentId="">
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />	
	<#list resultStudyList as study>
		<#local endpoint = study.AdministrativeData.Endpoint />
		<#if com.picklistValueMatchesPhrases(endpoint, endpointValueList) >
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#return returnList />
</#function>

<#function checkSummaryInfo summary>
	<#local valuesCSA = []/>
	
	<#if !(summary?has_content)>
		<#return [] />
	</#if>
	
	<#if summary.hasElement("KeyInformation")>
		<#local valuesCSA = valuesCSA + [summary]/>			
	</#if>		
	
	<#return valuesCSA />	
</#function>

<#macro CSAValueText summary discussion="" moreText="">
<#compress>
<@com.emptyLine/>
	<#if summary.documentKey?has_content && discussion?has_content>>
		<para><emphasis role="HEAD-WoutNo">			
		<#assign docUrl=iuclid.webUrl.documentView(summary.documentKey) />
			<ulink url="${docUrl}">${discussion}</ulink>
		</emphasis></para>
		<para><emphasis role="underline">${moreText}</emphasis></para>
	</#if>
</#compress>
</#macro>


<!-- Macros and functions -->
<#-- TODO It seems that all getSorted... functions could be incorporated in one -->
<#function getSortedBasicToxicokineticsOrDermalAbsorption documentKey documentType documentSubtype>
    <#assign studyList = iuclid.getSectionDocumentsForParentKey(documentKey, documentType, documentSubtype) />
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["basic toxicokinetics", "dermal absorption"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedAcuteToxicity studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
	<#if study.hasElement("MaterialsAndMethods.EndpointAddressed")>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["acute toxicity: oral", "acute toxicity: inhalation", "acute toxicity: dermal"])>
			<#local returnList = returnList + [study] />
		</#if>
		<#else>
		<#return [] />
	</#if>
	
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedSkinIrritation studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["skin irritation / corrosion"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedSkinCorrosion studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["skin irritation / corrosion"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedEyeIrritation studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["eye irritation"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedRespiratoryTract studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["respiratory irritation"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedCarcinogenicity studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["carcinogenicity"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedDevelopmentToxicity studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["developmental toxicity / teratogenicity"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedToxicityToReproInHumans studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["toxicity to reproduction / fertility"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedNeurotoxicity studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["neurotoxicity"])> 
			
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedImmunotoxicity studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["immunotoxicity"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedEndpointNotSpecified studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["not applicable"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedCarcinogenicityOral studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpoint = study.AdministrativeData.Endpoint />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistValueMatchesPhrases(endpoint, ["carcinogenicity: oral"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#if PurposeFlag?has_content>
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
	</#if>
    <#return returnList />
</#function>

<#function getSortedCarcinogenicityInhalation studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpoint = study.AdministrativeData.Endpoint />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistValueMatchesPhrases(endpoint, ["carcinogenicity: inhalation"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#if PurposeFlag?has_content>
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
	</#if>
    <#return returnList />
</#function>

<#function getSortedCarcinogenicityDermal studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpoint = study.AdministrativeData.Endpoint />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistValueMatchesPhrases(endpoint, ["carcinogenicity: dermal"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#if PurposeFlag?has_content>
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
	</#if>
    <#return returnList />
</#function>

<#function getSortedCarcinogenicityOther studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpoint = study.AdministrativeData.Endpoint />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistValueMatchesPhrases(endpoint, ["carcinogenicity, other"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#if PurposeFlag?has_content>
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
	</#if>
    <#return returnList />
</#function>

<#function getSortedSkinSensitisation studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local TypeOfSensitisationStudied = study.MaterialsAndMethods.TypeOfSensitisationStudied />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(TypeOfSensitisationStudied, ["skin"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#if PurposeFlag?has_content>
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
	</#if>
    <#return returnList />
</#function>

<#function getSortedSkinSensitisationEndpoint studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["skin sensitisation"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedRespiratorySensitisationEndpoint studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["respiratory sensitisation"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedRepeatedDoseToxicity studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["repeated dose toxicity: oral", "repeated dose toxicity: inhalation", "repeated dose toxicity: dermal"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedGeneticToxicity studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpointAddressed = study.MaterialsAndMethods.EndpointAddressed />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(endpointAddressed, ["genetic toxicity"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedSkinSensitisationRespiratory studyList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local TypeOfSensitisationStudied = study.MaterialsAndMethods.TypeOfSensitisationStudied />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistMultipleValueMatchesPhrases(TypeOfSensitisationStudied, ["respiratory"])>
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedSkinIrritationNonHuman studyList endpointValueList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpoint = study.AdministrativeData.Endpoint />
	<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistValueMatchesPhrases(endpoint, endpointValueList) >
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#function getSortedSkinCorrosionNonHuman studyList endpointValueList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	<#list studyList as study>
		<#local endpoint = study.AdministrativeData.Endpoint />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistValueMatchesPhrases(endpoint, endpointValueList) >
			<#local returnList = returnList + [study] />
		</#if>
	</#list>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#macro AbsorptionList AbsorptionRepeatableBlock>
<#compress>
	<#if AbsorptionRepeatableBlock?has_content>
		<#list AbsorptionRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.Absorption?has_content>
					<@com.range blockItem.Absorption/> % 
				</#if>	
				<#if blockItem.TimePoint?has_content>	
					at (<@com.value blockItem.TimePoint/>)
				</#if>
				<#if blockItem.Dose?has_content>
					(<@com.text blockItem.Dose/>) 
				</#if>	
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.value blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#-- TODO The following DosesConcentrations... macros could be merged in one -->
<#macro DosesConcentrationsList DosesConcentrationsRepeatableBlock>
<#compress>
	<#if DosesConcentrationsRepeatableBlock?has_content>
		<#list DosesConcentrationsRepeatableBlock as blockItem>
			<para role="indent">
				<@com.quantity blockItem.DoseConc/>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro DosesConcentrationsWithRemarksList DosesConcentrationsRepeatableBlock remarks = true>
<#compress>
	<#if DosesConcentrationsRepeatableBlock?has_content>
		<#list DosesConcentrationsRepeatableBlock>
		<para role="indent">
			<#items as blockItem>
				<#if blockItem.hasElement("DoseConc") && blockItem.DoseConc?has_content>
					<@com.quantity blockItem.DoseConc/><?linebreak?>
				</#if>
				
				<#if blockItem.hasElement("ConvertedDoseConc") && blockItem.ConvertedDoseConc?has_content>
					<@com.value blockItem.ConvertedDoseConc/><?linebreak?>
				</#if>

				<#if blockItem.hasElement("DurationOfTreatment") && blockItem.DurationOfTreatment?has_content>
					<@com.value blockItem.DurationOfTreatment/>
				</#if>
				
				<#if remarks>
					<@com.text blockItem.Remarks/><?linebreak?>
				</#if>
			</#items>
		</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro DosesConcentrationsFullList DosesConcentrationsRepeatableBlock remarks=true tabular=false>
<#compress>
	<#if DosesConcentrationsRepeatableBlock?has_content>
		<#local doseConcIndex=0/>
		<#list DosesConcentrationsRepeatableBlock as blockItem>
			<#if blockItem.hasElement("TreatmentGroup") && blockItem.TreatmentGroup?has_content || blockItem.hasElement("Sex") && blockItem.Sex?has_content || 
				blockItem.hasElement("NoOfAnimalsInTreatmentGroup") && blockItem.NoOfAnimalsInTreatmentGroup?has_content || blockItem.hasElement("DurationOfTreatment") && blockItem.DurationOfTreatment?has_content ||
				blockItem.hasElement("DoseType") && blockItem.DoseType?has_content || blockItem.hasElement("FrequencyOfTreatment") && blockItem.FrequencyOfTreatment?has_content ||
				blockItem.hasElement("DoseConc") && blockItem.DoseConc?has_content || blockItem.hasElement("ConvertedDoseConc") && blockItem.ConvertedDoseConc?has_content ||
				blockItem.hasElement("Remarks") && blockItem.Remarks?has_content>
				<#local doseConcIndex += 1/>
				<#if tabular>
					<informaltable frame="none">
					<col width="25%" />
					<col width="75%" />
					<tbody>
					
						<tr>
							<td>
								<#if blockItem.hasElement("TreatmentGroup") && blockItem.TreatmentGroup?has_content>
									<@com.value blockItem.TreatmentGroup ""/>
								<#else>
									#${doseConcIndex}
								</#if>	
							</td>
							<td></td>
						</tr>

						<#if blockItem.hasElement("Sex") && blockItem.Sex?has_content>
							<tr>
								<td>Sex:</td>
								<td><@com.value blockItem.Sex ""/></td>
							</tr>
						</#if>
						<#if blockItem.hasElement("NoOfAnimalsInTreatmentGroup") && blockItem.NoOfAnimalsInTreatmentGroup?has_content>
							<tr>
								<td>No. of animals in group:</td>
								<td><@com.value blockItem.NoOfAnimalsInTreatmentGroup ""/></td>
							</tr>	
						</#if>
						<#if blockItem.hasElement("DurationOfTreatment") && blockItem.DurationOfTreatment?has_content>
							<tr>
								<td>Duration of treatment:</td>
								<td><@com.value blockItem.DurationOfTreatment ""/></td>
							</tr>	
						</#if>
						<#if blockItem.hasElement("DoseType") && blockItem.DoseType?has_content>
							<tr>
								<td>Dose type:</td> 
								<td><@com.value blockItem.DoseType ""/></td>
							</tr>
						</#if>
						<#if blockItem.hasElement("FrequencyOfTreatment") && blockItem.FrequencyOfTreatment?has_content>
							<tr>
								<td>Frequency:</td>
								<td><@com.value blockItem.FrequencyOfTreatment ""/></td>
							</tr>
						</#if>
						<#if blockItem.hasElement("DoseConc") && blockItem.DoseConc?has_content>
							<tr>
								<td>Dose / conc.:</td> 
								<td><@com.value blockItem.DoseConc ""/></td>
							</tr>
						</#if>
						<#if blockItem.hasElement("ConvertedDoseConc") && blockItem.ConvertedDoseConc?has_content>
							<tr>
								<td>Converted dose / conc.:</td>
								<td><@com.value blockItem.ConvertedDoseConc ""/></td>
							</tr>
						</#if>
						<#if blockItem.hasElement("Remarks") && blockItem.Remarks?has_content && remarks >
							<tr>
								<td>Remarks:</td> 
								<td><@com.value blockItem.Remarks/></td>
							</tr>
						</#if>	
					</tbody>
					</informaltable>
					<#if blockItem?has_next><@com.emptyLine/></#if>
				<#else>
					<para role="indent">
						<#if blockItem.hasElement("TreatmentGroup") && blockItem.TreatmentGroup?has_content>
							Treatment group: <@com.value blockItem.TreatmentGroup ""/>.
						</#if>

						<#if blockItem.hasElement("Sex") && blockItem.Sex?has_content>
							Sex: <@com.value blockItem.Sex ""/>.
						</#if>

						<#if blockItem.hasElement("NoOfAnimalsInTreatmentGroup") && blockItem.NoOfAnimalsInTreatmentGroup?has_content>
							No. of animals in group: <@com.value blockItem.NoOfAnimalsInTreatmentGroup ""/>.
						</#if>

						<#if blockItem.hasElement("DurationOfTreatment") && blockItem.DurationOfTreatment?has_content>
							Duration of treatment: <@com.value blockItem.DurationOfTreatment ""/>.
						</#if>

						<#if blockItem.hasElement("DoseType") && blockItem.DoseType?has_content>
							Dose type: <@com.value blockItem.DoseType ""/>.
						</#if>

						<#if blockItem.hasElement("FrequencyOfTreatment") && blockItem.FrequencyOfTreatment?has_content>
							Frequency: <@com.value blockItem.FrequencyOfTreatment ""/>.
						</#if>

						<#if blockItem.hasElement("DoseConc") && blockItem.DoseConc?has_content>
							Dose / conc.: <@com.value blockItem.DoseConc ""/>.
						</#if>
						
						<#if blockItem.hasElement("ConvertedDoseConc") && blockItem.ConvertedDoseConc?has_content>
							Converted dose / conc.: <@com.value blockItem.ConvertedDoseConc ""/>.
						</#if>

						<#if blockItem.hasElement("Remarks") && blockItem.Remarks?has_content && remarks>
							<?linebreak?>
							Remarks: <@com.value blockItem.Remarks/>
						</#if>
					</para>
				</#if>
			</#if>		
		</#list>
  	</#if>
</#compress>
</#macro>

<#--  
	Macro to output the Doses/concentrations information in a table. 
	This same macro handles 3 different formats of the DosesConcentrationsRepeatableBlock.  
-->
<#macro DosesConcentrationsFullTable DosesConcentrationsRepeatableBlock remarks=true bgcolor="#D3D3D3" tabletitle="Doses / concentrations">
<#compress>
	<#if DosesConcentrationsRepeatableBlock?has_content>
		<table border="1">
			<title>${tabletitle}</title>

			<#--  Setting the table columns number/layout dinamically  -->
			<#list DosesConcentrationsRepeatableBlock as blockItem>
				<#local colNumb = 0/>
				<#list blockItem?children as child>
					<#local colNumb += 1/>
				</#list>
				<#break>
			</#list>

				<#if colNumb == 8>
					<col width="10%" />
					<col width="10%" />
					<col width="13%" />
					<col width="12%" />
					<col width="13%" />
					<col width="12%" />
					<col width="15%" />
					<col width="15%" />
				<#elseif colNumb == 3>
					<col width="33%" />
					<col width="33%" />
					<col width="34%" />
				<#elseif colNumb == 2>
					<col width="50%" />
					<col width="50%" />
				</#if>

			<thead align="center" valign="middle">
				<#list DosesConcentrationsRepeatableBlock as blockItem>
					<tr>
						<#if blockItem.hasElement("TreatmentGroup")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Group</emphasis></th></#if>
						<#if blockItem.hasElement("Sex")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Sex</emphasis></th></#if>
						<#if blockItem.hasElement("NoOfAnimalsInTreatmentGroup")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">No. animals</emphasis></th></#if>
						<#if blockItem.hasElement("DurationOfTreatment")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Duration</emphasis></th></#if>
						<#if blockItem.hasElement("DoseType")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Dose</emphasis></th></#if>
						<#if blockItem.hasElement("FrequencyOfTreatment")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Frequency</emphasis></th></#if>
						<#if blockItem.hasElement("DoseConc")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Dose / conc.</emphasis></th></#if>
						<#if blockItem.hasElement("ConvertedDoseConc")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Converted dose / conc.</emphasis></th></#if>
						<#if blockItem.hasElement("Remarks")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th></#if>
					</tr>
					<#break>
				</#list>
			</thead>
			<tbody valign="middle">
				<#list DosesConcentrationsRepeatableBlock as blockItem>
					<tr>
						<#if blockItem.hasElement("TreatmentGroup")>
							<td><@com.value blockItem.TreatmentGroup ""/></td>
						</#if>
						<#if blockItem.hasElement("Sex")>
							<td><@com.value blockItem.Sex ""/></td>
						</#if>
						<#if blockItem.hasElement("NoOfAnimalsInTreatmentGroup")>
							<td><@com.value blockItem.NoOfAnimalsInTreatmentGroup ""/></td>
						</#if>
						<#if blockItem.hasElement("DurationOfTreatment")>
							<td><@com.value blockItem.DurationOfTreatment ""/></td>	
						</#if>
						<#if blockItem.hasElement("DoseType")>
							<td><@com.value blockItem.DoseType ""/></td>
						</#if>
						<#if blockItem.hasElement("FrequencyOfTreatment")>
							<td><@com.value blockItem.FrequencyOfTreatment ""/></td>
						</#if>
						<#if blockItem.hasElement("DoseConc")>
							<td><@com.value blockItem.DoseConc ""/></td>
						</#if>
						<#if blockItem.hasElement("ConvertedDoseConc")>
							<td><@com.value blockItem.ConvertedDoseConc ""/></td>
						</#if>
						<#if blockItem.hasElement("Remarks")> 
							<td><@com.value blockItem.Remarks/></td>
						</#if>
					</tr>
				</#list>
			</tbody>
		</table>
	</#if>
</#compress>
</#macro>

<#macro BasicToxicokineticsMainAdmeResultsList MainAdmeResultsRepeatableBlock>
<#compress>
	<#if MainAdmeResultsRepeatableBlock?has_content>
		<#list MainAdmeResultsRepeatableBlock as blockItem>
			<para role="indent">
				Type: <@com.value blockItem.Type/>
				<?linebreak?>
				Result: <@com.text blockItem.Results/>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro BasicToxicokineticsInVitroSystem block>
<#compress>
	<#if block?has_content>
		<#if pppRelevant??>
			<@com.children path=block style="none" tabular=true/>
		<#else>
			<#list block?children as blockchildren>
				<@iuclid.label for=blockchildren var="label"/>
				<para role="indent">
					<?linebreak?>${label}: <@com.value blockchildren/>
				</para>
			</#list>
		</#if>
  	</#if>
</#compress>
</#macro>

<#macro BasicToxicokineticsDosesConcentrationsList DosesConcentrationsRepeatableBlock>
<#compress>
	<#if DosesConcentrationsRepeatableBlock?has_content>
		<#list DosesConcentrationsRepeatableBlock as blockItem>
			<#if blockItem.DoseConc?has_content>
				Doses/conc.: <@com.range blockItem.DoseConc/>
			</#if>
			<#if blockItem.FrequencyOfTreatment?has_content>
				Frequency: <@com.range blockItem.FrequencyOfTreatment/>
			</#if>
			<#if blockItem.NoOfAnimalsInTreatmentGroup?has_content>
				No. of animals in group: <@com.range blockItem.NoOfAnimalsInTreatmentGroup/>
			</#if>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro ToxicokineticParametersList ParametersRepeatableBlock>
<#compress>
	<#if ParametersRepeatableBlock?has_content>
		<#list ParametersRepeatableBlock as blockItem>
			<para role="indent">
				<@com.value blockItem.ToxicokineticParameters/> 
				<#if blockItem.TestNo?has_content>
					(Test No.: <@com.value blockItem.TestNo/>)
				</#if>
				<#if blockItem.Dose?has_content>
					(Dose: <@com.value blockItem.Dose/>)
				</#if>
				<#if blockItem.Value?has_content>
					(Value: <@com.value blockItem.Value/>)
				</#if>
				<#if blockItem.RemarksOnResult?has_content>
					(Remarks on Results: <@com.value blockItem.RemarksOnResult/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro ADMEList ADMERepeatableBlock>
<#compress>
	<#if ADMERepeatableBlock?has_content>
		<#list ADMERepeatableBlock as blockItem>
			<para role="indent">
				<@com.value blockItem.Type/>

				<#if blockItem.Results?has_content>
					<#if !pppRelevant??><?linebreak?></#if><@com.value blockItem.Results/>
				</#if>
				<#if blockItem.Value?has_content>
					<#if !pppRelevant??><?linebreak?></#if><@com.value blockItem.Value/>
				</#if>
				<#if blockItem.TimePoint?has_content>
					<#if !pppRelevant??><?linebreak?></#if><@com.value blockItem.TimePoint/>
				</#if>
				<#if blockItem.Dose?has_content>
					<#if !pppRelevant??><?linebreak?></#if><@com.value blockItem.Dose/>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro PercutaneousAbsorptionRateList PercutaneousRepeatableBlock>
<#compress>
	<#if PercutaneousRepeatableBlock?has_content>
		<#list PercutaneousRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.Absorption?has_content>
					<@com.value blockItem.Absorption/>
				</#if>	
				<#if blockItem.TimePoint?has_content>
					at <@com.value blockItem.TimePoint/>
				</#if>
				<#if blockItem.Dose?has_content>
					<#if pppRelevant??>
						for dose <@com.value blockItem.Dose/>
						<#if blockItem.ConcentrateDilution?has_content>
							(<@com.value blockItem.ConcentrateDilution/>)
						<#else>
							(<@com.value blockItem.Dose/>)
						</#if>
					</#if>
				</#if>
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.value blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#--  
	Macro to output the Percutaneous Absorption results information in a table. 
-->
<#macro PercutaneousAbsorptionRateTable PercutaneousRepeatableBlock bgcolor="#D3D3D3" tabletitle="Percutaneous absorption rate">
<#compress>
	<#if PercutaneousRepeatableBlock?has_content>
		<#-- make table header -->
		<table border="1">
			<title>${tabletitle}</title>

			<col width="15%" />
			<col width="15%" />
			<col width="20%" />
			<col width="15%" />
			<col width="15%" />
			<col width="20%" />			

			<thead align="center" valign="middle">
				<tr>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Time point</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Concentrate / Dilution</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Dose</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Parameter</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Absorption</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
				</tr>
			</thead>
			<tbody valign="middle">
				<#list PercutaneousRepeatableBlock as blockItem>
					<tr>
						<td>
							<@com.value blockItem.TimePoint/>
						</td>
						<td>
							<@com.value blockItem.ConcentrateDilution/>
						</td>
						<td>
							<@com.value blockItem.Dose/>
						</td>
						<td>
							<@com.value blockItem.Parameter/>
						</td>
						<td>
							<@com.range blockItem.Absorption/>
						</td>
						<td>
							<@com.value blockItem.RemarksOnResults/>
						</td>
					</tr>
				</#list>
			</tbody>
		</table>
  	</#if>
</#compress>
</#macro>

<#macro EyeIrritationInVitroList EyeIrritationInVitroRepeatableBlock>
<#compress>
	<#if EyeIrritationInVitroRepeatableBlock?has_content>
		<#list EyeIrritationInVitroRepeatableBlock as blockItem>
			<#if blockItem.RunExperiment?has_content || blockItem.Value?has_content>
				<para>
				<@com.value blockItem.IrritationParameter/>
				</para>
				<para role="indent">
					<para>
						<#if blockItem.RunExperiment?has_content>
							<@com.text blockItem.RunExperiment/>;
						</#if>
						
						<#if blockItem.Value?has_content>
							value <@com.range blockItem.Value/>
						</#if>
					</para>
				</para>
			</#if>
		</#list>
  	</#if>
</#compress>
</#macro>

<#--  
	Macro to output the in vitro results information in a table for both Eye and Skin Irritation documents.
-->
<#macro EyeSkinIrritationInVitroTable EyeSkinIrritationInVitroRepeatableBlock bgcolor="#D3D3D3" tabletitle="Results" sortedList="">
<#compress>
	<#if EyeSkinIrritationInVitroRepeatableBlock?has_content>

		<#-- make table header -->
		<table border="1">
			<title>${tabletitle}</title>

			<col width="10%" />
			<col width="20%" />
			<col width="15%" />
			<col width="25%" />
			<col width="30%" />			

			<thead align="center" valign="middle">
				<tr>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Run</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Parameter</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Value</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Controls validity</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
				</tr>
			</thead>
			<tbody valign="middle">
				<#--  if a custom sorting of the EyeSkinIrritationInVitroRepeatableBlock is given through sortedList argument, use that  -->
				<#if sortedList?has_content>
					<#local EyeSkinIrritationInVitroRepeatableBlock = sortedList/>
				</#if>

				<#list EyeSkinIrritationInVitroRepeatableBlock as blockItem>
					<tr>
						<td>
							<@com.value blockItem.RunExperiment/>
						</td>
						<td>
							<#if blockItem.hasElement('IrritationCorrosionParameter')>
								<@com.value blockItem.IrritationCorrosionParameter/>
							<#elseif blockItem.hasElement('IrritationParameter')>
								<@com.value blockItem.IrritationParameter/>
							</#if>
						</td>
						<td>
							<@com.value blockItem.Value/>
						</td>
						<td>
							<#if blockItem.VehicleControlsValid?has_content>
								vehicle control: <@com.value blockItem.VehicleControlsValid/>;
								<?linebreak?>
							</#if>
							<#if blockItem.PositiveControlsValid?has_content>
								pos. control: <@com.value blockItem.PositiveControlsValid/>;
								<?linebreak?>
							</#if>
							<#if blockItem.NegativeControlsValid?has_content>
								neg. control: <@com.value blockItem.NegativeControlsValid/>;
							</#if>
						</td>
						<td>
							<#if blockItem.hasElement('RemarksOnResult')>
								<@com.value blockItem.RemarksOnResult/>
							<#elseif blockItem.hasElement('RemarksOnResults')>
								<@com.value blockItem.RemarksOnResults/>
							</#if>
						</td>
					</tr>
				</#list>
			</tbody>
		</table>
  	</#if>
</#compress>
</#macro>

<#macro EyeIrritationInVivoList EyeIrritationInVivoRepeatableBlock>
<#compress>
	<#if EyeIrritationInVivoRepeatableBlock?has_content>
		<#list EyeIrritationInVivoRepeatableBlock as blockItem>
			<#if blockItem.Basis?has_content || blockItem.Score?has_content || blockItem.Scale?has_content || blockItem.TimePoint?has_content || blockItem.Reversibility?has_content || blockItem.RemarksOnResults?has_content>
				<para>
				<@com.value blockItem.Parameter/>
				</para>
				<para role="indent">
					<para>
						<#if blockItem.Basis?has_content>
							(<@com.value blockItem.Basis/>)
						</#if>
					
						<#if blockItem.Score?has_content>
							<@com.range blockItem.Score/>
						</#if>
					
						<#if blockItem.Scale?has_content>
							of max. <@com.number blockItem.Scale/>
						</#if>
					</para>
					
					<#if blockItem.TimePoint?has_content>
						<para>
							(Time point: <@com.value blockItem.TimePoint/>)
						</para>
					</#if>
					
					<#if blockItem.Reversibility?has_content>
						<para>
							<@com.value blockItem.Reversibility/>							
						</para>
					</#if>
					
					<#if blockItem.RemarksOnResults?has_content>
						<para>
							<@com.value blockItem.RemarksOnResults/>
						</para>
					</#if>
				</para>
			</#if>
		</#list>
  	</#if>
</#compress>
</#macro>

<#--  
	Macro to output the in vivo results information in a table for both Eye and Skin Irritation documents.
-->
<#macro EyeSkinIrritationInVivoTable EyeSkinIrritationInVivoRepeatableBlock bgcolor="#D3D3D3" tabletitle="Results" sortedList="">
<#compress>
	<#if EyeSkinIrritationInVivoRepeatableBlock?has_content>
		<#-- make table header -->
		<table border="1">
			<title>${tabletitle}</title>

			<col width="15%" />
			<col width="15%" />
			<col width="15%" />
			<col width="15%" />
			<col width="20%" />
			<col width="20%" />	

			<thead align="center" valign="middle">
				<tr>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Parameter</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Basis</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Score</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Time point</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Reversibility</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
				</tr>
			</thead>
			<tbody valign="middle">
				<#--  if a custom sorting of the EyeSkinIrritationInVivoRepeatableBlock is given through sortedList argument, use that  -->
				<#if sortedList?has_content>
					<#local EyeSkinIrritationInVivoRepeatableBlock = sortedList/>
				</#if>

				<#list EyeSkinIrritationInVivoRepeatableBlock as blockItem>
					<tr>
						<td>
							<@com.value blockItem.Parameter/>
						</td>
						<td>
							<@com.value blockItem.Basis/>
						</td>
						<td>
							<@com.value blockItem.Score/>
							<#if blockItem.Scale?has_content>
								of max. <@com.value blockItem.Scale/>
							</#if>
						</td>
						<td>
							<@com.value blockItem.TimePoint/>
						</td>
						<td>
							<@com.value blockItem.Reversibility/>
						</td>
						<td>
							<@com.value blockItem.RemarksOnResults/>
						</td>
					</tr>
				</#list>
			</tbody>
		</table>
  	</#if>
</#compress>
</#macro>

<#macro TransferList  TransferRepeatableBlock>
<#compress>
	<#if TransferRepeatableBlock?has_content>
		<#list TransferRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.TransferType?has_content>
					Transfer (<@com.value blockItem.TransferType/>)
				</#if>	
				<#if blockItem.Observation?has_content>
					: <@com.value blockItem.Observation/> 
				</#if>
				<#if blockItem.TestNo?has_content>
					(<@com.value blockItem.TestNo/>)
				</#if>	
				<#if blockItem.OrgansWithHighestLevelsOfSubstance?has_content>
					(<@com.value blockItem.OrgansWithHighestLevelsOfSubstance/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro AbsorptionList AbsorptionRepeatableBlock>
<#compress>
	<#if AbsorptionRepeatableBlock?has_content>
		<#list AbsorptionRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.Absorption?has_content>
					<@com.range blockItem.Absorption/> %
				</#if>
				<#if blockItem.TimePoint?has_content>
					at (<@com.value blockItem.TimePoint/>)
				</#if>
				<#if blockItem.Dose?has_content>
					(<@com.text blockItem.Dose/>)
				</#if>
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.value blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro BasicToxicokineticsMainAdmeResultsList MainAdmeResultsRepeatableBlock>
<#compress>
	<#if MainAdmeResultsRepeatableBlock?has_content>
		<#list MainAdmeResultsRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.Type?has_content>
					Type: <@com.value blockItem.Type/>
				</#if>
				<#if blockItem.Results?has_content>
					Result: <@com.text blockItem.Results/>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#-- TODO The following EffectLevels... macros could be merged in one -->
<#macro EffectLevelsList EffectsRepeatableBlock>
<#compress>
	<#if EffectsRepeatableBlock?has_content>
		<#list EffectsRepeatableBlock as blockItem>
			<#if blockItem.Endpoint?has_content || blockItem.Sex?has_content || blockItem.BasedOn?has_content || blockItem.RemarksOnResults?has_content>
			<para>
				<#if blockItem.Endpoint?has_content>
					<@com.value blockItem.Endpoint/>:
				</#if>
				<@com.range blockItem.EffectLevel/>
				<#if blockItem.Sex?has_content>
					(<@com.value blockItem.Sex/>)
				</#if>
				<#if blockItem.BasedOn?has_content>
					based on: (<@com.value blockItem.BasedOn/>) 
				</#if>
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.value blockItem.RemarksOnResults/>)
				</#if>
			</para>
			</#if>
		</#list>
  	</#if>
</#compress>
</#macro>


<#macro EffectLevelsMatAbnormalitiesList EffectsMaternalRepeatableBlock>
	<#compress>
		<#if EffectsMaternalRepeatableBlock?has_content>
			<#list EffectsMaternalRepeatableBlock as blockItem>
				<para role="indent">
					<#if blockItem.Endpoint?has_content>
						<@com.value blockItem.Endpoint/>:
					</#if>
					<#if blockItem.EffectLevel?has_content>
						<@com.range blockItem.EffectLevel/>
					</#if>
					<#if blockItem.BasedOn?has_content>
						<?linebreak?>based on: (<@com.value blockItem.BasedOn/>)
					</#if>
					<#if pppRelevant??>
						<#if blockItem.Basis?has_content>
							<?linebreak?>basis:<@com.value blockItem.Basis/>
						</#if>
					</#if>
					<#if blockItem.RemarksOnResults?has_content>
						(<@com.value blockItem.RemarksOnResults/>)
					</#if>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>
<#macro EffectLevelsFetusesList EffectsFetusesRepeatableBlock>
	<#compress>
		<#if EffectsFetusesRepeatableBlock?has_content>
			<#list EffectsFetusesRepeatableBlock as blockItem>
				<para role="indent">
					<#if blockItem.Endpoint?has_content>
						<@com.value blockItem.Endpoint/>:
					</#if>
					<#if blockItem.EffectLevel?has_content>
						<@com.range blockItem.EffectLevel/>
					</#if>
					<#if blockItem.BasedOn?has_content>
						<?linebreak?>based on: (<@com.value blockItem.BasedOn/>)
					</#if>
					<#if pppRelevant??>
						<#if blockItem.Basis?has_content>
							<?linebreak?>basis: <@com.value blockItem.Basis/>
						</#if>
					</#if>
					<#if blockItem.RemarksOnResults?has_content>
						(<@com.value blockItem.RemarksOnResults/>)
					</#if>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro EffectLevelsExtendedList EffectsExtendedRepeatableBlock>
<#compress>
	<#if EffectsExtendedRepeatableBlock?has_content>
		<#list EffectsExtendedRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.Endpoint?has_content>
					<@com.value blockItem.Endpoint/>:
				</#if>
				<#if blockItem.EffectLevel?has_content>
					<@com.range blockItem.EffectLevel/> 
				</#if>
				<#if blockItem.Sex?has_content>
					(<@com.value blockItem.Sex/>)
				</#if>
				<#if blockItem.BasedOn?has_content>
					based on: (<@com.value blockItem.BasedOn/>)
				</#if>
				<#if blockItem.Basis?has_content>
					<@com.value blockItem.Basis/>
				</#if>
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.value blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro TargetSystemOrganToxList TargetRepeatableBlock>
<#compress>
	<#if TargetRepeatableBlock?has_content>
		<#list TargetRepeatableBlock as blockItem>
			<#if com.picklistValueMatchesPhrases(blockItem.CriticalEffectsObserved,["yes"])>
				<#local text_1>
					<#if com.picklistValueMatchesPhrases(blockItem.TreatmentRelated,["yes"])>
						treatment-related
					<#else>
                    	not treatment-related
					</#if>
				</#local>
				<#local text_2>
					<#if com.picklistValueMatchesPhrases(blockItem.DoseResponseRelationship,["yes"])>
                    	dose-response: yes
					<#else>
                    	dose-response: no
					</#if>
				</#local>
				<para role="indent">
                    <#if !pppRelevant??><emphasis role="bold">Target system  / organ toxicity</emphasis><?linebreak?></#if>
					<#if blockItem.System?has_content>
						Lowest effective dose /concentration: <@com.value blockItem.System/>
					</#if>	
					<#if blockItem.Organ?has_content>
						: <@com.value blockItem.Organ/>
					</#if>
					<#if blockItem.LowestEffectiveDoseConc?has_content>
						(lowest effective dose/conc.: <@com.quantity blockItem.LowestEffectiveDoseConc/> ; ${text_1} ; ${text_2})
					</#if>
				</para>
			</#if>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro DetailedToxResultsList DetailedRepeatableBlock>
<#compress>
	<#if DetailedRepeatableBlock?has_content>
		<#list DetailedRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.TableTitleNumber?has_content>
					Table title number: <@com.value blockItem.TableTitleNumber/>.
				</#if>
				<#if blockItem.BasisForTheEffect?has_content>
					Basis for the effect: <@com.value blockItem.BasisForTheEffect/>.
				</#if>
				<#if blockItem.Examination?has_content>
					Examination: <@com.value blockItem.Examination/>.
				</#if>
				<#if blockItem.Score?has_content>
					Score: <@com.value blockItem.Score/>.
				</#if>
				<#if blockItem.Sex?has_content>
					Sex: <@com.value blockItem.Sex/>.
				</#if>
				<#if blockItem.AdditionalCovariate?has_content>
					Additional covariate: <@com.value blockItem.AdditionalCovariate/>.
				</#if>
				<#if blockItem.DoseConc?has_content>
					Dose / conc.: <@com.value blockItem.DoseConc/>.
				</#if>
				<#if blockItem.NoOfAnimalsPerSexPerDose?has_content>
					No. of animals per sex per dose: <@com.value blockItem.NoOfAnimalsPerSexPerDose/>.
				</#if>
				<#if blockItem.TimePoint?has_content>
					Time point: <@com.value blockItem.TimePoint/>.
				</#if>
				<#if blockItem.ResponseValueType?has_content>
					Response value (<@com.value blockItem.ResponseValueType/>):
				</#if>
				<#if blockItem.ReponseValue?has_content>
					<@com.value blockItem.ReponseValue/>
				</#if>
				<#if blockItem.VariationStatistic?has_content>
					(Variation statistics <@com.value blockItem.VariationStatistic/>)
				</#if>
				<#if blockItem.Unit?has_content>
					<@com.value blockItem.Unit/>.
				</#if>
				<#if blockItem.StatisticalSignificance?has_content>
					Statistical significance: <@com.value blockItem.StatisticalSignificance/>.
				</#if>
				<#if blockItem.EffectSize?has_content>
					Effect size (%): <@com.value blockItem.EffectSize/>.
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro TargetSystemOrganToxforEffectLevelsList TargetEffectRepeatableBlock>
<#compress>
	<#if TargetEffectRepeatableBlock?has_content>
		<#list TargetEffectRepeatableBlock as blockItem>
			<#local criticalEffectsObserved><@com.value blockItem.CriticalEffectsObserved/></#local>
			<#if criticalEffectsObserved?contains("yes") || pppRelevant??>
				<para role="indent">
					<#if !pppRelevant??>
						Target system / organ toxicity:
						<?linebreak?>
						<@com.quantity blockItem.LowestEffectiveDoseConc/>
					<#else>
						Critical effects observed: ${criticalEffectsObserved}
						<#if blockItem.LowestEffectiveDoseConc?has_content><?linebreak?>Lowest effective dose/conc. = <@com.quantity blockItem.LowestEffectiveDoseConc/></#if>
					</#if>

					<#if blockItem.System?has_content>
						(on <@com.value blockItem.System/>
					</#if>
					<#if blockItem.Organ?has_content>
						<@com.value blockItem.Organ/>)
						<?linebreak?>
					<#else>
						)
					</#if>

					<#if pppRelevant??>
						<#local details=[]/>
						<#if blockItem.TreatmentRelated?has_content>
							<#local tr>treatment related: <@com.value blockItem.TreatmentRelated/></#local>
							<#local details=details+[tr]/>
						</#if>
						<#if blockItem.DoseResponseRelationship?has_content>
							<#local dr>dose-response relationship: <@com.value blockItem.DoseResponseRelationship/></#local>
							<#local details=details+[dr]/>
						</#if>
						<#if blockItem.RelevantForHumans?has_content>
							<#local hu>relevant for humans: <@com.value blockItem.RelevantForHumans/></#local>
							<#local details=details+[hu]/>
						</#if>
						<#if details?has_content>
							<?linebreak?>(${details?join("; ")})
						</#if>
					</#if>
				</para>
			</#if>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro InductionList InductionRepeatableBlock Endpoint>
<#compress>
	<#if InductionRepeatableBlock?has_content>
		<#list InductionRepeatableBlock as blockItem>
			<#if Endpoint?contains("skin sensitisation: in vivo (non-LLNA)")>
				<para role="indent">
					Induction: <@com.value blockItem.Route/>
					Vehicle: <@com.value blockItem.Vehicle/>
				</para>
			<#elseif Endpoint?contains("skin sensitisation: in vivo (LLNA)")>
	            <para role="indent">
	                Vehicle: <@com.value blockItem.Vehicle/>
				</para>
			</#if>
		</#list>
  	</#if>
</#compress>
</#macro>

<#--TODO The following two macros could be possible merged to one -->
<#macro inVivoLLNAList inVivoLLNARepeatableBlock endPoint>
	<#if !endPoint?contains("(LLNA)")>
		<#return>
	</#if>
	<#compress>
	<#if inVivoLLNARepeatableBlock?has_content>
		<#list inVivoLLNARepeatableBlock as blockItem>
				<#local parameter>
					<@com.value blockItem.Parameter />
				</#local>
				<#if parameter?contains("SI")>
					<#local prefix = "Stimulation index: " />
				<#else>
					<#local prefix = parameter + ": "/>
				</#if>
		        <para role="indent">
					${prefix} <@com.range blockItem.Value/> (<@com.value blockItem.RemarksOnResults/>)
				</para>
		</#list>
  	</#if>
	</#compress>
</#macro>

<#macro inVitroLLNAList inVivoLLNARepeatableBlock endPoint>
	<#if !endPoint?contains("in vitro") && !endPoint?contains("in chemico")>
		<#return>
	</#if>
	<#compress>
		<#if inVivoLLNARepeatableBlock?has_content>
			<#list inVivoLLNARepeatableBlock as blockItem>
				<#if com.picklistValueMatchesPhrases(blockItem.Parameter, ["other:"]) >
					<para role="indent">
						Results:
                        <?linebreak?>
						<@com.value blockItem.Parameter /> <@com.quantity blockItem.Value/> 
						<#if blockItem.RemarksOnResults?has_content>
							(<@com.value blockItem.RemarksOnResults/>)
						</#if>
					</para>
				</#if>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro inVivoNonLLNAList inVivoNonLLNARepeatableBlock endPoint>
	<#if endPoint?contains("non-LLNA")>
		<#compress>
		<#if inVivoNonLLNARepeatableBlock?has_content>
			<#list inVivoNonLLNARepeatableBlock as blockItem>
		<para role="indent">
			<#if blockItem.Reading?has_content>
				No. with positive reactions: <@com.value blockItem.Reading/>
			</#if>	
			<#if blockItem.NoWithReactions?has_content>
				: <@com.number blockItem.NoWithReactions/>
			</#if>
			<#if blockItem.TotalNoInGroup?has_content>
				out of <@com.number blockItem.TotalNoInGroup/>
				<?linebreak?>
			</#if>			
			<#if blockItem.Group?has_content>
				(<@com.value blockItem.Group/>
			</#if>
			<#if blockItem.HoursAfterChallenge?has_content>
				; <@com.number blockItem.HoursAfterChallenge/>
				<#else/>
				<?linebreak?>
			</#if>
			<#if blockItem.DoseLevel?has_content>
				h after challenge; dose: <@com.text blockItem.DoseLevel/>)
				<#else/>
				)
				<?linebreak?>
			</#if>
			<#if blockItem.RemarksOnResults?has_content>
				(<@com.value blockItem.RemarksOnResults/>)
			</#if>
		</para>
		</#list>
		</#if>
		</#compress>
	</#if>
</#macro>

<#macro ControlsList ControlRepeatableBlock>
<#compress>
	<#if ControlRepeatableBlock?has_content>
		<#list ControlRepeatableBlock as blockItem>
			<para role="indent">
				Positive control substance(s): <@com.value blockItem.PositiveControlSubstance/>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro TestResultsList TestResultsRepeatableBlock>
<#compress>
	<#if TestResultsRepeatableBlock?has_content>
		<#list TestResultsRepeatableBlock as blockItem>
			<#local genotoxicity><@com.value blockItem.Genotoxicity/></#local>
			<#local organism><@com.value blockItem.Organism/></#local>
			<#local metActIndicator><@com.value blockItem.MetActIndicator/></#local>
			<#local cytotoxicity><@com.value blockItem.Cytotoxicity/></#local>
			<#local vehContrValid><@com.value blockItem.VehContrValid/></#local>
			<#local negContrValid><@com.value blockItem.NegContrValid/></#local>
			<#local posContrValid><@com.value blockItem.PosContrValid/></#local>
			<#if genotoxicity?has_content || organism?has_content || metActIndicator?has_content || cytotoxicity?has_content || vehContrValid?has_content || negContrValid?has_content || posContrValid?has_content >
			<para role="indent">
				<#if !pppRelevant??>Test results:<?linebreak?></#if>

				${genotoxicity} for ${organism};
				<?linebreak?>
				met. act.: ${metActIndicator}
				<?linebreak?>
				genotoxicity: ${genotoxicity}
				cytotoxicity: ${cytotoxicity}
				<?linebreak?>
				vehicle controls valid: ${vehContrValid}
				<?linebreak?>
				negative controls valid: ${negContrValid}
				<?linebreak?>
				positive controls valid: ${posContrValid}
				<?linebreak?>
			</para>
			</#if>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro TestResultsInVivoList TestResultsRepeatableBlock>
<#compress>
	<#if TestResultsRepeatableBlock?has_content>
		<#list TestResultsRepeatableBlock as blockItem>
			<#local genotoxicity><@com.value blockItem.Genotoxicity/></#local>
			<#local sex><@com.value blockItem.Sex/></#local>
			<#local toxicity><@com.value blockItem.Toxicity/></#local>
			<#local vehContrValid><@com.value blockItem.VehContrValid/></#local>
			<#local negContrValid><@com.value blockItem.NegContrValid/></#local>
			<#local posContrValid><@com.value blockItem.PosContrValid/></#local>
			<#local remarksOnResults><@com.value blockItem.RemarksOnResults/></#local>
			<#if genotoxicity?has_content || sex?has_content || toxicity?has_content || vehContrValid?has_content || negContrValid?has_content || posContrValid?has_content || remarksOnResults?has_content>
			<para role="indent">
				Genotoxicity: ${genotoxicity} (${sex})
				<?linebreak?>
				toxicity: ${toxicity}
				<?linebreak?>
                vehicle controls valid: ${vehContrValid}
                <?linebreak?>
                negative controls valid: ${negContrValid}
                <?linebreak?>
                positive controls valid: ${posContrValid}
                <?linebreak?>
                Remark: ${remarksOnResults}
			</para>
			</#if>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro SpeciesStrainList SpeciesStrainPath>
<#compress>
<#local SpeciesStrainRepeatableBlock = SpeciesStrainPath.SpeciesStrain/>
	<#if SpeciesStrainRepeatableBlock?has_content>
		<#list SpeciesStrainRepeatableBlock as blockItem>
			<para role="indent">
				<@com.value blockItem.SpeciesStrain/>
				<#if SpeciesStrainPath.MetabolicActivation?has_content>
					(<@com.value SpeciesStrainPath.MetabolicActivation/> met. act.)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro EffectLevelsPoList EffectLevelsPORepeatableBlock>
<#compress>
	<#if EffectLevelsPORepeatableBlock?has_content>
		<#list EffectLevelsPORepeatableBlock as blockItem>
			<para role="indent">
				<@com.value blockItem.Endpoint/>
				<#if blockItem.EffectLevel?has_content>
					(PO) <@com.range blockItem.EffectLevel/>)
				<?linebreak?>
				</#if>
				<#if blockItem.Sex?has_content>
					(<@com.value blockItem.Sex/>) 
				</#if>
				<#if blockItem.Basis?has_content>
					based on: <@com.value blockItem.Basis/>
				<?linebreak?>
				</#if>
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.value blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro SecondparentalGenerationP1List SecondPgenerationEffectLevelsRepeatableBlock>
<#compress>
	<#if SecondPgenerationEffectLevelsRepeatableBlock?has_content>
		<#list SecondPgenerationEffectLevelsRepeatableBlock as blockItem>
			<para role="indent">
				<@com.value blockItem.Endpoint/>
				<#if blockItem.EffectLevel?has_content>
					(P1): <@com.range blockItem.EffectLevel/>
				<?linebreak?>
				</#if>				
				<#if blockItem.Sex?has_content>
					(<@com.value blockItem.Sex/>) 
				</#if>	
				<#if blockItem.Basis?has_content>
					based on: <@com.value blockItem.Basis/>
				<?linebreak?>
				</#if>
				<@com.value blockItem.RemarksOnResults/>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro FgenerationList FgenerationListRepeatableBlock>
	<#compress>
		<#if FgenerationListRepeatableBlock?has_content>
			<#list FgenerationListRepeatableBlock as blockItem>
				<para role="indent">
					<@com.value blockItem.Endpoint/>
					<#if pppRelevant?? && blockItem.Generation?has_content>(<@com.value blockItem.Generation/>)</#if>
					<#if blockItem.EffectLevel?has_content>
						: <@com.range blockItem.EffectLevel/>
						<?linebreak?>
					</#if>
					<#if blockItem.Sex?has_content>
						(<@com.value blockItem.Sex/>)
					</#if>
					<#if blockItem.Basis?has_content>
						based on: <@com.value blockItem.Basis/>
						<?linebreak?>
					</#if>
					<@com.value blockItem.RemarksOnResults/>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro OverallReproductiveToxicityList ReproToxRepeatableBlock>
<#compress>
	<#if ReproToxRepeatableBlock?has_content>
		<#list ReproToxRepeatableBlock as blockItem>
			<para role="indent">
				<@com.value blockItem.ReproductiveEffectsObserved/>
				Lowest effective dose / concentration <@com.quantity blockItem.LowestEffectiveDoseConc/>
				<?linebreak?>
				Relation to other toxic effects: <@com.value blockItem.RelationToOtherToxicEffects/>

				<#if pppRelevant??>
					<#local details=[]/>
					<#if blockItem.TreatmentRelated?has_content>
						<#local tr>treatment related: <@com.value blockItem.TreatmentRelated/></#local>
						<#local details=details+[tr]/>
					</#if>
					<#if blockItem.DoseResponseRelationship?has_content>
						<#local dr>dose-response relationship: <@com.value blockItem.DoseResponseRelationship/></#local>
						<#local details=details+[dr]/>
					</#if>
					<#if blockItem.RelevantForHumans?has_content>
						<#local hu>relevant for humans: <@com.value blockItem.RelevantForHumans/></#local>
						<#local details=details+[hu]/>
					</#if>
					<#if details?has_content>
						<?linebreak?>(${details?join("; ")})
					</#if>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro MatAbnormalitiesList MatAbnormalitiesRepeatableBlock>
<#compress>
	<#if MatAbnormalitiesRepeatableBlock?has_content>
		<#list MatAbnormalitiesRepeatableBlock as blockItem>
			<para role="indent">
				<#if !pppRelevant??>Maternal abnormalities </#if><@com.value blockItem.Abnormalities/>
				<?linebreak?>
				localisation: <@com.value blockItem.Localisation/>
				<#if pppRelevant?? && blockItem.DescriptionIncidenceAndSeverity?has_content>
					<?linebreak?>description: <@com.text blockItem.DescriptionIncidenceAndSeverity/>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro FetalAbnormalitiesList FetalAbnormalitiesRepeatableBlock>
<#compress>
	<#if FetalAbnormalitiesRepeatableBlock?has_content>
		<#list FetalAbnormalitiesRepeatableBlock as blockItem>
			<para role="indent">
				<#if !pppRelevant??>Fetal abnormalities </#if><@com.value blockItem.Abnormalities/>
				<?linebreak?>
				localisation: <@com.value blockItem.Localisation/>
				<#if pppRelevant?? && blockItem.DescriptionIncidenceAndSeverity?has_content>
					<?linebreak?>description: <@com.text blockItem.DescriptionIncidenceAndSeverity/>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro OverallDevToxList OverallDevToxRepeatableBlock>
<#compress>
	<#if OverallDevToxRepeatableBlock?has_content>
		<#list OverallDevToxRepeatableBlock as blockItem>
			<para role="indent">
				<@com.value blockItem.DevelopmentalEffectsObserved/>
				<?linebreak?>
				Lowest effective dose / concentration: <@com.quantity blockItem.LowestEffectiveDoseConc/>
				<?linebreak?>
				Relation to maternal toxicity: <@com.value blockItem.RelationToMaternalToxicity/>

				<#if pppRelevant??>
					<#local details=[]/>
					<#if blockItem.TreatmentRelated?has_content>
						<#local tr>treatment related: <@com.value blockItem.TreatmentRelated/></#local>
						<#local details=details+[tr]/>
					</#if>
					<#if blockItem.DoseResponseRelationship?has_content>
						<#local dr>dose-response relationship: <@com.value blockItem.DoseResponseRelationship/></#local>
						<#local details=details+[dr]/>
					</#if>
					<#if blockItem.RelevantForHumans?has_content>
						<#local hu>relevant for humans: <@com.value blockItem.RelevantForHumans/></#local>
						<#local details=details+[hu]/>
					</#if>
					<#if details?has_content>
						<?linebreak?>(${details?join("; ")})
					</#if>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro resultsOfAssaysList block role='indent'>
	<#compress>
		<#if block?has_content>
			<#list block as blockItem>
				<para role="${role}">

					<@com.value blockItem.MaterialDetected/>
					<#if blockItem.Detected>detected<#else>NOT detected</#if>

					<#if blockItem.SampleType?has_content>
						in <@com.value blockItem.SampleType/>
					</#if>

					<#if blockItem.TimePoint?has_content>
						at <@com.quantity blockItem.TimePoint/>
					</#if>

					<#if blockItem.Quantity?has_content>
						: <@com.range blockItem.Quantity/>
					</#if>

				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro assaysList block role='indent' tabular=false>
	<#compress>
		<#if block?has_content>
			<#local assayIndex=0/>
			<#list block as blockItem>
				<#if blockItem.hasElement("AssayType") && blockItem.AssayType?has_content || blockItem.hasElement("LinkAnalyticalMethod") && blockItem.LinkAnalyticalMethod?has_content ||
					blockItem.hasElement("Remarks") && blockItem.Remarks?has_content>
					<#local assayIndex += 1/>
					<#if tabular>
						<informaltable frame="none">
						<col width="25%" />
						<col width="75%" />
						<tbody>
							<tr>
								<td>#${assayIndex}</td>
								<td></td>
							</tr>
							<#if blockItem.hasElement("AssayType") && blockItem.AssayType?has_content>
								<tr>
									<td>Assay type:</td> 
									<td><@com.value blockItem.AssayType/></td>
								</tr>
							</#if>
							<#if blockItem.hasElement("LinkAnalyticalMethod") && blockItem.LinkAnalyticalMethod?has_content>
								<tr>
									<td>Analytical method(s):</td> 
									<td>
										<#list blockItem.LinkAnalyticalMethod as anmethlink>
											<#local anmeth = iuclid.getDocumentForKey(anmethlink)/>
											<@com.text anmeth.name/>
											<#if anmethlink_has_next>, </#if>
										</#list>
									</td>
								</tr>
							</#if>
							<#if blockItem.hasElement("Remarks") && blockItem.Remarks?has_content>
								<tr>
									<td>Remarks:</td> 
									<td><@com.value blockItem.Remarks/></td>
								</tr>
							</#if>	
						</tbody>
						</informaltable>
						<#if blockItem?has_next><@com.emptyLine/></#if>
					<#else>

						<para role="${role}">

							<@com.value blockItem.AssayType/>:
							<#if blockItem.LinkAnalyticalMethod?has_content>
								analytical method(s):
								<#list blockItem.LinkAnalyticalMethod as anmethlink>
									<#local anmeth = iuclid.getDocumentForKey(anmethlink)/>
									<@com.text anmeth.name/>
									<#if anmethlink_has_next>, </#if>
								</#list>
							</#if>
							<#if blockItem.Remarks?has_content>
								(<@com.text blockItem.Remarks/>)
							</#if>
						</para>
					</#if>	
				</#if>	
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro summaryAdditionalInformationForHumanHealth summary valueForCsaText>
<#compress>
	
	<#if valueForCsaText=="valueForCsaTextInhalationEffectsOnFertility">
		<#if summary.Discussion.Discussion?has_content>
		<?linebreak?>
		<@com.emptyLine/>
		<para><emphasis role="underline">Additional information:</emphasis></para>
		<@com.richText summary.Discussion.Discussion/>
		</#if>
	</#if>
	
	<#if valueForCsaText=="valueForCsaTextInhalationDevelopmentalToxicity">
		<#if summary.Discussion.Discussion?has_content>
		<?linebreak?>
		<@com.emptyLine/>
		<para><emphasis role="underline">Additional information:</emphasis></para>
		<@com.richText summary.Discussion.Discussion/>
		</#if>		
	</#if>
	
	<#if valueForCsaText=="valueForCsaTextInhalationCarcinogenicity">
		<#if summary.Discussion.Discussion?has_content>
		<?linebreak?>
		<@com.emptyLine/>
		<para><emphasis role="underline">Additional information:</emphasis></para>
		<@com.richText summary.Discussion.Discussion/>
		</#if>		
	</#if>
	
</#compress>	
</#macro>

<#-- TODO The following isXXXStudy macros could be merged in one -->
<#function isIrritationStudy study>
	<#if !(study?has_content)>
		<#return false>
	</#if>
	<#local InterpretationResults = study.ApplicantSummaryAndConclusion.InterpretationOfResults />
	<#return com.picklistValueMatchesPhrases(InterpretationResults, [".*irritant.*"]) />
</#function>
<#function isEyeIrritantStudy study>
	<#if !(study?has_content)>
		<#return false>
	</#if>
	<#local InterpretationResults = study.ApplicantSummaryAndConclusion.InterpretationOfResults />
	<#return com.picklistValueMatchesPhrases(InterpretationResults, [".*eye.*"]) />
</#function>
<#function isCorrosionStudy study>
	<#if !(study?has_content)>
		<#return false>
	</#if>
	<#local InterpretationResults = study.ApplicantSummaryAndConclusion.InterpretationOfResults />
	<#return com.picklistValueMatchesPhrases(InterpretationResults, [".*corrosive.* || .*irritant.* || .*classification.* || .*GHS.* || .*other:.* || .* .*"]) />
</#function>
<#function isRespiratoryTrackStudy study>
	<#if !(study?has_content)>
		<#return false>
	</#if>
	<#local InterpretationResults = study.ApplicantSummaryAndConclusion.InterpretationOfResults />
	<#return com.picklistValueMatchesPhrases(InterpretationResults, ["Category 1 (irreversible effects on the eye) based on GHS criteria"]) />
</#function>

<#macro inVitroList inVitroRepeatableBlock>
<#compress>
	<#if inVitroRepeatableBlock?has_content>
		<#local sortedList = iuclid.sortByField(inVitroRepeatableBlock, "IrritationCorrosionParameter", ["% tissue viability","transcutaneous electrical resistance (in kΩ)","dye content (µg/disc)","penetration time (in minutes)"]) />

		<#local currentHeader><@com.value sortedList[0].IrritationCorrosionParameter/></#local>
		<para>${currentHeader}</para>

		<#list sortedList as blockItem>
			<#local parameter><@com.value blockItem.IrritationCorrosionParameter/></#local>
			<#if !(currentHeader == parameter)>
				<#local currentHeader = parameter/>
				<para>${currentHeader}</para>
			</#if>
			<para role="indent">
				<#if blockItem.RunExperiment?has_content>
					<@com.text blockItem.RunExperiment/>. 
				</#if>
				<#if blockItem.Value?has_content>
					Value: <@com.range blockItem.Value/>
				</#if>
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.value blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro immunotoxictyInVitroList inVitroRepeatableBlock>
<#compress>

	<#if inVitroRepeatableBlock?has_content>

		<#list inVitroRepeatableBlock as blockItem>

			<#if blockItem.Parameter?has_content>
				<para><@com.value blockItem.Parameter/></para>
			</#if>
			
			<para>				
				<#if blockItem.Group?has_content>
					Group: <@com.value blockItem.Group/> 
				</#if>
				<#if blockItem.RunExperiment?has_content>
					<@com.value blockItem.RunExperiment/>.
				</#if>
				<#if blockItem.Value?has_content>
					Value: <@com.value blockItem.Value/> 
					<#if blockItem.AtConcentration?has_content>
						at Concentration: <@com.value blockItem.AtConcentration/>
					</#if>
				</#if>
				<#if pppRelevant??>
					<#if blockItem.CellViability?has_content>
						Cell viability: <@com.value blockItem.CellViability ""/>
					</#if>
					<#if blockItem.VehicleControlsValidity?has_content>
						Vehicle controls validity: <@com.value blockItem.VehicleControlsValidity/>.
					</#if>
					<#if blockItem.NegativeControlsValidity?has_content>
						Negative controls validity: <@com.value blockItem.NegativeControlsValidity/>.
					</#if>
					<#if blockItem.PositiveControlsValidity?has_content>
						Positive controls validity: <@com.value blockItem.PositiveControlsValidity/>.
					</#if>
				</#if>
				<#if blockItem.RemarksOnResult?has_content>
					Remarks on Result: <@com.picklist blockItem.RemarksOnResult/>
				</#if>	
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro inVivoList inVivoRepeatableBlock>
<#compress>
	<#if inVivoRepeatableBlock?has_content>
		<#local sortedList = iuclid.sortByField(inVivoRepeatableBlock, "Parameter", ["overall irritation score","primary dermal irritation index (PDII)","erythema score","edema score"]) />

		<#local currentHeader><@com.value sortedList[0].Parameter/></#local>
		<para>${currentHeader}</para>

		<#list sortedList as blockItem>
			<#local parameter><@com.value blockItem.Parameter/></#local>
			<#if !(currentHeader == parameter)>
				<#local currentHeader = parameter/>
				<para>${currentHeader}</para>
			</#if>
			<para role="indent">
				<@com.range blockItem.Score/> 
				<#if blockItem.Scale?has_content>
					of max. <@com.number blockItem.Scale/>
				</#if>
				<#if blockItem.TimePoint?has_content>
					(Time point: <@com.value blockItem.TimePoint/>)
				</#if>
				<#if blockItem.Reversibility?has_content>			
					Reversibility: <@com.value blockItem.Reversibility/>
				</#if>
				<para>
					<#if blockItem.RemarksOnResults?has_content>
						(<@com.value blockItem.RemarksOnResults/>)
					</#if>
				</para>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#function determineEndpointTextRepeatedDose endpoint values valuesText emptyText >
    <#if endpoint?has_content>
        <#assign endpointValue><@com.value endpoint /></#assign>
        <#list values as value>
            <#if endpointValue == value>
                <#return valuesText[values?seq_index_of(value)] />
            </#if>
        </#list>
        <#return endpointValue />
    </#if>
    <#return emptyText />
</#function>
<#function determineEndpointTextTypeOfAssay study emptyText>
    <#if study?has_content && study.MaterialsAndMethods.TypeOfAssay?has_content>
        <#assign typeOfAssay><@com.value study.MaterialsAndMethods.TypeOfAssay/></#assign>
    </#if>
    <#assign endpoint>(<@com.value study.AdministrativeData.Endpoint/>)</#assign>
    <#return emptyText + typeOfAssay!"" + routeOfAdministration!"" + endpoint />
</#function>

<#function determineEndpointTextStudyType study emptyText >
    <#if study?has_content && study.MaterialsAndMethods.Studytype?has_content>
        <#assign studyType><@com.value study.MaterialsAndMethods.Studytype/></#assign>
    </#if>
    <#assign routeOfAdministration>(<@com.value study.MaterialsAndMethods.AdministrationExposure.RouteOfAdministration />)</#assign>
    <#assign endpoint>(<@com.value study.AdministrativeData.Endpoint/>)</#assign>
    <#return emptyText + studyType!"" + routeOfAdministration + endpoint />
</#function>
<#function determineEndpointTextRouteOfAdministration study emptyText >
    <#if study?has_content && study.MaterialsAndMethods.AdministrationExposure.RouteOfAdministration?has_content>
        <#assign routeOfAdministration>(<@com.value study.MaterialsAndMethods.AdministrationExposure.RouteOfAdministration />)</#assign>
        <#return emptyText + "(other routes)" + routeOfAdministration />
    </#if>
    <#return emptyText + "(Route: not specified)" />
</#function>

<#-- Macros to separate documents into three lists: 'study results', 'data waiving', 'testing proposal' -->

<#macro populateResultAndDataWaivingAndTestingProposalStudyLists studyList>
	<#assign resultStudyList = [] />
	<#assign dataWaivingStudyList = [] />
	<#assign testingProposalStudyList = [] />
	<#if studyList?has_content>
		<#list studyList as study>
			<#if isTestingProposalStudy(study)>
				<#assign testingProposalStudyList = testingProposalStudyList + [study] />
			<#elseif isDataWaivingStudy(study)>
				<#assign dataWaivingStudyList = dataWaivingStudyList + [study] />
			<#elseif isRelevantAdequacyOfStudy(study)>
				<#assign resultStudyList = resultStudyList + [study] />
			</#if>
		</#list>
	</#if>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign resultStudyList = iuclid.sortByField(resultStudyList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","(Q)SAR","disregarded due to major methodological deficiencies","other information"]) />
</#macro>

<#function isRelevantAdequacyOfStudy study>
	<#if !(study?has_content)>
		<#return false>
	</#if>
	<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
    <#return PurposeFlag?has_content && !com.picklistValueMatchesPhrases(PurposeFlag, ["other information"]) />
</#function>

<#function isDataWaivingStudy study>
	<#if !(study?has_content)>
		<#return false>
	</#if>
	<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
	<#local DataWaiving = study.AdministrativeData.DataWaiving />
    <#return !(PurposeFlag?has_content) && DataWaiving?has_content />
</#function>

<#function isTestingProposalStudy study>
	<#if !(study?has_content)>
		<#return false>
	</#if>
    <#return com.picklistValueMatchesPhrases(study.AdministrativeData.StudyResultType, ["experimental study planned.*"]) />
</#function>

<#macro toxMethodPPP study>
	<#local tox_human = ["ExposureRelatedObservationsOther","SensitisationData","DirectObservationsClinicalCases","EpidemiologicalData","HealthSurveillanceData"] />

	<#if tox_human?seq_contains(study.documentSubType)>
		<@toxHumanMethodPPP study/>
	<#else>
		<@toxNonHumanMethodPPP study/>
	</#if>
</#macro>

<#-- Macros to separate documents into three lists: 'study results', 'data waiving', 'testing proposal' -->
<#macro humanStudyMethod study>

<#local documentID = study.documentType +"."+ study.documentSubType />

	<#if !pppRelevant??>
		<#if study.hasElement("MaterialsAndMethods.StudyType")>
			<para>
				Study type: <@com.value study.MaterialsAndMethods.StudyType/>
			</para>
		</#if>

		<para>
			<#if documentID=="ENDPOINT_STUDY_RECORD.ExposureRelatedObservationsOther">
				<#-- placeholder -->
			<#elseif documentID=="ENDPOINT_STUDY_RECORD.SensitisationData">
				Type of population: <@com.value study.MaterialsAndMethods.Method.TypeOfPopulation/>
			<#else>
				<@com.value study.MaterialsAndMethods.Method.TypeOfPopulation/>
			</#if>
		</para>

		<#if !(documentID=="ENDPOINT_STUDY_RECORD.SensitisationData")>
			<para>
				<#if documentID=="ENDPOINT_STUDY_RECORD.DirectObservationsClinicalCases">
					Subjects: <@com.text study.MaterialsAndMethods.Method.Subjects/>
				<#else>
					Details on study design: <@com.text study.MaterialsAndMethods.Method.DetailsOnStudyDesign/>
				</#if>
			</para>

			<para>
				Endpoint addressed: <@com.value study.MaterialsAndMethods.EndpointAddressed/>
			</para>
		</#if>

		<#if documentID=="ENDPOINT_STUDY_RECORD.SensitisationData">
		Subjects: <@com.text study.MaterialsAndMethods.Method.Subjects/>
		</#if>

		<para>
			<#if study.hasElement("MaterialsAndMethods.TypeOfStudyInformation") && study.MaterialsAndMethods.TypeOfStudyInformation?has_content>
				Study type: <@com.text study.MaterialsAndMethods.TypeOfStudyInformation/>
			</#if>
		</para>

		<para>
			<@studyandsummaryCom.guidelineList study.MaterialsAndMethods.Guideline/>
		</para>

		<para>
			<@com.text study.MaterialsAndMethods.MethodNoGuideline/>
		</para>
	<#else>
	<#--ideally this should be merged with the above-->
		<@toxHumanMethodPPP study/>
	</#if>
</#macro>

<#macro basicHumanStudyResults study>
	<para>
		<@com.text study.ResultsAndDiscussion.Results/>
	</para>
</#macro>

<#macro nonHumanStudyMethod study>

	<#local documentID = study.documentType +"."+ study.documentSubType />

	<#local adminpath = "study." + "AdministrativeData.Endpoint" />
	<#local pathAdmin = adminpath?eval />

	<#local carcinoOralValue><#if com.picklistValueMatchesPhrases(pathAdmin, ["carcinogenicity: oral"])></#if></#local>
	<#local carcinoInhalationValue><#if com.picklistValueMatchesPhrases(pathAdmin, ["carcinogenicity: inhalation"])></#if></#local>
	<#local carcinoDermalValue><#if com.picklistValueMatchesPhrases(pathAdmin, ["carcinogenicity: dermal"])></#if></#local>
	<#local carcinoOtherValue><#if com.picklistValueMatchesPhrases(pathAdmin, ["carcinogenicity, other"])></#if></#local>

	<#assign skinIrritation = getSortedSkinIrritationNonHumanStudy(study, ["skin irritation: in vitro / ex vivo", "skin irritation: in vivo", "skin irritation / corrosion, other"] ) />
	<#assign skinCorrosion = getSortedSkinCorrosionNonHumanStudy(study, ["skin corrosion: in vitro / ex vivo", "skin irritation / corrosion.*"]) />

	<#if csrRelevant?? || svhcRelevant??><#local endpointData><@com.value study.AdministrativeData.Endpoint/></#local></#if>

	<#--	NOTE: PPP: interim solution - to be changed-->
	<#if !pppRelevant??>
		<#-- endpoint and method type -->
		<#if documentID=="ENDPOINT_STUDY_RECORD.SpecificInvestigations">
			<para>
				Endpoint addressed: <@com.value study.MaterialsAndMethods.EndpointAddressed/>
			</para>

			<para>
				Type of effects studied: ${endpointData}
				<#if study.MaterialsAndMethods.MethodType?has_content>
					(<@com.value study.MaterialsAndMethods.MethodType/>)
				</#if>
			</para>
		</#if>

		<#-- type of assay and endpoint, species, test concentration, controls -->
		<#if documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVitro">
			<para>
				<@com.value study.MaterialsAndMethods.TypeOfAssay/>
				
					(${endpointData})
			
			</para>

			<para>
			<@SpeciesStrainList study.MaterialsAndMethods.Method/>
			</para>

			<para>
			Test concentrations: <@com.text study.MaterialsAndMethods.Method.JustificationForDeviationFromTheHighDoseLevel/>
			</para>

			<para>
			<@ControlsList study.MaterialsAndMethods.Method.Controls/>
			</para>
		</#if>

		<#-- study type -->
		<#if documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVivo">
			<para>
				<@com.value study.MaterialsAndMethods.Studytype/>
			</para>

		<#elseif documentID=="ENDPOINT_STUDY_RECORD.AdditionalToxicologicalInformation">
			<para>
				Study type: <@com.text study.MaterialsAndMethods.TypeOfStudyInformation/>
			</para>
		</#if>

		<#-- endpoint -->
	  	<#if documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVivo" ||
		   documentID=="ENDPOINT_STUDY_RECORD.BasicToxicokinetics" ||
		   documentID=="ENDPOINT_STUDY_RECORD.DermalAbsorption" ||
		   documentID=="ENDPOINT_STUDY_RECORD.SkinSensitisation">
			<para>
				${endpointData}
			</para>

			<#if !endpointData?contains("in vivo")>
				<para>in vitro study</para>
			</#if>
		</#if>

		<#-- tissue studied -->
		<#if skinCorrosion?has_content>
		<para>Tissue studied: ${endpointData}</para>
		</#if>

		<#-- species and strain -->
		<#if !(documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVitro" || documentID=="ENDPOINT_STUDY_RECORD.SkinSensitisation")>
			<para>
				<#if study.hasElement("MaterialsAndMethods.TestAnimals.Species")>
				<@com.value study.MaterialsAndMethods.TestAnimals.Species/>
				</#if>

				<#if study.hasElement("MaterialsAndMethods.TestAnimals.Strain")>
					(<@com.value study.MaterialsAndMethods.TestAnimals.Strain/>)
				</#if>
			</para>
			<#elseif documentID=="ENDPOINT_STUDY_RECORD.SkinSensitisation">
				<#if study.hasElement("MaterialsAndMethods.InVivoTestSystem.TestAnimals.Species")>
					<para><@com.value study.MaterialsAndMethods.InVivoTestSystem.TestAnimals.Species/></para>
				</#if>

				<#if study.hasElement("MaterialsAndMethods.InVivoTestSystem.TestAnimals.Strain")>
					<para>(<@com.value study.MaterialsAndMethods.InVivoTestSystem.TestAnimals.Strain/>)</para>
				</#if>
		</#if>

		<#-- sex, coverage and endpoint -->
		<#if !(documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVitro" ||
			documentID=="ENDPOINT_STUDY_RECORD.EyeIrritation" ||
			skinIrritation?has_content ||
			skinCorrosion?has_content ||
			documentID=="ENDPOINT_STUDY_RECORD.DevelopmentalToxicityTeratogenicity")>
			<#if study.hasElement("MaterialsAndMethods.TestAnimals.Sex")>
			<para>
				<@com.value study.MaterialsAndMethods.TestAnimals.Sex/>
			</para>
			</#if>
			<#if study.hasElement("MaterialsAndMethods.InVivoTestSystem.TestAnimals.Sex")>
			<para>
				<@com.value study.MaterialsAndMethods.InVivoTestSystem.TestAnimals.Sex/>
			</para>
			</#if>

			<#if documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityDermal" || documentID=="ENDPOINT_STUDY_RECORD.DermalAbsorption">
				<para>
					Coverage (dermal absorption study): <@com.value study.MaterialsAndMethods.AdministrationExposure.TypeOfCoverage/>
				</para>
			</#if>

			<#if !(carcinoOtherValue?has_content ||
			  carcinoDermalValue?has_content ||
			  carcinoInhalationValue?has_content ||
			  carcinoOralValue?has_content ||
			  documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVivo" ||
			  documentID=="ENDPOINT_STUDY_RECORD.RespiratorySensitisation" ||
			  documentID=="ENDPOINT_STUDY_RECORD.SkinSensitisation" ||
			  documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityOtherRoutes" ||
			  documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityDermal" ||
			  documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityInhalation" ||
			  documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityOral" ||
			  documentID=="ENDPOINT_STUDY_RECORD.SpecificInvestigations" ||
			  documentID=="ENDPOINT_STUDY_RECORD.BasicToxicokinetic" ||
			  documentID=="ENDPOINT_STUDY_RECORD.DermalAbsorption")>
				<para>
					${endpointData}
				</para>
			</#if>
		</#if>

		<#-- endpoint, induction, challenge -->
		<#if documentID=="ENDPOINT_STUDY_RECORD.SkinSensitisation">
			<#if endpointData?contains("skin sensitisation: in vivo (LLNA)")>
				<para>Local lymph node assay</para>
			</#if>

			<#if study.hasElement("MaterialsAndMethods.InVivoTestSystem.StudyDesignInVivoNonLLNA.Induction")>
				<@InductionList study.MaterialsAndMethods.InVivoTestSystem.StudyDesignInVivoNonLLNA.Induction endpointData/>

				<#elseif !endpointData?contains("skin sensitisation: in vivo (LLNA)") && !endpointData?contains("skin sensitisation:  in vitro")>
					<para>${endpointData}</para>
			</#if>

			<#elseif documentID=="ENDPOINT_STUDY_RECORD.RespiratorySensitisation">
			<para>Local lymph node assay</para>

			<para>
				<#if study.MaterialsAndMethods.TestSystem.RouteOfInductionExposure?has_content>
					Induction: <@com.value study.MaterialsAndMethods.TestSystem.RouteOfInductionExposure/>
				</#if>
			</para>

			<para>
				<#if study.MaterialsAndMethods.TestSystem.RouteOfChallengeExposure?has_content>
					Challenge: <@com.value study.MaterialsAndMethods.TestSystem.RouteOfChallengeExposure/>
				</#if>
			</para>
		</#if>

		<#-- coverage -->
		<#if skinIrritation?has_content>
			Coverage: <@com.value study.MaterialsAndMethods.TestSystem.TypeOfCoverage/>
			<#if study.MaterialsAndMethods.TestSystem.PreparationOfTestSite?has_content>
				(<@com.value study.MaterialsAndMethods.TestSystem.PreparationOfTestSite/>)
			</#if>

		<#elseif documentID=="ENDPOINT_STUDY_RECORD.RepeatedDoseToxicityDermal">
			<para>
				<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.TypeOfCoverage")>
					Coverage: <@com.value study.MaterialsAndMethods.AdministrationExposure.TypeOfCoverage/>
				</#if>
			</para>
		</#if>

		<#-- route of administration and type of inhalation -->
		<#if !(carcinoDermalValue?has_content ||
			documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVitro" ||
			documentID=="ENDPOINT_STUDY_RECORD.RepeatedDoseToxicityDermal" ||
			documentID=="ENDPOINT_STUDY_RECORD.RespiratorySensitisation" ||
			documentID=="ENDPOINT_STUDY_RECORD.SkinSensitisation" ||
			documentID=="ENDPOINT_STUDY_RECORD.EyeIrritation" ||
			skinIrritation?has_content ||
			skinCorrosion?has_content ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityOtherRoutes" ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityDermal")>
		<para>
			<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.RouteOfAdministration")>
			<@com.value study.MaterialsAndMethods.AdministrationExposure.RouteOfAdministration/>
			</#if>

			<#if documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityInhalation">
				<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.TypeOfInhalationExposure")>
					(<@com.value study.MaterialsAndMethods.AdministrationExposure.TypeOfInhalationExposure/>)
				</#if>
			</#if>
		</para>
		</#if>

		<#--  type of inhalation -->
		<#if !(carcinoOtherValue?has_content ||
			carcinoOralValue?has_content ||
			documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVivo" ||
			documentID=="ENDPOINT_STUDY_RECORD.RepeatedDoseToxicityOther" ||
			documentID=="ENDPOINT_STUDY_RECORD.RepeatedDoseToxicityInhalation" ||
			documentID=="ENDPOINT_STUDY_RECORD.RepeatedDoseToxicityOral" ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityInhalation" ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityOral" ||
			documentID=="ENDPOINT_STUDY_RECORD.BasicToxicokinetics" ||
			documentID=="ENDPOINT_STUDY_RECORD.Neurotoxicity" ||
			documentID=="ENDPOINT_STUDY_RECORD.Immunotoxicity" ||
			documentID=="ENDPOINT_STUDY_RECORD.SpecificInvestigations")>
			<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.TypeOfInhalationExposureIfApplicable")>
				(<@com.value study.MaterialsAndMethods.AdministrationExposure.TypeOfInhalationExposureIfApplicable/>)
			</#if>
		</#if>

		<#--  frequency of treatment exposure -->
		<#if documentID=="ENDPOINT_STUDY_RECORD.BasicToxicokinetics">
			<para>
				Duration and frequency of treatment / exposure: <@com.value study.MaterialsAndMethods.AdministrationExposure.DurationAndFrequencyOfTreatmentExposure/>
			</para>
				<@DosesConcentrationsWithRemarksList study.MaterialsAndMethods.AdministrationExposure.DosesConcentrations/>			
		</#if>

		<#--  duration of exposure -->
		<#if documentID=="ENDPOINT_STUDY_RECORD.DermalAbsorption">
			<para>
				<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.DurationOfExposure")>
					<@com.text study.MaterialsAndMethods.AdministrationExposure.DurationOfExposure/>
				</#if>
			</para>
		</#if>

		<#-- doses concentration -->
		<#if !(documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVitro" ||
			documentID=="ENDPOINT_STUDY_RECORD.RespiratorySensitisation" ||
			documentID=="ENDPOINT_STUDY_RECORD.SkinSensitisation" ||
			documentID=="ENDPOINT_STUDY_RECORD.EyeIrritation" ||
			skinIrritation?has_content ||
			skinCorrosion?has_content ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityOtherRoutes" ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityDermal" ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityOral" ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityInhalation")>			

			<para>
			<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.DosesConcentrations")>
				<@DosesConcentrationsWithRemarksList study.MaterialsAndMethods.AdministrationExposure.DosesConcentrations/>
			</#if>
			</para>

		<#elseif study.hasElement("MaterialsAndMethods.AdministrationExposure.Doses") && !(documentID=="ENDPOINT_STUDY_RECORD.DermalAbsorption")>
				<para>
					Doses/conc.: <@com.text study.MaterialsAndMethods.AdministrationExposure.Doses/>
				</para>
		</#if>

		<#-- vehicle -->
		<#if documentID=="ENDPOINT_STUDY_RECORD.RespiratorySensitisation" || documentID=="ENDPOINT_STUDY_RECORD.EyeIrritation">
			<#if study.hasElement("MaterialsAndMethods.TestSystem.Vehicle")>
			<para>
				Vehicle: <@com.value study.MaterialsAndMethods.TestSystem.Vehicle/>
			</para>

			</#if>

			<#elseif documentID=="ENDPOINT_STUDY_RECORD.Neurotoxicity" || documentID=="ENDPOINT_STUDY_RECORD.Immunotoxicity" || documentID=="ENDPOINT_STUDY_RECORD.SpecificInvestigations" || documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityDermal" || documentID=="ENDPOINT_STUDY_RECORD.RepeatedDoseToxicityOral" || documentID=="ENDPOINT_STUDY_RECORD.RepeatedDoseToxicityInhalation" || documentID=="ENDPOINT_STUDY_RECORD.RepeatedDoseToxicityDermal" || documentID=="ENDPOINT_STUDY_RECORD.RepeatedDoseToxicityOther" || documentID=="ENDPOINT_STUDY_RECORD.Carcinogenicity" || documentID=="ENDPOINT_STUDY_RECORD.ToxicityReproduction" || documentID=="ENDPOINT_STUDY_RECORD.ToxicityReproductionOther" || documentID=="ENDPOINT_STUDY_RECORD.DevelopmentalToxicityTeratogenicity">
				<para>
					<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.Vehicle")>
					Vehicle: <@com.value study.MaterialsAndMethods.AdministrationExposure.Vehicle/>
					</#if>
				</para>
		</#if>

		<#-- vehicle -->
		<#if skinIrritation?has_content || skinCorrosion?has_content>
			<para>
				<#if study.MaterialsAndMethods.InVitroTestSystem.Vehicle?has_content>
				Vehicle: <@com.value study.MaterialsAndMethods.InVitroTestSystem.Vehicle/>
				</#if>
			</para>
		</#if>

		<#-- duration of exposure, frequency of treatment, in vitro test system -->
		<#if !(documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVivo" ||
			documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVitro" ||
			documentID=="ENDPOINT_STUDY_RECORD.RespiratorySensitisation" ||
			documentID=="ENDPOINT_STUDY_RECORD.SkinSensitisation" ||
			documentID=="ENDPOINT_STUDY_RECORD.EyeIrritation" ||
			skinIrritation?has_content ||
			skinCorrosion?has_content ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityOtherRoutes" ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityDermal" ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityInhalation" ||
			documentID=="ENDPOINT_STUDY_RECORD.AcuteToxicityOral")>
			<#if !(documentID=="ENDPOINT_STUDY_RECORD.DermalAbsorption") || !(documentID=="ENDPOINT_STUDY_RECORD.BasicToxicokinetics") >

			<para>
				<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.DurationOfTreatmentExposure")>
				Exposure: <@com.text study.MaterialsAndMethods.AdministrationExposure.DurationOfTreatmentExposure/>
				</#if>

				<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.FrequencyOfTreatment")>
					(<@com.text study.MaterialsAndMethods.AdministrationExposure.FrequencyOfTreatment/>)
				</#if>
			</para>
			<#else>
				<para>
					<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.DetailsOnInVitroTestSystemIfApplicable")>
					<@com.text study.MaterialsAndMethods.AdministrationExposure.DetailsOnInVitroTestSystemIfApplicable/>
					</#if>
				</para>
			</#if>
		</#if>

		<#-- positive controls -->
		<#if documentID=="ENDPOINT_STUDY_RECORD.GeneticToxicityVivo">
			<para>
			<#if study.hasElement("MaterialsAndMethods.AdministrationExposure.PositiveControls")><@com.text study.MaterialsAndMethods.AdministrationExposure.PositiveControls/></#if>
			</para>
		</#if>

		<#-- guideline followed -->
		<para>
			<@studyandsummaryCom.guidelineList study.MaterialsAndMethods.Guideline/>
		</para>

		<#-- method no. -->
		<para>
			<@com.text study.MaterialsAndMethods.MethodNoGuideline/>
		</para>

	<#else>
		<@toxNonHumanMethodPPP study/>
	</#if>

</#macro>

<#function getSortedSkinIrritationNonHumanStudy study endpointValueList>
	<#if !(study?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
	
		<#local endpoint = study.AdministrativeData.Endpoint />
	<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistValueMatchesPhrases(endpoint, endpointValueList) >
			<#local returnList = returnList + [study] />
		</#if>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>


<#function getSortedSkinCorrosionNonHumanStudy study endpointValueList>
	<#if !(studyList?has_content)>
		<#return []>
	</#if>
	<#local returnList = [] />
		<#local endpoint = study.AdministrativeData.Endpoint />
		<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
		<#if com.picklistValueMatchesPhrases(endpoint, endpointValueList) >
			<#local returnList = returnList + [study] />
		</#if>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign returnList = iuclid.sortByField(returnList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","disregarded due to major methodological deficiencies","other information"]) />
    <#return returnList />
</#function>

<#-------------------------------------PPP: additions------------------------------------------------------------->
<#--1. Methods-->
<#macro toxNonHumanMethodPPP study>
	<#compress>
	<#--BasicToxicokinetics additional test material info (Radiolabelling)-->
		<#if study.documentSubType=="BasicToxicokinetics">
			<#if study.MaterialsAndMethods.TestMaterials.RadiolabelledTestMaterial?has_content>
				<para><emphasis role='bold'>Radiolabelled test material:</emphasis></para>
				<@radioLabelTestMatList study.MaterialsAndMethods.TestMaterials.RadiolabelledTestMaterial/>
			</#if>
		</#if>

	<#-- General tox method characteristics Type of study-->
		<#if pppRelevant??>
			<#local excludeList = ["MethodNoGuideline", "GLPComplianceStatement", "OtherQualityAssurance", "ComplianceWithQualityStandards"]/>
			<#list study.MaterialsAndMethods?children as child>
				<#if child?node_type!="repeatable" && child?node_type!="block" && !(excludeList?seq_contains(child?node_name)) && child?has_content>
					<#--  This is to print a block title for fields falling directly under .MaterialsAndMethods.  -->
					<para><emphasis role="bold">Type of study:</emphasis></para>
					<#break>
				</#if>
			</#list>
			
			<@com.children path=study.MaterialsAndMethods exclude=excludeList style="none" tabular=true/>
		<#else>
			<#if study.MaterialsAndMethods.hasElement("ObjectiveOfStudyPick") && study.MaterialsAndMethods.ObjectiveOfStudyPick?has_content>
				<para><emphasis role="bold">Objective: </emphasis><@com.value study.MaterialsAndMethods.ObjectiveOfStudyPick/></para>
			</#if>

			<#if study.MaterialsAndMethods.hasElement("TypeOfStudy") && study.MaterialsAndMethods.TypeOfStudy?has_content>
				<para><emphasis role='bold'>Type of study: </emphasis><@com.value study.MaterialsAndMethods.TypeOfStudy/></para>
			<#elseif study.MaterialsAndMethods.hasElement("Studytype") && study.MaterialsAndMethods.Studytype?has_content>
				<para><emphasis role='bold'>Type of assay: </emphasis><@com.value study.MaterialsAndMethods.Studytype/></para>
			<#elseif study.MaterialsAndMethods.hasElement("TypeOfStudyInformation") && study.MaterialsAndMethods.TypeOfStudyInformation?has_content>
				<para><emphasis role='bold'>Type of information: </emphasis><@com.text study.MaterialsAndMethods.TypeOfStudyInformation/></para>
			</#if>

			<#if study.MaterialsAndMethods.hasElement("EndpointAddressed") && study.MaterialsAndMethods.EndpointAddressed?has_content>
				<para><emphasis role='bold'>Endpoint addressed: </emphasis><@com.value study.MaterialsAndMethods.EndpointAddressed/></para>
			</#if>

			<#if study.MaterialsAndMethods.hasElement("MethodType") && study.MaterialsAndMethods.MethodType?has_content>
				<para><emphasis role="bold">Method type: </emphasis><@com.value study.MaterialsAndMethods.MethodType/></para>
			</#if>

			<#if study.MaterialsAndMethods.hasElement("TestType") && study.MaterialsAndMethods.TestType?has_content>
				<para><emphasis role="bold">Test type: </emphasis><@com.value study.MaterialsAndMethods.TestType/></para>
			</#if>


			<#if study.MaterialsAndMethods.hasElement("LimitTest") && study.MaterialsAndMethods.LimitTest?has_content>
				<para><emphasis role="bold">Limit test: </emphasis><@com.value study.MaterialsAndMethods.LimitTest/></para>
			</#if>

			<#if study.MaterialsAndMethods.hasElement("JustificationForNonLLNAMethod") && study.MaterialsAndMethods.JustificationForNonLLNAMethod?has_content>
				<para><emphasis role="bold">Justification for non-LLNA method: </emphasis><@com.text study.MaterialsAndMethods.JustificationForNonLLNAMethod/></para>
			</#if>
		</#if>

	<#-- Test animals-->
		<#if study.MaterialsAndMethods.hasElement("TestAnimals") && study.MaterialsAndMethods.TestAnimals?has_content>
			<@methods_testAnimals study.MaterialsAndMethods.TestAnimals/>
		<#elseif study.MaterialsAndMethods.hasElement("TestOrganismsCellLine") && study.MaterialsAndMethods.TestOrganismsCellLine?has_content>
			<@methods_testAnimals study.MaterialsAndMethods.TestOrganismsCellLine/>
		</#if>

	<#--Administration/exposure-->
		<#if study.MaterialsAndMethods.hasElement("AdministrationExposure") && study.MaterialsAndMethods.AdministrationExposure?has_content>
			<@methods_administrationExposure study.MaterialsAndMethods.AdministrationExposure/>
		</#if>

	<#--Test system-->
		<#if study.MaterialsAndMethods.hasElement("TestSystem") && study.MaterialsAndMethods.TestSystem?has_content>
			<#if study.documentSubType=="PhototoxicityVitro">
				<@methods_testSystemPhototox study.MaterialsAndMethods.TestSystem/>
			<#elseif study.documentSubType=="EndocrineDisrupterScreeningInVitro">
			    <@endocrine_testSystemInformation study.MaterialsAndMethods.TestSystem/>
			<#else>
				<@methods_testSystem study.MaterialsAndMethods.TestSystem/>
			</#if>
		</#if>

	<#--In vitro test system-->
		<#if study.MaterialsAndMethods.hasElement("InVitroTestSystem") && study.MaterialsAndMethods.InVitroTestSystem?has_content>
			<para><emphasis role="bold">In vitro test system:</emphasis></para>
			<#if study.documentSubType=="SkinIrritationCorrosion">
				<@methods_inVitroIrritation study.MaterialsAndMethods.InVitroTestSystem/>
			<#elseif study.documentSubType=="SkinSensitisation">
				<@methods_inVitroSensitisation study.MaterialsAndMethods.InVitroTestSystem/>
			<#elseif study.documentSubType=="BasicToxicokinetics">
				<@BasicToxicokineticsInVitroSystem study.MaterialsAndMethods.InVitroTestSystem/>
			</#if>
		</#if>

	<#--In chemico test system (skin sensitisation)-->
		<#if study.MaterialsAndMethods.hasElement("InChemicoTestSystem") && study.MaterialsAndMethods.InChemicoTestSystem?has_content>
			<@methods_inChemico study.MaterialsAndMethods.InChemicoTestSystem/>
		</#if>

	<#--In silico test system (skin sensitisation)-->
		<#if study.MaterialsAndMethods.hasElement("InSilicoTestSystem") && study.MaterialsAndMethods.InSilicoTestSystem?has_content>
			<@methods_inSilico study.MaterialsAndMethods.InSilicoTestSystem/>
		</#if>

	<#--In vivo test system-->
		<#if study.MaterialsAndMethods.hasElement("InVivoTestSystem") && study.MaterialsAndMethods.InVivoTestSystem?has_content>
			<@methods_inVivo study.MaterialsAndMethods.InVivoTestSystem/>
		</#if>

	<#--Examinations-->
		<#if study.MaterialsAndMethods.hasElement("Examinations") && study.MaterialsAndMethods.Examinations?has_content>
			<@methods_examinations study.MaterialsAndMethods.Examinations/>
		</#if>

	<#--Detection method-->
		<#if study.MaterialsAndMethods.hasElement("DetectionMethod") && study.MaterialsAndMethods.DetectionMethod?has_content>
			<@methods_detectionMethod study.MaterialsAndMethods.DetectionMethod/>
		</#if>

	<#--Test design-->	
		<#if study.MaterialsAndMethods.hasElement("TestDesign") && study.MaterialsAndMethods.TestDesign?has_content>
			<#if pppRelevant??>
				<@methods_testDesign design=study.MaterialsAndMethods.TestDesign bgcolor="#d3d3d3"/>
			<#else>
				<@methods_testDesign study.MaterialsAndMethods.TestDesign/>
			</#if>
		</#if>	
	
	<#--Method (genotox vitro)-->
		<#if study.MaterialsAndMethods.hasElement("Method") && study.MaterialsAndMethods.Method?has_content>
			<#if study.documentSubType=='GeneticToxicityVitro'>
				<@methods_methodGenotox study.MaterialsAndMethods.Method/>
			<#else>
				<@methods_method study.MaterialsAndMethods.Method/>
			</#if>
		</#if>

	</#compress>
</#macro>

<#macro radioLabelTestMatList radiolabelledTestMaterialBlock>
	<#compress>
		<#if radiolabelledTestMaterialBlock?has_content>
			<#list radiolabelledTestMaterialBlock as blockItem>
				<#if blockItem.RadiolabelNo?has_content || blockItem.SMILESNotation?has_content || blockItem.RadiochemicalPurity?has_content ||
					blockItem.SpecificActivityAsReceived?has_content || blockItem.SpecificActivityOfDose?has_content || blockItem.Remarks?has_content>
					<informaltable frame="none">
					<col width="25%" />
					<col width="75%" />
					<tbody>
						<#if blockItem.RadiolabelNo?has_content>
							<tr>
								<td><@com.value blockItem.RadiolabelNo/></td>
								<td></td>
							</tr>
						</#if>
						<#if blockItem.SMILESNotation?has_content>
							<tr>
								<td>SMILES notation:</td>
								<td><@com.value blockItem.SMILESNotation ""/></td>
							</tr>
						</#if>	
						<#if blockItem.RadiochemicalPurity?has_content>
							<tr>
								<td>Rediochemical purity (%):</td>
								<td><@com.value blockItem.RadiochemicalPurity/></td>
							</tr>		
						</#if>
						<#if blockItem.SpecificActivityAsReceived?has_content>
							<tr>
								<td>Specific activity as received:</td>
								<td><@com.value blockItem.SpecificActivityAsReceived/></td>
							</tr>	
						</#if>
						<#if blockItem.SpecificActivityOfDose?has_content>
							<tr>
								<td>Specific activity of dose:</td>
								<td><@com.value blockItem.SpecificActivityOfDose/></td>
							</tr>	
						</#if>
						<#if blockItem.Remarks?has_content>
							<tr>
								<td>Remarks:</td>
								<td><@com.value blockItem.Remarks/></td>
							</tr>	
						</#if>
					</tbody>
					</informaltable>
				</#if>
				<#if blockItem?has_next><@com.emptyLine/></#if>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro toxHumanMethodPPP study>
	<#compress>

	<#--Type of study-->
		<#if pppRelevant??>
			<#local excludeList = ["MethodNoGuideline", "GLPComplianceStatement", "OtherQualityAssurance", "ComplianceWithQualityStandards"]/>
			<#list study.MaterialsAndMethods?children as child>
				<#if child?node_type!="repeatable" && child?node_type!="block" && !(excludeList?seq_contains(child?node_name)) && child?has_content>
					<#--  This is to print a block title for fields falling directly under .MaterialsAndMethods.  -->
					<para><emphasis role="bold">Type of study:</emphasis></para>
					<#break>
				</#if>
			</#list>
			<@com.children path=study.MaterialsAndMethods exclude=excludeList style="none" tabular=true/>
		<#else>
			<#if study.MaterialsAndMethods.hasElement("TypeOfSensitisationStudied") && study.MaterialsAndMethods.TypeOfSensitisationStudied?has_content>
				<para><emphasis role='bold'>Type of sensitisation studied: </emphasis><@com.value study.MaterialsAndMethods.TypeOfSensitisationStudied/></para>
			</#if>

			<#if study.MaterialsAndMethods.hasElement("TypeOfStudy") && study.MaterialsAndMethods.TypeOfStudy?has_content>
				<para><emphasis role='bold'>Type of study: </emphasis><@com.value study.MaterialsAndMethods.TypeOfStudy/></para>
			<#elseif study.MaterialsAndMethods.hasElement("Studytype") && study.MaterialsAndMethods.Studytype?has_content>
				<para><emphasis role='bold'>Type of assay: </emphasis><@com.value study.MaterialsAndMethods.Studytype/></para>
			<#elseif study.MaterialsAndMethods.hasElement("TypeOfStudyInformation") && study.MaterialsAndMethods.TypeOfStudyInformation?has_content>
				<para><emphasis role='bold'>Type of information: </emphasis><@com.text study.MaterialsAndMethods.TypeOfStudyInformation ""/></para>
			</#if>

			<#if study.MaterialsAndMethods.hasElement("EndpointAddressed") && study.MaterialsAndMethods.EndpointAddressed?has_content>
				<para><emphasis role='bold'>Endpoint adressed: </emphasis><@com.value study.MaterialsAndMethods.EndpointAddressed/></para>
			</#if>
		</#if>

	<#--Method-->
		<#if study.MaterialsAndMethods.hasElement("Method") && study.MaterialsAndMethods.Method?has_content>
			<@methods_method study.MaterialsAndMethods.Method/>
		</#if>

	</#compress>
</#macro>

<#macro methods_testAnimals testAn subSection=false>
	<#compress>
		<#if subSection>
			<para>Test animals:</para>
		<#else>
			<para><emphasis role="bold">Test animals:</emphasis></para>
		</#if>
		<#if pppRelevant??>
			<@com.children path=testAn style="none" tabular=true/>
		<#else>
			<para role="indent">
				<#if testAn.hasElement("Species") && testAn.Species?has_content>
					<@com.value testAn.Species/>
				</#if>

				<#if testAn.hasElement("Strain") && testAn.Strain?has_content>
					(<@com.value testAn.Strain/>)
				<#elseif testAn.hasElement("StrainCellLine") && testAn.StrainCellLine?has_content>
					(<@com.value testAn.StrainCellLine/>)
				</#if>

				<#if testAn.hasElement("Sex") && testAn.Sex?has_content>
					, <@com.value testAn.Sex/>
				</#if>

				<#if testAn.hasElement("State") && testAn.State?has_content>
					, <@com.value testAn.State/>
				</#if>

				<#if testAn.hasElement("DetailsOnSpeciesStrainSelectio") && testAn.DetailsOnSpeciesStrainSelectio?has_content>
					- <@com.value testAn.DetailsOnSpeciesStrainSelectio/>
				<#elseif testAn.hasElement("DetailsOnSpeciesStrainSelection") && testAn.DetailsOnSpeciesStrainSelection?has_content>
					- <@com.value testAn.DetailsOnSpeciesStrainSelection/>
				</#if>
			</para>

			<#if testAn.hasElement("OrganismDetails") && testAn.OrganismDetails?has_content>
				<para role="indent">
					<@com.value testAn.OrganismDetails/>
				</para>
			<#elseif testAn.hasElement("DetailsOnTestOrganismsTestSystemAndExperimentalCondition") && testAn.DetailsOnTestOrganismsTestSystemAndExperimentalCondition?has_content>
				<para role="indent">
					<@com.value testAn.DetailsOnTestOrganismsTestSystemAndExperimentalCondition/>
				</para>
			<#elseif testAn.hasElement("DetailsOnTestOrganismsTestSystemAndExperimentalConditions") && testAn.DetailsOnTestOrganismsTestSystemAndExperimentalConditions?has_content>
				<para role="indent">
					<@com.value testAn.DetailsOnTestOrganismsTestSystemAndExperimentalConditions/>
				</para>	
			</#if>

			<#if testAn.hasElement("DetailsOnTestAnimalsAndEnvironmentalConditions") && testAn.DetailsOnTestAnimalsAndEnvironmentalConditions?has_content>
				<para role="indent">
					<@com.value testAn.DetailsOnTestAnimalsAndEnvironmentalConditions/>
				</para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#macro methods_administrationExposure admExp>
	<#compress>
		<para><emphasis role="bold">Administration / Exposure:</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=admExp style="none" tabular=true/>

			<#if admExp.hasElement("DosesConcentrations") && admExp.DosesConcentrations?node_type=="repeatable" && admExp.DosesConcentrations?has_content>
				<@DosesConcentrationsFullTable DosesConcentrationsRepeatableBlock=admExp.DosesConcentrations/>
			</#if>

			<#if admExp.hasElement("Controls") && admExp.Controls?node_type=="repeatable" && admExp.Controls?has_content>
				<para><emphasis role="bold">Controls:</emphasis></para>
				<@controlsList controlRepeatableBlock=admExp.Controls tabular=true/>
			</#if>

			<#if admExp.hasElement("Assays") && admExp.Assays?node_type=="repeatable" && admExp.Assays?has_content>
				<para><emphasis role="bold">Assays:</emphasis></para>
				<@assaysList block=admExp.Assays tabular=true/>
			</#if>

		<#else>
			<#if admExp.hasElement("RouteOfAdministration") && admExp.RouteOfAdministration?has_content>
				<para>Route of administration: <@com.value admExp.RouteOfAdministration/></para>
				<#if admExp.hasElement("DetailsOnRouteOfAdministration") && admExp.DetailsOnRouteOfAdministration?has_content>
					<para role="indent">
						<@com.value admExp.DetailsOnRouteOfAdministration/>
					</para>
				</#if>
			</#if>

			<#if admExp.hasElement("TypeOfCoverage") && admExp.TypeOfCoverage?has_content>
				<para>Type of coverage: <@com.value admExp.TypeOfCoverage/></para>
			</#if>

			<#if admExp.hasElement("TypeOfInhalationExposure") && admExp.TypeOfInhalationExposure?has_content>
				<para>Type of inhalation exposure: <@com.value admExp.TypeOfInhalationExposure/></para>
			</#if>

			<#--Cell culture conditions-->
			<#if admExp.hasElement("CellCultures") && admExp.CellCultures?has_content>
				<para>Cell culture: <@com.value admExp.CellCultures/></para>
			</#if>
			<#if admExp.hasElement("PlatingConditions") && admExp.PlatingConditions?has_content>
				<para>Plating conditions: <@com.value admExp.PlatingConditions/></para>
			</#if>
			<#if admExp.hasElement("IncubationConditions") && admExp.IncubationConditions?has_content>
				<para>Incubation conditions: <@com.value admExp.IncubationConditions/></para>
			</#if>

			<#--Vehicle-->
			<#if admExp.hasElement("Vehicle") && admExp.Vehicle?has_content>
				<para>Vehicle: <@com.value admExp.Vehicle/></para>
			</#if>

			<#--Inhalation parameters-->
			<#if admExp.hasElement("MassMedianAerodynamicDiameter") && admExp.MassMedianAerodynamicDiameter?has_content>
				<para>Mass median aerodynamic diameter (MMAD): <@com.value admExp.MassMedianAerodynamicDiameter/></para>
			</#if>
			<#if admExp.hasElement("GeometricStandardDeviation") && admExp.GeometricStandardDeviation?has_content>
				<para>Geometric standard deviation (GSD): <@com.value admExp.GeometricStandardDeviation/></para>
			</#if>
			<#if admExp.hasElement("RemarksOnMMAD") && admExp.RemarksOnMMAD?has_content>
				<para>Remarks on MMAD/GSD:</para><para role="indent"><@com.value admExp.RemarksOnMMAD/></para>
			</#if>

			<#if admExp.hasElement("AnalyticalVerificationOfTestAtmosphereConcentrations") && admExp.AnalyticalVerificationOfTestAtmosphereConcentrations?has_content>
				<para>Analytical verification of test atmosphere concentrations: <@com.value admExp.AnalyticalVerificationOfTestAtmosphereConcentrations/></para>
			</#if>

			<#-- Details on exposure or similar -->
			<#if admExp.hasElement("DetailsOnExposure") && admExp.DetailsOnExposure?has_content>
				<para>Details on exposure: </para><para role="indent"><@com.value admExp.DetailsOnExposure/></para>
			<#elseif admExp.hasElement("DetailsOnDermalExposure") && admExp.DetailsOnDermalExposure?has_content>
				<para>Details on exposure: </para><para role="indent"><@com.value admExp.DetailsOnDermalExposure/></para>
			<#elseif admExp.hasElement("DetailsOnInhalationExposure") && admExp.DetailsOnInhalationExposure?has_content>
				<para>Details on exposure: </para><para role="indent"><@com.value admExp.DetailsOnInhalationExposure/></para>
			<#elseif admExp.hasElement("DetailsOnOralExposure") && admExp.DetailsOnOralExposure?has_content>
				<para>Details on exposure: </para><para role="indent"><@com.value admExp.DetailsOnOralExposure/></para>
			</#if>

			<#--Duration/Frequency-->
			<#if admExp.hasElement("DurationOfTreatmentExposure") && admExp.DurationOfTreatmentExposure?has_content>
				<para>Duration of treatment / exposure: <@com.value admExp.DurationOfTreatmentExposure/></para>
			</#if>
			<#if admExp.hasElement("FrequencyOfTreatment") && admExp.FrequencyOfTreatment?has_content>
				<para>Frequency: <@com.value admExp.FrequencyOfTreatment/></para>
			</#if>
			<#if admExp.hasElement("DurationAndFrequencyOfTreatmentExposure") && admExp.DurationAndFrequencyOfTreatmentExposure?has_content>
				<para>Duration and frequency of exposure: <@com.value admExp.DurationAndFrequencyOfTreatmentExposure/></para>
			</#if>
			<#if admExp.hasElement("DurationOfExposure") && admExp.DurationOfExposure?has_content>
				<para>Duration of exposure:
					<@com.value admExp.DurationOfExposure/>
				</para>
				<#if admExp.hasElement("RemarksOnDuration") && admExp.RemarksOnDuration?has_content>
					<para role="indent"><@com.value admExp.RemarksOnDuration/></para>
				</#if>
			</#if>
			<#if admExp.hasElement("DurationOfTest") && admExp.DurationOfTest?has_content>
				<para>Duration of test:</para><para role="indent"><@com.value admExp.DurationOfTest/></para>
			</#if>
			<#if admExp.hasElement("PostExposurePeriod") && admExp.PostExposurePeriod?has_content>
				<para>Post exposure period:</para><para role="indent"><@com.value admExp.PostExposurePeriod/></para>
			</#if>

			<#-- Doses concentrations -->
			<#if admExp.hasElement("DosesConcentrations") && admExp.DosesConcentrations?has_content>
				<para>Doses / concentrations:</para>
				<#if admExp.DosesConcentrations?node_type=="repeatable">
					<@DosesConcentrationsFullList admExp.DosesConcentrations/>
					<#--  <@DosesConcentrationsWithRemarksList admExp.DosesConcentrations/>  -->
					<#--  <@DosesConcentrationsList admExp.DosesConcentrations/>  -->
				<#else>
					<para role="indent"><@com.value admExp.DosesConcentrations/></para>
				</#if>
			</#if>
			<#if admExp.hasElement("Doses") && admExp.Doses?has_content>
				<para>Doses:</para><para role="indent"><@com.value admExp.Doses/></para>
			</#if>
			<#if admExp.hasElement("Concentrations") && admExp.Concentrations?has_content>
				<para>Concentrations:</para><para role="indent"><@com.value admExp.Concentrations/></para>
			</#if>

			<#if admExp.hasElement("AnalyticalVerificationOfDosesOrConcentrations") && admExp.AnalyticalVerificationOfDosesOrConcentrations?has_content>
				<para>Analytical verification of doses / concentrations: <@com.value admExp.AnalyticalVerificationOfDosesOrConcentrations/></para>
				<#if admExp.hasElement("DetailsOnAnalyticalVerificationOfDosesOrConcentrations") && admExp.DetailsOnAnalyticalVerificationOfDosesOrConcentrations?has_content>
					<para role="indent"><@com.value admExp.DetailsOnAnalyticalVerificationOfDosesOrConcentrations/></para>
				</#if>
			</#if>

			<#--Assays-->
			<#if admExp.hasElement("Assays") && admExp.Assays?has_content>
				<para>Assays:</para>
				<@assaysList admExp.Assays/>
			</#if>

			<#-- Animals -->
			<@animalsMethods admExp />

			<#-- Details-->
			<#if admExp.hasElement("OtherTreatments") && admExp.OtherTreatments?has_content>
				<para>Other treatments:</para><para role="indent"><@com.value admExp.OtherTreatments/></para>
			</#if>

			<#if admExp.hasElement("DetailsOnStudyDesign") && admExp.DetailsOnStudyDesign?has_content>
				<para>Study design:</para><para role="indent"><@com.value admExp.DetailsOnStudyDesign/></para>
			</#if>

			<#if admExp.hasElement("DetailsOnStudySchedule") && admExp.DetailsOnStudySchedule?has_content>
				<para>Study schedule:</para><para role="indent"><@com.value admExp.DetailsOnStudySchedule/></para>
			</#if>

			<#if admExp.hasElement("DetailsOnDosingAndSampling") && admExp.DetailsOnDosingAndSampling?has_content>
				<para>Dosing / sampling:</para><para role="indent"><@com.value admExp.DetailsOnDosingAndSampling/></para>
			</#if>

			<#if admExp.hasElement("DetailsOnInVitroTestSystemIfApplicable") && admExp.DetailsOnInVitroTestSystemIfApplicable?has_content>
				<para>In vitro test system:</para><para role="indent"><@com.value admExp.DetailsOnInVitroTestSystemIfApplicable/></para>
			</#if>

			<#if admExp.hasElement("Statistics") && admExp.Statistics?has_content>
				<para>Statistics:</para><para role="indent"><@com.value admExp.Statistics/></para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#macro animalsMethods admExp>
	<#if admExp.hasElement("NoOfAnimalsPerSexPerDose") && admExp.NoOfAnimalsPerSexPerDose?has_content>
		<para>No. of animals per sex per dose / concentration:</para><para role="indent"><@com.value admExp.NoOfAnimalsPerSexPerDose/></para>
	</#if>
	<#if admExp.hasElement("NoOfAnimalsPerSexPerDoseConcentration") && admExp.NoOfAnimalsPerSexPerDoseConcentration?has_content>
		<para>No. of animals per sex per dose / concentration:</para><para role="indent"><@com.value admExp.NoOfAnimalsPerSexPerDoseConcentration/></para>
	</#if>
	<#if admExp.hasElement("NoOfAnimalsPerGroup") && admExp.NoOfAnimalsPerGroup?has_content>
		<para>No. of animals per group: </para><para role="indent"><@com.value admExp.NoOfAnimalsPerGroup/></para>
	</#if>
	<#if admExp.hasElement("DetailsOnMatingProcedure") && admExp.DetailsOnMatingProcedure?has_content>
		<para>Mating procedure:</para><para role="indent"><@com.value admExp.DetailsOnMatingProcedure/></para>
	</#if>
	<#if admExp.hasElement("ControlAnimal") && admExp.ControlAnimal?has_content>
		<para>Control animals:</para><para role="indent"><@com.value admExp.ControlAnimal/></para>
	<#elseif admExp.hasElement("ControlAnimals") && admExp.ControlAnimals?has_content>
		<para>Control animals:</para><para role="indent"><@com.value admExp.ControlAnimals/></para>
	<#elseif admExp.hasElement("Controls") && admExp.Controls?has_content>  
		<para>Controls:</para>
		<#if admExp.Controls?node_type!="repeatable">
			<para role="indent"><@com.value admExp.Controls/></para>
		<#elseif admExp.Controls?node_type=="repeatable">
			<@controlsList admExp.Controls/>
		</#if>
	</#if>
	<#if admExp.hasElement("PositiveControl") && admExp.PositiveControl?has_content>
		<para>Positive control:</para><para role="indent"><@com.value admExp.PositiveControl/></para>
	</#if>
</#macro>

<#macro methods_examinations exam>
	<#compress>
		<para><emphasis role="bold">Examinations:</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=exam style="none" tabular=true/>
		<#else>
			<#list exam?children as child>
				<#if child?has_content>
					<para>${child?node_name?replace("([A-Z]{1})", " $1", "r")?lower_case?cap_first}:</para><para role="indent"><@com.text child/></para>
				</#if>
			</#list>
		</#if>	
	</#compress>
</#macro>

<#macro methods_detectionMethod method>
	<#compress>
	<para><emphasis role="bold">Detection method:</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=method style="none" tabular=true/>
		<#else>

			<#if method.DetectionMethodUsed?has_content>
				<para role="indent">Detection method used: <@com.value method.DetectionMethodUsed /></para>
			</#if>

			<#if method.DetailsOnDetectionMethod?has_content>
				<para role="indent">Details on detection method: <@com.value method.DetailsOnDetectionMethod "" /></para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#macro methods_testDesign design bgcolor="#FBDDA6">
	<#compress>
	<#if design.hasElement("TestMaterialPreparation") && design.TestMaterialPreparation?has_content>
		<para><emphasis role="bold">Test material preparation:</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=design.TestMaterialPreparation style="none" tabular=true/>
		<#else>

			<#if design.TestMaterialPreparation.hasElement("ConcSelectTestMat") && design.TestMaterialPreparation.ConcSelectTestMat?has_content>
				<para role="indent">Concentration selection on the test material: <@com.value design.TestMaterialPreparation.ConcSelectTestMat /></para>
			</#if>

			<#if design.TestMaterialPreparation.hasElement("Vehicle") && design.TestMaterialPreparation.Vehicle?has_content>
				<para role="indent">Vehicle / solvent: <@com.value design.TestMaterialPreparation.Vehicle /></para>
			</#if>

			<#if design.TestMaterialPreparation.hasElement("DilutionStepsDoseIntervals") && design.TestMaterialPreparation.DilutionStepsDoseIntervals?has_content>
				<para role="indent">Dilution steps / dose intervals: <@com.value design.TestMaterialPreparation.DilutionStepsDoseIntervals "" /></para>
			</#if>
		</#if>		
	</#if>

	<#if design.hasElement("ControlAndReferenceItems") && design.ControlAndReferenceItems?has_content>
		<para><emphasis role="bold">Control and reference items:</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=design.ControlAndReferenceItems style="none" tabular=true/>
		<#else>

			<#if design.ControlAndReferenceItems.hasElement("ControlsReferenceItemsUsed") && design.ControlAndReferenceItems.ControlsReferenceItemsUsed?has_content>
				<para role="indent">Controls / reference items used: <@com.value design.ControlAndReferenceItems.ControlsReferenceItemsUsed /></para>
			</#if>
		</#if>	

		<#if design.ControlAndReferenceItems.hasElement("ControlsReferenceSubstances") && design.ControlAndReferenceItems.ControlsReferenceSubstances?has_content>
			<table border="1">
        		<title>Control / reference items</title>

        		<col width="30%"/>
        		<col width="50%"/>
				<col width="20%"/>

				<tbody>		
				<tr>
            		<th colspan="1"><?dbfo bgcolor="${bgcolor}" ?><emphasis role="bold">Type of controls used</emphasis></th>
            		<th colspan="1"><?dbfo bgcolor="${bgcolor}" ?><emphasis role="bold">Description of reference and control items used</emphasis></th>
					<th colspan="1"><?dbfo bgcolor="${bgcolor}" ?><emphasis role="bold">Remarks</emphasis></th>
        		</tr>

        		<#list design.ControlAndReferenceItems.ControlsReferenceSubstances as controlReferenceSubstance>
					<tr>

        			<td><#if controlReferenceSubstance.TypeOfControls?has_content><@com.value controlReferenceSubstance.TypeOfControls /></#if></td>

        			<td><#if controlReferenceSubstance.ControlOrReferenceItemsUsed?has_content><@com.value controlReferenceSubstance.ControlOrReferenceItemsUsed /></#if></td>

					<td><#if controlReferenceSubstance.Remarks?has_content><@com.value controlReferenceSubstance.Remarks /></#if></td>

					</tr>
        		</#list>

        		</tbody>
    		</table>
		</#if>
	</#if>

	<#if design.hasElement("ExperimentalConditions") && design.ExperimentalConditions?has_content>
		<para><emphasis role="bold">Experimental conditions:</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=design.ExperimentalConditions style="none" tabular=true/>
		<#else>

			<#if design.ExperimentalConditions.hasElement("AdditionalAnalysis") && design.ExperimentalConditions.AdditionalAnalysis?has_content>
				<para role="indent">Additional analysis - e.g. cytotoxicity assay or other: <@com.value design.ExperimentalConditions.AdditionalAnalysis /></para>
			</#if>
		</#if>	
	</#if>	

	<#if design.hasElement("DataAnalysis") && design.DataAnalysis?has_content>
		<para><emphasis role="bold">Data analysis:</emphasis></para>

		<#if pppRelevant??>
			<@com.children path=design.DataAnalysis style="none" tabular=true/>
		<#else>

			<#if design.DataAnalysis.hasElement("AcceptanceCriteria") && design.DataAnalysis.AcceptanceCriteria?has_content>
				<para role="indent">Acceptance criteria for the test material results: <@com.value design.DataAnalysis.AcceptanceCriteria "" /></para>
			</#if>

			<#if design.DataAnalysis.hasElement("DataCalculationAndStatistics") && design.DataAnalysis.DataCalculationAndStatistics?has_content>
				<para role="indent">Data calculation and statistics: <@com.value design.DataAnalysis.DataCalculationAndStatistics "" /></para>
			</#if>

			<#if design.DataAnalysis.hasElement("EvaluationDataInterpretationCriteria") && design.DataAnalysis.EvaluationDataInterpretationCriteria?has_content>
				<para role="indent">Evaluation / data interpretation criteria: <@com.value design.DataAnalysis.EvaluationDataInterpretationCriteria "" /></para>
			</#if>
		</#if>	
	</#if>
	</#compress>
</#macro>

<#macro methods_methodGenotox method>
	<#compress>
		<para><emphasis role="bold">Method:</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=method style="none" tabular=true/>

			<#if method.SpeciesStrain?has_content>
				<para><emphasis role="bold">Species / strain / cell type:</emphasis></para>
				<@speciesStrainMethodList speciesStrainRepeatableBlock=method.SpeciesStrain tabular=true/>
			</#if>

			<#if method.Controls?has_content>
				<para><emphasis role="bold">Controls:</emphasis></para> 
				<@controlsList controlRepeatableBlock=method.Controls tabular=true/>
			</#if>
		<#else>

			<#if method.TargetGene?has_content><para>Target gene:</para><para role="indent"><@com.text method.TargetGene/></para></#if>
			<#if method.SpeciesStrain?has_content>
				<para>Species / strain:</para> <@speciesStrainMethodList method.SpeciesStrain/>
			</#if>

			<#if method.CytokinesisBlockIfUsed?has_content><para>Cytokinesis block: </para><para role="indent"><@com.text method.CytokinesisBlockIfUsed /></para></#if>
			<#if method.MetabolicActivation?has_content><para>Metabolic activation: <@com.value method.MetabolicActivation/></para>
				<#if method.MetabolicActivationSystem?has_content><para role="indent"><@com.text method.MetabolicActivationSystem/></para></#if>
			</#if>

			<#if method.JustificationForDeviationFromTheHighDoseLevel?has_content><para role="indent">Doses:</para><para role="indent"><@com.text method.JustificationForDeviationFromTheHighDoseLevel/></para></#if>
			<#if method.Vehicle?has_content><para role="indent">Vehicle: </para><para role="indent"><@com.text method.Vehicle/></para></#if>

			<#if method.Controls?has_content>
				<para>Controls:</para> <@controlsList method.Controls/>
			</#if>

			<#if method.DetailsOnTestSystemAndConditions?has_content><para>Test conditions:</para><para role="indent"><@com.text method.DetailsOnTestSystemAndConditions/></para>
				<#if method.RationaleForTestConditions?has_content><para role="indent2"><@com.text method.RationaleForTestConditions/></para></#if>
			</#if>

			<#if method.EvaluationCriteria?has_content><para>Evaluation criteria:</para><para role="indent"><@com.text method.EvaluationCriteria/></para></#if>
			<#if method.Statistics?has_content><para role="indent">Statistics:</para><para role="indent"><@com.text method.Statistics/></para></#if>
		</#if>
	</#compress>
</#macro>

<#macro methods_method method>
	<#compress>
		<#--specific for Medical data docs-->
		<para><emphasis role="bold">Method:</emphasis></para>

		<#if pppRelevant??>
			<@com.children path=method style="none" tabular=true/>
		<#else>

			<#if method.hasElement("TypeOfPopulation") && method.TypeOfPopulation?has_content>
				<para>Type of population:<@com.value method.TypeOfPopulation/></para>
			</#if>
			<#if method.hasElement("Subjects") && method.Subjects?has_content>
				<para>Subjects: </para><para role="indent"><@com.text method.Subjects/></para>
			</#if>
			<#if method.hasElement("Controls") && method.Controls?has_content>
				<para>Controls: </para><para role="indent"><@com.text method.Controls/></para>
			</#if>
			<#if method.hasElement("EthicalApproval") && method.EthicalApproval?has_content>
				<para>Ethical approval: <@com.value method.EthicalApproval/></para>
			</#if>
			<#if method.hasElement("DetailsOnStudyDesign") && method.DetailsOnStudyDesign?has_content>
				<para>Details on study design: </para><para role="indent"><@com.text method.DetailsOnStudyDesign ""/></para>
			</#if>
			<#if method.hasElement("RouteOfExposure") && method.RouteOfExposure?has_content>
				<para>Route of exposure: <@com.value method.RouteOfExposure/></para>
			</#if>
			<#if method.hasElement("RouteOfAdministration") && method.RouteOfAdministration?has_content>
				<para>Route of administration: <@com.value method.RouteOfAdministration/></para>
			</#if>
			<#if method.hasElement("ReasonOfExposure") && method.ReasonOfExposure?has_content>
				<para>Reason: <@com.value method.ReasonOfExposure/></para>
			</#if>
			<#if method.hasElement("ExposureAssessment") && method.ExposureAssessment?has_content>
				<para>Exposure assessment: <@com.value method.ExposureAssessment/></para>
				<#if method.hasElement("DetailsOnExposure") && method.DetailsOnExposure?has_content>
					<para role="indent"><@com.text method.DetailsOnExposure/></para>
				</#if>
			</#if>
			<#if method.hasElement("ClinicalHistory") && method.ClinicalHistory?has_content>
				<para>Clinical history: </para><para role="indent"><@com.text method.ClinicalHistory/></para>
			</#if>
			<#if method.hasElement("Examinations") && method.Examinations?has_content>
				<para>Examinations: </para><para role="indent"><@com.text method.Examinations/></para>
			</#if>
			<#if method.hasElement("MedicalTreatment") && method.MedicalTreatment?has_content>
				<para>Medical treatment: </para><para role="indent"><@com.text method.MedicalTreatment/></para>
			</#if>
			<#if method.hasElement("StatisticalMethods") && method.StatisticalMethods?has_content>
				<para>Statistics: </para><para role="indent"><@com.text method.StatisticalMethods/></para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#macro methods_testSystem testSys>
	<#-- Used in skin irritation, eye irritation-->
	<#compress>
		<para><emphasis role="bold">Test system:</emphasis></para>
	<#if pppRelevant??>
		<@com.children path=testSys style="none" tabular=true/>
	<#else>

		<#if testSys.hasElement("TypeOfCoverage") && testSys.TypeOfCoverage?has_content>
			<para>Type of coverage: <@com.value testSys.TypeOfCoverage/></para>
		</#if>

		<#if testSys.hasElement("PreparationOfTestSite") && testSys.PreparationOfTestSite?has_content>
			<para>Preparation of test site: <@com.value testSys.PreparationOfTestSite/></para>
		</#if>

		<#--Controls-->
		<#if testSys.hasElement("Controls") && testSys.Controls?has_content>
			<para>Controls: <@com.value testSys.Controls/></para>
		</#if>

		<#--Vehicle-->
		<#if testSys.hasElement("Vehicle") && testSys.Vehicle?has_content>
			<para>Vehicle: <@com.value testSys.Vehicle/></para>
		</#if>

		<#-- Doses concentrations (name has _list appended)-->
		<#if testSys.hasElement("AmountConcentrationApplied") && testSys.AmountConcentrationApplied?has_content>
			<para>Doses: </para><para role="indent"><@com.text testSys.AmountConcentrationApplied/></para>
		</#if>

		<#--Duration/Frequency-->
		<#if testSys.hasElement("DurationOfTreatmentExposure") && testSys.DurationOfTreatmentExposure?has_content>
			<para>Duration: </para><para role="indent"><@com.text testSys.DurationOfTreatmentExposure/></para>
		</#if>
		<#if testSys.hasElement("ObservationPeriod") && testSys.ObservationPeriod?has_content>
			<para>Observation period: </para><para role="indent"><@com.text testSys.ObservationPeriod/></para>
		</#if>
		<#if testSys.hasElement("DurationOfPostTreatmentIncubationInVitro") && testSys.DurationOfPostTreatmentIncubationInVitro?has_content>
			<para>Duration of post-treatment incubation (in vitro): </para><para role="indent"><@com.text testSys.DurationOfPostTreatmentIncubationInVitro/></para>
		</#if>

		<#--No animals-->
		<#if testSys.hasElement("NumberOfAnimals") && testSys.NumberOfAnimals?has_content>
			<para role="indent">No. of animals / in-vitro replicates: <@com.text testSys.NumberOfAnimals/></para>
		</#if>

		<#--Details-->
		<#if testSys.hasElement("DetailsOnStudyDesign") && testSys.DetailsOnStudyDesign?has_content>
			<para>Details on study design: </para><para role="indent"><@com.text testSys.DetailsOnStudyDesign/></para>
		</#if>
	</#if>	
	</#compress>
</#macro>

<#macro methods_testSystemPhototox testSys>
	<#compress>
		<para><emphasis role="bold">Test system:</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=testSys style="none" tabular=true/>

			<#if testSys.SpeciesStrain?has_content>
				<para><emphasis role="bold">Species / strain / cell type:</emphasis></para>
				<@speciesStrainMethodList speciesStrainRepeatableBlock=testSys.SpeciesStrain tabular=true/>
			</#if>
			<#if testSys.Controls?has_content>
				<para><emphasis role="bold">Controls:</emphasis></para>
				<@controlsList controlRepeatableBlock=testSys.Controls tabular=true/>
			</#if>
		<#else>

			<#--Species-->
			<#if testSys.SpeciesStrain?has_content>
				<para>Species / strain / cell type:</para><@speciesStrainMethodList testSys.SpeciesStrain/>
			</#if>

			<#--Controls-->
			<#if testSys.Controls?has_content>
				<para>Controls: </para><@controlsList testSys.Controls/>
			</#if>

			<#--Vehicle-->
			<#if testSys.Vehicle?has_content>
				<para>Vehicle: <@com.value testSys.Vehicle/></para>
			</#if>
			<#if testSys.VehicleSolvent?has_content>
				<para>Vehicle / solvent: </para><para role="indent"><@com.text testSys.VehicleSolvent/></para>
			</#if>

			<#--Other-->
			<#if testSys.TestSystemExpConditions?has_content>
				<para>Details on test system and experimental conditions:</para><para role="indent"><@com.text testSys.TestSystemExpConditions/></para>
			</#if>
			<#if testSys.EvaluationCriteria?has_content>
				<para>Evaluation criteria: </para><para role="indent"><@com.text testSys.EvaluationCriteria/></para>
			</#if>
			<#if testSys.Statistics?has_content>
				<para>Statistics: </para><para role="indent"><@com.text testSys.Statistics/></para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#macro methods_inVitroIrritation vitroSys>
	<#compress>
	<#if pppRelevant??>
		<@com.children path=vitroSys style="none" tabular=true/>
	<#else>

		<#--Test system-->
		<#if vitroSys.TestSystem?has_content>
			<para>Test system: <@com.value vitroSys.TestSystem/></para>
			<#if vitroSys.DetailsOnTestSystem?has_content>
				<para role="indent"><@com.text vitroSys.DetailsOnTestSystem/></para>
			</#if>
			<#if vitroSys.JustificationForTestSystemUsed?has_content>
				<para role="indent">Justification: <@com.text vitroSys.JustificationForTestSystemUsed/></para>
			</#if>
		</#if>

		<#--Species and cell type -->
		<#if vitroSys.SourceSpecies?has_content>
			<para>Source species: <@com.value vitroSys.SourceSpecies/>
				<#if vitroSys.SourceStrain?has_content>
					(<@com.value vitroSys.SourceStrain/>)
				</#if>
			</para>
			<#if vitroSys.DetailsOnAnimalUsedAsSourceOfTestSystem?has_content>
				<para role="indent"><@com.text vitroSys.DetailsOnAnimalUsedAsSourceOfTestSystem/></para>
			</#if>
		</#if>

		<#if vitroSys.CellType?has_content>
			<para>Cell type: <@com.value vitroSys.CellType/>
				<#if vitroSys.CellSource?has_content>
					from <@com.value vitroSys.CellSource/>
				</#if>
			</para>
		</#if>

		<#--Vehicle-->
		<#if vitroSys.Vehicle?has_content>
			<para>Vehicle: <@com.value vitroSys.Vehicle/></para>
		</#if>

		<#if vitroSys.ControlSamples?has_content>
			<para>Control samples: <@com.value vitroSys.ControlSamples/></para>
		</#if>

		<#--Treatment-->
		<#if vitroSys.AmountConcentrationApplied?has_content>
			<para>Doses: </para><para role="indent"><@com.text vitroSys.AmountConcentrationApplied/></para>
		</#if>
		<#if vitroSys.DurationOfTreatmentExposure?has_content>
			<para>Duration:</para><para role="indent"><@com.text vitroSys.DurationOfTreatmentExposure/></para>
		</#if>
		<#if vitroSys.DurationOfPostTreatmentIncubationIfApplicable?has_content>
			<para>Duration of post-treatment incubation: </para><para role="indent"><@com.text vitroSys.DurationOfPostTreatmentIncubationIfApplicable/></para>
		</#if>

		<#if vitroSys.NumberOfReplicates?has_content>
			<para>No. of replicates: </para><para role="indent"><@com.text vitroSys.NumberOfReplicates/></para>
		</#if>
	</#if>	
	</#compress>
</#macro>

<#macro methods_inVitroSensitisation vitroSys>
	<#compress>
	<#if pppRelevant??>
		<@com.children path=vitroSys style="none" tabular=true/>	
	<#else>
		<#--Test system-->
			<#if vitroSys.DetailsTestSystem?has_content>
				<para>Test system: <@com.value vitroSys.DetailsTestSystem/></para>
			</#if>

		<#--Controls-->
			<#if vitroSys.VehicleSolventControl?has_content>
				<para>Vehicle / solvent control: <@com.value vitroSys.VehicleSolventControl/></para>
			</#if>
			<#if vitroSys.NegativeControl?has_content>
				<para>Negative control: <@com.value vitroSys.NegativeControl/></para>
			</#if>
			<#if vitroSys.PositiveControl?has_content>
				<para>Positive control: <@com.value vitroSys.PositiveControl/></para>
			</#if>

			<#if vitroSys.DetailsOnStudyDesign?has_content>
				<para>Details on study design: </para><para role="indent"><@com.text vitroSys.DetailsOnStudyDesign/></para>
			</#if>
	</#if>	
	</#compress>
</#macro>

<#macro methods_inVivo vivoSys>
<#--	skin sensitisation-->
	<#compress>
		<para><emphasis role="bold">In vivo test system:</emphasis></para>

	<#--Test animals-->
		<#if vivoSys.TestAnimals?has_content>
			<@methods_testAnimals vivoSys.TestAnimals true/>
		</#if>

	<#--NonLLNA-->
		<#if vivoSys.StudyDesignInVivoNonLLNA?has_content>
			<@methods_inVivoNonLLNA vivoSys.StudyDesignInVivoNonLLNA />
		</#if>

	<#--LLNA-->
		<#if vivoSys.StudyDesignInVivoLLNA?has_content >
			<@methods_inVivoLLNA vivoSys.StudyDesignInVivoLLNA />
		</#if>
	</#compress>
</#macro>

<#macro methods_inVivoLLNA llna>
	<#compress>
		<para><emphasis role="bold">Study design: LLNA</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=llna style="none" tabular=true/>	
		<#else>
			<#if llna.Vehicle?has_content>
				<para role="indent">Vehicle: <@com.value llna.Vehicle/></para>
			</#if>
			<#if llna.Concentration?has_content>
				<para role="indent">Concentration: <@com.text llna.Concentration/></para>
			</#if>
			<#if llna.NoOfAnimalsPerDose?has_content>
				<para role="indent">No animals per dose: <@com.text llna.NoOfAnimalsPerDose/></para>
			</#if>
			<#if llna.PositiveControlSubstances?has_content>
				<para role="indent">Positive control substances: <@com.value llna.PositiveControlSubstances/></para>
			</#if>
			<#if llna.DetailsOnStudyDesign?has_content>
				<para role="indent">Details on study design: <@com.text llna.DetailsOnStudyDesign/></para>
			</#if>
			<#if llna.Statistics?has_content>
				<para role="indent">Statistics: <@com.text llna.Statistics/></para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#macro methods_inVivoNonLLNA nonllna>
	<#compress>
	<para><emphasis role="bold">Study design: non-LLNA</emphasis></para>

	<#if pppRelevant??>
		<@com.children path=nonllna style="none" tabular=true/>	
		
		<#if nonllna.Induction?has_content>
			<@InductionChallengeTable InductionChallengeRepeatableBlock=nonllna.Induction tabletitle="Induction"/>
		</#if>

		<#if nonllna.Challenge?has_content>
			<@InductionChallengeTable InductionChallengeRepeatableBlock=nonllna.Challenge tabletitle="Challenge"/>
		</#if>

	<#else>

		<#if nonllna.Induction?has_content>
			<para role="indent">Induction:</para>
			<@InductionChallengeList nonllna.Induction "indent2"/>
		</#if>

		<#if nonllna.Challenge?has_content>
			<para role="indent">Challenge:</para>
			<@InductionChallengeList nonllna.Challenge "indent2"/>
		</#if>

		<#if nonllna.NoOfAnimalsPerDose?has_content>
			<para role="indent">No animals per dose: <@com.text nonllna.NoOfAnimalsPerDose/></para>
		</#if>
		<#if nonllna.PositiveControlSubstances?has_content>
			<para role="indent">Positive control substances: <@com.value nonllna.PositiveControlSubstances/></para>
		</#if>
		<#if nonllna.ChallengeControls?has_content>
			<para role="indent">Challenge controls: <@com.text nonllna.ChallengeControls/></para>
		</#if>
		<#if nonllna.DetailsOnStudyDesign?has_content>
			<para role="indent">Details on study design: <@com.text nonllna.DetailsOnStudyDesign/></para>
		</#if>
	</#if>
	</#compress>
</#macro>

<#macro methods_inChemico chemSys>
<#--skin sensitisation-->
	<#compress>
		<para><emphasis role="bold">In chemico test system:</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=chemSys style="none" tabular=true/>
		<#else>

			<#if chemSys.DetailsTestSystem?has_content>
				<para>Test system: <@com.value chemSys.DetailsTestSystem/></para>
			</#if>

			<#if chemSys.VehicleSolvent?has_content>
				<para>Vehicle / solvent: <@com.value chemSys.VehicleSolvent/></para>
			</#if>

			<#if chemSys.PositiveControl?has_content>
				<para>Positive control: <@com.value chemSys.PositiveControl/></para>
			</#if>

			<#if chemSys.DetailsOnStudyDesign?has_content>
				<para>Details on study design: </para><para role="indent"><@com.text chemSys.DetailsOnStudyDesign/></para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#macro methods_inSilico silicoSys>
<#--skin sensitisation-->
	<#compress>
		<para><emphasis role="bold">In silico test system:</emphasis></para>
		<#if pppRelevant??>
			<@com.children path=silicoSys style="none" tabular=true/>
		<#else>

			<#if silicoSys.DetailsOfTestSystem?has_content>
				<para>Test system: <@com.value silicoSys.DetailsOfTestSystem/></para>
			</#if>

			<#if silicoSys.DetailsOnTheStudyDesign?has_content>
				<para>Details on study design: </para><para role="indent"><@com.value silicoSys.DetailsOnTheStudyDesign/></para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#macro InductionChallengeList InductionChallengeRepeatableBlock role="indent" tabular=false>
	<#compress>
		<#if InductionChallengeRepeatableBlock?has_content>
			<#local InductionChallengeIndex=0/>
			<#list InductionChallengeRepeatableBlock as blockItem>
				<#if blockItem.hasElement("No") && blockItem.No?has_content || blockItem.hasElement("Route") && blockItem.Route?has_content || 
					blockItem.hasElement("Vehicle") && blockItem.Vehicle?has_content || blockItem.hasElement("ConcentrationAmount") && blockItem.ConcentrationAmount?has_content ||
					blockItem.hasElement("DaySDuration") && blockItem.DaySDuration?has_content || blockItem.hasElement("AdequacyOfInduction") && blockItem.AdequacyOfInduction?has_content ||
					blockItem.hasElement("AdequacyOfChallenge") && blockItem.AdequacyOfChallenge?has_content>
					<#local InductionChallengeIndex += 1/>
					<#if tabular>
						<informaltable frame="none">
						<col width="25%" />
						<col width="75%" />
						<tbody>
							<tr>
								<td>
									<#if blockItem.hasElement("No") && blockItem.No?has_content>
										<@com.value blockItem.No/>
									<#else>
										#${InductionChallengeIndex}
									</#if>	
								</td>
								<td></td>
							</tr>

							<#if blockItem.hasElement("Route") && blockItem.Route?has_content>
								<tr>
									<td>Route:</td>
									<td><@com.value blockItem.Route/></td>
								</tr>
							</#if>
							<#if blockItem.hasElement("Vehicle") && blockItem.Vehicle?has_content>
								<tr>
									<td>Vehicle:</td>
									<td><@com.value blockItem.Vehicle/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("ConcentrationAmount") && blockItem.ConcentrationAmount?has_content>
								<tr>
									<td>Concentration / amount:</td>
									<td><@com.value blockItem.ConcentrationAmount/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("DaySDuration") && blockItem.DaySDuration?has_content>
								<tr>
									<td>Day(s) / duration:</td>
									<td><@com.value blockItem.DaySDuration/></td>
								</tr>
							</#if>
							<#if blockItem.hasElement("AdequacyOfInduction") && blockItem.AdequacyOfInduction?has_content>
								<tr>
									<td>Adequacy:</td>
									<td><@com.value blockItem.AdequacyOfInduction/></td>
								</tr>
							</#if>
							<#if blockItem.hasElement("AdequacyOfChallenge") && blockItem.AdequacyOfChallenge?has_content>
								<tr>
									<td>Adequacy:</td>
									<td><@com.value blockItem.AdequacyOfChallenge/></td>
								</tr>
							</#if>
						</tbody>
						</informaltable>
						<#if blockItem?has_next><@com.emptyLine/></#if>

					<#else>
						<para role = "${role}">
							<#if blockItem.hasElement("No") && blockItem.No?has_content>
								<@com.value blockItem.No/>.
							</#if>
							Route: <@com.value blockItem.Route/>.
							Vehicle: <@com.value blockItem.Vehicle/>.
							<#if blockItem.ConcentrationAmount?has_content>
								Conc.: <@com.text blockItem.ConcentrationAmount/>.
							</#if>
							<#if blockItem.DaySDuration?has_content>
								Duration: <@com.text blockItem.DaySDuration/>.
							</#if>
							<#if blockItem.hasElement("AdequacyOfInduction") && blockItem.AdequacyOfInduction?has_content>
								Adequacy: <@com.value blockItem.AdequacyOfInduction/>.
							<#elseif blockItem.hasElement("AdequacyOfChallenge") && blockItem.AdequacyOfChallenge?has_content>
								Adequacy: <@com.value blockItem.AdequacyOfChallenge/>.
							</#if>
						</para>
					</#if>
				</#if>
			</#list>
		</#if>
	</#compress>
</#macro>

<#--  
	Macro to output the Induction and Challenge (Skin Sensitisation) information in a table.  
-->
<#macro InductionChallengeTable InductionChallengeRepeatableBlock bgcolor="#D3D3D3" tabletitle="">
	<#compress>
		<#if InductionChallengeRepeatableBlock?has_content>
			<table border="1">
				<title>${tabletitle}</title>

				<#list InductionChallengeRepeatableBlock as blockItem>
					<#local colNumb = 0/>
					<#list blockItem?children as child>
						<#local colNumb += 1/>
					</#list>
					<#break>
				</#list>

				<#if colNumb == 6>
					<col width="10%" />
					<col width="17%" />
					<col width="18%" />
					<col width="20%" />
					<col width="17%" />
					<col width="18%" />
				<#elseif colNumb == 5>
					<col width="20%" />
					<col width="20%" />
					<col width="20%" />
					<col width="20%" />
					<col width="20%" />
				</#if>

				<thead align="center" valign="middle">
					<#list InductionChallengeRepeatableBlock as blockItem>
						<tr>
							<#if blockItem.hasElement("No")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">No.</emphasis></th></#if>
							<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Route</emphasis></th>
							<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Vehicle</emphasis></th>
							<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Concentration / amount</emphasis></th>
							<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Day(s) / duration</emphasis></th>
							<#if blockItem.hasElement("AdequacyOfInduction")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Adequacy of induction</emphasis></th></#if>
							<#if blockItem.hasElement("AdequacyOfChallenge")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Adequacy of challenge</emphasis></th></#if>
						</tr>
						<#break>
					</#list>
				</thead>
			
				<tbody valign="middle">
					<#list InductionChallengeRepeatableBlock as blockItem>
						<tr>
							<#if blockItem.hasElement("No")>
								<td><@com.value blockItem.No/></td>
							</#if>

							<#if blockItem.hasElement("Route")>
								<td><@com.value blockItem.Route/></td>
							</#if>
							<#if blockItem.hasElement("Vehicle")>
								<td><@com.value blockItem.Vehicle/></td>
							</#if>	
							<#if blockItem.hasElement("ConcentrationAmount")>
								<td><@com.value blockItem.ConcentrationAmount/></td>
							</#if>	
							<#if blockItem.hasElement("DaySDuration")>
								<td><@com.value blockItem.DaySDuration/></td>
							</#if>
							<#if blockItem.hasElement("AdequacyOfInduction")>
								<td><@com.value blockItem.AdequacyOfInduction/></td>
							</#if>
							<#if blockItem.hasElement("AdequacyOfChallenge")>
								<td><@com.value blockItem.AdequacyOfChallenge/></td>
							</#if>
						</tr>
					</#list>
				</tbody>
			</table>
		</#if>
	</#compress>
</#macro>

<#--There is an existing macro in keyTOX but combines different elements in that case-->
<#macro speciesStrainMethodList speciesStrainRepeatableBlock role="indent" tabular=false>
	<#compress>
		<#if speciesStrainRepeatableBlock?has_content>
			<#local speciesStrainIndex=0/>
			<#list speciesStrainRepeatableBlock as blockItem>
				<#if blockItem.hasElement("SpeciesStrain") && blockItem.SpeciesStrain?has_content || blockItem.hasElement("SpeciesStrainCell") && blockItem.SpeciesStrainCell?has_content || 
					blockItem.hasElement("AdditionalStrainCharacteristics") && blockItem.AdditionalStrainCharacteristics?has_content || blockItem.hasElement("MammalianCellDetails") && blockItem.MammalianCellDetails?has_content ||
					blockItem.hasElement("DetailsOnMammalianCellLinesIfApplicable") && blockItem.DetailsOnMammalianCellLinesIfApplicable?has_content>
					<#local speciesStrainIndex += 1/>
					<#if tabular>
						<informaltable frame="none">
						<col width="25%" />
						<col width="75%" />
						<tbody>
							<tr>
								<td>#${speciesStrainIndex}</td>
								<td></td>
							</tr>

							<#if blockItem.hasElement("SpeciesStrain") && blockItem.SpeciesStrain?has_content>
								<tr>
									<td>Species / strain:</td>
									<td><@com.value blockItem.SpeciesStrain/></td>
								</tr>
							</#if>
							<#if blockItem.hasElement("SpeciesStrainCell") && blockItem.SpeciesStrainCell?has_content>
								<tr>
									<td>Species / strain / cell type:</td>
									<td><@com.value blockItem.SpeciesStrainCell/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("AdditionalStrainCharacteristics") && blockItem.AdditionalStrainCharacteristics?has_content>
								<tr>
									<td>Additional strain characteristics:</td>
									<td><@com.value blockItem.AdditionalStrainCharacteristics/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("MammalianCellDetails") && blockItem.MammalianCellDetails?has_content>
								<tr>
									<td>Mammalian cell details:</td>
									<td><@com.text blockItem.MammalianCellDetails/></td>
								</tr>
							</#if>
							<#if blockItem.hasElement("DetailsOnMammalianCellLinesIfApplicable") && blockItem.DetailsOnMammalianCellLinesIfApplicable?has_content>
								<tr>
									<td>Details on mammalian cell type (if applicable):</td>
									<td><@com.text blockItem.DetailsOnMammalianCellLinesIfApplicable/></td>
								</tr>
							</#if>
						</tbody>
						</informaltable>
						<#if blockItem?has_next><@com.emptyLine/></#if>
					<#else>
						<para role="${role}">
							<#if blockItem.hasElement("SpeciesStrain") && blockItem.SpeciesStrain?has_content>
								<@com.value blockItem.SpeciesStrain/>
							<#elseif blockItem.hasElement("SpeciesStrainCell") && blockItem.SpeciesStrainCell?has_content>
								<@com.value blockItem.SpeciesStrainCell/>
							</#if>

							<#if blockItem.hasElement("AdditionalStrainCharacteristics") && blockItem.AdditionalStrainCharacteristics?has_content>
								(<@com.value blockItem.AdditionalStrainCharacteristics/>)
							</#if>

							<#if blockItem.hasElement("MammalianCellDetails") && blockItem.MammalianCellDetails?has_content>
								- <@com.text blockItem.MammalianCellDetails/>
							<#elseif blockItem.hasElement("DetailsOnMammalianCellLinesIfApplicable") && blockItem.DetailsOnMammalianCellLinesIfApplicable?has_content>
								- <@com.text blockItem.DetailsOnMammalianCellLinesIfApplicable/>
							</#if>
						</para>
					</#if>	
				</#if>	
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro speciesStrainMethodListImmunotoxicity speciesStrainRepeatableBlock role="indent">
	<#compress>
		<#if speciesStrainRepeatableBlock?has_content>
			<#list speciesStrainRepeatableBlock?children as blockChildren>
				<para role="${role}">					
					<#-- added for immunotox -->
					<#if blockChildren?has_content>
						<para><@com.value blockChildren/></para>
					</#if>		
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#--Same as above-->
<#macro controlsList controlRepeatableBlock role="indent" tabular=false>
	<#compress>
		<#if controlRepeatableBlock?has_content>
			<#local controlIndex=0/>
			<#list controlRepeatableBlock as blockItem>
				<#if blockItem.hasElement("NegativeControls") && blockItem.NegativeControls?has_content || blockItem.hasElement("NegativeSolventVehicleControls") && blockItem.NegativeSolventVehicleControls?has_content || 
					blockItem.hasElement("SolventControls") && blockItem.SolventControls?has_content || blockItem.hasElement("UntreatedNegativeControls") && blockItem.UntreatedNegativeControls?has_content ||
					blockItem.hasElement("TrueNegativeControls") && blockItem.TrueNegativeControls?has_content || blockItem.hasElement("PositiveControls") && blockItem.PositiveControls?has_content ||
					blockItem.hasElement("PositiveControlSubstance") && blockItem.PositiveControlSubstance?has_content || blockItem.hasElement("Remarks") && blockItem.Remarks?has_content>
					<#local controlIndex += 1/>
					<#if tabular>
						<informaltable frame="none">
						<col width="25%" />
						<col width="75%" />
						<tbody>
							<tr>
								<td>#${controlIndex}</td>
								<td></td>
							</tr>

							<#if blockItem.hasElement("NegativeControls") && blockItem.NegativeControls?has_content>
								<tr>
									<td>Negative:</td>
									<td><@com.value blockItem.NegativeControls/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("NegativeSolventVehicleControls") && blockItem.NegativeSolventVehicleControls?has_content>
								<tr>
									<td>Negative:</td>
									<td><@com.value blockItem.NegativeSolventVehicleControls/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("SolventControls") && blockItem.SolventControls?has_content>
								<tr>
									<td>Solvent/vehicle controls:</td>
									<td><@com.value blockItem.SolventControls/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("UntreatedNegativeControls") && blockItem.UntreatedNegativeControls?has_content>
								<tr>
									<td>Untreated negative controls:</td>
									<td><@com.value blockItem.UntreatedNegativeControls/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("TrueNegativeControls") && blockItem.TrueNegativeControls?has_content>
								<tr>
									<td>True negative controls:</td>
									<td><@com.value blockItem.TrueNegativeControls/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("PositiveControls") && blockItem.PositiveControls?has_content>
								<tr>
									<td>Positive:</td>
									<td><@com.value blockItem.PositiveControls/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("PositiveControlSubstance") && blockItem.PositiveControlSubstance?has_content>
								<tr>
									<td>Positive control substance:</td>
									<td><@com.value blockItem.PositiveControlSubstance/></td>
								</tr>
							</#if>	
							<#if blockItem.hasElement("Remarks") && blockItem.Remarks?has_content>
								<tr>
									<td>Remarks:</td>
									<td><@com.value blockItem.Remarks/></td>
								</tr>
							</#if>
						</tbody>
						</informaltable>
						<#if blockItem?has_next><@com.emptyLine/></#if>
					<#else>
						<para role="${role}">
							<#if blockItem.hasElement("NegativeControls") && blockItem.NegativeControls?has_content>
								Negative: <@com.value blockItem.NegativeControls/>.
							<#elseif blockItem.hasElement("NegativeSolventVehicleControls") && blockItem.NegativeSolventVehicleControls?has_content>
								Negative: <@com.value blockItem.NegativeSolventVehicleControls/>.
							</#if>	
							<#if blockItem.hasElement("SolventControls") && blockItem.SolventControls?has_content>
								Solvent/vehicle controls: <@com.value blockItem.SolventControls/>.
							</#if>
							<#if pppRelevant??>
								<#if blockItem.hasElement("UntreatedNegativeControls") && blockItem.UntreatedNegativeControls?has_content>
									Untreated negative controls: <@com.value blockItem.UntreatedNegativeControls/>.
								</#if>
							</#if>
							<#if blockItem.hasElement("TrueNegativeControls") && blockItem.TrueNegativeControls?has_content>
								True negative controls: <@com.value blockItem.TrueNegativeControls/>.
							</#if>

							<?linebreak?>

							<#if blockItem.hasElement("PositiveControls") && blockItem.PositiveControls?has_content>
								Positive: <@com.value blockItem.PositiveControls/>
							</#if>	
							<#if blockItem.PositiveControls?has_content>
								<#if blockItem.hasElement("PositiveControlSubstance") && blockItem.PositiveControlSubstance?has_content>
									(<@com.value blockItem.PositiveControlSubstance/>)
								</#if>
							</#if>.<?linebreak?>

							<#if blockItem.Remarks?has_content>
								Remarks: <@com.text blockItem.Remarks/>
							</#if>
						</para>
					</#if>	
				</#if>	
			</#list>
		</#if>
	</#compress>
</#macro>

<#--2. Results-->

<#--These three macros are changed with respect to the original; however probably some table format would be better-->
<#macro inVivoLLNAList_ inVivoLLNARepeatableBlock role="indent">
	<#compress>
		<#if inVivoLLNARepeatableBlock?has_content>
			<#list inVivoLLNARepeatableBlock as blockItem>
				<para role="${role}">
					<#local parameter><@com.value blockItem.Parameter /></#local>
					<#if parameter=="SI">
						<#local parameter = "Stimulation index" />
					</#if>
					${parameter} = <@com.range blockItem.Value/>
					<#if blockItem.Variability?has_content>
						(var: <@com.text blockItem.Variability/>)
					</#if>
					<#if blockItem.TestGroupRemarks?has_content>
						<?linebreak?>(<@com.text blockItem.TestGroupRemarks/>)
					</#if>
					<#if blockItem.RemarksOnResults?has_content>
						<?linebreak?>(<@com.value blockItem.RemarksOnResults/>)
					</#if>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#--  
	Macro to output in vivo LLNA results information in a table for Skin Sensitization document.
-->
<#macro inVivoLLNATable_ inVivoLLNARepeatableBlock bgcolor="#D3D3D3" tabletitle="Results">
<#compress>
	<#if inVivoLLNARepeatableBlock?has_content>
		<#-- make table header -->
		<table border="1">
			<title>${tabletitle}</title>

			<col width="15%" />
			<col width="15%" />
			<col width="20%" />
			<col width="25%" />
			<col width="25%" />		

			<thead align="center" valign="middle">
				<tr>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Parameter</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Value</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Variability</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Test group</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
				</tr>
			</thead>
			<tbody valign="middle">
				<#list inVivoLLNARepeatableBlock as blockItem>
					<tr>
						<td>
							<#local parameter><@com.value blockItem.Parameter /></#local>
							<#if parameter=="SI">
								<#local parameter = "Stimulation index" />
							</#if>
							${parameter}
						</td>
						<td>
							<@com.range blockItem.Value/>
						</td>
						<td>
							<@com.text blockItem.Variability/>
						</td>
						<td>
							<@com.text blockItem.TestGroupRemarks/>
						</td>
						<td>
							<@com.value blockItem.RemarksOnResults/>
						</td>
					</tr>
				</#list>
			</tbody>
		</table>
  	</#if>
</#compress>
</#macro>

<#macro inVitroLLNAList_ inVitroRepeatableBlock role="indent">
	<#compress>
		<#if inVitroRepeatableBlock?has_content>
			<#list inVitroRepeatableBlock as blockItem>
				<para role="${role}">
					<#if blockItem.RunExperiment?has_content>
						<@com.value blockItem.RunExperiment/>:
					</#if>
					<@com.value blockItem.Parameter /> = <@com.quantity blockItem.Value/>
					<#if blockItem.AtConcentration?has_content>
						at concentration of <@com.quantity blockItem.AtConcentration/>
					</#if>
					.<?linebreak?>

					<#local info=[]/>
					<#if blockItem.Group?has_content>
						<#local group><@com.value blockItem.Group/></#local>
						<#local info = info + [group]/>
					</#if>
					<#if blockItem.VehicleControlsValid?has_content>
						<#local veh>vehicle control: <@com.value blockItem.VehicleControlsValid/></#local>
						<#local info = info + [veh]/>
					</#if>
					<#if blockItem.PositiveControlsValid?has_content>
						<#local pos>pos. control: <@com.value blockItem.PositiveControlsValid/></#local>
						<#local info = info + [pos]/>
					</#if>
					<#if blockItem.NegativeControlsValid?has_content>
						<#local neg>neg. control: <@com.value blockItem.NegativeControlsValid/></#local>
						<#local info = info + [neg]/>
					</#if>
					<#if info?has_content>(${info?join("; ")})<?linebreak?></#if>

					<#if blockItem.CellViability?has_content>
						<?linebreak?>(<@com.text blockItem.CellViability/>)
					</#if>

					<#if blockItem.RemarksOnResults?has_content>
						<?linebreak?>(<@com.value blockItem.RemarksOnResults/>)
					</#if>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#--  
	Macro to output in vitro/in silico LLNA results information in a table for Skin Sensitization document.
-->
<#macro inVitroSilicoLLNATable_ inVitroSilicoRepeatableBlock bgcolor="#D3D3D3" tabletitle="Results">
<#compress>
	<#if inVitroSilicoRepeatableBlock?has_content>
		<#-- make table header -->
		<table border="1">
			<title>${tabletitle}</title>

			<#list inVitroSilicoRepeatableBlock as blockItem>
				<#local colNumb = 0/>
				<#list blockItem?children as child>
					<#local colNumb += 1/>
				</#list>
				<#break>
			</#list>

				<#--  colNumb does not match because some columns are merged  -->
				<#if colNumb == 11>
					<col width="12%" />
					<col width="13%" />
					<col width="8%" />
					<col width="12%" />
					<col width="20%" />
					<col width="20%" />
					<col width="15%" />
				<#elseif colNumb == 5>
					<col width="15%" />
					<col width="15%" />
					<col width="20%" />
					<col width="50%" />
				</#if>

			<thead align="center" valign="middle">
				<#list inVitroSilicoRepeatableBlock as blockItem>
					<tr>
						<#if blockItem.hasElement("RunExperiment")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Run</emphasis></th></#if>
						<#if blockItem.hasElement("Parameter")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Parameter</emphasis></th></#if>
						<#if blockItem.hasElement("Value")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Value</emphasis></th></#if>
						<#if blockItem.hasElement("Group")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Group</emphasis></th></#if>
						<#if blockItem.hasElement("VehicleControlsValid") || blockItem.hasElement("PositiveControlsValid") || blockItem.hasElement("NegativeControlsValid")>
							<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Controls validity</emphasis></th>
						</#if>
						<#if blockItem.hasElement("CellViability")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Cell viability</emphasis></th></#if>
						<#if blockItem.hasElement("RemarksOnResults") || blockItem.hasElement("RemarksOnResult")>
							<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
						</#if>
					</tr>
					<#break>
				</#list>
			</thead>
			<tbody valign="middle">
				<#list inVitroSilicoRepeatableBlock as blockItem>
					<tr>
						<#if blockItem.hasElement("RunExperiment")>
							<td>
								<@com.value blockItem.RunExperiment/>
							</td>
						</#if>
						<#if blockItem.hasElement("Parameter")>
							<td>
								<@com.value blockItem.Parameter />
							</td>
						</#if>
						<#if blockItem.hasElement("Value")>
							<td>
								<@com.value blockItem.Value/>
								<#if blockItem.hasElement("AtConcentration")>
									<#if blockItem.AtConcentration?has_content>
										<?linebreak?>
										(at concentration of <@com.value blockItem.AtConcentration/>)
									</#if>
								</#if>
							</td>
						</#if>
						<#if blockItem.hasElement("Group")>
							<td>
								<@com.value blockItem.Group/>
							</td>
						</#if>
						<#if blockItem.hasElement("VehicleControlsValid") || blockItem.hasElement("PositiveControlsValid") || blockItem.hasElement("NegativeControlsValid")>
							<td>
								<#if blockItem.hasElement("VehicleControlsValid")>
									<#if blockItem.VehicleControlsValid?has_content>
										vehicle control: <@com.value blockItem.VehicleControlsValid/>;
										<?linebreak?>
									</#if>
								</#if>
								<#if blockItem.hasElement("PositiveControlsValid")>
									<#if blockItem.PositiveControlsValid?has_content>
										pos. control: <@com.value blockItem.PositiveControlsValid/>;
										<?linebreak?>
									</#if>
								</#if>
								<#if blockItem.hasElement("NegativeControlsValid")>
									<#if blockItem.NegativeControlsValid?has_content>
										neg. control: <@com.value blockItem.NegativeControlsValid/>;
									</#if>
								</#if>
							</td>
						</#if>
						<#if blockItem.hasElement("CellViability")>
							<td>
								<@com.value blockItem.CellViability/>
							</td>
						</#if>
						<#if blockItem.hasElement("RemarksOnResults")>
							<td>
								<@com.value blockItem.RemarksOnResults/>
							</td>
						<#elseif blockItem.hasElement("RemarksOnResult")>
							<td>
								<@com.value blockItem.RemarksOnResult/>
							</td>
						</#if>
					</tr>
				</#list>
			</tbody>
		</table>
  	</#if>
</#compress>
</#macro>

<#macro inVivoNonLLNAList_ inVivoNonLLNARepeatableBlock role="indent">
	<#compress>
		<#if inVivoNonLLNARepeatableBlock?has_content>
			<#list inVivoNonLLNARepeatableBlock as blockItem>
				<para role="${role}">
					<#if blockItem.Reading?has_content>
						<@com.value blockItem.Reading/>:
					</#if>
					<#if blockItem.NoWithReactions?has_content>
						<@com.number blockItem.NoWithReactions/> positive reactions
					</#if>
					<#if blockItem.TotalNoInGroup?has_content>
						out of <@com.number blockItem.TotalNoInGroup/>
					</#if>
					.<?linebreak?>
					<#local info=[]/>
					<#if blockItem.Group?has_content>
						<#local group><@com.value blockItem.Group/></#local>
						<#local info = info + [group]/>
					</#if>
					<#if blockItem.HoursAfterChallenge?has_content>
						<#local hours><@com.number blockItem.HoursAfterChallenge/>h after challenge</#local>
						<#local info = info + [hours]/>
					</#if>
					<#if blockItem.DoseLevel?has_content>
						<#local dose>dose: <@com.text blockItem.DoseLevel/></#local>
						<#local info = info + [dose]/>
					</#if>
					<#if info?has_content>(${info?join("; ")})<?linebreak?></#if>

					<#if blockItem.ClinicalObservations?has_content>
						clinical observations: <@com.text blockItem.ClinicalObservations/><?linebreak?>
					</#if>

					<#if blockItem.RemarksOnResults?has_content>
						(<@com.value blockItem.RemarksOnResults/>)
					</#if>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#--  
	Macro to output in vivo non-LLNA results information in a table for Skin Sensitization document.
-->
<#macro inVivoNonLLNATable_ inVivoNonLLNARepeatableBlock bgcolor="#D3D3D3" tabletitle="Results">
<#compress>
	<#if inVivoNonLLNARepeatableBlock?has_content>
		<#-- make table header -->
		<table border="1">
			<title>${tabletitle}</title>

			<col width="10%" />
			<col width="10%" />
			<col width="10%" />
			<col width="10%" />
			<col width="10%" />
			<col width="25%" />
			<col width="25%" />	

			<thead align="center" valign="middle">
				<tr>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Reading</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Positive / Total</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Group</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Hours</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Dose</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Clinical observations</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
				</tr>
			</thead>
			<tbody valign="middle">
				<#list inVivoNonLLNARepeatableBlock as blockItem>
					<tr>
						<td>
							<@com.value blockItem.Reading/>
						</td>
						<td>
							<@com.value blockItem.NoWithReactions/> / <@com.value blockItem.TotalNoInGroup/>
						</td>
						<td>
							<@com.value blockItem.Group/>
						</td>
						<td>
							<@com.value blockItem.HoursAfterChallenge/>
						</td>
						<td>
							<@com.value blockItem.DoseLevel/>
						</td>
						<td>
							<@com.value blockItem.ClinicalObservations/>
						</td>
						<td>
							<@com.value blockItem.RemarksOnResults/>
						</td>
					</tr>
				</#list>
			</tbody>
		</table>
  	</#if>
</#compress>
</#macro>

<#--Also this macro covers all genotox studies in one, and improves the layout-->
<#macro TestResultsList_ TestResultsRepeatableBlock>
	<#compress>
		<#if TestResultsRepeatableBlock?has_content>
			<#list TestResultsRepeatableBlock as blockItem>
				<#local genotoxicity><@com.value blockItem.Genotoxicity/></#local>
				<#local organism><#if blockItem.hasElement("Organism")><@com.value blockItem.Organism/></#if></#local>
				<#local sex><#if blockItem.hasElement("Sex")><@com.value blockItem.Sex/></#if></#local>
				<#local metActIndicator><#if blockItem.hasElement("MetActIndicator")><@com.value blockItem.MetActIndicator/></#if></#local>
				<#local cytotoxicity><#if blockItem.hasElement("Cytotoxicity")><@com.value blockItem.Cytotoxicity/></#if></#local>
				<#local toxicity><#if blockItem.hasElement("Toxicity")><@com.value blockItem.Toxicity/></#if></#local>

				<#local vehContrValid><#if blockItem.VehContrValid?has_content>Vehicle: <@com.value blockItem.VehContrValid/>. </#if></#local>
				<#local negContrValid><#if blockItem.NegContrValid?has_content>Negative: <@com.value blockItem.NegContrValid/>. </#if></#local>
				<#local posContrValid><#if blockItem.PosContrValid?has_content>Positive: <@com.value blockItem.PosContrValid/>. </#if></#local>
				<#local truenegContrValid><#if blockItem.hasElement("TrueNegativeControlsValidity") && blockItem.TrueNegativeControlsValidity?has_content>True negative: <@com.value blockItem.TrueNegativeControlsValidity/>. </#if></#local>

				<#local remarks><#if blockItem.hasElement("RemarksOnResults")><@com.value blockItem.RemarksOnResults/></#if></#local>

				<#if genotoxicity?has_content || cytotoxicity?has_content || toxicity?has_content>
					<para role="indent">
						<#if organism?has_content>For ${organism}: </#if>

						<#if genotoxicity?has_content>Genotoxicity: ${genotoxicity}.</#if>
						<#if cytotoxicity?has_content>Cytotoxicity: ${cytotoxicity}.</#if>
						<#if toxicity?has_content>Toxicity: ${toxicity}.</#if>

						<#if metActIndicator?has_content && metActIndicator!="not specified" && metActIndicator!="not applicable">
							<?linebreak?>(${metActIndicator} metabolic activation)
						</#if>

						<#if sex?has_content>
							<?linebreak?>(Sex: ${sex})
						</#if>

						<#if vehContrValid?has_content || posContrValid?has_content || negContrValid?has_content || truenegContrValid?has_content>
							<?linebreak?>Controls: ${vehContrValid}${negContrValid}${truenegContrValid}${posContrValid}
						</#if>

						<#if remarks?has_content>
							<?linebreak?>Remarks: ${remarks}
						</#if>
					</para>
				</#if>
			</#list>
		</#if>
	</#compress>
</#macro>

<#--Results subsections-->
<#--macrotised-->
<#macro results_basicToxicokinetics study>
	<#compress>
	<#--		PreliminaryStudies-->
		<#if study.ResultsAndDiscussion.PreliminaryStudies?has_content>
			<para>Preliminary studies: </para><para role="indent"><@com.value study.ResultsAndDiscussion.PreliminaryStudies/></para>
		</#if>

		<#if study.ResultsAndDiscussion.MainAdmeResults?has_content>
			<para>Main ADME results: </para><@ADMEList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.MainAdmeResults)/>
		</#if>

		<#if study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnAbsorption?has_content>
			<para>Absorption:</para><para role="indent"><@com.value study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnAbsorption/></para>
		</#if>

		<#if study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnDistribution?has_content>
			<para>Distribution: </para><para role="indent"><@com.value study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnDistribution/></para>
		</#if>

		<#if study.ResultsAndDiscussion.PharmacokineticStudies.VolumeOfDistribution?has_content>
			<para>Volume of Distribution: </para><para role="indent"><@com.value study.ResultsAndDiscussion.PharmacokineticStudies.VolumeOfDistribution/></para>
		</#if>

		<#if study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnExcretion?has_content>
			<para>Excretion: </para><para role="indent"><@com.value study.ResultsAndDiscussion.PharmacokineticStudies.DetailsOnExcretion/></para>
		</#if>

		<#if study.ResultsAndDiscussion.PharmacokineticStudies.TransferIntoOrgans?has_content>
			<para>Transfer into organs:</para><@TransferList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.PharmacokineticStudies.TransferIntoOrgans)/>
		</#if>

		<#if study.ResultsAndDiscussion.PharmacokineticStudies.ToxicokineticParameters?has_content>
			<para>Toxicokinetic parameters: </para><@ToxicokineticParametersList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.PharmacokineticStudies.ToxicokineticParameters)/>
		</#if>

		<#if study.ResultsAndDiscussion.MetaboliteCharacterisationStudies.MetabolitesIdentified?has_content || study.ResultsAndDiscussion.MetaboliteCharacterisationStudies.DetailsOnMetabolites?has_content >
			<para>Metabolites identified: <@com.value study.ResultsAndDiscussion.MetaboliteCharacterisationStudies.MetabolitesIdentified/></para>
            <para role="indent"><@com.value study.ResultsAndDiscussion.MetaboliteCharacterisationStudies.DetailsOnMetabolites/></para>
		</#if>

		<#if study.ResultsAndDiscussion.MetaboliteCharacterisationStudies.DistributionOfMetabolitesInMatrices?has_content>
			<para>Distribution of metabolites in matrices:</para>
			<@metabolitesInMatricesList study.ResultsAndDiscussion.MetaboliteCharacterisationStudies.DistributionOfMetabolitesInMatrices/>
		</#if>

		<#if study.ResultsAndDiscussion.AppendixMetabolitesAndTheirParentsInTreatmentGroups.MetabolitesInTreatmentGroups?has_content>
			<para>Metabolites in treatment groups:</para>
			<@metabolitesInTreatmentGroupsList study.ResultsAndDiscussion.AppendixMetabolitesAndTheirParentsInTreatmentGroups.MetabolitesInTreatmentGroups/>
		</#if>

		<#if study.ResultsAndDiscussion.EnzymaticActivity.EnzymaticActivityMeasured?has_content>
			<para>Enzymatic activity: </para><para role="indent"><@com.value study.ResultsAndDiscussion.EnzymaticActivity.EnzymaticActivityMeasured/></para>
		</#if>

		<#if study.ResultsAndDiscussion.Bioaccessibility.BioaccessibilityTestingResults?has_content>
			<para>Bioaccessibility (or Bioavailability):</para><para role="indent"><@com.value study.ResultsAndDiscussion.Bioaccessibility.BioaccessibilityTestingResults/></para>
		</#if>

		<#if study.ResultsAndDiscussion.ComparativeInVitroMetabolism.ComparativeInVitroMetabolismIntegratedResults?has_content>
			<para>Comparative in vitro metabolism:</para><para role="indent"><@com.value study.ResultsAndDiscussion.ComparativeInVitroMetabolism.ComparativeInVitroMetabolismIntegratedResults/></para>
		</#if>

	</#compress>
</#macro>

<#macro metabolitesInMatricesList metabolitesInMatricesBlock>
	<#compress>
		<#if metabolitesInMatricesBlock?has_content>
			<#list metabolitesInMatricesBlock as blockItem>
				<para role="indent">
					<#if blockItem.RadiolabelNo.linkedRepeatableEntry.RadiolabelNo?has_content>
						Radiolabel no.: <@com.value blockItem.RadiolabelNo.linkedRepeatableEntry.RadiolabelNo/>.
					</#if>
					<#if blockItem.IdentityOfParentOrMetabolite?has_content>
						<#local parent = iuclid.getDocumentForKey(blockItem.IdentityOfParentOrMetabolite)>
						<#if parent.ReferenceSubstanceName?has_content>
							Identity of parent or metabolite: <@com.value parent.ReferenceSubstanceName ""/>.
						<#else>
							Identity of parent or metabolite: <@com.text parent.name ""/>.
						</#if>
					</#if>
					<#if blockItem.TreatmentGroup.linkedRepeatableEntry.TreatmentGroup?has_content>
						Treatment group: <@com.value blockItem.TreatmentGroup.linkedRepeatableEntry.TreatmentGroup/>.
					</#if>
					<#if blockItem.Matrix?has_content>
						Matrix: <@com.value blockItem.Matrix/>.
					</#if>
					<#if blockItem.PercentOfAdministeredDose?has_content>
						Percent of administered dose: <@com.value blockItem.PercentOfAdministeredDose/>.
					</#if>
					<#if blockItem.RemarksOnResult?has_content>
						Remarks: <@com.value blockItem.RemarksOnResult/>.
					</#if>
				</para>	
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro metabolitesInTreatmentGroupsList metabolitesInTreatmentGroupsBlock>
	<#compress>
		<#if metabolitesInTreatmentGroupsBlock?has_content>
			<#list metabolitesInTreatmentGroupsBlock as blockItem>
				<para role="indent">
					<#if blockItem.IDNo?has_content>
						ID no.: <@com.value blockItem.IDNo/>.
					</#if>
					<#if blockItem.IdentityOfCompound?has_content>
						<#local compound = iuclid.getDocumentForKey(blockItem.IdentityOfCompound)>
						<#if compound.ReferenceSubstanceName?has_content>
							Identity of compound: <@com.value compound.ReferenceSubstanceName ""/>.
						<#else>
							Identity of compound: <@com.text compound.name ""/>.
						</#if>
					</#if>
					<#if blockItem.ParentCompoundS?has_content>
						Parent compound(s):
						<#list blockItem.ParentCompoundS as parentLink>
							<#local parent = iuclid.getDocumentForKey(parentLink)>
							<#if parent.ReferenceSubstanceName?has_content>
								<@com.value parent.ReferenceSubstanceName ""/>
							<#else>
								<@com.text parent.name ""/>
							</#if>
							<#if parentLink?has_next> ; </#if>
						</#list>
						.
					</#if>
					<#if blockItem.TreatmentGroups?has_content>
						Treatment group (Test no.): 
						<#list blockItem.TreatmentGroups as treatGroup>
							<#if treatGroup.TreatmentGroupTestNo.linkedRepeatableEntry.TreatmentGroup?has_content>
								<@com.value treatGroup.TreatmentGroupTestNo.linkedRepeatableEntry.TreatmentGroup/>
								<#if treatGroup?has_next> ; </#if>
							</#if>
						</#list>
						.
					</#if>
					<#if blockItem.Expertise?has_content>
						Expertise: <@com.value blockItem.Expertise/>.
					</#if>
					<#if blockItem.TypeOfExpertise?has_content>
						Type of expertise: <@com.value blockItem.TypeOfExpertise/>.
					</#if>
				</para>	
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro results_acuteToxicity study>
	<#compress>
		<#if study.ResultsAndDiscussion.hasElement("Preliminary") && study.ResultsAndDiscussion.Preliminary?has_content>
			<para>Preliminary study: </para><para role="indent"><@com.text study.ResultsAndDiscussion.Preliminary/></para>
		</#if>

		<#if study.ResultsAndDiscussion.EffectLevels?has_content>
			<para>Effect levels:</para>
            <para role="indent"><@EffectLevelsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels)/></para>
		</#if>

		<#if study.ResultsAndDiscussion.Mortality?has_content>
			<para>Mortality: </para><para role="indent"><@com.text study.ResultsAndDiscussion.Mortality/></para>
		</#if>

		<#if study.ResultsAndDiscussion.ClinicalSigns?has_content>
			<para>Clinical signs: </para>
			<para role="indent">
				<@com.value study.ResultsAndDiscussion.ClinicalSigns/>
			</para>
		</#if>

		<#if study.ResultsAndDiscussion.BodyWeight?has_content>
			<para>Body weight: </para><para role="indent"><@com.value study.ResultsAndDiscussion.BodyWeight/></para>
		</#if>

		<#if study.ResultsAndDiscussion.GrossPathology?has_content>
			<para>Gross pathology: </para><para role="indent"><@com.text study.ResultsAndDiscussion.GrossPathology ""/></para>
		</#if>

		<#if study.ResultsAndDiscussion.OtherFindings?has_content>
			<para>Other findings: </para><para role="indent"><@com.text study.ResultsAndDiscussion.OtherFindings ""/></para>
		</#if>
	</#compress>
</#macro>

<#macro results_skinIrritation study>
	<#compress>
		<#if study.ResultsAndDiscussion.InVitro?has_content>
			<para><emphasis role="bold">In vitro</emphasis></para>
			<#if study.ResultsAndDiscussion.InVitro.Results?has_content>
				<#--  in case of Skin Irritation custom ordering and not key result oredering  -->
				<#local inVitrosortedList = iuclid.sortByField(study.ResultsAndDiscussion.InVitro.Results, "IrritationCorrosionParameter", ["% tissue viability","transcutaneous electrical resistance (in kΩ)","dye content (µg/disc)","penetration time (in minutes)"]) />
				<@EyeSkinIrritationInVitroTable EyeSkinIrritationInVitroRepeatableBlock=study.ResultsAndDiscussion.InVitro.Results sortedList=inVitrosortedList/>
				<@com.emptyLine/>
			</#if>			
			<@com.children path=study.ResultsAndDiscussion.InVitro tabular=true style='none'/>
		</#if>

		<#if study.ResultsAndDiscussion.InVivo?has_content>
			<para><emphasis role="bold">In vivo</emphasis></para>
			<#if study.ResultsAndDiscussion.InVivo.Results?has_content>
				<#--  in case of Skin Irritation custom ordering and not key result oredering  -->
				<#local inVivosortedList = iuclid.sortByField(study.ResultsAndDiscussion.InVivo.Results, "Parameter", ["overall irritation score","primary dermal irritation index (PDII)","erythema score","edema score"]) />
				<@EyeSkinIrritationInVivoTable EyeSkinIrritationInVivoRepeatableBlock=study.ResultsAndDiscussion.InVivo.Results sortedList=inVivosortedList/>
				<@com.emptyLine/>
			</#if>
			<@com.children path=study.ResultsAndDiscussion.InVivo tabular=true style='none'/>
		</#if>
	</#compress>
</#macro>


<#macro results_eyeIrritation study>
	<#compress>
		<#if study.ResultsAndDiscussion.InVitro?has_content>
			<para><emphasis role="bold">In vitro / ex vivo / in chemico</emphasis></para>
			<#if study.ResultsAndDiscussion.InVitro.ResultsOfExVivoInVitroStudy?has_content>
				<@EyeSkinIrritationInVitroTable studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.InVitro.ResultsOfExVivoInVitroStudy)/>
				<@com.emptyLine/>
			</#if>
			<@com.children path=study.ResultsAndDiscussion.InVitro tabular=true style='none'/>
		</#if>

		<#if study.ResultsAndDiscussion.InVivo?has_content>
			<para><emphasis role="bold">In vivo</emphasis></para>
			<#if study.ResultsAndDiscussion.InVivo.IrritationCorrosionResults?has_content>
				<@EyeSkinIrritationInVivoTable studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.InVivo.IrritationCorrosionResults)/>
				<@com.emptyLine/>
			</#if>
			<@com.children path=study.ResultsAndDiscussion.InVivo tabular=true style='none'/>
		</#if>
	</#compress>
</#macro>

<#macro results_skinSensitisation study>
	<#compress>
		<#if study.ResultsAndDiscussion.PositiveControlResults?has_content>
			<@com.formattedValue valuePath=study.ResultsAndDiscussion.PositiveControlResults tabular=true/>
		</#if>

		<#if study.ResultsAndDiscussion.InVitroInChemico?has_content>
			<para><emphasis role="bold">In vitro / in chemico</emphasis></para>
			<#if study.ResultsAndDiscussion.InVitroInChemico.Results?has_content>
				<@inVitroSilicoLLNATable_ studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.InVitroInChemico.Results) />
				<@com.emptyLine/>
			</#if>
			<@com.children path=study.ResultsAndDiscussion.InVitroInChemico tabular=true style='none'/>
		</#if>

		<#if study.ResultsAndDiscussion.InSilico?has_content>
			<para><emphasis role="bold">In silico</emphasis></para>
			<#if study.ResultsAndDiscussion.InSilico.Results?has_content>
				<@inVitroSilicoLLNATable_ studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.InSilico.Results) />
				<@com.emptyLine/>
			</#if>
			<@com.children path=study.ResultsAndDiscussion.InSilico tabular=true style='none'/>
		</#if>

		<#if study.ResultsAndDiscussion.TraditionalSensitisationTest?has_content>
			<para><emphasis role="bold">In vivo (non-LLNA)</emphasis></para>
			<#if study.ResultsAndDiscussion.TraditionalSensitisationTest.ResultsOfTest?has_content>
				<@inVivoNonLLNATable_ studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TraditionalSensitisationTest.ResultsOfTest)/>
			</#if>
		</#if>

		<#if study.ResultsAndDiscussion.InVivoLLNA?has_content>
			<para><emphasis role="bold">In vivo (LLNA)</emphasis></para>
			<#if study.ResultsAndDiscussion.InVivoLLNA.Results?has_content>
				<@inVivoLLNATable_ studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.InVivoLLNA.Results) />
				<@com.emptyLine/>
			</#if>
			<@com.children path=study.ResultsAndDiscussion.InVivoLLNA tabular=true style='none'/>
		</#if>
	</#compress>
</#macro>

<#--Macro to parse sections consisting in a repetition of picklist-text fields, such as examinations-->
<#macro examinationsSection path exclude=[]>
	<#compress>
		<#local examinations=path?children/>
		<#list examinations as exam>
			<#local name=exam?node_name>

			<#if !exclude?seq_contains(name)>
				<#if (exam_index%2)==0>
					<#if exam?has_content || examinations[exam_index+1]?has_content>
						<#local fieldName=name?replace("Observ", "")?replace("([A-Z]{1})", " $1", "r")?cap_first/>
						<para role="indent">${fieldName}: <@com.value exam/></para>
						<para role="indent2"><@com.text examinations[exam_index+1]/></para>
					</#if>
				</#if>
			</#if>
		</#list>
	</#compress>
</#macro>

<#macro results_repDoseCarciNeuroImmuno study>
	<#compress>
		<#if study.ResultsAndDiscussion.ResultsOfExaminations?has_content>
			<para>Examinations:
				<#local examinations=study.ResultsAndDiscussion.ResultsOfExaminations?children/>
				<#list examinations as exam>
					<#local name=exam?node_name>
					<#if name!="DetailsOnResults" && name!="RelevanceOfCarcinogenicEffectsPotential" && name!="SpecificImmunotoxicExaminations">
						<#if (exam_index%2)==0>
							<#if exam?has_content || examinations[exam_index+1]?has_content>
								<#local fieldName=name?replace("Observ", "")?replace("([A-Z]{1})", " $1", "r")?cap_first/>
								<para role="indent">${fieldName}: <@com.value exam/></para>
									<para role="indent2"><@com.text examinations[exam_index+1]/></para>
							</#if>
						</#if>
					<#elseif name=="RelevanceOfCarcinogenicEffectsPotential" && exam?has_content>
						<para role="indent">Relevance of carcinogenic effects / potential: </para><para role="indent2"><@com.text exam/></para>
					<#elseif name=="DetailsOnResults" && exam?has_content>
						<para role="indent">Details: </para><para role="indent2"><@com.text exam/></para>
					</#if>
				</#list>
			</para>
		</#if>

		<#--Immunotoxic examinations: same concept as above (could be a macro not to repeat everything)-->
		<#if study.ResultsAndDiscussion.ResultsOfExaminations.hasElement("SpecificImmunotoxicExaminations") &&
				study.ResultsAndDiscussion.ResultsOfExaminations.SpecificImmunotoxicExaminations?has_content>
			<para>Specific immunotoxic examinations:
				<#local examinations=study.ResultsAndDiscussion.ResultsOfExaminations.SpecificImmunotoxicExaminations?children/>
				<#list examinations as exam>
					<#local name=exam?node_name>
					<#if (exam_index%2)==0>
						<#if exam?has_content || examinations[exam_index+1]?has_content>
							<#local fieldName=name?replace("Observ", "")?replace("([A-Z]{1})", " $1", "r")?cap_first/>
							<para role="indent">${fieldName}: <@com.value exam/></para>
								<para role="indent2"><@com.text examinations[exam_index+1]/></para>
						</#if>
					</#if>
				</#list>
			</para>
		</#if>

		<#if study.ResultsAndDiscussion.EffectLevels.Efflevel?has_content>
			<para>Effect levels:</para>
				<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
		</#if>

		<#if study.ResultsAndDiscussion.TargetSystemOrganToxicity.TargetSystemOrganToxicity?has_content>
			<para>Target system  / organ toxicity:</para>
				<@TargetSystemOrganToxList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TargetSystemOrganToxicity.TargetSystemOrganToxicity)/>
		</#if>

		<#if study.ResultsAndDiscussion.hasElement("DetailedToxicologyResults")>
			<#if study.ResultsAndDiscussion.DetailedToxicologyResults.DetailedToxicologyResults?has_content>
				<para>Detailed toxicology results:</para>
					<@DetailedToxResultsList study.ResultsAndDiscussion.DetailedToxicologyResults.DetailedToxicologyResults/>
			</#if>
		</#if>

		<#if study.ResultsAndDiscussion.hasElement("InVitroResults")>
			<#if study.ResultsAndDiscussion.InVitroResults.Results?has_content>
				<para>In vitro results:</para>
					<@immunotoxictyInVitroList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.InVitroResults.Results)/>
			</#if>
			<#if study.ResultsAndDiscussion.InVitroResults.OutcomeOfThePredictionModel?has_content>
				<para role="indent">Outcome of the prediction model: </para><para role="indent2"><@com.value study.ResultsAndDiscussion.InVitroResults.OutcomeOfThePredictionModel/></para>
			</#if>
			<#if study.ResultsAndDiscussion.InVitroResults.OtherEffectsAcceptanceOfResults?has_content>
				<para role="indent">Other effects / acceptance of results: </para><para role="indent2"><@com.value study.ResultsAndDiscussion.InVitroResults.OtherEffectsAcceptanceOfResults/></para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#--This macro uses a new macro and not the existing one - but it's very similar and could be adapted-->
<#macro results_geneticToxicity study>
	<#compress>
		<#if study.ResultsAndDiscussion.TestRs?has_content>
			<para>Test results:</para>
				<#--					<@keyTox.TestResultsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TestRs)/>-->
				<#--						<@keyTox.TestResultsInVivoList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TestRs)/>-->
				<@TestResultsList_ studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TestRs)/>
		</#if>

		<#if study.ResultsAndDiscussion.ResultsDetails?has_content>
			<para>Additional information on results: </para><para role="indent"><@com.text study.ResultsAndDiscussion.ResultsDetails/></para>
		</#if>

		<#if study.ResultsAndDiscussion.hasElement("RemarksOnResults") && study.ResultsAndDiscussion.RemarksOnResults?has_content>
			<para>Remarks:</para><para role="indent"><@com.value study.ResultsAndDiscussion.RemarksOnResults/></para>
		</#if>
	</#compress>
</#macro>

<#macro results_toxicityReproductionOther study>
	<#compress>
		<#if study.ResultsAndDiscussion.EffectLevels.Efflevel?has_content>
			<para>Effect levels:</para>
				<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
		</#if>

		<#if study.ResultsAndDiscussion.ObservedEffects.ObservedEffects?has_content>
			<para>
				Observed effects:</para>
				<para role="indent"><@com.text study.ResultsAndDiscussion.ObservedEffects.ObservedEffects/></para>
		</#if>
	</#compress>
</#macro>

<#macro results_toxicityReproduction study>
	<#compress>

		<#--P0-->
		<#local p0=study.ResultsAndDiscussion.ResultsOfExaminationsParentalGeneration/>

		<#if p0.GeneralToxicityP0?has_content || p0.ReproductiveFunctionPerformanceP0?has_content || p0.DetailsOnResultsP0.DetailsOnResults?has_content ||
		p0.EffectLevelsP0?has_content || p0.TargetSystemOrganToxicityP0?has_content>

			<para><emphasis role="bold">P0 (first parental generation)</emphasis></para>

			<#if p0.GeneralToxicityP0?has_content>
				<para>General toxicity:
					<@examinationsSection p0.GeneralToxicityP0/>
				</para>
			</#if>

			<#if p0.ReproductiveFunctionPerformanceP0?has_content>
				<para>Reproductive function / performance:
					<@examinationsSection p0.ReproductiveFunctionPerformanceP0/>
				</para>
			</#if>

			<#if p0.DetailsOnResultsP0.DetailsOnResults?has_content>
				<para>Details:
					<@com.text p0.DetailsOnResultsP0.DetailsOnResults/>
				</para>
			</#if>

			<#if p0.EffectLevelsP0.Efflevel?has_content>
				<para>
					Effect levels:
					<@EffectLevelsPoList studyandsummaryCom.orderByKeyResult(p0.EffectLevelsP0.Efflevel)/>
				</para>
			</#if>

			<#if p0.TargetSystemOrganToxicityP0.TargetSystemOrganToxicity?has_content>
				<para>
					Target system / organ toxicity:
					<@TargetSystemOrganToxforEffectLevelsList studyandsummaryCom.orderByKeyResult(p0.TargetSystemOrganToxicityP0.TargetSystemOrganToxicity)/>
				</para>
			</#if>
		</#if>

		<#--P1-->
		<#local p1=study.ResultsAndDiscussion.ResultsP1SecondParentalGeneration/>

		<#if p1.GeneralToxicityP1?has_content || p1.ReproductiveFunctionPerformanceP1?has_content || p1.DetailsOnResultsP1.DetailsOnResults?has_content ||
		p1.EffectLevelsP1?has_content || p1.TargetSystemOrganToxicityP1?has_content>

			<para><emphasis role="bold">P1 (second parental generation)</emphasis></para>

			<#if p1.GeneralToxicityP1?has_content>
				<para>General toxicity:
					<@examinationsSection p1.GeneralToxicityP1/>
				</para>
			</#if>

			<#if p1.ReproductiveFunctionPerformanceP1?has_content>
				<para>Reproductive function / performance:
					<@examinationsSection p1.ReproductiveFunctionPerformanceP1/>
				</para>
			</#if>

			<#if p1.DetailsOnResultsP1.DetailsOnResults?has_content>
				<para>Details:
					<@com.text p1.DetailsOnResultsP1.DetailsOnResults/>
				</para>
			</#if>

			<#if p1.EffectLevelsP1.Efflevel?has_content>
				<para>
					Effect levels:
					<@SecondparentalGenerationP1List studyandsummaryCom.orderByKeyResult(p1.EffectLevelsP1.Efflevel)/>
				</para>
			</#if>

			<#if p1.TargetSystemOrganToxicityP1.TargetSystemOrganToxicity?has_content>
				<para>
					Target system / organ toxicity:
					<@TargetSystemOrganToxforEffectLevelsList studyandsummaryCom.orderByKeyResult(p1.TargetSystemOrganToxicityP1.TargetSystemOrganToxicity)/>
				</para>
			</#if>
		</#if>

		<#--F1-->
		<#local f1=study.ResultsAndDiscussion.ResultsOfExaminationsOffspring/>

		<#if f1.GeneralToxicityF1?has_content || f1.DevelopmentalNeurotoxicityF1?has_content || f1.DevelopmentalImmunotoxicityF1?has_content ||
		f1.DetailsOnResultsF1.DetailsOnResults?has_content ||	f1.EffectLevelsF1?has_content || f1.TargetSystemOrganToxicityF1?has_content>

			<para><emphasis role="bold">F1 generation</emphasis></para>

			<#if f1.GeneralToxicityF1?has_content>
				<para>General toxicity:
					<@examinationsSection f1.GeneralToxicityF1/>
				</para>
			</#if>

			<#if f1.DevelopmentalNeurotoxicityF1?has_content>
				<para>Developmental neurotoxicity:
					<@examinationsSection f1.DevelopmentalNeurotoxicityF1/>
				</para>
			</#if>

			<#if f1.DevelopmentalImmunotoxicityF1?has_content>
				<para>Developmental immunotoxicity:
					<@examinationsSection f1.DevelopmentalImmunotoxicityF1/>
				</para>
			</#if>

			<#if f1.DetailsOnResultsF1.DetailsOnResults?has_content>
				<para>Details:
					<@com.text f1.DetailsOnResultsF1.DetailsOnResults/>
				</para>
			</#if>

			<#if f1.EffectLevelsF1.Efflevel?has_content>
				<para>
					Effect levels:
					<@FgenerationList studyandsummaryCom.orderByKeyResult(f1.EffectLevelsF1.Efflevel)/>
				</para>
			</#if>

			<#if f1.TargetSystemOrganToxicityF1.TargetSystemOrganToxicity?has_content>
				<para>
					Target system / organ toxicity:
					<@TargetSystemOrganToxforEffectLevelsList studyandsummaryCom.orderByKeyResult(f1.TargetSystemOrganToxicityF1.TargetSystemOrganToxicity)/>
				</para>
			</#if>
		</#if>

		<#--F2-->
		<#local f2=study.ResultsAndDiscussion.ResultsF2Generation/>

		<#if f2.GeneralToxicityF2?has_content || f2.DevelopmentalNeurotoxicityOfF1Generation?has_content || f2.DevelopmentalImmunotoxicityOfF1Generation?has_content ||
		f2.DetailsOnResultsF2.DetailsOnResults || f2.EffectLevelsF2?has_content || f2.TargetSystemOrganToxicityF2?has_content>

			<para><emphasis role="bold">F2 generation</emphasis></para>

			<#if f2.GeneralToxicityF2?has_content>
				<para>General toxicity:
					<@examinationsSection f2.GeneralToxicityF2/>
				</para>
			</#if>

			<#if f2.DevelopmentalNeurotoxicityOfF1Generation?has_content>
				<para>Developmental neurotoxicity:
					<@examinationsSection f2.DevelopmentalNeurotoxicityOfF1Generation/>
				</para>
			</#if>

			<#if f2.DevelopmentalImmunotoxicityOfF1Generation?has_content>
				<para>Developmental immunotoxicity:
					<@examinationsSection f2.DevelopmentalImmunotoxicityOfF1Generation/>
				</para>
			</#if>

			<#if f2.DetailsOnResultsF2.DetailsOnResults?has_content>
				<para>Details:
					<@com.text f2.DetailsOnResultsF2.DetailsOnResults/>
				</para>
			</#if>

			<#if f2.EffectLevelsF2.Efflevel?has_content>
				<para>
					Effect levels:
					<@FgenerationList studyandsummaryCom.orderByKeyResult(f2.EffectLevelsF2.Efflevel)/>
				</para>
			</#if>

			<#if f2.TargetSystemOrganToxicityF2.TargetSystemOrganToxicity?has_content>
				<para>
					Target system / organ toxicity:
					<@TargetSystemOrganToxforEffectLevelsList studyandsummaryCom.orderByKeyResult(f2.TargetSystemOrganToxicityF2.TargetSystemOrganToxicity)/>
				</para>
			</#if>
		</#if>

		<#--Overall-->
		<#if study.ResultsAndDiscussion.ReproductiveToxicity.ReproductiveToxicity?has_content>
			<para><emphasis role="bold">Overall reproductive toxicity:</emphasis></para>
			<para>
				<@OverallReproductiveToxicityList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.ReproductiveToxicity.ReproductiveToxicity)/>
			</para>
		</#if>
	</#compress>
</#macro>

<#macro results_developmentalToxicity study>
	<#compress>

		<#-- Maternal-->
		<#local maternal=study.ResultsAndDiscussion.ResultsMaternalAnimals/>
		<#if maternal.GeneralToxicityMaternalAnimals?has_content || maternal.MaternalDevelopmentalToxicity?has_content ||
		maternal.EffectLevelsMaternalAnimals.Efflevel?has_content || maternal.MaternalAbnormalities.MaternalAbnormalities?has_content>
			<para><emphasis role="bold">Maternal animals</emphasis></para>
			<#if maternal.GeneralToxicityMaternalAnimals?has_content>
				<para>
					General toxicity:
					<@examinationsSection path=maternal.GeneralToxicityMaternalAnimals exclude=["DetailsOnResults"]/>
					<#if maternal.GeneralToxicityMaternalAnimals.DetailsOnResults?has_content>
						<para role="indent">Details: <@com.text maternal.GeneralToxicityMaternalAnimals.DetailsOnResults/></para>
					</#if>
				</para>
			</#if>

			<#if maternal.MaternalDevelopmentalToxicity?has_content>
				<para>
					Maternal developmental toxicity:
					<@examinationsSection path=maternal.MaternalDevelopmentalToxicity exclude=["ResultsDetailsMaternal"]/>
					<#if maternal.MaternalDevelopmentalToxicity.ResultsDetailsMaternal?has_content>
						<para role="indent">Details: <@com.text maternal.MaternalDevelopmentalToxicity.ResultsDetailsMaternal/></para>
					</#if>
				</para>
			</#if>

			<#if maternal.EffectLevelsMaternalAnimals.Efflevel?has_content>
				<para>Effect levels:
					<@EffectLevelsMatAbnormalitiesList studyandsummaryCom.orderByKeyResult(maternal.EffectLevelsMaternalAnimals.Efflevel)/>
				</para>
			</#if>

			<#if maternal.MaternalAbnormalities.MaternalAbnormalities?has_content>
				<para>Maternal abnormalities:
					<@MatAbnormalitiesList studyandsummaryCom.orderByKeyResult(maternal.MaternalAbnormalities.MaternalAbnormalities)/>
				</para>
			</#if>
		</#if>

		<#-- Fetuses-->
		<#local fetuses=study.ResultsAndDiscussion.ResultsFetuses/>
		<#if fetuses?has_content>
		<#--		This path doesn't seem correctly assigned-->
			<para><emphasis role="bold">Fetuses:</emphasis></para>

			<#if fetuses?has_content>
				<para>
					General toxicity:
					<@examinationsSection path=fetuses exclude=["ResultsDetailsDevelop", "EffectLevelsFetuses", "FetalAbnormalities"]/>
					<#if fetuses.ResultsDetailsDevelop?has_content>
						<para role="indent">Details: <@com.text fetuses.ResultsDetailsDevelop/></para>
					</#if>
				</para>
			</#if>

			<para>Effect levels:
				<@EffectLevelsFetusesList studyandsummaryCom.orderByKeyResult(fetuses.EffectLevelsFetuses.Efflevel)/>
			</para>

			<para>Fetal abnormalities:
				<@FetalAbnormalitiesList studyandsummaryCom.orderByKeyResult(fetuses.FetalAbnormalities.FetalAbnormalities)/>
			</para>
		</#if>

		<#-- Overall-->
		<#if study.ResultsAndDiscussion.DevelopmentalToxicity.DevelopmentalToxicity?has_content>
			<para><emphasis role="bold">Overall developmental toxicity:</emphasis></para>

			<para>
				<@OverallDevToxList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.DevelopmentalToxicity.DevelopmentalToxicity)/>
			</para>
		</#if>
	</#compress>
</#macro>

<#--new-->
<#macro results_phototoxicity study>
	<#compress>

		<#if study.ResultsAndDiscussion.Results?has_content || study.ResultsAndDiscussion.RemarksOnResult?has_content>
			<para>
				Results:
				<para role="indent"><@com.text study.ResultsAndDiscussion.Results/></para>
				<#if study.ResultsAndDiscussion.RemarksOnResult?has_content>
					<para role="indent">Remarks: <@com.value study.ResultsAndDiscussion.RemarksOnResult/></para>
				</#if>

			</para>
		</#if>

		<#if study.ResultsAndDiscussion.ResultsReferenceSubstance?has_content>
			<para>
				Results with reference substance (positive control): <para role="indent"><@com.text study.ResultsAndDiscussion.ResultsReferenceSubstance/></para>
			</para>
		</#if>

		<#if study.ResultsAndDiscussion.StatisticsErrorEstimates?has_content>
			<para>
				Statistics: <para role="indent"><@com.text study.ResultsAndDiscussion.StatisticsErrorEstimates/></para>
			</para>
		</#if>

	</#compress>
</#macro>

<#--livestock-->
<#macro results_effectsLivestock study>
	<#compress>

		<#--hashmap to get text content from field name-->
		<#local livestockField2Text={"ObservClinSigns" : "Clinical signs and mortality: ",
		"ObservBodyweight" :"Body weight and weight gain: ",
		"ObservFoodConsum" : "Food consumption and compound intake: ",
		"ObservWaterConsum" :"Water consumption and compound intake: ",
		"ObservHaematol" : "Haematology: ",
		"ObservClinChem" :"Clinical chemistry: ",
		"ObservUrin" : "Urinalysis: ",
		"ObservGrpathol" :"Gross pathology and organ weights: ",
		"ObservHistopathol":"Histopathology: "}

		/>

		<#--iterate over the children, but need the actual value of the text in IUCLID section-->
		<para>
			<#list study.ResultsAndDiscussion?children as child>
				<#if child?node_type=="picklist_single">
					<para>${livestockField2Text[child?node_name]}<@com.value child/></para>
				</#if>
			</#list>
		</para>

		<#if study.ResultsAndDiscussion.ResultsOfExaminations.ResultsDetails?has_content>
			<para>
				Details: <para role="indent"><@com.text study.ResultsAndDiscussion.ResultsOfExaminations.ResultsDetails/></para>
			</para>
		</#if>

		<#if study.ResultsAndDiscussion.EffectLevels.Efflevel?has_content>
			<para>Effect levels:</para>
				<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
		</#if>

		<#if study.ResultsAndDiscussion.TargetSystemOrganToxicity.TargetSystemOrganToxicity?has_content>
			<para>Target system  / organ toxicity:</para>
				<@TargetSystemOrganToxList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TargetSystemOrganToxicity.TargetSystemOrganToxicity)/>
		</#if>

	</#compress>
</#macro>

<#--specific investigation-->
<#macro results_specificInvestigation study>
	<#compress>
		<#if study.ResultsAndDiscussion.ResultsDetails?has_content>
			<para>
				Details: <para role="indent"><@com.text study.ResultsAndDiscussion.ResultsDetails/></para>
			</para>
		</#if>
	</#compress>
</#macro>

<#--endocrine in vivo-->
<#macro results_endocrineDisrupterMammalianScreening study>
	<#compress>
		<#if study.ResultsAndDiscussion.EndocrineDisruptingPotential?has_content>
			<para>Endocrine disrupting potential: <para role="indent"><@com.value study.ResultsAndDiscussion.EndocrineDisruptingPotential/></para></para>
		</#if>

		<#if study.ResultsAndDiscussion.MaximumToleratedDoseLevelExceeded?has_content>
			<para>Maximum tolerated dose level exceeded: <para role="indent"><@com.value study.ResultsAndDiscussion.MaximumToleratedDoseLevelExceeded/></para></para>
		</#if>

		<#-- Examinations-->
		<#local exam=study.ResultsAndDiscussion.ResultsOfExaminations/>
		<#if exam?has_content>
			<para>
				Examinations:
				<@examinationsSection path=exam exclude=["DetailsOnResults"]/>
				<#if exam.DetailsOnResults?has_content>
					<para role="indent">Details: <@com.text exam.DetailsOnResults/></para>
				</#if>
			</para>
		</#if>

		<#if study.ResultsAndDiscussion.EffectLevels.Efflevel?has_content>
			<para>Effect levels:
				<@EffectLevelsExtendedList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.EffectLevels.Efflevel)/>
			</para>
		</#if>

	</#compress>
</#macro>

<#--endocrine in vitro-->
<#macro results_endocrineDisrupterScreeningInVitro study>
	<#compress>
		<#if study.ResultsAndDiscussion.TestResults.TestResults?has_content>
			<#list study.ResultsAndDiscussion.TestResults.TestResults as testResult>
				<@printResultsEndocrineInVitro testResult/>
			</#list>
		</#if>	
	</#compress>
</#macro>

<#macro results_healthSurvExposureEpidemiological study>
	<#compress>
		<#if study.ResultsAndDiscussion.Results?has_content>
			<para>Results: <para role="indent"><@com.text study.ResultsAndDiscussion.Results/></para></para>
		</#if>

		<#--only for epidemiological data-->
		<#if study.ResultsAndDiscussion.hasElement("ConfoundingFactors") && study.ResultsAndDiscussion.ConfoundingFactors?has_content>
			<para>Confounding factors: <para role="indent"><@com.text study.ResultsAndDiscussion.ConfoundingFactors/></para></para>
		</#if>
		<#if study.ResultsAndDiscussion.hasElement("StrengthsWeaknesses") && study.ResultsAndDiscussion.StrengthsWeaknesses?has_content>
			<para>Strengths and weaknesses: <para role="indent"><@com.text study.ResultsAndDiscussion.StrengthsWeaknesses/></para></para>
		</#if>

	</#compress>
</#macro>

<#macro results_directObs study>
	<#compress>
		<#if study.ResultsAndDiscussion.hasElement("ClinicalSigns") && study.ResultsAndDiscussion.ClinicalSigns?has_content>
			<para>Clinical signs: <para role="indent"><@com.text study.ResultsAndDiscussion.ClinicalSigns/></para></para>
		</#if>

		<#if study.ResultsAndDiscussion.RsExaminations?has_content>
			<para>Results of examinations: <para role="indent"><@com.text study.ResultsAndDiscussion.RsExaminations/></para></para>
		</#if>

		<#if study.ResultsAndDiscussion.hasElement("EffectivityMedicalTreatment") && study.ResultsAndDiscussion.EffectivityMedicalTreatment?has_content>
			<para>Effectivity of medical treatment: <para role="indent"><@com.text study.ResultsAndDiscussion.EffectivityMedicalTreatment/></para></para>
		</#if>

		<#if study.ResultsAndDiscussion.hasElement("Outcome") && study.ResultsAndDiscussion.Outcome?has_content>
			<para>Outcome of incidence: <para role="indent"><@com.text study.ResultsAndDiscussion.Outcome/></para></para>
		</#if>
	</#compress>
</#macro>

<#macro results_dermalAbsorption study>
	<#compress>
		<#if study.ResultsAndDiscussion.SignsSymptomsToxicity?has_content || study.ResultsAndDiscussion.DermalIrritation?has_content>
			<para>Toxicity:
				<#if study.ResultsAndDiscussion.SignsSymptomsToxicity?has_content>
					<para role="indent">Signs and symptoms: <@com.value study.ResultsAndDiscussion.SignsSymptomsToxicity/>.</para>
				</#if>
				<#if study.ResultsAndDiscussion.DermalIrritation?has_content>
					<para role="indent">Dermal irritation: <@com.value study.ResultsAndDiscussion.DermalIrritation/>.</para>
				</#if>
			</para>
		</#if>

		<#if study.ResultsAndDiscussion.AbsorptionMatrices?has_content>
			<para>Absorption in different matrices:
				<para role="indent"><@com.text study.ResultsAndDiscussion.AbsorptionMatrices/>.</para>
			</para>
		</#if>

		<#if study.ResultsAndDiscussion.TotalRecovery?has_content>
			<para>Total recovery:
				<para role="indent"><@com.text study.ResultsAndDiscussion.TotalRecovery/>.</para>
			</para>
		</#if>

		<#if study.ResultsAndDiscussion.Absorption?has_content>
			<#if pppRelevant??>
				<@PercutaneousAbsorptionRateTable studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.Absorption)/>
			<#else>
				<para>Percutaneous absorption rate: <@PercutaneousAbsorptionRateList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.Absorption)/></para>
			</#if>
		</#if>

		<#if study.ResultsAndDiscussion.ConversionFactor?has_content>
			<para>Conversion factor human vs. animal skin:
				<para role="indent"><@com.text study.ResultsAndDiscussion.ConversionFactor/>.</para>
			</para>
		</#if>
	</#compress>
</#macro>

<#macro results_cellCulture study>
	<#compress>
		<#if study.ResultsAndDiscussion.CytopathicEffects?has_content>
			<para>Cytopathic effects: <@com.value study.ResultsAndDiscussion.CytopathicEffects/></para>
		</#if>

		<#if study.ResultsAndDiscussion.TCID50?has_content>
			<para>TCID50:<@com.quantity study.ResultsAndDiscussion.TCID50/></para>
		</#if>

		<#if study.ResultsAndDiscussion.ResultsOfAssays?has_content>
			<para>Results of assays:</para>
			<para><@resultsOfAssaysList study.ResultsAndDiscussion.ResultsOfAssays/></para>
		</#if>

		<#if study.ResultsAndDiscussion.Statistics?has_content>
			<para>Statistics: <para role="indent"><@com.text study.ResultsAndDiscussion.Statistics/></para></para>
		</#if>


	</#compress>
</#macro>

<#--3. New whole studies: intermediate effects
	NOTE: maybe it could be included in general macros for Eappendix but it's quite different -->
<#macro intermediateEffectsStudies _subject>
	<#compress>

		<#local resultStudyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "FLEXIBLE_RECORD", "IntermediateEffects") />

		<#-- Study results-->
		<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Studies</emphasis></para>
		<@com.emptyLine/>

		<#if !resultStudyList?has_content>
			No relevant individual studies available.
		<#else>

			<#--NOTE: change the name displayed e.g. with a hash mapping document name to name to display. Also for long-term tox this will be wrong.-->
			${resultStudyList?size} individual <#if resultStudyList?size==1>study<#else>studies</#if> for intermediate effects <#if resultStudyList?size==1>is<#else>are</#if> summarised below:

			<#list resultStudyList as study>

				<sect4 xml:id="${study.documentKey.uuid!}" label="/${study_index+1}" role="NotInToc"><title  role="HEAD-5" >${study.name}</title>

					<#--1. Header-->
					<para><emphasis role="HEAD-WoutNo">1. Information on the study</emphasis></para>

					<#local referenceLinksList=study.DataSource.Reference/>
					<#if referenceLinksList?has_content>
						<#local referenceList = []/>
						<#list referenceLinksList as referenceLink>
							<#local reference = iuclid.getDocumentForKey(referenceLink)/>
							<#local referenceList = referenceList + [reference] />
						</#list>
						<#local referenceList = iuclid.sortByField(referenceList, "GeneralInfo.LiteratureType", ["study report", "other company data", "publication", "review article or handbook", "other:"]) />
						<#local reference = referenceList[0]/>
					<#else>
					<#--Create empty reference hash-->
						<#local reference = {'GeneralInfo': {'LiteratureType':"", 'Author':"", 'ReferenceYear':"", 'Name':"", 'ReportNo':"", 'StudyIdentifiers':""}}/>
					</#if>

					<table border="1">
						<title> </title>
						<col width="35%" />
						<col width="65%" />
						<tbody>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Data point:</emphasis></th>
							<td>intermediate effects: <@com.value study.AdministrativeData.StudyResultType/></td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Report type: </emphasis></th>
							<td>
								<#if reference.GeneralInfo.LiteratureType?has_content><@com.value reference.GeneralInfo.LiteratureType/></#if>
							</td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Report author: </emphasis></th>
							<td>
								<@com.text reference.GeneralInfo.Author/>
							</td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Report year: </emphasis></th>
							<td><@com.number reference.GeneralInfo.ReferenceYear/></td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Report title: </emphasis></th>
							<td><@com.text reference.GeneralInfo.Name/></td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Report No: </emphasis></th>
							<td><@com.text reference.GeneralInfo.ReportNo/></td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">NoS Id: </emphasis></th>
							<td>
								<#local NoSId=""/>
								<#if reference.GeneralInfo.StudyIdentifiers?has_content>
									<#list reference.GeneralInfo.StudyIdentifiers as studyId>
										<#if studyId.Remarks?matches(".*NOTIF.*STUD.*", "i") || studyId.Remarks?matches(".*NOS.*", "i")>
											<#if studyId.StudyID?has_content>
												<#local NoSId = studyId.StudyID/>
											<#else>
												<#local NoSId>NA - justification: <@com.text studyId.Remarks/></#local>
											</#if>
											<#break>
										</#if>
									</#list>
								</#if>

								<#if NoSId?has_content>
									${NoSId}
								</#if>
							</td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Document No: </emphasis></th>
							<td><#local docUrl=iuclid.webUrl.documentView(study.documentKey) />
								<ulink url="${docUrl}"><@com.text study.documentKey.uuid/></ulink>
							</td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Guidelines followed in study: </emphasis></th>
							<td><@com.value study.MaterialsAndMethods.MethodUsed.Qualifier/> <@com.value study.MaterialsAndMethods.MethodUsed.MethodUsed/>
								<?linebreak?><@com.text study.MaterialsAndMethods.MethodUsed.PrincipleOfTheMethod/>
							</td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Deviations from current test guideline: </emphasis></th>
							<td>
								<#local deviations><@com.value study.MaterialsAndMethods.MethodUsed.Deviations/></#local>
								<#if deviations?starts_with('yes')>${deviations}</#if>
							</td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Previous evaluation: </emphasis></th>
							<td>
								<#--Check in change log: if uuid found, then "Yes:" and append status (concatenated); else "No"
									(NOTE: probably part of this can go to a macro/function elsewhere)-->
								<#local changeLogFlag="no"/>

								<#local changeLogStatusList=[]/>

								<#local changeLogs = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "FLEXIBLE_RECORD", "ChangeLog") />
								<#list changeLogs as changeLog>
									<#list changeLog.ChangeLog.ChangeLogEntries as changeLogEntry>
										<#local changeLogDoc=iuclid.getDocumentForKey(changeLogEntry.LinkToDocument)/>

										<#if changeLogDoc?has_content>
											<#if study.documentKey.uuid==changeLogDoc.documentKey.uuid>
												<#local changeLogStatus><@com.value changeLogEntry.Status/></#local>
												<#if changeLogStatus?has_content>
													<#if !(changeLogStatus?starts_with("new"))>
														<#local changeLogFlag="yes"/>
													</#if>
													<#local changeLogStatusList = changeLogStatusList + [changeLogStatus]/>
												</#if>
											</#if>
										</#if>
									</#list>
								</#list>

								${changeLogFlag}<#if changeLogStatusList?has_content> (${changeLogStatusList?join(", ")})</#if>
							</td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">GLP/Officially recognised testing facilities: </emphasis></th>
							<td><@com.value study.MaterialsAndMethods.MethodUsed.GLPCompliance/>
								<?linebreak?>
								<#if study.MaterialsAndMethods.MethodUsed.OtherQualityFollowed?has_content>
									other quality assurance: <@com.value study.MaterialsAndMethods.MethodUsed.OtherQualityFollowed/>
								</#if>
							</td>
						</tr>
						<tr>
							<th><?dbfo bgcolor="#d3d3d3" ?><emphasis role="bold">Acceptability/Reliability: </emphasis></th>
							<td><@com.value study.AdministrativeData.Reliability/>
								<#if study.AdministrativeData.RationalReliability?has_content>
									: <@com.value study.AdministrativeData.RationalReliability/>
								</#if>
							</td>
						</tr>
						</tbody>
					</table>
					<@com.emptyLine/>

					<para><emphasis role="HEAD-WoutNo"> 2. Full summary of the study according to OECD format </emphasis></para>

					<#-- 2. Materials and methods-->
					<para><emphasis role="bold">a) Materials and methods</emphasis></para>
					<@methods_intermediateEffects study true/>
					<@com.emptyLine/>
					<@intermediateEffectIdentification study/>
					<@com.emptyLine/>

					<#--3.Results-->
					<para><emphasis role="bold">b) Results</emphasis></para>
					<@results_intermediateEffects study true/>
					<@com.emptyLine/>

					<#--4.Assessment and conclusion-->
					<#local assess= study.ApplicantSSummaryAndConclusion/>
					<para><emphasis role="HEAD-WoutNo">3. Assessment and conclusion </emphasis> </para>
					<#--					<@com.emptyLine/>-->
					<#--					<para><emphasis role="bold">a) Assessment and conclusion by applicant:</emphasis></para>-->

					<#if assess.ExecutiveSummary.ExecutiveSummary?has_content>
						<@com.emptyLine/>
						<para>
							<emphasis role="bold">Executive summary:</emphasis>
							<@com.richText assess.ExecutiveSummary.ExecutiveSummary/>
						</para>
					</#if>

					<@com.emptyLine/>
					<para><emphasis role="bold">Interpretation of results:</emphasis></para>

					<#if assess.InterpretationOfResultsObservations.TypeOfResult?has_content>
						<para role="indent">Type of result: <@com.value assess.InterpretationOfResultsObservations.TypeOfResult/></para>
					</#if>
					<#if assess.InterpretationOfResultsObservations.EffectConcentrationChoice?has_content>
						<para role="indent">Effect concentration: <@com.value assess.InterpretationOfResultsObservations.EffectConcentrationChoice/>
						<#if assess.InterpretationOfResultsObservations.Concentration?has_content>
							= <@com.range assess.InterpretationOfResultsObservations.Concentration/>
						</#if>
						</para>
					</#if>
					<#if assess.InterpretationOfResultsObservations.Remarks?has_content>
						<para role="indent">Remarks: <@com.text assess.InterpretationOfResultsObservations.Remarks/></para>
					</#if>


					<#if  assess.InterpretationOfResultsObservations.OverallResults?has_content>
						<@com.emptyLine/>
						<para>
							<emphasis role="bold">Conclusion:</emphasis>
							<@com.text  assess.InterpretationOfResultsObservations.OverallResults/>
						</para>
					</#if>

					<#--					<@com.emptyLine/>-->

					<#--					<para><emphasis role="bold">b) Assessment and conclusion by RMS:</emphasis></para>-->

				</sect4>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro results_intermediateEffects study printRemarks=false>
	<#compress>

		<#list study.ResultsAndDiscussion.TestResults.TestResults as child>
			<#if child_has_next || (child_index>0)><para><emphasis role="underline">Result #${child_index+1}</emphasis></para></#if>

			<para role="indent">
				<#if child.ConcentrationSelection?has_content><#local concSel><@com.value child.ConcentrationSelection/></#local>${concSel?cap_first}</#if>
				<#if child.ConcentrationRangeTested?has_content>
					: <@com.range child.ConcentrationRangeTested/>
				</#if>
			</para>

			<#if child.NumberOfReplicatesAndOutliers?has_content>
				<para role="indent">Number of replicates and outliers: <@com.text child.NumberOfReplicatesAndOutliers/></para>
			</#if>

			<#if child.ParameterAndResult?has_content>
				<para role="indent">Parameter and result:</para>
				<#list child.ParameterAndResult as param>
					<para role="indent2">
						<@com.value param.Parameter/> = <@com.quantity param.ParameterResult/>
					</para>
				</#list>
			</#if>

			<#if child.OtherObservation?has_content>
				<para role="indent">Other observations:</para>
				<#list child.OtherObservation as obs>
					<para role="indent2">
						<@com.value obs.Observation/>
						<#if obs.Concentration?has_content> - <@com.range obs.Concentration/></#if>
					</para>
				</#list>
			</#if>

			<#if child.ResultsForTheTestMaterial?has_content>
				<para role="indent">Results for the test material: <@com.value child.ResultsForTheTestMaterial/></para>
			</#if>

			<#if child.AcceptanceOfResults?has_content>
				<para role="indent">Acceptance: <@com.value child.AcceptanceOfResults/></para>
			</#if>

			<#if child.RemarksOnResults?has_content>
				<para role="indent">Remarks: <@com.text child.RemarksOnResults/></para>
			</#if>

		</#list>

		<#--2. Other information including tables (to include?) : doesn't exist here-->

		<#--3. Remarks on results-->
		<#if printRemarks>
			<#if study.OverallRemarksAttachments.RemarksOnResults?has_content>
				<para>Overall remarks:</para><para role="indent"><@com.richText study.OverallRemarksAttachments.RemarksOnResults/></para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#macro methods_intermediateEffects study printTestMat=false>
	<#compress>

	    <#-- 1. Test material-->
		<#if printTestMat>
			<para>
				<emphasis role="bold">Test material:</emphasis>
				<para role="indent"><@studyandsummaryCom.testMaterialInformation study.MaterialsAndMethods.TestMaterials.TestMaterialInformation/></para>

				<#if study.MaterialsAndMethods.TestMaterials.SpecificDetailsOnTestMaterialUsedForTheStudy?has_content>
					<para role="indent">
						Specific details: <@com.text study.MaterialsAndMethods.TestMaterials.SpecificDetailsOnTestMaterialUsedForTheStudy/>
					</para>
				</#if>
			</para>
		</#if>

		<#-- 2. Test system-->
		<para>
			<emphasis role="bold">Test system:</emphasis>

			<#local sys=study.MaterialsAndMethods.TestSystem/>
			<#if sys.TestSystemType?has_content>
				<para role="indent">Type: <@com.value sys.TestSystemType/>.</para>
			</#if>
			<#if sys.TestSystemIdentity?has_content>
				<para role="indent">Identity: <@com.value sys.TestSystemIdentity/>.</para>
			</#if>
			<#if sys.GeneticModOfSystem?has_content>
				<para role="indent">Genetic modification: <@com.value sys.GeneticModOfSystem/>.</para>
			</#if>
			<#if sys.TestSystemDetails?has_content>
				<para role="indent">Details: <@com.text sys.TestSystemDetails/>.</para>
			</#if>
			<#if sys.MetabolicCompetence?has_content>
				<para role="indent">Metabolic competence: <@com.value sys.MetabolicCompetence/>.</para>
			</#if>
		</para>

	<#-- 3. Detection method -->
		<para>
			<emphasis role="bold">Detection method:</emphasis>
			<#local det=study.MaterialsAndMethods.DetectionMethod/>
			<para role="indent">
				<#if det.DetectionMethodUsed?has_content>
					<@com.value det.DetectionMethodUsed/>
				</#if>
				<#if det.DetailsOnDetectionMethod?has_content>
					: <@com.text det.DetailsOnDetectionMethod/>
				</#if>
			</para>
		</para>

	<#-- 4. Test design -->
		<#local des=study.MaterialsAndMethods.TestDesign/>
		<para>
			<emphasis role="bold">Study design:</emphasis>

			<para role="indent">
				Test material preparation:

				<#--  THIS FIELD DOES NOT EXIST ANYMORE SINCE THE APRIL 2023 RELEASE, and it does not seem to be replaced by another field  -->
				<#--  <#if des.TestMaterialPreparation.ConcentrationSelection?has_content>
					<para role="indent2">Concentration selection: <@com.value des.TestMaterialPreparation.ConcentrationSelection/>.</para>
				</#if>  -->
				<#if des.TestMaterialPreparation.Vehicle?has_content>
					<para role="indent2">Vehicle / solvent: <@com.value des.TestMaterialPreparation.Vehicle/>.</para>
				</#if>
				<#if des.TestMaterialPreparation.DilutionStepsDoseIntervals?has_content>
					<para role="indent2">Dilution steps / dose intervals: <@com.text des.TestMaterialPreparation.DilutionStepsDoseIntervals/>.</para>
				</#if>

			</para>

			<para role="indent">
				Control and reference items:
				<#if des.ControlAndReferenceItems.ControlsReferenceItemsUsed?has_content>
					<@com.value des.ControlAndReferenceItems.ControlsReferenceItemsUsed/>.
				</#if>
				<#if des.ControlAndReferenceItems.ControlsReferenceSubstances?has_content>
					<#list des.ControlAndReferenceItems.ControlsReferenceSubstances as ref>
						<para role="indent2">
							<#if ref.TypeOfControls?has_content><@com.value ref.TypeOfControls/></#if>
							<#if ref.ControlOrReferenceItemsUsed?has_content>: <@com.value ref.ControlOrReferenceItemsUsed/></#if>
							<#if ref.Remarks?has_content> (<@com.text ref.Remarks/>)</#if>
						</para>
					</#list>
				</#if>
			</para>

			<para role="indent">
				Experimental conditions:
				<#if des.ExperimentalConditions.NumberOfReplicates?has_content>
					<para role="indent2">No of replicates: <@com.text des.ExperimentalConditions.NumberOfReplicates/>.</para>
				</#if>
				<#if des.ExperimentalConditions.ExperimentalConditions?has_content>
					<para role="indent2">Conditions:<@com.text des.ExperimentalConditions.ExperimentalConditions/>.</para>
				</#if>
				<#if des.ExperimentalConditions.AdditionalAnalysis?has_content>
					<para role="indent2">Additional analysis: <@com.value des.ExperimentalConditions.AdditionalAnalysis/>.</para>
				</#if>
			</para>

			<para role="indent">
				Data analysis:
				<#if des.DataAnalysis.AcceptanceCriteria?has_content>
					<para role="indent2">Acceptance criteria: <@com.text des.DataAnalysis.AcceptanceCriteria/>.</para>
				</#if>
				<#if des.DataAnalysis.DataCalculationAndStatistics?has_content>
					<para role="indent2">Data calculation and statistics:<@com.text des.DataAnalysis.DataCalculationAndStatistics/>.</para>
				</#if>
				<#if des.DataAnalysis.EvaluationDataInterpretationCriteria?has_content>
					<para role="indent2">Evaluation / data interpretation criteria: <@com.text des.DataAnalysis.EvaluationDataInterpretationCriteria/>.</para>
				</#if>
			</para>
		</para>

	</#compress>
</#macro>


<#macro intermediateEffectIdentification study>
	<#compress>

		<para><emphasis role="bold">Effect identification:</emphasis></para>

		<#if study.EffectIdentification.Details?has_content>
			<para role="indent">P/A/O:<?linebreak?>

				<#list study.EffectIdentification.Details as pao>
					<para role="indent2">
					<#if pao.Process?has_content>
						Process: <@com.value pao.Process/>.
					</#if>
					<#if pao.Object?has_content>
						Object: <@com.value pao.Object/>.
					</#if>
					<#if pao.EffectAction?has_content>
						Action: <@com.value pao.EffectAction/>.
					</#if>
					</para>
				</#list>
			</para>
		</#if>

		<#if study.EffectIdentification.EffectDetails?has_content>
			<para role="indent">Details: <@com.text  study.EffectIdentification.EffectDetails/></para>
		</#if>

		<#if study.EffectIdentification.Context?has_content>
			<para role="indent">Context:<?linebreak?>

				<#list study.EffectIdentification.Context as ctx>
					<para role="indent2">
						<#if ctx.System?has_content>
							System: <@com.value ctx.System/>.
						</#if>
						<#if ctx.Organ?has_content>
							Organ: <@com.value ctx.Organ/>.
						</#if>
						<#if ctx.Remarks?has_content>
							(<@com.text ctx.Remarks/>).
						</#if>
					</para>
				</#list>
			</para>
		</#if>
	</#compress>
</#macro>

<#--4. Results summaries-->

<#macro toxRefValuesTable summary bgcolor="#FBDDA6" printTableIfEmpty=false>

	<#-- Check beforehand if section "Human health hazard characteristics" has content -->
	<#local summaryHasHumanHealthHazardCharacteristics = false>
    <#if summary?has_content>
        <#local toxRefPath2ValMap = {"AcceptableOperatorExposureLevel":"Aoel", "AcceptableDailyIntake":"Adi", "AcuteReferenceDose":"Arfd", "AcuteAcceptableOperatorExposureLevel":"Aaoel", "OtherReferenceValues":"ReferenceValueDescriptor"}/>
		<#list summary.HumanHealthHazardCharacteristics?children as child>
			<#if child?has_content && toxRefPath2ValMap[child?node_name]??>
				<#local toxRef=toxRefPath2ValMap[child?node_name]/>
				<#if child[toxRef]?has_content || child.NoAllocated> <#-- if this condition is false then check the next child -->
					<#local summaryHasHumanHealthHazardCharacteristics = true>
					<#break>
				</#if>
			</#if>	
		</#list>
	</#if>		

	<#if summaryHasHumanHealthHazardCharacteristics || printTableIfEmpty>
        <#--  CREATE TABLE  -->
        <table border="1">
            <#--  Define table header  -->
            <thead>
                <tr><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if>
                    <th><emphasis role="bold">Reference Value</emphasis></th>
                    <th><emphasis role="bold">Study</emphasis></th>
                    <th><emphasis role="bold">Route</emphasis></th>
                    <th><emphasis role="bold">Uncertainty factor (UF)</emphasis></th>
                    <th><emphasis role="bold">Dose descriptor</emphasis></th>
                    <th><emphasis role="bold">Justification</emphasis></th>
                </tr>
            </thead>

            <#--  Define table body  -->
            <tbody>
				<#if summaryHasHumanHealthHazardCharacteristics>
                	<#list summary.HumanHealthHazardCharacteristics?children as child>
						<#if child?has_content && toxRefPath2ValMap[child?node_name]??>
							<#local toxRef=toxRefPath2ValMap[child?node_name]/>

							<#if child[toxRef]?has_content && !child.NoAllocated>
								<tr>
									<#--  Reference Value column  -->
									<td>
										<#if toxRef == "ReferenceValueDescriptor"> <#-- Other reference values -->
											<#local refValueDescriptor><@com.value valuePath=child.ReferenceValueDescriptor /></#local>		 
											<#if refValueDescriptor?has_content>
												<emphasis role="bold">${refValueDescriptor}</emphasis> = <@com.value child.RefValue/>
											</#if>	
										<#else>
											<emphasis role="bold">${toxRef?upper_case}</emphasis> = <@com.value child[toxRef]/>
										</#if>	
									</td>

									<#--  Study column  -->
									<td>
										<#if child.hasElement("StudyRetained")><@com.picklistMultiple child.StudyRetained/></#if>
									</td>

									<#--  Route column  -->
									<td>
										<#if child.hasElement("RouteOfOriginalStudy")>
											<#local route><@com.picklist child.RouteOfOriginalStudy/></#local>
											${route}
											<#if child.hasElement("OralAbsorption") && route?matches(".*oral.*") && child.OralAbsorption?has_content>
												(<@com.number child.OralAbsorption/>%)
											</#if>
										</#if>	
									</td>

									<#--  Uncertainty factor (UF) column  -->
									<td>
										<@com.text child.OverallUncertainty/>
										<#if child.JustificationOverallUf?has_content>
											- <@com.text child.JustificationOverallUf/>
										</#if>
									</td>

									<#--  Dose descriptor column  -->
									<td>
										<#if child.hasElement("DoseDescriptorStartingPoint")><@com.picklist child.DoseDescriptorStartingPoint/></#if>
									</td>

									<#--  Justification column  -->
									<td>
										<@com.richText child.JustificationAndComments/>
									</td>
								</tr>
							<#elseif child.NoAllocated>
								<tr>
									<td colspan="6" align="center">
										<emphasis role="bold"><#if toxRef == "ReferenceValueDescriptor">OTHER REFERENCE VALUE <#else>${toxRef?upper_case}</#if> not allocated</emphasis><sbr/>
										<@com.text child.Justification ""/>
									</td>
								</tr>
							</#if>
						</#if>	
                	</#list>
				<#else>
					<tr>
						<td colspan="6" align="center">
							No information on toxicological reference values.
						</td>
					</tr>
				</#if>
            </tbody>
        </table>
    </#if>
</#macro>

<#--Endocrine disrupting properties-->
<#macro endocrineDisruptingPropertiesTable summary bgcolor="#FBDDA6">
	<#compress>

	<#--ED assessment-->
		<#local isFirst=true/>
		<#list summary.EdAssessment?children as child>

		<#--Assessment type-->
			<#local assessmentType><#compress>
				<#if child?node_name?contains("Humans")>human
				<#elseif child?node_name?contains("NonTarget")>non-target organisms
				</#if>
			</#compress></#local>

			<#local assessmentType><#compress>
				${assessmentType}
				<#if child?node_name?contains("Tmodality")>(T-modality)
				<#elseif child?node_name?contains("Easmodality")>(EAS-modality)
				</#if>
			</#compress></#local>

		<#--Lines of evidence-->
			<#local evPath=child.AssessmentLinesOfEvidence/>
			<#local evidence><#compress>
				<#if evPath.hasElement("SufficientInvestigationT") && evPath.SufficientInvestigationT?has_content>
					<para>T-mediated parameters sufficiently investigated: <@com.value evPath.SufficientInvestigationT/></para>
				<#elseif evPath.hasElement("SufficientInvestigationEas") && evPath.SufficientInvestigationEas?has_content>
					<para>EAS-mediated parameters sufficiently investigated: <@com.value evPath.SufficientInvestigationEas/></para>
				</#if>

				<#if evPath.HasEndocrineActivityBeenSufficientlyInvestigated?has_content>
					<para>Endocrine activity sufficiently investigated: <@com.value evPath.HasEndocrineActivityBeenSufficientlyInvestigated/></para>
				</#if>

				<#if evPath.SelectionOfRelevantScenario?has_content>
					<para><@com.value evPath.SelectionOfRelevantScenario/></para>
				</#if>

				<#if evPath.EvidenceAdverseEffects?has_content>
					<para>Adverse effects: <@com.richText evPath.EvidenceAdverseEffects/></para>
				</#if>

				<#if evPath.EvidenceEndocrineActivity?has_content>
					<para>Endocrine activity: <@com.richText evPath.EvidenceEndocrineActivity/></para>
				</#if>

				<#if evPath.WoeAdversityEndocrineActivity?has_content>
					<para>WoE: <@com.richText evPath.WoeAdversityEndocrineActivity/></para>
				</#if>
			</#compress></#local>

		<#--MoA-->
			<#local MoA><#compress>
				<#if child.MoaAnalysis.PostulatedMoa?has_content>
					<para>Postulated MoA:<?linebreak?>
						<#list child.MoaAnalysis.PostulatedMoa?children as moa>
							<para role="indent">
								<#if moa.PostulatedMoa?has_content>
									<@com.text moa.PostulatedMoa/>
								</#if>
								<#if moa.EventType?has_content>
									: <@com.text moa.EventType/>
								</#if>
								<#if moa.EventDescription?has_content>
									- <@com.text moa.EventDescription/><?linebreak?>
								</#if>
								<#if moa.SupportingEvidence?has_content>
									Evidence: <@com.text moa.SupportingEvidence/><?linebreak?>
								</#if>
								<#if moa.RelevantRecords?has_content>
									Study record(s):
									<#list moa.RelevantRecords as studyReferenceLinkedToSummary>
										<#local studyReference = iuclid.getDocumentForKey(studyReferenceLinkedToSummary) />
										<command  linkend="${studyReference.documentKey.uuid!}">
											<@com.text studyReference.name/>
										</command>
										<#if studyReferenceLinkedToSummary_has_next> | </#if>
									</#list>
								</#if>
							</para>
						</#list>
					</para>
				</#if>

				<#if child.MoaAnalysis.EmpiricalSupport?has_content>
					<para>Empirical support: <@com.richText child.MoaAnalysis.EmpiricalSupport/></para>
				</#if>

				<#if child.MoaAnalysis.ConclusionOnMoa?has_content>
					<para>Conclusion: <@com.richText child.MoaAnalysis.ConclusionOnMoa/></para>
				</#if>
			</#compress></#local>

		<#--Uncertainties-->
			<#local uncert><#compress>
				<#if child.UncertaintyAnalysis.UncertaintyAnalysis?has_content>
					<para>Uncertainty analysis:<?linebreak?>
						<#list child.UncertaintyAnalysis.UncertaintyAnalysis?children as unc>
							<para role="indent">
								<#if unc.IdentifiedUncertainties?has_content>
									<@com.text unc.IdentifiedUncertainties/>
								</#if>
								<#if unc.Justification?has_content>
									<@com.text unc.Justification/> -
								</#if>
							</para>
						</#list>
					</para>
				</#if>
			</#compress></#local>

		<#--print if content-->
			<#if uncert?has_content || MoA?has_content || evidence?has_content>
				<#if isFirst>
				<#--					<para><emphasis role="bold">ED assessment:</emphasis></para>-->
					<table border="1">
					<tbody>

					<tr>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Assessment type</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Lines of evidence</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">MoA</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Uncertainty</emphasis></th>
						<#--			<th><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Conclusion</emphasis></th>-->
					</tr>
					<#local isFirst=false/>
				</#if>

				<tr>
					<td>${assessmentType}</td>
					<td>${evidence}</td>
					<td>${MoA}</td>
					<td>${uncert}</td>
				</tr>

			</#if>

		</#list>
		<#if !isFirst></tbody></table></#if>

	<#--Conclusion-->
		<#local conclusion><#compress>
			<#if summary.OverallConclusionEdAssessment.OverallConclusionEdAssessmentHumans.CriteriaForHumansMet?has_content>
				<para role="indent">ED criteria for humans met: <@com.value summary.OverallConclusionEdAssessment.OverallConclusionEdAssessmentHumans.CriteriaForHumansMet/></para>
			</#if>
			<#if summary.OverallConclusionEdAssessment.OverallConclusionEdAssessmentNonTargetOrganisms.AdverseEffectRelevantForMammals?has_content>
				<para role="indent">Adverse effect relevant for wild mammals: <@com.value summary.OverallConclusionEdAssessment.OverallConclusionEdAssessmentNonTargetOrganisms.AdverseEffectRelevantForMammals/></para>
			</#if>

			<#if summary.OverallConclusionEdAssessment.OverallConclusionEdAssessmentNonTargetOrganisms.EdCriteriaMammalsMet?has_content>
				<para role="indent">ED criteria for wild mammals met: <@com.value summary.OverallConclusionEdAssessment.OverallConclusionEdAssessmentNonTargetOrganisms.EdCriteriaMammalsMet/></para>
			</#if>

			<#if summary.OverallConclusionEdAssessment.OverallConclusionEdAssessmentNonTargetOrganisms.ImpactOnOtherOrganisms?has_content>
				<para role="indent">ED criteria for non-target organisms other than mammals met: <@com.value summary.OverallConclusionEdAssessment.OverallConclusionEdAssessmentNonTargetOrganisms.ImpactOnOtherOrganisms/></para>
			</#if>
		</#compress></#local>
		<#if conclusion?has_content>
			<@com.emptyLine/><para><emphasis role="bold">Overall conclusion:</emphasis></para>
			${conclusion}
		</#if>
	</#compress>
</#macro>

<#macro nonDietaryExpoSummary summary bgcolor="#FBDDA6">

	<#if summary.DescriptionOfUse.Uses?has_content>
		<para><emphasis role="bold">Uses and exposure:</emphasis></para>

		<#list summary.DescriptionOfUse.Uses as use>

			<#if use_has_next || (use?index gt 0 && use?is_last)><para><emphasis role="underline">SUMMARY #${use_index+1}</emphasis></para></#if>

			<para role="indent">
				Use:
				<#if pppRelevant??><para style="background-color:#f7f7f7"></#if>
					<@com.value use.UseDescription/>
				<#if pppRelevant??></para></#if>
			</para>

			<para role="indent">Exposure scenarios:</para>
			<#if pppRelevant??>
				<#if use.ExposureScenarios.OperatorExposure.OperatorExposure?has_content>
					<@com.emptyLine/>
					<para role="indent"><emphasis role="bold">Operator</emphasis></para>
					<para role="indent" style="background-color:#f7f7f7">
						<@com.value use.ExposureScenarios.OperatorExposure.OperatorExposure/>
					</para>
				</#if>

				<#if use.ExposureScenarios.WorkerExposure.WorkerExposure?has_content>
					<@com.emptyLine/>
					<para role="indent"><emphasis role="bold">Worker</emphasis></para>
					<para role="indent" style="background-color:#f7f7f7">
						<@com.value use.ExposureScenarios.WorkerExposure.WorkerExposure/>
					</para>
				</#if>

				<#if use.ExposureScenarios.BystanderResidentExposure.BystanderResidentExposure?has_content>
					<@com.emptyLine/>
					<para role="indent"><emphasis role="bold">Bystander / resident</emphasis></para>
					<para role="indent" style="background-color:#f7f7f7">
						<@com.value use.ExposureScenarios.BystanderResidentExposure.BystanderResidentExposure/>
					</para>
				</#if>
			<#else>
				<table border="1">
					<tbody>
					<tr>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Operator</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Worker</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Bystander / resident</emphasis></th>
					</tr>
					<tr>
						<td>
							<@com.value use.ExposureScenarios.OperatorExposure.OperatorExposure/>
						</td>
						<td>
							<@com.value use.ExposureScenarios.WorkerExposure.WorkerExposure/>
						</td>
						<td>
							<@com.value use.ExposureScenarios.BystanderResidentExposure.BystanderResidentExposure/>
						</td>
					</tr>
					</tbody>
				</table>
			</#if>	
		</#list>
	</#if>
</#macro>

<#macro dermalAbsorptionSummary summary>
	<#compress>

		<#local csa=summary.KeyValueCsa>

		<para>
			<#if csa.Endpoint?has_content>
				Endpoint: <@com.value csa.Endpoint/>
			</#if>
			<#if csa.TypeOfInformation?has_content>
				- <@com.value csa.TypeOfInformation/>
			</#if>
			<#if csa.Justification?has_content>
				(<@com.text csa.Justification/>)
			</#if>
			.
		</para>

		<para>
			<#if csa.Species?has_content>
				Species: <@com.value csa.Species/>.
			</#if>
		</para>

		<para>
			<#if csa.Results?has_content>
				Results:
				<#list csa.Results as res>
					<para role="indent2">
						<@com.number res.Concentration/><@com.value res.Parameter/>
						<#if res.Absorption?has_content> - absorption: <@com.range res.Absorption/></#if>
					</para>
				</#list>
			</#if>
		</para>
	</#compress>
</#macro>

<#macro endpointBlock endpointPath>
	<#compress>
		<#if endpointPath.hasElement("EffectLevelUnit")>
			<#if endpointPath.EffectLevelUnit?has_content>
				<#if endpointPath.EffectLevelUnit?node_type=="picklist_single">
					<@com.value endpointPath.EffectLevelUnit/>:
				<#else>
					<@com.value endpointPath.EffectLevelUnit/>:
				</#if>

				<#if endpointPath.EffectLevelValue?node_type=="quantity">
					<@com.quantity endpointPath.EffectLevelValue/>
				<#else>
					<@com.range endpointPath.EffectLevelValue/>
				</#if>

				<?linebreak?>

				<#if endpointPath.hasElement("PhysicalForm") && endpointPath.PhysicalForm?has_content>
					(<@com.value endpointPath.PhysicalForm/>)<?linebreak?>
				</#if>
			</#if>
		</#if>

		<#if endpointPath.EndpointConclusion?has_content >
			<@com.value endpointPath.EndpointConclusion/>

			<#if endpointPath.hasElement("System") &&  endpointPath.System?has_content>
				: <@com.value endpointPath.System/>
			</#if>
			<#if endpointPath.hasElement("Organ") &&  endpointPath.Organ?has_content >
				-  <@com.value endpointPath.Organ/>
			</#if>
			<?linebreak?>
		</#if>

		<#-- Some cases (sensitisation) has additional information. NOTE: included outside of block-->
		<#--		<#if endpointPath.hasElement("AdditionalInformation") && endpointPath.AdditionalInformation?has_content>-->
		<#--			<para><@com.richText endpointPath.AdditionalInformation/></para>-->
		<#--		</#if>-->

	</#compress>
</#macro>

<#macro detailedEndpointName child name>
	<#if child?node_name!="EndpointConclusion" && !child?node_name?contains("Record")>
		${child?node_name?replace("([A-Z]{1})", " $1", "r")?lower_case?cap_first}
	<#else>
		${name}
	</#if>

	<#--Add more details if exist: species, duration-->
	<#if child.hasElement("TestType") && child.TestType?has_content>
		| <@com.value child.TestType />
		<#if child.hasElement("ExperimentalExposureTimePerWeek") && child.ExperimentalExposureTimePerWeek?has_content>
			(<@com.number child.ExperimentalExposureTimePerWeek /> h/w)
		</#if>
	</#if>
	<#if child.hasElement("Species") && child.Species?has_content>
		| <@com.value picklistValue=child.Species printDescription=false printRemarks=false/>
	</#if>
</#macro>

<#function isEndpointsBlock path>
	<#if path?node_type=="block">
		<#if path?node_name=="EndpointConclusion">
			<#return true/>
		<#else>
			<#list path?children as child>
				<#if child?node_name=="EndpointConclusion">
					<#return true/>
				</#if>
			</#list>
		</#if>
	</#if>
	<#return false/>
</#function>

<#function getSummarySeq summary>
	<#local mySeq=[]/>

	<#if summary.hasElement("KeyValueForChemicalSafetyAssessment")>
		<#local csaPath=summary["KeyValueForChemicalSafetyAssessment"]>
	<#else>
	<#--NOTE: for cases like phototox-->
		<#local csaPath=summary>
	</#if>

	<#list csaPath?children as csaField>


		<#--Name (higher-level)-->
		<#local propName>
			${csaField?node_name?replace("([A-Z]{1})", " $1", "r")?lower_case?cap_first}
		</#local>

		<#if csaField?node_type=="block">

			<#--Endpoints-->
			<#local links=""/>
			<#local endpoint=""/>
			<#list csaField?children as child>

				<#--Links-->
				<#if child?node_name=="LinkToRelevantStudyRecords" || child?node_name=="RelevantRecords">
					<#local links><#compress>
						<#if child.StudyNameType?has_content>
							<#list child.StudyNameType as studyReferenceLinkedToSummary>
								<#local studyReference = iuclid.getDocumentForKey(studyReferenceLinkedToSummary) />
								<para>
									<command  linkend="${studyReference.documentKey.uuid!}">
										<@com.text studyReference.name/>
									</command>
								</para>
							</#list>
						</#if>
					</#compress></#local>
				</#if>

				<#--Endpoints block-->
				<#--case with simple block-->
				<#if isEndpointsBlock(child)>

					<#--Name (lower-level)-->
					<#local propName><@detailedEndpointName child propName/></#local>

					<#--Endpoints-->
					<#local endpoint><#compress><@endpointBlock child/>
					</#compress></#local>

					<#--append-->
					<#if links?has_content || endpoint?has_content>
						<#local mySeq = mySeq + [{'name': propName, "links" : links!, "endpoint":endpoint}]/>
					</#if>

				<#--case with repeatable blocks-->
				<#elseif child?children??>
					<#list child?children as gChildSeq>
						<#if gChildSeq?is_sequence>
							<#list gChildSeq as gChild>
								<#if gChild?is_node && isEndpointsBlock(gChild)>
								<#--Name (lower-level)-->
									<#local propName><@detailedEndpointName gChild propName/></#local>

								<#--Endpoints-->
									<#local endpoint><#compress><@endpointBlock gChild/></#compress></#local>

								<#--append-->
									<#if links?has_content || endpoint?has_content>
										<#local mySeq = mySeq + [{'name': propName, "links" : links!, "endpoint":endpoint}]/>
									</#if>
								</#if>
							</#list>
						</#if>
					</#list>
				</#if>
			</#list>
		</#if>
	</#list>

	<#return mySeq/>

</#function>

<#macro getSummaryFromHash hash>
	<#compress>
		<table border="1">
			<tbody valign="middle">
			<tr>
				<th align="center"><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Endpoint</emphasis></th>
				<th align="center"><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Studies</emphasis></th>
				<th align="center"><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Value used for CSA</emphasis></th>
			</tr>

			<#list hash?keys?sort as key>
				<#local seq = hash[key]/>
				<#local usespan = true />
				<#list seq as item>
					<tr>
						<#if usespan>
							<td rowspan="${seq?size}">${key}</td>
							<#local usespan = false />
						</#if>
						<td>${item.links}</td>
						<td>${item.endpoint}</td>
					</tr>
				</#list>
			</#list>
			</tbody></table>
	</#compress>
</#macro>

<#--Macro for summaries in TOX-->
<#macro toxPPPsummary subject docSubTypes includeMetabolites=true merge=false>
	<#compress>

		<#local summaryDocToCSAMap = {
		"Toxicokinetics" : {"path" : "KeyValue",
		"values" : [{"type":"listValue", "field": "Bioaccumulation.Bioaccumulation", "preText" : "Bioaccumulation potential: "},
		{"type":"value", "field": "AbsorptionOral", "preText": "Oral absorption rate: ", "postText":"%"},
		{"type":"value", "field": "AbsorptionDerm", "preText": "Dermal absorption rate: ", "postText":"%"},
		{"type":"value", "field": "AbsorptionInhal", "preText": "Inhalation absorption rate: ", "postText":"%"}]},
		"Phototoxicity" : {"path":"KeyValueCsa", "values":[{"type":"listValue", "field":"Results", "preText":"Results: "}]}
		}/>

	<#--Get all documents, from same or different type-->
		<#if !docSubTypes?is_sequence>
			<#local docSubTypes=[docSubTypes]/>
		</#if>

	<#--Ensure merge=false for non compatible summary types-->
		<#if docSubTypes?seq_contains("Toxicokinetics") ||
		docSubTypes?seq_contains("ToxRefValues") ||
		docSubTypes?seq_contains("EndocrineDisruptingPropertiesAssessmentPest") ||
		docSubTypes?seq_contains("NonDietaryExpo") ||
		docSubTypes?seq_contains("DermalAbsorption")>
			<#local merge=false>
		</#if>

	<#-- Get all entities (subject and metabolites, if they exist)-->
		<#local entities=[subject]/>
		<#if includeMetabolites && _metabolites?? && _metabolites?has_content>
			<#local entities = entities + _metabolites/>
		</#if>

	<#-- Get all summaries for each entity-->
		<#local entity2summaryHash = {}/>
		<#list entities as entity>
			<#local entitySummaryList=[]/>
			<#list docSubTypes as docSubType>
				<#if docSubType=="ToxRefValues" || docSubType=="EndocrineDisruptingPropertiesAssessmentPest" || docSubType=="NonDietaryExpo">
					<#local summaryList = iuclid.getSectionDocumentsForParentKey(subject.documentKey, "FLEXIBLE_SUMMARY", docSubType) />
				<#else>
					<#local summaryList = iuclid.getSectionDocumentsForParentKey(subject.documentKey, "ENDPOINT_SUMMARY", docSubType) />
				</#if>
				<#local entitySummaryList = entitySummaryList + summaryList/>
			</#list>
			<#if entitySummaryList?has_content>
				<#if entity.documentType=="MIXTURE">
					<#local entityName=entity.MixtureName/>
				<#elseif entity.documentType=="SUBSTANCE">
					<#local entityName=entity.ChemicalName/>
				</#if>
				<#local entity2summaryHash = entity2summaryHash + { entityName : entitySummaryList}/>
			</#if>
		</#list>

	<#--Iterate through summaries and create section lists for each entity-->
		<#if !entity2summaryHash?has_content>
			<@com.emptyLine/>
			<para>No summary information available for this section.</para>
			<@com.emptyLine/>

		<#else>
			<#list entity2summaryHash as entityName, allSummaryList>
	
				<#local keyInfo=[]/>
				<#local links=[]/>
				<#local endpointsHash={}/>
				<#local addInfo=[]/>
				<#local justification=[]/>
				<#local moa=[]/>
	
			<#--Need to iterate in every section, so that all Discussions, Key Information, Endpoints, etc appear together-->
				<#if allSummaryList?has_content>
	
					<#local printSummaryName = allSummaryList?size gt 1 />
	
					<#if entity2summaryHash?keys?seq_index_of(entityName)==0>
						<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Summary</emphasis></para>
					</#if>
	
					<#if includeMetabolites && _metabolites?? && _metabolites?has_content && entityName!=subject.ChemicalName>
						<@com.emptyLine/>
						<para><emphasis role="underline">----- Metabolite <emphasis role="bold">${entityName}</emphasis> -----</emphasis></para>
						<@com.emptyLine/>
					</#if>
	
					<#list allSummaryList as summary>
	
						<#if (!merge) && printSummaryName>
							<para><emphasis role="bold">#${summary_index+1}: <@com.text summary.name/></emphasis></para>
							<@com.emptyLine/>
						</#if>
	
					<#-- Key information-->
						<#if summary.documentSubType=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction" || summary.documentSubType=="GeneticToxicity">
	
							<#local summaryKeyInfo = []/>
							<#list summary.KeyValueForChemicalSafetyAssessment?children as csaEntry>
								<#if csaEntry?node_type=="block" && csaEntry.hasElement("DescriptionOfKeyInformation.KeyInfo")>
									<#if csaEntry.DescriptionOfKeyInformation.KeyInfo?has_content>
										<#local csaName>${csaEntry?node_name?replace("([A-Z]{1})", " $1", "r")?lower_case?cap_first}</#local>
										<#local csaKeyInfo><para role="indent">
										<#-- <emphasis role="underline">${csaName}:</emphasis-->
											<@com.richText csaEntry.DescriptionOfKeyInformation.KeyInfo/>
											</para>
										</#local>
										<#local summaryKeyInfo = summaryKeyInfo + [csaKeyInfo]/>
									</#if>
								</#if>
							</#list>
							<#local summaryKeyInfo>${summaryKeyInfo?join("<?linebreak?>")}</#local>
	
						<#else>
							<#local summaryKeyInfo = ""/>
	
							<#local keyInfoPath><#compress>
								<#if summary.hasElement("DescriptionOfKeyInformation.KeyInfo")>
									summary.DescriptionOfKeyInformation.KeyInfo
								<#elseif summary.hasElement("KeyInformation.KeyInformation")>
									summary.KeyInformation.KeyInformation
								</#if>
							</#compress></#local>
	
							<#if keyInfoPath?has_content && keyInfoPath?eval?has_content>
								<#local summaryKeyInfo><para role="indent"><@com.richText keyInfoPath?eval/></para></#local>
							</#if>
						</#if>
	
						<#if summaryKeyInfo?has_content>
							<#if merge>
								<#local keyInfo = keyInfo + [summaryKeyInfo]/>
							<#else>
								<para><emphasis role="bold">Key information: </emphasis></para>${summaryKeyInfo}
							</#if>
						</#if>
	
					<#--Linked studies-->
						<#local summaryLinks=""/>
						<#if summary.hasElement("LinkToRelevantStudyRecord") && summary.LinkToRelevantStudyRecord.Link?has_content>
							<#local summaryLinks><#compress>
								<#list summary.LinkToRelevantStudyRecord.Link as studyReferenceLinkedToSummary>
									<#local studyReference = iuclid.getDocumentForKey(studyReferenceLinkedToSummary) />
									<para role="indent">
										<command  linkend="${studyReference.documentKey.uuid!}">
											<@com.text studyReference.name/>
										</command>
									</para>
								</#list>
							</#compress></#local>
							<#if merge>
								<#local links = links + [summaryLinks]/>
							<#else>
								<para><emphasis role="bold">Linked studies: </emphasis></para>${summaryLinks}
								<@com.emptyLine/>
							</#if>
						</#if>
	
					<#--CSA value-->
						<#if summary.documentSubType=="ToxRefValues">
							<para><emphasis role="bold">Toxicological reference values: </emphasis></para>
							<@toxRefValuesTable summary/><@com.emptyLine/>
	
						<#elseif summary.documentSubType=="EndocrineDisruptingPropertiesAssessmentPest">
							<para><emphasis role="bold">ED assessment: </emphasis></para>
							<@endocrineDisruptingPropertiesTable summary/><@com.emptyLine/>
	
						<#elseif summary.documentSubType=="NonDietaryExpo">
							<@nonDietaryExpoSummary summary/><@com.emptyLine/>
	
						<#elseif summary.documentSubType=="DermalAbsorption">
							<para><emphasis role="bold">Key values for chemical safety assessment: </emphasis></para>
							<para role="indent">
								<@dermalAbsorptionSummary summary/>
								<@com.emptyLine/>
							</para>
	
						<#elseif summary.documentSubType=="Toxicokinetics" || (summary.documentSubType=="Phototoxicity" && !(merge))>
							<para><emphasis role="bold">Key values for chemical safety assessment: </emphasis></para>
							<para role="indent">
								<@valueForCSA summary summaryDocToCSAMap[summary.documentSubType]/>
								<@com.emptyLine/>
							</para>
	
						<#else>
	
							<#if !merge><#local endpointsHash={}/></#if>
	
						<#--Get sequence of hashes and populate hash-->
							<#if summary.documentSubType=="Phototoxicity">
							<#--special case for Phototox-->
								<#local photoEndpoint><@com.value summary.KeyValueCsa.Phototoxicity.EndpointConclusion/></#local>
								<#local photoLinks = summaryLinks?replace('role="indent"', '')/>
								<#local summarySeq = [{"name":"Phototoxicity", "links": photoLinks, "endpoint": photoEndpoint}]/>
							<#elseif summary.documentSubType=="SpecificInvestigationsOtherStudies">
								<#local summarySeq = [{"name":"Intraperitoneal/subcutaneous single dose", "links":summaryLinks?replace('role="indent"', ''), "endpoint": ""}]/>
							<#else>
								<#local summarySeq = getSummarySeq(summary)/>
							</#if>
	
							<#list summarySeq as seqEntry>
								<#if endpointsHash[seqEntry["name"]]??>
									<#local newSeqEntry = endpointsHash[seqEntry["name"]] + [seqEntry]/>
									<#local endpointsHash = endpointsHash + {seqEntry["name"]:newSeqEntry}/>
								<#else>
									<#local endpointsHash = endpointsHash + {seqEntry["name"]:[seqEntry]}/>
								</#if>
							</#list>
	
	
							<#if !merge && endpointsHash?has_content>
								<para><emphasis role="bold">Key values for chemical safety assessment: </emphasis></para>
								<@getSummaryFromHash endpointsHash/><@com.emptyLine/>
							</#if>
	
						</#if>
	
					<#--  MoA: to do -->
						<#local summaryMoA=""/>
						<#if summary.hasElement("KeyValueForChemicalSafetyAssessment.MoAHumanRelevanceFramework.MoAHumanRelevanceFramework") && summary.Discussion.Discussion?has_content>
							<#local summaryMoA><para role="indent"><@com.richText summary.KeyValueForChemicalSafetyAssessment.MoAHumanRelevanceFramework.MoAHumanRelevanceFramework/></para></#local>
						<#elseif summary.hasElement("KeyValueForChemicalSafetyAssessment.MoAAnalysisHumanRelevanceFramework.MoAAnalysisHumanRelevanceFramework")>
							<#local summaryMoA><para role="indent"><@com.richText summary.KeyValueForChemicalSafetyAssessment.MoAAnalysisHumanRelevanceFramework.MoAAnalysisHumanRelevanceFramework/></para></#local>
						</#if>
						<#if summaryMoA?has_content>
							<#if merge>
								<#local moa = moa + [summaryMoA]/>
							<#else>
								<para><emphasis role="bold">Mode of Action Analysis / Human Relevance Framework: </emphasis></para>${summaryMoA}
							</#if>
						</#if>
	
	
					<#--Discussion-->
						<#if summary.hasElement("Discussion.Discussion") && summary.Discussion.Discussion?has_content>
							<#local summaryDiscussion><para role="indent"><@com.richText summary.Discussion.Discussion/></para></#local>
							<#if merge>
								<#local addInfo = addInfo + [summaryDiscussion]/>
							<#else>
								<para><emphasis role="bold">Additional information: </emphasis></para>${summaryDiscussion}
							</#if>
						</#if>
	
					<#--Additional Info-->
						<#local summaryAddInfo = ""/>
	
						<#if summary.documentSubType=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction" || summary.documentSubType=="Sensitisation">
	
							<#local summaryAddInfo = []/>
							<#list summary.KeyValueForChemicalSafetyAssessment?children as csaEntry>
								<#if csaEntry?node_type=="block">
									<#local addInfoPath><#compress>
										<#if csaEntry.hasElement("EndpointConclusion.AdditionalInformation")>
											csaEntry.EndpointConclusion.AdditionalInformation
										<#elseif csaEntry.hasElement("AdditionalInformation.AdditionalInfo")>
											csaEntry.AdditionalInformation.AdditionalInfo
										</#if>
									</#compress></#local>
									<#if addInfoPath?has_content && addInfoPath?eval?has_content>
										<#local csaName>${csaEntry?node_name?replace("([A-Z]{1})", " $1", "r")?lower_case?cap_first}:</#local>
										<#local csaAddInfo><para role="indent">
										<#--  <emphasis role="underline">${csaName}</emphasis> -->
											<@com.richText addInfoPath?eval/></para>
										</#local>
										<#local summaryAddInfo = summaryAddInfo + [csaAddInfo]/>
									</#if>
								</#if>
							</#list>
							<#local summaryAddInfo>${summaryAddInfo?join("<?linebreak?>")}</#local>
	
						<#elseif summary.hasElement("AdditionalInformation.AdditionalInfo") && summary.AdditionalInformation.AdditionalInfo?has_content>
	
							<#local summaryAddInfo><para role="indent"><@com.richText summary.AdditionalInformation.AdditionalInfo/></para></#local>
						</#if>
	
						<#if summaryAddInfo?has_content>
							<#if merge>
								<#local addInfo =  addInfo + [summaryAddInfo]/>
							<#else>
								<para><emphasis role="bold">Additional information: </emphasis></para>${summaryAddInfo}
							</#if>
						</#if>
	
					<#--Justification-->
						<#--  <#if summary.hasElement("JustificationForClassificationOrNonClassification") && summary.JustificationForClassificationOrNonClassification?has_content>
	
							<#local summaryJustification><#compress>
								<#list summary.JustificationForClassificationOrNonClassification?children as just>
									<#if just?has_content>
										<para role="indent">
											<#if just_has_next>${just?node_name?replace("([A-Z]{1})", " $1", "r")?lower_case?cap_first}:</#if>
											<@com.richText just/>
										</para>
									</#if>
								</#list>
							</#compress></#local>
							<#if merge>
								<#local justification =  justification + [summaryJustification]/>
							<#else>
								<para><emphasis role="bold">Justification for classification or non-classification:</emphasis></para>${summaryJustification}
							</#if>
						</#if>  -->
						<#local summaryJustification>
						<#if summary.hasElement("Justification") && docSubType!="AcuteToxicity">

							<#if summary.Justification?has_content>
								<@justification summary "Justification.JustifClassif"/>
							</#if>

						<#elseif docSubType=="AcuteToxicity" && summary.hasElement("Justification")>

							<#if summary.Justification?has_content>
								<@justification summary "Justification.JustifClassif"/>
								<@justification summary "Justification.JustifClassif_STOTSE"/>	
							</#if>								
						</#if>
						</#local>

						<#if merge>
							<#local justification =  justification + [summaryJustification]/>
						<#else>
							<para><emphasis role="bold">Justification for classification or non-classification:</emphasis></para>${summaryJustification}
						</#if>

					</#list>
	
					<#if merge>
						<#if keyInfo?has_content>
							<para><emphasis role="bold">Key information: </emphasis></para>
							${keyInfo?join("")}
							<@com.emptyLine/>
						</#if>
	
						<#if endpointsHash?has_content>
							<para><emphasis role="bold">Key values for chemical safety assessment: </emphasis></para>
							<@getSummaryFromHash endpointsHash/>
							<@com.emptyLine/>
						</#if>
	
						<#if moa?has_content>
							<para><emphasis role="bold">Mode of Action Analysis / Human Relevance Framework:</emphasis></para>
							${moa?join("")}
							<@com.emptyLine/>
						</#if>
	
						<#if addInfo?has_content>
							<para><emphasis role="bold">Additional information:</emphasis></para>
							${addInfo?join("")}
							<@com.emptyLine/>
						</#if>
	
					<#--                    <#if discussion?has_content>-->
					<#--                        <para><emphasis role="bold">Discussion:</emphasis></para>-->
					<#--                        ${discussion?join("")}-->
					<#--                        <@com.emptyLine/>-->
					<#--                    </#if>-->
	
						<#if justification?has_content>
							<para><emphasis role="bold">Justification for classification or non classification:</emphasis></para>
							${justification?join("")}
							<@com.emptyLine/>
						</#if>
					</#if>
	
				</#if>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro valueForCSA summary propertyData>
	<#compress>
		<#if propertyData["values"]?has_content>
			<#list propertyData["values"] as value>

				<#local valuePath = "summary." + propertyData["path"] + "." + value["field"] />
				<#local val = valuePath?eval />
				<#if val?has_content>
					<para>
					<#-- preText -->
					${value["preText"]!}

					<#-- value
					NOTE: the "type" field in the hashMap could be omitted and just use node_type for each case
					e.g. picklist_single, picklist_multi...-->
					<#if value["type"]=='listValue'>
						<@com.value val />
					<#elseif value["type"]=='mListValue'>
						<@com.value  val />
					<#elseif value["type"]=='value'>
						<#if (val?node_type)=="decimal">
							<@com.number val />
						<#elseif (val?node_type)=="quantity">
							<@com.quantity val />
						<#elseif (val?node_type)=="range">
							<@com.range val />
						</#if>
					</#if>

					<#-- postText -->
					${value["postText"]!}

					<#-- atValuePath -->
					<#if value["atField"]?has_content>
						<#local atValuePath = "summary." + propertyData["path"] + "." + value["atField"] />
						<#local atVal = atValuePath?eval />
						<#if atVal?has_content>
							at <@com.quantity atVal />
						</#if>
					</#if>
					</para>
				</#if>
<#--				<#if value_has_next>-->
<#--					<?linebreak?>-->
<#--				</#if>-->
			</#list>
		</#if>
	</#compress>
</#macro>

<#--  Function to create a hashmap with CSA info from tox summaries  -->
<#function getToxCSA summary csaPath=['KeyValueForChemicalSafetyAssessment'] excludePath=['']>
	<#--  Initialize sequence that will hold CSA values  -->
	<#local summaryCSAseq = []/>

	<#--  TOXICOKINETICS  -->
	<#if summary?node_name=="Toxicokinetics">

		<#-- Get links to relevant study record(s) -->
		<#local CSABlock = studyandsummaryCom.getObjectFromPathOptions(summary, ["KeyValue"])/>

		<#if CSABlock?has_content>
			
			<#list CSABlock?children as child>

				<#--  Take the label of the field as childName  -->
				<@iuclid.label for=child var="childName"/>

				<#--  Get endpoint conclusion  -->				
				<#local endpointConclusion>
					<#if child?node_type=="block">
						<#list child?children as blockChild>
						<@iuclid.label for=blockChild var="blockChildName"/>
							<#if blockChild?node_type!="document_references" && blockChild?has_content>
								<para>${blockChildName}: <@com.value blockChild/></para>
							</#if>
						</#list>
					</#if>
				</#local>

				<#--  Links  -->
				<#local links = ''/>
				<#local links = studyandsummaryCom.getSummaryLinks(child, ["LinkToRelevantStudyRecord"])/>

				<#--  Append variables to final sequence  -->
				<#if links?has_content || endpointConclusion?has_content>
					<#local summaryCSAseq = summaryCSAseq + [{'endpoint': childName!, 'conclusion' : endpointConclusion!, "links" : links!}]/>
				</#if>
			</#list>
		</#if>

	<#--  DERMAL ABSORPTION  -->
	<#elseif summary?node_name=="DermalAbsorption">
		<#--  Iterate over csaPath  -->
		<#list csaPath as path>
			<#--  Get block at path (CSA or Links)  -->
			<#local block = studyandsummaryCom.getObjectFromPathOptions(summary, [path])/>

			<#if block?has_content>
				<#if block?node_name=="LinkToRelevantStudyRecord">
					<#--  Get links to relevant study record(s)  -->
					<#local links = studyandsummaryCom.getSummaryLinks(block, ["Link"])/>

				<#elseif block?node_name=="KeyValueCsa">
					<#--  Get endpoint  -->
					<#local endpoint>
						<#compress>
							<#if block.hasElement("Endpoint")>
								<@com.value block.Endpoint/>
							</#if>
						</#compress>
					</#local>

					<#--  Get type of information  -->
					<#local infoType>
						<#compress>
							<#if block.hasElement("TypeOfInformation")>
								<@com.value block.TypeOfInformation/>
							</#if>
						</#compress>
					</#local>

					<#--  Get species  -->
					<#local species>
						<#compress>
							<#if block.hasElement("Species")>
								<@com.value block.Species/>
							</#if>
						</#compress>
					</#local>

					<#--  Get results  -->
					<#local results>
						<#compress>
							<#if block.hasElement("Results")>
								<#list block.Results as row>
									<#if row.Concentration?has_content>
										<@com.value row.Concentration/>
									</#if>

									<#if row.Parameter?has_content>
										<@com.value row.Parameter/>
									</#if>
									 - absorption: 
									<#if row.Absorption?has_content>
										<@com.value row.Absorption/>
									</#if>

									<#if row?has_next>
										<@com.emptyLine/>
									</#if>
								</#list>
							</#if>
						</#compress>
					</#local>

					<#--  Get justification  -->
					<#local justification>
						<#compress>
							<#if block.hasElement("Justification")>
								<@com.value block.Justification/>
							</#if>
						</#compress>
					</#local>
				</#if>
			</#if>
		</#list>

		<#--  Append variables to final sequence  -->
		<#if links?has_content || endpoint?has_content || infoType?has_content || species?has_content || results?has_content  || justification?has_content>
			<#local summaryCSAseq = summaryCSAseq + [{'endpoint': endpoint!, 'infoType' : infoType!, 'species' : species!, 'results' : results!, 'justification' : justification!, "links" : links!}]/>
		</#if>
	<#else>
		<#--  Consider different path names, if not provided  -->
		<#local csaBlock = studyandsummaryCom.getObjectFromPathOptions(summary, csaPath)/>

		<#--  Iterate over CSA block children  -->
		<#if csaBlock?has_content>
			<#list csaBlock?children as block>
				
				<#--  Take the label of the field as block name  -->
				<@iuclid.label for=block var="blockName"/>

				<#--  Process if path is not to be excluded  -->
				<#if !excludePath?seq_contains(block?node_name)>
					<#if block?node_type=="block">

						<#--  ACUTE TOXICITY - IRRITATION/CORROSION - SENSITISATION - GENOTOXICITY - CARCINOGENICITY - NEUROTOXICITY - IMMUNOTOXICITY - PHOTOTOXICITY  -->
						<#if summary?node_name=="AcuteToxicity" || summary?node_name=="IrritationCorrosion" || summary?node_name=="Sensitisation" || summary?node_name=="GeneticToxicity" || summary?node_name=="Carcinogenicity" || summary?node_name=="Neurotoxicity" || summary?node_name=="Immunotoxicity" || summary?node_name=="Phototoxicity">
							<#--  Links  -->
							<#local links = ''/>
							<#local links = studyandsummaryCom.getSummaryLinks(block, ["LinkToRelevantStudyRecord"])/>

							<#--  Endpoint conclusion  -->
							<#local endpointConclusion>
								<#compress>
									<#if block.hasElement("EndpointConclusion")>
										<@com.value block.EndpointConclusion/>
									<#elseif block.hasElement("EndpointConclusion2")>
										<@com.value block.EndpointConclusion2/>
									</#if>

									<#if block.hasElement("PhysicalForm")>
										(<@com.value block.PhysicalForm/>)
									</#if>
								</#compress>
							</#local>

							<#--  Dose descriptor  -->
							<#local doseDescriptor>
								<#compress>
									<#if block.hasElement("EffectLevelUnit")>
										<@com.value block.EffectLevelUnit/>
									</#if>
								</#compress>
							</#local>

							<#--  Effect level  -->
							<#local effLev>
								<#compress>
									<#if block.hasElement("EffectLevelValue")>
										<@com.value block.EffectLevelValue/>
									</#if>
								</#compress>
							</#local>

							<#if summary?node_name=="Carcinogenicity" || summary?node_name=="Neurotoxicity" || summary?node_name=="Immunotoxicity">
								<#--  Study duration  -->
								<#local duration>
									<#compress>
										<#if block.hasElement("TestType")>
											<@com.value block.TestType/>
										</#if>
									</#compress>
								</#local>

								<#--  Species  -->
								<#local species>
									<#compress>
										<#if block.hasElement("Species")>
											<@com.value valuePath=block.Species printDescription=false/>
										</#if>
									</#compress>
								</#local>

								<#if summary?node_name=="Carcinogenicity">
									<#--  System  -->
									<#local system>
										<#compress>
											<#if block.hasElement("System")>
												<@com.value block.System/>
											</#if>
										</#compress>
									</#local>

									<#--  Organ  -->
									<#local organ>
										<#compress>
											<#if block.hasElement("Organ")>
												<@com.value block.Organ/>
											</#if>
										</#compress>
									</#local>
								</#if>
							</#if>

							<#--  Append variables to final sequence  -->
							<#if summary?node_name=="Carcinogenicity">
								<#if endpointConclusion?has_content || doseDescriptor?has_content || effLev?has_content || links?has_content || duration?has_content || species?has_content || system?has_content || organ?has_content>
									<#local summaryCSAseq = summaryCSAseq + [{'endpoint': blockName, "links" : links!, "descriptor" : doseDescriptor!, "effect" : effLev!, "conclusion" : endpointConclusion!, "duration" : duration!, "species":species!, "system":system!, "organ":organ!}]/>
								</#if>
							<#elseif summary?node_name=="Neurotoxicity" || summary?node_name=="Immunotoxicity">
								<#if endpointConclusion?has_content || doseDescriptor?has_content || effLev?has_content || links?has_content || duration?has_content || species?has_content>
									<#local summaryCSAseq = summaryCSAseq + [{'endpoint': blockName, "links" : links!, "descriptor" : doseDescriptor!, "effect" : effLev!, "conclusion" : endpointConclusion!, "duration" : duration!, "species":species!}]/>
								</#if>
							<#else>
								<#if endpointConclusion?has_content || doseDescriptor?has_content || effLev?has_content || links?has_content>
									<#local summaryCSAseq = summaryCSAseq + [{'endpoint': blockName!, "links" : links!, "descriptor":doseDescriptor!, "effect":effLev!, "conclusion":endpointConclusion!}]/>
								</#if>
							</#if>

						<#--  REPEATED DOSE TOXICITY - REPRODUCTIVE TOXICITY  -->
						<#elseif summary?node_name=="RepeatedDoseToxicity" || summary?node_name=="ToxicityToReproduction">
							<#list block?children as subBlock>
								<#--  Take the label of the field as block name  -->
								<@iuclid.label for=subBlock var="subBlockName"/>

								<#if subBlock?node_type=="block">
									<#--  Links  -->
									<#local links = ''/>
									<#local links = studyandsummaryCom.getSummaryLinks(subBlock, ["LinkToRelevantStudyRecord"])/>

									<#--  Endpoint conclusion - ONLY FOR REPROD TOX  -->
									<#local endpointConclusion>
										<#compress>
											<#if subBlock.hasElement("EndpointConclusion")>
												<@com.value subBlock.EndpointConclusion/>
											</#if>
										</#compress>
									</#local>

									<#--  Dose descriptor  -->
									<#local doseDescriptor>
										<#compress>
											<#if subBlock.hasElement("EffectLevelUnit")>
												<@com.value subBlock.EffectLevelUnit/>
											</#if>
										</#compress>
									</#local>

									<#--  Effect level  -->
									<#local effLev>
										<#compress>
											<#if subBlock.hasElement("EffectLevelValue")>
												<@com.value subBlock.EffectLevelValue/>
											</#if>
										</#compress>
									</#local>

									<#--  Study duration  -->
									<#local duration>
										<#compress>
											<#if subBlock.hasElement("TestType")>
												<@com.value subBlock.TestType/>
											</#if>
										</#compress>
									</#local>

									<#--  Experimental exposure time per week (hours/week)  -->
									<#local exposure>
										<#compress>
											<#if subBlock.hasElement("ExperimentalExposureTimePerWeek")>
												<@com.value subBlock.ExperimentalExposureTimePerWeek/>
											</#if>
										</#compress>
									</#local>

									<#--  Species  -->
									<#local species>
										<#compress>
											<#if subBlock.hasElement("Species")>
												<@com.value valuePath=subBlock.Species printDescription=false/>
											</#if>
										</#compress>
									</#local>

									<#--  System - ONLY FOR REP DOSE TOX  -->
									<#local system>
										<#compress>
											<#if subBlock.hasElement("System")>
												<@com.value subBlock.System/>
											</#if>
										</#compress>
									</#local>

									<#--  Organ - ONLY FOR REP DOSE TOX  -->
									<#local organ>
										<#compress>
											<#if subBlock.hasElement("Organ")>
												<@com.value subBlock.Organ/>
											</#if>
										</#compress>
									</#local>

									<#--  Append variables to final sequence  -->
									<#if summary?node_name=="RepeatedDoseToxicity">
										<#if doseDescriptor?has_content || effLev?has_content || links?has_content || exposure?has_content || species?has_content || system?has_content || organ?has_content>
											<#local summaryCSAseq = summaryCSAseq + [{'endpoint': blockName + " - " + subBlockName!, "links" : links!, "descriptor" : doseDescriptor!, "effect" : effLev!, "exposure" : exposure!, "species":species!, "system":system!, "organ":organ!}]/>
										</#if>
									<#elseif summary?node_name=="ToxicityToReproduction">
										<#if endpointConclusion?has_content || doseDescriptor?has_content || effLev?has_content || duration?has_content || links?has_content || exposure?has_content || species?has_content>
											<#local summaryCSAseq = summaryCSAseq + [{'endpoint': subBlockName!, "links" : links!, "conclusion" : endpointConclusion!, "descriptor" : doseDescriptor!, "effect" : effLev!, "duration" : duration!, "exposure" : exposure!, "species":species!}]/>
										</#if>
									</#if>
								</#if>
							</#list>

						<#--  REPRODUCTIVE TOXICITY  -->
						<#elseif summary?node_name=="ToxicityToReproduction_EU_PPP">

							<#list block?children as subBlock>
								<#--  Take the label of the field as subBlockName  -->
								<@iuclid.label for=subBlock var="subBlockName"/>

								<#--  Links  -->
								<#if subBlock?node_type=="block">
									<#if subBlock?node_name=="LinkToRelevantStudyRecords">
										<#local links = studyandsummaryCom.getSummaryLinks(subBlock, ["StudyNameType"])/>
									</#if>
								</#if>

								<#if !subBlock?node_name?matches("LinkToRelevantStudyRecords") && !subBlock?node_name?matches("DescriptionOfKeyInformation") && !subBlock?node_name?matches("AdditionalInformation")>
									<#if subBlock?node_name?matches("EffectsOnDevelopmentalToxicity.EffectOnDevelopmentalToxicityViaOralRoute") >
										<#if subBlock?node_name?matches("EffectsOnDevelopmentalToxicity.EffectOnDevelopmentalToxicityViaOralRoute")>
											<#local devToxPath = subBlock />
										</#if>
										
										<#list devToxPath as devTox>
											<#--  Endpoint conclusion  -->
											<#local endpointConclusion>
												<#compress>
													<#if devTox.hasElement("EndpointConclusion")>
														<@com.value devTox.EndpointConclusion/>
													</#if>
												</#compress>
											</#local>

											<#--  Basis For Effect Level  -->
											<#local basisEffLev>
												<#compress>
													<#if devTox.hasElement("BasisForEffectLevel")>
														<@com.value devTox.BasisForEffectLevel/>
													</#if>
												</#compress>
											</#local>

											<#--  Dose descriptor  -->
											<#local doseDescriptor>
												<#compress>
													<#if devTox.hasElement("EffectLevelUnit")>
														<@com.value devTox.EffectLevelUnit/>
													</#if>
												</#compress>
											</#local>

											<#--  Effect level  -->
											<#local effLev>
												<#compress>
													<#if devTox.hasElement("EffectLevelValue")>
														<@com.value devTox.EffectLevelValue/>
													</#if>
												</#compress>
											</#local>

											<#--  Study duration  -->
											<#local duration>
												<#compress>
													<#if devTox.hasElement("TestType")>
														<@com.value devTox.TestType/>
													</#if>
												</#compress>
											</#local>

											<#--  Experimental exposure time per week (hours/week)  -->
											<#local exposure>
												<#compress>
													<#if devTox.hasElement("ExperimentalExposureTimePerWeek")>
														<@com.value devTox.ExperimentalExposureTimePerWeek/>
													</#if>
												</#compress>
											</#local>

											<#--  Species  -->
											<#local species>
												<#compress>
													<#if devTox.hasElement("Species")>
														<@com.value valuePath=devTox.Species printDescription=false/>
													</#if>
												</#compress>
											</#local>

											<#--  Append variables to final sequence  -->
											<#if links?has_content || endpointConclusion?has_content || basisEffLev?has_content || doseDescriptor?has_content || effLev?has_content || duration?has_content || exposure?has_content || species?has_content>
												<#local summaryCSAseq = summaryCSAseq + [{'endpoint': subBlockName!, "links" : links!, "conclusion" : endpointConclusion!, "basis" : basisEffLev!, "descriptor" : doseDescriptor!, "effect" : effLev!, "duration" : duration!, "exposure" : exposure!, "species":species!}]/>
											</#if>
										</#list>
									<#else>
										<#--  Endpoint conclusion  -->
										<#local endpointConclusion>
											<#compress>
												<#if subBlock.hasElement("EndpointConclusion")>
													<@com.value subBlock.EndpointConclusion/>
												</#if>
											</#compress>
										</#local>

										<#--  Basis For Effect Level  -->
										<#local basisEffLev>
											<#compress>
												<#if subBlock.hasElement("BasisForEffectLevel")>
													<@com.value subBlock.BasisForEffectLevel/>
												</#if>
											</#compress>
										</#local>

										<#--  Dose descriptor  -->
										<#local doseDescriptor>
											<#compress>
												<#if subBlock.hasElement("EffectLevelUnit")>
													<@com.value subBlock.EffectLevelUnit/>
												</#if>
											</#compress>
										</#local>

										<#--  Effect level  -->
										<#local effLev>
											<#compress>
												<#if subBlock.hasElement("EffectLevelValue")>
													<@com.value subBlock.EffectLevelValue/>
												</#if>
											</#compress>
										</#local>

										<#--  Study duration  -->
										<#local duration>
											<#compress>
												<#if subBlock.hasElement("TestType")>
													<@com.value subBlock.TestType/>
												</#if>
											</#compress>
										</#local>

										<#--  Experimental exposure time per week (hours/week)  -->
										<#local exposure>
											<#compress>
												<#if subBlock.hasElement("ExperimentalExposureTimePerWeek")>
													<@com.value subBlock.ExperimentalExposureTimePerWeek/>
												</#if>
											</#compress>
										</#local>

										<#--  Species  -->
										<#local species>
											<#compress>
												<#if subBlock.hasElement("Species")>
													<@com.value valuePath=subBlock.Species printDescription=false/>
												</#if>
											</#compress>
										</#local>

										<#--  Append variables to final sequence  -->
										<#if links?has_content || endpointConclusion?has_content || basisEffLev?has_content || doseDescriptor?has_content || effLev?has_content || duration?has_content || exposure?has_content || species?has_content>
											<#local summaryCSAseq = summaryCSAseq + [{'endpoint': subBlockName!, "links" : links!, "conclusion" : endpointConclusion!, "basis" : basisEffLev!, "descriptor" : doseDescriptor!, "effect" : effLev!, "duration" : duration!, "exposure" : exposure!, "species":species!}]/>
										</#if>
									</#if>
								</#if>
							</#list>
						</#if>
					</#if>
				</#if>
			</#list>
		</#if>
	</#if>

	<#--  Initialize a hash that will hold information from all summaries  -->
	<#--  <#local endpointsHash = {}/>
	<#list summaryCSAseq as seqEntry>
		<#if endpointsHash[seqEntry["name"]]??>
			<#local newSeqEntry = endpointsHash[seqEntry["name"]] + [seqEntry]/>
			<#local endpointsHash = endpointsHash + {seqEntry["name"]:newSeqEntry}/>
		<#else>
			<#local endpointsHash = endpointsHash + {seqEntry["name"]:[seqEntry]}/>
		</#if>
	</#list>  -->
	
	<#return summaryCSAseq/>
</#function>

<#--  Macro for the basic summary table of tox CSA  -->
<#macro toxCSAtable summaryList bgcolor="#FBDDA6">
	<#compress>
		<#if !summaryList?is_sequence>
			<#local summaryList=[summaryList]/>
		</#if>

		<#list summaryList as summary>
			<#if summary?node_name=="NonDietaryExpo">
				<@nonDietaryExpoSummary summary bgcolor/><@com.emptyLine/>
			<#elseif summary?node_name=="ToxRefValues">
				<para><emphasis role="bold">Toxicological reference values: </emphasis></para>
				<@toxRefValuesTable summary bgcolor/><@com.emptyLine/>
			<#else>
				<#--  Initialize a hash that will hold information from all summaries  -->
				<#if summary?node_name=="Phototoxicity">
					<#local endpointsHash = getToxCSA(summary, ['KeyValueCsa'])/>
				<#elseif summary?node_name=="DermalAbsorption">
					<#local endpointsHash = getToxCSA(summary, ['KeyValueCsa', 'LinkToRelevantStudyRecord'])/>
				<#elseif summary?node_name=="ToxicityToReproduction_EU_PPP">
					<#local endpointsHash = getToxCSA(summary, ['KeyValueForChemicalSafetyAssessment'], ['ToxicityToReproductionOtherStudies', 'MoAAnalysisHumanRelevanceFramework'])/>
				<#else>
					<#local endpointsHash = getToxCSA(summary)/>
				</#if>

				<#--  Parse the hash and create the table  -->
				<#if endpointsHash?has_content>
					<#--  CREATE TABLE  -->
					<table border="1">
						<#--  Set columns width  -->
						<#if summary?node_name=="AcuteToxicity">
							<col width="24%"/>
							<col width="14%"/>
							<col width="28%"/>
							<col width="34%"/>
						<#elseif summary?node_name=="RepeatedDoseToxicity">
							<col width="20%"/>
							<col width="12%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="17%"/>
							<col width="10%"/>
							<col width="20%"/>
						<#elseif summary?node_name=="Carcinogenicity">
							<col width="14%"/>
							<col width="12%"/>
							<col width="12%"/>
							<col width="11%"/>
							<col width="11%"/>
							<col width="13%"/>
							<col width="10%"/>
							<col width="17%"/>
						</#if>

						<#--  Define table header  -->
						<thead>
							<tr align="center" valign="middle"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if>
								<th><emphasis role="bold">Endpoint</emphasis></th>

								<#if summary?node_name=="AcuteToxicity" || summary?node_name=="RepeatedDoseToxicity" || summary?node_name=="Carcinogenicity" || summary?node_name=="Neurotoxicity" || summary?node_name=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction" || summary?node_name=="Immunotoxicity">
									<th><emphasis role="bold">Dose descriptor, Effect level</emphasis></th>
								</#if>

								<#if summary?node_name!="RepeatedDoseToxicity" && summary?node_name!="DermalAbsorption">
									<th><emphasis role="bold">Endpoint Conclusion</emphasis></th>
								</#if>

								<#if summary?node_name=="ToxicityToReproduction_EU_PPP">
									<th><emphasis role="bold">Basis For Effect Level</emphasis></th>
								</#if>

								<#if summary?node_name=="RepeatedDoseToxicity" || summary?node_name=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction">
									<th><emphasis role="bold">Exposure (hours/week)</emphasis></th>
								</#if>

								<#if summary?node_name=="Carcinogenicity" || summary?node_name=="Neurotoxicity" || summary?node_name=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction" || summary?node_name=="Immunotoxicity">
									<th><emphasis role="bold">Study duration</emphasis></th>
								</#if>

								<#if summary?node_name=="DermalAbsorption">
									<th><emphasis role="bold">Type of information</emphasis></th>
									<th><emphasis role="bold">Justification</emphasis></th>
									<th><emphasis role="bold">Results</emphasis></th>
								</#if>

								<#if summary?node_name=="RepeatedDoseToxicity" || summary?node_name=="Carcinogenicity" || summary?node_name=="Neurotoxicity" || summary?node_name=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction" || summary?node_name=="DermalAbsorption" || summary?node_name=="Immunotoxicity">
									<th><emphasis role="bold">Species</emphasis></th>

									<#if summary?node_name!="Neurotoxicity" && summary?node_name!="ToxicityToReproduction_EU_PPP" && summary?node_name!="ToxicityToReproduction" && summary?node_name!="DermalAbsorption" && summary?node_name!="Immunotoxicity">
										<th><emphasis role="bold">System</emphasis></th>
										<th><emphasis role="bold">Organ</emphasis></th>
									</#if>
								</#if>

								<th><emphasis role="bold">Linked studies</emphasis></th>
							</tr>
						</thead>

						<#--  Define table body  -->
						<tbody valign="middle">
							<#if summary?node_name=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction">
								<#local fertRowSpan = 0>
								<#local devToxRowSpan = 0>

								<#local prevEndpoint = ''>

								<#list endpointsHash as item>
									<#if !item.endpoint?truncate(15)?matches(prevEndpoint?truncate(15))>
										<#if item.endpoint?starts_with("Effect on fertility")>
											<#local fertRowSpan++>
										<#elseif item.endpoint?starts_with("Effect on developmental")>
											<#local devToxRowSpan++>
										</#if>
									</#if>

									<#local prevEndpoint = item.endpoint>
								</#list>
							</#if>

							<#list endpointsHash as item>
								<tr>
									<td>${item.endpoint}</td>

									<#if summary?node_name=="AcuteToxicity" || summary?node_name=="RepeatedDoseToxicity" || summary?node_name=="Carcinogenicity" || summary?node_name=="Neurotoxicity" || summary?node_name=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction" || summary?node_name=="Immunotoxicity">
										<td>${item.descriptor} ${item.effect}</td>
									</#if>

									<#if summary?node_name!="RepeatedDoseToxicity" && summary?node_name!="DermalAbsorption">
										<td>${item.conclusion}</td>
									</#if>

									<#if summary?node_name=="ToxicityToReproduction_EU_PPP">
										<td>${item.basis}</td>
									</#if>

									<#if summary?node_name=="RepeatedDoseToxicity" || summary?node_name=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction">
										<td>${item.exposure}</td>
									</#if>

									<#if summary?node_name=="Carcinogenicity" || summary?node_name=="Neurotoxicity" || summary?node_name=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction" || summary?node_name=="ToxicityToReproduction" || summary?node_name=="Immunotoxicity">
										<td>${item.duration}</td>
									</#if>

									<#if summary?node_name=="DermalAbsorption">
										<td>${item.infoType}</td>
										<td>${item.justification}</td>
										<td>${item.results}</td>
									</#if>
									
									<#if summary?node_name=="RepeatedDoseToxicity" || summary?node_name=="Carcinogenicity" || summary?node_name=="Neurotoxicity" || summary?node_name=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction" || summary?node_name=="DermalAbsorption" || summary?node_name=="Immunotoxicity">
										<td>${item.species}</td>

										<#if summary?node_name!="Neurotoxicity" && summary?node_name!="ToxicityToReproduction_EU_PPP" && summary?node_name!="ToxicityToReproduction" && summary?node_name!="Toxicokinetics" && summary?node_name!="AcuteToxicity" && summary?node_name!="IrritationCorrosion" && summary?node_name!="Sensitisation" && summary?node_name!="DermalAbsorption" && summary?node_name!="Immunotoxicity">
											<td>${item.system}</td>
											<td>${item.organ}</td>
										</#if>
									</#if>

									<#if summary?node_name=="ToxicityToReproduction_EU_PPP" || summary?node_name=="ToxicityToReproduction">
										<#if item?index==0>
											<td rowspan="${fertRowSpan}">${item.links}</td>
										<#elseif item?index==fertRowSpan>
											<td rowspan="${devToxRowSpan}">${item.links}</td>
										</#if>
									<#elseif summary?node_name=="Toxicokinetics">
											<td >${item.links}</td>
									<#else>
										<td>${item.links}</td>
									</#if>
								</tr>
							</#list>
						</tbody>
					</table>
				</#if>
			</#if>
		</#list>
	</#compress>
</#macro>

<#-- Macro that prints the test system data in the "Endocrine disrupting properties in vitro" documents -->
<#macro endocrine_testSystemInformation testSys>
<#compress>
	<para><emphasis role="bold">Test system:</emphasis></para>
	<#if pppRelevant??>
		<@com.children path=testSys style="none" tabular=true/>
	<#else>

		<#if testSys.TestSystemType?has_content>
			<para role="indent">Type of test system: <@com.value testSys.TestSystemType /></para>
		</#if>

		<#if testSys.TestSystemIdentity?has_content>
			<para role="indent">Test system identity: <@com.value testSys.TestSystemIdentity /></para>
		</#if>

		<#if testSys.GeneticModOfSystem?has_content>
			<para role="indent">Genetic modification of the test system: <@com.value testSys.GeneticModOfSystem /></para>
		</#if>

		<#if testSys.TestSystemDetails?has_content>
			<para role="indent">Details on test system and experimental conditions: <@com.value testSys.TestSystemDetails ""/></para>
		</#if>

		<#if testSys.MetabolicCompetence?has_content>
			<para role="indent">Metabolic competence of the test system: <@com.value testSys.MetabolicCompetence /></para>
		</#if>
	</#if>	
</#compress>
</#macro>

<#-- Macro that prints a result record in the "Endocrine disrupting properties in vitro" documents -->
<#macro printResultsEndocrineInVitro testResult>
	<#if testResult.KeyObservation?has_content>
		<para role="indent">Key result: <@com.value testResult.KeyObservation /></para>
	</#if>

	<#if testResult.ConcentrationSelection?has_content>
		<para role="indent">Concentration selection on the test material: <@com.value testResult.ConcentrationSelection /></para>
	</#if>

	<#if testResult.ConcentrationRangeTested?has_content>
		<para role="indent">Concentration range tested: <@com.value testResult.ConcentrationRangeTested /></para>
	</#if>

	<#if testResult.NumberOfReplicatesAndOutliers?has_content>
		<para role="indent">Number of replicates and outliers: <@com.value testResult.NumberOfReplicatesAndOutliers "" /></para>
	</#if>

	<#if testResult.ParameterAndResult?has_content>
		<table border="1">
        	<title>Parameter and result</title>

        	<col width="40%"/>
        	<col width="60%"/>

			<tbody>		
			<tr>
            	<th colspan="1"><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Parameter</emphasis></th>
            	<th colspan="1"><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Result for the parameter</emphasis></th>
        	</tr>

        	<#list testResult.ParameterAndResult as parameterResult>
				<tr>

        		<td><#if parameterResult.Parameter?has_content><@com.value parameterResult.Parameter /></#if></td>
        		<td><#if parameterResult.ParameterResult?has_content><@com.value parameterResult.ParameterResult /></#if></td>

				</tr>
        	</#list>

        	</tbody>
    	</table>
	</#if>

	<#if testResult.OtherObservation?has_content>
		<table border="1">
        	<title>Other observations</title>

        	<col width="40%"/>
        	<col width="60%"/>

			<tbody>		
			<tr>
            	<th colspan="1"><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Observation</emphasis></th>
            	<th colspan="1"><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Concentration</emphasis></th>
        	</tr>

        	<#list testResult.OtherObservation as otherObservation>
				<tr>

        		<td><#if otherObservation.Observation?has_content><@com.value otherObservation.Observation /></#if></td>
        		<td><#if otherObservation.Concentration?has_content><@com.value otherObservation.Concentration /></#if></td>

				</tr>
        	</#list>

        	</tbody>
    	</table>
	</#if>

	<#if testResult.ResultsForTheTestMaterial?has_content>
		<para role="indent">Results for the test material: <@com.value testResult.ResultsForTheTestMaterial /></para>
	</#if>

	<#if testResult.AcceptanceOfResults?has_content>
		<para role="indent">Acceptance of results: <@com.value testResult.AcceptanceOfResults /></para>
	</#if>

	<#if testResult.RemarksOnResults?has_content>
		<para role="indent"><emphasis role="underline">Remarks on results:</emphasis><@com.value testResult.RemarksOnResults /></para>
	</#if>	
</#macro>

<#-- ecotoxicityMetabolitesTable generates an HTML table from the Metabolites repeatable table in 
	FLEXIBLE_SUMMARY.InformationEcotoxicityMetabolites (relevant for MICRO AS Ecotox and Tox)

	If more than one summary is passed to the macro, all Metabolites repeatable table from all summaries are put together into 
	the same table.

	Inputs:
	- summaryList: single summary or list of summary documents with transformation products blocks
	- bgcolor: background color for table headers
-->
<#macro ecotoxicityMetabolitesTable summaryList bgcolor="#FBDDA6">
	<#compress>

		<#-- transform to sequence if it's not -->
		<#if !summaryList?is_sequence>
			<#local summaryList=[summaryList]/>
		</#if>

		<#-- NOTE: a hash could be created to be able to sort results -->

		<#-- make a condition to check if ecotoxicity metabolites table exists this will work as long as
		the FLEXIBLE_SUMMARY.InformationEcotoxicityMetabolites is not combined with other summary types but
		only with itself -->
		<#local ecotoxMetabTableExist=false/>
		<#list summaryList as summary>
			<#if summary.hasElement('DescriptionOfKeyInformation.Metabolites') && summary.DescriptionOfKeyInformation.Metabolites?has_content>
				<#local ecotoxMetabTableExist=true/>
			</#if>
		</#list>

		<#if ecotoxMetabTableExist>
			<#-- make table header -->
			<table border="1">

				<col width="11%" />
				<col width="8%" />
				<#if _section=="Ecotox"><col width="7%" /></#if>
				<col width="10%" />
				<col width="7%" />
				<col width="9%" />
				<col width="11%" />
				<col width="10%" />
				<col width="11%" />
				<col width="9%" />
				<col width="7%" />
				

				<thead align="center" valign="middle">
					<tr>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Metabolite</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Hazard effect</emphasis></th>
						<#if _section=="Ecotox"><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">NTO</emphasis></th></#if>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Condition</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">LOQ</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Expected quantity</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Regulation mechanism</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Mode of action</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Suff. body of knowledge</emphasis></th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if>
							<emphasis role="bold"><#if _section=="Ecotox">Eco</#if>Toxic effect</emphasis>
						</th>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Antimicrobial</emphasis></th>
					</tr>
				</thead>
				<tbody valign="middle">

					<#--  Initialize the counter that keeps track of the remarks index  -->
					<#local footnotesCounter = 0 />
					<#local footnotesHash = {}/>

					<#-- populate table -->
					<#list summaryList as summary>
						<#list summary.DescriptionOfKeyInformation.Metabolites as item>
							<tr>
								<td>
									<#local substance=iuclid.getDocumentForKey(item.LinkMetabolite)/>
									<#if substance?has_content>
										<@com.text substance.ReferenceSubstanceName ""/>
									</#if>

									<#if item.Remarks?has_content>
										<#local footnotesCounter++ />

										<#local remarks>
											<@com.value item.Remarks ""/>
										</#local>

										(${footnotesCounter})

										<#local footnotesHash += {footnotesCounter: remarks}/>
									</#if>
								</td>
								<td>
									<#if _section=="Ecotox">
										<@com.value item.HazardousEffectObservedInEcotoxicologyStudies/>
									<#elseif _section=="Tox">
										<@com.value item.HazardousEffectObservedInToxicologicalStudies/>
									</#if>
								</td>
								<#if _section=="Ecotox">
									<td>
										<@com.value item.NonTargetOrganisms/>
									</td>
								</#if>
								<td>
									<@com.value item.Conditions/>
								</td>
								<td>
									<@com.value item.LOQOfMethod/>
								</td>
								<td>
									<@com.value item.ExpectedQuantities/>
								</td>
								<td>
									<@com.value item.RegulationMechanism/>
								</td>
								<td>
									<@com.value item.ModeOfAction/>
								</td>
								<td>
									<@com.value item.SufficientBodyOfKnowledge ""/>

									<#if item.LinkToLiteratureSearch?has_content>
										<#local footnotesCounter++ />

										<#local litSearch = iuclid.getDocumentForKey(item.LinkToLiteratureSearch) />
										<#local litSearchLink>
											<command  linkend="${litSearch.documentKey.uuid!}">
												<@com.text litSearch.name ""/>
											</command>
										</#local>

										(${footnotesCounter})

										<#local footnotesHash += {footnotesCounter: litSearchLink}/>
									</#if>
								</td>
								<td>
									<#if _section=="Ecotox">
										<@com.value item.NatureOfObservedEcotoxicEffect/>
									<#elseif _section=="Tox">
										<@com.value item.NatureOfObservedToxicEffect/>
									</#if>
								</td>
								<td>
									<#if _section=="Ecotox">
										<@com.value item.RelevantAntimicrobialActivity/>
									<#elseif _section=="Tox">
										<@com.value item.AntimicrobialActivity/>
									</#if>
								</td>
							</tr>
						</#list>
					</#list>
				</tbody>
			</table>
			<#if footnotesHash?has_content>
				<para role="small">
					<emphasis role="bold">Remarks / Literature Search:</emphasis>
					<emphasis>
						<#list footnotesHash as footnotesCounter, footnotesContent>
							<para><superscript>(${footnotesCounter})</superscript>${footnotesContent}</para>
						</#list>
					</emphasis>
				</para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#-- assessmentPotentialToxicity outputs the contents of the FLEXIBLE_SUMMARY.AssessmentPotentialToxicity (MIXTURE) and 
	FLEXIBLE_SUMMARY.PathogenicityInfectivityHumans (SUBSTANCE) documents for MICRO

	Inputs:
	- summary: document to be printed
-->	
<#macro assessmentPotentialToxicity summary>

	<#if summary?has_content>

		<#-- Assembling evidence -->
		<#if summary.hasElement("AssessmentOfPotentialToxicity")>
			<#local assemblingEvidence = summary.AssessmentOfPotentialToxicity.AssemblingEvidence>
		<#else>
			<#local assemblingEvidence = summary.AssessmentOfPotentialInfectivityAndPathogenicityOfTheMicroorganismToHumans.AssemblingEvidence>
		</#if>

		<#if assemblingEvidence?has_content>
			<para><emphasis role="bold">Assembling evidence</emphasis>:</para>
			<#list assemblingEvidence as reference>
				<#local litSearch = iuclid.getDocumentForKey(reference) />
				<para><command linkend="${litSearch.documentKey.uuid!}">
					<@com.text litSearch.name ""/><#if reference?has_next>; </#if>
				</command></para>
			</#list>
		</#if>

		<#-- Weighing evidence -->
		<#if summary.hasElement("AssessmentOfPotentialToxicity")>
			<#local weighingEvidence = summary.AssessmentOfPotentialToxicity.WeighingEvidence>
		<#else>
			<#local weighingEvidence = summary.AssessmentOfPotentialInfectivityAndPathogenicityOfTheMicroorganismToHumans.WeighingEvidence>
		</#if>

		<#if weighingEvidence?has_content>
			<para><emphasis role="bold">Weighing evidence</emphasis>:

				<#list weighingEvidence as evidence>

					<#if weighingEvidence?size gt 1>
						<#if evidence?index == 0><@com.emptyLine/></#if>
						<para role="indent"><emphasis role="bold">#${evidence?index+1}:</emphasis></para>
						<#local indentRole = "indent2">
					<#else>
						<#local indentRole = "indent">
						<@com.emptyLine/>
					</#if>	

					<#-- Description of key conclusion for the study -->
					<#if evidence.DescriptionOfKeyConclusionForTheStudy?has_content>
						<para role="${indentRole}"><emphasis role="bold">Description of key conclusion for the study</emphasis>: <@com.value evidence.DescriptionOfKeyConclusionForTheStudy/></para>
						<@com.emptyLine/>
					</#if>
					
					<#-- Identified uncertainties -->
					<#if evidence.IdentifiedUncertainties?has_content>
						<para role="${indentRole}"><emphasis role="bold">Identified uncertainties</emphasis>: <@com.value evidence.IdentifiedUncertainties/></para>
						<@com.emptyLine/>
					</#if>

					<#-- Link to relevant study record -->
					<#if evidence.LinkToRelevantStudyRecord?has_content>
						<#local studyLink = com.getStudyLink(evidence.LinkToRelevantStudyRecord)/>
						<para role="${indentRole}"><emphasis role="bold">Link to relevant study record</emphasis>: ${studyLink}</para>
					</#if>
					
					<#if evidence?has_next><@com.emptyLine/></#if>
				</#list>
			</para>
			<@com.emptyLine/>	
		</#if>
		
		<#-- Integrating evidence -->
		<#if summary.hasElement("AssessmentOfPotentialToxicity")>
			<#local integratingEvidence = summary.AssessmentOfPotentialToxicity.IntegratingEvidence>
		<#else>
			<#local integratingEvidence = summary.AssessmentOfPotentialInfectivityAndPathogenicityOfTheMicroorganismToHumans.IntegratingEvidence>
		</#if>
		
		<#local integratingEvidencePrinted = false>

		<#-- MIXTURE -->
		<#if integratingEvidence.hasElement("SufficientInformationToClassifyTheProduct") && integratingEvidence.SufficientInformationToClassifyTheProduct?has_content>
			<#if !integratingEvidencePrinted><para><emphasis role="bold">Integrating evidence</emphasis>:</para><@com.emptyLine/><#local integratingEvidencePrinted=true></#if>
			<para role="indent"><emphasis role="bold">Sufficient information to classify the product</emphasis>: <@com.value integratingEvidence.SufficientInformationToClassifyTheProduct/></para>
			<@com.emptyLine/>
		</#if>

		<#-- SUBSTANCE-->
		<#if integratingEvidence.hasElement("OpportunisticInfection") && integratingEvidence.OpportunisticInfection?has_content>
			<#if !integratingEvidencePrinted><para><emphasis role="bold">Integrating evidence</emphasis>:</para><@com.emptyLine/><#local integratingEvidencePrinted=true></#if>
			<para role="indent"><emphasis role="bold">Opportunistic infection</emphasis>: <@com.value integratingEvidence.OpportunisticInfection/></para>
			<@com.emptyLine/>
		</#if>

		<#if integratingEvidence.hasElement("AbsenceOfInfectivity") && integratingEvidence.AbsenceOfInfectivity?has_content>
			<#if !integratingEvidencePrinted><para><emphasis role="bold">Integrating evidence</emphasis>:</para><@com.emptyLine/><#local integratingEvidencePrinted=true></#if>
			<para role="indent"><emphasis role="bold">Absence of infectivity</emphasis>: <@com.value integratingEvidence.AbsenceOfInfectivity/></para>
			<@com.emptyLine/>
		</#if>

		<#if integratingEvidence.hasElement("AbsenceOfPathogenicity") && integratingEvidence.AbsenceOfPathogenicity?has_content>
			<#if !integratingEvidencePrinted><para><emphasis role="bold">Integrating evidence</emphasis>:</para><@com.emptyLine/><#local integratingEvidencePrinted=true></#if>
			<para role="indent"><emphasis role="bold">Absence of pathogenicity</emphasis>: <@com.value integratingEvidence.AbsenceOfPathogenicity/></para>
			<@com.emptyLine/>
		</#if>
	</#if>	
</#macro>