<!-- 4. ENVIRONMENTAL FATE PROPERTIES template file -->

<!----------------------------------------------------------------------------------
------------------------------------------------------------------------------------
study table that captures all related Env. Fate and Behaviour endpoint study records
-----------------------------------------------------------------------------------
----------------------------------------------------------------------------------->

<!-----------------------------------------------------------------------------
-------------------------------------------------------------------------------
_subject is root entity
docType is a hardcoded document type string
docSubType is a hardcoded document sub type string
columnHeaders is a list of strings that represent column headers
numberOfColumns is a calculation of the size.number of headers in columnHeaders
-------------------------------------------------------------------------------
------------------------------------------------------------------------------->

<#macro studyTable _subject docType docSubType columnHeaders numberOfColumns columnWidths>

<!-- docType and docSubType dynamically fetched when getting section documents for root entity -->
<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "${docType}", "${docSubType}") />

<!-- get the table of contents node name for the relevant document -->
<#assign tocNodeTitle = com.tableOfContentsNodeTitle("${docType}", "${docSubType}")/>

	<#-- Populate resultStudyList, dataWaivingStudyList, testingProposalStudyList -->
	<@populateResultAndDataWaivingAndTestingProposalStudyLists studyList />
			
	<!-- Study results -->
	<#if resultStudyList?has_content>

		The studies on ${tocNodeTitle} are summarised in the following table:
		
		<@com.emptyLine/>
		<table border="1">
		<!-- Study title taken from related ToC node -->
		<title>Studies on ${tocNodeTitle}</title>
		<#-----------------------------------------------------------------------------------------
		-------------------------------------------------------------------------------------------
		Iterate column widths and with *index, create the relevant number of column widths
		*Note that the user should ensure the number of col. widths correspond to number of headers
		-------------------------------------------------------------------------------------------
		------------------------------------------------------------------------------------------>
		<#list columnWidths as width>
		<#assign columnIndexWidth = width?index>
			<col width="${columnWidths[columnIndexWidth]}">${width}</col>
		</#list>

			<tbody>				
				<#-----------------------------------------------------------------------------------------
				-------------------------------------------------------------------------------------------
				Iterate column headers
				*Note that the user should ensure the number of col. headers correspond to number of widths
				-------------------------------------------------------------------------------------------
				------------------------------------------------------------------------------------------>
				<tr>
				<#list columnHeaders as header>
					<#assign columnIndexHeader = header?index>
					<?dbfo bgcolor="#FBDDA6" ?><th><emphasis role="bold">${header}</emphasis></th>
				</#list>
				</tr>

			<#list resultStudyList as study>
				<tr>
					<#list 0..numberOfColumns-1 as columnNum>
						<td>
						<#if columnNum == 0><!-- CSR Column 1 *Method -->

							<#-- QSAR related information in materials and methods -->
							<@studyandsummaryCom.qsarModel study/>

							<!-- CSR BiodegradationInWaterScreeningTests | BiodegradationInWaterAndSedimentSimulationTests | BiodegradationInSoil | AdsorptionDesorption | BioaccumulationAquaticSediment -->
							<#if docSubType=="BiodegradationInWaterScreeningTests" || docSubType=="BiodegradationInWaterAndSedimentSimulationTests" || 
							docSubType=="BiodegradationInSoil" || docSubType=="AdsorptionDesorption" || docSubType=="BioaccumulationAquaticSediment">						
							<para>
								<@com.picklist study.AdministrativeData.Endpoint/>
							</para>
							</#if>

							<#-- CSR BiodegradationInWaterScreeningTests -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.InoculumOrTestSystem")>
								<para>
									<@com.picklist study.MaterialsAndMethods.StudyDesign.InoculumOrTestSystem/> (<@com.picklist study.MaterialsAndMethods.StudyDesign.OxygenConditions/>)
								</para>
							</#if>

							<#-- CSR AdsorptionDesorption -->
							<#if study.hasElement("MaterialsAndMethods.MethodType") && docSubType=="AdsorptionDesorption">
								<para>
									<@com.picklist study.MaterialsAndMethods.MethodType/>
								</para>
							</#if>							

							<!-- CSR Phototransformation -->
							<#if study.hasElement("MaterialsAndMethods.StudyType")>
								<para>
									Study type: <@com.picklist study.MaterialsAndMethods.StudyType/>
								</para>
							</#if>

							<!-- CSR Hydrolysis | PhototransformationInAir | Phototransformation | PhotoTransformationInSoil | BiodegradationInWaterScreeningTests | BiodegradationInWaterAndSedimentSimulationTests | BiodegradationInSoil | AdsorptionDesorption | BioaccumulationAquaticSediment | BioaccumulationTerrestrial -->
							<#if study.hasElement("MaterialsAndMethods.Guideline")>
								<para>
									<@studyandsummaryCom.guidelineList study.MaterialsAndMethods.Guideline/>
								</para>
							</#if>

							<!-- CSR Hydrolysis | PhototransformationInAir | Phototransformation | PhotoTransformationInSoil | BiodegradationInWaterScreeningTests | BiodegradationInWaterAndSedimentSimulationTests | BiodegradationInSoil | AdsorptionDesorption | HenrysLawConstant | BioaccumulationAquaticSediment | BioaccumulationTerrestrial -->
							<#if study.hasElement("MaterialsAndMethods.MethodNoGuideline")>
								<para>
									<@com.text study.MaterialsAndMethods.MethodNoGuideline/>
								</para>
							</#if>
							
							<!-- CSR Hydrolysis | PhototransformationInAir -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.EstimationMethodIfUsed")>
								<para>
									<@com.text study.MaterialsAndMethods.StudyDesign.EstimationMethodIfUsed/>
								</para>
							</#if>

							<!-- CSR Phototransformation | PhotoTransformationInSoil -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.ComputationalMethods")>
								<para>
									<@com.text study.MaterialsAndMethods.StudyDesign.ComputationalMethods/>
								</para>
							</#if>

							<!-- CSR PhototransformationInAir | Phototransformation | PhotoTransformationInSoil -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.LightSource")>
								<para>
									Light source: <@com.picklist study.MaterialsAndMethods.StudyDesign.LightSource/>
								</para>
							</#if>
							
							<!-- CSR PhototransformationInAir | Phototransformation | PhotoTransformationInSoil -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.LightSpectrumWavelengthInNm")>
								<para>
									Light spectrum: <@com.range study.MaterialsAndMethods.StudyDesign.LightSpectrumWavelengthInNm/>
								</para>
							</#if>
							
							<!-- CSR PhototransformationInAir | Phototransformation | PhotoTransformationInSoil -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.RelativeLightIntensity")>
								<para>
									Rel. light intensity: <@com.range study.MaterialsAndMethods.StudyDesign.RelativeLightIntensity/>
								</para>
							</#if>

							<!-- CSR Phototransformation -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.SensitiserForIndirectPhotolysis")>
								<para>Sensitiser:</para>
								<@sensitiserList study.MaterialsAndMethods.StudyDesign.SensitiserForIndirectPhotolysis/> 
							</#if>

							<!-- CSR BioaccumulationAquaticSediment | BioaccumulationTerrestrial -->
							<#if study.hasElement("MaterialsAndMethods.TestOrganisms.TestOrganismsSpecies")>
								<para>
									<@com.picklist study.MaterialsAndMethods.TestOrganisms.TestOrganismsSpecies/>
								</para>
							</#if>

							<!-- CSR BioaccumulationAquaticSediment -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.RouteOfExposure")>
								<para>
									<@com.picklist study.MaterialsAndMethods.StudyDesign.RouteOfExposure/>
								</para>
							</#if>

							<!-- CSR BioaccumulationAquaticSediment -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.TestType")>
								<para>
									<@com.picklist study.MaterialsAndMethods.StudyDesign.TestType/>
								</para>
							</#if>

							<!-- CSR BioaccumulationAquaticSediment -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.WaterMediaType")>
								<para>
									Media type: <@com.picklist study.MaterialsAndMethods.StudyDesign.WaterMediaType/>
								</para>
							</#if>

							<!-- CSR BioaccumulationAquaticSediment -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.TotalExposureUptakeDuration")>
								<para>
									Total exposure / uptake duration: <@com.range study.MaterialsAndMethods.StudyDesign.TotalExposureUptakeDuration/>
								</para>
							</#if>

							<!-- CSR BioaccumulationAquaticSediment -->
							<#if study.hasElement("MaterialsAndMethods.StudyDesign.TotalDepurationDuration")>
								<para>
									Total depuration duration: <@com.range study.MaterialsAndMethods.StudyDesign.TotalDepurationDuration/>
								</para>
							</#if>

							<!-- CSR BioaccumulationAquaticSediment -->
							<#if study.hasElement("MaterialsAndMethods.TestConditions.DetailsOnEstimationOfBioconcentration")>
								<para>
									Details on estimation of bioconcentration: <@com.text study.MaterialsAndMethods.TestConditions.DetailsOnEstimationOfBioconcentration/>
								</para>
							</#if>

                        <#elseif columnNum == 1><!-- CSR Column 1 *Results -->

							<#-- QSAR based results -->
							<@studyandsummaryCom.qsarResultsAndDiscussion study />

							<!-- CSR Hydrolysis -->
							<#if docSubType=="Hydrolysis">
								<para>Half-life (DT50):</para>
								<@hydrolysisHalfLifeList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.DTParentCompound)/>									
								
								<para>Recovery (in %):</para>
								<@recoveryList study.ResultsAndDiscussion.MaterialMassBalance/>
							</#if>
	
							<!-- CSR PhototransformationInAir | Phototransformation -->
							<#if study.hasElement("ResultsAndDiscussion.SpectrumOfSubstance")>
								<para>Spectrum of substance:</para>
								<@spectrumOfSubstanceList study.ResultsAndDiscussion.SpectrumOfSubstance/>
							</#if>

							<!-- CSR PhototransformationInAir | Phototransformation -->
							<#if study.hasElement("ResultsAndDiscussion.DissipationParentCompound")>	
								<para>Half-life (DT50):</para>
								<@phototransformationHalfLifeList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.DissipationParentCompound)/>
							</#if>							

							<!-- CSR PhotoTransformationInSoil | Phototransformation | PhototransformationInAir -->
							<#if study.hasElement("ResultsAndDiscussion.Degradation") && docSubType=="PhotoTransformationInSoil" || docSubType=="Phototransformation" || docSubType=="PhototransformationInAir">	
								<para>% Degradation:</para>
								<@degradationList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.Degradation)/>
							</#if>

							<!-- CSR PhototransformationInAir -->
							<#if study.hasElement("ResultsAndDiscussion.DegradationRateConstant")>	
								<para>Degradation rate constant:</para>
								<@degradationRateConstantList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.DegradationRateConstant)/>
							</#if>

							<!-- CSR PhotoTransformationInSoil | Phototransformation | PhototransformationInAir -->
							<#if study.hasElement("ResultsAndDiscussion.QuantumYield")>	
								<para>Quantum yield: <@com.number study.ResultsAndDiscussion.QuantumYield/></para>
							</#if>

							<!-- CSR Phototransformation -->
							<#if docSubType=="Phototransformation">
							<para>Rate constant: <@com.range study.ResultsAndDiscussion.RateConstant/></para>
							</#if>
							
							<!-- CSR BiodegradationInWaterScreeningTests -->
							<#if docSubType=="BiodegradationInWaterScreeningTests">
							<para>
								<@com.picklist study.ApplicantSummaryAndConclusion.InterpretationOfResults/>
							</para>
							</#if>

							<!-- CSR BiodegradationInWaterAndSedimentSimulationTests | BiodegradationInSoil -->
							<#if docSubType=="BiodegradationInWaterAndSedimentSimulationTests" || docSubType=="BiodegradationInSoil" && study.hasElement("ResultsAndDiscussion.DTParentCompound")>
								<para>Disappearance time (DT) of parent compound:</para>
								<@disappearanceTimeList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.DTParentCompound)/>
							</#if>

							<!-- CSR PhototransformationInAir | Phototransformation | PhotoTransformationInSoil | BiodegradationInWaterScreeningTests | BiodegradationInWaterAndSedimentSimulationTests | BiodegradationInSoil -->
							<#if study.hasElement("ResultsAndDiscussion.Degradation") && docSubType!="PhotoTransformationInSoil" && docSubType!="Phototransformation" && docSubType!="PhototransformationInAir">
								<para>% Degradation of test substance:</para>
								<para><@degradationOfTestSubstanceList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.Degradation)/></para>
							</#if>
							
							<!-- CSR BiodegradationInWaterAndSedimentSimulationTests -->
							<#if study.hasElement("ResultsAndDiscussion.MineralizationRateInCO2")>
								<para>Mineralization rate: <@com.quantity study.ResultsAndDiscussion.MineralizationRateInCO2/></para>
							</#if>
							
							<!-- CSR Hydrolysis | PhototransformationInAir | Phototransformation | PhotoTransformationInSoil | BiodegradationInWaterAndSedimentSimulationTests | BiodegradationInSoil -->
							<#if study.hasElement("ResultsAndDiscussion.TransformationProducts")>
								<para>Transformation products: <@com.picklist study.ResultsAndDiscussion.TransformationProducts/></para>
							</#if>

							<!-- CSR BiodegradationInWaterAndSedimentSimulationTests | BiodegradationInSoil -->
							<#if study.hasElement("ResultsAndDiscussion.TransformationProductsDetails")>
								<#--  <@transformationProductList study.ResultsAndDiscussion.IdentityTransformation/>  -->
								<#-- this path does not exist anymore, instead:-->
								<@transformationProductsDetailsList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.TransformationProductsDetails)/>
							</#if>

							<!-- CSR BiodegradationInSoil -->
							<#if study.hasElement("ResultsAndDiscussion.EvaporationOfParentCompound")>	
								<para>Evaporation of parent compound: <@com.picklist study.ResultsAndDiscussion.EvaporationOfParentCompound/></para>
							</#if>

							<!-- CSR BiodegradationInSoil -->
							<#if study.hasElement("ResultsAndDiscussion.VolatileMetabolites")>	
								<para>Volatile metabolites: <@com.picklist study.ResultsAndDiscussion.VolatileMetabolites/></para>
							</#if>

							<!-- CSR BiodegradationInSoil -->
							<#if study.hasElement("ResultsAndDiscussion.Residues")>	
								<para>Residues: <@com.picklist study.ResultsAndDiscussion.Residues/></para>
							</#if>

							<!-- CSR AdsorptionDesorption -->
							<#if docSubType=="AdsorptionDesorption">
								<para>Adsorption coefficient:</para>
								<@adsorptionCoefficientList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.AdsorptionCoefficient)/>
								
								<para>Partition coefficients:</para>
								<@partitionCoefficientList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.AdsorptionOther)/>
								
								<para>Mass balance (in %) at end of adsorption phase:</para>
								<@massBalanceAdsorptiontList study.ResultsAndDiscussion.ResultsBatchEquilibriumOrOtherMethod.MassBalanceAtEndOfAdsorptionPhase/>
								
								<para>Mass balance (in %) at end of desorption phase:</para>
								<@massBalanceDesorptiontList study.ResultsAndDiscussion.ResultsBatchEquilibriumOrOtherMethod.MassBalanceAtEndOfDesorptionPhase/>

								<para>
								Transformation products: <@com.picklist study.ResultsAndDiscussion.ResultsBatchEquilibriumOrOtherMethod.TransformationProducts/>
								</para>
							</#if>

							<!-- CSR HenrysLawConstant -->
							<#if docSubType=="HenrysLawConstant">
								<para>Henry's Law constant H:</para>
								<@henrysLawConstantList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.HenrysLawConstantH)/>
							</#if>

							<!-- CSR DistributionModelling -->
							<#if docSubType=="DistributionModelling">
							<para>Percent distribution in media:</para>
								<para>Air (%): <@com.number study.ResultsAndDiscussion.PercentDistributionInMedia.AirPercentage/></para>
								<para>Water (%): <@com.number study.ResultsAndDiscussion.PercentDistributionInMedia.WaterPercentage/></para>
								<para>Soil (%): <@com.number study.ResultsAndDiscussion.PercentDistributionInMedia.SoilPercentage/></para>
								<para>Sediment (%): <@com.number study.ResultsAndDiscussion.PercentDistributionInMedia.SedimentPercentage/></para>
								<para>Susp. sediment (%): <@com.number study.ResultsAndDiscussion.PercentDistributionInMedia.SuspSedimentPercentage/></para>
								<para>Biota (%): <@com.number study.ResultsAndDiscussion.PercentDistributionInMedia.BiotaPercentage/></para>
								<para>Aerosol (%): <@com.number study.ResultsAndDiscussion.PercentDistributionInMedia.AerosolPercentage/></para>
								<para>Other distribution results: <@com.text study.ResultsAndDiscussion.PercentDistributionInMedia.OtherDistributionResults/></para>
							</#if>

							<!-- CSR BioaccumulationAquaticSediment | BioaccumulationTerrestrial -->
							<#if docSubType=="BioaccumulationAquaticSediment" || docSubType=="BioaccumulationTerrestrial">
							<para>Bioaccumulation factor:</para>
								<@bioaccumulationFactorList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.BioaccumulationFactor)/>
								
								<para>Elimination:</para>
								<@depurationList studyandsummaryCom.orderByKeyResult(study.ResultsAndDiscussion.Depuration)/>
								
								<para>Lipid content:</para>
								<@lipidContentList study.ResultsAndDiscussion.LipidContent/>
								
								<para>Transformation products: <@com.text study.ResultsAndDiscussion.Metabolites/></para>
							</#if>

                        <#elseif columnNum == 2><!-- CSR Column 1 *Remarks -->
                        	<@studyandsummaryCom.studyRemarksColumn study/>

                        </#if>
						</td>
					</#list>
				</tr>
				<@studyandsummaryCom.tableRowForJustificationForTypeOfInformation study/>
			</#list>
			</tbody>
		</table>

		<#elseif !(dataWaivingStudyList?has_content || testingProposalStudyList?has_content)>
			No relevant information available.
		</#if>

		<#if dataWaivingStudyList?has_content || testingProposalStudyList?has_content>
	
			<#if csrRelevant??>
				<!-- Data waiving -->
				<#if dataWaivingStudyList?has_content>
				<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Data waiving</emphasis></para>
				<@studyandsummaryCom.dataWaiving dataWaivingStudyList "${tocNodeTitle}" false/>
				</#if>

				<!-- Testing proposal -->
				<#if testingProposalStudyList?has_content>
				<para><@com.emptyLine/><emphasis role="HEAD-WoutNo">Testing proposal</emphasis></para>
				<@studyandsummaryCom.testingProposal testingProposalStudyList "${tocNodeTitle}" false/>
				</#if>
			</#if>
		
		</#if>

</#macro>

<!----------------------------------------------------------------------------------
------------------------------------------------------------------------------------
summary table that captures all related Env. Fate and Behaviour endpoint summaries
-----------------------------------------------------------------------------------
----------------------------------------------------------------------------------->

<!---------------------------------------------------------------------
-----------------------------------------------------------------------
_subject is root entity
docType is a hardcoded document type string
docSubType is a hardcoded document sub type string
titleText is a hardcoded text that for some summaries is required
discussionText is a hardcoded text that offers an additional sub-title
-----------------------------------------------------------------------
---------------------------------------------------------------------->

<#macro summaryTable _subject docType docSubType titleText discussionText>
<#compress>

	<!-- docType and docSubType dynamically fetched when getting section documents for root entity -->
	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "${docType}", "${docSubType}") />
	<#if summaryList?has_content && docSubType!="PhotoTransformationInSoil">
		
		<!-- CSR EnvironmentalFateAndPathways | EnvironmentalFateAndPathways -->
        <#if docSubType="EnvironmentalFateAndPathways" || docSubType="EnvironmentalFateAndPathways">
		<!-- Add hardcoded sub-title text from user defined macro *titleText -->
        <para><emphasis role="underline"><emphasis role="bold">${titleText}</emphasis></emphasis></para>
        </#if>

		<!-- Only print name of doc if more than one Endpoint Summary -->
		<#assign printSummaryName = summaryList?size gt 1 />

		<#list summaryList as summary>

		<!-- Check if continue to iterate Summary document if KeyInformation is entered -->
		<#assign summaryValue = checkSummaryInfo(summary)/>

			<#if summaryValue?has_content>

				<!-- Add hardcoded Discussion text from user defined macro *discussionText -->
				<@CSAValueText summary "${discussionText}" "The following information is taken into account for any hazard / risk / persistency assessment:" />

				<#if summary?has_content>
				
					<#-- print the key information, summary name if applicable, and assessment entity -->
					<@studyandsummaryCom.endpointSummary summary "" "${docSubType}" printSummaryName/>

					<#-- print the table of summary values where applicable -->
					<@studyandsummaryCom.fateCSAtable summary/>
					
					<!-- endpoint summary discussion -->
                    <#if summary.hasElement("Discussion")>
                        <@studyandsummaryCom.summaryAdditionalInformation summary/>
                    </#if>
				</#if>

			</#if>

		</#list>
	</#if>		
</#compress>
</#macro>

<!-- Secondary poisoning -->
<#macro ecotoxicologicalInformationSecondaryPoisoning _subject>
<#compress>	
	
	<#assign summaryList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "ENDPOINT_SUMMARY", "EcotoxicologicalInformation") />
	
	<#if !summaryList?has_content>
		No relevant information available.
		<@com.emptyLine/>
	<#else/>
	
		<!-- TODO: this probably will need to be improved in case there are AEs -->
		<#assign firsSummary = summaryList[0] />
		
		<#if isNoBioaccumulationPotential(firsSummary)>
			<para>Based on the available information, there is no indication of a bioaccumulation potential and, hence, secondary poisoning is not considered relevant (see CSR chapter 7.5 "PNEC derivation and other hazard conclusions)").</para>
		<#elseif isPnecOral(firsSummary)>
			<para>
				<#if firsSummary.HazardForPredators.SecondaryPoisoning.HazAssessConclVal?has_content>
					The hazard assessment conclusion for secondary poisoning (PNECoral) is <@com.quantity firsSummary.HazardForPredators.SecondaryPoisoning.HazAssessConclVal/> (see CSR chapter 7.5 "PNEC derivation and other hazard conclusions").
				</#if>
			</para>
			<para><emphasis role="bold">Interpretation of the available data with regard to the potential to bio-accumulate in the food chain:</emphasis></para>
			<para>&gt;&gt;&gt;NOTE (please delete this instruction): As appropriate enter relevant information manually.&lt;&lt;&lt;</para>
		<#else>
			<para>Based on the available information the bioaccumulation potential cannot be judged (see CSR chapter 7.5 "PNEC derivation and other hazard conclusions").</para>
		</#if>
	</#if>
</#compress>
</#macro>

<!-- Macros and functions -->
<#macro hydrolysisHalfLifeList halfLifeRepeatableBlock>
<#compress>
	<#if halfLifeRepeatableBlock?has_content>
		<#list halfLifeRepeatableBlock as blockItem>

		<@iuclid.label for=blockItem.Ph var="phLabel"/> 
		<@iuclid.label for=blockItem.Type var="typeLabel"/> 
		<@iuclid.label for=blockItem.HydrolysisRateConstant var="rateConstantLabel"/> 
		
			<para role="indent">
			
				<#if blockItem.Parameter?has_content>
					<@com.range blockItem.Parameter/> 
				</#if>

				<#if blockItem.Ph?has_content>
					t1/2 (${phLabel}) <@com.number blockItem.Ph/>):
				</#if>				

				<#if pppRelevant??>
					<#if blockItem.StDev?has_content>
						[sd=<@com.number blockItem.StDev/>]
					</#if>
				</#if>
				
				<#if blockItem.Temp?has_content>
					at <@com.range blockItem.Temp/>;
				</#if>	
				
				<#if blockItem.HydrolysisRateConstant?has_content>
					${rateConstantLabel}: <@com.range blockItem.HydrolysisRateConstant/>;
				</#if>	
				
				<#if blockItem.Type?has_content>					
					${typeLabel}: <@com.picklist blockItem.Type/>;
				</#if>

				<#if blockItem.hasElement("ChiSquare2Error") && blockItem.ChiSquare2Error?has_content>					
					Chi-square Error: <@com.value blockItem.ChiSquare2Error/>;
				</#if>

				<#if blockItem.hasElement("pvalue") && blockItem.pvalue?has_content>					
					p-value: <@com.value blockItem.pvalue/>;
				</#if>

				<#if blockItem.hasElement("KineticParameters") && blockItem.KineticParameters?has_content>					
					Kinetic Parameters: <@com.value blockItem.KineticParameters/>;
				</#if>

				<#if blockItem.RemarksOnResults?has_content>
					(<@com.picklist blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro recoveryList recoveryRepeatableBlock>
<#compress>
	<#if recoveryRepeatableBlock?has_content>
		<#list recoveryRepeatableBlock as blockItem>

		<@iuclid.label for=blockItem.Ph var="phLabel"/> 

			<para role="indent">
				<#if blockItem.Ph?has_content>
					${phLabel} <@com.number blockItem.Ph/>:
				</#if>
				
				<#if blockItem.Recovery?has_content>
					<@com.range blockItem.Recovery/> 
				</#if>

				<#if blockItem.hasElement("RecoveryOfParentSubstance") && blockItem.RecoveryOfParentSubstance?has_content>
					(<@com.range blockItem.RecoveryOfParentSubstance/> of parent)
				</#if>

				<#if pppRelevant??>
					<#if blockItem.StDev?has_content>
						[sd=<@com.number blockItem.StDev/>]
					</#if>
				</#if>
				
				<#if blockItem.Temp?has_content>
					at <@com.quantity blockItem.Temp/> 
				</#if>
				
				<#if blockItem.SamplingTime?has_content>
					after <@com.range blockItem.SamplingTime/>
				</#if>

				<#if pppRelevant??>
					<#if blockItem.RemarksOnResults?has_content>
						(<@com.picklist blockItem.RemarksOnResults/>)
					</#if>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro materialMassBalanceList materialMassBalanceRepeatableBlock>
<#compress>
	<#if materialMassBalanceRepeatableBlock?has_content>
		<#list materialMassBalanceRepeatableBlock as blockItem>
			<@iuclid.label for=blockItem.SamplingTime var="samplingTime"/>
			<@iuclid.label for=blockItem.SamplingConditions var="samplingConditions"/>
			<@iuclid.label for=blockItem.TotalExtractable var="totalExtractable"/>
			<@iuclid.label for=blockItem.CO2 var="co2"/>
			<@iuclid.label for=blockItem.OtherVolatiles var="otherVolatiles"/>
			<@iuclid.label for=blockItem.Recovery var="recovery"/>
			<@iuclid.label for=blockItem.StDev var="stDev"/>

			<para role="indent">
				<#if blockItem.SamplingTime?has_content>
					${samplingTime}: <@com.value blockItem.SamplingTime/>;
				</#if>

				<#if blockItem.SamplingConditions?has_content>
					${samplingConditions}: <@com.value blockItem.SamplingConditions/>;
				</#if>

				<#if blockItem.TotalExtractable?has_content>
					${totalExtractable}: <@com.value blockItem.TotalExtractable/>;
				</#if>

				<#if blockItem.CO2?has_content>
					${co2}: <@com.value blockItem.CO2/>;
				</#if>

				<#if blockItem.OtherVolatiles?has_content>
					${otherVolatiles}: <@com.value blockItem.OtherVolatiles/>;
				</#if>
				
				<#if blockItem.Recovery?has_content>
					${recovery}: <@com.value blockItem.Recovery/> 
				</#if>

				<#if pppRelevant??>
					<#if blockItem.StDev?has_content>
						[${stDev}=<@com.value blockItem.StDev/>]
					</#if>
				</#if>
				
				<#if pppRelevant??>
					<#if blockItem.RemarksOnResults?has_content>
						(<@com.value blockItem.RemarksOnResults/>)
					</#if>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro spectrumOfSubstanceList spectrumRepeatableBlock>
<#compress>
	<#if spectrumRepeatableBlock?has_content>
		<#list spectrumRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.Parameter?has_content>
					<@com.picklist blockItem.Parameter/>: 
				</#if>	
					
				<#if blockItem.Value?has_content>
					<@com.quantity blockItem.Value/>
				</#if>
					
				<#if blockItem.hasElement("RemarksOnResults")>
					(<@com.picklist blockItem.RemarksOnResults/>)
				<#else/>
					(<@com.text blockItem.Remarks/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro phototransformationHalfLifeList halfLifeRepeatableBlock>
<#compress>
	<#if halfLifeRepeatableBlock?has_content>
		<#list halfLifeRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.hasElement("HalfLife")>
					<@com.range blockItem.HalfLife/>
				<#else>
					<@com.range blockItem.DT50/>
				</#if>
				<#if blockItem.TestCondition?has_content>
					(<@com.text blockItem.TestCondition/>)
				</#if>

				<#if pppRelevant??>
					<#if blockItem.RemarksOnResults?has_content>
						(<@com.picklist blockItem.RemarksOnResults/>)
					</#if>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro degradationList degradationRepeatableBlock>
<#compress>
	<#if degradationRepeatableBlock?has_content>
		<#list degradationRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.hasElement("DegradationPercent")>
					<@com.range blockItem.DegradationPercent/>
				<#else>
					<@com.range blockItem.Degr/>
				</#if>

				<#if pppRelevant??>
					%
					<#if blockItem.StDev?has_content>
						[<@com.number blockItem.StDev/>]
					</#if>
				</#if>

				after
				<#if blockItem.hasElement("TimePoint")>
					<@com.quantity blockItem.TimePoint/>
				<#else>
					<@com.quantity blockItem.SamplingTime/>
				</#if>
				<#if blockItem.TestCondition?has_content>
					(<@com.text blockItem.TestCondition/>)
				</#if>

				<#if pppRelevant??>
					<#if blockItem.RemarksOnResults?has_content>
						(<@com.picklist blockItem.RemarksOnResults/>)
					</#if>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro sensitiserList sensitiserRepeatableBlock>
<#compress>
	<#if sensitiserRepeatableBlock?has_content>
		<#list sensitiserRepeatableBlock as blockItem>
			<para role="indent">
				<@com.picklist blockItem.TypeOfSensitiser/> 
				<#if blockItem.ConcentrationOfSensitiser?has_content>
					(<@com.range blockItem.ConcentrationOfSensitiser/>)
				</#if>

				<#if pppRelevant??>
					<#if blockItem.DetailsOnSensitiser?has_content>
						- <@com.text blockItem.DetailsOnSensitiser/>
					</#if>
				</#if>

			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro degradationRateConstantList degradationRateRepeatableBlock>
<#compress>
	<#if degradationRateRepeatableBlock?has_content>
		<#list degradationRateRepeatableBlock as blockItem>
			<para role="indent">
				<@com.range blockItem.RateConstant/> 
				<#if blockItem.ReactionWith?has_content>
					for reaction with <@com.picklist blockItem.ReactionWith/>
				</#if>
				<#if pppRelevant?? && blockItem.RemarksOnResults?has_content>
					(<@com.picklist blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro degradationOfTestSubstanceList degradationRepeatableBlock>
<#compress>
	<#if degradationRepeatableBlock?has_content>
		<#list degradationRepeatableBlock as blockItem>
			<para role="indent">
				<#if pppRelevant??>
					<#if blockItem.hasElement("SoilNo") && blockItem.SoilNo?has_content>
						<@com.picklist blockItem.SoilNo/>:
					</#if>

					<#if blockItem.Parameter?has_content && blockItem.hasElement("Parameter")>
						<@com.picklist blockItem.Parameter/> =
					</#if>
				</#if>

				<@com.range blockItem.Degr/>

				<#if pppRelevant??>
					<#if blockItem.Degr?has_content>
						%
					</#if>

					<#if blockItem.StDev?has_content>
						[sd=<@com.number blockItem.StDev/>]
					</#if>

					<#if blockItem.hasElement("ParentProduct") && blockItem.ParentProduct?has_content>
						for <@com.picklist blockItem.ParentProduct/>
						<#if blockItem.NameOrCodeForProduct?has_content>
							<#local product=iuclid.getDocumentForKey(blockItem.NameOrCodeForProduct)/>
							<@com.text product.ReferenceSubstanceName/>
						</#if>
					</#if>
				</#if>
				
				<#if blockItem.SamplingTime?has_content>
					after
					<@com.quantity blockItem.SamplingTime/>
				</#if>

				<#if !pppRelevant??>
					<#if blockItem.Parameter?has_content>
						(<@com.picklist blockItem.Parameter/>)
					</#if>
				</#if>

				<#if blockItem.RemarksOnResults?has_content>
					(<@com.picklist blockItem.RemarksOnResults/>)
				</#if>

				<#if !(pppRelevant??) && blockItem.hasElement("SoilNo") && blockItem.SoilNo?has_content>
					(<@com.picklist blockItem.SoilNo/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro biodegradationHalfLifeList halfLifeRepeatableBlock><#-- DEPRECATED to be removed -->
<#compress>
	<#if halfLifeRepeatableBlock?has_content>
		<#list halfLifeRepeatableBlock as blockItem>
			<para role="indent">
			
				<@com.value blockItem.Parameter/>

				<#if pppRelevant??>
					<#if blockItem.StDev?has_content>
						[sd=<@com.picklist blockItem.StDev/>]
					</#if>

					<#if blockItem.Type?has_content>
						(<@com.picklist blockItem.Type/>)
					</#if>
				</#if>

				<#if blockItem.Compartment?has_content>
					in
					<@com.picklist blockItem.Compartment/>
				</#if>
				
				<#if blockItem.Temp?has_content>
					at
					<@com.quantity blockItem.Temp/>
				</#if>

				<#if pppRelevant??>
					<#if blockItem.RemarksOnResults?has_content>
						(<@com.picklist blockItem.RemarksOnResults/>)
					</#if>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro transformationProductList transformationProductBlock>
<#compress>
	<#if transformationProductBlock?has_content>
		<#list transformationProductBlock as blockItem>
			<#local referenceSubstance = iuclid.getDocumentForKey(blockItem.ReferenceSubstance) />
			<#if referenceSubstance?has_content>
				<para role="indent">
        
					<@com.value blockItem.No/> 

					<#if referenceSubstance.ReferenceSubstanceName?has_content>						
						<@com.referenceSubstanceName com.getReferenceSubstanceKey(blockItem.ReferenceSubstance) />						
					</#if>

					<#if blockItem.hasElement("ParentCompoundS") && blockItem.ParentCompoundS?has_content>
						<#local parents= []/>
						<#list blockItem.ParentCompoundS as parentLink>
							<#local comp = iuclid.getDocumentForKey(parentLink) />
							<#local parent><@com.value comp.ReferenceSubstanceName/></#local>
							<#local parents = parents + [parent]/>
						</#list>
						(parent: ${parents?join("; ")})
					</#if>

					<#if blockItem.hasElement("MaximumOccurrence") && blockItem.MaximumOccurrence?has_content>
						Maximum ocurrence: <@com.value blockItem.MaximumOccurrence/>
					</#if>

				</para>
			</#if>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro soilTypeList soilTypeBlock>
<#compress>
	<#if soilTypeBlock?has_content>
		<#list soilTypeBlock as blockItem>
			<para role="indent">
				<#if pppRelevant??>
					<#if blockItem.SoilNo?has_content>
						<@com.picklist blockItem.SoilNo/>:
					</#if>
				</#if>

				<@com.picklist blockItem.SoilType/>
				<#if !pppRelevant?? && blockItem.SoilNo?has_content>
					(<@com.picklist blockItem.SoilNo/>)
				</#if>

				<#if pppRelevant??>
					<#if blockItem.Clay?has_content>
						. Clay: <@com.range blockItem.Clay/>%
					</#if>
					<#if blockItem.Silt?has_content>
						. Silt: <@com.range blockItem.Silt/>%
					</#if>
					<#if blockItem.Sand?has_content>
						. Sand: <@com.range blockItem.Sand/>%
					</#if>
					<#if blockItem.OrgC?has_content>
						. Org.C: <@com.range blockItem.OrgC/>%
					</#if>
					<#if blockItem.Ph?has_content>
						. pH: <@com.range blockItem.Ph/>%
					</#if>
					<#if blockItem.CEC?has_content>
						. CEC: <@com.range blockItem.CEC/>%
					</#if>
					<#if blockItem.BulkDensityGCm?has_content>
						. Bulk density: <@com.range blockItem.BulkDensityGCm/>g/cm3
					</#if>
					<#if blockItem.MoistureContent?has_content>
						. Moisture: <@com.range blockItem.MoistureContent/>%
					</#if>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro disappearanceTimeList halfLifeRepeatableBlock> <#-- before called biodegradationInSoilHalfLifeList, covers also the old biodegradationHalfLifeList-->
<#compress>
	<#if halfLifeRepeatableBlock?has_content>
		<#list halfLifeRepeatableBlock as blockItem>
			<para role="indent">

				
				<#if pppRelevant??><#-- for PPP only: print soil number first -->
					<#if blockItem.hasElement("SoilNo") && blockItem.SoilNo?has_content>
						Soil <@com.value blockItem.SoilNo/>:
					</#if>
				</#if>

				<#if blockItem.Parameter?has_content>
					<@com.value blockItem.Parameter/><#if blockItem.TypeOfValue?has_content> (<@com.value blockItem.TypeOfValue/>)</#if><#if blockItem.Value?has_content>: <@com.value blockItem.Value/></#if>
				</#if>

				<#if pppRelevant??><#-- for PPP only: standard devaiation -->
					<#if blockItem.StDev?has_content>
						[sd=<@com.value blockItem.StDev/>]
					</#if>
				</#if>

				<#if blockItem.hasElement("Compartment") && blockItem.Compartment?has_content>
					in <@com.picklist blockItem.Compartment/>
				</#if>

				<#if blockItem.Temp?has_content>
					at <@com.value blockItem.Temp/>
				</#if>

				<#-- for PPP only: additional fields -->
				<#if pppRelevant??>
					<#if blockItem.hasElement("Type") && blockItem.Type?has_content>
						(<@com.value blockItem.Type/>)
					<#elseif blockItem.hasElement("TypeOfKineticsAndMethodOfCalculation") && blockItem.TypeOfKineticsAndMethodOfCalculation?has_content>
						(<@com.value blockItem.TypeOfKineticsAndMethodOfCalculation/>)
					</#if>

					<#-- NOTE: other additional parameters are missing: ChiSquare2Error, CI95, KineticParameters-->

				<#-- for other than PPP: print soil number in parenthesis -->
				<#else>

					<#if blockItem.hasElement("SoilNo") && blockItem.SoilNo?has_content>
						(<@com.value blockItem.SoilNo/>)
					</#if>
				</#if>

				<#if blockItem.hasElement("ChiSquare2Error") && blockItem.ChiSquare2Error?has_content>					
					Chi-square Error: <@com.value blockItem.ChiSquare2Error/>;
				</#if>

				<#if blockItem.hasElement("pvalue") && blockItem.pvalue?has_content>					
					p-value: <@com.value blockItem.pvalue/>;
				</#if>

				<#if blockItem.hasElement("KineticParameters") && blockItem.KineticParameters?has_content>					
					Kinetic Parameters: <@com.value blockItem.KineticParameters/>;
				</#if>

				<#if blockItem.hasElement("RemarksOnResults") && blockItem.RemarksOnResults?has_content>
					(<@com.value blockItem.RemarksOnResults/>)
				<#elseif blockItem.hasElement("RemarksOnResult") && blockItem.RemarksOnResult?has_content>
					(<@com.value blockItem.RemarksOnResult/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro adsorptionCoefficientList adsorptionCoefficientRepeatableBlock>
<#compress>
	<#if adsorptionCoefficientRepeatableBlock?has_content>
		<#list adsorptionCoefficientRepeatableBlock as blockItem>
			<para role="indent">

				<#if pppRelevant??>
					<#if blockItem.SampleNo?has_content>
						<@com.picklist blockItem.SampleNo/>:
					</#if>
				</#if>

				<#if blockItem.Type?has_content>
					<@com.picklist blockItem.Type/>: 
				</#if>
				
				<#if blockItem.Value?has_content>
					<@com.range blockItem.Value/>
				</#if>
				
				<#if blockItem.Temp?has_content>
					at <@com.quantity blockItem.Temp/>
				</#if>

				<#if pppRelevant??>
					<#if blockItem.Ph?has_content>
						at pH=<@com.number blockItem.Ph/>
					</#if>

					<#if blockItem.Matrix?has_content>
						(Matrix: <@com.text blockItem.Matrix/>)
					</#if>
				</#if>
					
				<#if blockItem.PercentageOfOrganicCarbon?has_content>
					(Org. C (%): <@com.range blockItem.PercentageOfOrganicCarbon/>)
				</#if>
				
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.picklist blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro partitionCoefficientList partitionCoefficientRepeatableBlock>
<#compress>
	<#if partitionCoefficientRepeatableBlock?has_content>
		<#list partitionCoefficientRepeatableBlock as blockItem>
			<para role="indent">

				<#if pppRelevant??>
					<#if blockItem.SampleNo?has_content>
						<@com.picklist blockItem.SampleNo/>
					</#if>

					<#if blockItem.PhaseSystem?has_content>
						(<@com.picklist blockItem.PhaseSystem/>)
					</#if>

					<#if blockItem.SampleNo?has_content>:</#if>
				</#if>

				<#if blockItem.Type?has_content>
					<@com.picklist blockItem.Type/>: 
				</#if>
					
				<#if blockItem.Value?has_content>
					<@com.range blockItem.Value/> 
				</#if>	
					
				<#if blockItem.Temp?has_content>
					at <@com.quantity blockItem.Temp/>
				</#if>

				<#if pppRelevant??>
					<#if blockItem.Ph?has_content>
						at pH=<@com.number blockItem.Ph/>
					</#if>

					<#if blockItem.Matrix?has_content>
						(Matrix: <@com.text blockItem.Matrix/>)
					</#if>

					<#if blockItem.OrgCarbon?has_content>
						(Org. C (%): <@com.range blockItem.OrgCarbon/>)
					</#if>
				</#if>
					
				<#if blockItem.RemarksOnResults?has_content>					
					(<@com.picklist blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro massBalanceAdsorptiontList massBalanceAdsorptiontRepeatableBlock>
<#compress>
	<#if massBalanceAdsorptiontRepeatableBlock?has_content>
		<#list massBalanceAdsorptiontRepeatableBlock as blockItem>
			<para role="indent">

				<#if pppRelevant??>
					<#if blockItem.SampleNo?has_content>
						<@com.picklist blockItem.SampleNo/>:
					</#if>
				</#if>

				<#if blockItem.AdsorptionPercentage?has_content>
					<@com.range blockItem.AdsorptionPercentage/> 
				</#if>
				
				<#if blockItem.Duration?has_content>
					after <@com.quantity blockItem.Duration/>
				</#if>

				<#if !pppRelevant??>
					<#if blockItem.SampleNo?has_content>
						(<@com.picklist blockItem.SampleNo/>)
					</#if>
				<#else>
					<#if blockItem.RemarksOnResults?has_content>
						(<@com.picklist blockItem.RemarksOnResults/>)
					</#if>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro massBalanceDesorptiontList massBalanceDesorptiontRepeatableBlock>
<#compress>
	<#if massBalanceDesorptiontRepeatableBlock?has_content>
		<#list massBalanceDesorptiontRepeatableBlock as blockItem>
			<para role="indent">

				<#if pppRelevant??>
					<#if blockItem.SampleNo?has_content>
						<@com.picklist blockItem.SampleNo/>:
					</#if>
				</#if>

				<#if blockItem.DesorptionPercentage?has_content>
					<@com.range blockItem.DesorptionPercentage/> 
				</#if>
				
				<#if blockItem.Duration?has_content>
					after <@com.quantity blockItem.Duration/>
				</#if>

				<#if !pppRelevant??>
					<#if blockItem.SampleNo?has_content>
						(<@com.picklist blockItem.SampleNo/>)
					</#if>
				<#else>
					<#if blockItem.RemarksOnResults?has_content>
						(<@com.picklist blockItem.RemarksOnResults/>)
					</#if>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro henrysLawConstantList henrysLawConstantRepeatableBlock>
<#compress>
	<#if henrysLawConstantRepeatableBlock?has_content>
		<#list henrysLawConstantRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.H?has_content>
					<@com.range blockItem.H/>
				</#if>
				
				<#if blockItem.Temp?has_content>
					at <@com.quantity blockItem.Temp/>
				</#if>
				
				<#if blockItem.AtmPressure?has_content>
					and <@com.quantity blockItem.AtmPressure/>
				</#if>
				
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.picklist blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro bioaccumulationFactorList bioaccumulationFactorRepeatableBlock>
<#compress>
	<#if bioaccumulationFactorRepeatableBlock?has_content>
		<#list bioaccumulationFactorRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.Type?has_content>
					<@com.picklist blockItem.Type/>: 
				</#if>
				
				<#if blockItem.Value?has_content>
					<@com.range blockItem.Value/>
				</#if>
				
				<#if blockItem.Basis?has_content>
					(<@com.picklist blockItem.Basis/>)
				</#if>
				
				<#if blockItem.TimeOfPlateau?has_content>
					Time of plateau: <@com.quantity blockItem.TimeOfPlateau/>
				</#if>
				
				<#if blockItem.CalculationBasis?has_content>
					(<@com.picklist blockItem.CalculationBasis/>) 
				</#if>
				
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.picklist blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro depurationList depurationRepeatableBlock>
<#compress>
	<#if depurationRepeatableBlock?has_content>
		<#list depurationRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.Elimination?has_content>
					<@com.picklist blockItem.Elimination/>; 
				</#if>
				
				<#if blockItem.Endpoint?has_content>
					<@com.picklist blockItem.Endpoint/>: 
				</#if>
				
				<#if blockItem.DepurationTime?has_content>
					<@com.quantity blockItem.DepurationTime/>
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#macro lipidContentList lipidContentRepeatableBlock>
<#compress>
	<#if lipidContentRepeatableBlock?has_content>
		<#list lipidContentRepeatableBlock as blockItem>
			<para role="indent">
				<#if blockItem.LipidContent?has_content>
					<@com.range blockItem.LipidContent/> 
				</#if>
				
				<#if blockItem.TimePoint?has_content>
					(<@com.picklist blockItem.TimePoint/>)
				</#if>
				
				<#if blockItem.RemarksOnResults?has_content>
					(<@com.picklist blockItem.RemarksOnResults/>)
				</#if>
			</para>
		</#list>
  	</#if>
</#compress>
</#macro>

<#function isNoBioaccumulationPotential ecotoxicologicalInformationSummary>
	<#if !(ecotoxicologicalInformationSummary?has_content)>
		<#return false>
	</#if>
	<#return com.picklistValueMatchesPhrases(ecotoxicologicalInformationSummary.HazardForPredators.SecondaryPoisoning.HazAssessConcl, ["no potential for bioaccumulation", "no potential to cause toxic effects if accumulated (in higher organisms) via the food chain"]) />
</#function>

<#function isPnecOral ecotoxicologicalInformationSummary>
	<#if !(ecotoxicologicalInformationSummary?has_content)>
		<#return false>
	</#if>
	<#return com.picklistValueMatchesPhrases(ecotoxicologicalInformationSummary.HazardForPredators.SecondaryPoisoning.HazAssessConcl, ["PNEC oral"]) />
</#function>

<#function checkSummaryInfo summary>
	<#local valuesCSA = []/>
	
	<#if !(summary?has_content)>
		<#return [] />
	</#if>
	
	<#if summary.hasElement("KeyInformation")>
		<#local valuesCSA = valuesCSA + [summary]/>			
	</#if>		
	
	<#return valuesCSA />	
</#function>

<#macro CSAValueText summary discussion="" moreText="">
<#compress>
	<para><emphasis role="HEAD-WoutNo">
		<#assign docUrl=iuclid.webUrl.documentView(summary.documentKey) />
		<ulink url="${docUrl}">${discussion!}</ulink>
	</emphasis></para>
	<para><emphasis role="underline">${moreText}</emphasis></para>
</#compress>
</#macro>

<!-- Macros and functions -->
<#-- Macros to separate documents into three lists: 'study results', 'data waiving', 'testing proposal' -->

<#macro populateResultAndDataWaivingAndTestingProposalStudyLists studyList>
	<#assign resultStudyList = [] />
	<#assign dataWaivingStudyList = [] />
	<#assign testingProposalStudyList = [] />
	<#if studyList?has_content>
		<#list studyList as study>
			<#if isTestingProposalStudy(study)>
				<#assign testingProposalStudyList = testingProposalStudyList + [study] />
			<#elseif isDataWaivingStudy(study)>
				<#assign dataWaivingStudyList = dataWaivingStudyList + [study] />
			<#elseif isRelevantAdequacyOfStudy(study)>
				<#assign resultStudyList = resultStudyList + [study] />
			</#if>
		</#list>
	</#if>
	<#-- sort resultStudyList according to PurposeFlag -->
	<#assign resultStudyList = iuclid.sortByField(resultStudyList, "AdministrativeData.PurposeFlag", ["key study","supporting study","weight of evidence","(Q)SAR","disregarded due to major methodological deficiencies","other information"]) />
</#macro>

<#function isRelevantAdequacyOfStudy study>
	<#if !(study?has_content)>
		<#return false>
	</#if>
	<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
    <#return PurposeFlag?has_content && !com.picklistValueMatchesPhrases(PurposeFlag, ["other information"]) />
</#function>

<#function isDataWaivingStudy study>
	<#if !(study?has_content)>
		<#return false>
	</#if>
	<#local PurposeFlag = study.AdministrativeData.PurposeFlag />
	<#local DataWaiving = study.AdministrativeData.DataWaiving />
    <#return !(PurposeFlag?has_content) && DataWaiving?has_content />
</#function>

<#function isTestingProposalStudy study>
	<#if !(study?has_content)>
		<#return false>
	</#if>
    <#return com.picklistValueMatchesPhrases(study.AdministrativeData.StudyResultType, ["experimental study planned.*"]) />
</#function>

<#---------------------------PPP additions------------------------------------>
<#macro results_biodegradationInSoil study>
	<#compress>
		<#local res=study.ResultsAndDiscussion/>

		<#if res.MaterialMassBalance?has_content>
			<para>Material (mass) balance:</para>
			<para role="indent"><@massBalanceList studyandsummaryCom.orderByKeyResult(res.MaterialMassBalance)/></para>
		</#if>

		<#if res.MineralizationRateInCO2?has_content>
			<para>Mineralization rate (in CO2): <@com.value res.MineralizationRateInCO2/></para>
		</#if>

		<#if res.Degradation?has_content>
			<para>% Degradation of test substance:</para>
			<para role="indent"><@degradationOfTestSubstanceList studyandsummaryCom.orderByKeyResult(res.Degradation)/></para>
		</#if>

		<#if res.DTParentCompound?has_content>
			<para>Disappearance time (DT) of parent compound:</para>
			<para role="indent"><@disappearanceTimeList studyandsummaryCom.orderByKeyResult(res.DTParentCompound)/></para>
		</#if>

		<#if res.TransformationProducts?has_content || res.TransformationProductsDetails?has_content || res.TransfProductsDetails?has_content >
			<para>Transformation products: <@com.value res.TransformationProducts/></para>
			<para><@transformationProductsDetailsList studyandsummaryCom.orderByKeyResult(res.TransformationProductsDetails)/></para>
			<#if res.TransfProductsDetails?has_content>
				<para role="indent">Details: <@com.text res.TransfProductsDetails/></para>
			</#if>
		</#if>

		<#if res.EvaporationOfParentCompound?has_content>
			<para>Evaporation of parent compound: <@com.picklist res.EvaporationOfParentCompound/></para>
		</#if>

		<#if res.VolatileMetabolites?has_content>
			<para>Volatile metabolites: <@com.picklist res.VolatileMetabolites/></para>
		</#if>

		<#if res.Residues?has_content>
			<para>Residues: <@com.picklist res.Residues/></para>
		</#if>

		<#if res.DetailsOnResults?has_content>
			<para>Details:</para>
			<para role="indent"><@com.text res.DetailsOnResults/></para>
		</#if>

		<#if res.ResultsWithReferenceSubstance?has_content>
			<para>Results with reference substance: </para>
			<para role="indent"><@com.text res.ResultsWithReferenceSubstance/></para>
		</#if>

	</#compress>
</#macro>

<#macro results_fieldStudies study>
	<#compress>
	
	<#local res = study.ResultsAndDiscussion/>

	<#if res.HalfLifeOfParentCompound50DisappearanceTimeDT50?has_content>
		<para>Half-life of parent compound / 50% disappearance time (DT50):</para>
		<para role="indent"><@disappearanceTimeList studyandsummaryCom.orderByKeyResult(res.HalfLifeOfParentCompound50DisappearanceTimeDT50)/></para>
	</#if>

	<#if res.TransformationProductsDetails?has_content || res.TransfProductsDetails?has_content >
		<para>Transformation products:</para>
		<para><@transformationProductsDetailsList studyandsummaryCom.orderByKeyResult(res.TransformationProductsDetails)/></para>
		<#if res.TransfProductsDetails?has_content>
			<para role="indent">Details: <@com.text res.TransfProductsDetails/></para>
		</#if>
	</#if>

	</#compress>
</#macro>

<#macro results_biodegradationWaterSedimentSimulation study>
	<#compress>
		<#local res=study.ResultsAndDiscussion/>

		<#if res.TestPerformance?has_content>
			<para>Test performance:</para>
			<para role="indent"><@com.text res.TestPerformance/></para>
		</#if>

		<#if res.MaterialMassBalance?has_content>
			<para>Material mass balance:</para>
			<para role="indent"><@massBalanceList studyandsummaryCom.orderByKeyResult(res.MaterialMassBalance)/></para>
		</#if>

		<#if res.Degradation?has_content>
			<para>% Degradation:</para>
			<para role="indent"><@degradationOfTestSubstanceList studyandsummaryCom.orderByKeyResult(res.Degradation)/></para>
		</#if>

		<#if res.DTParentCompound?has_content>
			<para>Disappearance time (DT) of parent compound:</para>
			<para role="indent"><@disappearanceTimeList studyandsummaryCom.orderByKeyResult(res.DTParentCompound)/></para>
		</#if>

		<#if res.MineralizationRateInCO2?has_content>
			<para>Mineralization rate (in CO2): <@com.quantity study.ResultsAndDiscussion.MineralizationRateInCO2/></para>
		</#if>

		<#if res.TransformationProducts?has_content || res.TransformationProductsDetails?has_content || res.TransfProductsDetails?has_content >
			<para>Transformation products: <@com.value res.TransformationProducts/></para>
			<para><@transformationProductsDetailsList studyandsummaryCom.orderByKeyResult(res.TransformationProductsDetails)/></para>
			<#if res.TransfProductsDetails?has_content>
				<para role="indent">Details: <@com.text res.TransfProductsDetails/></para>
			</#if>
		</#if>

		<#if res.EvaporationOfParentCompound?has_content>
			<para>Evaporation of parent compound: <@com.picklist res.EvaporationOfParentCompound/></para>
		</#if>

		<#if res.VolatileMetabolites?has_content>
			<para>Volatile metabolites: <@com.picklist res.VolatileMetabolites/></para>
		</#if>

		<#if res.Residues?has_content>
			<para>Residues: <@com.picklist res.Residues/></para>
		</#if>

		<#if res.DetailsOnResults?has_content>
			<para>Details:</para>
			<para role="indent"><@com.text res.DetailsOnResults/></para>
		</#if>

		<#if res.ResultsWithReferenceSubstance?has_content>
			<para>Results with reference substance: </para>
			<para role="indent"><@com.text res.ResultsWithReferenceSubstance/></para>
		</#if>

	</#compress>
</#macro>

<#macro results_phototransformation study>
	<#compress>
		<#local res=study.ResultsAndDiscussion/>

		<#if res.PreliminaryStudy?has_content>
			<para>Preliminary study:</para>
			<para role="indent"><@com.text res.PreliminaryStudy/></para>
		</#if>

		<#if res.TestPerformance?has_content>
			<para>Test performance:</para>
			<para role="indent"><@com.text res.TestPerformance/></para>
		</#if>

		<#if res.hasElement("Spectrum")>
			<#local spectrumPath=res.Spectrum/>
		<#elseif res.hasElement("SpectrumOfSubstance")>
			<#local spectrumPath=res.SpectrumOfSubstance/>
		</#if>
		<#if spectrumPath?has_content>
			<para>Spectrum of substance:</para>
			<para role="indent"><@spectrumOfSubstanceList spectrumPath/></para>
		</#if>

		<#if res.hasElement("MaterialMassBalance") && res.MaterialMassBalance?has_content>
			<para>Material (mass) balance:</para>
			<para role="indent"><@materialMassBalanceList res.MaterialMassBalance/></para>
		</#if>

		<#if res.Degradation?has_content>
			<para>% Degradation:</para>
			<para role="indent"><@degradationList studyandsummaryCom.orderByKeyResult(res.Degradation)/></para>
		</#if>

		<#if res.QuantumYield?has_content>
			<para>Quantum yield: <@com.number res.QuantumYield/></para>
		</#if>

		<#if res.hasElement("DissipationParentCompound")>
			<#local dissPath=res.DissipationParentCompound/>
		<#elseif res.hasElement("DissipationHalfLife")>
			<#local dissPath=res.DissipationHalfLife/>
		</#if>
		<#if dissPath?has_content>
			<para>Dissipation half-life of parent compound:</para>
			<para role="indent"><@phototransformationHalfLifeList studyandsummaryCom.orderByKeyResult(dissPath)/></para>
		</#if>

		<#if res.hasElement("DTParentCompound")>
			<para>Disappearance time (DT) of parent compound:</para>
			<@disappearanceTimeList studyandsummaryCom.orderByKeyResult(res.DTParentCompound)/>
		</#if>

		<#if res.hasElement("PredictedEnvironmental") && res.PredictedEnvironmental?has_content>
			<para>Predicted environmental photolytic half-life:</para>
			<para role="indent"><@com.text res.PredictedEnvironmental/></para>
		</#if>

		<#if res.hasElement("DegradationRateConstant") && res.DegradationRateConstant?has_content>
			<para>Degradation rate constant:</para>
			<para role="indent"><@degradationRateConstantList studyandsummaryCom.orderByKeyResult(res.DegradationRateConstant)/></para>
		</#if>

		<#if res.TransformationProducts?has_content || res.IdentityTransformation?has_content>
			<para>Transformation products: <@com.picklist res.TransformationProducts/></para>
			<para role="indent"><@transformationProductList res.IdentityTransformation/></para>
		</#if>

		<#if res.hasElement("DetailsOnResults")>
			<#local detPath=res.DetailsOnResults/>
		<#elseif res.hasElement("ResultsDetails")>
			<#local detPath=res.ResultsDetails/>
		</#if>
		<#if detPath?has_content>
			<para>Details:</para>
			<para role="indent"><@com.text detPath/></para>
		</#if>

		<#if res.ResultsReferenceSubstance?has_content>
			<para>Results with reference substance: </para>
			<para role="indent"><@com.text res.ResultsReferenceSubstance/></para>
		</#if>
	</#compress>
</#macro>

<#macro results_adsorptionDesorption study>
	<#compress>
		<#local res=study.ResultsAndDiscussion/>

		<#if res.AdsorptionCoefficient?has_content>
			<para>Adsorption coefficient:</para>
			<para role="indent"><@adsorptionCoefficientList studyandsummaryCom.orderByKeyResult(res.AdsorptionCoefficient)/></para>
		</#if>

		<#if res.AdsorptionOther?has_content>
			<para>Partition coefficients:</para>
			<para role="indent"><@partitionCoefficientList studyandsummaryCom.orderByKeyResult(res.AdsorptionOther)/></para>
		</#if>

		<#if res.ResultsHplcMethod?has_content>
		<#--			<para><emphasis role="bold">HPLC method</emphasis></para>-->
			<#if res.ResultsHplcMethod.DetailsOnResultsHplcMethod?has_content>
				<para>HPLC method:</para>
				<para role="indent"><@com.text res.ResultsHplcMethod.DetailsOnResultsHplcMethod/></para>
			</#if>
		</#if>

		<#if res.ResultsBatchEquilibriumOrOtherMethod?has_content>
		<#--			<para><emphasis role="bold">Batch equilibrium or other method</emphasis></para>-->

			<#local res2=res.ResultsBatchEquilibriumOrOtherMethod/>

			<#if res2.AdsorptionAndDesorptionConstants?has_content>
				<para>Adsorption and desorption constants:</para>
				<para role="indent"><@com.text res2.AdsorptionAndDesorptionConstants/></para>
			</#if>

			<#if res2.RecoveryOfTestMaterial?has_content>
				<para>Recovery of test material:</para>
				<para role="indent"><@com.text res2.RecoveryOfTestMaterial/></para>
			</#if>

			<#if res2.ConcentrationOfTestSubstanceAtEndOfAdsorptionEquilibrationPeriod?has_content>
				<para>Concentration of test substance at end of adsorption equilibration period:</para>
				<para role="indent"><@com.text res2.ConcentrationOfTestSubstanceAtEndOfAdsorptionEquilibrationPeriod/></para>
			</#if>

			<#if res2.ConcentrationOfTestSubstanceAtEndOfDesorptionEquilibrationPeriod?has_content>
				<para>Concentration of test substance at end of desorption equilibration period:</para>
				<para role="indent"><@com.text res2.ConcentrationOfTestSubstanceAtEndOfDesorptionEquilibrationPeriod/></para>
			</#if>

			<#if res2.MassBalanceAtEndOfAdsorptionPhase?has_content>
				<para>Mass balance (in %) at end of adsorption phase:</para>
				<para role="indent"><@massBalanceAdsorptiontList res2.MassBalanceAtEndOfAdsorptionPhase/></para>
			</#if>

			<#if res2.MassBalanceAtEndOfDesorptionPhase?has_content>
				<para>Mass balance (in %) at end of desorption phase:</para>
				<para role="indent"><@massBalanceDesorptiontList res2.MassBalanceAtEndOfDesorptionPhase/></para>
			</#if>

			<#if res2.TransformationProducts?has_content || res2.IdentityTransformation?has_content>
				<para>Transformation products: <@com.picklist res2.TransformationProducts/></para>
				<para role="indent"><@transformationProductList res2.IdentityTransformation/></para>
			</#if>

			<#if res2.DetailsOnResultsBatchEquilibriumMethod?has_content>
				<para>Details:</para>
				<para role="indent"><@com.text res2.DetailsOnResultsBatchEquilibriumMethod/></para>
			</#if>

			<#if res2.Statistics?has_content>
				<para>Statistics:</para>
				<para role="indent"><@com.text res2.Statistics/></para>
			</#if>

		</#if>
	</#compress>
</#macro>

<#macro results_hydrolysis study>
	<#compress>
		<#local res=study.ResultsAndDiscussion/>

		<#if res.PreliminaryStudy?has_content>
			<para>Preliminary study:</para>
			<para role="indent"><@com.text res.PreliminaryStudy/></para>
		</#if>

		<#if res.TestPerformance?has_content>
			<para>Test performance:</para>
			<para role="indent"><@com.text res.TestPerformance/></para>
		</#if>

		<#if res.TransformationProducts?has_content || res.IdentityTransformation?has_content>
			<para>Transformation products: <@com.picklist res.TransformationProducts/></para>
			<para role="indent"><@transformationProductList res.IdentityTransformation/></para>
			<#if res.DetailsOnHydrolysisAndAppearanceOfTransformationProducts?has_content>
				<para role="indent">(<@com.text res.DetailsOnHydrolysisAndAppearanceOfTransformationProducts/>)</para>
			</#if>
		</#if>

		<#if res.MaterialMassBalance?has_content>
			<para>Total recovery of test substance (in %):</para>
			<para role="indent"><@recoveryList res.MaterialMassBalance/></para>
		</#if>

		<#if res.DTParentCompound?has_content>
			<para>Dissipation DT50 of parent compound:</para>
			<para role="indent"><@hydrolysisHalfLifeList studyandsummaryCom.orderByKeyResult(res.DTParentCompound)/></para>
		</#if>

		<#if res.OtherKineticParameters?has_content>
			<para>Other kinetic parameters:</para>
			<para role="indent"><@com.text res.OtherKineticParameters/></para>
		</#if>

		<#if res.DetailsOnResults?has_content>
			<para>Details:</para>
			<para role="indent"><@com.text res.DetailsOnResults/></para>
		</#if>

		<#if res.ResultsWithReferenceSubstance?has_content>
			<para>Results with reference substance: </para>
			<para role="indent"><@com.text res.ResultsWithReferenceSubstance/></para>
		</#if>
	</#compress>
</#macro>

<#macro results_biodegradationWaterScreening study>
	<#compress>
		<#local res=study.ResultsAndDiscussion/>

		<#if res.PrelimStudyRs?has_content>
			<para>Preliminary study:</para>
			<para role="indent"><@com.text res.PrelimStudyRs/></para>
		</#if>

		<#if res.TestPerformance?has_content>
			<para>Test performance:</para>
			<para role="indent"><@com.text res.TestPerformance/></para>
		</#if>

		<#if res.Degradation?has_content>
			<para>% Degradation:</para>
			<para role="indent"><@degradationOfTestSubstanceList studyandsummaryCom.orderByKeyResult(res.Degradation)/></para>
		</#if>

		<#if res.ResultsDetails?has_content>
			<para>Details:</para>
			<para role="indent"><@com.text res.ResultsDetails/></para>
		</#if>

		<#if res.Bod5CodResults?has_content>
			<para><emphasis role="bold">BOD / COD results:</emphasis></para>

			<#if res.Bod5CodResults.Bod5Cod?has_content>
				<para>BOD / COD:</para>
				<para role="indent"><@spectrumOfSubstanceList studyandsummaryCom.orderByKeyResult(res.Bod5CodResults.Bod5Cod)/></para>
			</#if>

			<#if res.Bod5CodResults.ResultsWithReferenceSubstance?has_content>
				<para>Results with reference substance:</para>
				<para role="indent"><@com.text res.Bod5CodResults.ResultsWithReferenceSubstance/></para>
			</#if>

		</#if>

	</#compress>
</#macro>

<#macro results_monitoring study>
	<#compress>
		<#local res=study.ResultsAndDiscussion/>

		<#if res.Concentration?has_content>
			<para>Concentration:</para>
			<para role="indent"><@concentrationList studyandsummaryCom.orderByKeyResult(res.Concentration)/></para>

		</#if>

		<#if res.DetailsOnResults?has_content>
			<para>Details:</para>
			<para role="indent"><@com.text res.DetailsOnResults/></para>
		</#if>

	</#compress>
</#macro>

<#--Lists-->
<#macro massBalanceList massBalanceRepeatableBlock>
	<#compress>
		<#if massBalanceRepeatableBlock?has_content>
			<#list massBalanceRepeatableBlock as blockItem>
				<para role="indent">

					<#if blockItem.hasElement("SoilNo") && blockItem.SoilNo?has_content>
						<@com.picklist blockItem.SoilNo/>:
					</#if>

					<#if blockItem.hasElement("Compartment") && blockItem.Compartment?has_content>
						<@com.picklist blockItem.Compartment/>:
					</#if>

					<#if blockItem.TotalExtractable?has_content>
						Total extractable: <@com.range blockItem.TotalExtractable/>%.
					</#if>

					<#if blockItem.NonExtractable?has_content>
						Non extractable: <@com.range blockItem.NonExtractable/>%.
					</#if>

					<#if blockItem.CO2?has_content>
						CO2: <@com.range blockItem.CO2/>%.
					</#if>

					<#if blockItem.OtherVolatiles?has_content>
						Other volatiles: <@com.range blockItem.OtherVolatiles/>%.
					</#if>

					<#if blockItem.Recovery?has_content>
						<@com.range blockItem.Recovery/>% recovery
					</#if>

					<#if blockItem.StDev?has_content>
						[sd=<@com.number blockItem.StDev/>]
					</#if>

					<#if blockItem.RemarksOnResults?has_content>
						(<@com.picklist blockItem.RemarksOnResults/>)
					</#if>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro concentrationList concentrationRepeatableBlock>
	<#compress>
		<#if concentrationRepeatableBlock?has_content>
			<#list concentrationRepeatableBlock as blockItem>
				<para role="indent">

					<#if blockItem.Concentration?has_content>
						<@com.range blockItem.Concentration/>
					</#if>

					<#if blockItem.SubstanceOrMetabolite?has_content>
						(<@com.picklist blockItem.SubstanceOrMetabolite/>)
					</#if>

					<#if blockItem.Location?has_content || blockItem.Country?has_content>
						- location: <@com.text blockItem.Location/> <@com.picklist blockItem.Country/>
					</#if>

					<#if blockItem.RemarksOnResults?has_content>
						(<@com.picklist blockItem.RemarksOnResults/>)
					</#if>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro testDurationList testDurationRepeatableBlock>
	<#compress>
		<#if testDurationRepeatableBlock?has_content>
			<#list testDurationRepeatableBlock as blockItem>
				<para role="indent">

					<#if blockItem.SoilNo?has_content>
						<@com.picklist blockItem.SoilNo/>:
					</#if>

					<#if blockItem.Duration?has_content>
						<@com.range blockItem.Duration/>
					</#if>

				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro initialSubstanceConcentrationList initialSubstanceConcentrationRepeatableBlock>
	<#compress>
		<#if initialSubstanceConcentrationRepeatableBlock?has_content>
			<#list initialSubstanceConcentrationRepeatableBlock as blockItem>
				<para role="indent">

					<#if blockItem.hasElement("SoilNo") && blockItem.SoilNo?has_content>
						<@com.picklist blockItem.SoilNo/>:
					</#if>

					<#if blockItem.InitialConc?has_content>
						<@com.range blockItem.InitialConc/>
					</#if>

					<#if blockItem.BasedOn?has_content>
						based on <@com.picklist blockItem.BasedOn/>
					</#if>

				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro experimentalConditionsList experimentalConditionsRepeatableBlock>
	<#compress>
		<#if experimentalConditionsRepeatableBlock?has_content>
			<#list experimentalConditionsRepeatableBlock as blockItem>
				<para role="indent">

					<#if blockItem.SoilNo?has_content>
						<@com.value blockItem.SoilNo/>:
					</#if>

					<#if blockItem.Temp?has_content>
						Temperature: <@com.value blockItem.Temp/>.
					</#if>

					<#if blockItem.Humidity?has_content>
						Humidity: <@com.value blockItem.Humidity/>.
					</#if>

					<#if blockItem.SterileConditions?has_content>
						Sterile conditions: <@com.value blockItem.SterileConditions/>.
					</#if>

					<#if blockItem.MicrobialBiomass?has_content>
						Microbial biomass: <@com.value blockItem.MicrobialBiomass/>.
					</#if>
					.

				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro testDurationConditionList testDurationConditionRepeatableBlock>
	<#compress>
		<#if testDurationConditionRepeatableBlock?has_content>
			<#list testDurationConditionRepeatableBlock as blockItem>
				<para role="indent">

					<#if blockItem.hasElement("SampleNo") && blockItem.SampleNo?has_content>
						<@com.picklist blockItem.SampleNo/>:
					</#if>

					<#if blockItem.Duration?has_content>
						<@com.value blockItem.Duration/>
					</#if>

					<#if blockItem.Temp?has_content>
						at <@com.value blockItem.Temp/>
					</#if>

					<#if blockItem.hasElement("Moisture") && blockItem.Moisture?has_content>
						at <@com.quantity blockItem.Moisture/>% moisture
					</#if>

					<#if blockItem.hasElement("Ph") && blockItem.Ph?has_content>
						at pH=<@com.number blockItem.Ph/>
					</#if>

					<#if blockItem.hasElement("InitialConcMeasured") && blockItem.InitialConcMeasured?has_content>
						- initial concentration measured: <@com.value blockItem.InitialConcMeasured/>
					<#elseif blockItem.hasElement("ConcOfAdsorbedTestMat") && blockItem.ConcOfAdsorbedTestMat?has_content>
						- concentration of adsorbed test mat.: <@com.value blockItem.ConcOfAdsorbedTestMat/>
					</#if>

					<#if blockItem.hasElement("Remarks") && blockItem.Remarks?has_content>
						(<@com.text blockItem.Remarks/>)
					</#if>

				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro matrixList matrixBlock>
	<#compress>
		<#if matrixBlock?has_content>
			<#list matrixBlock as blockItem>
				<para>

					<#if blockItem.MatrixNo?has_content>
						<@com.picklist blockItem.MatrixNo/>:
					</#if>

					<@com.picklist blockItem.MatrixType/>

					<#if pppRelevant??>
						<#if blockItem.Clay?has_content>
							. Clay: <@com.range blockItem.Clay/>%
						</#if>
						<#if blockItem.Silt?has_content>
							. Silt: <@com.range blockItem.Silt/>%
						</#if>
						<#if blockItem.Sand?has_content>
							. Sand: <@com.range blockItem.Sand/>%
						</#if>
						<#if blockItem.OrgCarbon?has_content>
							. Org.Carbon: <@com.range blockItem.OrgCarbon/>%
						</#if>
						<#if blockItem.Ph?has_content>
							. pH: <@com.range blockItem.Ph/>%
						</#if>
						<#if blockItem.CEC?has_content>
							. CEC: <@com.range blockItem.CEC/>%
						</#if>
						<#if blockItem.BulkDensityGCm?has_content>
							. Bulk density: <@com.range blockItem.BulkDensityGCm/>g/cm3
						</#if>

					</#if>

				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro refSubList refSubBlock>
	<#compress>
		<#if refSubBlock?has_content>
			<#list refSubBlock as blockItem>
				<para role="indent">
					<@com.picklist blockItem.ReferenceSubstance/>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro paramBiodegradationList paramBiodegradationBlock>
	<#compress>
		<#if paramBiodegradationBlock?has_content>
			<#list paramBiodegradationBlock as blockItem>
				<para role="indent">
					<@com.picklist blockItem.ParameterFollowedForBiodegradationEstimation/>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro transformationProductsDetailsList block>
	<#compress>
	<#-- NOTE: could be turned into a table; X2 and 95%CI not reported-->

		<#list block as blockItem>
			<para role="indent">

				<#if blockItem.IdentityOfCompound?has_content>
					<#local comp = iuclid.getDocumentForKey(blockItem.IdentityOfCompound) />
					<@com.value comp.ReferenceSubstanceName/>

					<#if blockItem.ParentCompoundS?has_content>
						<#local parents= []/>
						<#list blockItem.ParentCompoundS as parentLink>
							<#local comp = iuclid.getDocumentForKey(parentLink) />
							<#local parent><@com.value comp.ReferenceSubstanceName/></#local>
							<#local parents = parents + [parent]/>
						</#list>
						(parent: ${parents?join("; ")})
					</#if>
					:
				</#if>

				<#if blockItem.hasElement("SoilNo") && blockItem.SoilNo?has_content>
					Soil <@com.value blockItem.SoilNo/>:
				<#elseif blockItem.hasElement("Compartment") && blockItem.Compartment?has_content>
					Compartment: <@com.value blockItem.Compartment/>
				</#if>

				<#if blockItem.KineticFormationFraction?has_content>
					Kinetic formation fraction: <@com.value blockItem.KineticFormationFraction/>.
				</#if>

				<#if blockItem.MaximumOccurrence?has_content>
					Maximum occurrence: <@com.value blockItem.MaximumOccurrence/>%

					<#if blockItem.TimepointOfMaximumOccurrenceObservedInDays?has_content>
						at <@com.value blockItem.TimepointOfMaximumOccurrenceObservedInDays/> days
					</#if>
					.
				</#if>

				<#if blockItem.Parameter?has_content>
					<@com.value blockItem.Parameter/><#if blockItem.TypeOfValue?has_content> (<@com.value blockItem.TypeOfValue/>)</#if><#if blockItem.Value?has_content>: <@com.value blockItem.Value/></#if>.
				
					<#if blockItem.StDev?has_content>
						[sd=<@com.value blockItem.StDev/>]
					</#if>

					<#if blockItem.Temp?has_content>
						at <@com.value blockItem.Temp/>
					</#if>

					<#if blockItem.TypeOfKineticsAndMethodOfCalculation?has_content>
						(
						<@com.value blockItem.TypeOfKineticsAndMethodOfCalculation/>
						<#if blockItem.KineticParameters?has_content>
							, kinetic parameters: <@com.value blockItem.KineticParameters/>
						</#if>
						)
					</#if>
				</#if>

			</para>
		</#list>

	</#compress>
</#macro>

<#--Methods-->
<#macro fateMethod study>
	<#compress>

		<#--General-->
		<#if study.MaterialsAndMethods.hasElement("TestType") && study.MaterialsAndMethods.TestType?has_content>
			<para><emphasis role='bold'>Test type: </emphasis><@com.picklist study.MaterialsAndMethods.TestType/></para>
		</#if>

		<#if study.MaterialsAndMethods.hasElement("TypeOfMeasurement") && study.MaterialsAndMethods.TypeOfMeasurement?has_content>
			<para><emphasis role='bold'>Type of measurement: </emphasis><@com.value study.MaterialsAndMethods.TypeOfMeasurement/></para>
		</#if>

		<#if study.MaterialsAndMethods.hasElement("TypeOfStudy") && study.MaterialsAndMethods.TypeOfStudy?has_content>
			<para><emphasis role='bold'>Type of study: </emphasis><@com.picklist study.MaterialsAndMethods.TypeOfStudy/></para>
		</#if>
		<#if study.MaterialsAndMethods.hasElement("StudyType") && study.MaterialsAndMethods.StudyType?has_content>
			<para><emphasis role='bold'>Study type: </emphasis><@com.picklist study.MaterialsAndMethods.StudyType/></para>
		</#if>

		<#if study.MaterialsAndMethods.hasElement("TypeOfStudyInformation") && study.MaterialsAndMethods.TypeOfStudyInformation?has_content>
			<para><emphasis role='bold'>Type of study / information: </emphasis><@com.text study.MaterialsAndMethods.TypeOfStudyInformation ""/></para>
		</#if>

		<#if study.MaterialsAndMethods.hasElement("MethodType") && study.MaterialsAndMethods.MethodType?has_content>
			<para><emphasis role='bold'>Type of method: </emphasis><@com.picklist study.MaterialsAndMethods.MethodType/></para>
		</#if>

		<#if study.MaterialsAndMethods.hasElement("Media") && study.MaterialsAndMethods.Media?has_content>
			<para><emphasis role='bold'>Media: </emphasis><@com.value study.MaterialsAndMethods.Media/></para>
		</#if>

		<#--Study Design-->
		<#if study.MaterialsAndMethods.hasElement("StudyDesign") && study.MaterialsAndMethods.StudyDesign?has_content>
			<para><emphasis role='bold'>Study design:</emphasis></para>

			<#if study.documentSubType=="BiodegradationInSoil">
				<@methods_studyDesign_biodegradationSoil study/>
			<#elseif study.documentSubType=="PhotoTransformationInSoil" || study.documentSubType=="Phototransformation" || study.documentSubType=="PhototransformationInAir">
				<@methods_studyDesign_phototransformation study/>
			<#elseif study.documentSubType=="AdsorptionDesorption">
				<@methods_studyDesign_adsorptionDesorption study/>
			<#elseif study.documentSubType=="Hydrolysis">
				<@methods_studyDesign_hydrolysis study/>
			<#elseif study.documentSubType=="BiodegradationInWaterAndSedimentSimulationTests" || study.documentSubType=="BiodegradationInWaterScreeningTests" >
				<@methods_studyDesign_biodegradationWaterSediment study/>
			<#elseif study.documentSubType=="MonitoringData">
				<@methods_studyDesign_monitoring study/>
			</#if>
		<#elseif study.documentSubType=="FieldStudies"><#-- path is not harmonised under Study design like for other cases (might change in future) -->
			<#if study.MaterialsAndMethods.TestMaterials.SoilProperties?has_content || study.MaterialsAndMethods.TestMaterials.DetailsOnSoilCharacteristics?has_content>
			<para><emphasis role='bold'>Soil properties:</emphasis></para>
			<@soilTypeList study.MaterialsAndMethods.TestMaterials.SoilProperties/>
			<para role="indent">Details: <@com.value study.MaterialsAndMethods.TestMaterials.DetailsOnSoilCharacteristics/></para>
		</#if>

		</#if>



	</#compress>
</#macro>

<#macro methods_studyDesign_monitoring study>
	<#compress>

		<#local stdes=study.MaterialsAndMethods.StudyDesign/>

		<#if stdes.DetailsOnAnalyticalMethods?has_content>
			<para>Details on analytical methods</para>
			<para role="indent"><@com.text stdes.DetailsOnAnalyticalMethods/></para>
		</#if>

		<#if stdes.DetailsOnSampling?has_content>
			<para>Sampling:</para>
			<para role="indent"><@com.text stdes.DetailsOnSampling/></para>
		</#if>
	</#compress>
</#macro>

<#macro methods_studyDesign_biodegradationSoil study>
	<#compress>

		<#local stdes=study.MaterialsAndMethods.StudyDesign/>

		<#if stdes.OxygenConditions?has_content>
			<para>Oxygen conditions:</para>
			<para role="indent"><@com.value stdes.OxygenConditions/></para>
		</#if>

		<#if stdes.ContinuousDarkness?has_content>
			<para>Continuous darkness: <@com.value stdes.ContinuousDarkness/></para>
		</#if>

		<#if stdes.SoilClassification?has_content || stdes.SoilProperties?has_content || stdes.DetailsOnSoilCharacteristics?has_content>
			<para>Soil: <@com.value stdes.SoilClassification/></para>
			<@soilTypeList stdes.SoilProperties/>
			<para role="indent">Details:<@com.value stdes.DetailsOnSoilCharacteristics/></para>
		</#if>

		<#if stdes.DurationOfTestContactTime?has_content>
			<para>Duration of test (contact time):</para>
			<para role="indent"><@testDurationList stdes.DurationOfTestContactTime/></para>
		</#if>

		<#if stdes.InitialTestSubstanceConcentration?has_content>
			<para>Initial test substance concentration:</para>
			<para role="indent"><@initialSubstanceConcentrationList stdes.InitialTestSubstanceConcentration/></para>
		</#if>

		<#if stdes.ParameterFollowed?has_content>
			<para>Parameter followed for biodegradation estimation: <@com.value stdes.ParameterFollowed/></para>
		</#if>

		<#if stdes.DetailsOnAnalyticalMethods?has_content>
			<para>Details on analytical methods:</para>
			<para role="indent"><@com.value stdes.DetailsOnAnalyticalMethods/></para>
		</#if>

		<#if stdes.ExperimentalConditions?has_content || stdes.DetailsOnExperimentalConditions?has_content>
			<para>Experimental conditions:</para>
			<para role="indent"><@experimentalConditionsList stdes.ExperimentalConditions/></para>
			<para role="indent">Details: <@com.value stdes.DetailsOnExperimentalConditions/></para>
		</#if>

	</#compress>
</#macro>

<#macro methods_studyDesign_phototransformation study>
	<#compress>

		<#local stdes=study.MaterialsAndMethods.StudyDesign/>

		<#if stdes.hasElement("Radiolabelling") && stdes.Radiolabelling?has_content>
			<para>Radiolabelling: <@com.picklist stdes.Radiolabelling/></para>
		</#if>

		<#if stdes.hasElement("EstimationMethodIfUsed") && stdes.EstimationMethodIfUsed?has_content>
			<para>Estimation method: <@com.text stdes.EstimationMethodIfUsed/></para>
		</#if>

		<#if (stdes.hasElement("AnalyticalMonitoring") && stdes.AnalyticalMonitoring?has_content) ||
		(stdes.hasElement("AnalyticalMethod") && stdes.AnalyticalMethod?has_content) ||
		(stdes.hasElement("DetailsOnAnalyticalMethods") &&stdes.DetailsOnAnalyticalMethods?has_content)>
			<para>Analytical methods:</para>
			<#if stdes.hasElement("AnalyticalMonitoring") &&  stdes.AnalyticalMonitoring?has_content>
				<para role="indent">Monitoring: <@com.value stdes.AnalyticalMonitoring/></para>
			</#if>

			<#if stdes.AnalyticalMethod?has_content>
				<para role="indent">Method: <@com.picklistMultiple stdes.AnalyticalMethod/></para>
			</#if>

			<#if stdes.DetailsOnAnalyticalMethods?has_content>
				<para role="indent">Details: <@com.text stdes.DetailsOnAnalyticalMethods/></para>
			</#if>
		</#if>

		<#if stdes.hasElement("DetailsOnSampling") && stdes.DetailsOnSampling?has_content>
			<para>Sampling:</para>
			<para role="indent"><@com.text stdes.DetailsOnSampling/></para>
		</#if>

		<#if stdes.hasElement("DetailsOnSoil") && stdes.DetailsOnSoil?has_content>
			<para>Soil:</para>
			<para role="indent"><@com.text stdes.DetailsOnSoil/></para>
		</#if>

		<#if stdes.hasElement("Buffers") && stdes.Buffers?has_content>
			<para>Buffers:</para>
			<para role="indent"><@com.text stdes.Buffers/></para>
		</#if>

		<#if stdes.LightSource?has_content || stdes.LightSpectrumWavelengthInNm?has_content ||
		stdes.RelativeLightIntensity?has_content || stdes.DetailsOnLightSource?has_content>
			<para>Light:</para>

			<#if stdes.LightSource?has_content>
				<para role="indent">Source: <@com.picklist stdes.LightSource/></para>
				<#if stdes.DetailsOnLightSource?has_content><para role="indent2"><@com.text stdes.DetailsOnLightSource/></para></#if>
			</#if>

			<#if stdes.LightSpectrumWavelengthInNm?has_content>
				<para role="indent">Spectrum: <@com.range stdes.LightSpectrumWavelengthInNm/>nm</para>
			</#if>

			<#if stdes.RelativeLightIntensity?has_content>
				<para role="indent">Relative intensity: <@com.range stdes.RelativeLightIntensity/></para>
			</#if>
		</#if>

		<#if stdes.hasElement("SensitiserForIndirectPhotolysis") && stdes.SensitiserForIndirectPhotolysis?has_content>
			<para>Sensitiser for indirect photolysis:</para>
			<para role="indent"><@sensitiserList stdes.SensitiserForIndirectPhotolysis/></para>
		</#if>

		<#if stdes.DetailsOnTestConditions?has_content>
			<para>Test conditions:</para>
			<para role="indent"><@com.text stdes.DetailsOnTestConditions/></para>
		</#if>

		<#if stdes.DurationOfTestAtGivenTestCondition?has_content>
			<para>Duration:</para>
			<para role="indent"><@testDurationConditionList stdes.DurationOfTestAtGivenTestCondition/></para>
		</#if>

		<#if stdes.ReferenceSubstance?has_content>
			<para>Reference substance: <@com.picklist stdes.ReferenceSubstance/></para>
		</#if>

		<#if stdes.hasElement("DarkControls") && stdes.DarkControls?has_content>
			<para>Dark controls: <@com.picklist stdes.DarkControls/></para>
		</#if>

		<#if stdes.hasElement("ComputationalMethods") && stdes.ComputationalMethods?has_content>
			<para>Computational methods:</para>
			<para role="indent"><@com.text stdes.ComputationalMethods/></para>
		</#if>

	</#compress>
</#macro>

<#macro methods_studyDesign_adsorptionDesorption study>
	<#compress>

		<#local stdes=study.MaterialsAndMethods.StudyDesign/>

		<#if stdes.TestTemperature?has_content>
			<para>Test temperature:</para>
			<para role="indent"><@com.text stdes.TestTemperature/></para>
		</#if>

		<#if stdes.HPLCMethod.DetailsOnStudyDesignHplcMethod?has_content>
			<para>HPLC method:</para>
			<para role="indent"><@com.text stdes.HPLCMethod.DetailsOnStudyDesignHplcMethod/></para>
		</#if>

		<#if stdes.BatchEquilibriumOrOtherMethod?has_content>

			<#local batch=stdes.BatchEquilibriumOrOtherMethod/>

		<#--			<para>Batch equilibrium or other method:</para>-->

			<#if batch.AnalyticalMonitoring?has_content || batch.DetailsOnAnalyticalMethods?has_content>

				<para>Analytical methods:</para>

				<#if batch.AnalyticalMonitoring?has_content>
					<para role="indent">Monitoring: <@com.value batch.AnalyticalMonitoring/></para>
				</#if>

				<#if batch.DetailsOnAnalyticalMethods?has_content>
					<para role="indent">Details: <@com.text batch.DetailsOnAnalyticalMethods/></para>
				</#if>
			</#if>

			<#if batch.DetailsOnSampling?has_content>
				<para>Sampling:</para>
				<para role="indent"><@com.text batch.DetailsOnSampling/></para>
			</#if>

			<#if batch.MatrixProperties?has_content || batch.DetailsOnMatrix?has_content>
				<para>Matrix:</para>
				<para role="indent"><@matrixList batch.MatrixProperties/></para>
				<#if batch.DetailsOnMatrix?has_content><para role="indent">Details: <@com.text batch.DetailsOnMatrix/></para></#if>
			</#if>

			<#if batch.DetailsOnTestConditions?has_content>
				<para>Test conditions:</para>
				<para role="indent"><@com.text batch.DetailsOnTestConditions/></para>

			</#if>

			<#if batch.DurationOfAdsorptionEquilibration?has_content>
				<para>Duration of adsorption equilibration:</para>
				<para role="indent"><@testDurationConditionList batch.DurationOfAdsorptionEquilibration/></para>

			</#if>

			<#if batch.DurationOfDesorptionEquilibration?has_content>
				<para>Duration of desorption equilibration:</para>
				<para role="indent"><@testDurationConditionList batch.DurationOfDesorptionEquilibration/></para>

			</#if>

			<#if batch.ComputationalMethods?has_content>
				<para>Computational methods:</para>
				<para role="indent"><@com.text batch.ComputationalMethods/></para>
			</#if>
		</#if>

	</#compress>
</#macro>

<#macro methods_studyDesign_hydrolysis study>
	<#compress>

		<#local stdes=study.MaterialsAndMethods.StudyDesign/>

		<#if stdes.AnalyticalMonitoring?has_content || stdes.DetailsOnAnalyticalMethods?has_content>
			<para>Analytical methods:</para>
			<#if stdes.AnalyticalMonitoring?has_content>
				<para role="indent">Monitoring: <@com.value stdes.AnalyticalMonitoring/></para>
			</#if>

			<#if stdes.DetailsOnAnalyticalMethods?has_content>
				<para role="indent"><@com.text stdes.DetailsOnAnalyticalMethods/></para>
			</#if>

		</#if>

		<#if stdes.DetailsOnSampling?has_content>
			<para>Sampling:</para>
			<para role="indent"><@com.text stdes.DetailsOnSampling/></para>
		</#if>

		<#if stdes.Buffers?has_content>
			<para>Buffers:</para>
			<para role="indent"><@com.text stdes.Buffers/></para>
		</#if>

		<#if stdes.EstimationMethodIfUsed?has_content>
			<para>Estimation method:</para>
			<para role="indent"><@com.text stdes.EstimationMethodIfUsed/></para>
		</#if>

		<#if stdes.DetailsOnTestConditions?has_content>
			<para>Test conditions:</para>
			<para role="indent"><@com.text stdes.DetailsOnTestConditions/></para>
		</#if>

		<#if stdes.DurationOfTest?has_content>
			<para>Duration:</para>
			<para role="indent"><@testDurationConditionList stdes.DurationOfTest/></para>
		</#if>

		<#if stdes.NumberOfReplicates?has_content>
			<para>Number of replicates:</para>
			<para role="indent"><@com.text stdes.NumberOfReplicates/></para>
		</#if>

		<#if stdes.PositiveControls?has_content>
			<para>Positive controls:</para>
			<para role="indent"><@com.picklist stdes.PositiveControls/></para>
		</#if>

		<#if stdes.NegativeControls?has_content>
			<para>Negative controls:</para>
			<para role="indent"><@com.picklist stdes.NegativeControls/></para>
		</#if>

		<#if stdes.StatisticalMethods?has_content>
			<para>Statistical methods:</para>
			<para role="indent"><@com.text stdes.StatisticalMethods/></para>
		</#if>

	</#compress>
</#macro>

<#macro methods_studyDesign_biodegradationWaterSediment study>
	<#compress>

		<#local stdes=study.MaterialsAndMethods.StudyDesign/>

		<#if stdes.OxygenConditions?has_content>
			<para>Oxygen conditions:</para>
			<para role="indent"><@com.picklist stdes.OxygenConditions/></para>
		</#if>

		<#if stdes.hasElement("ContinuousDarkness") && stdes.ContinuousDarkness?has_content>
			<para>Continuous darkness: <@com.value stdes.ContinuousDarkness/></para>
		</#if>

		<#if stdes.InoculumOrTestSystem?has_content || stdes.DetailsOnInoculum>
			<para>Inoculum or test system: <@com.picklist stdes.InoculumOrTestSystem/></para>
			<para role="indent"><@com.text stdes.DetailsOnInoculum/></para>
		</#if>

		<#if stdes.hasElement("DetailsOnSourceAndPropertiesOfSurfaceWater") && stdes.DetailsOnSourceAndPropertiesOfSurfaceWater?has_content>
			<para>Details on source and properties of surface water:</para>
			<para role="indent"><@com.text stdes.DetailsOnSourceAndPropertiesOfSurfaceWater/></para>
		</#if>

		<#if stdes.hasElement("DetailsOnSourceAndPropertiesOfSediment") && stdes.DetailsOnSourceAndPropertiesOfSediment?has_content>
			<para>Details on source and properties of sediment:</para>
			<para role="indent"><@com.text stdes.DetailsOnSourceAndPropertiesOfSediment/></para>
		</#if>

		<#if stdes.hasElement("DetailsOnSourceAndPropertiesOfManure") && stdes.DetailsOnSourceAndPropertiesOfManure?has_content>
			<para>Details on source and properties of manure:</para>
			<para role="indent"><@com.text stdes.DetailsOnSourceAndPropertiesOfManure/></para>
		</#if>

		<#if stdes.DurationOfTestContactTime?has_content>
			<para>Duration of test (contact time):</para>
			<para role="indent"><@com.range stdes.DurationOfTestContactTime/></para>
		</#if>

		<#if stdes.InitialTestSubstanceConcentration?has_content>
			<para>Initial test substance concentration:</para>
			<para role="indent"><@initialSubstanceConcentrationList stdes.InitialTestSubstanceConcentration/></para>
		</#if>

		<#if stdes.ParameterFollowedForBiodegradationEstimation?has_content>
			<para>Parameter followed for biodegradation estimation:
			<#if stdes.ParameterFollowedForBiodegradationEstimation?node_type="picklist_multi">
				<@com.picklistMultiple stdes.ParameterFollowedForBiodegradationEstimation/>
			<#else></para><para role="indent"><@paramBiodegradationList stdes.ParameterFollowedForBiodegradationEstimation/>
			</#if>
			</para>
		</#if>

		<#if stdes.DetailsOnAnalyticalMethods?has_content>
			<para>Details on analytical methods:</para>
			<para role="indent"><@com.text stdes.DetailsOnAnalyticalMethods/></para>
		</#if>

		<#if stdes.DetailsOnStudyDesign?has_content>
			<para>Details on study design:</para>
			<para role="indent"><@com.text stdes.DetailsOnStudyDesign/></para>
		</#if>

		<#if stdes.ReferenceSubstance?has_content>
			<para>Reference substance:</para>
			<para role="indent"><@refSubList stdes.ReferenceSubstance/></para>
		</#if>

	</#compress>
</#macro>

<#--3. summaries-->

<#-- fateCSA prints the information under the section Key Value for Chemical Safety Assessment of 
	a single Fate summary, based on the document sub type.
	For harmonised summaries, it uses the fateCSAtable macro.

	Inputs:
	- summary: summary document object (ENDPOINT_SUMMARY or FLEXIBLE_SUMMARY)
	- endpoint: 'ResidueDefinitionRiskAssessment' or 'ResidueDefinitionMonitoring', for the "DefinitionResidueFate" document
-->
<#macro fateCSA summary endpoint="" bgcolor="#FBDDA6">

	<#-- individual cases for all the old EU_PPP summaries -->
	<#if summary.documentSubType=="BiodegradationInSoil_EU_PPP"><#-- obsolete document -->
		<#if summary.KeyValueCsa.PersistenceDegradationSoil?has_content>
			<para>Persistance / rate of degradation in soil:</para>
			<para role="small"><@degradationRateSummaryTable path=summary.KeyValueCsa.PersistenceDegradationSoil bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.ModellingDegradationSoil?has_content>
			<para>Modelling rate of degradation in soil:</para>
			<para role="small"><@modellingDegradationRateSummaryTable path=summary.KeyValueCsa.ModellingDegradationSoil bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.KeyValueCsa?has_content>
			<para>Key value for safety assessment:</para>
			<para role="small"><@keyValueCSASummaryTable path=summary.KeyValueCsa.KeyValueCsa bgcolor=bgcolor/></para>
		</#if>

	<#elseif summary.documentSubType=="RouteDegSoil_EU_PPP"><#-- obsolete document -->
		<#if summary.KeyValueCsa.DegradationSoil?has_content>
			<para>Route of degradation in soil:</para>
			<para role="small"><@degradationRouteSummaryTable path=summary.KeyValueCsa.DegradationSoil bgcolor=bgcolor/></para>
		</#if>

	<#elseif summary.documentSubType=="BiodegradationInWaterAndSedimentSimulationTests_EU_PPP"><#-- obsolete document -->
		<#if summary.KeyValueCsa.PersistenceDegradationFreshwater?has_content>
			<para>Persistance / rate of degradation in freshwater:</para>
			<para role="small"><@degradationRateSummaryTable path=summary.KeyValueCsa.PersistenceDegradationFreshwater bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.ModelledDegradationFreshwater?has_content>
			<para>Modelling rate of degradation in freshwater:</para>
			<para role="small"><@modellingDegradationRateSummaryTable path=summary.KeyValueCsa.ModelledDegradationFreshwater bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.DegradationMarineWater.PersistenceDegradationFreshwaterSediment?has_content>
			<para>Persistance / rate of degradation in freshwater sediment:</para>
			<para role="small"><@degradationRateSummaryTable path=summary.KeyValueCsa.DegradationMarineWater.PersistenceDegradationFreshwaterSediment bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.DegradationMarineWater.ModelledDegradationFreshwaterSed?has_content>
			<para>Modelling rate of degradation in freshwater sediment:</para>
			<para role="small"><@modellingDegradationRateSummaryTable path=summary.KeyValueCsa.DegradationMarineWater.ModelledDegradationFreshwaterSed bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.DegradationMarineSediment.PersistenceDegradationWholeSystem?has_content>
			<para>Persistance / rate of degradation in whole system:</para>
			<para role="small"><@degradationRateSummaryTable path=summary.KeyValueCsa.DegradationMarineSediment.PersistenceDegradationWholeSystem bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.DegradationMarineSediment.ModelledDegradationWholeSystem?has_content>
			<para>Modelling rate of degradation in whole system:</para>
			<para role="small"><@modellingDegradationRateSummaryTable path=summary.KeyValueCsa.DegradationMarineSediment.ModelledDegradationWholeSystem bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.DegradationMarineWater.HalfLifeMarineWater?has_content>
			<para>Rate of degradation in marine water:</para>
			<para role='indent'>
				Half-life in marine water: <@com.value summary.KeyValueCsa.DegradationMarineWater.HalfLifeMarineWater/>
					<#if summary.KeyValueCsa.DegradationMarineWater.Temperature?has_content>at <@com.value summary.KeyValueCsa.DegradationMarineWater.Temperature/></#if>
			</para>
		</#if>
		<#if summary.KeyValueCsa.DegradationMarineSediment.HalfLifeMarineWaterSed?has_content>
			<para>Rate of degradation in marine water sediment:</para>
			<para role='indent'>
				Half-life in marine water sediment: <@com.value summary.KeyValueCsa.DegradationMarineSediment.HalfLifeMarineWaterSed/>
					<#if summary.KeyValueCsa.DegradationMarineSediment.Temperature?has_content>at <@com.value summary.KeyValueCsa.DegradationMarineSediment.Temperature/></#if>
			</para>
		</#if>
								
	<#elseif summary.documentSubType=="RouteDegWaterSed_EU_PPP"><#-- obsolete document -->
		<#if summary.KeyValueCsa.RouteDegradationFreshwater?has_content>
			<para>Route of degradation in freshwater:</para>
			<para role="small"><@degradationRouteSummaryTable path=summary.KeyValueCsa.RouteDegradationFreshwater bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.RouteDegradationMarineWater?has_content>
			<para>Route of degradation in marine water:</para>
			<para role="small"><@degradationRouteSummaryTable path=summary.KeyValueCsa.RouteDegradationMarineWater bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.RouteDegradationFreswaterSediment?has_content>
			<para>Route of degradation in freshwater sediment:</para>
			<para role="small"><@degradationRouteSummaryTable path=summary.KeyValueCsa.RouteDegradationFreswaterSediment bgcolor=bgcolor/></para>
		</#if>
		<#if summary.KeyValueCsa.RouteDegradationMarineWaterSediment?has_content>
			<para>Route of degradation in marine water sediment:</para>
			<para role="small"><@degradationRouteSummaryTable path=summary.KeyValueCsa.RouteDegradationMarineWaterSediment bgcolor=bgcolor/></para>
		</#if>
	
	<#-- definition of the residue -->
	<#elseif summary.documentSubType=="DefinitionResidueFate">
		<#if summary.KeyInformation[endpoint]?has_content>
			<para><emphasis role="bold">Definition of the residue:</emphasis></para>
			<para role="small"><@residueDefinitionSummaryTable path=summary.KeyInformation selectedEndpoint=endpoint bgcolor=bgcolor/></para>
		</#if>

	<#-- predicted concentrations environment summaries -->
	<#elseif summary.documentSubType?matches("EstConc.*") && summary.documentType=="FLEXIBLE_SUMMARY">
		<@estConcPEC summary=summary bgcolor=bgcolor/>

	<#else>
		<#-- call the general macro in studies and summaries -->
		<@studyandsummaryCom.fateCSAtable summaryList=summary bgcolor=bgcolor/>
	
	</#if>
	
</#macro>


<#-- fatePPPsummary prints a summary of the fate section for PPP (DEPRECATED)

	Inputs:
	- subject: entity
	- docSubType: str defining the document subtype 
	- endpoint: 'ResidueDefinitionRiskAssessment' or 'ResidueDefinitionMonitoring', 
		for the "DefinitionResidueFate" document

-->
<#macro fatePPPsummary subject docSubType endpoint="">
	<#compress>

		<#-- Get doc-->
		<#if docSubType=="DefinitionResidueFate">
			<#local summaryList = iuclid.getSectionDocumentsForParentKey(subject.documentKey, "FLEXIBLE_SUMMARY", docSubType) />
		<#else>
			<#local summaryList = iuclid.getSectionDocumentsForParentKey(subject.documentKey, "ENDPOINT_SUMMARY", docSubType) />
		</#if>

		<#-- Get metabolites-->
		<#if _metabolites?? && _metabolites?has_content>

			<#-- get a list of entities of same size as summaryList-->
			<#local entityList = []/>
			<#list summaryList as summary>
				<#local entityList = entityList + [subject.ChemicalName]/>
			</#list>

			<#-- add metabolites-->
			<#list _metabolites as metab>
				<#if docSubType=="DefinitionResidueFate">
					<#local metabSummaryList = iuclid.getSectionDocumentsForParentKey(metab.documentKey, "FLEXIBLE_SUMMARY", docSubType) />
				<#else>
					<#local metabSummaryList = iuclid.getSectionDocumentsForParentKey(metab.documentKey, "ENDPOINT_SUMMARY", docSubType) />
				</#if>
				<#if metabSummaryList?has_content>
					<#local summaryList = summaryList + metabSummaryList/>
					<#list metabSummaryList as metabSummary>
						<#local entityList = entityList + [metab.ChemicalName]/>
					</#list>
				</#if>
			</#list>
		</#if>

		<#-- Iterate-->
		<#if !summaryList?has_content>
			<@com.emptyLine/>
			<para>No summary information available for this section.</para>
			<@com.emptyLine/>
		<#else>
			<@com.emptyLine/>
			<para><emphasis role="HEAD-WoutNo">Summary</emphasis></para>

			<#local printSummaryName = summaryList?size gt 1 />

			<#list summaryList as summary>
				<@com.emptyLine/>

				<#if _metabolites?? && _metabolites?has_content &&
					 subject.ChemicalName!=entityList[summary_index] &&
				     entityList?seq_index_of(entityList[summary_index]) == summary_index>

					<para><emphasis role="underline">----- Metabolite <emphasis role="bold">${entityList[summary_index]}</emphasis> -----</emphasis></para>
					<@com.emptyLine/>
				</#if>

				<#if printSummaryName><para><emphasis role="bold">#${summary_index+1}: <@com.text summary.name/></emphasis></para></#if>

				<#--CSA path-->
				<#if summary.hasElement("KeyValueForCsa")>
					<#local csaPath=summary["KeyValueForCsa"]>
				<#elseif summary.hasElement("KeyValueForChemicalSafetyAssessment")>
					<#local csaPath=summary["KeyValueForChemicalSafetyAssessment"]>
				<#elseif summary.hasElement("KeyValueCsa")>
					<#local csaPath=summary["KeyValueCsa"]>
				</#if>

				<#--Key Information-->
				<#if summary.hasElement("KeyInformation") && summary.KeyInformation.KeyInformation?has_content>
					<para><emphasis role="bold">Key information: </emphasis></para>
					<para role="indent"><@com.richText summary.KeyInformation.KeyInformation/></para>
				</#if>

				<#--Links (only for cases with no standard table)-->
				<#if summary.hasElement("LinkToRelevantStudyRecord.Link") && summary.LinkToRelevantStudyRecord.Link?has_content>
					<para><emphasis role="bold">Link to relevant study records: </emphasis></para>
					<para role="indent">
						<#list summary.LinkToRelevantStudyRecord.Link as link>
							<#if link?has_content>
								<#local studyReference = iuclid.getDocumentForKey(link) />
								<para>
									<command  linkend="${studyReference.documentKey.uuid!}">
										<@com.text studyReference.name/>
									</command>
								</para>
							</#if>
						</#list>
					</para>
				</#if>

				<#--CSA-->
				<#if csaPath?? && csaPath?has_content>
					<@fateCSA summary/>
				</#if>

				<#--Discussion-->
				<#if summary.hasElement("Discussion") && summary.Discussion.Discussion?has_content>
					<para><emphasis role="bold">Discussion:</emphasis></para>
					<para role="indent"><@com.richText summary.Discussion.Discussion/></para>
				</#if>

			</#list>
		</#if>
	</#compress>
</#macro>

<#-- fatePPPsummary prints a summary of estimation of concentrations (EstConcSoil, EstConcGroundwater, EstConcWaterSed, EstConcOtherRoutes)
	(DEPRECATED)

	Inputs:
	- subject: entity
	- docSubType: str defining the document subtype 

-->
<#macro estConcSummary subject docSubType>
	<#compress>

		<#-- Get doc-->
		<#local summaryList = iuclid.getSectionDocumentsForParentKey(subject.documentKey, "FLEXIBLE_SUMMARY", docSubType) />


		<#-- Iterate-->
		<#if summaryList?has_content>
			<@com.emptyLine/>
			<para><emphasis role="HEAD-WoutNo">Summary</emphasis></para>

			<#assign printSummaryName = summaryList?size gt 1 />

			<#list summaryList as summary>
				<@com.emptyLine/>

				<#if printSummaryName><para><emphasis role="bold">#${summary_index+1}: <@com.text summary.name/></emphasis></para></#if>

				<#--Links (only for cases with no standard table)-->
				<#if summary.RelevantSummaries.InputSummaries?has_content>
					<para><emphasis role="bold">Link to relevant study records: </emphasis></para>
					<para role="indent">
						<#list summary.RelevantSummaries.InputSummaries as link>
							<#if link?has_content>
								<#local studyReference = iuclid.getDocumentForKey(link) />
								<para>
									<command  linkend="${studyReference.documentKey.uuid!}">
										<@com.text studyReference.name/>
									</command>
								</para>
							</#if>
						</#list>
					</para>
				</#if>

				<#--Key Information-->
				<#if summary.KeyInformation.field357?has_content>
					<para><emphasis role="bold">Key information: </emphasis></para>
					<para role="indent"><@com.richText summary.KeyInformation.field357/></para>
				</#if>

				<#--CSA-->
				<@estConcPEC summary/>

				<#--Discussion-->
				<#if summary.Discussion.Discussion?has_content>
					<para><emphasis role="bold">Discussion: </emphasis></para>
					<para role="indent"><@com.richText summary.Discussion.Discussion/></para>
				</#if>

			</#list>
		</#if>
	</#compress>
</#macro>

<#-- individual tables for CSA blocks -->
<#macro degradationRateSummaryTable path bgcolor="#FBDDA6">
	<#compress>

		<table border="1">

			<#if path[0].hasElement("TestConditions") && path[0].hasElement("SoilType")>
				<col width="20%" />
				<col width="8%" />
				<col width="8%" />
				<col width="8%" />
				<col width="6%" />
				<col width="6%" />
				<col width="6%" />
				<col width="6%" />
				<col width="6%" />
				<col width="6%" />
				<col width="9%" />
				<col width="10%" />
			<#elseif path[0].hasElement("Ph")>
				<col width="25%" />
				<col width="8%" />
				<col width="8%" />
				<col width="8%" />
				<col width="8%" />
				<col width="8%" />
				<col width="8%" />
				<col width="12%" />
				<col width="15%" />
			<#else>
				<col width="25%" />
				<col width="9%" />
				<col width="9%" />
				<col width="9%" />
				<col width="9%" />
				<col width="20%" />
				<col width="19%" />
			</#if>

			<thead align="center" valign="middle">
			<tr>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Substance</emphasis></th>
				<#if path[0].hasElement("TestConditions")><th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Test cond.</emphasis></th></#if>
				<#if path[0].hasElement("SoilType")>
					<th colspan="4"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Soil characteristics</emphasis></th>
				<#elseif path[0].hasElement("Ph")>
					<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">pH</emphasis></th>
					<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Temp.</emphasis></th>
				</#if>
				<th colspan="4"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Degradation results</emphasis></th>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Method of calculation</emphasis></th>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
			</tr>
			<tr>
				<#if path[0].hasElement("SoilType")>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">type</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">pH</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">% moist.</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Temp.</emphasis></th>
				</#if>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">DT50</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">DT90</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">f.f.</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">X2</emphasis></th>
			</tr>

			</thead>
			<tbody valign="middle">
			<#list path as item>
				<tr>
					<td>
						<#local substance=iuclid.getDocumentForKey(item.Substance)/>
						<#if substance?has_content>
							<@com.text substance.ChemicalName/>
						</#if>
						<#if item.ParentMetabolite?has_content>
							(<@com.picklist item.ParentMetabolite/>)
						</#if>
						<#local precursor=iuclid.getDocumentForKey(item.Precursor)/>
						<#if precursor?has_content>
							<para>precursor: <@com.text precursor.ChemicalName/></para>
						</#if>
					</td>
					<#if item.hasElement("TestConditions")><td><@com.picklist item.TestConditions/></td></#if>
					<#if item.hasElement("SoilType")><td><@com.text item.SoilType/></td></#if>
					<#if item.hasElement("Ph")>
						<td>
							<@com.number item.Ph/>
							<#if item.MeasuredIn?has_content>
								(<@com.text item.MeasuredIn/>)
							</#if>
						</td>
					</#if>
					<#if item.hasElement("SoilMoisture")><td><#if item.SoilMoisture?has_content><@com.quantity item.SoilMoisture/></#if></td></#if>
					<#if item.hasElement("Temperature")><td><@com.quantity item.Temperature/></td><#elseif item.hasElement("Teperature")><td><@com.quantity item.Teperature/></td></#if>
					<td>
						<#if item.hasElement("HalfLifeFreshWater")>
							<@com.quantity item.HalfLifeFreshWater/>
						<#elseif item.hasElement("HalfLifeSoil")>
							<@com.quantity item.HalfLifeSoil/>
						<#elseif item.hasElement("HalfLifeFreshwaterSediment")>
							<@com.quantity item.HalfLifeFreshwaterSediment/>
						</#if>
					</td>
					<td>
						<#if item.hasElement("DtNinetyFreshwater")>
							<@com.quantity item.DtNinetyFreshwater/>
						<#elseif item.hasElement("DtNinetySoil")>
							<@com.quantity item.DtNinetySoil/>
						<#elseif item.hasElement("DTNinetyFreshwaterSediment")>
							<@com.quantity item.DTNinetyFreshwaterSediment/>
						</#if>
					</td>
					<td><@com.number item.KineticFormationFraction/></td>
					<td><@com.number item.ChiSquare/></td>
					<td><@com.text item.CalculationMethod/>
						<#if item.KineticParameters?has_content>
							<para>kin. param:<@com.picklistMultiple item.KineticParameters/></para>
						</#if>

					</td>
					<td><@com.text item.Remarks/></td>
				</tr>
			</#list>
			</tbody>
		</table>

	</#compress>
</#macro>

<#macro modellingDegradationRateSummaryTable path bgcolor="#FBDDA6">

	<#compress>

		<table border="1">

		<#if path[0].hasElement("SoilType")>
			<col width="20%" />
			<col width="9%" />
			<col width="9%" />
			<col width="9%" />
			<col width="7%" />
			<col width="7%" />
			<col width="7%" />
			<col width="7%" />
			<col width="12%" />
			<col width="12%" />
		<#elseif path[0].hasElement("Ph")>
			<col width="26%" />
			<col width="12%" />
			<col width="10%" />
			<col width="10%" />
			<col width="10%" />
			<col width="16%" />
			<col width="16%" />
		<#else>
			<col width="26%" />
			<col width="14%" />
			<col width="10%" />
			<col width="10%" />
			<col width="20%" />
			<col width="20%" />
		</#if>

			<thead align="center" valign="middle">
			<tr>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Substance</emphasis></th>
				<#if path[0].hasElement("TestConditions")>
					<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Test cond.</emphasis></th>
				</#if>
				<#if path[0].hasElement("SoilType")>
					<th colspan="3"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Soil characteristics</emphasis></th>
				<#elseif path[0].hasElement("Ph")>
					<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">pH</emphasis></th>
				</#if>
				<th colspan="3"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Degradation results</emphasis></th>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Method of calculation</emphasis></th>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
			</tr>
			<tr>
				<#if path[0].hasElement("SoilType")>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">type</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">pH</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">% moist.</emphasis></th>
				</#if>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">norm. DT50</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">f.f.</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">X2</emphasis></th>
			</tr>

			</thead>
			<tbody valign="middle">
			<#list path as item>
				<tr>
					<td>
						<#local substance=iuclid.getDocumentForKey(item.Substance)/>
						<#if substance?has_content>
							<@com.text substance.ChemicalName/>
						</#if>
						<#if item.ParentMetabolite?has_content>
							(<@com.picklist item.ParentMetabolite/>)
						</#if>
						<#local precursor=iuclid.getDocumentForKey(item.Precursor)/>
						<#if precursor?has_content>
							<para>precursor: <@com.text precursor.ChemicalName/></para>
						</#if>
					</td>
					<#if item.hasElement("TestConditions")><td><@com.picklist item.TestConditions/></td></#if>
					<#if item.hasElement("SoilType")><td><@com.text item.SoilType/></td></#if>
					<#if item.hasElement("Ph")>
						<td>
						<@com.number item.Ph/>
						<#if item.MeasuredIn?has_content>
							(<@com.text item.MeasuredIn/>)
						</#if>
						</td>
					</#if>
					<#if item.hasElement("SoilMoisture")><td><#if item.SoilMoisture?has_content><@com.quantity item.SoilMoisture/>%</#if></td></#if>
					<td><@com.quantity item.NormalisedDtFifty/></td>
					<td><@com.number item.KineticFormationFraction/></td>
					<td><@com.number item.ChiSquare/></td>
					<td><@com.text item.CalculationMethod/>
						<#if item.KineticParameters?has_content>
							<para>kin. param:<@com.picklistMultiple item.KineticParameters/></para>
						</#if>
					</td>
					<td><@com.text item.Remarks/></td>
				</tr>
			</#list>
			</tbody>
		</table>

	</#compress>
</#macro>

<#macro keyValueCSASummaryTable path bgcolor="#FBDDA6">

	<#compress>

		<table border="1">

			<col width="30%" />
			<col width="15%" />
			<col width="15%" />
			<col width="15%" />
			<col width="25%" />


			<thead align="center" valign="middle">
			<tr>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Substance</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Half-life (DT50) in soil</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Mean formation fraction</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">pH dependence</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
			</tr>

			</thead>
			<tbody valign="middle">
			<#list path as item>
				<tr>
					<td>
						<#local substance=iuclid.getDocumentForKey(item.Substance)/>
						<#if substance?has_content>
							<@com.text substance.ChemicalName/>
						</#if>
						<#if item.ParentMetabolite?has_content>
							(<@com.picklist item.ParentMetabolite/>)
						</#if>
					</td>
					<td><@com.quantity item.HalfLifeSoil/></td>
					<td><@com.number item.FormationFraction/></td>
					<td><@com.picklist item.PhDependence/></td>
					<td><@com.text item.Remarks/></td>
				</tr>
			</#list>
			</tbody>
		</table>

	</#compress>
</#macro>

<#macro degradationRouteSummaryTable path bgcolor="#FBDDA6">

	<#compress>

		<table border="1">

            <#if path[0].hasElement("TestConditions")>
                <col width="20%" />
                <col width="11%" />
                <col width="11%" />
                <col width="11%" />
                <col width="11%" />
                <col width="8%" />
                <col width="8%" />
                <col width="8%" />
                <col width="14%" />
            <#else>
                <col width="24%" />
                <col width="11%" />
                <col width="11%" />
                <col width="11%" />
                <col width="10%" />
                <col width="10%" />
                <col width="10%" />
                <col width="15%" />
            </#if>

			<thead align="center" valign="middle">
			<tr>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Substance</emphasis></th>
				<#if path[0].hasElement("TestConditions")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Test cond.</emphasis></th></#if>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Duration</emphasis></th>
				<#if path[0].hasElement("NumberSoils")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">No. soils</emphasis></th></#if>
                <#if path[0].hasElement("Ph")><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">pH</emphasis></th></#if>
                <th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Radio label</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Mineralis.</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Non extr. residues</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Max. occurrence</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
			</tr>

			</thead>
			<tbody valign="middle">
			<#list path as item>
				<tr>
					<td>
						<#local substance=iuclid.getDocumentForKey(item.Substance)/>
						<#if substance?has_content>
							<@com.text substance.ChemicalName/>
						</#if>
						<#if item.ParentMetabolite?has_content>
							(<@com.picklist item.ParentMetabolite/>)
						</#if>
					</td>
					<#if item.hasElement("TestConditions")>
                        <td>
                            <@com.picklist item.TestConditions/>
                            <#if item.SterileConditions?has_content>
                                (sterile conditions)
                            </#if>
                        </td>
                    </#if>
					<td><#if item.ActualDuration?has_content><@com.number item.ActualDuration/>d</#if></td>
					<#if item.hasElement("NumberSoils")><td><@com.number item.NumberSoils/></td></#if>
					<#if item.hasElement("Ph")><td><@com.number item.Ph/></td></#if>
					<td><@com.text item.RadioLabel/></td>
					<td><#if item.Mineralisation?has_content><@com.range item.Mineralisation/>%</#if></td>
					<td><#if item.NonExtractableResidues?has_content><@com.range item.NonExtractableResidues/>%</#if></td>
					<td>
						<#if item.MaximumOccurrence?has_content>
							<@com.number item.MaximumOccurrence/>%
						</#if>
						<#if item.DayMaximumOccurence?has_content>
							at <@com.number item.DayMaximumOccurence/>d
						</#if>
					</td>
					<td><@com.text item.Remarks/></td>
				</tr>
			</#list>
			</tbody>
		</table>

	</#compress>
</#macro>

<#macro residueDefinitionSummaryTable path selectedEndpoint bgcolor="#FBDDA6">
	<#compress>

		<table border="1">

			<#if !(selectedEndpoint?has_content) || path[selectedEndpoint][0].hasElement("LinkToValidatedMethod")>
				<col width="20%" />
				<col width="20%" />
				<col width="20%" />
				<col width="40%" />
			</#if>

			<thead align="center" valign="middle">
			<tr>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Compartment</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Residue definition</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Residue components</emphasis></th>
				<#if !(selectedEndpoint?has_content) || path[selectedEndpoint][0].hasElement("LinkToValidatedMethod")>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Other information</emphasis></th>
				</#if>
			</tr>
			</thead>

			<tbody valign="middle">

			<#list path[selectedEndpoint] as item>
				<tr>
					<td><@com.picklist item.Compartment/></td>
					<td>
						<#if item.hasElement("ResidueDefinitionMonitoring") && item.ResidueDefinitionMonitoring?has_content>
							<para><@com.text item.ResidueDefinitionMonitoring/></para>
						</#if>
						<#if item.hasElement("ResidueDefinitionRisk") && item.ResidueDefinitionRisk?has_content>
							<para><@com.text item.ResidueDefinitionRisk/></para>
						</#if>
					</td>
					<td>
						<#if item.hasElement("ResidueDefinitionRiskComp")>
							<#local compPath=item.ResidueDefinitionRiskComp/>
						<#elseif item.hasElement("ResidueDefinitionMonitoringComp")>
							<#local compPath=item.ResidueDefinitionMonitoringComp/>
						</#if>

						<#list compPath as link>
							<#if link?has_content>
								<#local comp = iuclid.getDocumentForKey(link) />
								<para>
									<@com.text comp.ReferenceSubstanceName/>
								</para>
							</#if>
						</#list>
					</td>

					<#if item.hasElement("LinkToValidatedMethod")>
						<td>
							<#if item.hasElement("MonitoringResidueDefinitionLoq") && item.MonitoringResidueDefinitionLoq?has_content>
								<para>LOQ: <@com.value item.MonitoringResidueDefinitionLoq/></para>
							</#if>
							<#if item.hasElement("LinkToValidatedMethod") && item.LinkToValidatedMethod?has_content>
								<para>Validated method:
									<#list item.LinkToValidatedMethod as link>
										<#if link?has_content>
											<#local method = iuclid.getDocumentForKey(link) />
											<command linkend="${method.documentKey.uuid!}">
												<@com.text method.name ""/><#if link?has_next>; </#if>
											</command>
										</#if>	
									</#list>	
								</para>
							</#if>
						</td>
					</#if>
				</tr>
			</#list>

			</tbody>
		</table>

	</#compress>
</#macro>


<#--
	estConcPEC prints the PEC section of estimation of concentrations summaries
	(EstConcSoil, EstConcGroundwater, EstConcWaterSed, EstConcOtherRoutes)
	
	Inputs:
	- summary: summary document object
-->
<#macro estConcPEC summary bgcolor="#FBDDA6">
	<#compress>

	<#--CSA-->
	<#if summary.hasElement("PECOtherRoutes.PECOtherRoutesRep") && summary.PECOtherRoutes.PECOtherRoutesRep?has_content>
		<para><emphasis role="bold">PEC from other routes of exposure:</emphasis></para>
		<para role="small"><@pecOtherRoutesSummaryTable path=summary.PECOtherRoutes.PECOtherRoutesRep bgcolor=bgcolor/></para>

	<#elseif summary.hasElement("PecSoil") && summary.PecSoil?has_content>
		<para><emphasis role="bold">PEC from soil:</emphasis></para>

		<@com.children summary.PecSoil/>

		<#if summary.PecSoil.PecSoilMgkg?has_content>
			<para>PEC:</para>
			<para role="small"><@pecSoilSummaryTable path=summary.PecSoil.PecSoilMgkg bgcolor=bgcolor/></para>
		</#if>
	<#elseif summary.hasElement("PecGroundWater") && summary.PecGroundWater?has_content>
		<para><emphasis role="bold">PEC from ground water:</emphasis></para>

		<@com.children summary.PecGroundWater/>

		<#if summary.PecGroundWater.PecGroundWater?has_content>
			<para>PEC:</para>
			<para role="small"><@pecGroundWaterSummaryTable path=summary.PecGroundWater.PecGroundWater bgcolor=bgcolor/></para>
		</#if>
	<#elseif summary.hasElement("PecSurfaceWaterPecSediment") && summary.PecSurfaceWaterPecSediment?has_content>
		<para><emphasis role="bold">PEC from surface water and sediment:</emphasis></para>

		<@com.children summary.PecSurfaceWaterPecSediment/>

		<#if summary.PecSurfaceWaterPecSediment.FocusStepOneTwoList?has_content>
			<para>FOCUS step 1 and 2:</para>
			<para role="small"><@pecSurfaceWaterSedimentSummaryTable path=summary.PecSurfaceWaterPecSediment.FocusStepOneTwoList bgcolor=bgcolor/></para>
		</#if>

		<#if summary.PecSurfaceWaterPecSediment.FocusStepThreeList?has_content>
			<para>FOCUS step 3:</para>
			<para role="small"><@pecSurfaceWaterSedimentSummaryTable path=summary.PecSurfaceWaterPecSediment.FocusStepThreeList bgcolor=bgcolor/></para>
		</#if>

		<#if summary.PecSurfaceWaterPecSediment.FocusStepFour?has_content>
			<para>FOCUS step 4:</para>
			<para role="small"><@pecSurfaceWaterSedimentSummaryTable path=summary.PecSurfaceWaterPecSediment.FocusStepFour bgcolor=bgcolor/></para>
		</#if>
	</#if>

	</#compress>
</#macro>

<#-- tables for PEC sections -->
<#macro pecOtherRoutesSummaryTable path bgcolor="#FBDDA6">

	<#compress>

		<table border="1">

			<col width="23%" />
			<col width="23%" />
			<col width="22%" />
			<col width="22%" />
			<col width="10%" />


			<thead align="center" valign="middle">
			<tr>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Substance</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Uses</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Route of exposure</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Method of calculation</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">PEC</emphasis></th>
			</tr>

			</thead>
			<tbody valign="middle">
			<#list path as item>
				<tr>
					<td>
						<#local substance=iuclid.getDocumentForKey(item.Substance)/>
						<#if substance?has_content>
							<#if substance.documentType=="SUBSTANCE">
								<@com.text substance.ChemicalName ""/>
							<#elseif substance.documentType=="REFERENCE_SUBSTANCE">
								<@com.text substance.ReferenceSubstanceName ""/>
							</#if>
						</#if>
						<#if item.ParentMetabolite?has_content>
							(<@com.picklist item.ParentMetabolite/>)
						</#if>
					</td>
					<td>
						<#list item.UseDescription as gaplink>
							<#if gaplink?has_content>
								<#local gap=iuclid.getDocumentForKey(gaplink)/>
								<para><@com.text gap.name ""/></para>
							</#if>
						</#list>
					</td>
					<td><@com.text item.RouteOfExposure/></td>
					<td><@com.text item.MethodOfCalculation/></td>
					<td><@com.quantity item.PEC/></td>
				</tr>
			</#list>
			</tbody>
		</table>

	</#compress>
</#macro>

<#macro pecSoilSummaryTable path bgcolor="#FBDDA6">

	<#compress>

		<table border="1">

			<col width="18%" />
			<col width="20%" />
			<col width="15%" />
			<col width="16%" />
			<col width="16%" />
			<col width="15%" />


			<thead align="center" valign="middle">
			<tr>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Substance</emphasis></th>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Uses</emphasis></th>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Timing</emphasis></th>
				<th colspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Application</emphasis></th>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
			</tr>
			<tr>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Single</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Multiple</emphasis></th>
			</tr>

			</thead>
			<tbody valign="middle">
			<#list path as item>
				<tr>
					<td>
						<#local substance=iuclid.getDocumentForKey(item.Substance)/>
						<#if substance?has_content>
							<@com.text substance.ReferenceSubstanceName/>
						</#if>
						<#if item.ParentMetabolite?has_content>
							(<@com.picklist item.ParentMetabolite/>)
						</#if>
					</td>
					<td>
						<#list item.UseDescription as gaplink>
							<#if gaplink?has_content>
								<#local gap=iuclid.getDocumentForKey(gaplink)/>
								<para><@com.text gap.name/></para>
							</#if>
						</#list>
					</td>
					<td><@com.picklist item.Timing/></td>
					<td>
						<para><#if item.SingleApplicationActual?has_content><@com.range item.SingleApplicationActual/> (actual)</#if></para>
						<para><#if item.SingleApplicationTimeWa?has_content><@com.range item.SingleApplicationTimeWa/> (time weighted average)</#if></para>
					</td>
					<td>
						<para><#if item.MultipleApplicationActual?has_content><@com.range item.MultipleApplicationActual/> (actual)</#if></para>
						<para><#if item.MultipleApplicationTimeWa?has_content><@com.range item.MultipleApplicationTimeWa/> (time weighted average)</#if></para>
					</td>
					<td>
						<@com.text item.Remarks/>
					</td>
				</tr>
			</#list>
			</tbody>
		</table>

	</#compress>
</#macro>

<#macro pecGroundWaterSummaryTable path bgcolor="#FBDDA6">

<#compress>

	<table border="1">

		<col width="18%" />
		<col width="17%" />
		<col width="13%" />
		<col width="13%" />
		<col width="13%" />
		<col width="13%" />
		<col width="13%" />

		<thead align="center" valign="middle">
		<tr>
			<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Substance</emphasis></th>
			<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Uses</emphasis></th>
			<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Tier</emphasis></th>
			<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Model</emphasis></th>
			<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Scenario</emphasis></th>
			<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">PEC</emphasis></th>
			<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
		</tr>
		</thead>
		<tbody valign="middle">
		<#list path as item>
			<tr>
				<td>
					<#local substance=iuclid.getDocumentForKey(item.Substance)/>
					<#if substance?has_content>
						<#if substance.documentType=="SUBSTANCE">
							<@com.text substance.ChemicalName/>
						<#elseif substance.documentType=="REFERENCE_SUBSTANCE">
							<@com.text substance.ReferenceSubstanceName/>
						</#if>
					</#if>
					<#if item.ParentMetabolite?has_content>
						(<@com.picklist item.ParentMetabolite/>)
					</#if>
				</td>
				<td>
					<#list item.UseDescription as gaplink>
						<#if gaplink?has_content>
							<#local gap=iuclid.getDocumentForKey(gaplink)/>
							<para><@com.text gap.name/></para>
						</#if>
					</#list>
				</td>
				<td><@com.text item.Tier/></td>
				<td><@com.picklist item.Model/></td>
				<td><@com.picklist item.Scenario/></td>
				<td><@com.range item.Pecgw/></td>
				<td><@com.text item.Remarks/></td>
			</tr>
		</#list>
		</tbody>
	</table>

	</#compress>
</#macro>

<#macro pecSurfaceWaterSedimentSummaryTable path bgcolor="#FBDDA6">

	<#compress>

		<table border="1">

<#--			<col width="20%" />-->
<#--			<col width="20%" />-->
<#--			<col width="15%" />-->
<#--			<col width="15%" />-->
<#--			<col width="15%" />-->
<#--			<col width="15%" />-->

			<thead align="center" valign="middle">
			<tr>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if>Substance<emphasis role="bold"></emphasis></th>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if>Uses<emphasis role="bold"></emphasis></th>
				<#if path[0].hasElement("Step")><th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Step</emphasis></th></#if>
				<#if path[0].hasElement("FocusScenario")><th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Focus scenario</emphasis></th></#if>
				<#if path[0].hasElement("DominantRouteOfEntry")><th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Dominant route entry</emphasis></th></#if>
				<#if path[0].hasElement("WaterBody")><th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Water body</emphasis></th></#if>
				<#if path[0].hasElement("RiskMitigationMeasures")><th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Risk mitigation meas.</emphasis></th></#if>
				<#if path[0].hasElement("DayAfterOverallMaximum")><th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Day after ov. max.</emphasis></th></#if>
				<th colspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">PEC</emphasis></th>
				<th rowspan="2"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>


			</tr>
			<tr>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Surface water</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Sediment</emphasis></th>
			</tr>
			</thead>
			<tbody valign="middle">
			<#list path as item>
				<tr>
					<td>
						<#local substance=iuclid.getDocumentForKey(item.Substance)/>
						<#if substance?has_content>
							<#if substance.documentType=="SUBSTANCE">
								<@com.text substance.ChemicalName/>
							<#elseif substance.documentType=="REFERENCE_SUBSTANCE">
								<@com.text substance.ReferenceSubstanceName/>
							</#if>
						</#if>						
						<#if item.ParentMetabolite?has_content>
							(<@com.picklist item.ParentMetabolite/>)
						</#if>
					</td>
					<td>
						<#list item.UseDescription as gaplink>
							<#if gaplink?has_content>
								<#local gap=iuclid.getDocumentForKey(gaplink)/>
								<para><@com.text gap.name/></para>
							</#if>
						</#list>
					</td>
					<#if path[0].hasElement("Step")><td><@com.picklist item.Step/></td></#if>
					<#if path[0].hasElement("FocusScenario")><td><@com.picklist item.FocusScenario/></td></#if>
					<#if path[0].hasElement("DominantRouteOfEntry")><td><@com.picklist item.DominantRouteOfEntry/></td></#if>
					<#if path[0].hasElement("WaterBody")><td><@com.picklist item.WaterBody/></td></#if>
					<#if path[0].hasElement("RiskMitigationMeasures")><td><@com.picklist item.RiskMitigationMeasures/></td></#if>
					<#if path[0].hasElement("DayAfterOverallMaximum")><td><@com.quantity item.DayAfterOverallMaximum/></td></#if>
					<td>
						<#if item.MaxPecsw?has_content><para>Max: <@com.range item.MaxPecsw/></para></#if>
						<#if item.TwaPecsw?has_content><para>TWA: <@com.range item.TwaPecsw/></para></#if>
					</td>
					<td>
						<#if item.MaxPecsw?has_content><para>Max: <@com.range item.ActualPecsed/></para></#if>
						<#if item.TwaPecsw?has_content><para>TWA: <@com.range item.TwaPecsed/></para></#if>
					</td>
					<td><@com.text item.Remarks/></td>
				</tr>
			</#list>
			</tbody>
		</table>

	</#compress>
</#macro>

<#-- transformationProductsSummaryTable generates an HTML table from the transformation products block of some 
	summaries e.g. biodegradation in soil, field studies, and biodegradation in water and sediment.

	The columns are transformation product, compartment (if it exists), kinetic formation fraction, maximum occurrence, and linked studies. 
	If the compartment column exists, the table has five columns, and if not, it has four columns.

	If more than one summary is passed to the macro, all transformation products from all summaries are put together into 
	the same table. If summaries with compartment and without are put together, "soil" is automatically taken for the compartment of
	biodegradation in soil and field studies.

	Inputs:
	- summaryList: single summary or list of summary documents with transformation products blocks
-->
<#macro transformationProductsSummaryTable summaryList bgcolor="#FBDDA6">
	<#compress>

	<#-- transform to sequence if it's not -->
	<#if !summaryList?is_sequence>
		<#local summaryList=[summaryList]/>
	</#if>

	<#-- NOTE: a hash could be created to be able to sort results -->

	<#-- make a condition to check if the trProducts block exists and add the compartment column (only in biodegradation in water) -->
	<#local compartmentExists=false/>
	<#local trProductsExist=false/>
	<#list summaryList as summary>
		<#if summary.hasElement('InformationOnTransformationProducts.InformationOnTransformationProducts')>
			<#local trProductsExist=true/>
			<#list summary.InformationOnTransformationProducts.InformationOnTransformationProducts as block>
				<#if block.hasElement("Compartment")>
					<#local compartmentExists=true/>
					<#break>
				</#if>
			</#list>
		</#if>
	</#list>

	<#if trProductsExist>
		<#-- make table header -->
		<table border="1">

			<#if compartmentExists>
				<col width="25%" />
				<col width="20%" />
				<col width="15%" />
				<col width="15%" />
				<col width="25%" />
			<#else>
				<col width="30%" />
				<col width="15%" />
				<col width="15%" />
				<col width="40%" />
			</#if>
			

			<thead align="center" valign="middle">
			<tr>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Transformation product</emphasis></th>
				<#if compartmentExists><th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Compartment</emphasis></th></#if>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Kinetic formation fraction</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Maximum occurrence</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Linked studies</emphasis></th>
			</tr>

			</thead>
			<tbody valign="middle">

			<#-- populate table -->
			<#list summaryList as summary>
				<#list summary.InformationOnTransformationProducts.InformationOnTransformationProducts as item>
					<tr>
						<td>
							<#local substance=iuclid.getDocumentForKey(item.IdentityOfTheTransformationProduct)/>
							<#if substance?has_content>
								<@com.text substance.ReferenceSubstanceName/>
							</#if>
						</td>
						<#if compartmentExists>
							<td>
								<#if item.hasElement("Compartment")>
									<@com.value item.Compartment/>
								<#else>
									soil
								</#if>
							</td>
						</#if>
						<td>
							<@com.value item.KineticFormationFraction/>
						</td>
						<td>
							<@com.value item.MaximumOccurrence/>
						</td>
						<td>
							${studyandsummaryCom.getSummaryLinks(item, ['LinkToRelevantStudyRecord'])}
						</td>
					</tr>
				</#list>
			</#list>
			</tbody>
		</table>
	</#if>
	
	</#compress>
</#macro>

<#-- relevantMetabolitesGroundWater outputs the contents of the FLEXIBLE_SUMMARY.RelevantMetabolitesGroundWater document

	Inputs:
	- summary: document to be printed
-->	
<#macro relevantMetabolitesGroundWater summary>

	<#if summary?has_content>

		<#local style = "background-color:#f7f7f7"/>

		<#if _section=="Ecotox"> <#-- Used to compile Biological activity of metabolites potentially occurring in groundwater section  -->
			<#-- Step 1: Exclusion of degradation products of no concern -->
			<#if summary.hasElement("DescriptionKeyInfo.StepOne.field8430") && summary.DescriptionKeyInfo.StepOne.field8430?has_content>
				<para style="${style}"><emphasis role="bold">Step 1: Exclusion of degradation products of no concern</emphasis>: <@com.value summary.DescriptionKeyInfo.StepOne.field8430/></para>
			</#if>

			<#-- Step 2: Quantification of potential groundwater contamination -->
			<#if summary.hasElement("DescriptionKeyInfo.StepTwo.field247") && summary.DescriptionKeyInfo.StepTwo.field247?has_content>
				<para style="${style}"><emphasis role="bold">Step 2: Quantification of potential groundwater contamination</emphasis>: <@com.value summary.DescriptionKeyInfo.StepTwo.field247/></para>
			</#if>

			<#-- Stage 1 of Step 3: Screening for biological activity -->
			<#if summary.hasElement("DescriptionKeyInfo.StageOneStepThree.field3368") && summary.DescriptionKeyInfo.StageOneStepThree.field3368?has_content>
				<para style="${style}"><emphasis role="bold">Stage 1 of Step 3: Screening for biological activity</emphasis>: <@com.value summary.DescriptionKeyInfo.StageOneStepThree.field3368/></para>
			</#if>
		<#else>

			<#-- Step 1: Exclusion of degradation products of no concern -->
			<#if summary.hasElement("DescriptionKeyInfo.StepOne.field8430") && summary.DescriptionKeyInfo.StepOne.field8430?has_content>
				<para style="${style}"><emphasis role="bold">Step 1: Exclusion of degradation products of no concern</emphasis>: <@com.value summary.DescriptionKeyInfo.StepOne.field8430/></para>
			</#if>

			<#-- Step 2: Quantification of potential groundwater contamination -->
			<#if summary.hasElement("DescriptionKeyInfo.StepTwo.field247") && summary.DescriptionKeyInfo.StepTwo.field247?has_content>
				<para style="${style}"><emphasis role="bold">Step 2: Quantification of potential groundwater contamination</emphasis>: <@com.value summary.DescriptionKeyInfo.StepTwo.field247/></para>
			</#if>

			<#-- Stage 1 of Step 3: Screening for biological activity -->
			<#if summary.hasElement("DescriptionKeyInfo.StageOneStepThree.field3368") && summary.DescriptionKeyInfo.StageOneStepThree.field3368?has_content>
				<para style="${style}"><emphasis role="bold">Stage 1 of Step 3: Screening for biological activity</emphasis>: <@com.value summary.DescriptionKeyInfo.StageOneStepThree.field3368/></para>
			</#if>

			<#-- Stage 2 of Step 3: Screening for genotoxicity -->
			<#if summary.hasElement("DescriptionKeyInfo.StageTwoStepThree.field957") && summary.DescriptionKeyInfo.StageTwoStepThree.field957?has_content>
				<para style="${style}"><emphasis role="bold">Stage 2 of Step 3: Screening for genotoxicity</emphasis>: <@com.value summary.DescriptionKeyInfo.StageTwoStepThree.field957/></para>
			</#if>

			<#-- Stage 3 of Step 3: Screening for toxicity -->
			<#if summary.hasElement("DescriptionKeyInfo.StageThreeStepThree.field2883") && summary.DescriptionKeyInfo.StageThreeStepThree.field2883?has_content>
				<para style="${style}"><emphasis role="bold">Stage 3 of Step 3: Screening for toxicity</emphasis>: <@com.value summary.DescriptionKeyInfo.StageThreeStepThree.field2883/></para>
			</#if>

			<#-- Step 4: Exposure assessment - threshold of concern approach -->
			<#if summary.hasElement("DescriptionKeyInfo.StepFour.field992") && summary.DescriptionKeyInfo.StepFour.field992?has_content>
				<para style="${style}"><emphasis role="bold">Step 4: Exposure assessment - threshold of concern approach</emphasis>: <@com.value summary.DescriptionKeyInfo.StepFour.field992/></para>
			</#if>

			<#-- Step 5: Refined risk assessments for non-relevant metabolites -->
			<#if summary.hasElement("DescriptionKeyInfo.StepFive.field9341") && summary.DescriptionKeyInfo.StepFive.field9341?has_content>
				<para style="${style}"><emphasis role="bold">Step 5: Refined risk assessments for non-relevant metabolites</emphasis>: <@com.value summary.DescriptionKeyInfo.StepFive.field9341/></para>
			</#if>

			<#-- Link to relevant biodegradation studies -->
			<#if summary.hasElement("AdministrativeDataSummary.RelevantBiodegradationStudies") && summary.AdministrativeDataSummary.RelevantBiodegradationStudies?has_content>
				<para><emphasis role="bold">Link to relevant biodegradation studies</emphasis>:
					<#list summary.AdministrativeDataSummary.RelevantBiodegradationStudies as reference>
						<#local studyLink = com.getStudyLink(reference)/>
						${studyLink}<#if reference?has_next>; </#if>	
					</#list>	
				</para>
			</#if> 

			<#-- Link to relevant lysimeter studies -->
			<#if summary.hasElement("AdministrativeDataSummary.RelevantLysimeterStudies") && summary.AdministrativeDataSummary.RelevantLysimeterStudies?has_content>
				<para><emphasis role="bold">Link to relevant lysimeter studies</emphasis>:
					<#list summary.AdministrativeDataSummary.RelevantLysimeterStudies as reference>
						<#local studyLink = com.getStudyLink(reference)/>
						${studyLink}<#if reference?has_next>; </#if>	
					</#list>	
				</para>
			</#if>
		</#if>
		<@com.emptyLine/>  
	</#if>
</#macro>
