<#-- This FTL contains macros to output content in documents related with microbial pesticides, namely:
        - FLEXIBLE_RECORD.BioPropertiesMicro (Document M (a.s.) - section 2 for microbial PPP)
        - ENDPOINT_STUDY_RECORD.EffectivenessAgainstTargetOrganisms (Document M (a.s. and product) - section 3)
        - ENDPOINT_SUMMARY.EffectivenessAgainstTargetOrganisms (Document M (a.s. and product) - section 3)
        - ENDPOINT_STUDY_RECORD.ToxicityToOtherAboveGroundOrganisms (Document M (a.s.) - section 2 for microbial PPP)
        - ENDPOINT_SUMMARY.ToxicityToOtherAboveGroundOrganisms (Document M (a.s.) - section 2 for microbial PPP)
-->     

<#-- BioPropMicroSection outputs sections of the FLEXIBLE_RECORD.BioPropertiesMicro document, 
    based on the path provided. It iterates over the children of the provided path and prints the label
    and the content.
    
    It should be used for L2 sections (L3 in case of subsections of General information on the microorganism).

    Inputs:
    - path: str containing the path in the document FLEXIBLE_RECORD.BioPropertiesMicro
    - exclude: list containing paths to exclude from the output e.g. Reference
-->
<#macro BioPropMicroSection path exclude=[]>

    <#compress>

        <#-- list of paths to exclude from the output: it is the reference block plus additional ones from the macro call -->
        <#local exclude = exclude + ["Reference", "DataAccess", "DataProtectionClaimed"]/>
        
        <#-- get doc and iterate -->
        <#local docs=iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "FLEXIBLE_RECORD", "BioPropertiesMicro")/>
        <#list docs as doc>
            
            <#-- print name of document if more than 1
                NOTE: probably more than one document should NOT be allowed
            -->
            <#local docUrl=iuclid.webUrl.documentView(doc.documentKey) />
            <#if (docs?size>1)><para><emphasis role="underline">#${doc_index+1}: <ulink url="${docUrl}"><@com.text doc.name ""/></ulink></emphasis></para></#if>
			
            <#-- get the path -->
            <#local combinedPath="doc."+path/>
			<#local docPath=combinedPath?eval/>
            
            <#-- iterate through the path elements -->
            <#list docPath?children as child>  

                <#-- print only if not in the list of paths to exclude-->
                <#if !exclude?seq_contains(child?node_name) && child?has_content>
                    
                    <#-- get the label -->
                    <@iuclid.label for=child var="fieldLabel"/>

                    <#-- consider special cases 
                        - literature search block
                        - phylogenetic tree
                    -->
                    <#if child?node_name == "SupportingLiteratureSearchesIfRelevant">

                        <@LitSearchBlock child/>
                    
                    <#elseif child?node_name == "PhylogenicTree">
                        
                        <para>${fieldLabel}:</para>
                        <@com.printImage attachmentPath=child imageWidthPerc=70 printTitle=false informal=true url=docUrl printMetaDataIfNotImage=true/>

                    <#else>
                        <#-- print (with grey background in the case of rich text) -->
                        <#if child?node_type == "multilingual_text_html"><para style="background-color:#f7f7f7"><#else><para></#if>
                            <#if fieldLabel?has_content>${fieldLabel}:</#if>
                            <#-- print the content -->
                            <@com.value child 'literal'/>
                        </para>
                    </#if>

                </#if>
            </#list>
			
            <#if combinedPath != "doc.SupportingLiteratureSearchesIfRelevant">
                <#-- print the reference -->
                <#if docPath.hasElement("Reference") && docPath.Reference?has_content>
                    <para>Reference(s):</para>
                    <#list docPath.Reference as refKey>
                        <#local ref = iuclid.getDocumentForKey(refKey) />
                        <#local refUrl=iuclid.webUrl.documentView(ref.documentKey) />
                        <para role="indent">
                            <ulink url="${refUrl}">
                                <@com.value ref.GeneralInfo.Name ""/>,
                                <#if ref.GeneralInfo.Author?has_content><@com.value ref.GeneralInfo.Author ""/>,</#if>							
                                <@com.value ref.GeneralInfo.ReferenceYear/>	      
                                <#if ref.GeneralInfo.ReportNo?has_content>(Report No: <@com.value ref.GeneralInfo.ReportNo ""/>)</#if>
                                <#if ref.GeneralInfo.LiteratureType?has_content>[<@com.value ref.GeneralInfo.LiteratureType/>]</#if>    
                            </ulink>      		
                        </para>
                    </#list>
                </#if>
            </#if>
                  
	        <@com.emptyLine/>

        </#list>
    </#compress>
</#macro>

<#--BLOCKS-->

<#-- LitSearchBlock outputs the literature search repeatable block from the FLEXIBLE_RECORD.BioPropertiesMicro document.
    
    Inputs:
    - litBlock: field object from the document FLEXIBLE_RECORD.BioPropertiesMicro 
-->
<#macro LitSearchBlock litsearch>

    <#local litsearchDoc=iuclid.getDocumentForKey(litsearch.LiteratureSearch)/>

    <para role='indent'>
        <para><command linkend="${litsearchDoc.documentKey.uuid!}"><@com.text litsearchDoc.name ""/></command>
        <#if litsearch.Remarks?has_content>: <@com.value litsearch.Remarks/></#if></para>
    </para>

</#macro>

<#-- generalInfo_effectivenessTargetOrg outputs the general information section of the ENDPOINT_STUDY_RECORD.EffectivenessAgainstTargetOrganisms
    document.
    The structure of the output follows the ToC of the microbial PPP a.s.
    
    Inputs:
    - study: document of type ENDPOINT_STUDY_RECORD.EffectivenessAgainstTargetOrganisms
    -->
<#macro generalInfo_effectivenessTargetOrg study>

    <#local gen=study.GeneralInformation/>

    <#--  3.1 Use of the active substance-->
    <#if gen.BackgroundInformation?has_content>
        <para><emphasis role="bold">Background</emphasis></para>
        <para role="indent"><@com.value gen.BackgroundInformation 'literal'/></para>
    </#if>

    <#--  3.2 Function (including also product type...) -->
    <#local use=gen.InformationOnIntendedUseAndApplication/>
    <#if use.FunctionAddressed?has_content || use.ProductType?has_content>
        <para><emphasis role="bold">Function</emphasis></para>

        <#if use.FunctionAddressed?has_content>
            <para role="indent"><@com.value use.FunctionAddressed 'literal'/></para>
        </#if>

        <#if use.ProductType?has_content>
            <para role="indent">Product type: <@com.value use.ProductType 'literal'/></para>
        </#if>
    </#if>

    <#--  3.3 Effects on harmful organisms -->
    <#local eff=gen.GeneralInformationOnEffectiveness/>

    <#if eff.EffectsOnTargetOrganisms?has_content>
        <para><emphasis role="bold">Effects on harmful organisms</emphasis></para>
        <para role="indent"><@com.value eff.EffectsOnTargetOrganisms 'literal'/></para>
    </#if>

    <#--  3.4 Field of use envisaged -->
    <#if use.FieldOfUseEnvisagedUser?has_content>
        <para><emphasis role="bold">Field of use envisaged</emphasis></para>
        <para role="indent"><@com.value use.FieldOfUseEnvisagedUser 'literal'/></para>
    </#if>

    <#--  3.5 Harmful organisms controlled and crops or products protected or treated -->
    <#if gen.PestTargetOrganismsToBeControlled?has_content || gen.ProductsOrganismsOrObjectsToBeProtectedUnderStudy?has_content>

        <para><emphasis role="bold">Harmful organisms controlled and crops or products protected or treated</emphasis></para>

        <#if gen.PestTargetOrganismsToBeControlled.TargetOrganisms?has_content>
            <para role="indent"><emphasis role="underline">List of target organisms:</emphasis></para>
            <@targetOrganismsList gen.PestTargetOrganismsToBeControlled.TargetOrganisms "indent2"/>
            <@com.emptyLine/>
        </#if>

        <#if gen.ProductsOrganismsOrObjectsToBeProtectedUnderStudy.OrganismsToBeProtectedOrTreatedMaterials?has_content>
            <para role="indent"><emphasis role="underline">Crops or products protected or treated:</emphasis></para>
            <para role="indent2"><@com.value gen.ProductsOrganismsOrObjectsToBeProtectedUnderStudy.OrganismsToBeProtectedOrTreatedMaterials 'literal'/></para>
        </#if>
    </#if>

    <#--  3.6 Mode of action -->
    <#if eff.ModeAction?has_content || eff.DetailsOnModeOfAction?has_content>

        <para><emphasis role="bold">Mode of action</emphasis></para>

        <para role="indent"><@com.value eff.ModeAction 'literal'/></para>
        <#if eff.DetailsOnModeOfAction?has_content>
            <para role="indent"><@com.value eff.DetailsOnModeOfAction 'literal'/></para>
        </#if>
    </#if>

    <#--  3.7 Information on the occurrence or possible occurrence of the development of resistance, and appropriate management strategies -->
    <#if eff.PossibleOccurrenceOfResistance?has_content ||
            eff.ManagementStrategiesToAvoidResistance?has_content ||
            eff.AnyOtherKnownLimitationsAndManagementStrategies?has_content>

        <para><emphasis role="bold">Information on the occurrence or possible occurrence of the development of resistance, and appropriate management strategies</emphasis></para>

        <#if eff.PossibleOccurrenceOfResistance?has_content>
            <para role="indent"><@com.value eff.PossibleOccurrenceOfResistance 'literal'/></para>
        </#if>

        <#if eff.ManagementStrategiesToAvoidResistance?has_content>
            <para role="indent"><@com.value eff.ManagementStrategiesToAvoidResistance 'literal'/></para>
        </#if>

        <#if eff.AnyOtherKnownLimitationsAndManagementStrategies?has_content>
            <para role="indent"><@com.value eff.AnyOtherKnownLimitationsAndManagementStrategies 'literal'/></para>
        </#if>
    </#if>

    <#-- Method of application -->
    <#if gen.InformationOnApplicationOfProduct?has_content>
        <para><emphasis role="bold">Information on application of the product</emphasis></para>
        <para role="indent">Method of application: <@com.value gen.InformationOnApplicationOfProduct.MethodOfApplication 'literal'/></para>
        <#if gen.InformationOnApplicationOfProduct.DetailsOnApplication?has_content>
            <para role="indent"><@com.value gen.InformationOnApplicationOfProduct.DetailsOnApplication 'literal'/></para>
        </#if>
    </#if>
</#macro>

<#-- targetOrganismsList outputs the target organisms repeatable block from the ENDPOINT_STUDY_RECORD.EffectivenessAgainstTargetOrganisms document.
    
    Inputs:
    - targetOrganismsRepeatableBlock: field object from the document FLEXIBLE_RECORD.BioPropertiesMicro 
    - role: type of indentation e.g. 'indent', 'indent2'
-->
<#macro targetOrganismsList targetOrganismsRepeatableBlock role="indent">
    <#compress>
        <#if targetOrganismsRepeatableBlock?has_content>
            <#list  targetOrganismsRepeatableBlock as blockItem>
                <#if blockItem.ScientificName?has_content || blockItem.CommonName?has_content || blockItem.DevelopmentalStage?has_content || blockItem.DevelopmentalStageOfTargetPlant?has_content>
                    <para role="${role}">
                        <#if blockItem.ScientificName?has_content>
                            <@com.picklist blockItem.ScientificName/>
                            <#if blockItem.CommonName?has_content>
                                (<@com.picklist blockItem.CommonName/>)
                            </#if>
                        <#elseif blockItem.CommonName?has_content>
                            <@com.picklist blockItem.CommonName/>
                        </#if>

                        <#if blockItem.DevelopmentalStage?has_content>
                            <?linebreak?>- Developmental stage of target pest: <@com.picklist blockItem.DevelopmentalStage/>
                        </#if>

                        <#if blockItem.DevelopmentalStageOfTargetPlant?has_content>
                            <?linebreak?>- Developmental stage of target plant: <@com.picklistMultiple blockItem.DevelopmentalStageOfTargetPlant/>
                        </#if>
                    </para>
                </#if>
            </#list>
        </#if>
    </#compress>
</#macro>

<#-- effectList outputs the Effect concentrations block from the ENDPOINT_STUDY_RECORD.ToxicityToOtherAboveGroundOrganisms.
    NOTE: this has changed in April 2023 but not yet implemented! New fields were added:
    - *.EffectConcentrations.SlopeOfTheCurve
    - *.EffectConcentrations.LifeStage

    Inputs:
    - effectConcRepeatableBlock: path object of the block
-->
<#macro effectList effectConcRepeatableBlock>
    <#compress>
        <#if effectConcRepeatableBlock?has_content>
            <#list effectConcRepeatableBlock as blockItem>
                <#if blockItem.Endpoint?has_content || blockItem.Duration?has_content
                || blockItem.EffectConc?has_content || blockItem.ConcBasedOn?has_content
                || blockItem.NominalMeasured?has_content || blockItem.BasisForEffect?has_content
                || blockItem.RemarksOnResults?has_content>
                    <para role="indent">
                        <#if blockItem.Endpoint?has_content>
                            <@com.picklist blockItem.Endpoint/>
                        </#if>

                        <#if blockItem.Duration?has_content>
                            (<@com.quantity blockItem.Duration/>):
                        </#if>

                        <#if blockItem.EffectConc?has_content>
                            <@com.range blockItem.EffectConc/>
                        </#if>

                        <#if blockItem.ConcBasedOn?has_content>
                            <@com.picklist blockItem.ConcBasedOn/>
                        </#if>

                        <#if blockItem.NominalMeasured?has_content>
                            (<@com.picklist blockItem.NominalMeasured/>)
                        </#if>

                        <#if blockItem.BasisForEffect?has_content>
                            based on: <@com.picklist blockItem.BasisForEffect/>
                        </#if>

                        <#if blockItem.RemarksOnResults?has_content>
                            (<@com.picklist blockItem.RemarksOnResults/>)
                        </#if>
                    </para>
                </#if>
            </#list>
        </#if>
    </#compress>
</#macro>

<#--SUMMARIES-->

<#-- toxicityToOtherAboveGroundOrganismsSummaryTable prints the section of key value for chemical safety assessment
    of the ENDPOINT_SUMMARY.ToxicityToOtherAboveGroundOrganisms in table format (excluding higher tier testing)
    
    Inputs:
    - summary: summary DOCUMENT
-->
<#macro toxicityToOtherAboveGroundOrganismsSummaryTable summary>
    <#compress>
        
        <#-- table for the first two sections -->
        <table border="1">
			
            <tbody valign="middle">
			
            <tr>
				<th align="center"><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Endpoint</emphasis></th>
                <th align="center"><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Descriptor and value</emphasis></th>
				<th align="center"><?dbfo bgcolor="#FBDDA6" ?><emphasis role="bold">Studies</emphasis></th>
			</tr>

            <#list summary.KeyValueForChemicalSafetyAssessment?children as endpointEntry>

                <#-- exclude the higher tier since the structure is very different -->
                <#if endpointEntry?node_name != "HigherTierTesting">

                    <tr>

                        <td>
                            <@iuclid.label for=endpointEntry var="fieldLabel"/>
                            ${fieldLabel}
                        </td>

                        <td>
                            <#if endpointEntry.DoseDescriptor?has_content>
                                <@com.value endpointEntry.DoseDescriptor/> = 
                            </#if>
                            <#if endpointEntry.EffectConcentration?has_content>
                                <@com.value endpointEntry.EffectConcentration/>
                            </#if>
                        </td>

                        <td>

                            <#if endpointEntry.LinkToRelevantStudyRecord?has_content>
                                <#list endpointEntry.LinkToRelevantStudyRecord as link>
                                    <#local study = iuclid.getDocumentForKey(link) />
                                    <para>
                                        <command linkend="${study.documentKey.uuid!}">
                                            <@com.text study.name/>
                                        </command>
                                    </para>
                                </#list>
                            </#if>  
                        </td>
                    </tr>

                </#if>
            </#list>
        </tbody>
        </table>

    </#compress>
</#macro>

