
<!-- Legal entity information from a Legal entity  -->
<#macro basicLegalEntityInformation _subject legalEntity="">
	<#compress>


		<#if !legalEntity?has_content><#assign legalEntity = iuclid.getDocumentForKey(_subject.OwnerLegalEntity)/></#if>
		<#if legalEntity?has_content>

			<#if legalEntity.GeneralInfo.LegalEntityName?has_content>
				<para><emphasis role="bold">Legal Entity name:</emphasis> <@com.value legalEntity.GeneralInfo.LegalEntityName "" /></para><?linebreak?>
			</#if>
	
			<#if legalEntity.GeneralInfo.LegalEntityType?has_content>
				<para><emphasis role="bold">Legal Entity type:</emphasis> <@com.value legalEntity.GeneralInfo.LegalEntityType /></para><?linebreak?>
			</#if>

			<#if legalEntity.GeneralInfo.OtherNames?has_content>
				<para><emphasis role="bold">Other names for legal entity:</emphasis>
				<#list legalEntity.GeneralInfo.OtherNames as legalEntityOtherNames>
					<@com.value legalEntityOtherNames.Name />
					<#if legalEntityOtherNames_has_next><#if pppRelevant??>,<#else><?linebreak?></#if></#if>
				</#list>
				</para>
			</#if>

		</#if>
	
	</#compress>
</#macro>

<!-- Contact information from a Legal entity or Site -->
<#macro contactInfoOfLegalEntity _subject contactPath="" title="Basic contact information of the Legal Entity">
	<#compress>

		<#if !contactPath?has_content>
			<#local legalEntity = iuclid.getDocumentForKey(_subject.OwnerLegalEntity)/>
			<#if legalEntity?has_content><#local contactPath = legalEntity.GeneralInfo/></#if>
		</#if>

		<#if (legalEntity?? && legalEntity?has_content) || contactPath?has_content>

			<#local contactPath = contactPath.ContactAddress/>

			<@com.emptyLine/>
			<table border="1">
				<title>${title}</title>
				<col width="50%" />
				<col width="50%" />
				<tbody>

					<#if contactPath.Phone?has_content || contactPath.Email?has_content || contactPath.Address1?has_content ||
							contactPath.Address2?has_content || contactPath.Postal?has_content || contactPath.Town?has_content ||
							contactPath.Country?has_content>
						<tr>
							<td>
								<#if contactPath.Phone?has_content || contactPath.Email?has_content>
									Phone: <@com.value contactPath.Phone "" /><?linebreak?>
									E-mail: <@com.value contactPath.Email "" />
								</#if>
							</td>
							<td>
								<#if contactPath.Address1?has_content || contactPath.Address2?has_content || contactPath.Postal?has_content ||
										contactPath.Town?has_content || contactPath.Country?has_content>
									Address 1: <@com.value contactPath.Address1 "" /><?linebreak?>
									Address 2: <@com.value contactPath.Address2 "" /><?linebreak?>
									Postal code: <@com.value contactPath.Postal "" /><?linebreak?>
									Town: <@com.value contactPath.Town "" /><?linebreak?>
									Country: <@com.value contactPath.Country />
								</#if>
							</td>
						</tr>
					<#else>
						<tr colspan="2">
							<td>
								<para>No contact information provided</para>
							</td>
						</tr>
					</#if>
				</tbody>
			</table>
		<#else>
		</#if>
	</#compress>
</#macro>

<!-- Contact persons information from main substance or mixture -->
<#macro contactPersonsInfoOfMainSubstanceOrMixture _subject title="Contact persons of the main entity (substance or mixture)">
	<#compress>

		<#if _subject.ContactPersons?has_content>

			<@com.emptyLine/>
			<table border="1">
				<title>${title}</title>
				<col width="50%" />
				<col width="50%" />
				<tbody>
					<@tableOfContactPersons _subject.ContactPersons/>
				</tbody>
			</table>
		</#if>
	</#compress>
</#macro>

<!-- Contact persons information from Legal entity -->
<#macro contactPersonsInfoOfLegalEntity _subject legalEntity="" title="Contact persons of the Legal Entity">
	<#compress>

		<#if !legalEntity?has_content><#assign legalEntity = iuclid.getDocumentForKey(_subject.OwnerLegalEntity)/></#if>
		<#if legalEntity?has_content>

			<@com.emptyLine/>

			<table border="1">
				<title>${title}</title>
				<col width="50%" />
				<col width="50%" />
				<tbody>
					<@tableOfContactPersons legalEntity.ContactInfo.ContactPersons/>
				</tbody>
			</table>
		</#if>
		
	</#compress>
</#macro>

<!-- Contact persons main table -->
<#macro tableOfContactPersons contactBlock>
	<#compress>

		<#list contactBlock as contactPersons>

			<#if contactPersons?has_content>
				<#local contactPerson = iuclid.getDocumentForKey(contactPersons.ContactPerson)/>
				<#if contactPerson?has_content>
					<#if contactPerson.GeneralInfo.ContactType?has_content>
						<tr>
							<td colspan="2">
								Contact type: <@com.value contactPerson.GeneralInfo.ContactType/>
							</td>
						</tr>
						<#else>
						<tr>
							<td colspan="2"></td>
						</tr>
					</#if>

					<tr>
						<td>
							<#if contactPerson.GeneralInfo.LastName?has_content	|| contactPerson.GeneralInfo.FirstName?has_content ||
								contactPerson.GeneralInfo.Organisation?has_content ||	contactPerson.GeneralInfo.Phone?has_content ||
								contactPerson.GeneralInfo.Email?has_content>
								Last name: <@com.value contactPerson.GeneralInfo.LastName "" /><?linebreak?>
								First name: <@com.value contactPerson.GeneralInfo.FirstName "" /><?linebreak?>
								Organisation: <@com.value contactPerson.GeneralInfo.Organisation "" /><?linebreak?>
								Phone: <@com.value contactPerson.GeneralInfo.Phone "" /><?linebreak?>
								E-mail: <@com.value contactPerson.GeneralInfo.Email "" />
							</#if>
						</td>
						<td>
							<#if contactPerson.GeneralInfo.Address1?has_content	|| contactPerson.GeneralInfo.Address2?has_content ||
								contactPerson.GeneralInfo.Postal?has_content || contactPerson.GeneralInfo.Town?has_content || contactPerson.GeneralInfo.Country?has_content>
								Address 1: <@com.value contactPerson.GeneralInfo.Address1 "" /><?linebreak?>
								Address 2: <@com.value contactPerson.GeneralInfo.Address2 "" /><?linebreak?>
								Postal code: <@com.value contactPerson.GeneralInfo.Postal "" /><?linebreak?>
								Town: <@com.value contactPerson.GeneralInfo.Town "" /><?linebreak?>
								Country: <@com.value contactPerson.GeneralInfo.Country />
							</#if>
						</td>
					</tr>

				<#else>
				<tr><?dbfo bgcolor="#bbbbbb"?>
					<td colspan="2">
						<para>Empty contact persons block</para>
					</td>
				</tr>
				</#if>
			<#else>
				<#--NOTE: otherwise if empty block report crashes-->
				<tr><td></td><td></td></tr>
			</#if>

		</#list>
		
	</#compress>
</#macro>


<#-----------------------PPP additions--------------------------------------------->
<#--- applicant outputs information from the legal entity owner, third party, role in supply chain,
	 and contact persons of an ENTITY (SUBSTANCE, MIXTURE), which contain information relating the 
	 applicant submitting the dossier.

	Inputs:
	- _subject: ENTITY (SUBSTANCE, or MIXTURE)
-->
<#macro applicant _subject>
	<#compress>

		<#if _subject.OwnerLegalEntity?has_content>
			<para><emphasis role="underline">Information of the applicant (legal entity):</emphasis></para>
			<#local legalEntity = iuclid.getDocumentForKey(_subject.OwnerLegalEntity)/>
			<#if legalEntity?has_content>
				<@legalEntityInfo legalEntity "applicant"/>
			</#if>
		<#else>
			<para>No information of applicant available.</para>
		</#if>

		<#if _subject.ThirdParty?has_content>
			<@com.emptyLine/>
			<para><emphasis role="underline">Third party:</emphasis></para>
			<#local thirdParty = iuclid.getDocumentForKey(_subject.ThirdParty)/>
			<#if thirdParty?has_content>
				<@legalEntityInfo thirdParty "third party"/>
			</#if>
		</#if>

		<@roleInSupplyChain _subject/>

		<#if _subject.ContactPersons?has_content>
			<@com.emptyLine/>
			<para><emphasis role="underline">Contact persons:</emphasis></para>
			<@contactPersonsInfoOfMainSubstanceOrMixture _subject "Contact persons (${_subject.documentType?lower_case})"/>
		</#if>
	</#compress>
</#macro>

<#--- legalEntityInfo outputs basic information of a legal entity
	 
	Inputs:
	- legal_entity: LEGAL_ENTITY ENTITY
	- name: str containing the generic name to be printed in the title
-->
<#macro legalEntityInfo legalEntity name="legal entity">
	<#compress>
		<@basicLegalEntityInformation _subject legalEntity/>
		
		<#-- NOTE: missing IDENTIFIERS section-->

		<#if legalEntity.GeneralInfo.ContactAddress?has_content>
			<@contactInfoOfLegalEntity _subject legalEntity.GeneralInfo "Basic contact information of the ${name}"/>
		</#if>

		<#if legalEntity.ContactInfo.ContactPersons?has_content>
			<@contactPersonsInfoOfLegalEntity _subject legalEntity "Contact persons of the ${name}"/>
		</#if>
	</#compress>
</#macro>

<#--- roleInSupplyChain outputs the roles in the supply chain of a SUBSTANCE or MIXTURE document 
	as a concatenated string.
	 
	Inputs:
	- _subject: ENTITY (SUBSTANCE, or MIXTURE)
-->
<#macro roleInSupplyChain _subject>
	<#compress>
		<#if _subject.RoleInSupplyChain?has_content>
			<#local rolePath=_subject.RoleInSupplyChain/>
			<#local roles=[]/>
			<#list rolePath?children as child>
				<#if child?node_type=="boolean" && child>
					<#local childName>${child?node_name?replace("([A-Z]{1})", " $1", "r")?lower_case}</#local>
					<#local roles=roles+[childName]/>
				</#if>
			</#list>

			<#if roles?has_content>
				<#local roles=roles?join(", ")/>
				<@com.emptyLine/>
				<para>
					<emphasis role="underline">Role in the supply chain: </emphasis>
					${roles}
				</para>
			</#if>
		</#if>
	</#compress>
</#macro>

<#--- producer outputs the contents of the document FLEXIBLE_RECORD.Suppliers
	 
	Inputs:
	- _subject: ENTITY (SUBSTANCE, or MIXTURE)
-->
<#macro producer _subject>
	<#compress>

		<#assign recordList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "FLEXIBLE_RECORD", "Suppliers") />

		<#if !(recordList?has_content)>
			No relevant information on producers available.
		<#else>
			<#list recordList as record>

				<#--Get hyperlink and print record's name (with a numbering system if more than one)-->
				<#local docUrl=iuclid.webUrl.documentView(record.documentKey) />
				<para><emphasis role="HEAD-WoutNo"><#if (recordList?size>1)>Producer #${record_index+1}:</#if><ulink url="${docUrl}"><@com.text record.name/></ulink></emphasis></para>

				<#-- Producer-->
				<#local legalEntity = iuclid.getDocumentForKey(record.ManufacturerImportForm.LegalEntity)/>
				<#if legalEntity?has_content>
					<para><emphasis role="underline">Producer's details:</emphasis></para>
					<@legalEntityInfo legalEntity/>
				</#if>

				<#if record.ManufacturerImportForm.Remarks?has_content>
					<para><emphasis role="underline">Remarks:</emphasis> <@com.value record.ManufacturerImportForm.Remarks/></para>
				</#if>

				<#if record.OnlyRepresentationInfo.ImporterEntries?has_content>
					<@com.emptyLine/>
					<para><emphasis role="underline">Other importers:</emphasis></para>

					<#list record.OnlyRepresentationInfo.ImporterEntries as leEntry>
						<#if (record.OnlyRepresentationInfo.ImporterEntries?size>1) >Importer #${leEntry_index+1}:</#if>

						<#local leImporter = iuclid.getDocumentForKey(leEntry.LegalEntity)/>
						<#if leImporter?has_content>
							<#--NOTE: maybe better to show less info for these cases-->
							<@legalEntityInfo leImporter/>
						</#if>
					</#list>
				</#if>
				<@com.emptyLine/>
			</#list>
		</#if>

	</#compress>
</#macro>


<#--- manufacturingPlant outputs the contents of the document FLEXIBLE_RECORD.Sites
	 
	Inputs:
	- _subject: ENTITY (SUBSTANCE, or MIXTURE)
-->
<#macro manufacturingPlant _subject>
	<#compress>

		<#assign recordList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "FLEXIBLE_RECORD", "Sites") />

		<#if !(recordList?has_content)>
			No relevant information on manufacturing plants available.
		<#else>
			<#list recordList as record>

				<#--Get hyperlink and print record's name (with a numbering system if more than one)-->
				<#local docUrl=iuclid.webUrl.documentView(record.documentKey) />
				<para><emphasis role="HEAD-WoutNo"><#if (recordList?size>1)>Manufacturing plant #${record_index+1}:</#if><ulink url="${docUrl}"><@com.text record.name/></ulink></emphasis></para>

				<@com.emptyLine/>

				<#--Site-->
				<#local site = iuclid.getDocumentForKey(record.ReferenceSite)/>
				<#if site?has_content>
					<@siteInfo site/>
				</#if>

				<#if record.Remarks?has_content>
					<para><emphasis role="underline">Remarks:</emphasis> <@com.value record.Remarks/></para>
				</#if>

				<#--Mixture/Product-->
				<#if _subject.documentType=="MIXTURE" && record.RelatedMixtureProduct.SpecifyToWhichMixtureProductSItApplies?has_content>
					<para><emphasis role="underline">Applicable to mixture/product:</emphasis>
						<#local product=iuclid.getDocumentForKey(record.RelatedMixtureProduct.SpecifyToWhichMixtureProductSItApplies)/>
						<@mixtureName _subject/>
					</para>
				</#if>

				<@com.emptyLine/>
			</#list>
		</#if>

	</#compress>
</#macro>

<#--- siteInfo outputs information from a SITE entity
	 
	Inputs:
	- site: SITE ENTITY
-->
<#macro siteInfo site>
	<#compress>

		<#if site.GeneralInfo.SiteName?has_content>
			<para><emphasis role="bold">Site name:</emphasis> <@com.value site.GeneralInfo.SiteName "" /></para><?linebreak?>
		</#if>

		<#if site.GeneralInfo.OwnerLegalEntity?has_content>
			<#local legalEntity = iuclid.getDocumentForKey(site.GeneralInfo.OwnerLegalEntity)/>
			<#if legalEntity?has_content>
				<para>
					<emphasis role="bold">Legal entity owner:</emphasis>
					<@com.value legalEntity.GeneralInfo.LegalEntityName />
					<#if legalEntity.GeneralInfo.LegalEntityType?has_content>
						<@com.value legalEntity.GeneralInfo.LegalEntityType/>
					</#if>
				</para>
				<?linebreak?>
			</#if>
		</#if>

		<#if site.GeneralInfo.ExternalSystemIdentifiers?has_content>
			<para><emphasis role="bold">Other IT system identifiers:</emphasis>
				<#list site.GeneralInfo.ExternalSystemIdentifiers as otherId>
					<@com.value otherId.ExternalSystemDesignator/>: <@com.value otherId.Id/>
					<#if otherId_has_next>,</#if>
				</#list>
			</para>
		</#if>

		<#if site.ContactAddress?has_content>
			<@contactInfoOfLegalEntity _subject site "Contact info of site"/>
		</#if>

	</#compress>
</#macro>

<#--- producerDevCodeNos outputs information from a FLEXIBLE_RECORD.Identifiers document 
	 
	Inputs:
	- _subject: ENTITY (SUBSTANCE, MIXTURE)
-->
<#macro producerDevCodeNos _subject>
	<#compress>

		<#assign recordList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "FLEXIBLE_RECORD", "Identifiers") />

		<#if !(recordList?has_content)>
			No relevant information on producer's development code numbers available.
		<#else>
			<para><emphasis role="underline">Development code numbers:</emphasis></para>

			<#list recordList as record>

				<#--Get hyperlink and print record's name (with a numbering system if more than one)-->
				<#local docUrl=iuclid.webUrl.documentView(record.documentKey) />
				<para><emphasis role="HEAD-WoutNo"><#if (recordList?size>1)>Development code numbers #${record_index+1}:</#if><ulink url="${docUrl}"><@com.text record.name ""/></ulink></emphasis></para>

				<#--Regulatory programme identifiers-->
				<#if record.RegulatoryProgrammeIdentifiers.RegulatoryProgrammeIdentifiers?has_content>
					<para>Regulatory programme identifiers:</para>
					<@regProgIdsList record.RegulatoryProgrammeIdentifiers.RegulatoryProgrammeIdentifiers "indent"/>
					<@com.emptyLine/>
				</#if>

				<#--Other IT system identifiers-->
				<#if record.ExternalSystemIdentifiers.ExternalSystemIdentifiers?has_content>
					<para>Other IT system identifiers:</para>
					<@itSystemIdsList record.ExternalSystemIdentifiers.ExternalSystemIdentifiers "indent"/>
					<@com.emptyLine/>
				</#if>

			</#list>
		</#if>

	</#compress>
</#macro>

<#--- regProgIdsList outputs a list of identifiers from the Regulatory programme identifiers section
	of a FLEXIBLE_RECORD.Identifiers document 
	 
	Inputs:
	- path: node corresponding to the Regulatory programme identifiers section i.e. RegulatoryProgrammeIdentifiers.RegulatoryProgrammeIdentifiers
	- role: str identifieng the role to be given to the paragraph e.g. indent, indent2
-->
<#macro regProgIdsList path role="">
	<#compress>
		<#if path?has_content>
			<#list path as item>
				<para role="${role}">
					<@com.value item.RegulatoryProgramme/>: <@com.value item.Id/>
					<#if item.Remarks?has_content>(<@com.value item.Remarks/>)</#if>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#--- regProgIdsList outputs a list of identifiers from the Other IT system identifiers
 sectionof a FLEXIBLE_RECORD.Identifiers document 
	 
	Inputs:
	- path: node corresponding to the Other IT system identifiers section i.e. RegulatoryProgrammeIdentifiers.ExternalSystemIdentifiers
	- role: str identifieng the role to be given to the paragraph e.g. indent, indent2
-->
<#macro itSystemIdsList path role="">
	<#compress>
		<#if path?has_content>
			<#list path as item>
				<para role="${role}">
					<@com.value item.ExternalSystemDesignator/>: <@com.value item.Id/>
					<#if item.Remarks?has_content>(<@com.value item.Remarks/>)</#if>
				</para>
			</#list>
		</#if>
	</#compress>
</#macro>

<#-- manufacturer outputs the contents of the FLEXIBLE_RECORD.Manufacturer_EU_PPP/FLEXIBLE_RECORD.Manufacturer_EFSA document

	Inputs:
	- _subject: ENTITY in which the document is found
	- docSubType document to extract information from
-->
<#macro manufacturer _subject docSubTypes=["Manufacturer_EU_PPP", "Manufacturer_EFSA"]>
	<#compress>

		<#-- Convert docSubTypes to list, in case only one name provided -->
		<#if !docSubTypes?is_sequence>
			<#local docSubTypes=[docSubTypes]/>
		</#if>

		<#local recordList = []/>

		<#list docSubTypes as docSubType>
			<#local documents = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "FLEXIBLE_RECORD", docSubType) />
			
			<#local recordList += documents/>
		</#list>	

		<#if !(recordList?has_content)>
			<@com.emptyLine/>
			No information available.
			<@com.emptyLine/>
		
		<#else>

			<#list recordList as record>

				<#--Get hyperlink and print record's name (with a numbering system if more than one)-->
				<#local docUrl=iuclid.webUrl.documentView(record.documentKey) />
				<@com.emptyLine/>
				<para><emphasis role="bold"><#if (recordList?size>1)>#${record_index+1}: </#if>Title: <ulink url="${docUrl}"><@com.text record.name ""/></ulink></emphasis></para>
				<#if record.documentSubType == "Manufacturer_EU_PPP">
					<@manufacturerPPP record/>
				<#elseif record.documentSubType == "Manufacturer_EFSA">
					<@manufacturerEFSA _subject record/>

				</#if>
			</#list>
		</#if>
	</#compress>
</#macro>

<#macro manufacturerPPP record>
	<#compress>
		<#--Key info-->
		<#if record.KeyInformation?has_content>
						
			<para><emphasis role="bold">Key information: </emphasis></para>
			<para role="indent"><para style="background-color:#f7f7f7" ><@com.value record.KeyInformation.field4764/></para></para>

			<#if record.KeyInformation.QualityControl?has_content> 
				<para role='indent'>Quality control: <@com.value record.KeyInformation.QualityControl ""/> </para>
			</#if>
		</#if>

		<#--Related compositions-->
		<#if record.AdministrativeDataSummary.RelatedCompositions?has_content>
			
			<para><emphasis role="bold">Related compositions: </emphasis></para>
			<#list record.AdministrativeDataSummary.RelatedCompositions as compLink>
				<#local comp = iuclid.getDocumentForKey(compLink) />
				<para role="indent">
					<#if comp.GeneralInformation.Name?has_content>
						<@com.value comp.GeneralInformation.Name ""/>
					<#else>
						<@com.text comp.name ""/>
					</#if>
				</para>
			</#list>
		</#if>

		<#if record.AdditionalInformation?has_content>
			
			<para><emphasis role="bold">Additional information and confidentiality:</emphasis></para>
			<para role="indent"><para style="background-color:#f7f7f7"><@com.value record.AdditionalInformation.field7821/></para></para>
		</#if>
		
	</#compress>
</#macro>

<#macro manufacturerEFSA entity record printAdminInfo='link' printImpuritiesInfo=false>
	<#compress>

		<#if entity.documentType=="MIXTURE">
			<#local printImpuritiesInfo=false/>
		</#if>

		<#if printAdminInfo?has_content>

			<#if printAdminInfo=='full'>
			
				<#if record.AdministrativeData?has_content>
					
					<#if record.AdministrativeData.ManufacturerName?has_content>
						<para><emphasis role="bold">Manufacturer name: </emphasis><@com.value record.AdministrativeData.ManufacturerName/></para>
					</#if>

					<#-- for each site, print the legal entity including contacts and the site info -->
					<#if record.AdministrativeData.ManufacturingPlantSite?has_content>
										
						<#list record.AdministrativeData.ManufacturingPlantSite as siteLink>
							
							<para><emphasis role="bold">Manufacturing plants/sites: </emphasis></para>
							<#if (record.AdministrativeData.ManufacturingPlantSite?size>1)><para><emphasis role="indent">#{siteLink?index+1}: </emphasis></para></#if>

							<@siteInfoTableEFSA siteLink=siteLink/>

						</#list>
					</#if>

					<#-- related compositions -->
					<#if record.AdministrativeData.RelatedCompositions?has_content>
						
						<para><emphasis role="bold">Related compositions: </emphasis></para>
						<#list record.AdministrativeData.RelatedCompositions as compLink>
							<#local comp = iuclid.getDocumentForKey(compLink) />
							<para role="indent">
								<#if comp.GeneralInformation.Name?has_content>
									<@com.value comp.GeneralInformation.Name/>
								<#else>
									<@com.text comp.name/>
								</#if>
							</para>
						</#list>
					</#if>	
				</#if>

			<#elseif printAdminInfo=='link'>
				<#-- print link to basic admin info -->
				<para><emphasis role="bold">Manufacturer: </emphasis><command linkend="${record.documentKey!}_basicInfo"><@com.value record.AdministrativeData.ManufacturerName/></command></para>
			
			</#if>

		</#if>

		<#--Manufacturing process-->
		<#if record.ManufacturingProcess?has_content>
			
			<#-- only present in AS document -->
			<#if record.hasElement("ManufacturingProcess.StartingSubstances") && record.ManufacturingProcess.StartingSubstances?has_content>
				<para><emphasis role="bold">Starting substances:</emphasis></para>
				<@startingSubstancesTable record.ManufacturingProcess.StartingSubstances/>
			</#if>
			<#if record.ManufacturingProcess.ManufacturingProcess.ManufacturingProcess?has_content>
				<para><emphasis role="bold">Manufacturing process:</emphasis></para>
				<@manufacturingProcessTable record.ManufacturingProcess.ManufacturingProcess.ManufacturingProcess/>
			</#if>
			<#if record.hasElement("ManufacturingProcess.ManufacturingProcess.SubstancesProduced") && record.ManufacturingProcess.ManufacturingProcess.SubstancesProduced?has_content>
				<para><emphasis role="bold">Substances produced:</emphasis></para>
				<para><para style="background-color:#f7f7f7"><@com.value record.ManufacturingProcess.ManufacturingProcess.SubstancesProduced/></para></para>
			</#if>
			<#if record.hasElement("ManufacturingProcess.ManufacturingProcess.PurificationSteps") && record.ManufacturingProcess.ManufacturingProcess.PurificationSteps?has_content>
				<para><emphasis role="bold">Purification steps:</emphasis></para>
				<para><para style="background-color:#f7f7f7"><@com.value record.ManufacturingProcess.ManufacturingProcess.PurificationSteps/></para></para>
			</#if>
			<#if record.hasElement("ManufacturingProcess.ManufacturingProcess.ByProducts") && record.ManufacturingProcess.ManufacturingProcess.ByProducts?has_content>
				<para><emphasis role="bold">By products:</emphasis></para>
				<para><para style="background-color:#f7f7f7"><@com.value record.ManufacturingProcess.ManufacturingProcess.ByProducts/></para></para>
			</#if>
			<#if record.ManufacturingProcess.ManufacturingProcess.QualityControl?has_content>
				<@com.formattedValue valuePath=record.ManufacturingProcess.ManufacturingProcess.QualityControl tabular=true/>
			</#if>
		</#if>

		<#--Additional info-->
		<#if record.AdditionalInformation?has_content>

			<para><emphasis role="bold">Additional information:</emphasis></para>

			<#if record.AdditionalInformation.AdditionalInformation?has_content>
				<para><para style="background-color:#f7f7f7" ><@com.value record.AdditionalInformation.AdditionalInformation/></para></para>
			</#if>

			<#if record.AdditionalInformation.ProcessFlowchartRep?has_content>
				<para>Process flowchart(s):</para>
				<#list record.AdditionalInformation.ProcessFlowchartRep as blockItem>
					<@com.printImage attachmentPath=blockItem.ProcessFlowchart imageWidthPerc=100 printTitle=false informal=true/>
				</#list>
			</#if>

			<#if record.AdditionalInformation.Remarks?has_content>
				<para>Remarks:</para>
				<para><para style="background-color:#f7f7f7" ><@com.value record.AdditionalInformation.Remarks/></para></para>
			</#if>
		</#if>

		<#-- Impurities -->
		<#if printImpuritiesInfo>
			<para><emphasis role='bold'>Impurities in the manufacturing process:</emphasis></para>
			<@manufacturingProcessImpuritiesInfo record/>
		</#if>
		
	</#compress>
</#macro>

<#macro startingSubstancesTable startingSubstancesRepeatableBlock >
	<#compress>
		<#if startingSubstancesRepeatableBlock?has_content>
			<#local remarksList = []/>
			<#local remarksCounter = 0/>

			<table border="1">

				<col width="20%" />
				<col width="15%" />
				<col width="20%" />
				<col width="15%" />
				<col width="20%" />
				<col width="10%" />

				<thead align="center" valign="middle">
					<tr><?dbfo bgcolor="#d3d3d3" ?>
						<th><emphasis role="bold">Substance</emphasis></th>
						<th><emphasis role="bold">CAS No.</emphasis></th>
						<th><emphasis role="bold">Molecular / structural formula</emphasis></th>
						<th><emphasis role="bold">Purity</emphasis></th>
						<th><emphasis role="bold">Supplier</emphasis></th>
						<th><emphasis role="bold">Remarks</emphasis></th>
					</tr>
				</thead>

				<tbody>

					<#list startingSubstancesRepeatableBlock as blockItem>
						
						<#-- get the ref substance -->
						<#local refSubstance = iuclid.getDocumentForKey(blockItem.Substance)/>

						<tr>
							<td>
								<#if refSubstance.ReferenceSubstanceName?has_content>
									<@com.value refSubstance.ReferenceSubstanceName ""/>
								<#else>
									<@com.text refSubstance.name ""/>
								</#if>
							</td>

							<td>
								${pppId.getCASid(refSubstance)}
							</td>

							<td>
								<@com.molecularFormula referenceSubstanceID=refSubstance convertFormula=true/><?linebreak?>
								<@com.structuralFormula referenceSubstanceID=refSubstance imageWidthPerc=100 printTitle=false informal=true/>
							</td>

							<td>
								<@com.value blockItem.Purity ""/>
							</td>

							<td>
								<@com.value blockItem.Supplier ""/>
							</td>

							<#-- consider remarks, additional information, function and amount as a remark -->
							<td>
								<#local remarksRowList = []/>
								<#list [blockItem.AmountOfTheStartingMaterial, blockItem.Function, blockItem.Remarks, blockItem.AdditionalInformation] as remarksPath>
									<#if remarksPath?has_content>
										<@iuclid.label for=remarksPath var="fieldLabel"/>
										<#local remark>${fieldLabel}: <@com.value valuePath=remarksPath format=''/></#local>
										<#local remarksRowList += [remark]/>
									</#if>
									
								</#list>
								<#if remarksRowList?has_content>
									<#local remarksCounter++ />
									<emphasis>(${remarksCounter})</emphasis>
									<#local remarksList += [remarksRowList?join(" | ")]/>
								</#if>
							</td>

						</tr>

					</#list>
				</tbody>
			</table>

			<#if remarksList?has_content>
				<para role="small">
					<emphasis>
						<#list remarksList as remark>
							(${remark?index+1})
							${remark}
							<#if remark?has_next><?linebreak?></#if>
						</#list>
					</emphasis>
				</para>
			</#if>
		</#if>	
	</#compress>
</#macro>

<#macro manufacturingProcessTable manufacturingProcessRepeatableBlock >
	<#compress>
		<#if manufacturingProcessRepeatableBlock?has_content>

			<table border="1">

				<tbody>

				<#list manufacturingProcessRepeatableBlock as blockItem>

					<#--  Title: --> 
					<tr><?dbfo bgcolor="#d3d3d3" ?><td><emphasis role='bold'><@com.value blockItem.Title ""/></emphasis></td></tr>
					
					<#--Description:--> 
					<#if blockItem.Description?has_content>
						<tr>
							<td>
								<para style="background-color:#f7f7f7">
								<@com.value blockItem.Description/>
								</para>
							</td>
						</tr>
					</#if>

					<#--  Reaction scheme:  -->
					<#if blockItem.ReactionScheme?has_content>
						<tr>
							<td>
								<@com.printImage attachmentPath=blockItem.ReactionScheme imageWidthPerc=100 printTitle=false informal=true/>
							</td>
						</tr>
					</#if>

				</#list>
				</tbody>
			</table>
		</#if>	
	</#compress>
</#macro>

<#macro manufacturerEfsaBasicInformation entity manufactureType="active substance">
	
	<#local records = iuclid.getSectionDocumentsForParentKey(entity.documentKey, "FLEXIBLE_RECORD", "Manufacturer_EFSA") />

	<#if records?has_content>
		<#list records as record>

			<#-- if more than one record, print the name -->
			<#local docUrl=iuclid.webUrl.documentView(record.documentKey) />

			<#-- print manufacturer  -->
			<para xml:id="${record.documentKey!}_basicInfo"><emphasis role="bold">Manufacturer<#if (records?size>1)> #${record_index+1}</#if>: </emphasis><ulink url="${docUrl}"><@com.value valuePath=record.AdministrativeData.ManufacturerName format=''/></ulink></para>

			<#-- for each site, print the legal entity including contacts and the site info -->
			<#if record.AdministrativeData.ManufacturingPlantSite?has_content>
								
				<#list record.AdministrativeData.ManufacturingPlantSite as siteLink>
					
					<#if (record.AdministrativeData.ManufacturingPlantSite?size>1)>
						<para><emphasis role="underline">Manufacturing plant #{siteLink?index+1}: </emphasis></para>
					</#if>

					<#-- print table -->
					<#if manufactureType=="active substance">
						<@siteInfoTableEFSA siteLink=siteLink sectionTitles=["Manufacturer of the active substance (legal entity)", "Location of the manufacturing plant"] />
					<#elseif  manufactureType=="product">
						<@siteInfoTableEFSA siteLink=siteLink sectionTitles=["Manufacturer of the plant protection product (legal entity)", "Location of the manufacturing plant"] printLEinfo=true/>
					<#else>
						<@siteInfoTableEFSA siteLink=siteLink/>
					</#if>

				</#list>
			<#else>
				<para>No information on manufacturing site provided</para>
			</#if>

		</#list>
	<#else>
		<para>No information provided</para>
	</#if>

</#macro>

<#macro siteInfoTableEFSA siteLink bgcolor="#D3D3D3" tableTitle='' sectionTitles=["Manufacturer", "Location of the manufacturing plant"] printLEinfo=true>
		
		<#-- get the site, legal entity and contact persons -->
		<#local site = iuclid.getDocumentForKey(siteLink) />

		<#local manufacturersLE = []/>
		<#local contactsLE = []/>

		<#-- consider multiple LE -->
		<#if site.GeneralInfo.OwnerLegalEntity?has_content>
			<#local manufacturerLE = iuclid.getDocumentForKey(site.GeneralInfo.OwnerLegalEntity) />
			<#local manufacturersLE += [manufacturerLE]/>
		</#if>
		<#if site.GeneralInfo.OtherLegalEntityOwners?has_content>
			<#list site.GeneralInfo.OtherLegalEntityOwners as otherLElink>
				<#local manufacturerLE = iuclid.getDocumentForKey(otherLElink) />
				<#local manufacturersLE += [manufacturerLE]/>
			</#list>
		</#if>

		<informaltable border="1">
			<#if tableTitle?has_content><title>${tableTitle}</title></#if>

			<col width="40%" />
			<col width="60%" />

			<tbody>
			
			<#if printLEinfo> 
				<#-- rows for manufacturer of the a.s. -->
				<tr><td colspan="2"><?dbfo bgcolor="${bgcolor}"?><emphasis role='bold'>${sectionTitles[0]}</emphasis></td></tr>

				
				<#if manufacturersLE?has_content>

					<#list manufacturersLE as manufacturerLE>

						<#if manufacturerLE.ContactInfo.ContactPersons?has_content>
							<#local contactsLE = manufacturerLE.ContactInfo.ContactPersons/>
						</#if>

						<#-- if more than one owner, add one line with an index -->
						<#if (manufacturersLE?size>1)><tr><td colspan="2"><?dbfo bgcolor="${bgcolor}"?><emphasis role='bold'>#${manufacturerLE?index+1}</emphasis></td></tr></#if>

						<tr>
							<td>
								<emphasis role='bold'>Name</emphasis>
							</td>
							<td>
								<#if manufacturerLE?has_content>
									<@com.value valuePath=manufacturerLE.GeneralInfo.LegalEntityName format=''/>
								</#if>
							</td>
						</tr>

						<tr>
							<td>
								<emphasis role='bold'>Address</emphasis>
							</td>
							<td>
								<#if manufacturerLE?has_content>
									
									<#local contactPath = manufacturerLE.GeneralInfo.ContactAddress/>

									<@com.value contactPath.Address1 "" /><?linebreak?>
									<@com.value contactPath.Address2 "" /><?linebreak?>
									<#local contactAddInfoList = []/>
									<#list [contactPath.Postal, contactPath.Town, contactPath.Region, contactPath.Country] as contactAddInfoPath>
										<#local contactAddInfo><@com.value contactAddInfoPath "" /></#local>
										<#if contactAddInfo?has_content>
											<#local contactAddInfoList += [contactAddInfo]/>
										</#if>
									</#list>
									${contactAddInfoList?join(", ")}

								</#if>
							</td>
						</tr>

						<#-- add an empty element to the list of contacts if it's empty, in order to count rows and print always the title -->
						<#if !contactsLE?has_content><#local contactsLE=['']/></#if>
						<#local useSpan=true/>
						<#list contactsLE as contactPersonLink>

							<tr>
								<#if useSpan>
									<td  rowspan="${contactsLE?size}">
										<emphasis role='bold'>Contact information</emphasis>
									</td>
									<#local useSpan=false/>
								</#if>

								<td>
									<#if contactPersonLink?has_content>
									<#local contactPerson = iuclid.getDocumentForKey(contactPersonLink.ContactPerson)/>
									<#if contactPerson?has_content>
										Name: <@com.value contactPerson.GeneralInfo.LastName "" /><#if contactPerson.GeneralInfo.FirstName?has_content && contactPerson.GeneralInfo.LastName?has_content>, </#if><@com.value contactPerson.GeneralInfo.FirstName "" /><?linebreak?>
										Organisation: <@com.value contactPerson.GeneralInfo.Organisation "" /><?linebreak?>
										Phone: <@com.value contactPerson.GeneralInfo.Phone "" /><?linebreak?>
										E-mail: <@com.value contactPerson.GeneralInfo.Email "" /><?linebreak?>
										<#if contactPerson.GeneralInfo.Fax?has_content>Fax: <@com.value contactPerson.GeneralInfo.Fax "" /></#if>
									</#if>
									</#if>
								</td>
							</tr>
						</#list>
					</#list>
				<#else>
					<tr><td colspan="2">No information on the owner of the manufacturing plant provided</td></tr>
				</#if>
			</#if>

			<#-- rows for the location of the plant -->
			<tr><td colspan="2"><?dbfo bgcolor="${bgcolor}"?><emphasis role='bold'>${sectionTitles[1]}</emphasis></td></tr>

			<tr>
				<td>
					<emphasis role='bold'>Name</emphasis>
				</td>
				<td>
					<@com.value valuePath=site.GeneralInfo.SiteName format=''/>
				</td>
			</tr>

			<tr>
				<td>
					<emphasis role='bold'>Address</emphasis>
				</td>
				<td>
					<#local contactPath = site.ContactAddress/>

					<@com.value contactPath.Address1 "" /><?linebreak?>
					<@com.value contactPath.Address2 "" /><?linebreak?>
					<#local contactAddInfoList = []/>
					<#list [contactPath.Postal, contactPath.Town, contactPath.Region, contactPath.Country] as contactAddInfoPath>
						<#local contactAddInfo><@com.value contactAddInfoPath "" /></#local>
						<#if contactAddInfo?has_content>
							<#local contactAddInfoList += [contactAddInfo]/>
						</#if>
					</#list>
					${contactAddInfoList?join(", ")}
				</td>
			</tr>

			<tr>
				<td>
					<emphasis role='bold'>Phone</emphasis>
				</td>
				<td>
					<@com.value valuePath=site.ContactAddress.Phone format=''/>
				</td>
			</tr>


			</tbody>

		</informaltable>

</#macro>

<#macro manufacturingProcessImpuritiesInfo manufacturingDoc>

	<#local impurityMatch = false/>

	<#if _mixture?? && _mixture?has_content>
	
		<#-- extract the SITE from the manufacturing document -->
		<#local manufacturingSites = []/>
		<#list manufacturingDoc.AdministrativeData.ManufacturingPlantSite as manufacturingSiteLink>
			<#--  <#local manufacturingSite = iuclid.getDocumentForKey(manufacturingSiteLink) />  -->
			<#local manufacturingSites += [manufacturingSiteLink]/>
		</#list>

		<#-- ensure there are manufacturing sites -->
		<#if manufacturingSites?has_content>

			<#-- get impurities doc, iterate and match the SITE with the SITE in the manufacturingDOC -->
			<#local impuritiesDocList = iuclid.getSectionDocumentsForParentKey(_mixture.documentKey, "FLEXIBLE_SUMMARY", "Impurities") />
			<#list impuritiesDocList as impuritiesDoc>
				
				<#list impuritiesDoc.ListOfImpurities.Impurities as impurity>

					<#-- ensure an impurity is linked -->
					<#if impurity.ImpurityLink?has_content>

						<#-- check if match and retrieve the list of origins that match -->
						<#local matchedOriginImpList = []/>
						<#list impurity.FormationImp as impurityOrigin>

							<#if impurityOrigin.ManufacturingPlants?has_content>
								<#--  <#local impuritySite = iuclid.getDocumentForKey(impurityOrigin.ManufacturingPlants) />  -->
							
								<#-- if match, get information to hash -->
								<#if impurityOrigin.ManufacturingPlants?has_content && manufacturingSites?seq_contains(impurityOrigin.ManufacturingPlants)>
									<#local impurityMatch = true/>
									<#local matchedOriginImpList += [impurityOrigin]/>
								</#if>
							</#if>
						</#list>

						<#-- print information -->
						<#if matchedOriginImpList?has_content>

							<#-- print general info on impurity -->

							<#local impSub = iuclid.getDocumentForKey(impurity.ImpurityLink) />
							<#local reference = impSub/>
							<#if impSub.documentType=="SUBSTANCE">
								<#local reference = iuclid.getDocumentForKey(impSub.ReferenceSubstance.ReferenceSubstance) />
							</#if>
							<#if reference?has_content>
								<#local impSubName><@com.value valuePath=reference.ReferenceSubstanceName format=""/></#local>
							<#else>
								<#local impSubName><@com.text impSub.name ""/></#local>
							</#if>
							
							<#local impCode><@com.value valuePath=impurity.CodeNameOfTheImpurity format=""/></#local>

							<para>
								<emphasis role='underline'><command linkend="${reference.documentKey!}">${impSubName}</command></emphasis>
								<#if impCode?has_content && impCode != impSubName> (code: ${impCode})</#if>
								<#if impurity.Type?has_content> [type: <@com.value valuePath=impurity.Type/>]</#if>
							</para>

							<#list matchedOriginImpList as matchedOriginImp>

								<#if (matchedOriginImpList?size>1)>#{matchedOriginImp?index+1}</#if>

								<#local impSite = iuclid.getDocumentForKey(matchedOriginImp.ManufacturingPlants)/>

								<#-- print manufacturing plant only if >1 -->
								<#if (manufacturingSites?size>1)>
									<@com.formattedValue valuePath=impSite.GeneralInfo.SiteName format="" tabular=true/>
								</#if>
								<#--  <para role='indent'>Origin: <@com.value valuePath=matchedOriginImp.OriginImp/></para>  -->
								<@com.formattedValue valuePath=matchedOriginImp.OriginImp customValueName="Origin" tabular=true/>
								
								<#if matchedOriginImp.Reactionscheme?has_content>
									<@com.formattedValue valuePath='' customValueName="Reaction scheme" printOnlyTitle=true tabular=true/>
									<@com.printImage attachmentPath=matchedOriginImp.Reactionscheme imageWidthPerc=100 printTitle=false informal=true/>
								<#else>
									<@com.formattedValue valuePath='' customValueName="Reaction scheme" customValue="No reaction scheme provided." tabular=true/>
								</#if>
								
								<#--  <#if matchedOriginImp.Remarks?has_content><para role='indent'>Remarks: <@com.value valuePath=matchedOriginImp.Remarks/></para></#if>  -->
								<@com.formattedValue valuePath=matchedOriginImp.Remarks tabular=true/>

							</#list>

						</#if>

					</#if>

				</#list>

			</#list>
		</#if>
	</#if>

	<#-- if no match, report some text -->
	<#if !impurityMatch>
		<para>No impurities information reported for the manufacturing plant(s) of this method of manufacture.</para>
	</#if>

</#macro>

<#-- packaging outputs the contents of the FLEXIBLE_RECORD.Packaging document

	Inputs:
	- _subject: ENTITY in which the document is found
-->
<#macro packaging _subject>
	<#compress>

		<#assign recordList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "FLEXIBLE_RECORD", "Packaging") />

		<#if !(recordList?has_content)>
			No relevant information on packaging available.
		
		<#else>

			<#list recordList as record>

				<#--Get hyperlink and print record's name (with a numbering system if more than one)-->
				<#local docUrl=iuclid.webUrl.documentView(record.documentKey) />
				<para><emphasis role="HEAD-WoutNo"><#if (recordList?size>1)>Packaging #${record_index+1}:</#if><ulink url="${docUrl}"><@com.text record.name/></ulink></emphasis></para>

				<#--Use-->
				<#if record.Packaging.UseOrComposition?has_content>
					<para><emphasis role="bold">Applied to: </emphasis></para>

					<#list record.Packaging.UseOrComposition as useLink>
						<#local use = iuclid.getDocumentForKey(useLink)>
						<para role="indent"><@com.value use.GeneralInformation.Name/></para>
					</#list>
				</#if>

				<#--Characteristics-->
				<para><emphasis role="bold">Characteristics of the packaging: </emphasis></para>

				<#if record.Packaging.TypeOfPackaging?has_content>
					<para role="indent"><emphasis role="underline">Type:</emphasis> <@com.value record.Packaging.TypeOfPackaging/></para>
				</#if>

				<#if record.Packaging.SizeOfPackagingInContactWithTheProductContainerSize?has_content>
					<para role="indent"><emphasis role="underline">Size:</emphasis>
						<#list record.Packaging.SizeOfPackagingInContactWithTheProductContainerSize as size>
							<@com.range size.SizeOfPackaging/><#if size_has_next>, </#if>
						</#list>
					</para>
				</#if>

				<#if record.Packaging.MaterialOfPackaging?has_content>
					<para role="indent"><emphasis role="underline">Material:</emphasis> <@com.value record.Packaging.MaterialOfPackaging/></para>
				</#if>

				<#if record.Packaging.Compatibility?has_content>
					<para role="indent"><emphasis role="underline">Compatibility of the product:</emphasis></para>
					<para role="indent2"><@com.value record.Packaging.Compatibility/></para>
				</#if>

				<#if record.Packaging.FurtherDescription?has_content>
					<para role="indent"><emphasis role="underline">Further description:</emphasis></para>
					<para role="indent2"><@com.value record.Packaging.FurtherDescription/></para>
				</#if>

				<#if record.Packaging.SafetyFeaturesOfThePackaging?has_content>
					<para role="indent"><emphasis role="underline">Safety features:</emphasis></para>
					<para role="indent2"><@com.value record.Packaging.SafetyFeaturesOfThePackaging/></para>
				</#if>

				<#if record.Packaging.Description?has_content>
					<para role="indent"><emphasis role="underline">Secondary packaging (not in contact with product):</emphasis></para>
					<para role="indent2"><@com.value record.Packaging.Description/></para>
				</#if>

				<#--Additional info-->
				<#if record.Packaging.AdditionalInfo?has_content>
					<para><emphasis role="bold">Additional information:</emphasis></para>
					<para role="indent"><para style="background-color:#f7f7f7"><@com.value record.Packaging.AdditionalInfo/></para></para>
				</#if>

			</#list>
		</#if>

	</#compress>

</#macro>

<#-- protectionMeasures outputs the contents of the FLEXIBLE_RECORD.ProtectionMeasures document

	Inputs:
	- _subject: ENTITY in which the document is found
	- selectedSection: string to select subsections of document to be printed ("handling", "accident", "destruction", "instructions")
	- otherMixturePPP: bool; if true prints Instructions of use even if pppRelevant and ENTITY is a mixture
-->
<#macro protectionMeasures _subject selectedSection='' otherMixturePPP=false>
	<#compress>

		<#assign recordList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "FLEXIBLE_RECORD", "ProtectionMeasures") />

		<#if !(recordList?has_content)>
			No relevant information on protection measures available.
		
		<#else>
		
			<#list recordList as record>

				<#--Get hyperlink and print record's name (with a numbering system) if more than one-->
				<#local docUrl=iuclid.webUrl.documentView(record.documentKey) />
				<#if (recordList?size>1)><para><emphasis role="HEAD-WoutNo">Record #${record_index+1}:<ulink url="${docUrl}"><@com.text record.name ""/></ulink></emphasis></para></#if>

				<#--Instructions-->
				<#if (!selectedSection?has_content) || ['instructions', 'handling']?seq_contains(selectedSection)>
					<#if (!pppRelevant??) || _subject.documentType=="SUBSTANCE" || otherMixturePPP> <#-- for PPP, only for substance (for product is in b3) or other mixtures printed in Vol 4 -->
						<#if record.InstructionsForUse.InstructionsForUse?has_content>
							<#if selectedSection!='instructions'><para><emphasis role="bold">Instructions of use: </emphasis></para></#if>
							<para role="indent2"><para style="background-color:#f7f7f7" ><@com.value record.InstructionsForUse.InstructionsForUse/></para></para>
						</#if>
					</#if>
				</#if>

				<#--Measures to protect humans etc-->
				<#if record.MeasuresToProtect?has_content>
					<#if !selectedSection?has_content><para><emphasis role="bold">Measures to protect humans, animals and the environment: </emphasis></para></#if>

					<#local measures=record.MeasuresToProtect/>

					<#if (!selectedSection?has_content) || selectedSection=='handling'>

						<#if measures.RecommendedMethodsAndPrecautionsConcerningStorage?has_content>
							<#if !selectedSection?has_content><para role="indent"><emphasis role="underline"><#else><para><emphasis role="bold"></#if>Recommended methods and precautions concerning storage:</emphasis></para>
							<para role="indent2"><para style="background-color:#f7f7f7" ><@com.value measures.RecommendedMethodsAndPrecautionsConcerningStorage/></para></para>
						</#if>

						<#if measures.RecommendedMethodsAndPrecautionsConcerningHandling?has_content>
							<#if !selectedSection?has_content><para role="indent"><emphasis role="underline"><#else><para><emphasis role="bold"></#if>Recommended methods and precautions concerning handling and transport:</emphasis></para>
							<para role="indent2"><@com.value measures.RecommendedMethodsAndPrecautionsConcerningHandling 'literal'/></para>
						</#if>

						<#if measures.RecommendedMethodsAndPrecautionsConcerningFire?has_content>
							<#if !selectedSection?has_content><para role="indent"><emphasis role="underline"><#else><para><emphasis role="bold"></#if>Recommended methods and precautions concerning fire:</emphasis></para>
							<para role="indent2"><@com.value measures.RecommendedMethodsAndPrecautionsConcerningFire 'literal'/></para>
						</#if>
					</#if>

					<#if (!selectedSection?has_content) || selectedSection=='accident'>
						
						<#if measures.ParticularsOfLikelyDirect?has_content>
							<#if !selectedSection?has_content><para role="indent"><emphasis role="underline"><#else><para><emphasis role="bold"></#if>Particulars of likely direct or indirect adverse effects:</emphasis></para>
							<para role="indent2"><para style="background-color:#f7f7f7" ><@com.value measures.ParticularsOfLikelyDirect/></para></para>
						</#if>

						<#if measures.FirstAidInstructionsAntidotes?has_content>
							<#if !selectedSection?has_content><para role="indent"><emphasis role="underline"><#else><para><emphasis role="bold"></#if>First aid instructions, antidotes:</emphasis></para>
							<para role="indent2"><@com.value measures.FirstAidInstructionsAntidotes 'literal'/></para>
						</#if>

						<#if measures.EmergencyMeasuresToProtectEnvironmentInCaseOfAccident?has_content>
							<#if !selectedSection?has_content><para role="indent"><emphasis role="underline"><#else><para><emphasis role="bold"></#if>Emergency measures to protect the environment in case of accident:</emphasis></para>
							<para role="indent2"><@com.value measures.EmergencyMeasuresToProtectEnvironmentInCaseOfAccident 'literal'/></para>
						</#if>

						<#if (!pppRelevant??) || _subject.documentType=="MIXTURE"><#-- for PPP, only for products -->
							<#if measures.ControlMeasuresOfRepellents?has_content || measures.RiskMitigationMeasures?has_content>
								<#if !selectedSection?has_content><para role="indent"><emphasis role="underline"><#else><para><emphasis role="bold"></#if>Control measures of repellents or poison included in the product, to prevent action against non-target organisms:</emphasis></para>
								<para role="indent2"><@com.value measures.RiskMitigationMeasures/></para>
								<#if !selectedSection?has_content><para role="indent2"><#else><para role="indent"></#if><para style="background-color:#f7f7f7"><@com.value measures.ControlMeasuresOfRepellents/></para></para>
							</#if>
						</#if>
					</#if>

					<#if (!selectedSection?has_content)> <#-- print here if whole document -->
						<#if measures.Procedures?has_content>
							<para role="indent"><emphasis role="underline">Procedures for cleaning application equipment:</emphasis></para>
							<para role="indent2"><@com.value measures.Procedures 'literal'/></para>
						</#if>
					</#if>
				</#if>

				<#--Destruction-->
				<#if (!selectedSection?has_content) || selectedSection=='destruction'>

					<#if record.PossibilityOfDestructionOrDecontamination?has_content>
						<para><emphasis role="bold">Possibility of destruction or decontamination following release in or on the following: </emphasis></para>

						<#local dest=record.PossibilityOfDestructionOrDecontamination/>

						<#if dest.Air?has_content>
							<para role="indent"><emphasis role="underline">Air:</emphasis></para>
							<para role="indent2"><@com.value dest.Air 'literal'/></para>
						</#if>

						<#if dest.Water?has_content>
							<para role="indent"><emphasis role="underline">Water:</emphasis></para>
							<para role="indent2"><@com.value dest.Water 'literal'/></para>
						</#if>

						<#if dest.Soil?has_content>
							<para role="indent"><emphasis role="underline">Soil:</emphasis></para>
							<para role="indent2"><@com.value dest.Soil 'literal'/></para>
						</#if>
					</#if>

					<#--Waste-->
					<#if record.ProceduresForWasteManagement?has_content>
						<para><emphasis role="bold">Procedures for waste management: </emphasis></para>

						<#local waste=record.ProceduresForWasteManagement/>

						<#if waste.PossibilityOfReuseOrRecycling?has_content>
							<para role="indent"><emphasis role="underline">Possibility of reuse or recycling:</emphasis></para>
							<para role="indent2"><@com.value waste.PossibilityOfReuseOrRecycling 'literal'/></para>
						</#if>

						<#if waste.PossibilityOfNeutralisationOfEffects?has_content>
							<para role="indent"><emphasis role="underline">Neutralisation procedure and possibility of neutralisation of effects:</emphasis></para>
							<para role="indent2"><@com.value waste.PossibilityOfNeutralisationOfEffects 'literal'/></para>
						</#if>

						<#if waste.ConditionsForControllerDischarge?has_content>
							<para role="indent"><emphasis role="underline">Conditions for controlled discharge including leachate qualities on disposal:</emphasis></para>
							<para role="indent2"><@com.value waste.ConditionsForControllerDischarge 'literal'/></para>
						</#if>

						<#if waste.ConditionsForControllerIncineration?has_content>
							<para role="indent"><emphasis role="underline">Conditions for controlled incineration:</emphasis></para>
							<para role="indent2"><@com.value waste.ConditionsForControllerIncineration 'literal'/></para>
						</#if>

						<#if waste.InstructionsForSafeDisposal?has_content>
							<para role="indent"><emphasis role="underline">Instructions for safe disposal of the product and its packaging for different groups of users:</emphasis></para>
							<para role="indent2"><para style="background-color:#f7f7f7" ><@com.value waste.InstructionsForSafeDisposal/></para></para>
						</#if>
					</#if>

					<#-- cleaning -->
					<#if selectedSection?has_content> <#-- print here if selected section-->
						<#if record.MeasuresToProtect.Procedures?has_content>
							<para><emphasis role="bold">Procedures for cleaning application equipment:</emphasis></para>
							<para role="indent"><@com.value record.MeasuresToProtect.Procedures 'literal'/></para>
						</#if>
					</#if>

				</#if>

				<#--References-->
				<#if !selectedSection?has_content> 
					<#if record.AdditionalInformation.Reference?has_content>
					<para><emphasis role="bold">References: </emphasis></para>

						<#list record.AdditionalInformation.Reference as refLink>
							<#local ref=iuclid.getDocumentForKey(refLink)>
							<para role="indent">
								<@com.value ref.GeneralInfo.Name ""/>, <@com.value ref.GeneralInfo.Author ""/>, <@com.value ref.GeneralInfo.ReferenceYear ""/>
								<#if ref.GeneralInfo.ReportNo?has_content>(<@com.value ref.GeneralInfo.ReportNo ""/>)</#if>
								<#if ref.GeneralInfo.LiteratureType?has_content>[<@com.value ref.GeneralInfo.LiteratureType/>]</#if>
							</para>
						</#list>
					</#if>
				</#if>

			</#list>
		</#if>
	</#compress>
</#macro>

<#-- assessmentOtherAuthorities outputs the contents of the FLEXIBLE_RECORD.AssessmentOtherAuthorities document

	Inputs:
	- _subject: ENTITY (SUBSTANCE, MIXTURE) in which the document is found
	- addInfo: if True, print the additional information section
-->
<#macro assessmentOtherAuthorities _subject addInfo=true bgcolor="#FBDDA6">
	<#compress>

		<#assign studyList = iuclid.getSectionDocumentsForParentKey(_subject.documentKey, "FLEXIBLE_RECORD", "AssessmentOtherAuthorities") />

		<#if !(studyList?has_content)>
			<@com.emptyLine/>
			No information on assessment by other authorities available.
			<@com.emptyLine/>
		<#else>
			<#list studyList as study>

				<#--Get hyperlink and print record's name (with a numbering system if more than one)-->
				<#local docUrl=iuclid.webUrl.documentView(study.documentKey) />
				<@com.emptyLine/>
				<para><emphasis role="HEAD-WoutNo"><#if (studyList?size>1)>#${study_index+1}: </#if>Title:<ulink url="${docUrl}"><@com.text study.name ""/></ulink></emphasis></para>

				<#--Assessments in Europe-->
				<#if study.AssessmentsEurope?has_content>

					<para><emphasis role="bold">Assessments in Europe:</emphasis></para>

					<#--List of assessments-->
					<#if study.AssessmentsEurope.Biocide?has_content ||
							study.AssessmentsEurope.VeterinaryMedicine?has_content ||
							study.AssessmentsEurope.OtherProductSafetyAssessments?has_content>
						<#--  <para><emphasis role="underline">Assessments:</emphasis></para>  -->
						<@assessmentsTable path=study.AssessmentsEurope bgcolor=bgcolor/>
						<@com.emptyLine/>
					</#if>

					<#--Residue definitions-->
					<#if study.AssessmentsEurope.ExistingResidues?has_content>
						<para><emphasis role="underline">Existing residue definitions:</emphasis></para>
						<@existingResiduesTable path=study.AssessmentsEurope.ExistingResidues bgcolor=bgcolor/>
						<@com.emptyLine/>
					</#if>

					<#--MRLs-->
					<#if study.AssessmentsEurope.ExistingMrl.EuMrl?has_content>
						<para><emphasis role="underline">Existing MRLs:</emphasis></para>
						<@existingMRLsTable path=study.AssessmentsEurope.ExistingMrl.EuMrl bgcolor=bgcolor/>
						<@com.emptyLine/>
					</#if>
				</#if>

				<#--Assessments outside Europe-->
				<#if study.AssessmentsOutsideEurope?has_content>

					<para><emphasis role="bold">Assessments outside Europe:</emphasis></para>

					<#--List of assessments-->
					<#if study.AssessmentsOutsideEurope.Biocide?has_content ||
					study.AssessmentsOutsideEurope.VeterinaryMedicine?has_content ||
					study.AssessmentsOutsideEurope.OtherProductSafetyAssessments?has_content>
						<#--  <para><emphasis role="underline">Assessments:</emphasis></para>  -->
						<@assessmentsTable path=study.AssessmentsOutsideEurope bgcolor=bgcolor/>
						<@com.emptyLine/>
					</#if>

					<#--Residue definitions-->
					<#if study.AssessmentsOutsideEurope.ExistingResidues?has_content>
						<para><emphasis role="underline">Existing residue definitions:</emphasis></para>
						<@existingResiduesTable path=study.AssessmentsOutsideEurope.ExistingResidues bgcolor=bgcolor/>
						<@com.emptyLine/>
					</#if>

					<#--MRLs-->
					<#if study.AssessmentsOutsideEurope.MrlExportingCountries.ExportingCountryMrl?has_content>
						<para><emphasis role="underline">Existing MRLs:</emphasis></para>
						<@existingMRLsTable path=study.AssessmentsOutsideEurope.MrlExportingCountries.ExportingCountryMrl bgcolor=bgcolor/>
						<@com.emptyLine/>
					</#if>

				</#if>

				<#--Additional info-->
				<#if addInfo && study.AdditionalInformation?has_content>

					<para><emphasis role="bold">Additional information:</emphasis></para>

					<#if study.AdditionalInformation.RegistrationInExportingCountry ||
							study.AdditionalInformation.RegistrationInExportingCountryRemark?has_content>
						<para><emphasis role="underline">Evidence of registration in the exporting country:</emphasis>
							<#if study.AdditionalInformation.RegistrationInExportingCountry>yes (attached)<#else>no</#if>
							<para role="indent"><@com.value valuePath=study.AdditionalInformation.RegistrationInExportingCountryRemark format=''/></para>
						</para>
					</#if>

					<#if study.AdditionalInformation.LegislationInExportingCountry ||
						study.AdditionalInformation.LegislationExportingCountryRemark?has_content>
						<para><emphasis role="underline">Legislation in the exporting country concerning the MRL:</emphasis>
							<#if study.AdditionalInformation.LegislationInExportingCountry>yes (attached)<#else>no</#if>
							<para role="indent"><@com.value valuePath=study.AdditionalInformation.LegislationExportingCountryRemark format=''/></para>
						</para>
					</#if>

				</#if>

			</#list>
		</#if>

	</#compress>
</#macro>

<#-- importTolerances outputs the contents of the Additional information section 
	of the FLEXIBLE_RECORD.AssessmentOtherAuthorities document, which contain information related to
	import tolerances.

	Inputs:
	- _subject: ENTITY (SUBSTANCE, MIXTURE) in which the document is found
-->
<#macro importTolerances subject>
	<#compress>
		<#local studyList = iuclid.getSectionDocumentsForParentKey(subject.documentKey, "FLEXIBLE_RECORD", "AssessmentOtherAuthorities") />

		<#local tolerances=[]/>
		<#if studyList?has_content>
			<#list studyList as study>
				<#if study.AdditionalInformation?has_content>
					<#local tolerances = tolerances + [study.AdditionalInformation]/>
				</#if>
			</#list>
		</#if>

		<#if tolerances?has_content>
			<#list tolerances as tolerance>
				<#if (tolerances?size>1) ><para><emphasis role="HEAD-WoutNo">#${tolerance_index+1}</emphasis></para></#if>

				<#if tolerance.RegistrationInExportingCountry || tolerance.RegistrationInExportingCountryRemark?has_content>
					<para><emphasis role="underline">Evidence of registration in the exporting country:</emphasis>
						<#if tolerance.RegistrationInExportingCountry>yes<#else>no</#if>
						<para role="indent"><@com.value tolerance.RegistrationInExportingCountryRemark/></para>

						<#if tolerance.RegistrationInExportingCountryAttachments?has_content>
							<para role="indent"><emphasis role="underline">Attached files (evidence of registration):</emphasis></para>
							<#list tolerance.RegistrationInExportingCountryAttachments as row>
								<para role="indent2"><@com.value row.AttachedDocument/></para>
							</#list>
						</#if>

						<#if tolerance.RegisteredUsePatternExportingCountryAttachments?has_content>
							<para role="indent"><emphasis role="underline">Attached files (registered uses)</emphasis>:</para>
							<#list tolerance.RegisteredUsePatternExportingCountryAttachments as row>
								<para role="indent2"><@com.value row.AttachedDocument/></para>
							</#list>
						</#if>
					</para>
				</#if>

				<#if tolerance.LegislationInExportingCountry || tolerance.LegislationExportingCountryRemark?has_content>
					<para><emphasis role="underline">Legislation in the exporting country concerning the MRL:</emphasis>
						<#if tolerance.LegislationInExportingCountry>yes<#else>no</#if>
						<para role="indent"><@com.value tolerance.LegislationExportingCountryRemark/></para>

						<#if tolerance.LegislationExportingCountryAttachments?has_content>
							<para role="indent"><emphasis role="underline">Attached files:</emphasis></para>
							<#list tolerance.LegislationExportingCountryAttachments as row>
								<para role="indent2"><@com.value row.AttachedDocument/></para>
							</#list>
						</#if>
					</para>
				</#if>

				<@com.emptyLine/>

			</#list>

		<#else>
			<@com.emptyLine/>
			<para>No information on import tolerances available.</para>
			<@com.emptyLine/>
		</#if>

	</#compress>
</#macro>

<#-- assessmentsTable creates a table for the Assessments sections of the FLEXIBLE_RECORD.AssessmentOtherAuthorities document
	(e.g. in Europe and Outside europe).

	Inputs:
	- path: node corresponding to the assessments section e.g. AssessmentsEurope
-->
<#macro assessmentsTable path bgcolor="#FBDDA6">
	<#compress>

	<para role="small">
		<table border="1">
	<#--		<title></title>-->
			<col width="34%" />
			<col width="33%" />
			<col width="33%" />

			<thead align="center" valign="middle">
			<tr>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Evaluation</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Status</emphasis></th>
				<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
			</tr>
			</thead>

			<tbody>

			<#if path.Biocide?has_content>
				<tr>
					<td>biocides</td>
					<td><@com.value path.Biocide "en" false false false/></td>
					<td><@com.value path.Biocide.remarks/></td>
				</tr>
			</#if>

			<#if path.VeterinaryMedicine?has_content>
				<tr>
					<td>veterinary medicines</td>
					<td><@com.value path.VeterinaryMedicine "en" false false false/></td>
					<td><@com.value path.VeterinaryMedicine.remarks/></td>
				</tr>
			</#if>

			<#if path.OtherProductSafetyAssessments?has_content>

				<#list path.OtherProductSafetyAssessments as assess>
					<tr>
						<td><@com.value assess.Evaluation/></td>
						<td><@com.value assess.Status "en" false false false/></td>
						<td><@com.value assess.Status.remarks/></td>
					</tr>
				</#list>
			</#if>

			</tbody>
		</table>
	</para>

	</#compress>
</#macro>

<#-- existingResiduesTable creates a table for the Existing residue definitions sections 
	of the FLEXIBLE_RECORD.AssessmentOtherAuthorities document (e.g. in Europe and Outside europe).

	Inputs:
	- path: node corresponding to the existing residue definitions section e.g. AssessmentsEurope.ExistingResidues
-->
<#macro existingResiduesTable path bgcolor="#FBDDA6">
	<#compress>

		<#if path.MonitoringPurposesPlant?has_content ||
				path.RiskAssessmentPlant?has_content ||
				path.MonitoringPurposesAnimal?has_content ||
				path.RiskAssessmentAnimal?has_content> 
			<para role="small">
				<table border="1">
					<#--		<title></title>-->
					<col width="35%" />
					<col width="65%" />

	<#--				<thead align="center" valign="middle"><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if>-->

					<tbody>

					<#if path.MonitoringPurposesPlant?has_content>
						<tr>
							<td><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if>Plant - monitoring</td>
							<td><@com.value path.MonitoringPurposesPlant/></td>
						</tr>
					</#if>

					<#if path.RiskAssessmentPlant?has_content>
						<tr>
							<td><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if>Plant - risk assessment</td>
							<td><@com.value path.RiskAssessmentPlant/></td>
						</tr>
					</#if>

					<#if path.MonitoringPurposesAnimal?has_content>
						<tr>
							<td><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if>Animal - monitoring</td>
							<td><@com.value path.MonitoringPurposesAnimal/></td>
						</tr>
					</#if>

					<#if path.RiskAssessmentAnimal?has_content>
						<tr>
							<td><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if>Animal - risk assessment</td>
							<td><@com.value path.RiskAssessmentAnimal/></td>
						</tr>
					</#if>

					</tbody>
				</table>
			</para>
		</#if>

		<#if path.Remarks?has_content>
			<@com.emptyLine/>
			<para>Remarks: <@com.value path.Remarks/></para>
		</#if>

		<#if path.hasElement("EfsaParamCode")>
			<#if path.EfsaParamCode?has_content>
				<@com.emptyLine/>
				<para>EFSA paramCode:</para>
				<#list path.EfsaParamCode as param>
					<para role="indent"><@com.value param.RdParamCode/></para>
				</#list>
			</#if>
		</#if>

	</#compress>
</#macro>

<#-- existingResiduesTable creates a table for the Existing MRL sections 
	of the FLEXIBLE_RECORD.AssessmentOtherAuthorities document (e.g. in Europe and Outside europe).

	Inputs:
	- path: node corresponding to the existing residue definitions section e.g. AssessmentsEurope.ExistingMrl
-->
<#macro existingMRLsTable path bgcolor="#FBDDA6">
	<#compress>

		<para role="small">
			<table border="1">
				<#--<title></title>-->
				<#if path[0].hasElement("Country")>
					<col width="18%"/>
					<col width="34%" />
					<col width="23%" />
					<col width="15%" />
					<col width="10%" />
				<#else>
					<col width="40%" />
					<col width="30%" />
					<col width="20%" />
					<col width="10%" />
				</#if>


				<thead align="center" valign="middle">
				<tr>
					<#if path[0].hasElement("Country")>
						<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Country</emphasis></th>
					</#if>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Commodity</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Residue definition monitoring</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">MRL value</emphasis></th>
					<th><#if bgcolor?has_content><?dbfo bgcolor="${bgcolor}"?></#if><emphasis role="bold">Remarks</emphasis></th>
				</tr>
				</thead>

				<tbody>
					<#--NOTE: it doesn't sort even if values provided-->
					<#local mrlList=iuclid.sortByField(path, "Country", [])/>

					<#--  Initialize the counter that keeps track of the remarks index  -->
					<#local remarksCounter = 0 />

					<#list mrlList as mrl>
						<tr>
							<#if mrl.hasElement("Country")>
								<td><@com.value mrl.Country/></td>
							</#if>
							<td><@com.value mrl.Commodity/></td>
							<td><@com.value mrl.ResidueMonitoring/></td>
							<td><@com.value mrl.MrlValue/></td>
							<td>
								<#if mrl.Remarks?has_content>
									<#local remarksCounter++ />

									<emphasis>(${remarksCounter})</emphasis>
								</#if>
								<#--  <@com.value mrl.Remarks/>  -->
							</td>
						</tr>
					</#list>
				</tbody>
			</table>

			<para role="small">
				<emphasis>
					<@com.printRemarksFromTable mrlList />
				</emphasis>
			</para>
		</para>
	</#compress>
</#macro>

<#-- summaryEvaluationPPP outputs the contents of the FLEXIBLE_SUMMARY.SummaryEvaluation_EU_PPP document

	Inputs:
	- summary: document to be printed
	- bgcolor: parameter to set background color of table headers
-->	
<#macro summaryEvaluationPPP summary bgcolor="#d3d3d3">

	<#if summary?has_content>

		<#-- Administrative data -->
		<#if summary.hasElement("AdministrativeDataSummary.ComplementaryInformation") && summary.AdministrativeDataSummary.ComplementaryInformation?has_content>
			<para><emphasis role="bold">Complementary information</emphasis>: <@com.value summary.AdministrativeDataSummary.ComplementaryInformation/></para>
		</#if>

		<#-- Reports and administrative information -->
		<#if summary.hasElement("ReportsAdministrativeInfo.ReportsAdministrativeInfo") && summary.ReportsAdministrativeInfo.ReportsAdministrativeInfo?has_content>
			<#local infoTable = summary.ReportsAdministrativeInfo.ReportsAdministrativeInfo>
			<#--  CREATE TABLE  -->
    		<table border="1">
        		<#--  Assign title  -->
        		<title>Reports and administrative information</title>

        		<#--  Set columns width  -->
        		<col width="33%"/>
        		<col width="33%"/>
        		<col width="33%"/>
            
        		<#--  Define table header  -->
        		<thead align="center" valign="middle">
            		<tr><?dbfo bgcolor="${bgcolor}" ?>
                		<th>
                    		<emphasis role="bold">Type of report</emphasis>
                		</th>
                		<th>
                    		<emphasis role="bold">Attached document</emphasis>
                		</th>
                		<th>
                    		<emphasis role="bold">Attached (sanitised) document for publication</emphasis>
                		</th>                  
            		</tr>
        		</thead>
            
        		<#--  Define table body  -->
        		<tbody align="center" valign="middle">
            		<#--  Iterate over rows  -->
            		<#list infoTable as report>
                		<tr>
                    		<#-- Type of report -->
                    		<td>
                        		<@com.value report.TypeOfReport ""/>
                    		</td>

                    		<#-- Attached document -->
                    		<td>
								<@com.printImage attachmentPath=report.AttachedDocument imageWidthPerc=70 printTitle=false informal=true url=iuclid.webUrl.documentView(summary.documentKey) printMetaDataIfNotImage=true/>    
                    		</td>

                    		<#-- Attached (sanitised) document for publication -->
                    		<td>
								<@com.printImage attachmentPath=report.SanitisedDocument imageWidthPerc=70 printTitle=false informal=true url=iuclid.webUrl.documentView(summary.documentKey) printMetaDataIfNotImage=true/>
                    		</td>                       
                		</tr>
            		</#list>
        		</tbody>
    		</table>	
		</#if>

		<#-- Letter(s) of access -->
		<#if summary.hasElement("LettersOfAccess.LettersOfAccess") && summary.LettersOfAccess.LettersOfAccess?has_content>
			<#local lettersTable = summary.LettersOfAccess.LettersOfAccess>
			<#--  CREATE TABLE  -->
    		<table border="1">
        		<#--  Assign title  -->
        		<title>Letter(s) of access</title>

        		<#--  Set columns width  -->
        		<col width="25%"/>
        		<col width="25%"/>
        		<col width="25%"/>
				<col width="25%"/>
            
        		<#--  Define table header  -->
        		<thead align="center" valign="middle">
            		<tr><?dbfo bgcolor="${bgcolor}" ?>
                		<th>
                    		<emphasis role="bold">Type of document</emphasis>
                		</th>
                		<th>
                    		<emphasis role="bold">Attached document</emphasis>
                		</th>
                		<th>
                    		<emphasis role="bold">Attached (sanitised) document for publication</emphasis>
                		</th>

						<#-- "Related studies" field seems not to be selectable -->

						<th>
                    		<emphasis role="bold">Remarks</emphasis>
                		</th>                 
            		</tr>
        		</thead>
            
        		<#--  Define table body  -->
        		<tbody align="center" valign="middle">
            		<#--  Iterate over rows  -->
            		<#list lettersTable as letter>
                		<tr>
                    		<#-- Type of document -->
                    		<td>
                        		<@com.value letter.TypeOfDocument/>
                    		</td>

                    		<#-- Attached document -->
                    		<td>
								<@com.printImage attachmentPath=letter.AttachedDocument imageWidthPerc=70 printTitle=false informal=true url=iuclid.webUrl.documentView(summary.documentKey) printMetaDataIfNotImage=true/>   
                    		</td>

                    		<#-- Attached (sanitised) document for publication -->
                    		<td>
								<@com.printImage attachmentPath=letter.AttachedSanitisedDocumentForPublication imageWidthPerc=70 printTitle=false informal=true url=iuclid.webUrl.documentView(summary.documentKey) printMetaDataIfNotImage=true/>
                    		</td>

							<#-- Remarks -->
							<td>
                        		<@com.value letter.Remarks ""/>
                    		</td>                       
                		</tr>
            		</#list>
        		</tbody>
    		</table>	
		</#if> 

		<#-- Other references (including SDS) -->
		<#if summary.hasElement("OtherReferencesIncludingSDS.References") && summary.OtherReferencesIncludingSDS.References?has_content>
			<para><emphasis role="bold">References</emphasis>:
				<#list summary.OtherReferencesIncludingSDS.References as reference>
					<#local studyLink = com.getStudyLink(reference)/>
					${studyLink}<#if reference?has_next>; </#if>	
				</#list>	
			</para>
		</#if>  
	</#if>
</#macro>

<#-- mixtureName outputs the name of a MIXTURE entity with a hyperlink to the document
	NOTE: Macros to be moved to macros_common_general

	Inputs: 
	- _subject: MIXTURE ENTITY
-->
<#macro mixtureName _subject>
	<#compress>
		<#if _subject.documentType=="MIXTURE">

			<#local docUrl=iuclid.webUrl.entityView(_subject.documentKey)/>

			<#if docUrl?has_content>
				<ulink url="${docUrl}"><@com.text _subject.MixtureName ""/></ulink>
			<#else>
				<@com.text _subject.MixtureName ""/>
			</#if>
		</#if>
	</#compress>
</#macro>

