
<#import "../efsa_common_ftls/docbook/appendixE.ftl" as keyAppendixE>
<#import "../../common_modules/docbook/macros_common_general.ftl" as com>
<#import "../../common_modules/docbook/macros_common_studies_and_summaries.ftl" as studyandsummaryCom>
<#import "../../common_modules/docbook/common_module_administrative_information.ftl" as keyAdm>
<#import "../../common_modules/docbook/common_module_biological_properties_microorganism.ftl" as keyBioPropMicro/>
<#import "../../common_modules/docbook/common_module_physical_chemical_summary_properties.ftl" as keyPhysChemSummary/>
<#import "../../common_modules/docbook/common_module_human_health_hazard_assessment_of_physicochemical_properties.ftl" as keyPhyschem>
<#import "../../common_modules/docbook/common_module_analytical_methods.ftl" as keyAnMeth>
<#import "../../common_modules/docbook/common_module_human_health_hazard_assessment.ftl" as keyTox>
<#import "../../common_modules/docbook/common_module_residues.ftl" as keyRes/>
<#import "../../common_modules/docbook/common_module_environmental_fate_properties.ftl" as keyFate>
<#import "../../common_modules/docbook/common_module_literature_data.ftl" as keyLit>
<#import "../../common_modules/docbook/common_module_traversal_utils_new.ftl" as utils>
<#import "../efsa_common_ftls/docbook/macros_litRefs.ftl" as litRefs>
<#import "../efsa_common_ftls/docbook/macros_identity_ppp.ftl" as pppId>
<#import "../efsa_common_ftls/docbook/macros_gap.ftl" as keyGAP>

<#assign locale = "en" />
<#assign sysDateTime = .now>

<#-- Initialize the following variables:
	* _dossierHeader (:DossierHashModel) //The header document of a proper or 'raw' dossier, can be empty
	* _subject (:DocumentHashModel) //The dossier subject document or, if not in a dossier context, the root document, never empty
	-->
<@com.initializeMainVariables/>

<#--Initialize relevance-->
<@com.initiRelevanceForPPP relevance/>

<#--get name of the entity-->
<#assign ownerLegalEntityMain = iuclid.getDocumentForKey(_subject.OwnerLegalEntity) />
<#assign thirdPartyLegalEntityMain = iuclid.getDocumentForKey(_subject.ThirdParty) />
<#if _dossierHeader??><#assign submittingLegalEntity = iuclid.getDocumentForKey(_dossierHeader.submittingLegalEntityKey) /></#if>

<#--get dossier/subject uuid used in mrl_instructions.ftl-->
<#if _dossierHeader??>
	<#assign subjectId = com.sanitizeUUID(_dossierHeader.subjectKey)/>
<#else>
	<#assign subjectId = _subject.documentKey.uuid/> 
</#if>	

<#if _subject.documentType=="MIXTURE">
    <#global _metabolites = com.getMetabolites(_subject)/>

	<#global _mixture = _subject/>

    <#assign activeSubstanceList = com.getComponents(_subject, "active substance") />

    <#if activeSubstanceList?has_content>
        <#assign activeSubstance = activeSubstanceList[0] />

        <#global _subjectMixture=_subject/>

        <#global _subject=activeSubstance/>
    </#if>
<#elseif _subject.documentType=="SUBSTANCE">
    <#assign activeSubstance=_subject/>
</#if>

<#global workingContext="MRL"/>
<#assign docNameCode=""/>


<#if !(activeSubstance??)>
    <#assign errorMessage="The mixture does not contain an active substance! Please, add an active substance in the mixture composition and try again"/>
<#elseif !(_dossierHeader??)>
    <#assign errorMessage="Not a dossier! Plase, run Report Generator from a dossier."/>
</#if>

<#if !(errorMessage??)>
<book version="5.0" xmlns="http://docbook.org/ns/docbook" xmlns:xi="http://www.w3.org/2001/XInclude">
    <#assign left_header_text = ''/>
    <#assign central_header_text = com.getReportSubject(rootDocument).name?html />
    <#assign right_header_text = ''/>

    <#assign left_footer_text = "IUCLID 6 " + iuclid6Version!/>
    <#assign central_footer_text = 'MRL Report' />
    <#assign right_footer_text = ''/>

	<#assign appPurpose=_dossierHeader.MRLApplication.DossierSpecificInformation.Purpose />
	<#assign appEMS=_dossierHeader.MRLApplication.DossierSpecificInformation.EMS />
	<#assign mrlHash=keyRes.getMRLhash([], _subject)/>

	<article role="NotInToc">
		<simplesect>
			<title>Version history</title>
			<revhistory role="MRL">
				<#list 1..5 as x>
					<revision>
						<date></date>
						<revnumber></revnumber>
						<revremark></revremark>
					</revision>
				</#list>
			</revhistory>
		</simplesect>
	</article>

    <info>
        <title>MRL REPORT</title>

        <cover>
            <@com.emptyLine/>
            <para>
				<#include "mrl_instructions.ftl"/>
				<@com.emptyLine/>

				<para>
                    <emphasis role="bold">Submission Date (MM and YYYY):</emphasis>
                </para>
				<@com.emptyLine/>

				<para>
                    <emphasis role="bold">Subsequent Submissions Date (MM and YYYY):</emphasis>
                </para>
				<@com.emptyLine/>

                <para>
                    <emphasis role="bold">Substance Name:</emphasis> <@com.substanceName _subject/>
                </para>
				<@com.emptyLine/>

                <para>
                    <emphasis role="bold">Applicant's Identity: </emphasis><#if ownerLegalEntityMain?has_content><@com.text ownerLegalEntityMain.GeneralInfo.LegalEntityName ""/></#if>
                </para>

				<#if appPurpose?has_content>
					<@com.emptyLine/>

					<para><emphasis role="bold">Purpose of the application:</emphasis></para>

					<para>
						<itemizedlist>
							<#list appPurpose as purpose>
								<listitem><@com.picklist purpose/></listitem>
							</#list>
						</itemizedlist>
					</para>
				</#if>

				<#if mrlHash?has_content><#-- report ONLY proposed commodities -->
					<@com.emptyLine/>

					<para><emphasis role="bold">Commodity:</emphasis></para>
						
					<para>
						<itemizedlist>
							<#list mrlHash['MRLtable'] as commodity, commodityData>
								<#if commodityData["proposed"]?? && commodityData["proposed"]?has_content>
									<listitem>${commodity}</listitem>
								</#if>
							</#list>
						</itemizedlist>
					</para>
				</#if>

				<#if appEMS?has_content>
					<@com.emptyLine/>

					<para>
						<emphasis role="bold">Evaluating Member State (EMS): </emphasis><@com.picklist appEMS/>
					</para>
				</#if>
            </para>
        </cover>

        <@com.metadataBlock left_header_text central_header_text right_header_text left_footer_text central_footer_text right_footer_text />
    </info>
 
	<chapter label="I">
		<title>Background</title>
	
		<#assign app=_dossierHeader.MRLApplication.DossierSpecificInformation/>
        <#assign nosinfo=_dossierHeader.NotificationOfStudies/>
		
        <#assign ownerLegalEntityName>
            <#if ownerLegalEntityMain?has_content><@com.text ownerLegalEntityMain.GeneralInfo.LegalEntityName ""/></#if>
        </#assign>
        
        <#assign submittingLegalEntityName>
            <#if submittingLegalEntity?? && submittingLegalEntity?has_content>
                <@com.text submittingLegalEntity.GeneralInfo.LegalEntityName ""/>
            </#if>
		</#assign>
		
        <#assign thirdPartyName>
            <#if thirdPartyLegalEntityMain?has_content>
                <@com.text thirdPartyLegalEntityMain.GeneralInfo.LegalEntityName ""/>
            </#if>
		</#assign>

		<para>
    		The applicant <emphasis role="underline">${ownerLegalEntityName}</emphasis>
    		<#if thirdPartyName?has_content>(third party: ${thirdPartyName})</#if>
    		submitted an MRL application
    		to the Evaluating Member State (EMS) <emphasis role="underline"><@com.picklist app.EMS/></emphasis>:
		</para>
		<itemizedlist><#--NOTE: itemized list works better in Word if outside of para -->
			<listitem>European Reference Number: <@com.text app.EUReferenceNumber ""/></listitem>
			<listitem>Dossier UUID: ${sanitizeUUID(_dossierHeader.subjectKey)}</listitem>
		</itemizedlist>
    	
    	<#if _dossierHeader.remarks?has_content>
    		<para>The applicant made the following remarks: <@com.text _dossierHeader.remarks ""/></para>
		</#if>
		
    	<#assign purposeSize = (app.Purpose?size>1)/>
    	<para>
    		The following purpose<#if purposeSize>s were<#else> was</#if> indicated by the applicant: 
			<#if !purposeSize><@com.picklistMultiple app.Purpose/></#if>
		</para>
		<#if purposeSize>
			<itemizedlist>
			<#list app.Purpose as purpose>
				<listitem><@com.picklist purpose/></listitem>
			</#list>
			</itemizedlist>
		</#if>
			
		<#assign applicantSize = (app.Applicant?size>1)/>
    	<para>
    		The applicant<#if applicantSize>s are<#else> is</#if>: 
			<#if !applicantSize><@com.picklistMultiple app.Applicant/></#if>
		</para>
		<#if applicantSize>
			<itemizedlist>
			<#list app.Applicant as applicant>
				<listitem><@com.picklist applicant/></listitem>
			</#list>
			</itemizedlist>
		</#if>

		<para>
			This application should be assessed under: <emphasis role="underline"><@com.picklist app.DataRequirements/></emphasis><?linebreak?>
		</para>
		<#if app.AdditionalInformationOnDataRequirements?has_content>
			<itemizedlist><listitem>Rationale: <@com.text app.AdditionalInformationOnDataRequirements ""/></listitem></itemizedlist>
		</#if>
		
		<@com.printEmptyBox title="Evaluating Member State's assessment on data requirements used" color="#DAE9F7"/>

		<#if _dossierHeader.OtherSubmissionRelatedInformation.PartOfActiveSubstanceAppl>
			<para>The MRL application is submitted as part of the following <emphasis role="underline">active substance application: 
				<@com.text _dossierHeader.OtherSubmissionRelatedInformation.SubmissionNumber ""/></emphasis><?linebreak?>
			</para>
		</#if>
		
		<#assign allPurposes><@com.picklistMultiple app.Purpose/></#assign>
		<#if keyRes.checkIfImportTolerance(_subjectMixture)>
			<@keyRes.importTolerance _subject "registration"/>
			<@keyRes.importTolerance _subject "legislation"/>
		</#if>
		
		<para  role='small'>
			<@keyRes.mrlTable entity=_subject/>
		</para>

		<@com.printEmptyBox title="Evaluating Member State's assessment on proposed MRLs" color="#DAE9F7"/>
	</chapter>
     
    <chapter label="II">
        <title>The active substance and its use pattern</title>
     
        <sect1 label="1">
            <title role="HEAD-1">Identity of the active substance</title>
            
	        <sect2>
	            <title role="HEAD-2">Names, identifiers and molecular information of the active substance</title>
				<#if _subject.ReferenceSubstance.ReferenceSubstance?has_content>
					<#assign refSub = iuclid.getDocumentForKey(_subject.ReferenceSubstance.ReferenceSubstance)/>
					<@pppId.pppRefSubInfoTable refSub/>
				<#else>
					<@pppId.pppEntityInfoTable entity=_subject tableType='table'/>
				
					<para>No reference substance provided.</para>
				</#if>
	        </sect2>

			<@com.emptyLine/>

	        <sect2>
	            <title role="HEAD-2">Method of manufacture (synthesis pathway) of the active substance</title>
	            <@keyAdm.manufacturer _subject/>
	        </sect2>

			<@com.emptyLine/>

	        <sect2>
	            <title role="HEAD-2">Specification of purity of the active substance, additives and impurities</title>
				<@pppId.pppSubstanceComposition substance=_subject selectedCompositionTypes=['technical specification', 'legal entity composition of the substance' ] removeBatchCompositions=true mergeTables=true tableTitle="Substance composition"/> 
	        </sect2>
	
	        <#if keyAppendixE.containsDoc(_subjectMixture, "FLEXIBLE_SUMMARY.Metabolites" , "", false)>
				
				<@com.emptyLine/>

		        <sect2>
		            <title role="HEAD-2">Information on metabolites</title>
		            <@pppId.metabolitesInformation _subjectMixture/>
		        </sect2>
			</#if>

        </sect1>
        
		<@com.emptyLine/>

        <sect1 label="2">
            <title role="HEAD-1">Assessments on the active substance</title>
			
            <@keyAdm.assessmentOtherAuthorities _subject=_subject addInfo=false bgcolor="#D3D3D3"/> 
        </sect1>

		<@com.emptyLine/>

        <sect1 label="3">
            <title role="HEAD-2">Use of the active substance (GAP)</title>

            <para>For details on uses of the active substance please refer to the <command  linkend="appA">Appendix A</command>.</para>
        </sect1>

		<@com.emptyLine/>

        <sect1 label="4">
            <title role="HEAD-2">Effects on harmful organisms, function, mode of action and possible resistance</title>
             <@keyAppendixE.PPPsummary subject=_subject docSubTypes=["EffectivenessAgainstTargetOrganisms"] includeMetabolites=false includeImpurities=false/>
        	 
        	 <@keyAppendixE.appendixEstudies subject=_subject docSubTypes="EffectivenessAgainstTargetOrganisms"
              name="effects on harmful organisms, function, mode of action and possible resistance" includeMetabolites=false sectionNb="4." includeImpurities=false/>
        </sect1>
        
    </chapter>	    
	    
	<chapter label="III">
    	<title>Assessment</title>
 
        <#global _summaries=true>
        <#global _studies=false>
        <#global _waivers=false>
		<#global _annotations=true/>
 
		<#include "mrl_assessment.ftl"/>
	</chapter>
 
	<chapter label="IV">
        <title>Conclusions and recommendations</title>

		<#global _section="Residues"/>
        
        <sect1 label="1">
            <title role="HEAD-2">Proposed residue definitions</title>

			<@keyAppendixE.PPPsummary subject=_subject docSubTypes=["ResidueFood"] merge=false includeMetabolites=true includeAnnotations=_annotations/>
        </sect1>


        <sect1 label="2">
            <title role="HEAD-2">Proposed maximum residue levels (MRLs)</title>

			<@keyAppendixE.PPPsummary subject=_subject docSubTypes=["MRLProposal"] merge=false includeMetabolites=true includeAnnotations=_annotations/>
        </sect1>
    </chapter>

	<#-- NOTE: using <appendix> automatically adds "Appendix" as title but doesn't show in ToC -->
	<chapter label="Appendix A" xml:id="appA">
		<title>Good Agricultural Practices (GAP) supported in the MRL application</title>

		<#if _subjectMixture??>
			<@keyGAP.GAPsummary _subject=_subjectMixture orientation="land"/>
		</#if>
		<#--  <para>Please, use the standalone report for Good Agricultural Practices (GAP) available in Report Generator.</para>  -->
	</chapter>

	<chapter label="Appendix B">
		<title>Pesticide Residues Intake Model (PRIMo)</title>

		<para>Please refer to the relevant section of the IUCLID dossier.</para>
	</chapter>

	<chapter label="Appendix C">
		<title>Detailed evaluation of the additional studies relied on</title>

		<#global _summaries=false/>
        <#global _studies=true/>
        <#global _waivers=true/>
		<#global _annotations=true/>
		<#global _prefix="C."/>

		<#include "mrl_assessment.ftl"/>
	</chapter>
		
 
	<chapter label="Appendix D">
		<title>Import tolerances</title>

		<@keyAdm.importTolerances _subject/> 
	</chapter>

	
    <chapter label="Annex 1">
        <title>Information on Test Materials</title>
        <#include "../../common_modules/docbook/Annex2_test_materials.ftl" encoding="UTF-8" />
    </chapter> 
	
	<chapter label="Annex 2">
        <title>Information on Reference Substances</title>

        <#list pppId.referenceSubstancesList as refSub>
            <sect4 role="NotInToc" xml:id="${refSub.documentKey.uuid!}">
                <#assign refSubName><@com.text refSub.ReferenceSubstanceName ""/></#assign>
                <#assign refSubInfo>
                    <para role="small">
                        <@pppId.pppRefSubInfoTable referenceSubstance=refSub selectedFields=["Name", "IUPAC name", "Description", "CAS name", "CAS number", "EC number", "Synonyms", "Molecular information"]/>
                    </para>
                </#assign>
                ${refSubInfo}
            </sect4>

            <@com.emptyLine/>
        </#list>
     </chapter>
     
     <chapter label="References">
     	<title>Additional studies relied on</title>
		<#-- Print all references (LITERATURE entities) in the dossier -->
		<@litRefs.printLitRefs litRefs.getReferences(['component', 'node', 'tocNode']) false "#D3D3D3" "List of References"/>	
	</chapter>
</book>

<#else>
    <book version="5.0" xmlns="http://docbook.org/ns/docbook" xmlns:xi="http://www.w3.org/2001/XInclude">
        <info>
            <title>${errorMessage}</title>
        </info>

        <part></part>
    </book>

</#if>

				
<#function sanitizeUUID uuidPath>

	<#local uuid><@com.text uuidPath ""/></#local>

	<#if uuid?matches(".{2,50}/.{2,50}", "r")>
		<#local uuid=uuid?replace(".*/", '', 'r')/>

	</#if>

	<#return uuid/>
</#function>
