# Thermographic data | Mus.4172-E-33 (SLUB)

## Description

This data set contains thermographic images for the visualisation of watermarks. An IRCAM Equus 327k with Watermark Imager software (Fraunhofer) version 8.416 (R2016b) was used.

## Contents of the data set

The following data is available for each recorded watermark on a document:

- \*.mat MATLAB file with the entire recorded sequence including all image and metadata for the processed image (\*.tif)
- \*.wki.txt camera metadata files (originally output by the software as .wki) 
- \*.tif an user-friendly processed preview image 
- 00_Readme.md (this file)

## File naming conventions

The files are named according to the following scheme:

Abbreviation of Institution, Shelfmark, number, main/countermark, page, motif

**Example:**

SLUB_Mus3550D84_17_01_100_lion-in-shield.tif

**Explanation:**

- SLUB → institution
- Mus3550D84 → Shelfmark (avoiding full stops, commas, spaces; separating units by hyphens) 
- 17 → Number
- 01 → Main or countermark (01 main mark, 02 countermark, 03 other/unclear; add ‘f’ for fragment), 04a part of a full-page image (with indication of current part, beginning with "a" for upperside and/or left, counting clockwise for more than two parts)
- 100 → page or leaf (as given on the manuscript, optional with "r"/"v" indicating "recto"/"verso") to which the camera points (preceded by volume number if necessary, e.g. ‘vol1-100’)
- lion-in-shield → Motif, in English, terms standardised according to [Bernstein](https://bernstein.oeaw.ac.at/twiki/bin/viewfile/Main/DocumentsArchive@filename=Watermark_Terms_v8-1.pdf "https://bernstein.oeaw.ac.at/twiki/bin/viewfile/Main/DocumentsArchive@filename=Watermark_Terms_v8-1.pdf"), separated by hyphens, special characters are not allowed

## Further information

For further information check RISM and Deutsche Fotothek.

## Licence

This dataset is licensed under the **Creative Commons Attribution (CC BY) 4.0** licence (<https://creativecommons.org/licenses/by/4.0/>)

## Contact

For questions or further information please contact the music department of SLUB Dresden. Editor of this dataset: Elena Melnik

This dataset is part of the [Zenodo community](https://zenodo.org/communities/thermography-research-data "https://sandbox.zenodo.org/communities/thermographie/records")

## Version of readme

1.0