/*
  This file is part of t8code.
  t8code is a C library to manage a collection (a forest) of multiple
  connected adaptive space-trees of general element classes in parallel.

  Copyright (C) 2025 the developers

  t8code is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  t8code is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with t8code; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <gtest/gtest.h>
#include <t8.h>
#include <test/t8_gtest_memory_macros.hxx>

/* Check that MPI is configured consistently */
#if (defined(T8_ENABLE_MPI) && defined(gtest_disable_mpi)) || (defined(T8_ENABLE_MPI) && defined(gtest_disable_mpi))
#error "MPI configured differently in t8code and gtest"
#endif

int
main (int argc, char **argv)
{
  /* Initialize mpi */
  int mpiret = sc_MPI_Init (&argc, &argv);
  SC_CHECK_MPI (mpiret);

  /* Initialize sc and t8code */
  sc_init (sc_MPI_COMM_WORLD, 1, 1, NULL, SC_LP_PRODUCTION);
  t8_init (SC_LP_DEFAULT);

  /* Register a package id for the testsuite */
  t8_testsuite_register_package_id ();

  ::testing::InitGoogleTest (&argc, argv);

  const int retval = RUN_ALL_TESTS ();

  /* Finalize SC */
  sc_finalize ();

  /* Finalize and check mpi */
  mpiret = sc_MPI_Finalize ();
  SC_CHECK_MPI (mpiret);
  return retval;
}
