/*
  This file is part of t8code.
  t8code is a C library to manage a collection (a forest) of multiple
  connected adaptive space-trees of general element classes in parallel.

  Copyright (C) 2015 the developers

  t8code is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  t8code is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with t8code; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/** \file t8_cmesh_triangle.h
 * We define a function here that serves to open a mesh file generated by
 * TRIANGLE and constructing a cmesh from it.
 */

#ifndef T8_CMESH_TRIANGLE_H
#define T8_CMESH_TRIANGLE_H

#include <t8.h>
#include <t8_eclass.h>
#include <t8_cmesh/t8_cmesh.h>

/* put typedefs here */

T8_EXTERN_C_BEGIN ();

/* put declarations here */

/** Open a .node, .ele and .neigh file created by TRIANGLE to read
 * and create a cmesh from them. The cmesh will be replicated.
 * The files are opened and read by one process and the cmesh is then
 * broadcasted to the other processes.
 * \param [in] fileprefix A string holding the prefix of the TRIANGLE files.
 *                        The files \a fileprefix.node, \a fileprefix.ele and
 *                        \a fileprefix.neigh are read.
 * \param [in] partition  In the future this flag can decide whether the returned
 *                        cmesh is partitioned or not. Currently it is always replicated.
 * \param [in] comm       The mpi communicator to be used.
 * \param [in] do_dup     Whether \a comm should be duplicated by cmesh.
 * \return                A committed, replicated cmesh constructed from the info
 *                        in the TRIANGLE files.
 */
t8_cmesh_t
t8_cmesh_from_triangle_file (char *fileprefix, int partition, sc_MPI_Comm comm, int do_dup);

T8_EXTERN_C_END ();

#endif /* !T8_CMESH_TRIANGLE_H */
