library(WikidataR)
df_museum <- query_wikidata('SELECT DISTINCT ?item ?itemLabel ?countryLabel ?coord ?open ?street WHERE {
      ?item wdt:P1619 ?open.
      ?item wdt:P625 ?coord.
      ?item wdt:P31 wd:Q1863818.
      ?item wdt:P17 ?country.
  VALUES ?country {
    wd:Q142
    wd:Q29
  }
    OPTIONAL {
    ?item wdt:P6375 ?street.
    SERVICE wikibase:label { bd:serviceParam wikibase:language "en". ?street rdfs:label ?streetLabel. }
  }
  
  SERVICE wikibase:label { bd:serviceParam wikibase:language "en". }
}
')
n <- nrow(df_museum)
df_museum$visits <- sample(60000:500000, n , replace = TRUE)
write.csv(df_museum, file= "../data/raw/museum.csv" )
print(df_museum)