# R et Rmarkdown

Ce support a été créé en janvier 2026 pour une formation de 3 heures "[Traiter des données avec R et documenter les traitements de données avec Rmarkdown](https://amethis.doctorat.org/amethis-client/formation/gestion/formation/3487)", incluant des travaux pratiques (diapositives ayant un fond vert clair). 

Il est possible d'accéder à la [présentation en ligne](https://r-and-rmarkdown-6a4baf.frama.io/presentation/presentation.html#/title-slide)

# Objectifs pédagogiques

- maîtriser la console Rstudio pour R  
- R : maîtriser les notions de base : variables, fonctions, paquets  
- traitement de données tabulées (CSV) avec R   
- groupement de données, tableaux croisés   
- introduction aux visualisations (ggplot)  et à la cartographie avec R (sf)  


# structure de l'archive 

cloner le dossier avec git, ou le télécharger en format zip et l'extraire

- **presentation**  
    |_ presentation.qmd (source de la présentation (quarto))  
    |_ presentation.html : ouvrir ce fichier dans un navigateur pour voir la présentation   
- **data**  
    |_ titanic.csv (source : https://github.com/datasciencedojo/datasets/blob/master/titanic.csv )
    |_ museum.csv ; le jeu titanic est prévu pour les démo, le jeu museum est prévu pour les exercices
- **scripts**
    |_ script.R : exemple de script qu'on peut exécuter hors de Rstudio (pour différencier des chuncks dans Rmarkdown)
    |_ script qui permet l'extraction du jeu de données museum.csv à partir d'une requête en Sparql et l'ajout d'un vecteur "visits" dont les données sont aléatoires.

# reproduire la leçon

télécharger l'archive de ce cours depuis le repository

Le fichier presentation.qmd peut être lu et modifié avec Quarto.


Une copie CSV de ce fichier se trouve dans le dossier data (data/raw/titanic.csv)


Pour reconstituer l'environnement de ce cours, utiliser le fichier renv.lock. 
Si Renv n'est pas installé, il faut l'installer : 

```r
install.packages("renv")
```

initier Renv ('renv::init()') dans le répertoire de fichiers et charger les dépendances dans leur version indiquées dans le lockfile ("renv.lock")

```r 
renv::init()
renv::restore()
```

Quarto permet de générer un support en html (presentation/presentation.html) qui peut être lu à travers le navigateur. 



