/*
 * SPDX-FileCopyrightText: 2021 Helmholtz-Zentrum für Infektionsforschung GmbH (HZI) <PiaPost@helmholtz-hzi.de>
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

import {
  ConfigUtils,
  GlobalConfig,
  SupersetOfServiceConfig,
} from '@pia/lib-service-core';

const conf = {
  public: GlobalConfig.getPublic('questionnaireservice'),
  internal: GlobalConfig.getInternal('questionnaireservice'),
  database: GlobalConfig.getQPia(),
  services: {
    userservice: GlobalConfig.userservice,
    complianceservice: GlobalConfig.complianceservice,
    sampletrackingservice: GlobalConfig.sampletrackingservice,
  },
  servers: {
    messageQueue: GlobalConfig.getMessageQueue('questionnaireservice'),
    authserver: {
      probandTokenIntrospectionClient:
        GlobalConfig.authserver.probandTokenIntrospectionClient,
      adminTokenIntrospectionClient:
        GlobalConfig.authserver.adminTokenIntrospectionClient,
    },
  },
  timeZone: GlobalConfig.timeZone,
  isTestMode: ConfigUtils.getEnvVariable('IS_TEST_MODE', 'false') === 'true',
};

export const config: SupersetOfServiceConfig<typeof conf> = conf;
