/*
 * SPDX-FileCopyrightText: 2023 Helmholtz-Zentrum für Infektionsforschung GmbH (HZI) <PiaPost@helmholtz-hzi.de>
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */
export class FeedbackStatisticMapperUtility {
    static map(dto) {
        if (!dto || !dto.data || dto.data.length === 0) {
            return null;
        }
        const intervals = dto.data[0].intervals.map((interval) => [
            new Date(interval.timeRange.startDate ?? 0),
            new Date(interval.timeRange.endDate ?? 0),
        ]);
        const series = dto.data.map((data) => {
            return {
                label: data.label,
                color: data.color,
                data: data.intervals.map((interval) => interval.value),
            };
        });
        return {
            intervals,
            series,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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