/*
 * SPDX-FileCopyrightText: 2023 Helmholtz-Zentrum für Infektionsforschung GmbH (HZI) <PiaPost@helmholtz-hzi.de>
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */
import { add } from 'date-fns';
import { ColorPaletteUtility } from './color-palette.utility';
export class DataFakerUtility {
    /**
     * Generate an array of random numbers, ranging from 0 to 100
     */
    static generateRandomNumberArray(length) {
        const result = [];
        for (let i = 0; i < length; i++) {
            result.push(Math.random() * 100);
        }
        return result;
    }
    static generateFeedbackStatistic(start, end, duration, labels) {
        const intervals = [];
        for (let date = start; date <= end; date = add(date, duration)) {
            intervals.push([date, add(date, duration)]);
        }
        intervals.pop();
        const series = labels.map((label, i) => ({
            label,
            color: ColorPaletteUtility.getColorForIterator(i),
            data: this.generateRandomNumberArray(intervals.length),
        }));
        return {
            intervals,
            series,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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