/*
 * SPDX-FileCopyrightText: 2021 Helmholtz-Zentrum für Infektionsforschung GmbH (HZI) <PiaPost@helmholtz-hzi.de>
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

import { ComponentFixture, TestBed } from '@angular/core/testing';
import { RouterTestingModule } from '@angular/router/testing';
import { TranslateModule, TranslateService } from '@ngx-translate/core';
import { MockComponent, MockModule, MockProvider, MockService } from 'ng-mocks';

import { SettingsPage } from './settings.page';
import { HeaderComponent } from '../shared/components/header/header.component';
import { DeleteAccountModalService } from '../account/services/delete-account-modal.service';
import { provideHttpClientTesting } from '@angular/common/http/testing';
import { Router } from '@angular/router';
import { AuthService } from '../auth/auth.service';
import { KeycloakClientService } from '../auth/keycloak-client.service';
import { InAppBrowser } from '@awesome-cordova-plugins/in-app-browser/ngx';
import SpyObj = jasmine.SpyObj;
import { BadgeService } from '../shared/services/badge/badge.service';
import { ModalController } from '@ionic/angular/standalone';
import {
  provideHttpClient,
  withInterceptorsFromDi,
} from '@angular/common/http';

describe('SettingsPage', () => {
  let component: SettingsPage;
  let fixture: ComponentFixture<SettingsPage>;

  let deleteAccountModalService: DeleteAccountModalService;
  let auth: AuthService;

  beforeEach(() => {
    TestBed.configureTestingModule({
      imports: [
        RouterTestingModule,
        SettingsPage,
        MockModule(TranslateModule),
        MockComponent(HeaderComponent),
      ],
      providers: [
        InAppBrowser,
        MockProvider(TranslateService),
        MockProvider(BadgeService, MockService(BadgeService)),
        MockProvider(KeycloakClientService, MockService(KeycloakClientService)),
        MockProvider(ModalController),
        provideHttpClient(withInterceptorsFromDi()),
        provideHttpClientTesting(),
      ],
    }).compileComponents();

    deleteAccountModalService = TestBed.inject(DeleteAccountModalService);
    auth = TestBed.inject(AuthService);

    fixture = TestBed.createComponent(SettingsPage);

    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should open account deletion modal', () => {
    const showDeleteAccountModalSpy = spyOn(
      deleteAccountModalService,
      'showDeleteAccountModal'
    );

    component.openDeleteAccountModal();

    expect(showDeleteAccountModalSpy).toHaveBeenCalled();
  });

  describe('Change Password', () => {
    let openAccountManagementSpy;

    beforeEach(() => {
      openAccountManagementSpy = spyOn(auth, 'openAccountManagement');
    });

    it('should open keycloak account management ', () => {
      component.openAccountManagement();

      expect(openAccountManagementSpy).toHaveBeenCalled();
    });
  });
});
