/*
 * SPDX-FileCopyrightText: 2021 Helmholtz-Zentrum für Infektionsforschung GmbH (HZI) <PiaPost@helmholtz-hzi.de>
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { TranslateModule } from '@ngx-translate/core';

import { LoginPage } from './login/login.page';
import { AuthRoutingModule } from './auth-routing.module';
import { SharedModule } from '../shared/shared.module';
import { InputPasswordComponent } from './input-password/input-password.component';
import { LoginUsernameComponent } from './login-username/login-username.component';
import {
  IonItem,
  IonInput,
  IonButton,
  IonIcon,
  IonContent,
  IonCard,
  IonCardHeader,
} from '@ionic/angular/standalone';

@NgModule({
  imports: [
    CommonModule,
    FormsModule,
    TranslateModule.forChild(),
    AuthRoutingModule,
    SharedModule,
    ReactiveFormsModule,
    IonItem,
    IonInput,
    IonButton,
    IonIcon,
    IonContent,
    IonCard,
    IonCardHeader,
    LoginPage,
    InputPasswordComponent,
    LoginUsernameComponent,
  ],
  providers: [],
})
export class AuthModule {}
