# Voynich MS 408 - Zenodo Upload Package
## AI Validation of Steven Quevedo's Mechanical Hypothesis

**Version**: 2.0 (January 24, 2026)
**Authors**: Steven Quevedo (Hypothesis), Jeffrey Meijer (AI Validation)

---

## Package Contents

### 📄 Documentation

| File | Description |
|------|-------------|
| `ZENODO_COLLABORATION_CALL.md` | Full academic document with methodology and findings |
| `COLLABORATION_TLDR.md` | Short version for social media and outreach |
| `VOYNICH_COMPLETE_TRANSLATION.pdf` | Professional PDF with layered translations |

### 🌐 Interactive Tools

| File | Description |
|------|-------------|
| `voynich_interactive_viewer.html` | Web-based viewer with toggleable translation layers |

### 🐍 Python Code

| File | Description |
|------|-------------|
| `quevedo_engine_v5.py` | Wheel mechanism simulator (v5.0 with full lexicon) |
| `collaborative_translator.py` | Translation with confidence marking |
| `move37_phonetic_constraint.py` | Phonetic constraint analysis |
| `macaronic_lexicon.py` | Macaronic Latin vocabulary database |

---

## Key Results

### Statistical Validation
- **86.5% match** between simulated engine output and real Voynich
- **Jaccard Index**: 0.0256 (simulated) vs 0.0226 (real Voynich)
- **10,042 unique words** generated by simulator

### Translation Coverage
- **28,790 words** translated across 184 folios
- **51% confirmed** vocabulary (90%+ confidence)
- **49% uncertain** vocabulary (requires expert review)

### Confirmed Macaronic Latin Terms
| Voynich | Macaronic | Meaning | Confidence |
|---------|-----------|---------|------------|
| QO | QUO | by which | 95% |
| OR | ORCIO | jar/vessel | 95% |
| AR/AIR | ARIA | air/vapor | 98% |
| TAL | TAGLIA | cut | 95% |
| TOL | TOGLI | remove | 95% |
| DAIIN | DARE-IN | add inside | 95% |
| CH | CHIUSA | channel | 85% |

### Patterns Requiring Expert Review
| Pattern | Hypothesis | Expert Needed |
|---------|------------|---------------|
| SH/SHE/SHEDY | Solid/container? | Germanic linguist |
| AIN/AIIN | Wheel rotation marker? | Mechanical historian |
| KEE/KED | Heat intensity scale? | Alchemical expert |

---

## How to Use

### PDF Document
Open `VOYNICH_COMPLETE_TRANSLATION.pdf` for a printable, professional document with:
- Original Voynich text
- Macaronic Latin layer
- English translation layer
- Code breakdown (Prefix+Root+Suffix)
- Confidence percentages

### Interactive Viewer
Open `voynich_interactive_viewer.html` in any web browser for:
- Toggle layers on/off with buttons
- Color-coded confidence levels
- Side-by-side original and translation

### Python Simulator
```bash
python quevedo_engine_v5.py
```
Generates synthetic Voynich-like text using the wheel mechanism.

---

## Citation

```
Quevedo, S., & Meijer, J. (2026). AI Validation of the Voynich Mechanical Hypothesis: 
86.5% Statistical Match Using Macaronic Latin. Zenodo. https://doi.org/[TO BE ASSIGNED]
```

---

## License

This work is licensed under Creative Commons Attribution 4.0 International (CC BY 4.0).
You are free to share and adapt with attribution.

---

## Contact

- **Steven Quevedo**: [email to be added]
- **Jeffrey Meijer (AI Kapitein)**: [email to be added]

**Repository**: [GitHub URL to be added]
