#!/usr/bin/env python3
#
# Copyright 2016-2024 Swiss National Supercomputing Centre (CSCS/ETH Zurich)
# ReFrame Project Developers. See the top-level LICENSE file for details.
#
# SPDX-License-Identifier: BSD-3-Clause
#
# -*- coding: utf-8 -*-
#
# ReFrame documentation build configuration file, created by
# sphinx-quickstart on Tue Jul 11 13:42:52 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import re
import sys

import sphinx_rtd_theme

prefix = os.path.join(os.path.abspath(os.path.dirname(__file__)), '..')
pymajver = sys.version_info.major
pyminver = sys.version_info.minor
external = os.path.join(prefix, 'external')
sys.path = [prefix, external] + sys.path

import reframe                           # noqa: F401, F403
import reframe.utility.osext as osext    # noqa: F401, F403

# Sphinx erroneously uses `repr()` to display values and not the
# human-readable `str()`. For this reason we define the following variable in
# the `reframe` module so that objects can redirect to their `str()` method
# from `repr()` if they are invoked in the context of Sphinx when building the
# documentation. See discussion and the related workaround here:
#
# https://github.com/sphinx-doc/sphinx/issues/3857

reframe.__build_docs__ = True

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
needs_sphinx = '3.0.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx.ext.autodoc',
              'sphinx.ext.autosummary',
              'sphinx.ext.doctest',
              'sphinx.ext.todo',
              'sphinx.ext.coverage',
              'sphinx.ext.imgmath',
              'sphinx.ext.intersphinx',
              'sphinx.ext.ifconfig',
              'sphinx.ext.viewcode',
              'sphinx.ext.githubpages',
              'sphinxcontrib.jquery']

intersphinx_mapping = {
    'python': ('http://docs.python.org/3', None),
}

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'ReFrame'
copyright = '2016-2025, CSCS/ETH Zurich, ReFrame Project Developers'
author = 'ReFrame Project Developers'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = reframe.VERSION
# The full version, including alpha/beta/rc tags.
release = osext.reframe_version()

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store', 'html/*']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output ----------------------------------------------

html_show_sourcelink = False
html_favicon = '_static/img/favicon.png'
last_updated = True

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
# html_theme = 'agogo'


# READTHEDOCS
html_theme = "sphinx_rtd_theme"
sphinx_rtd_theme_version_info = tuple(int(x) for x in sphinx_rtd_theme.__version__.split('.'))
if sphinx_rtd_theme_version_info[0] < 3:
    html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

html_theme_options = {
    'collapse_navigation': True,
    'display_version': True,
    'navigation_depth': 5,
    #     # 'canonical_url': True,
}

html_context = {
    # Enable the "Edit in GitHub link within the header of each page.
    'display_github': True,
    # Set the following variables to generate the resulting github URL for each page.
    # Format Template: https://{{ github_host|default("github.com") }}/{{ github_user }}/{{ github_repo }}/blob/{{ github_version }}{{ conf_py_path }}{{ pagename }}{{ suffix }}
    'github_user': 'reframe-hpc',
    'github_repo': 'reframe',
    # 'github_version': 'master/source/'

    # 'show_github': True,
    # 'show_on_github_url' : 'https://github.com/sphinx-doc/sphinx/issues/2386'
}

html_theme_options = {
    'logo_only': True
}
html_logo = "_static/img/reframe-logo-dark-bg.png"
autodoc_default_flags = ['members']

# End of READTHEDOCS

# BOOTSTRAP specific
# html_theme = 'bootstrap'
# html_theme_path = sphinx_bootstrap_theme.get_html_theme_path()

# html_theme_options = {
#     'navbar_links': [
#         ("Examples", "examples"),
#         ("Link", "http://example.com", True),
#     ],
#     'navbar_sidebarrel': True,
#     'navbar_pagenav': False,

# }
# End of BOOTSTRAP specific


# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
html_sidebars = {
    '**': [
        'about.html',
        'navigation.html',
        'relations.html',  # needs 'show_related': True theme option to display
        'searchbox.html',
        'donate.html',
    ]
}


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'reframedoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'reframe.tex', 'ReFrame Documentation',
     'CSCS', 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ('manpage', 'reframe',
     'The CLI frontend for managing and executing ReFrame tests',
     [author], 1),
    ('config_reference', 'reframe.settings', 'ReFrame Configuration Manual',
     [author], 8)
]
manpages_url = (
    'http://man7.org/linux/man-pages/man{section}/{page}.{section}.html'
)


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'reframe', 'ReFrame Documentation',
     author, 'ReFrame', 'ReFrame is a new framework for writing regression tests for HPC systems.',
     'Miscellaneous'),
]


# Versioning
scv_whitelist_branches = ('master',)
scv_whitelist_tags = (re.compile(r'^v\d+\.\d+$'),)
