# Changelog

All notable changes to the ZEKNOP Data Interoperability Standard will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),  
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

---

## [1.1] - 2026-01-27

### Summary

Version 1.1 enhances the whitepaper for strategic deployment, addressing regulatory requirements in **Australia (Online Safety Act)** and **France (Social Media Ban <15)**. Age verification is positioned as a **flagship demonstration** of the protocol's broader capabilities in privacy-preserving identity management.

### Added

- **Executive Summary:** Completely restructured to begin with the fundamental problem of data fragmentation, addressing both privacy risks (for regulators/privacy advocates) and systemic inefficiencies (for technical stakeholders)
- **Section 8 - Flagship Use Case:** New dedicated section "Privacy-Preserving Age Verification" with:
  - Detailed 6-step verification workflow diagram
  - Technical implementation (attestation format, verification process)
  - Age threshold flexibility (`over13`, `over15` [FR], `over16` [AU], `over18`, `over21`)
  - Privacy guarantees (unlinkability, data minimisation, user control)
  - Comparison with alternative approaches
  - Regulatory alignment analysis
- **Section 5.4 - Australian Privacy Act Compliance:** New table mapping Australian Privacy Principles (APPs) to ZEKNOP implementation
- **Multi-Jurisdictional Support:** Added AU and FR to regulatory compliance table (Section 2.3.4)
- **Australian financial products:** Added `au.superannuation.*`, `au.banking.*`, `au.mortgage.*`, `au.loan.hecs` to type registries
- **Age verification scopes:** Added `identity:age:over13`, `identity:age:over15` (France), `identity:age:over16` (Australia) for jurisdictional flexibility
- **Australian references:** Online Safety Act 2021, Privacy Act 1988, Australian Privacy Principles, eSafety Commissioner
- **French references:** Social Media Regulation Act (Loi n° 2023-566), France Identité
- **Section 12.1 Security:** Enhanced phishing/impersonation mitigation with consumer registration, pre-configured scope limits, and institution verification
- **Section 12.3 Compliance Standards:** Restructured with categories (Security, Privacy, Financial, Age Verification); added CDR (AU), Open Banking (UK), CCPA (US)

### Changed

- **Executive Summary framing:** Now begins with broader data fragmentation problem ("Data about individuals are now distributed across hundreds of institutions...") before introducing age verification as a pressing example
- **Section 1.1 - Problem Statement:** Renamed "Age Verification Crisis" to "**Identity Verification Dilemma**" to reflect broader protocol scope; age verification framed as "a pressing example"
- **Section 1.3 - Use Cases:** Age verification marked as "**Flagship Use Case**" with framing "As a primary example of the protocol in action"
- **Section 8.10 - Implementation Considerations:** Expanded with multi-jurisdictional table (AU, FR, EU) for institution readiness
- **Section 9.3 - Certification Program:** Made jurisdiction-agnostic ("Applicable privacy legislation" instead of specific laws)
- **Section 11.1 - Scope:** Updated derived claims list to include all age thresholds (isOver13, isOver15, isOver16, isOver18, isOver21)
- **Section 13.1 - Geographic Coverage:** Updated to "EU (including CZ, FR), AU"
- **Call to Action (Section 14):** Added specific invitation to Australian regulators, platforms, and financial institutions

### Fixed

- **Framing balance:** Refined throughout to ensure age verification is presented as a flagship demonstration of protocol power, not the sole purpose of ZEKNOP
- **Identity blocks count:** Verified as 9 blocks (consistent throughout document)
- **Terminology consistency:** Standardised on "ZEKNOP" for protocol, "ZEKNOP Data Interoperability Standard" for full name

### Removed

- **`identity:digitalLife:ageVerification` scope:** Removed as redundant with `identity:age:overXX` scopes

---

## [1.0] - 2025-11-21

### Summary

Initial defensive publication establishing prior art for the ZEKNOP Data Interoperability Standard.

### Added

- **Core Protocol Specification:**
  - Asset & Liability Portability Standard (14+ asset types, 11+ liability types, 12+ policy types)
  - Granular Identity Framework (9 identity blocks)
  - OAuth 2.0 consent flows with granular scopes
  - Audit trail and compliance mechanisms

- **Data Models:**
  - JSON Schema definitions for assets, liabilities, policies
  - Identity blocks: pseudonymous, contact, address, financial, KYC, documents, biometric, membership, digital life
  - External type registries with hierarchical naming
  - Jurisdictional extensions system

- **Privacy-by-Design Patterns:**
  - Derived claims without document storage
  - Zero-knowledge data flows
  - Time-bound and revocable consent
  - Minimal disclosure principles

- **API Specification:**
  - REST API endpoints (OpenAPI 3.0)
  - Data migration and portability workflows
  - Consent management endpoints

- **Governance Framework:**
  - Foundation model (Stichting)
  - RFC process
  - Certification program (Compatible, Certified, Secure+)

- **Use Case Workflows:**
  - Financial advisor onboarding
  - E-commerce privacy-preserving checkout
  - Bank KYC without document storage
  - Event ticket security

### Publication

- **DOI:** [10.5281/zenodo.17666290](https://doi.org/10.5281/zenodo.17666290)
- **License:** CC BY 4.0
- **Platform:** Zenodo

---

## Links

- **Current Version:** [defensive-publication-v1.1.md](./defensive-publication-v1.1.md)
- **Previous Version:** [defensive-publication-v1.0.md](./defensive-publication-v1.0.md)
- **Project Website:** <https://zeknop.org>
- **Contact:** <info@zeknop.org>
