# Small-scale fisheries biogeography and adaptive capacity in Chile (2015–2022)

This repository contains curated datasets, metadata, and reproducible R scripts supporting analyses
of biogeographic structure, ecological stability of landings, and socio-ecological adaptive capacity
in Chilean small-scale fisheries.

---

## Data source and filtering

The landings dataset consists of individual vessel landing records obtained from the Chilean
National Fisheries Service (SERNAPESCA) for the period 2015–2022 through a public information request.
The original database contains daily inspection records of vessel departures and arrivals from
legally operating artisanal fisheries.

The dataset includes information on municipality, landing cove, vessel characteristics, fishing
gear, and landed species. Taxonomic information was cross-referenced with the World Register of
Marine Species (WoRMS).

For the purposes of this dataset, records were filtered to retain only benthic species, including
rockfish and rays, primarily harvested by small-scale vessels (<12 m length) operating in nearshore
areas. The spatial extent was restricted to continental Chile between 18°S and 44°S, excluding
insular territories and regions with sparse reporting south of the Gulf of Penas.

To ensure compliance with ethical standards and data protection principles, all personally
identifiable information (e.g., vessel names, registration numbers, and owner names) was removed
from the publicly released dataset. Unique registry identifiers were retained only when necessary
for analytical consistency and cannot be used to identify individual fishers.

---

## Fishing effort and adjusted landings

To derive a measure of fishing effort with the available data, each landing record for each vessel
was divided by a unit of effort obtained by transforming the departure and arrival dates into days
of travel and by considering the monthly number of trips made by the same vessel.

For the filtered dataset, municipalities were grouped by year and both the number of trips and the
number of unique landing sites were counted for each municipality–year combination. A controlled
frequency was then calculated as the ratio of trips per landing site in each municipality and year.

Using a threshold of 12 trips per year (at least one monthly report), municipalities that did not
meet this criterion were excluded, reducing the dataset from 83 to 65 municipalities.

---

## Socio-ecological variables and Adaptive Capacity (Table S2)

Adaptive Capacity was characterized using a set of socio-ecological variables compiled at the
municipality level from multiple public sources in Chile. These variables capture institutional,
demographic, infrastructural, educational, and fishery-related attributes that influence the
ability of coastal communities to respond to environmental and socioeconomic change.

A total of 27 variables were selected and organized into five Adaptive Capacity dimensions:
Agency, Assets, Flexibility, Learning, and Social organization (Table S2). Variable selection was
based on data availability, spatial consistency at the municipality level, and relevance to
small-scale fisheries and coastal social–ecological systems.

The variables were derived from publicly available datasets provided by the Chilean National
Fisheries Service (SERNAPESCA), the Undersecretariat of Fisheries (SUBPESCA), the National Institute
of Statistics (INE), the National System of Municipal Information (SINIM), and the Ministries of
Education and Public Security. Fishery-related variables were calculated directly from the landings
dataset, while demographic, health, infrastructure, and education variables were obtained from
official administrative records.

All socio-ecological variables were aggregated at the municipality level and matched to the
filtered set of 65 coastal municipalities retained for analysis. Variable definitions, short names,
thematic categories, Adaptive Capacity dimensions, and data sources are fully described in Table S2.

---

## Adaptive Capacity Dimension Weighting (ACDW)

To quantify the relative contribution of each Adaptive Capacity dimension to municipality clustering,
we computed an Adaptive Capacity Dimension Weighting (ACDW) using a composite eigenscore approach.
Adaptive capacity variables (Table S2) were projected into a reduced multivariate space using
principal component analysis (PCA).

For each Adaptive Capacity dimension (Agency, Assets, Flexibility, Learning, Social organization),
a composite score was derived by projecting municipal values onto dominant eigenvectors and weighting
them by the variance explained by the first principal component (PC1). This procedure yields a
dimension-specific weighting reflecting the dominant multivariate gradient across municipalities.

These ACDW scores were subsequently used as predictors in statistical models evaluating variation in
ecological stability of landings across municipalities, together with biogeographic cluster
membership. Ecological stability was quantified as Bray–Curtis similarity (1 − BC), ranging from 1
(identical species composition between years) to 0 (no overlap in species composition). Because the
response variable is bounded within (0, 1), regression analyses were implemented using beta
regression (R package `betareg`).

---

## Repository structure

```text
data/
  landings/                Curated artisanal landings dataset and metadata
  adaptive_capacity/       Socio-ecological variables and Table S2 metadata
scripts/                   Reproducible R scripts used in the analyses