cmake_minimum_required(VERSION 3.5...3.31)

# Extract test name
get_filename_component(testname "${UKRmolOut_TEST_TGT}" NAME)

# Get and sort all swinterf inputs
file(GLOB swinterf_input "${UKRmolOut_TEST_SRC}/inputs/scattering.swinterf.*.inp")
list(SORT swinterf_input)

# Outer region run
foreach(input ${swinterf_input})

    # extract the spin-symmetry label
    string(REGEX REPLACE "(.*\\.swinterf\\.)(.*)(\\.inp)" "\\2" spinsym ${input})

    # run swinterf
    execute_process(COMMAND ${SWINTERF_PROGRAM}
                    RESULT_VARIABLE errcode
                    INPUT_FILE "${UKRmolOut_TEST_SRC}/inputs/scattering.swinterf.${spinsym}.inp"
                    OUTPUT_FILE "logs/scattering.swinterf.${spinsym}.out"
                    ERROR_FILE "logs/scattering.swinterf.${spinsym}.err"
                    WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
    if(NOT "${errcode}" STREQUAL "0")
        message(FATAL_ERROR "Outer swinterf failed for ${spinsym} with error ${errcode}")
    endif()

    # run rsolve (if input available); copy the input to "inp" required by mpi_r_solve
    if(EXISTS "${UKRmolOut_TEST_SRC}/inputs/scattering.rsolve.${spinsym}.inp")
        file(COPY "${UKRmolOut_TEST_SRC}/inputs/scattering.rsolve.${spinsym}.inp" DESTINATION "${UKRmolOut_TEST_TGT}")
        file(RENAME "${UKRmolOut_TEST_TGT}/scattering.rsolve.${spinsym}.inp" "${UKRmolOut_TEST_TGT}/inp")
        execute_process(COMMAND ${RSOLVE_PROGRAM}
                        RESULT_VARIABLE errcode
                        INPUT_FILE "${UKRmolOut_TEST_SRC}/inputs/scattering.rsolve.${spinsym}.inp"
                        OUTPUT_FILE "logs/scattering.rsolve.${spinsym}.out"
                        ERROR_FILE "logs/scattering.rsolve.${spinsym}.err"
                        WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
        if(NOT "${errcode}" STREQUAL "0")
            message(FATAL_ERROR "Outer rsolve failed for ${spinsym} with error ${errcode}")
        endif()
    endif()

    # run eigenp (if input available)
    if(EXISTS "${UKRmolOut_TEST_SRC}/inputs/scattering.eigenp.${spinsym}.inp")
        execute_process(COMMAND ${EIGENP_PROGRAM}
                        RESULT_VARIABLE errcode
                        INPUT_FILE "${UKRmolOut_TEST_SRC}/inputs/scattering.eigenp.${spinsym}.inp"
                        OUTPUT_FILE "logs/scattering.eigenp.${spinsym}.out"
                        ERROR_FILE "logs/scattering.eigenp.${spinsym}.err"
                        WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
        if(NOT "${errcode}" STREQUAL "0")
            message(FATAL_ERROR "Outer eigenp failed for ${spinsym} with error ${errcode}")
        endif()
        file(READ "${UKRmolOut_TEST_TGT}/fort.110" eigphs)
        file(APPEND "${UKRmolOut_TEST_TGT}/../output.scattering.eigenp.dat" "${testname}: ${spinsym}\n---->\n${eigphs}<----\n")
        file(RENAME "${UKRmolOut_TEST_TGT}/fort.110" "${UKRmolOut_TEST_TGT}/outputs/scattering.eigenp.${spinsym}.dat")
        if(NUMDIFF_EXECUTABLE)
            execute_process(COMMAND "${NUMDIFF_EXECUTABLE}" -X 1:3- -X 2:3- -a 0 -r 1e-3 "${UKRmolOut_TEST_SRC}/outputs/scattering.eigenp.${spinsym}.dat" "outputs/scattering.eigenp.${spinsym}.dat"
                            RESULT_VARIABLE errcode
                            OUTPUT_FILE "logs/scattering.eigenp.numdiff.${spinsym}.out"
                            ERROR_FILE "logs/scattering.eigenp.numdiff.${spinsym}.err"
                            WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
            if(NOT "${errcode}" STREQUAL "0")
                message(FATAL_ERROR "Scattering eigenphase sums wrong for spin-symmetry ${spinsym}!")
            endif()
        endif()
    endif()

    # run tmatrx (if input available)
    if(EXISTS "${UKRmolOut_TEST_SRC}/inputs/scattering.tmatrx.${spinsym}.inp")
        execute_process(COMMAND ${TMATRX_PROGRAM}
                        RESULT_VARIABLE errcode
                        INPUT_FILE "${UKRmolOut_TEST_SRC}/inputs/scattering.tmatrx.${spinsym}.inp"
                        OUTPUT_FILE "logs/scattering.tmatrx.${spinsym}.out"
                        ERROR_FILE "logs/scattering.tmatrx.${spinsym}.err"
                        WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
        if(NOT "${errcode}" STREQUAL "0")
            message(FATAL_ERROR "Outer tmatrx failed for ${spinsym} with error ${errcode}")
        endif()
    endif()

    # run ixsecs (if input available)
    if(EXISTS "${UKRmolOut_TEST_SRC}/inputs/scattering.ixsecs.${spinsym}.inp")
        execute_process(COMMAND ${IXSECS_PROGRAM}
                        RESULT_VARIABLE errcode
                        INPUT_FILE "${UKRmolOut_TEST_SRC}/inputs/scattering.ixsecs.${spinsym}.inp"
                        OUTPUT_FILE "logs/scattering.ixsecs.${spinsym}.out"
                        ERROR_FILE "logs/scattering.ixsecs.${spinsym}.err"
                        WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
        if(NOT "${errcode}" STREQUAL "0")
            message(FATAL_ERROR "Outer ixsecs failed for ${spinsym} with error ${errcode}")
        endif()
        file(READ "${UKRmolOut_TEST_TGT}/fort.111" ixsecs)
        file(APPEND "${UKRmolOut_TEST_TGT}/../output.scattering.ixsecs.dat" "${testname}: ${spinsym}\n---->\n${ixsecs}<----\n")
        file(RENAME "${UKRmolOut_TEST_TGT}/fort.111" "${UKRmolOut_TEST_TGT}/outputs/scattering.ixsecs.${spinsym}.dat")
        if(NUMDIFF_EXECUTABLE)
            execute_process(COMMAND "${NUMDIFF_EXECUTABLE}" -a 0 -r 1e-3 "${UKRmolOut_TEST_SRC}/outputs/scattering.ixsecs.${spinsym}.dat" "outputs/scattering.ixsecs.${spinsym}.dat"
                            RESULT_VARIABLE errcode
                            OUTPUT_FILE "logs/scattering.ixsecs.numdiff.${spinsym}.out"
                            ERROR_FILE "logs/scattering.ixsecs.numdiff.${spinsym}.err"
                            WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
            if(NOT "${errcode}" STREQUAL "0")
                message(FATAL_ERROR "Scattering cross sections wrong for spin-symmetry ${spinsym}!")
            endif()
        endif()
    endif()

    # run reson (if input available)
    if(EXISTS "${UKRmolOut_TEST_SRC}/inputs/scattering.reson.${spinsym}.inp")
        execute_process(COMMAND ${RESON_PROGRAM}
                        RESULT_VARIABLE errcode
                        INPUT_FILE "${UKRmolOut_TEST_SRC}/inputs/scattering.reson.${spinsym}.inp"
                        OUTPUT_FILE "logs/scattering.reson.${spinsym}.out"
                        ERROR_FILE "logs/scattering.reson.${spinsym}.err"
                        WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
        if(NOT "${errcode}" STREQUAL "0")
            message(FATAL_ERROR "Outer reson failed for ${spinsym} with error ${errcode}")
        endif()
    endif()

endforeach()

# run RMT interface (if input available)
if(EXISTS "${UKRmolOut_TEST_SRC}/inputs/scattering.rmt_interface.inp")
    execute_process(COMMAND ${RMT_INTERFACE_PROGRAM}
                    RESULT_VARIABLE errcode
                    INPUT_FILE "${UKRmolOut_TEST_SRC}/inputs/scattering.rmt_interface.inp"
                    OUTPUT_FILE "logs/scattering.rmt_interface.out"
                    ERROR_FILE "logs/scattering.rmt_interface.err"
                    WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
    if(NOT "${errcode}" STREQUAL "0")
        message(FATAL_ERROR "Outer rmt_interface failed with error ${errcode}")
    endif()
    if(PYTHON_EXECUTABLE)
        execute_process(COMMAND ${PYTHON_EXECUTABLE} "${PROJECT_SOURCE_DIR}/tests/scripts/dump-molecular-data.py" 5
                        OUTPUT_FILE outputs/molecular_data.dat
                        ERROR_FILE logs/molecular_data.err
                        WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
        if(NOT "${errcode}" STREQUAL "0")
            message(FATAL_ERROR "Failed to translate molecular_data to text with error ${errcode}")
        endif()
        file(READ "${UKRmolOut_TEST_TGT}/outputs/molecular_data.dat" moldat)
        file(APPEND "${UKRmolOut_TEST_TGT}/../output.molecular_data.dat" "${testname}\n---->\n${moldat}<----\n")
        if(NUMDIFF_EXECUTABLE)
            execute_process(COMMAND "${NUMDIFF_EXECUTABLE}" -D "\\s \\s- \\n [ , ]" -a 1e-10 -r 1e-3 "${UKRmolOut_TEST_SRC}/outputs/molecular_data.dat" "outputs/molecular_data.dat"
                            RESULT_VARIABLE errcode
                            OUTPUT_FILE "logs/scattering.rmt_interface.numdiff.out"
                            ERROR_FILE "logs/scattering.rmt_interface.numdiff.err"
                            WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
            if(NOT "${errcode}" STREQUAL "0")
                message(FATAL_ERROR "Molecular RMT data wrong!")
            endif()
        endif()
    endif()
endif()

# run dipelm (if input available)
if(EXISTS "${UKRmolOut_TEST_SRC}/inputs/scattering.dipelm.inp")
    execute_process(COMMAND ${DIPELM_PROGRAM}
                    RESULT_VARIABLE errcode
                    INPUT_FILE "${UKRmolOut_TEST_SRC}/inputs/scattering.dipelm.inp"
                    OUTPUT_FILE "logs/scattering.dipelm.out"
                    ERROR_FILE "logs/scattering.dipelm.err"
                    WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
    if(NOT "${errcode}" STREQUAL "0")
        message(FATAL_ERROR "Outer dipelm failed with error ${errcode}")
    endif()
    file(READ "${UKRmolOut_TEST_TGT}/photo_xsec" beta)
    file(WRITE "${UKRmolOut_TEST_TGT}/outputs/photoionization.beta0.dat" "${beta}")
    file(APPEND "${UKRmolOut_TEST_TGT}/../output.photoionization.beta.dat" "${testname}: beta0\n---->\n${beta}<----\n")
    file(READ "${UKRmolOut_TEST_TGT}/photo_beta_2l" beta)
    file(WRITE "${UKRmolOut_TEST_TGT}/outputs/photoionization.beta2.dat" "${beta}")
    file(APPEND "${UKRmolOut_TEST_TGT}/../output.photoionization.beta.dat" "${testname}: beta2\n---->\n${beta}<----\n")
    if(NUMDIFF_EXECUTABLE)
        execute_process(COMMAND "${NUMDIFF_EXECUTABLE}" -a 0 -r 1e-3 "${UKRmolOut_TEST_SRC}/outputs/photoionization.beta0.dat" "photo_xsec"
                        RESULT_VARIABLE errcode
                        OUTPUT_FILE "logs/photoionization.beta0.numdiff.out"
                        ERROR_FILE "logs/photoionization.beta0.numdiff.err"
                        WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
        if(NOT "${errcode}" STREQUAL "0")
            message(FATAL_ERROR "Photoionization cross sections wrong!")
        endif()
        execute_process(COMMAND "${NUMDIFF_EXECUTABLE}" -a 0 -r 1e-3 "${UKRmolOut_TEST_SRC}/outputs/photoionization.beta2.dat" "photo_beta_2l"
                        RESULT_VARIABLE errcode
                        OUTPUT_FILE "logs/photoionization.beta2.numdiff.out"
                        ERROR_FILE "logs/photoionization.beta2.numdiff.err"
                        WORKING_DIRECTORY "${UKRmolOut_TEST_TGT}")
        if(NOT "${errcode}" STREQUAL "0")
            message(FATAL_ERROR "Asymmetry parameters wrong!")
        endif()
    endif()
endif()
