PROGRAM RMAT
   use rmt_molecular_interface
   use precisn_gbl
   use const_gbl, only: stdout
   use ukrmol_interface_gbl, only: start_mpi, finalize_mpi
   IMPLICIT NONE
   !todo the following variables should be read-in from a namelist
   INTEGER :: NFDM = 2
   REAL(wp) :: DELTA_R = 0.08d0
   INTEGER  :: lutarg = 24 !target properties: DENPROP output
   INTEGER  :: lunp1 = 667 !N+1 dipoles: CDENPROP_TARGET output for all pairs of N+1 symmetries
   INTEGER  :: n_symmetries = 8
   NAMELIST/rmt_interface_inp/n_symmetries,nfdm,delta_r,lutarg,lunp1
   integer :: i, ifail

      call print_ukrmol_header(stdout)

      write(*,'(/,10X,"rmt_interface: start")')
      write(*,'(  10X,"====================",/)')

      call start_mpi

      read(5,nml=rmt_interface_inp)
      !
      !---- Call interface routines to transfer the channel data and the amplitudes to the module rmt_molecular_interface.
      do i=1,n_symmetries
         ifail = 0
         CALL SW_INTERF(IFAIL,NFDM,DELTA_R)
      enddo
      !
      call print_all_data
      !
      !---- Using the data from the rmt_molecular_interface module generate the files molecular_data and amplitude_data for later use in RMT.
      !
      call generate_data_for_rmt(DELTA_R,NFDM,lutarg,lunp1)
      call finalize_mpi

      write(*,'(/,10X,"rmt_interface: finished")')
      write(*,'(  10X,"=======================",/)')

end program
