! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      program DCSPROG
c
      character(LEN=8) curdat
      COMMON/MCDEP/ICOMPL,LREAL,LINTEG,LRATIO
      DATA ifail/0/
C
      ICOMPL = 2
      LREAL  = 8
      LINTEG = 4
      LRATIO = 2
      CALL PRINT_UKRMOL_HEADER(6)
      CALL DATE_and_time(CURDAT)
c      CALL CLOCK(CURTIM)
      PRINT 10, CURDAT
   10 FORMAT(//,' PROGRAM DCS (8 Feb 2000) : ',//,24X,' DATE = ',a)
C
      CALL DCSDRI(IFAIL)
C
      STOP
      END
      SUBROUTINE DCSDRI(IFAIL)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      PARAMETER (NSYMX=20,NLMX=20,NPMX=50,NSMX=3)
      integer, allocatable :: nbloc(:)
      double precision, allocatable :: esc(:),dcsf(:,:),emcsf(:),
     * tcsf(:),a(:,:),b(:,:),tmtr(:),tmti(:),esct(:),test(:)
      DIMENSION IBUG(3),THETA(NPMX),P(2*NLMX,NPMX),
     & NCHSET(NSYMX),NTSET(NSYMX),IMULT(NSYMX),JMULT(NSYMX),
     & EINC(2),luchan(nsymx)
      COMMON/BLCK1/SI,EI,SJ,EJ,SSCT(NSYMX),NSYM,NE,
     &   LAMI,IGUI,LAMJ,IGUJ,LAMSCT(NSYMX),IGUSCT(NSYMX),NBLC(NSYMX),
     &   ISGN(4,NSYMX),JSGN(4,NSYMX),NLI(4,NSYMX),NLJ(4,NSYMX)
      CHARACTER(LEN=1) CFF,ICFORM,ITFORM
      CHARACTER(LEN=3) EUNIT(3)
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=11) TFORM,CFORM
      NAMELIST/TRANS/ITARG,JTARG,NE,EINC,IEUNIT,NCHSET,NSYM,MORE,NTSET,
     & IMULT,JMULT,LUTMT,ITPOUT,KMAX,NPTOT,IBUG,ITFORM,ICFORM,LUCHAN,
     & istyle
      DATA PI/3.141592654D0/,HALF/0.5D0/
      DATA CFF/'U'/,FORM,TFORM,CFORM/3*'FORMATTED'/
      DATA IEUNIT/1/,EV/0.036750D0/,EUNIT/'Ryd',' eV',' au'/,
     & LUTMT,ITPOUT/12,0/,IBUG/3*0/,MORE/0/,istyle/0/
     & NPTOT/19/,ITARG,JTARG/1,1/
C
C#######################################################################
C#    DRIVER ROUTINE FOR COMPUTING DIFFERENTIAL CROSS SECTIONS FOR     #
C#    ELECTRONIC EXCITATION OF DIATOMIC MOLECULES FROM FIXED NUCLEI T  #
C#    MATRICES. IT IS ASSUMED THAT THE SPIN MAGNETIC QUANTUM NUMBERS OF#
C#    THE ELECTRON AND TARGET, THE ORIENTATION OF THE MOLECULE IN SPACE#
C#    , AND THE SIGN OF THE PROJECTION OF ITS TOTAL ORBITAL ANGULAR    #
C#    MOMENTUM ON THE INTERNUCLEAR AXIS, ARE NOT MEASURED.             #
C#######################################################################
C
      NLMXT = 2*NLMX
      KMAX  = NLMXT
      DO 1 I=1,NSYMX
      IMULT(I) = 1
      JMULT(I) = 1
      luchan(i) = 10
      NCHSET(I) = I
      NTSET(I) = I
 1    CONTINUE
      ITFORM = CFF
      ICFORM = CFF
      IFAIL = 0
      ITIME = 0
C
C *** READ, WRITE AND CHECK NAMELIST INPUT
C
      READ(5,TRANS)
C
      IF(ITFORM.EQ.'U') TFORM = 'UN'//FORM
      IF(ICFORM.EQ.'U') CFORM = 'UN'//FORM
      WRITE(6,6001) (LUCHAN(i),i=1,nsym)
      WRITE(6,6005) LUTMT,ITPOUT,KMAX,IBUG
      NP = (NPTOT+1)/2
      NPTOT=2*NP-1
      IF(KMAX.GT.NLMXT) THEN
        WRITE(6,4001) KMAX,NLMXT
        STOP
      ELSE IF(NPTOT.GT.NPMX) THEN
        WRITE(6,4002) NPTOT,NPMX
        STOP
      ENDIF
C
C *** COMPUTE THE ANGULAR GRID AND LEGENDRE POLYNOMIALS, WRITE THE
C     OUTPUT FILE HEADER RECORDS IF REQUIRED
      STEP=PI/2.D0/dble(NP-1)
      FKMAX=KMAX-1
      DO 10 IPTOT=1,NPTOT
         TEMP=(IPTOT-1)*STEP
         THETA(IPTOT)=TEMP
         IF(IPTOT.LE.NP) THEN
            CT=DCOS(TEMP)
            ST=DSIN(TEMP)
            CALL PLMLGD(P(1,IPTOT),CT,ST,FKMAX,0.D0)
         ELSE
            IP=NPTOT-IPTOT+1
            DO 9 K=1,KMAX
               P(K,IPTOT)=P(K,IP)*(-1)**(K-1)
    9       CONTINUE
         ENDIF
   10 CONTINUE
      WRITE(6,6010) NPTOT
      IF(IBUG(1).GT.0) THEN
        CALL MR8PRT(THETA,1,1,NPTOT,NPMX,1,1,1,'THETA   ')
        CALL MR8PRT(P,1,1,KMAX,NLMXT,1,1,NPTOT,'P       ')
      ENDIF
      IF(ITPOUT.GT.0) THEN
         REWIND ITPOUT
         WRITE(ITPOUT) NPTOT
         WRITE(ITPOUT)(THETA(I),I=1,NPTOT)
      ENDIF
C
C *** READ, WRITE AND CHECK NAMELIST TRANS
   50 WRITE(6,6002)
      IF(ITIME.GT.0) THEN
        KMAX  = NLMXT
        DO 2 I=1,NSYMX
        IMULT(I) = 1
        JMULT(I) = 1
 2      CONTINUE
        READ(5,TRANS)
        REWIND LUTMT
      ENDIF
C
      IF(NSYM.GT.NSYMX) THEN
         WRITE(6,4004) NSYM,NSYMX
         STOP
      ENDIF
c
      LREQD = 4*NSMX*NLMX**3+8*NLMX*NLMX*NSYMX+4*NLMX+NSYMX+NPMX+4
     1        +NLMX*(NLMX+2)
      allocate (test(lreqd*ne),stat=ierror)
      IF(ierror.ne.0) THEN
         WRITE(6,4003) NE
         stop
      ENDIF
      deallocate (test)
c
      allocate (nbloc(nsymx*ne),dcsf(npmx,ne),emcsf(ne),tcsf(ne),
     * esc(ne),esct(ne),a(2*nlmx,ne),b(2*nlmx,ne),
     * tmtr(NLMX*NLMX*NSYMX*NE*4),tmti(NLMX*NLMX*NSYMX*NE*4))
c
      WRITE(6,6003) ITARG,JTARG,NE
      ESC(1) = EINC(1)
      DO 54 I=2,NE
      ESC(I) = ESC(I-1)+EINC(2)
 54   continue
      WRITE(6,6004) EUNIT(IEUNIT),(ESC(I),I=1,NE)
      IF(IEUNIT.EQ.1) THEN
        DO 53 I=1,NE
        ESCT(I) = HALF*ESC(I)
 53     continue
      ELSE IF(IEUNIT.EQ.2) THEN
        DO 51 I=1,NE
        ESCT(I) = ESC(I)*EV
 51     continue
      ELSE
        DO 52 I=1,NE
        ESCT(I) = ESC(I)
 52     continue
      ENDIF
      WRITE(6,6013) NSYM
      DO 3 I=1,NSYM
      NBLC(I) = IMULT(I)*JMULT(I)
 3    continue
      if(ibug(1).gt.0) WRITE(6,6014) (NBLC(I),I=1,NSYM)
c
      call GETDIM(nsym,TFORM,NTSET,LUTMT,maxtg,maxch,maxmi,maxmf,
     1 IBUG(1),IFAIL)
C
C *** PREPARE THE T MATRIX BLOCKS NEEDED IN DCS
      CALL DCSORT(LUCHAN,LUTMT,IBUG(2),NCHSET,CFORM,NTSET,TFORM,
     & ITARG,JTARG,NLMX,TMTR,TMTI,ESCT,NBLOC,maxtg,maxch,
     * maxmi,maxmf,ifail)
C
C *** CALCULATE THE SINGLE SET (OR BOTH SETS) OF MULTIPOLAR COEFFICIENTS
      NTAU = NLMX**3*2*NSMX
      CALL DCS(KMAX,IBUG(3),NTAU,NLMX,TMTR,TMTI,A,B,ESCT)
C
C *** COMPUTES THE INTEGRATED CROSS SECTIONS
      WEIGHT=1.D0
      IF(LAMI.EQ.0.AND.LAMJ.NE.0) WEIGHT=2.D0
      DO 70 K=1,KMAX
      DO 60 IE=1,NE
      A(K,IE)=(A(K,IE)+B(K,IE))*WEIGHT
   60 CONTINUE
   70 CONTINUE
      FPI=4.D0*PI
      DO 80 IE=1,NE
      TCSF(IE) = A(1,IE)*FPI
      EMCSF(IE)= (A(1,IE)-A(2,IE)/3.D0)*FPI
   80 CONTINUE
C
C *** COMPUTES THE DCS'S AND WRITES THEM ON ITPOUT IF REQUIRED
      DO 120 K=1,KMAX
      FK=K-1
      FAC=DSQRT(FPI/(2.D0*FK+1.D0))
      DO 110 IE=1,NE
      A(K,IE)=A(K,IE)*FAC
  110 CONTINUE
  120 CONTINUE
      CALL MTMULT(DCSF,P,A,NPTOT,KMAX,NE,NPMX,NLMXT,NLMXT)
      WRITE(6,6007)
      if(istyle.eq.0.or.istyle.eq.2)
     1 CALL DCSPRT(DCSF,TCSF,EMCSF,NPTOT,NPMX,NE,THETA,ESC,IEUNIT)
      if(istyle.eq.1.or.istyle.eq.2)
     1 CALL EXFPRT(DCSF,TCSF,EMCSF,NPTOT,NPMX,NE,THETA,ESC,IEUNIT)
      IF(ITPOUT.GT.0) THEN
         WRITE(ITPOUT)SI,LAMI,IGUI,SJ,LAMJ,IGUJ,NE
         WRITE(ITPOUT)(ESCT(IE),IE=1,NE)
         WRITE(ITPOUT)((DCSF(IPTOT,IE),IPTOT=1,NPTOT),IE=1,NE)
      ENDIF
C
C *** TURNS TO THE FOLLOWING TRANSITION IF ANY
      IF(MORE.GT.0) THEN
        ITIME = ITIME+1
        GO TO 50
      ELSE
        deallocate (nbloc,dcsf,emcsf,tcsf,esc,esct,a,b,tmtr,
     *              tmti)
        STOP
      ENDIF
C
 1001 FORMAT(//' Insufficient core,  given',I10,'  required',I10)
 6001 FORMAT(/' Unit for target data input,    LUCHAN =',8I3)
 6005 format( ' Unit for T-matrix input,       LUTMT  =',I3,
     &       /' Unit for cross section output, ITPOUT =',I3,
     &       /' Number of Legendre polynomials KMAX   =',I3,
     &      //' Debug flags, IBUG=',3I3)
 6002 FORMAT(//' **************************'/
     &         ' *   CURRENT TRANSITION   *'/
     &         ' **************************')
 6003 FORMAT(/' Transition is between state',I2,' and state',I2/
     &        ' Number of scattering energies, NE   =',I3)
 6004 FORMAT(/' Scattering energies (',A,')',10(/10F11.4))
 6007 FORMAT(/' ### CROSS SECTIONS  (units: bohr**2)')
 6010 FORMAT(/' Angular grid:',I3,' equally spaced points in [0,pi]')
 6013 FORMAT(//' Number of scattering symmetries in sum,   NSYM =',I3)
 6014 FORMAT(/' Number of T-matrix blocks required for each symmetry'
     &       /' NBLC =',20I3)
C
 4001 FORMAT(/' STOP : KMAX=',I3,' WHILE NLMXT=',I3,' INCREASE NLMXT')
 4002 FORMAT(/' STOP : NPTOT=',I3,' WHILE NPMX=',I3,' INCREASE NPMX')
 4003 FORMAT(/' STOP : NE=',I3,' would exceed core available')
 4004 FORMAT(/' STOP : NSYM=',I3,' WHILE NSYMX=',I3,' INCREASE NSYMX')
C
      END
      SUBROUTINE DCSPRT(A,TOT,EMTOT,NI,NIMX,NE,THETA,ESCT,IEUNIT)
C#######################################################################
C#    PRINTS DIFFERENTIAL CROSS SECTIONS
C#######################################################################
      PARAMETER (NL=5)
      DOUBLE PRECISION A(NIMX,*),ALGN(NL),THETA(*),ESCT(NE),TOT(NE),
     & EMTOT(NE)
      CHARACTER(LEN=3) EUNIT(3)
      DATA EUNIT/'Ryd',' eV',' au'/,PI/3.141592654/
C
      DEGR = 180./PI
      NELEFT = NE
   10 NEC = MIN(NELEFT,NL)
      NEINC = NE-NELEFT
      WRITE(6,9001) EUNIT(IEUNIT),(ESCT(J),J=NEINC+1,NEINC+NEC)
      WRITE(6,9003) (TOT(J),J=NEINC+1,NEINC+NEC)
      WRITE(6,9005) (EMTOT(J),J=NEINC+1,NEINC+NEC)
      WRITE(6,9004)
      DO 30 I=1,NI
      DO 20 J=1,NEC
      JJ=J+NEINC
      ALGN(J)=A(I,JJ)
   20 CONTINUE
      WRITE(6,9002) I,THETA(I)*DEGR,(ALGN(J),J=1,NEC)
   30 CONTINUE
      NELEFT=NELEFT-NEC
      IF(NELEFT.GT.0) GO TO 10
C
      RETURN
 9001 FORMAT(/1X,'Energies (',A3,')  ',5F12.5)
 9002 FORMAT(9X,I3,F6.0,5D12.4)
 9003 FORMAT(/1X,'Integrated       ',5D12.4)
 9005 FORMAT(/1X,'Momentum transfer',5D12.4)
 9004 FORMAT(/1X,'Differential cross sections,  (angles in degrees) ')
      END
      SUBROUTINE EXFPRT(A,TOT,EMTOT,NI,NIMX,NE,THETA,ESCT,IEUNIT)
C#######################################################################
C#    PRINTS Excitation functions at a given angle THETA
C#######################################################################
      PARAMETER (NL=6)
      DOUBLE PRECISION A(NIMX,*),THETA(*),ESCT(NE),TOT(NE),
     & EMTOT(NE)
      CHARACTER(LEN=3) EUNIT(3)
      DATA EUNIT/'Ryd',' eV',' au'/,PI/3.141592654/
C
      DEGR = 180.d0/PI
      WRITE(6,9001) EUNIT(IEUNIT)
c
      write(6,9004)
      do 21 j=1,ne
      write(6,9002) esct(j),tot(j),emtot(j)
 21   continue
      NILEFT = NI
   10 NIC = MIN(NILEFT,NL)
      NIINC = NI-NILEFT
      WRITE(6,9003) (theta(i+niinc)*degr,i=1,nic)
      do 20 j=1,ne
      WRITE(6,9002) ESCT(J),(a(i+niinc,j),i=1,nic)
   20 CONTINUE
      NILEFT=NILEFT-NIC
      IF(NILEFT.GT.0) GO TO 10
C
      RETURN
 9001 FORMAT(/1X,'Energies in (',A3,')  ')
 9002 FORMAT(F6.3,6D12.4)
 9003 FORMAT(/1X,'Angles   ',f6.0,8f12.0)
 9004 format(/1x,' En   Integrated  Mom.Transf')
      END
      SUBROUTINE GETTMT(TFORM,NTSET,LASTST,MSYM,STOT,GUTOT,NMX,
     & NTRANS,NCHAN,NVIB,NDIS,TREAL,TIMAG,IGAP,JGAP,ISGN,JSGN,NLI,
     & NLJ,NBLC,ECU,ISYM,MAXVI,MAXVJ,ICHL,LCHL,MCHL,ECHL,LUTMT,
     & NTARG,tr,ti,IPRNT,IFAIL)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXESC=10)
      double precision :: tr(*),ti(*)
      DIMENSION TREAL(NMX,*),TIMAG(NMX,*),NTSET(*),NBLC(*),
     1 NEREP(MAXESC+1),EINC(2*MAXESC),ICHL(*),LCHL(*),MCHL(*),ECHL(*),
     * mvi(1),mvf(1),mvd(1),enr(1),IGAP(4,*),JGAP(4,*),
     & ISGN(4,*),JSGN(4,*),NLI(4,*),NLJ(4,*)
      INTEGER GUTOT,STOT
      CHARACTER(LEN=11) TFORM
      CHARACTER(LEN=80) TITLE
      DATA TINY/1.D-6/,ZERO/0.D0/,IWRITE/6/,EN/-100.d0/
      save 
C
C---- Argument list
C     MSYM = M symmetry of complete system 
C
C----- THE CONVENTION T = S-1 IS ASSUMED (QUERY)
C
      KOUNT = ISYM
      XKSQ = 2.D0*ECU
      IF(IPRNT.GT.0) WRITE(IWRITE,503) KOUNT
      IF(NTSET(KOUNT).GT.0) THEN
        IF(NTSET(KOUNT).NE.LASTST.OR.XKSQ.LT.EN) THEN
          CALL READTH(LUTMT,TITLE,NTSET(KOUNT),NCHAN,NVIB,NDIS,NTARG,
     1    MAXCHI,MAXCHF,MGVN,STOT,GUTOT,NETOT,MAXNE,NEREP,EINC,ICHL,
     2    LCHL,MCHL,ECHL,TFORM,IWRITE,IPRNT-1,IFAIL)
          IF(IFAIL.NE.0) RETURN
c This seems to rule out cases where there are closed channels
c          IF(MAXCHF.NE.NCHAN) THEN
c            WRITE(IWRITE,510)
c            IFAIL = 1
c            RETURN
c          ENDIF
          IF(IPRNT.GT.0) WRITE(IWRITE,507) NTSET(KOUNT),TITLE,MGVN,
     1    GUTOT,NCHAN
          LASTST = NTSET(KOUNT)
        ENDIF
      ELSE
        WRITE(IWRITE,501) NTSET(KOUNT),KOUNT
        IFAIL = 1
        RETURN
      ENDIF
C
      MSYM = MGVN
C
      IRED = 0
      neq = 1
 11   CALL READT(neq,MAXCHI,MAXCHF,NDIS,MVI,MVF,MVD,TR,TI,ENr)
      IRED = IRED+1
      en = enr(1)
      maxvi = mvi(1)
      maxvf = mvf(1)
      maxvd = mvd(1)
C
C---- Is this the right energy ?
      IF(EN.LT.XKSQ-TINY.OR.EN.GT.XKSQ+TINY) THEN
        IF(IRED.LT.NETOT) THEN
          GO TO 11
        ELSE
          WRITE(IWRITE,502) XKSQ,EN
          IFAIL = 1
          RETURN
        ENDIF
      ELSE
        IF(IPRNT.NE.0) WRITE(IWRITE,511) EN
      ENDIF
C
C---- Unpack T-matrix
      MAXVJ = MAXVF+MAXVD
      I2 = 0
      DO 12 J=1,MAXVJ
      DO 13 I=1,MAXVI
      TREAL(I,J) = tr(I2+I)
      timag(i,j) = ti(i2+i)
 13   continue
      I2 = I2+MAXCHI
 12   continue
C
C---- Set up pointers to required blocks of the T-matrix
      NT = ICHL(MAXVF)
      DO 31 IT=1,NT*ichl(maxvi)
      NBLC(IT) = 0
 31   continue
      ITARG = 0
      JTARG = 0
      LASTMI = -10
      LASTMJ = -10
      DO 2 I=1,MAXVI
      IF(ICHL(I).EQ.ITARG.AND.LASTMI.EQ.MCHL(I)) GO TO 20
      ITARG = ICHL(I)
      DO 3 J=1,MAXVJ
      IF(ICHL(J).EQ.JTARG.AND.LASTMJ.EQ.MCHL(J)) GO TO 30
      JTARG = ICHL(J)
      IT = (ITARG-1)*NT+JTARG
      NBLC(IT) = NBLC(IT)+1
      IJB = NBLC(IT)
      NLI(IJB,IT) = 0
      NLJ(IJB,IT) = 0
      IGAP(IJB,IT) = I-1
      JGAP(IJB,IT) = J-1
      MDIF = MGVN-MCHL(I)
      IF(MDIF.NE.0) THEN
        ISGN(IJB,IT) = SIGN(1,MDIF)
      ELSE
        ISGN(IJB,IT) = 0
      ENDIF
      MDIF = MGVN-MCHL(J)
      IF(MDIF.NE.0) THEN
        JSGN(IJB,IT) = SIGN(1,MDIF)
      ELSE
        JSGN(IJB,IT) = 0
      ENDIF
c
 30   NLJ(IJB,IT) = NLJ(IJB,IT)+1
      LASTMJ = MCHL(J)
 3    continue
c
 20   LASTMI = MCHL(I)
 2    continue
      NTRANS = IT
      NTARGI = ITARG
      NTARGJ = JTARG
C
C       Copy NLJ into NLI  (NLI depends only on I and NLJ only on J)
      IT = 0
      DO 6 I=1,NTARGI
      DO 61 J=1,NTARGJ
      IT = IT+1
      NLI(1,IT) = NLJ(1,I)
      NB = NBLC(IT)
      IF(NB.GT.1) THEN
        NLI(NB,IT) = NLJ(NBLC(I),I)
        IF(NB.GT.2) THEN
          IF(NBLC(I).EQ.1) THEN
            PRINT *,' ERROR IN GETTMT',IT,NB,I,NBLC(I)
            STOP
          ENDIF
          NLI(2,IT) = NLJ(1,I)
          NLI(3,IT) = NLJ(2,I)
        ENDIF
      ENDIF
 61   continue
 6    CONTINUE
C
      RETURN
c
 501  FORMAT(/' INVALID VALUE OF NTSET ',I4,' FOR REQUEST NUMBER',I4)
 502  FORMAT(/' UNABLE TO LOCATE ENERGY',F10.6,' RYD ON T-MATRIX FILE,
     1NEXT ENERGY IS',F10.6)
 503  FORMAT(//' SYMMETRY NUMBER',I3)
 504  FORMAT(/' Real part of T-matrix')
 505  FORMAT(/' Imaginary part of T-matrix')
 507  FORMAT(/' T-matrices from set number ',I2,5X,A/' MGVN =',I2,
     1'  GUTOT =',I2,'  NCHAN =',I3)
 508  FORMAT(3E20.13)
 509  FORMAT(10E12.4)
 510  FORMAT(/' Subset of T-matrix incompatible with DCS',
     1       /' Rerun TMATRX with MAXF left as default value')
 511  FORMAT(/' Found T-matrix for energy ',F10.6)
C
      END
      SUBROUTINE DCSORT(LUCHAN,LUTMT,IBUG,NCHSET,CFORM,NTSET,TFORM,
     & ITARGT,JTARGT,NLMX,TMTR,TMTI,ESCT,NBLOC,maxtg,maxch,
     * ndmx,ndmy,ifail)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
c
      PARAMETER (NTMX=100,NSYMX=20,NSMX=3)
c     NTMX is the maximum number of transitions to be considered
c
      COMMON/BLCK1/SI,EI,SJ,EJ,SSCT(NSYMX),NSYM,NE,
     &   LAMI,IGUI,LAMJ,IGUJ,LAMSCT(NSYMX),IGUSCT(NSYMX),NBLC(NSYMX),
     &   ISGN(4,NSYMX),JSGN(4,NSYMX),NLI(4,NSYMX),NLJ(4,NSYMX)
      COMMON/BLCK2/KEYGU,LISTT(4,NSYMX),
     &   LJSTT(4,NSYMX),INDBLC(4,NSYMX),KEYDBL(2)
      double precision, allocatable :: temp(:),tr(:),ti(:)
      DIMENSION SICU(NTMX),LAMICU(NTMX),IGUICU(NTMX),EICU(NTMX),
     &   SJCU(NTMX),LAMJCU(NTMX),IGUJCU(NTMX),EJCU(NTMX),
     &   NBLCU(NTMX),IGAP(4,NTMX),NLICU(4,NTMX),ISGNCU(4,NTMX),
     & JGAP(4,NTMX),NLJCU(4,NTMX),JSGNCU(4,NTMX),ATMR(NDMX,ndmy),
     & ATMI(NDMX,ndmy),NBLOC(*),NTSET(*),ESCT(*),luchan(*),
     & NCHSET(*),TMTR(NLMX*NLMX,*),TMTI(NLMX*NLMX,*),
     & IVTARG(maxtg),IVNU(maxtg),IVCHL(maxch),LVCHL(maxch),MVCHL(maxch),
     & EVCHL(maxch),STARG(maxtg),MTARG(maxtg),GTARG(maxtg),ETARG(maxtg)
      INTEGER STARG,GTARG
      CHARACTER(LEN=13) CGU(2)
      CHARACTER*(*) TFORM,CFORM
C
      DATA CGU/'HETERONUCLEAR','HOMONUCLEAR'/
      DATA RR/0.D0/,ZERO,EPS,HALF/0.D0,1.D-4,0.5D0/
C
C#######################################################################
C#    PREPARES THE T MATRIX BLOCKS CORRESPONDING TO THE CURRENT        #
C#    TRANSITION IN A FORM THAT CAN BE USED BY SUBROUTINE DCS          #
C#######################################################################
C
      WRITE(6,6001)
C
C *** CHECK THE DATA PASSED THROUGH COMMON/BLCK1/ AND LIST
      IF (IBUG.GT.0) THEN
         WRITE(6,5001) (LUCHAN(i),i=1,nsym)
         WRITE(6,5013) LUTMT,IBUG
         WRITE(6,5011) NE
         WRITE(6,5002) (ESCT(I),I=1,NE)
         WRITE(6,5012) NSYM
         WRITE(6,5003) (NBLC(I),I=1,NSYM)
      ENDIF
C
C *** COMPUTES THE NUMBER OF T MATRIX SUB-BLOCKS REQUIRED
      NASKED=0
      DO 1 I=1,NSYM
      NASKED=NASKED+NBLC(I)
    1 CONTINUE
      NASKED=NE*NASKED
      IF(IBUG.GT.0) WRITE(6,5004) NASKED
C
C *** READ, PRINT AND CHECK A T MATRIX TAKEN FROM FILE 
      NMAT   = 0
      NFOUND = 0
      NDONE  = 0
      ISYM = 1
      LASTST = -1
      maxxi = 0
      maxxj = 0
c
      allocate (tr(ndmx*ndmy),ti(ndmx*ndmy))
c
   10 CONTINUE
      NEXTS = NDONE+NBLC(ISYM)*NE
      IF(NFOUND.EQ.NEXTS) THEN
        NDONE = NEXTS
        ISYM = ISYM+1
        IEN = 1
      ELSE
        IEN = (NFOUND-NDONE+NBLC(ISYM))/NBLC(ISYM)
      ENDIF
      ECU   = ESCT(IEN)
C
      CALL GETTMT(TFORM,NTSET,LASTST,LAMCU,ISTOT,IGUCU,NDMX,
     & NTRSCU,NCHAN,NVIB,NDIS,ATMR,ATMI,IGAP,JGAP,ISGNCU,JSGNCU,
     & NLICU,NLJCU,NBLCU,ECU,ISYM,MAXVI,MAXVJ,IVCHL,LVCHL,MVCHL,
     & EVCHL,LUTMT,NTARG,tr,ti,IBUG,IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(6,4004)
        STOP
      ENDIF
      IF(NTRSCU.GT.NTMX) THEN
        WRITE(6,4002) NTRSCU,NTMX
        STOP
      ENDIF
      LAMSCT(ISYM) = LAMCU
      IGUSCT(ISYM) = IGUCU
      SCU = HALF*(ISTOT-1)
      SSCT(ISYM) = SCU
C
C---- Read target and channel data (NCHAN, NVIB and NDIS are INPUT)
      IF(IEN.EQ.1) CALL READTC(LUCHAN(isym),NCHSET(ISYM),NCHAN,NVIB,
     1 NDIS,NTARG,ION,IVTARG,IVNU,IVCHL,LVCHL,MVCHL,EVCHL,STARG,MTARG,
     & GTARG,ETARG,RR,RMASS,CFORM,6,IBUG-1,IFAIL)
C
      IF(NVIB.EQ.0) THEN
        ITG = ITARGT
        JTG = JTARGT
      ELSE
        ITG = IVTARG(ITARGT)
        JTG = IVTARG(JTARGT)
      ENDIF
      SI = HALF*(STARG(ITG)-1)
      SJ = HALF*(STARG(JTG)-1)
      LAMI = ABS(MTARG(ITG))
      LAMJ = ABS(MTARG(JTG))
      NB   = NBLC(ISYM)
      IF(NB.NE.1.AND.NB.NE.2.AND.NB.NE.4) GO TO 408
      IF((LAMCU.EQ.0.OR.(LAMCU.GT.0.AND.(LAMI+LAMJ).EQ.0))
     & .AND.NB.NE.1) GO TO 408
      IF((LAMCU.GT.0.AND.LAMI*LAMJ.EQ.0.AND.(LAMI+LAMJ).NE.0)
     & .AND.NB.GT.2) GO TO 408
      IF(LAMI.EQ.0) THEN
        DO 51 IB=1,NB
        ISGN(IB,ISYM) = 0
 51     continue
      ELSE
        ISGN(1,ISYM) = 1
        IF(NB.GT.1) THEN
          IF(NB.EQ.2) THEN
            ISGN(2,ISYM) = -1
          ELSE
            ISGN(2,ISYM) = 1
            ISGN(3,ISYM) = -1
            ISGN(4,ISYM) = -1
          ENDIF
        ENDIF
      ENDIF
      IF(LAMJ.EQ.0) THEN
        DO 52 IB=1,NB
        JSGN(IB,ISYM) = 0
 52     continue
      ELSE
        JSGN(1,ISYM) = 1
        IF(NB.GT.1) THEN
          JSGN(2,ISYM) = -1
          IF(NB.GT.2) THEN
            JSGN(3,ISYM) = 1
            JSGN(4,ISYM) = -1
          ENDIF
        ENDIF
      ENDIF
      IGUI = GTARG(ITG)
      IGUJ = GTARG(JTG)
C
C *** INITIALIZE A KEY FOR HETERO/HOMONUCLEAR CASE
      IF(NFOUND.EQ.0) THEN
        KEYGU=1
        IF(IGUI.NE.0) KEYGU=2
        IF(IBUG.GT.0) WRITE(6,5005) CGU(KEYGU)
      ENDIF
C
C *** COMPUTES THE STARTING ANGULAR MOMENTUM OF THE SCATTERED ELECTRON
C     IN A ROW AND IN A COLUMN OF EACH T SUB-BLOCK IN EACH SYMMETRY
      IF(IEN.EQ.1) THEN
        LAM=LAMCU
        IGU=IGUCU
        DO 4 IBLC=1,NBLC(ISYM)
        CALL LSTART(LAM,LAMI,ISGN(IBLC,ISYM),IGU,IGUI,
     &                   LISTT(IBLC,ISYM))
        CALL LSTART(LAM,LAMJ,JSGN(IBLC,ISYM),IGU,IGUJ,
     &                   LJSTT(IBLC,ISYM))
 4      CONTINUE
        IF(IBUG.GT.0) THEN
          CALL MI4PRT(LISTT,1,1,4,4,1,1,NSYM,'LISTT   ')
          CALL MI4PRT(LJSTT,1,1,4,4,1,1,NSYM,'LJSTT   ')
        ENDIF
      ENDIF
C
      IT = 0
      ITARG = 0
      JTARG = 0
      EI = -HALF
      EJ = -HALF
      DO 2 I=1,MAXVI
      IF(IVCHL(I).EQ.ITARG) GO TO 2
      ITARG = IVCHL(I)
      IF(NVIB.EQ.0) THEN
        ITG = ITARG
      ELSE
        ITG = IVTARG(ITARG)
      ENDIF
      IF(ITARG.EQ.ITARGT) EI=HALF*EVCHL(I)
      DO 3 J=1,MAXVJ
      IF(IVCHL(J).EQ.JTARG) GO TO 3
      JTARG = IVCHL(J)
      IF(NVIB.EQ.0) THEN
        JTG = JTARG
      ELSE
        JTG = IVTARG(JTARG)
      ENDIF
      IF(JTARG.EQ.JTARGT) EJ=HALF*EVCHL(J)
      IT = IT+1
      SICU(IT) = HALF*(STARG(ITG)-1)
      SJCU(IT) = HALF*(STARG(JTG)-1)
      LAMICU(IT) = ABS(MTARG(ITG))
      LAMJCU(IT) = ABS(MTARG(JTG))
      IGUICU(IT) = GTARG(ITG)
      IGUJCU(IT) = GTARG(JTG)
      EICU(IT)   = HALF*EVCHL(I)
      EJCU(IT)   = HALF*EVCHL(J)
 3    CONTINUE
 2    CONTINUE
      IF(EI.LT.ZERO.OR.EJ.LT.ZERO) THEN
        WRITE(6,4004)
        STOP
      ENDIF
c
      NMAT=NMAT+1
      IF (IBUG.GT.0) THEN
         WRITE(6,5006) SCU,LAMCU,IGUCU,ECU,maxvj,NTRSCU
         WRITE(6,5007)
     &   (SICU(I),LAMICU(I),IGUICU(I),EICU(I),
     &    SJCU(I),LAMJCU(I),IGUJCU(I),EJCU(I),NBLCU(I),I=1,NTRSCU)
         CALL MI4PRT(IGAP,1,1,4,4,1,1,NTRSCU,'IGAP    ')
         CALL MI4PRT(JGAP,1,1,4,4,1,1,NTRSCU,'JGAP    ')
         CALL MI4PRT(NLICU,1,1,4,4,1,1,NTRSCU,'NLICU   ')
         CALL MI4PRT(NLJCU,1,1,4,4,1,1,NTRSCU,'NLJCU   ')
         CALL MI4PRT(ISGNCU,1,1,4,4,1,1,NTRSCU,'ISGNCU  ')
         CALL MI4PRT(JSGNCU,1,1,4,4,1,1,NTRSCU,'JSGNCU  ')
         CALL MR8PRT(ATMR,1,1,maxvi,NDMX,1,1,maxvj,'R(T)    ')
         CALL MR8PRT(ATMI,1,1,maxvi,NDMX,1,1,maxvj,'I(T)    ')
      ENDIF
      maxnli = 0
      maxnlj = 0
      DO 50 I=1,NTRSCU
      DO 40 J=1,NBLCU(I)
      IMAX=IGAP(J,I)+NLICU(J,I)
      maxnli = max(maxnli,nlicu(j,i))
      JMAX=JGAP(J,I)+NLJCU(J,I)
      maxnlj = max(maxnlj,nljcu(j,i))
      IF(IMAX.GT.maxvi.OR.JMAX.GT.maxvj) THEN
        WRITE(6,4003) J,I
        STOP
      ENDIF
   40 CONTINUE
   50 CONTINUE
      if(maxnli*maxnlj.gt.maxxi*maxxj) then
        maxxi = maxnli
        maxxj = maxnlj
        if(allocated(temp)) deallocate(temp)
        allocate (temp(maxxi*maxxj))
      endif
C
C *** SEE IF IT CONTAINS PART OF THE INFORMATION REQUIRED (THE VARIOUS
C     TESTS ARE NESTED SO THAT THE MORE LENGTHY ARE PERFORMED THE LESS
C     OFTEN, WHILE OPTIMIZING THE ACCESS TO THE TMTR/TMTI ARRAYS IN A
C     WAY CONSISTENT WITH DCS)
C     IF IT DOES NOT
C        READ THE FOLLOWING MATRIX
C     IF IT DOES
C        SYMMETRIZE THE MATRIX
C        STORE THE BLOCKS CORRESPONDING TO THE REQUIRED TRANSITION
C     ENDIF
      NBLOC(NMAT)=0
         NB=NBLC(ISYM)
         INDIC1=(ISYM-1)*NE*4
         DO 90 IE=1,NE
            IF (ESCT(IE).NE.ECU) GO TO 90
            INDIC2=INDIC1+(IE-1)*4
            DO 80 ITCU=1,NTRSCU
               ITEST=ABS(LAMI-LAMICU(ITCU))+
     &               ABS(IGUI-IGUICU(ITCU))+
     &               ABS(LAMJ-LAMJCU(ITCU))+
     &               ABS(IGUJ-IGUJCU(ITCU))
               TEST=ABS(SI-SICU(ITCU))+ABS(EI-EICU(ITCU)) +
     &              ABS(SJ-SJCU(ITCU))+ABS(EJ-EJCU(ITCU))
               IF(ITEST.NE.0.OR.TEST.GT.EPS) THEN
                 IF(IBUG.NE.0) WRITE(6,4006) ITCU,LAMI,LAMICU(ITCU),
     &           IGUI,IGUICU(ITCU),LAMJ,LAMJCU(ITCU),IGUJ,IGUJCU(ITCU),
     &           SI,SICU(ITCU),EI,EICU(ITCU),SJ,SJCU(ITCU),EJ,EJCU(ITCU)
                 GO TO 80
               ENDIF
               NBCU=NBLCU(ITCU)
               IF(NBCU.LT.NB) GO TO 10
               DO 70 IB=1,NB
                  LISTTC=LISTT(IB,ISYM)
                  LJSTTC=LJSTT(IB,ISYM)
                  INDICE=INDIC2+IB
                  DO 60 IBCU=1,NBCU
                  ITEST=ABS(ISGN(IB,ISYM)-ISGNCU(IBCU,ITCU))+
     &                  ABS(JSGN(IB,ISYM)-JSGNCU(IBCU,ITCU))
                  IF(ITEST.EQ.0) THEN
                    NLIC=NLICU(IBCU,ITCU)
                    NLJC=NLJCU(IBCU,ITCU)
                    NLI(IB,ISYM) = NLIC
                    NLJ(IB,ISYM) = NLJC
                    NFOUND = NFOUND+1
                    NBLOC(NMAT) = NBLOC(NMAT)+1
                    IF(IBUG.GT.0) WRITE(6,5008) ISYM,IE,IB
                    IGAPC=IGAP(IBCU,ITCU)
                    JGAPC=JGAP(IBCU,ITCU)
                    CALL MTBLCK(ATMR,NDMX,TEMP,NLMX,
     &                              IGAPC,NLIC,JGAPC,NLJC)
                    IF(IBUG.GT.0) CALL MR8PRT
     &                  (TEMP,1,1,NLIC,NLMX,1,1,NLJC,'RT BLOCK')
                    CALL MTVEC(TEMP,NLIC,NLJC,LISTTC,LJSTTC,KEYGU,
     &                             TMTR(1,INDICE),NLMX)
                    CALL MTBLCK(ATMI,NDMX,TEMP,NLMX,
     &                              IGAPC,NLIC,JGAPC,NLJC)
                    IF(IBUG.GT.0) CALL MR8PRT
     &                  (TEMP,1,1,NLIC,NLMX,1,1,NLJC,'IT BLOCK')
                    CALL MTVEC(TEMP,NLIC,NLJC,LISTTC,LJSTTC,KEYGU,
     &                             TMTI(1,INDICE),NLMX)
                    GO TO 70
                  ELSE IF(IBUG.GT.0) THEN
                    WRITE(6,4005) IB,ISYM,IBCU,ITCU,
     &                    ISGN(IB,ISYM),ISGNCU(IBCU,ITCU),
     &                    JSGN(IB,ISYM),JSGNCU(IBCU,ITCU)
                  ENDIF
   60           CONTINUE
   70         CONTINUE
            IF(NFOUND.EQ.NASKED) GO TO 150
               GO TO 10
   80       CONTINUE
            GO TO 10
   90    CONTINUE
         GO TO 10
C
C *** END OF FILE ON LUTMT OR ON UNIT 5, AND/OR ALL INFORMATION REQUIRED
C     HAS BEEN OBTAINED
  150 WRITE(6,6002) NASKED,NFOUND
      IF(IBUG.GT.0) THEN
         WRITE(6,6003) NMAT
         CALL MI4PRT(NBLOC,1,1,1,1,1,1,NMAT,'NBLOC   ')
      ENDIF
      deallocate (tr,ti)
      IF(NFOUND.NE.NASKED) STOP
C
C *** CONNECT THE ORDERING OF THE T MATRIX BLOCKS DEFINED BY/TRANS/ WITH
C     THAT USED IN DCS, USING THE ARRAYS INDBLC(4,NSYMX) AND KEYDBL(2)
C     IF(LAMI.EQ.0.AND.LAMJ.EQ.0) THEN
C        INDBLC(1,ISYM)=1
C        INDBLC(2,ISYM)=1 IF LAMSCT(ISYM).NE.0, OR 0.
C        INDBLC(3,ISYM)=0
C        INDBLC(4,ISYM)=0
C        KEYDBL(1)=1
C        KEYDBL(2)=0
C     ELSE IF(LAMI.EQ.0.OR.LAMJ.EQ.0) THEN
C        INDBLC(1,ISYM)=1
C        INDBLC(2,ISYM)=2 IF LAMSCT(ISYM).NE.0.AND.NBLC(ISYM).EQ.2, OR 0
C        INDBLC(3,ISYM)=0
C        INDBLC(4,ISYM)=0
C        KEYDBL(1)=1
C        KEYDBL(2)=0
C     ELSE
C        INDBLC(1,ISYM) : INDICE(SIGN(LAMI)= SIGN(LAMJ)= ANY1), OR 0
C        INDBLC(2,ISYM) : INDICE(SIGN(LAMI)= SIGN(LAMJ)=-ANY1), OR 0
C        INDBLC(3,ISYM) : INDICE(SIGN(LAMI)=-SIGN(LAMJ)= ANY2), OR 0
C        INDBLC(4,ISYM) : INDICE(SIGN(LAMI)=-SIGN(LAMJ)=-ANY2), OR 0
C        KEYDBL(1) : 1 IF INDBLC(1,ISYM).NE.0 FOR SOME ISYM
C                  : 3 IF INDBLC(3,ISYM).NE.0 FOR SOME ISYM AND
C                         INDBLC(1,ISYM).EQ.0 FOR ALL  ISYM
C        KEYDBL(2) : 3 IF INDBLC(3,ISYM).NE.0 FOR SOME ISYM AND
C                         KEYDBL(1).NE.3
C                  : 0 IN ALL OTHER CASES
C     ENDIF
C
      DO 210 ISYM=1,NSYM
         INDBLC(1,ISYM)=1
         INDBLC(2,ISYM)=0
         INDBLC(3,ISYM)=0
         INDBLC(4,ISYM)=0
  210 CONTINUE
      KEYDBL(1)=1
      KEYDBL(2)=0
      IF(LAMI.EQ.0.AND.LAMJ.EQ.0) THEN
         DO 220 ISYM=1,NSYM
            IF(LAMSCT(ISYM).NE.0) INDBLC(2,ISYM)=1
  220    CONTINUE
      ELSE IF(LAMI.EQ.0.OR.LAMJ.EQ.0) THEN
         DO 230 ISYM=1,NSYM
            IF(NBLC(ISYM).EQ.2.AND.LAMSCT(ISYM).NE.0) INDBLC(2,ISYM)=2
  230    CONTINUE
      ELSE
         DO 240 ISYM=1,NSYM
            NBLCC=NBLC(ISYM)
            LAM=LAMSCT(ISYM)
            IF(NBLCC.EQ.1) THEN
               CALL FINDT(ISGN(1,ISYM),JSGN(1,ISYM),1,1,IBLC1)
               IF(IBLC1.EQ.0) THEN
                  INDBLC(1,ISYM)=0
                  INDBLC(3,ISYM)=1
               ENDIF
            ELSE IF(NBLCC.EQ.2) THEN
               CALL FINDT(ISGN(1,ISYM),JSGN(1,ISYM),2,1,IBLC1)
               IF(IBLC1.EQ.0) THEN
                  INDBLC(1,ISYM)=0
                  INDBLC(3,ISYM)=1
                  INDBLC(4,ISYM)=2
               ELSE
                  INDBLC(1,ISYM)=IBLC1
                  CALL FINDL(ISGN(1,ISYM),JSGN(1,ISYM),2,IBLC1,IBLC2)
                  IF(IBLC2.NE.0) THEN
                     IF(LAM.NE.0) INDBLC(2,ISYM)=IBLC2
                  ELSE
                     INDBLC(3,ISYM)=MOD(IBLC1,2)+1
                  ENDIF
               ENDIF
            ELSE IF(NBLCC.EQ.3) THEN
               CALL FINDT(ISGN(1,ISYM),JSGN(1,ISYM),3,1,IBLC1)
               INDBLC(1,ISYM)=IBLC1
               CALL FINDL(ISGN(1,ISYM),JSGN(1,ISYM),3,IBLC1,IBLC2)
               IF(IBLC2.EQ.0) THEN
                  IF(IBLC1.EQ.1) THEN
                     INDBLC(3,ISYM)=2
                     IF(LAM.NE.0) INDBLC(4,ISYM)=3
                  ELSE IF(IBLC1.EQ.2) THEN
                     INDBLC(3,ISYM)=1
                     IF(LAM.NE.0) INDBLC(4,ISYM)=3
                  ELSE
                     INDBLC(3,ISYM)=1
                     IF(LAM.NE.0) INDBLC(4,ISYM)=2
                  ENDIF
               ELSE
                  IF(LAM.NE.0) INDBLC(2,ISYM)=IBLC2
                  IF(IBLC1*IBLC2.EQ.2) THEN
                     INDBLC(3,ISYM)=3
                  ELSE IF(IBLC1*IBLC2.EQ.3) THEN
                     INDBLC(3,ISYM)=2
                  ELSE
                     INDBLC(3,ISYM)=1
                  ENDIF
               ENDIF
            ELSE IF(NBLCC.EQ.4) THEN
               CALL FINDT(ISGN(1,ISYM),JSGN(1,ISYM),4,1,IBLC1)
               INDBLC(1,ISYM)=IBLC1
               CALL FINDL(ISGN(1,ISYM),JSGN(1,ISYM),4,IBLC1,IBLC2)
               INDBLC(2,ISYM)=IBLC2
               CALL FINDT(ISGN(1,ISYM),JSGN(1,ISYM),4,-1,IBLC3)
               INDBLC(3,ISYM)=IBLC3
               CALL FINDL(ISGN(1,ISYM),JSGN(1,ISYM),4,IBLC3,IBLC4)
               INDBLC(4,ISYM)=IBLC4
            ENDIF
  240    CONTINUE
         ITR1=0
         ITR2=0
         DO 250 ISYM=1,NSYM
            IF(INDBLC(1,ISYM).NE.0) ITR1=ITR1+1
            IF(INDBLC(3,ISYM).NE.0) ITR2=ITR2+1
  250    CONTINUE
         IF(ITR1.EQ.0.AND.ITR2.EQ.0) THEN
            WRITE(6,4004)
            STOP
         ELSE IF(ITR1.EQ.0) THEN
            KEYDBL(1)=3
         ELSE IF(ITR1.NE.0.AND.ITR2.NE.0) THEN
            KEYDBL(2)=3
         ENDIF
      ENDIF
      IF(IBUG.GT.0) THEN
         WRITE(6,5009) KEYDBL
         CALL MI4PRT(INDBLC,1,1,4,4,1,1,NSYM,'INDBLC  ')
      ENDIF
C
      RETURN
 408  WRITE(6,4008) NB,ISYM,LAMCU,LAMI,LAMJ
 4008 FORMAT(/' INCONSISTENT VALUE OF NBLC',I3,' FOR SYMMETRY',I3,
     &  5X,3I5)
      STOP
C
 6001 FORMAT(//' ### ENTER SUBROUTINE SORT'/)
 6002 FORMAT(/' NUMBER OF BLOCKS ASKED=',I3
     &       /' NUMBER OF BLOCKS FOUND=',I3)
 6003 FORMAT(/' NUMBER OF FULL MATRICES READ IN=',I3)
C
 5001 FORMAT(/' Units for target data input,    LUCHAN =',8I3)
 5013 format( ' Unit for T-matrix input,        LUTMT  =',I3,
     &      //' Debug flag, IBUG=',I3)
 5011 FORMAT(/' Number of scattering energies, NE   =',I3)
 5002 FORMAT(/' Scattering energies (au)',10(/10F11.4))
 5012 FORMAT(//' Number of scattering symmetries in sum,   NSYM =',I3)
 5003 FORMAT(/' NBLC',2X,15I6)
 5004 FORMAT(/' Number of T-matrix sub-blocks required =',I4)
 5005 FORMAT(/' Target is ',A)
 5006 FORMAT(/' Current scattering symmetries,',
     &        ' SCU=',F4.1,' LAMCU=',I2,' IGUCU=',I2,
     &       /' Current scattering energy, ECU   =',F11.4,' (au)',
     &       /' Max dimension of T-matrix subset =',I3,
     &       /' Number of transitions considered =',I3)
 5007 FORMAT(/' SICU    LAMICU  IGUICU   EICU      ',
     &        ' SJCU    LAMJCU  IGUJCU   EJCU      NBLCU',
     &       100(/1X,F4.1,6X,I1,6X,I2,3X,F11.4,4X,
     &               F4.1,6X,I1,6X,I2,3X,F11.4,2X,I1))
 5008 FORMAT(/' ISYM=',I2,' IE=',I2,' IB=',I2)
 5009 FORMAT(/' KEYDBL=',2I2)
C
 4002 FORMAT(/' STOP: NTRSCU=',I3,'WHILE NTMX=',I3,' INCREASE NTMX')
 4003 FORMAT(/' STOP: INCONSISTENCY BETWEEN NDIM AND IGAP,JGAP,NLI,NLJ',
     &        ' FOR BLOCK',I2,' OF TRANSITION',I2)
 4004 FORMAT(/' STOP: NO T MATRIX BLOCK AVAILABLE FOR THE CURRENT',
     &        ' TRANSITION')
 4005 FORMAT(/' FAILED TEST 3 ',4I5/4(5X,2I5))
 4006 FORMAT(/' FAILED TEST 2 ',I5/4(5X,2I5)/4(5X,2F10.6))
 4007 FORMAT(/' FAILED TEST 1 ',I5/2(5X,2I5),5X,2F10.6)
C
      END
      SUBROUTINE GETDIM(nsym,TFORM,NTSET,LUTMT,maxtg,maxch,maxmi,maxmf,
     1 IPRNT,IFAIL)
C
C     GETDIM reads T-matrix headers to determine maximum dimensions
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXESC=10,maxmax=1000)
      DIMENSION NTSET(nsym),NEREP(MAXESC+1),EINC(2*MAXESC),ICHL(maxmax),
     2 LCHL(maxmax),MCHL(maxmax),ECHL(maxmax)
      INTEGER GUTOT,STOT
      CHARACTER(LEN=11) TFORM
      CHARACTER(LEN=80) TITLE
      DATA ZERO/0.D0/,IWRITE/6/
C
 501  FORMAT(/' INVALID VALUE OF NTSET ',I4,' FOR REQUEST NUMBER',I4)
 503  FORMAT(/' Maximum dimensions required: NCHAN=',I3,3x,'MAXCHI=',i3,
     13x,'MAXCHF=',i3,3x,'MAXTGT=',i3)
C
      maxtg = 0
      maxch = 0
      maxmi = 0
      maxmf = 0
      do 1 isym=1,nsym
      IF(NTSET(isym).GT.0) THEN
        CALL READTH(LUTMT,TITLE,NTSET(isym),NCHAN,NVIB,NDIS,NTARG,
     1  MAXCHI,MAXCHF,MGVN,STOT,GUTOT,NETOT,MAXNE,NEREP,EINC,ICHL,
     2  LCHL,MCHL,ECHL,TFORM,IWRITE,IPRNT-1,IFAIL)
        IF(IFAIL.NE.0) RETURN
        maxtg = max(maxtg,ntarg,nvib)
        maxch = max(maxch,nchan)
        maxmi = max(maxmi,maxchi)
        maxmf = max(maxmf,maxchf)
      ELSE
        WRITE(IWRITE,501) NTSET(isym),isym
        IFAIL = 1
        RETURN
      ENDIF
 1    continue
      write(iwrite,503) maxch,maxmi,maxmf,maxtg
c
      RETURN
      END
      SUBROUTINE DCS(KMAX,IBUG,NTAU,NLMX,TMTR,TMTI,A,B,ESCT)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NSYMX=20,NSMX=3)
      COMMON/BLCK1/SI,EI,SJ,EJ,SSCT(NSYMX),NSYM,NE,
     &   LAMI,IGUI,LAMJ,IGUJ,LAMSCT(NSYMX),IGUSCT(NSYMX),NBLC(NSYMX),
     &   ISGN(4,NSYMX),JSGN(4,NSYMX),NLI(4,NSYMX),NLJ(4,NSYMX)
      COMMON/BLCK2/KEYGU,LISTT(4,NSYMX),
     &   LJSTT(4,NSYMX),INDBLC(4,NSYMX),KEYDBL(2)
      DIMENSION A(2*NLMX,*),B(2*NLMX,*),ESCT(*)
      DIMENSION TMTR(NLMX*NLMX,ne),
     & TMTI(NLMX*NLMX,ne),ANG3J(NLMX,NLMX),L2STT(NLMX),L2EDD(NLMX)
      double precision, allocatable :: taure(:,:),tauim(:,:)
C
C#######################################################################
C#    COMPUTES THE SINGLE SET (OR THE TWO SETS) OF MULTIPOLAR EXPANSION#
C#    COEFFICIENTS CORRESPONDING TO THE CURRENT TRANSITION, FOR ALL    #
C#    SCATTERING ENERGIES                                              #
C#######################################################################
c
      WRITE(6,6000)
c
      allocate (taure(ntau,ne),tauim(ntau,ne))
C
C *** CHECK THE DATA PASSED THROUGH COMMON/BLCK1/ AND /BLCK2/ AND LIST
      IF (IBUG.GT.0) THEN
         WRITE(6,5001) KMAX,IBUG,SI,LAMI,IGUI,EI,SJ,LAMJ,IGUJ,EJ,
     &                 NE,NSYM
         WRITE(6,5002) (ESCT(I),I=1,NE)
         WRITE(6,5003) (SSCT(I),LAMSCT(I),IGUSCT(I),NBLC(I),I=1,NSYM)
         CALL MI4PRT(NLI,1,1,4,4,1,1,NSYM,'NLI     ')
         CALL MI4PRT(NLJ,1,1,4,4,1,1,NSYM,'NLJ     ')
         CALL MI4PRT(ISGN,1,1,4,4,1,1,NSYM,'ISGN    ')
         CALL MI4PRT(JSGN,1,1,4,4,1,1,NSYM,'JSGN    ')
         WRITE(6,5004) KEYGU,KEYDBL
         CALL MI4PRT(LISTT,1,1,4,4,1,1,NSYM,'LISTT   ')
         CALL MI4PRT(LJSTT,1,1,4,4,1,1,NSYM,'LJSTT   ')
         CALL MI4PRT(INDBLC,1,1,4,4,1,1,NSYM,'INDBLC  ')
         DO 3 ISYM=1,NSYM
            DO 2 IE =1,NE
               DO 1 IB=1,NBLC(ISYM)
                  WRITE(6,5005) ISYM,IE,IB
                  INDICE=(ISYM-1)*NE*4+(IE-1)*4+IB
                  NLIC=NLI(IB,ISYM)
                  NLJC=NLJ(IB,ISYM)
                  LISTTC=LISTT(IB,ISYM)
                  LJSTTC=LJSTT(IB,ISYM)
                  CALL MR8PRT (TMTR(1,INDICE),
     &            LISTTC,KEYGU,NLIC,NLMX,LJSTTC,KEYGU,NLJC,'TMTR    ')
                  CALL MR8PRT (TMTI(1,INDICE),
     &            LISTTC,KEYGU,NLIC,NLMX,LJSTTC,KEYGU,NLJC,'TMTI    ')
    1          CONTINUE
    2       CONTINUE
    3    CONTINUE
      ENDIF
C
C *** SHORT NOTATIONS FOR THE COMPOSED DIMENSIONS OF SOME ARRAYS
      NLMXT=2*NLMX
      INDMAX = NTAU
C
C *** INDEX TO CHARACTERIZE THE PARITY OF THE SPIN MULTIPLICITIES
C     OF THE N+1 ELECTRON SYSTEM
      MULT=2*SSCT(1)+1
      KSPIN=MOD(MULT,2)
C
C *** START OF LOOP ON THE TWO POSSIBLE DISTINCT COMPONENTS OF THE
C     TRANSITION STUDIED
      ITRANS=1
   10 IPOINT=KEYDBL(ITRANS)
C ----------------------------------------------------------------------
C     TAU MATRIX (EQUATION 11) AND EXTREMA OF LI,LJ,JT,IS
C ----------------------------------------------------------------------
      CALL MR8INI(TAURE,INDMAX,NE,INDMAX,0)
      CALL MR8INI(TAUIM,INDMAX,NE,INDMAX,0)
      LIMIN=101
      LIMAX=1
      LJMIN=101
      LJMAX=1
      JTMIN=101
      JTMAX=1
      ISMIN=101
      ISMAX=1
C
C +++ LOOP ON THE SCATTERING SYMMETRIES
      DO 55 ISYM=1,NSYM
         LAM=LAMSCT(ISYM)
         FLAM=LAM
         aflam = abs(flam)
         IGU=IGUSCT(ISYM)
         S=SSCT(ISYM)
         IS =S+0.5+0.5*KSPIN
         ISMAX=MAX0(ISMAX,IS)
         ISMIN=MIN0(ISMIN,IS)
         INDX2A=(ISYM-1)*NE*4
         IF(IBUG.GT.0) WRITE(6,5006) ISYM,S,LAM,IGU
C
         IBLC=INDBLC(IPOINT,ISYM)
         FLAMI=LAMI*ISGN(IBLC,ISYM)
         FLAMJ=LAMJ*JSGN(IBLC,ISYM)
         IF(IBUG.GT.0)WRITE(6,5007) FLAMI,FLAMJ
C
   20    INDX2B=INDX2A+IBLC
         LIST=LISTT(IBLC,ISYM)
         LIED=LIST+(NLI(IBLC,ISYM)-1)*KEYGU
         LJST=LJSTT(IBLC,ISYM)
         LJED=LJST+(NLJ(IBLC,ISYM)-1)*KEYGU
         IF(IBUG.GT.0)WRITE(6,5008) LIST,LIED,LJST,LJED
         LIMIN=MIN0(LIMIN,LIST)
         LIMAX=MAX0(LIMAX,LIED)
         LJMIN=MIN0(LJMIN,LJST)
         LJMAX=MAX0(LJMAX,LJED)
C
C +++ LOOPS ON LI, LJ, JT
      DO 54 LI=LIST,LIED,KEYGU
         FLI=LI-1
         IIS=(LI-1)*NLMXT*NSMX+IS
      DO 53 LJ=LJST,LJED,KEYGU
         FLJ=LJ-1
         IIJS=(LJ-1)*NLMX*NLMXT*NSMX+IIS
         INDEX1=(LJ-1)*NLMX+LI
         JTST=DABS(FLAMJ-FLAMI)+1.D0
         JTST=MAX0(JTST,IABS(LJ-LI)+1)
         JTED=LJ+LI-1
         IF(JTST.GT.JTED) GO TO 53
         JTMIN=MIN0(JTMIN,JTST)
         JTMAX=MAX0(JTMAX,JTED)
      DO 52 JT=JTST,JTED
         FJT=JT-1
         INDICE=IIJS+(JT-1)*NSMX
         ANG=(-1)**LAM*
     &       F3J(FLI,FLJ,FJT,FLAMI-FLAM,+FLAM-FLAMJ,FLAMJ-FLAMI)
         IF (IBUG.GE.10) WRITE(6,5009) LI,LJ,JT,ANG
C
C +++ LOOP ON THE SCATTERING ENERGIES
      DO 51 IE=1,NE
         INDEX2=INDX2B+(IE-1)*4
         TAURE(INDICE,IE)=TAURE(INDICE,IE)
     &                   +ANG*TMTR(INDEX1,INDEX2)
         TAUIM(INDICE,IE)=TAUIM(INDICE,IE)
     &                   +ANG*TMTI(INDEX1,INDEX2)
   51 CONTINUE
   52 CONTINUE
   53 CONTINUE
   54 CONTINUE
C
C +++ INCLUDE THE -LAMSCT CONTRIBUTION, IF ANY
      IBLC=INDBLC(IPOINT+1,ISYM)
      IF(aFLAM.GT.0.D0.AND.IBLC.NE.0) THEN
         aflam=-aflam
         FLAM=-FLAM
         GO TO 20
      ENDIF
C
   55 CONTINUE
C
      IF (IBUG.GT.0) THEN
         DO 70 IE=1,NE
         DO 65 INDICE=1,INDMAX
            IF(DABS(TAURE(INDICE,IE)).NE.0.D0.OR.
     &         DABS(TAUIM(INDICE,IE)).NE.0.D0) THEN
               LJ=INDICE/(NLMX*NLMXT*NSMX)+1
               LI=(INDICE-(LJ-1)*NLMX*NLMXT*NSMX)/(NLMXT*NSMX)+1
               JT=(INDICE-(LJ-1)*NLMX*NLMXT*NSMX-(LI-1)*NLMXT*NSMX)/
     &            NSMX+1
               IS=(INDICE-(LJ-1)*NLMX*NLMXT*NSMX-(LI-1)*NLMXT*NSMX-
     &            (JT-1)*NSMX)
               WRITE(6,5010) IE,INDICE,LI,LJ,JT,IS,
     &         TAURE(INDICE,IE),TAUIM(INDICE,IE)
            ENDIF
   65    CONTINUE
   70    CONTINUE
      ENDIF
      WRITE(6,6001)
      WRITE(6,6002) LIMIN-1,LIMAX-1,LJMIN-1,LJMAX-1,JTMIN-1,JTMAX-1,
     & ISMIN,ISMAX
C ---------------------------------------------------------------------
C     MULTIPOLAR-COEFFICIENTS (EQUATION 12)
C ---------------------------------------------------------------------
C
C +++ DETERMINE THE ALLOWED VALUES OF K
      KMAXX=1
      KINCR=2
      DO 90 JT=JTMIN,JTMAX
         INDA=(JT-1)*NSMX
      DO 901 IS=ISMIN,ISMAX
         INDB=INDA+IS
         ICOUNT=0
         KIMAX=1
         KJMAX=1
         DO 89 LI=LIMIN,LIMAX
            INDC=INDB+(LI-1)*NLMXT*NSMX
         DO 891 LJ=LJMIN,LJMAX
            INDICE=INDC+(LJ-1)*NLMX*NLMXT*NSMX
            IF(TAURE(INDICE,1).NE.0.D0.OR.
     &         TAUIM(INDICE,1).NE.0.D0) THEN
               ICOUNT=ICOUNT+1
               IF(ICOUNT.EQ.1) THEN
                  MODI=MOD(LI,2)
                  MODJ=MOD(LJ,2)
               ELSE
                  MODIC=MOD(LI,2)
                  MODJC=MOD(LJ,2)
                  IF(MODIC.NE.MODI.AND.MODJC.NE.MODJ) KINCR=1
               ENDIF
               KIMAX=MAX0(KIMAX,2*LI-1)
               KJMAX=MAX0(KJMAX,2*LJ-1)
            ENDIF
  891    continue
   89    CONTINUE
         KJTIS=MIN(KIMAX,KJMAX)
         KMAXX=MAX(KMAXX,KJTIS)
  901 continue    
   90 CONTINUE
      WRITE(6,6003) KMAXX
      IF(KINCR.EQ.2) WRITE(6,6004)
      IF(KINCR.EQ.1) WRITE(6,6005)
      KMAXX=MIN0(KMAX,KMAXX)
C
      CALL MR8INI(A,KMAX,NE,NLMXT,0)
      LMIN=MIN0(LIMIN,LJMIN)
      LMAX=MAX0(LIMAX,LJMAX)
      IF(LMAX.GT.NLMX) THEN
        WRITE(6,6999) NLMX,LMAX
        STOP
      ENDIF
      FAC0=1.D0/(16.D0*(2.D0*SI+1.D0))
C
C +++ LOOP ON THE MULTIPOLAR TERMS
      DO 109 K=1,KMAXX,KINCR
         IF(IBUG.GT.0) WRITE(6,5011) K
         FK=K-1
         FAC1=FAC0*(-1)**(K-1)*(2.D0*FK+1.D0)
         CALL MR8INI(ANG3J,LMAX,LMAX,NLMX,0)
C
C +++ LOOP ON L1,L2 TO COMPUTE AND STORE THE 3J COEFFICIENTS NEEDED AND
C     THE CORRESPONDING SELECTION RULES
      DO 101 L1=LMIN,LMAX
         L2ST=MAX0(LMIN,IABS(L1-K)+1)
         L2ED=MIN0(LMAX,L1+K-1)
         IF (MOD(L2ST+L1+K+1,2).NE.0) L2ST=L2ST+1
         IF (MOD(L2ED+L1+K+1,2).NE.0) L2ED=L2ED-1
         L2STT(L1)=L2ST
         L2EDD(L1)=L2ED
         IF (L2ST.GT.L2ED) GO TO 101
         FL1=L1-1
      DO 100 L2=L2ST,L2ED,2
         FL2=L2-1
         FAC=DSQRT((2.D0*FL1+1.D0)*(2.D0*FL2+1.D0))
         X3J=F3J(FL1,FL2,FK,0.D0,0.D0,0.D0)
         ANG3J(L1,L2)=FAC*X3J
  100 CONTINUE
  101 CONTINUE
      IF(IBUG.GT.0) THEN
         CALL MR8PRT(ANG3J,1,1,LMAX,NLMX,1,1,LMAX,'ANG3J   ')
         CALL MI4PRT(L2STT,1,1,1,1,1,1,LMAX,'L2STT   ')
         CALL MI4PRT(L2EDD,1,1,1,1,1,1,LMAX,'L2EDD   ')
      ENDIF
C +++ END OF LOOP
C
C +++ LOOPS ON LI1,LI2,LJ1,LJ2,JT
      IF(IBUG.GE.10) WRITE(6,5012)
      DO 108 LI1=LIMIN,LIMAX
         LI2ST=L2STT(LI1)
         LI2ED=L2EDD(LI1)
         IF(LI2ST.GT.LI2ED) GO TO 108
         FLI1=LI1-1
         I1I=(LI1-1)*NLMXT*NSMX
      DO 107 LI2=LI2ST,LI2ED,2
         FLI2=LI2-1
         I2I=(LI2-1)*NLMXT*NSMX
      DO 106 LJ1=LJMIN,LJMAX
         LJ2ST=L2STT(LJ1)
         LJ2ED=L2EDD(LJ1)
         IF(LJ2ST.GT.LJ2ED) GO TO 106
         FLJ1=LJ1-1
         I1IJ=(LJ1-1)*NLMX*NLMXT*NSMX+I1I
      DO 105 LJ2=LJ2ST,LJ2ED,2
         JTST=MAX(ABS(LI2-LJ2)+1,ABS(LJ1-LI1)+1)
         JTST=MAX(JTST,JTMIN)
         JTED=MIN(LI2+LJ2-1,LJ1+LI1-1)
         JTED=MIN(JTED,JTMAX)
         IF (JTST.GT.JTED) GO TO 105
         FLJ2=LJ2-1
         I2IJ=(LJ2-1)*NLMX*NLMXT*NSMX+I2I
         FAC2=FAC1*(-1)**((LI1-LJ1-LI2+LJ2)/2)*ANG3J(LI1,LI2)
     &                                        *ANG3J(LJ1,LJ2)
      DO 104 JT=JTST,JTED
         FJT=JT-1
         X6J=F6J(FLI2,FLI1,FK,FLJ1,FLJ2,FJT)
         ANGJT=(-1)**(JT-1)*X6J*(2.D0*FJT+1.D0)
         FAC3=FAC2*ANGJT
         I1IJT=(JT-1)*NSMX+I1IJ
         I2IJT=(JT-1)*NSMX+I2IJ
C
C +++ LOOP ON THE SPIN SCATTERING SYMMETRY
      DO 103 IS=ISMIN,ISMAX
         S=IS-0.5-0.5*KSPIN
         FAC4=FAC3*(2.D0*S+1.D0)
         INDIC1=I1IJT+IS
         INDIC2=I2IJT+IS
C
C +++ LOOP ON THE SCATTERING ENERGY
      DO 102 IE=1,NE
         SCATT=TAURE(INDIC1,IE)*TAURE(INDIC2,IE)+
     &         TAUIM(INDIC1,IE)*TAUIM(INDIC2,IE)
         FAC5=FAC4*SCATT/(ESCT(IE)-EI)
         IF(IBUG.GE.10.AND.FAC5.NE.0.D0)
     &   WRITE(6,5013)IE,INDIC1,LI1,LJ1,INDIC2,LI2,LJ2,JT,IS,
     &                FAC0,FAC1,FAC2,FAC3,FAC4,FAC5
         A(K,IE)=A(K,IE)+FAC5
C
  102 CONTINUE
  103 CONTINUE
  104 CONTINUE
  105 CONTINUE
  106 CONTINUE
  107 CONTINUE
  108 CONTINUE
  109 CONTINUE
C
C
      WRITE(6,6006)
      CALL MR8PRT(A,1,1,KMAXX,NLMXT,1,1,NE,'A       ')
      IF(ITRANS.EQ.1) THEN
         CALL MTBLCK(A,NLMXT,B,NLMXT,0,KMAX,0,NE)
         CALL MR8INI(A,KMAX,NE,NLMXT,0)
         IF(KEYDBL(2).NE.0) THEN
            ITRANS=ITRANS+1
            GO TO 10
         ENDIF
      ENDIF
      deallocate (taure,tauim)
C
      RETURN
C
 6000 FORMAT(//' ### ENTER SUBROUTINE DCS'/)
 6001 FORMAT(/'--- TAU MATRIX AND LIMITING VALUES OF THE ANGULAR',
     &         ' MOMENTA CALCULATED---')
 6002 FORMAT(/' LIMIN=',I3,' LIMAX=',I3,' LJMIN=',I3,' LJMAX=',I3,
     &        ' JTMIN=',I3,' JTMAX=',I3,' ISMIN=',I3,' ISMAX=',I3)
 6003 FORMAT(/' ORDER + 1 OF THE HIGHEST MULTIPOLE CONTRIBUTING TO THE',
     &        ' DCS =',I3)
 6004 FORMAT(/' THE DCS IS SYMMETRICAL WITH RESPECT TO 90 DEGREES')
 6005 FORMAT(/' THE DCS IS NOT SYMMETRICAL WITH RESPECT TO 90 DEGREES')
 6006 FORMAT(/'--- MULTIPOLAR COEFFICIENTS CALCULATED---')
 6999 FORMAT(/' FIXED DIMENSION NLMX=',I2,'  EXCEEDED BY LMAX=',I2)
C
 5001 FORMAT(/' KMAX=',I3,' IBUG=',I2/
     &        ' SI=',D8.2,' LAMI=',I2,' IGUI=',I2,' EI=',F11.4/
     &        ' SJ=',D8.2,' LAMJ=',I2,' IGUJ=',I2,' EJ=',F11.4/
     &        ' NE=',I3,' NSYM=',I3)
 5002 FORMAT(/' ESCT',10(/10F11.4))
 5003 FORMAT(/'  SSCT    LAMSCT  IGUSCT  NBLC',
     &      100(/2X,F4.1,6X,I1,6X,I2,6X,I1))
 5004 FORMAT(/' KEYGU=',I2,' KEYDBL=',2I2)
 5005 FORMAT(/' ISYM=',I3,' IE=',I3,' IB=',I2)
 5006 FORMAT(/' SYMMETRY NUMBER',I3,' S=',D8.2,' LAM=',I3,' IGU=',I3)
 5007 FORMAT(/' FLAMI=',D8.2,' FLAMJ=',D8.2)
 5008 FORMAT(/' LIST=',I3,' LIED=',I3,' LJST=',I3,' LJED=',I3)
 5009 FORMAT(/' LI=',I3,' LJ=',I3,' JT=',I3,' ANG=',F11.4)
 5010 FORMAT(/' IE=',I2,' INDICE=',I5,' LI=',I3,' LJ=',I3,' JT=',I3,
     &        ' IS=',I3,' TAURE=',D12.5,' TAUIM=',D12.5)
 5011 FORMAT(/' MULTIPOLAR TERM NUMBER',I3)
 5012 FORMAT(/' IE INDIC1 LI1 LJ1 INDIC2 LI2 LJ2  JT  IS',
     &        ' FAC0       FAC1       FAC2       FAC3       FAC4      ',
     &        ' FAC5')
 5013 FORMAT(/1X,I2,2X,I5,2X,I2,2X,I2,2X,I5,2X,I2,2X,I2,2X,I2,2X,I2,1X,
     &        D10.3,1X,D10.3,1X,D10.3,1X,D10.3,1X,D10.3,1X,D10.3)
C
      END
      SUBROUTINE FACLOG
C#######################################################################
C#    INITIALIZES AN ARRAY CONTAINING  LOGARITHMS OF FACTORIALS        #
C#######################################################################
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NFMX=250)
      COMMON /LOGFAC/ FCT(NFMX)
      DATA NTIMES /1/
C
      IF (NTIMES .GT. 1) RETURN
      NTIMES = NTIMES+1
      FCT(1) = 0.D0
      DO 10 I = 1,NFMX-1
         AI = I
         FCT(I+1) = FCT(I)+DLOG(AI)
 10   CONTINUE
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION FDELTA (FL1,FL2,FL3)
C#######################################################################
C#    RETURNS THE SQUARE ROOT OF THE COEFFICIENT :                     #
C#    (L1+L2-L3)|*(L2+L3-L1)|*(L3+L1-L2)|*( (L1+L2+L3+1)| )**(-1)      #
C#    WHICH IS USED IN RACAH FORMULA FOR THE 3J AND 6J COEFFICIENTS    #
C#######################################################################
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NFMX=250)
      COMMON /LOGFAC/ FCT(NFMX)
      DATA   EPS /.01d0/
C
      IA=FL1+FL2+FL3 +EPS
      A=2.d0*(FL1+FL2+FL3)+1.d0
      IB=A +EPS
      IB=IB/2
      IF(IB.ne.IA) go to 1
      IK1=FL1+FL2-FL3+EPS
      IK2=FL2+FL3-FL1+EPS
      IK3=FL3+FL1-FL2+EPS
      KK=FL1+FL2+FL3+1+EPS
      IF(IK1.lt.0.or.ik2.lt.0.or.ik3.lt.0) go to 1
      D1=FCT(KK+1)
      D2=FCT(IK1+1)+FCT(IK2+1)+FCT(IK3+1)
      D3 = (D2 - D1) / 2.D0
      FDELTA = DEXP (D3)
      GO TO 5
    1 FDELTA=0.d0
    5 RETURN
C
      END
      SUBROUTINE FINDL(ISGN,JSGN,NBLC,IBLC1,IBLC2)
C#######################################################################
C#    FINDS THE -LAMSCT COMPLEMENT OF A GIVEN +LAMSCT T MATRIX BLOCK   #
C#######################################################################
      DIMENSION ISGN(*),JSGN(*)
      DO 10 IBLC2=1,NBLC
         IF(ISGN(IBLC2).EQ.-ISGN(IBLC1).AND.
     &      JSGN(IBLC2).EQ.-JSGN(IBLC1)) GO TO 11
   10 CONTINUE
      IBLC2=0
   11 RETURN
      END
      SUBROUTINE FINDT(ISGN,JSGN,NBLC,IKEY,IBLC)
C#######################################################################
C#    FINDS THE T MATRIX BLOCK CORRESPONDING TO A TRANSITION BETWEEN   #
C#    STATES HAVING THE SAME (IKEY=1) OR OPPOSITE (IKEY=-1) SIGNS OF   #
C#    LAMI AND LAMJ                                                    #
C#######################################################################
      DIMENSION ISGN(*),JSGN(*)
      DO 10 IBLC=1,NBLC
         IF(ISGN(IBLC).EQ.IKEY*JSGN(IBLC)) GO TO 11
   10 CONTINUE
      IBLC=0
   11 RETURN
      END
C
C
C
      DOUBLE PRECISION FUNCTION F3J (FJ1,FJ2,FJ3, FM1,FM2,FM3)
C#######################################################################
C#    CALCULATES 3J COEFFICIENTS FROM RACAH FORMULA                    #
C#######################################################################
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER T,TMIN,TMAX
      PARAMETER (NFMX=250)
      COMMON /LOGFAC/ FCT(NFMX)
      DATA TINY,ZERO,ONE /0.01D0,0.D0,1.D0/ ,NTIMES /1/
      save ntimes
C
      IF (NTIMES .EQ. 1) CALL FACLOG
      NTIMES = NTIMES+1
      CC = ZERO
      IF (FJ3 . GT. (FJ1+FJ2+TINY))      GO TO 100
      IF (ABS(FJ1-FJ2) .GT. (FJ3+TINY)) GO TO 100
      IF (ABS(FM1+FM2+FM3) .GT. TINY)   GO TO 100
      IF (ABS(FM1) .GT. (FJ1+TINY))     GO TO 100
      IF (ABS(FM2) .GT. (FJ2+TINY))     GO TO 100
      IF (ABS(FM3) .GT. (FJ3+TINY))     GO TO 100
      J1=FJ1
      J2=FJ2
      J3=FJ3
      IF (ABS(FM1)+ABS(FM2)+ABS(FM3).EQ.0.D0.AND.
     &    MOD(J1+J2+J3,2).NE.0) GO TO 100
      FK1 = FJ3-FJ2+FM1
      FK2 = FJ3-FJ1-FM2
      FK3 = FJ1-FM1
      FK4 = FJ2+FM2
      FK5 = FJ1+FJ2-FJ3
      FK1M = FK1-TINY
      FK2M = FK2-TINY
      FK1P = FK1+TINY
      FK2P = FK2+TINY
      IF (FK1M .LT. ZERO) K1 = FK1M
      IF (FK1P .GT. ZERO) K1 = FK1P
      IF (FK2M .LT. ZERO) K2 = FK2M
      IF (FK2P .GT. ZERO) K2 = FK2P
      K3 = FK3+TINY
      K4 = FK4+TINY
      K5 = FK5+TINY
      TMIN = 0
      IF (K1+TMIN .LT. 0) TMIN = -K1
      IF (K2+TMIN .LT. 0) TMIN = -K2
      TMAX = K3
      IF (K4-TMAX .LT. 0) TMAX = K4
      IF (K5-TMAX .LT. 0) TMAX = K5
      N1 = FJ1+FJ2-FJ3+ONE+TINY
      N2 = FJ2+FJ3-FJ1+ONE+TINY
      N3 = FJ3+FJ1-FJ2+ONE+TINY
      N4 = FJ1+FM1+ONE+TINY
      N5 = FJ2+FM2+ONE+TINY
      N6 = FJ3+FM3+ONE+TINY
      N7 = FJ1-FM1+ONE+TINY
      N8 = FJ2-FM2+ONE+TINY
      N9 = FJ3-FM3+ONE+TINY
      N10 = FJ1+FJ2+FJ3+2.D0+TINY
      X = FCT(N1)+FCT(N2)+FCT(N3)+FCT(N4)+FCT(N5)+FCT(N6)
     &   +FCT(N7)+FCT(N8)+FCT(N9)-FCT(N10)
      X = 0.5D0*X
      DO 10  T = TMIN,TMAX
         PHASE = ONE
         IF (MOD(T,2) .NE. 0) PHASE = -ONE
         CC = CC+PHASE*EXP(-FCT(T+1)   -FCT(K1+T+1)-FCT(K2+T+1)
     &                      -FCT(K3-T+1)-FCT(K4-T+1)-FCT(K5-T+1)+X)
 10   CONTINUE
      FSP = ABS(FJ1-FJ2-FM3)+TINY
      NS = FSP
      IF (MOD(NS,2) .GT. 0) CC = -CC
 100  F3J = CC
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION F6J (FJ1,FJ2,FJ3,FL1,FL2,FL3)
C#######################################################################
C#    CALCULATES 6J-COEFFICIENTS FROM RACAH FORMULA                    #
C#######################################################################
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NFMX=250)
      COMMON /LOGFAC/ FCT(NFMX)
      DATA NTIMES /1/
      save ntimes
C
      IF (NTIMES .EQ. 1) CALL FACLOG
      NTIMES = NTIMES+1
      D = FDELTA (FJ1,FJ2,FJ3)
      D = D*FDELTA (FJ1,FL2,FL3)
      D = D*FDELTA (FL1,FJ2,FL3)
      D = D*FDELTA (FL1,FL2,FJ3)
      F6J = 0.D0
      IF (ABS(D) .EQ. 0.D0) RETURN
C
      FK1 = FJ1+FJ2+FJ3
      FK2 = FJ1+FL2+FL3
      FK3 = FL1+FJ2+FL3
      FK4 = FL1+FL2+FJ3
      FK5 = FJ1+FJ2+FL1+FL2
      FK6 = FJ2+FJ3+FL2+FL3
      FK7 = FJ3+FJ1+FL3+FL1
      FMIN = MIN(FK5,FK6,FK7)
      FMAX = MAX(FK1,FK2,FK3,FK4)
      iMIN = nint(FMIN)
      iMAX = nint(FMAX)
      K1 = nint(FK1)
      K2 = nint(FK2)
      K3 = nint(FK3)
      K4 = nint(FK4)
      K5 = nint(FK5)
      K6 = nint(FK6)
      K7 = nint(FK7)
      IF (iMIN.lt.iMAX.or.imax.lt.0.or.imin.lt.0) go to 1000
      IF (iMIN.gt.0) go to 90
      K1 = -K1
      K2 = -K2
      K3 = -K3
      K4 = -K4
      BOT = FCT(K1+1)+FCT(K2+1)+FCT(K3+1)+FCT(K4+1)+FCT(K5+1)+FCT(K6+1)
     &     +FCT(K7+1)
      BOT = EXP(BOT)
      F6J = D/BOT
      RETURN
C
 90   F6J = 0.d0
      DO 100 I = iMAX,iMIN
         BOITE = ((-1.d0)**I)
         IZ = I+1
         M1 = I-K1
         M2 = I-K2
         M3 = I-K3
         M4 = I-K4
         M5 = K5-I
         M6 = K6-I
         M7 = K7-I
         DOT = FCT(IZ+1)
         BOT = FCT(M1+1)+FCT(M2+1)+FCT(M3+1)+FCT(M4+1)+FCT(M5+1)
     &        +FCT(M6+1)+FCT(M7+1)
         B1 = DOT-BOT
         BOITE = BOITE*EXP(B1)
         F6J = F6J+BOITE
 100  CONTINUE
      F6J = F6J*D
 1000 RETURN
C
      END
      SUBROUTINE LSTART(LAM,LAMT,ISGNT,IGU,IGUT,LST)
C#######################################################################
C     COMPUTES THE LOWEST POSSIBLE VALUE + 1 OF THE ORBITAL ANGULAR    #
C     MOMENTUM FOR AN ELECTRON COUPLED WITH A GIVEN TARGET STATE TO A  #
C     GIVEN OVERALL SYMETRY                                            #
C#######################################################################
      LAME=LAM-ISGNT*LAMT
      IGUE=IGU*IGUT
      LST=IABS(LAME)+1
      IF((IGUE.EQ.+1.AND.MOD(LST,2).EQ.0).OR.
     &   (IGUE.EQ.-1.AND.MOD(LST,2).NE.0)) LST=LST+1
      RETURN
      END
      SUBROUTINE MI4PRT(A,IST,INC,NI,NIMX,JST,JNC,NJ,NAME)
C#######################################################################
C#    PRINTS A 2-DIM MATRIX OF INTEGERS INTO I6 FORMAT                 #
C#######################################################################
      CHARACTER(LEN=8) NAME
      INTEGER A(NIMX,*),ALGN(20)
C
      NJLEFT=NJ
   10 NJC=MIN(NJLEFT,20)
      DO 30 I=1,NI
         II=IST+(I-1)*INC
         DO 20 J=1,NJC
            JJ=JST+(J+NJ-NJLEFT-1)*JNC
            ALGN(J)=A(II,JJ)
   20    CONTINUE
         IF(I.EQ.1) THEN
            WRITE(6,9001) NAME,I,(ALGN(J),J=1,NJC)
         ELSE
            WRITE(6,9002) I,(ALGN(J),J=1,NJC)
         ENDIF
   30 CONTINUE
      NJLEFT=NJLEFT-NJC
      IF(NJLEFT.GT.0) GO TO 10
C
      RETURN
 9001 FORMAT(1X,A8,I3,20I6)
 9002 FORMAT(9X,I3,20I6)
      END
      SUBROUTINE MR8INI (A8,II,JJ,NA,IKEY)
C#######################################################################
C#    INITIALIZES THE OFF DIAGONAL ELEMENTS OF A DOUBLE PRECISION REAL #
C     MATRIX TO ZERO, AND ITS DIAGONAL ELEMENTS TO DFLOAT(IKEY)        #
C#######################################################################
      DOUBLE PRECISION A8,DFACT
      DIMENSION A8(NA,*)
C
      DFACT   = dble(IKEY)
      DO 30 J = 1,JJ
         DO 20 I = 1,II
            A8(I,J) = 0.D0
 20      CONTINUE
         IF (J.GT.II) GO TO 30
         A8(J,J) = DFACT
 30   CONTINUE
      RETURN
      END
      SUBROUTINE MR8PRT(A,IST,INC,NI,NIMX,JST,JNC,NJ,NAME)
C#######################################################################
C#    PRINTS A 2-DIM MATRIX OF DOUBLE PRECISION REALS INTO D12.5 FORMAT#
C#######################################################################
      CHARACTER(LEN=8) NAME
      DOUBLE PRECISION A(NIMX,*),ALGN(10)
C
      NJLEFT=NJ
   10 NJC=MIN0(NJLEFT,10)
      DO 30 I=1,NI
         II=IST+(I-1)*INC
         DO 20 J=1,NJC
            JJ=JST+(J+NJ-NJLEFT-1)*JNC
            ALGN(J)=A(II,JJ)
   20    CONTINUE
         IF(I.EQ.1) THEN
            WRITE(6,9001) NAME,I,(ALGN(J),J=1,NJC)
         ELSE
            WRITE(6,9002) I,(ALGN(J),J=1,NJC)
         ENDIF
   30 CONTINUE
      NJLEFT=NJLEFT-NJC
      IF(NJLEFT.GT.0) GO TO 10
C
      RETURN
 9001 FORMAT(1X,A8,I3,10D12.5)
 9002 FORMAT(9X,I3,10D12.5)
      END
      SUBROUTINE MTBLCK(AIN,NAMX,BOUT,NBMX,IGAP,NLI,JGAP,NLJ)
C#######################################################################
C#    STORES A BLOCK OF THE INPUT MATRIX INTO AN OUTPUT MATRIX OF      #
C#    POSSIBLY DIFFERENT DIMENSION                                     #
C#######################################################################
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION AIN(NAMX,*),BOUT(NBMX,*)
C
      DO 10 JL=1,NLJ
      DO 11 IL=1,NLI
      BOUT(IL,JL)=AIN(IGAP+IL,JGAP+JL)
   11 continue
   10 CONTINUE
      RETURN
      END
      SUBROUTINE MTMULT (A,B,C, L,M,N, NA,NB,NC)
C#######################################################################
C#    PERFORMS MATRIX MULTIPLICATION                                   #
C#         A      = B        * C                                       #
C#          (L,N)    (M,L)      (M,N)                                  #
C#######################################################################
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION A(NA,*),B(NB,*),C(NC,*)
C
      DO 200 I = 1,L
         DO 201 J = 1,N
            SUM = 0.D0
            DO 202 K = 1,M
               SUM = SUM+B(K,I)*C(K,J)
 202        CONTINUE
            A(I,J) = SUM
 201     CONTINUE
 200  CONTINUE
      RETURN
C
      END
      SUBROUTINE MTSYM(A,NDIM,NDIMX,IKEY)
C#######################################################################
C#    SYMMETRIZES A MATRIX WHICH IS GIVEN BY ITS LOWER TRIANGLE IF     #
C#    IKEY.EQ.1 AND BY ITS UPPER TRIANGLE IF IKEY.EQ.2                 #
C#######################################################################
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION A(NDIMX,*)
C
      DO 10 I=1,NDIM
      DO 11 J=1,I
         IF(IKEY.EQ.1) A(J,I)=A(I,J)
         IF(IKEY.EQ.2) A(I,J)=A(J,I)
 11   continue
   10 CONTINUE
      RETURN
      END
      SUBROUTINE MTVEC(AMAT,NLI,NLJ,LIST,LJST,INCR,VEC,NDIMX)
C#######################################################################
C#    STORES A TWO DIMENSIONAL MATRIX INTO A VECTOR                    #
C#######################################################################
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION AMAT(NDIMX,*),VEC(*)
C
      DO 20 JL=1,NLJ
         LJ=LJST+(JL-1)*INCR
         INDJ=(LJ-1)*NDIMX
         DO 10 IL=1,NLI
            LI=LIST+(IL-1)*INCR
            INDIJ=INDJ+LI
            VEC(INDIJ)=AMAT(IL,JL)
   10    CONTINUE
   20 CONTINUE
      RETURN
      END
      SUBROUTINE PLMLGD(P,CT,ST,FLMX,FMM)
C#######################################################################
C#    CALCULATES NORMALIZED LEGENDRE FUNCTIONS                         #
C#    STORES THEM SO THAT P(IABS(M),M) IS THE IABS(M)+1 TH TERM        #
C#######################################################################
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      PARAMETER (NFMX=250)
      COMMON /LOGFAC/FCT(NFMX)
      DIMENSION P(*)
      DATA NTIMES/1/
      DATA EPSI,DLG2,FACTOR/0.01D0,0.6931471D0,0.282094792D0/
C
      IF(NTIMES.EQ.1) CALL FACLOG
      NTIMES=NTIMES+1
C
      FM = DABS(FMM)
      M=FM+EPSI
      SGN=(-1)**MOD(M,2)
      STM=1
      IF(M.GT.0) STM=ST**M
      P(M+1)= SGN*DEXP(FCT(2*M+2)*0.5D0 -M*DLG2-FCT(M+1))*STM* FACTOR
      FL = FM+1
      A=DSQRT((FL+FM)*(FL-FM)/((2*FL+1)*(2*FL-1)))
      P(M+2) = P(M+1)*CT/A
      I=1
   10 I=I+1
      B=A
      FL = FL+1
      A=DSQRT((FL+FM)*(FL-FM)/((2*FL+1)*(2*FL-1)))
      P(M+I+1)=(P(M+I)*CT-B*P(M+I-1))/A
      IF(FL.LT.(FLMX-EPSI)) GO TO 10
      RETURN
      END
