! Copyright 2022
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
module algorithms

    use iso_fortran_env, only: int32, int64

    implicit none

    interface findloc
        module procedure findloc_i4_i8_i8_1d
        module procedure findloc_i8_i8_i8_1d
    end interface findloc

contains

    !> A convenience subroutine defined in Fortran 2008. Can be safely erased once Fortran 2008 is fully embraced.
    integer function findloc_i4_i8_i8_1d (array, val, dimen, back) result (position)

        integer(int32), intent(in) :: array(:)
        integer(int64), intent(in) :: val, dimen
        logical, intent(in), optional :: back

        integer :: i, first, last, step

        first = 1
        last = size(array)
        step = 1

        if (present(back)) then
            if (back) then
                first = size(array)
                last = 1
                step = -1
            end if
        end if

        position = 0
        do i = first, last, step
            if (array(i) == val) then
                position = i
                return
            end if
        end do

    end function findloc_i4_i8_i8_1d


    !> A convenience subroutine defined in Fortran 2008. Can be safely erased once Fortran 2008 is fully embraced.
    integer function findloc_i8_i8_i8_1d (array, val, dimen, back) result (position)

        integer(int64), intent(in) :: array(:)
        integer(int64), intent(in) :: val, dimen
        logical, intent(in), optional :: back

        integer :: i, first, last, step

        first = 1
        last = size(array)
        step = 1

        if (present(back)) then
            if (back) then
                first = size(array)
                last = 1
                step = -1
            end if
        end if

        position = 0
        do i = first, last, step
            if (array(i) == val) then
                position = i
                return
            end if
        end do

    end function findloc_i8_i8_i8_1d

end module algorithms
