! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE VIBRMT(IFAIL)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     MAXIMUM DIMENSIONS ARE SET BY THE FOLLOWING PARAMETER STATEMENT
C     VARIABLE DIMENSIONS ARE USED IN ALL LOWER LEVEL ROUTINES, EXCEPT
C     VIBINI 
C
      PARAMETER (MAXPTS=50,MAXPOL=200,MAXTGT=50)
C
C     MAXPTS = MAXIMUM NUMBER OF GEOMETRIES
C     MAXPOL = MAXIMUM NUMBER OF NONADIABATIC R-MATRIX POLES
C     MAXTGT = MAXIMUM NUMBER OF TARGET ELECTRONIC STATES
C     MAXFCH = MAXIMUM NUMBER OF FIXED NUCLEI SCATTERING CHANNELS
C
      CHARACTER(LEN=80) NAME
      CHARACTER(LEN=11) RFORM,CHFORM,VCFORM,NRFORM,MODDAT,BFORM
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=1) IBFORM,ICFORM,IRFORM,IVCFRM,INRFRM
      CHARACTER(LEN=8) BLANK
      CHARACTER(LEN=20) DAYTIM
      INTEGER STOT,GUTOT
      DIMENSION RK(MAXPTS+4),R(MAXPTS),IPRNT(6),ICUP(2)
     1,NCHSET(MAXPTS),NRMSET(MAXPTS),NVTARG(MAXTGT)
     3,ICROSS(2,MAXPOL),NBSET(MAXPOL)
      COMMON/INTFS/ NCHAN,ION,NVIB,NDIS,IWRITE,MGVN,STOT,GUTOT
      double precision, allocatable :: ampv(:),eigv(:),cke(:),ckw(:),
     * evchl(:),evib(:),vibfn(:),avc(:),qwts(:),rquad(:),emat(:),
     * cfa0(:),etarg(:,:),echl(:),eig(:,:),fnmc(:,:),wamp(:,:),
     * butt(:,:),vec(:,:),etmin(:)
      integer, allocatable :: ivstg(:),ivmtg(:),ivgtg(:),ivchl(:),
     * lvchl(:),mvchl(:),ivtarg(:),ivnu(:),ncup(:),ichl(:),lchl(:),
     * mchl(:),mtarg(:),starg(:),gtarg(:)
      EXTERNAL VPOTL
C
C***********************************************************************
C
C     BASIC DATA IS INPUT VIA NAMELIST /VRMTIN/
C     OTHER DATA IS INPUT VIA NAMELISTS IN ROUTINES VIBINI AND DISINI
C
C      BBLOCH   = COEFFICIENT IN ELECTRONIC BLOCH OPERATOR
C      BIGB     = COEFFICIENT IN NUCLEAR BLOCH OPERATOR
C      GUTOT    = g/u symmetry of total system
C      ICROSS   = for each pair of diabatic crossings I,
C                 ICROSS(1,I) = label of (initially) lower pole
C                 ICROSS(2,I) = label of geometry immediately 
C                 preceding the crossing
C      ICUP     = ICUP(1) = label of lowest pole to be coupled
C                 ICUP(2) = label of highest pole to be coupled
C      IGREF    = Label of reference geometry for diabatic
C                 transformation of coupled electronic states
C      IWRITE   = Logical unit for printed output
C      IBFORM   = Formatted/unformatted switch for unit LUBND
C      ICFORM   = Formatted/unformatted switch for unit LUCHAN
C      INRFRM   = Formatted/unformatted switch for unit LUNRMT
C      IRFORM   = Formatted/unformatted switch for unit LURMT
C      ISMAX    = Highest term to be retained in multipole expansion of
C                 either the asymptotic electronic on nuclear potential 
C      IVCFRM   = Formatted/unformatted switch for unit LUVCHN
C      IPRNT    = DEBUG PRINT SWITCHES
C                 (1) input data
C                 (2) transformed CI data
C                 (3) vibrational wavefunctions
C                 (4) nuclear motion code
C                 (5)   "       "     "
C                 (6) output data
C      LUCHAN   = LOGICAL UNIT HOLDING CHANNEL AND TARGET DATA
C      LUNRMT   = Logical unit holding non-adiabatic R-matrices
C      LURMT    = Logical unit holding fixed nuclei R-matrix data
C      LUVCHN   = Logical unit holding vibrational and dissociating
C                 channel data
C      MGVN     = M symmetry of total system
C      NAME     = Title for output
C      NBASIS   = NUMBER OF LEGENDRE POLYNOMIALS TO BE USED IN EXPANSION
C                 OF NUCLEAR MOTION HAMILTONIAN
C      NCHSET   = set numbers of input channel/target data for each
C                 geometry
C      NCREF    = Label of some geometry unaffected by crossings
C      NCROSS   = Number of pairs of poles which are required to cross
C                 diabatically 
C      NDIS     = NUMBER OF DISSOCIATING CHANNELS
C      NGEOM    = NUMBER OF GEOMETRIES
C      NNRSET   = set number for output non-adiabatic R-matrix data
C      NPOLE    = NUMBER OF ELECTRONIC R-MATRIX POLES TO BE TREATED
C                 NON-ADIABATICALLY
C      NRMSET   = Set numbers for input fixed nuclei R-matrix data
C                 for each geometry
C      NRQUAD   = NUMBER OF QUADRATURE POINTS FOR INTEGRALS IN NUCLEAR
C                 MOTION CODE ( IF =0 THEN CODE DECIDES)
C      NVCSET   = set number for output vibrational/dissociating
C                 channel data
C      NVTARG   = NUMBER OF VIBRATIONAL LEVELS FOR EACH TARGET STATE
C      R        = ARRAY HOLDING INTERNUCLEAR SEPARATIONS
C      STOT     = Spin multiplicity of total system
C
      NAMELIST/VRMTIN/LUCHAN,LURMT,LUVCHN,LUNRMT,NPOLE,NDIS,MGVN
     1 ,STOT,GUTOT,NGEOM,R,IWRITE,ISMAX,NVTARG,NBASIS,NBSET,nbigset
     2 ,NRQUAD,IPRNT,NCHSET,NRMSET,NVCSET,NNRSET,BBLOCH
     3 ,ICFORM,IRFORM,IVCFRM,INRFRM,NAME,BIGB,LUBND
     4 ,NCROSS,ICROSS,ICUP,IGREF,NCREF,IBFORM
C
C***********************************************************************
C
      DATA IREAD,LUBND,LUCHAN,LURMT,LUVCHN,LUNRMT/5,11,10,21,28,29/
     1,IPRNT/6*0/,NBASIS/25/,BBLOCH,BIGB/0.D0,0.D0/
     2,NKNOT/0/,NVCSET/1/,NNRSET/1/,NRQUAD/0/,NPOLE/0/,ISMAX/-1/
     3,NEXT/1/,ZERO/0.D0/,IGREF/1/,NCREF/1/,MDMAX/-1/,nbigset/1/
     4,HALF/0.5D0/,TWO/2.D0/,EV/13.6054d0/
     5,ICUP/1,0/,ICROSS/MAXPOL*0,MAXPOL*0/
      DATA FORM,CHFORM,RFORM,NRFORM,VCFORM/5*'FORMATTED'/
     1,BLANK/'        '/,IBFORM,ICFORM,IRFORM,IVCFRM,INRFRM/5*'U'/
      DATA MODDAT/'5-OCT-1993'/
C
C---- SET UP DEFAULT VALUES OF POINTERS NCHSET AND NRMSET 
      IWRITE = 6
      NDIS = 0
      DO 112 I=1,MAXPTS
      NCHSET(I) = I
      NRMSET(I) = I
 112  continue
      DO 113 I=1,MAXPOL
      NBSET(I) = 1
 113  continue
C
      IFAIL = 0
      NEXT = 1
C
C---- Read basic data via namelist /VRMTIN/
      READ(5,VRMTIN)
C
C---- Date stamp run and print title
      CALL DATEST(DAYTIM)
      NAME(61:) = DAYTIM
      WRITE(IWRITE,12)MODDAT,NAME
c
c---- Check that input data does not exceed fixed dimensions
      IF(NGEOM.EQ.1.OR.NPOLE.EQ.0) THEN
        WRITE(IWRITE,14)
        RETURN
      ENDIF
      IF(NPOLE.GT.MAXPOL.OR.NGEOM.GT.MAXPTS) GO TO 96
C
      IF(IBFORM.EQ.'U') BFORM='UN'//FORM
      IF(ICFORM.EQ.'U') CHFORM='UN'//FORM
      IF(IRFORM.EQ.'U') RFORM='UN'//FORM
      IF(INRFRM.EQ.'U') NRFORM='UN'//FORM
      IF(IVCFRM.EQ.'U') VCFORM='UN'//FORM
c
      WRITE(IWRITE,10)NPOLE,NDIS,(R(I),I=1,NGEOM)
      WRITE(IWRITE,11)MGVN,STOT,GUTOT
      WRITE(IWRITE,13)CHFORM,LUCHAN,(NCHSET(IG),IG=1,NGEOM)
      WRITE(IWRITE,33)RFORM,LURMT,(NRMSET(IG),IG=1,NGEOM)
      WRITE(IWRITE,31)VCFORM,LUVCHN,NVCSET,NRFORM,LUNRMT,NNRSET
C
C---- Compute NCROSS = number of diabatic crossings
      NCROSS = MAXPOL
      DO 24 I=MAXPOL,1,-1
      IF(ICROSS(2,I).NE.0) GO TO 25
      NCROSS = NCROSS-1
 24   CONTINUE
C      
C---- Find first R-matrix input set (or set with largest NOCSF) and read
c     dimension information
c
 25   WRITE(IWRITE,19)
      CALL READRH(LURMT,nchset(nbigset),RFORM,MGVN,STOT,GUTOT,NCHANF,
     1 nvib,NDIS0,NTARG,ION,R(nbigset),RMASS,RMATR,NBUT,ISMX,NOCSF,NPLX,
     2 IWRITE,IPRNT(1),IFAIL)
      nocsx = nocsf
      IF(IFAIL.NE.0) RETURN
      IF(ISMAX.EQ.-1.OR.ISMAX.GT.ISMX) ISMAX=ISMX
      ncupp = icup(2)
      IF(ncupp.GT.NPLX) then
        WRITE(IWRITE,22) ncupp,nplx
        ncupp = nplx
      endif
C
      TWOMI = HALF/RMASS
      write(iwrite,28) rmass
C
C---- Assign storage for fixed nuclei data
      NCHFSQ = NCHANF*(NCHANF+1)/2
      allocate (etarg(ntarg,ngeom),echl(nchanf),eig(NOCSF,NGEOM),
     * fnmc(ISMAX*NCHFSQ,NGEOM),wamp(NOCSF*NCHANF,NGEOM),etmin(ntarg),
     * butt(3*NCHANF,NGEOM),vec(NCUPP*NOCSF,NGEOM),mtarg(ntarg),
     * starg(ntarg),gtarg(ntarg),ichl(nchanf),lchl(nchanf),
     * mchl(nchanf))
C
      DO 8 I=1,ntarg
      ETMIN(I) = ZERO
 8    continue
C
C---- LOOP OVER GEOMETRIES
      DO 2 IG=1,NGEOM
C
C---- READ TARGET AND CHANNEL DATA
c
      CALL READTC(LUCHAN,NCHSET(IG),NCHANF,NVIB0,NDIS0,NTARG,ION,IVT0,
     1IVU0,ICHL,LCHL,MCHL,ECHL,STARG,MTARG,GTARG,ETarg(1,ig),R(IG),
     2 RMASS,CHFORM,IWRITE,IPRNT(1),IFAIL)
      IF(IFAIL.NE.0) RETURN
C
C---- Read remainder of R-matrix data
      IF(IG.NE.nbigset) CALL READRH(LURMT,NRMSET(IG),RFORM,MGVN,STOT,
     1 GUTOT,NCHANF,NVIB0,NDIS0,NTARG,ION,R(IG),RMASS,RMATR,NBUT,ISMX,
     2 NOCSF,NPLX,IWRITE,-1,IFAIL)
      if(nocsf.gt.nocsx) then
        write(iwrite,900) nocsf,nocsx
        ifail = 1
        return
      else if(nocsf.lt.nocsx) then
        write(iwrite,901) nocsf,nocsx
      endif
      CALL READRM(LURMT,RFORM,NCHANF,NOCSF,ISMX,ISMAX,NPLX,NCUPP,NBUT,
     1 FNMc(1,ig),EIG(1,ig),WAMP(1,ig),VEC(1,ig),BUTT(1,ig),work,IFAIL)
      IF(IFAIL.NE.0) RETURN
      DO 3 IT=1,NTARG
      ETMIN(IT) = MIN(ETMIN(IT),ETarg(IT,ig))
 3    continue
C
C----- SWAP POLE POSITIONS AND BOUNDARY AMPLITUDES IF POLES ARE
C      REQUIRED TO CROSS DIABATICALLY
      IF(NCROSS.GT.0) CALL SWAPPR(NGEOM,NCREF,NCHANF,NOCSF,NCROSS,NPLX,
     1 ICROSS,EIG(1,ig),WAMP(1,ig),VEC(1,ig),IG,IWRITE)
C
 2    CONTINUE
      WRITE(IWRITE,21)
C
C---- Find minimum of target potential curve and use this as zero
C     of energy scale
      EBASE = ZERO
      DO 4 IT=1,NTARG
      EBASE = MIN(EBASE,ETMIN(IT))
 4    continue
C
C---- Initialization of vibrational data
      WRITE(IWRITE,15) (I,NVTARG(I),I=1,NTARG)
      NVIB = 0
C
C---- Compute number of vibrational channels
      DO 5 I=1,NTARG
      NVIB = NVIB+NVTARG(I)
 5    continue
      NVIBD = NVIB+NDIS
      NVCHAN = 0
      DO 61 I=1,NTARG
      DO 6 J=1,NCHANF
      IF(I.EQ.ICHL(J)) NVCHAN=NVCHAN+NVTARG(I)
 6    CONTINUE
 61   continue
      NCHAN = NVCHAN+NDIS
      NCH2 = NCHAN*(NCHAN+1)/2
C
C---- Initialize acquisition of vibrational functions 
      CALL VIBINI(IREAD,IWRITE,NTARG,NVTARG,RMASS,EBASE,IPRNT(3))
C
C----- SUBTRACT BASE ENERGY FROM POLE POSITIONS
      WRITE(IWRITE,17) EBASE
      DO 71 I=1,NOCSF
      do 7 ig=1,NGEOM
      EIG(I,ig) = EIG(I,ig)-EBASE
 7    continue
 71   continue
C
C---- Transform CI data into form suitable for use in nuclear motion cod
      allocate (ncup(npole),emat(NGEOM*NPOLE*NPOLE),cfa0(NPOLE*ncupp))
c
      CALL CUPPL(NGEOM,NOCSF,NPOLE,ncupp,NCHANF,NTARG,ICHL,IGREF,
     1 VEC,EIG,WAMP,EMAT,ICUP,NCUP,CFA0,EMINA,IWRITE,IPRNT(2),IFAIL)
      IF(IFAIL.NE.0) RETURN
C
C---- Set up quadrature scheme for integrals in adiabatic nuclei approx
      IF(NRQUAD.EQ.0) THEN
C     THIS IS A BIT ARBITRARY AND NOT THOROUGHLY TESTED
        NQUAD = max(15*NVTARG(1),nbasis)+1
        IF(MOD(NQUAD,2).EQ.0) NQUAD=NQUAD+1
      ELSE
        NQUAD = NRQUAD
      ENDIF
      if(nbasis.gt.nquad) then
        write(iwrite,95) nrquad,nbasis,nbasis+1
        nquad = nbasis+1
      endif
      allocate (rquad(nquad),qwts(nquad))
C
      CALL VMESH(R(1),R(NGEOM),NQUAD,RQUAD,QWTS)
C
C---- Initialize spline interpolation
      CALL SPLINI(NKNOT,KNOTS,RK,MAXPTS,NGEOM,R,IWRITE)
C
C---- Get target vibrational wavefunctions on quadrature mesh
c
      allocate (evib(nvibd),ivtarg(nvibd),ivnu(nvibd),vibfn(nvib*nquad))
c
      CALL RVIBR(NVIB,NQUAD,EVIB,IVTARG,IVNU,VIBFN,dum,RQUAD)
C
C---- Optionally check their orthonormality on [R(1),R(NGEOM)]
      IF(IPRNT(3).GT.0) CALL CHECKQ(NQUAD,NVIB,QWTS,VIBFN,IWRITE)
C
C---- Compute highest scattering energy for which current value of NPOLE
C     is appropriate
      EMINR = TWO*(EMINA+ebase-EVIB(1))
      EMINE = EV*EMINR
      WRITE (IWRITE,35) EMINR,EMINE
C
C---- Initialize solution of equations for asymptotically dissociating
C     channels
      if(ndis.eq.0) then
        msmax = ismax
      else
        msmax = 2
      endif
      allocate (avc(MSMAX*NCHAN*(NCHAN+1)/2))
      IF(NDIS.GT.0) THEN
        IADC = 1+ISMAX*NVCHAN*(NVCHAN+1)/2
        ND2 = NDIS*(NDIS+1)/2+6*NDIS
        CALL DISINI(IREAD,IWRITE,RMASS,EBASE,NDIS,ND2,MDMAX,AVC(iadc),
     1  R(NGEOM),RAFIND,EVIB(1+NVIB),IVTARG(1+NVIB),IPRNT(3),IFAIL)
      ENDIF
      MSMAX = MAX(ISMAX,MDMAX)
      WRITE(IWRITE,34) MSMAX
C
C---- Define asymptotic vibrational channels (including dissociating 
C     ones) and write new channel file
c
      allocate (ivchl(nchan),lvchl(nchan),mvchl(nchan),evchl(nchan))
      allocate (ivstg(nvib),ivmtg(nvib),ivgtg(nvib))
c
      CALL VCHAN(NCHANF,NTARG,LCHL,MCHL,ICHL,NVTARG,EVIB,IVCHL,LVCHL,
     * MVCHL,EVCHL,starg,mtarg,gtarg,ivstg,ivmtg,ivgtg,NDIS,RMASS)
C
C---- Write header to file holding vibrational channel information
      CALL WRITCH(LUVCHN,NVCSET,VCFORM,ZERO,RMASS,IVCHL,LVCHL,
     1 MVCHL,EVCHL,nvib,ivSTG,ivMTG,ivGTG,evib,
     2 IVTARG,IVNU,NAME,IPRNT(6),IFAIL)
      IF(IFAIL.NE.0) RETURN
C
C---- Get multipole moments for potentials in asymptotic hybrid
C     equations
      IF(MSMAX.GT.0) THEN
        CALL ADNUC(NGEOM,R,NCHANF,ICHL,NTARG,NVTARG,VIBFN,KNOTS,
     1  RK,NVCHAN,FNMC,AVC,dum,ISMAX,NQUAD,RQUAD,QWTS)
      ENDIF
C
C----- CALCULATE SPLINE INTERPOLATION COEFFICIENTS FOR R-MATRIX POLE
C      POSITIONS, BOUNDARY AMPLITUDES AND CI VECTOR COEFFICIENTS
C
      allocate (cke(KNOTS*NPOLE*NPOLE),ckw(KNOTS*NCHANF*NPOLE))
C
      CALL SPLINE(NPOLE*NPOLE,NGEOM,KNOTS,RK,CKE,R,EMAT,dum,dum,dum)
      CALL SPLINE(NPOLE*NCHANF,NGEOM,KNOTS,RK,CKW,R,WAMP,dum,dum,dum)
C
C----- STORAGE ALLOCATION FOR NUCLEAR MOTION CODE
      NHD  = NBASIS*NPOLE
      allocate (ampv(Nhd*NPOLE*(NPOLE+NVCHAN)),eigv(Nhd*NPOLE))
      WRITE(IWRITE,23) NBASIS,NHD
C
C----- MAKE INITIALIZATION CALL TO NUCLEAR R-MATRIX PACKAGE
C
      CALL VRMAT1(NPOLE,NVCHAN,NCHANF,NVIB,NBASIS,NCUP,NQUAD,ICHL,
     1 R(1),R(NGEOM),BBLOCH,TWOMI,KNOTS,RK,CKE,CKW,IPRNT(4),
     2 IWRITE,AMPv,EIGv,VPOTL)
C
C---- Convert eigenvalues back to absolute units (au)
      epmin = zero
      DO 9 I=1,nhd
      eigv(I) = eigv(I)+EBASE
      epmin = min(epmin,eigv(i))
 9    continue
      WRITE(IWRITE,101) epmin,(eigv(I),I=1,nhd)
C
C----- TRANSFORM BOUNDARY AMPLITUDES TO GET CORRECT AMPLITUDES IN
C      DISSOCIATING CHANNELS
      IF(NDIS.GT.0) THEN
        CALL TRANSD(NDIS,NPOLE,NHD,NOCSF,NCHANF,NCUP,CFA0,LUBND,
     1  BFORM,NBSET,AMPv(1+nhd*nvchan),TWOMI,IWRITE,IFAIL)
        IF(IFAIL.NE.0) RETURN
      ENDIF
C
C---- Write new R-matrix file
      CALL WRITRM(LUNRMT,NNRSET,NRFORM,NHD,MSMAX,0,AVC,EIGv,
     1 AMPv,dum,dum,Nvib,ZERO,RMASS,R(NGEOM),0,NAME,IPRNT(6),IFAIL)
C
C     Close files and return to calling program
      IF(IFAIL.EQ.0) WRITE(IWRITE,18)
c
      deallocate (ampv,eigv,cke,ckw,evchl,evib,vibfn,avc,rquad,qwts,
     * ivstg,ivmtg,ivgtg,ivchl,lvchl,mvchl,ivtarg,ivnu,ncup,emat,cfa0,
     * etarg,echl,eig,fnmc,wamp,butt,vec,etmin,mtarg,starg,gtarg,ichl,
     * mchl,lchl)
c    
      CLOSE(UNIT=LUCHAN)
      CLOSE(UNIT=LURMT)
      CLOSE(UNIT=LUVCHN)
      CLOSE(UNIT=LUNRMT)
      RETURN
C
 96   WRITE(IWRITE,98) NPOLE,NTARG,NGEOM,MAXPOL,MAXTGT,MAXPTS
 98   FORMAT(/' INPUT DATA WILL EXCEED FIXED DIMENSIONS'/' INPUT  ',
     13I5/' MAXIMA ',3I5)
      STOP
 10   FORMAT(/' Number of electronic R-matrix poles treated non-adiabati
     1cally =',I3/' Number of dissociating channels =',I3//
     2' Input geometries'/' R =',7F10.5,(/4X,7F10.5))
 11   FORMAT(/' Symmetry data  MGVN =',I2,' STOT =',I2,' GUTOT =',I2)
 12   FORMAT(//' Program VIBRMT ( last modified ',A,' )'//A/)
 13   FORMAT(/' Input datasets:',33X,'Unit       Set numbers'/
     1' Target and channel data     LUCHAN (',A11,')',I3,5X,30I5/
     235X,30I3)
 14   FORMAT(/' There is no need to call VIBRMT for either fixed nuclei 
     1or adiabatic nuclei calculations'/' Returning to calling program'/
     2)
 15   FORMAT(/' Number of vibrational levels for each electronic state'
     1/(' NVTARG(',I2,') =',I3))
 16   FORMAT(I3,12F10.5/(3X,12F10.5))
 17   FORMAT(/' Base energy used in nuclear motion code  EBASE =',F11.5,
     1' au')
 18   FORMAT(/' *** Task successfully completed ***')
 19   FORMAT(/' *** FIXED NUCLEI DATA *** ')
 20   FORMAT(/' Insufficient vectors have been saved for required treatm
     1ent of crossings'/' The highest',I2,' diabatic crossings will be i
     2gnored')
 21   FORMAT(/' *** END OF FIXED NUCLEI DATA *** ')
 22   FORMAT(/' *** Insufficient eigenvectors available to treat',I3,
     1' coupled poles non-adiabatically, only',I3,' will be used ***')
 23   FORMAT(/' Number of terms in Legendre basis =',I5/' Dimension of n
     1uclear motion Hamiltonian =',I5)
 27   FORMAT(10A8)
 28   format(/' Reduced mass =',f10.3)
 31   FORMAT(/' Output datasets:',32X,'Unit    Set Number'/
     1' Vibrational channel data    LUVCHN (',A11,')',I3,5X,I5/
     2' Non-adiabatic R-matrix data LUNRMT (',A11,')',I3,5X,I5)
 33   FORMAT(' Fixed nuclei R-matrix data  LURMT  (',A11,')',I3,5X,30I5/
     235X,30I3)
 34   FORMAT(/' Maximum multipole RETAINED in expansion of asymptotic po
     1tentials:  ISMAX =',I2)
 35   FORMAT(/' Approximation valid for scattering energies below',
     1F10.4,' Ryd',2X,F10.4,' eV'/' If higher energies are required, inc
     2rease NPOLE')
 95   format(/' NRQUAD=',i3,' too small for NBASIS=',i3,' increased to '
     1,i3)
 101  FORMAT(/' Poles of nuclear motion R-matrix (au)'/'  Minimum ',
     1d15.6/(5D15.6))
 900  format(/' ERROR: NOCSF =',i5,' greater than initial value',i5)
 901  format(/' WARNING: NOCSF =',i5,' less than initial value',i5)
C
      END
      SUBROUTINE CUPPL(NGEOM,NOCSF,NPOLE,nplx,NCHAN,NTARG,ICHL,IGREF,CIV
     1 ,EIG,WAMP,ECUP,ICUP,NCUP,COEF,EMINA,IWRITE,LBUG,IFAIL)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     CUPPL transforms poles and amplitudes to a representation where
C     the electronic wavefunctions are independant of R. The electronic
C     wavefunctions at each geometry are re-expanded in terms of the
C     functions at R=R(IGREF). The code assumes that all SCF coeffients
C     and numerical basis functions used in the CI calculation are
C     consistent in sign. This routine also assumes that the basic
C     molecular orbitals vary slowly with geometry.
C
C***********************************************************************
C
      DIMENSION EIG(NOCSF,NGEOM),WAMP(*),WORK(NCHAN*NOCSF*NGEOM),
     2 ICUP(2),ICHL(NCHAN),NCUP(NPOLE),
     1 CIV(NOCSF,nplx,NGEOM),ECUP(NGEOM,NPOLE,NPOLE),COEF(NPOLE,nplx)
      DATA ZERO/0.D0/,VBIG/1000.D0/,ncol/6/
C
C----- SET UP COUPLING FLAGS
      DO 16 I=1,NPOLE
      NCUP(I) = 1
 16   continue
      NSAV = 0
      NC = ICUP(2)-ICUP(1)+1
      NSAV = NSAV+NC
      DO 9 J=ICUP(1),ICUP(2)
      NCUP(J) = NC
 9    continue
      IF(NSAV.GT.NPlx) THEN
        WRITE(IWRITE,29) NSAV,NPlx
        IFAIL = 1
        RETURN
      ELSE
        WRITE(IWRITE,28) NSAV
      ENDIF
C
      DO 1 IG=1,NGEOM
C
      DO 181 I=1,NPOLE
      DO 18 J=1,NPOLE
      ECUP(IG,I,J) = ZERO
 18   continue
 181  continue
      DO 19 I=1,NPOLE
      ECUP(IG,I,I) = EIG(I,IG)
 19   continue
C
C---- CALCULATE OVERLAP MATRIX
      II = 0
      DO 12 I=1,NPOLE
      IF(NCUP(I).EQ.1)GO TO 12
      II = II+1
      DO 2 J=1,nplx
      SUM = ZERO
      DO 3 K=1,NOCSF
      SUM = SUM+CIV(K,I,IGREF)*CIV(K,J,IG)
 3    continue
      COEF(II,J) = SUM
 2    CONTINUE
 12   CONTINUE
C
C---- Transform boundary amplitudes
      CALL TRANSW(NCHAN,NOCSF,NPOLE,NCUP,NTARG,ICHL,IG,WAMP,COEF,nplx)
C
C---- COUPLE POLES
      ncupp = 0
      II = 0
      DO 17 I=1,NPOLE
      IF(NCUP(I).EQ.1) GO TO 17
      II = II+1
      JJ = 0
      DO 7 J=1,NPOLE
      IF(NCUP(J).EQ.1) GO TO 7
      ncupp = ncupp+1
      JJ = JJ+1
      SUM = ZERO
      DO 8 K=1,nplx
      SUM = SUM+COEF(II,K)*EIG(K,IG)*COEF(JJ,K)
 8    CONTINUE
      ECUP(IG,I,J) = SUM
 7    CONTINUE
 17   CONTINUE
C
 1    CONTINUE
C
C---- Reorder boundary amplitudes so that geometries are contiguous
      DO 6 I=1,NCHAN*NOCSF*NGEOM
      WORK(I) = WAMP(I)
 6    continue
      K = 0
      DO 51 IG=1,NGEOM
      DO 5 I=1,NCHAN*NOCSF
      K = K+1
      J = (I-1)*NGEOM+IG
      WAMP(J) = WORK(K)
 5    CONTINUE
 51   continue
C
C---- Find lowest energy of adiabatic poles
      EMINA = VBIG
      DO 41 IG=1,NGEOM
      DO 4 I=NPOLE+1,NOCSF
      EMINA = MIN(EMINA,EIG(I,IG))
 4    CONTINUE
 41   continue
C
      IF(LBUG.GT.0) THEN
        WRITE(IWRITE,101)
 101    FORMAT(/' Transformed boundary amplitudes')
        npsq = npole*nchan
        K = 0
        DO 107 j=1,npole
        DO 106 I=1,NCHAN
        iJ = ((I-1)*npole+(j-1))*ngeom
        DO 105 IG=1,NGEOM
        K = K+1
        Work(iJ+ig) = Wamp(K)
 105    CONTINUE
 106    continue
 107    continue
        call WRECMT(work,ngeom,npsq,ngeom,npsq,ncol,iwrite)
        IF(NCUPP.EQ.0) THEN
          WRITE(IWRITE,103)
          ip2 = 0
 25       ip1 = ip2+1
          ip2 = ip2+min(npole-ip2,ncol)
          DO 15 IG=1,NGEOM
          WRITE(IWRITE,100)(ECUP(IG,I,I),I=ip1,ip2)
 15       continue
          if(ip2.lt.npole) then
            write(iwrite,100)
            go to 25
          endif
        ELSE
          WRITE(IWRITE,102)
          npsq = npole*npole
          call WRECMT(ecup,ngeom,npsq,ngeom,npsq,ncol,iwrite)
        ENDIF
      ENDIF
C
      RETURN
 28   FORMAT(/' Number of coupled electronic poles',I3)
 29   FORMAT(/' *** ERROR ***  Number of coupled poles',I3,' exceeds num
     1ber of non-adiadatic poles',I3)
 100  FORMAT(6D12.4)
 102  FORMAT(/' Coupled Energy matrix')
 103  FORMAT(/' Uncoupled R-matrix Poles')
      END
      SUBROUTINE TRANSW(NCHAN,NOCSF,NPOLE,NCUP,NTARG,ICHL,IG,WAMP,COEF,
     1 nplx)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     TRANSW transforms boundary amplitudes of coupled poles
C
C***********************************************************************
C
      DIMENSION WAMP(NCHAN,NOCSF,*),WORK(NPOLE),COEF(NPOLE,nplx),
     2NCUP(NPOLE),ICHL(NCHAN)
      DATA ZERO/0.D0/,EPS/1.D-6/,ratio/2.d0/
C
      DO 61 I=1,NCHAN
      JJ = 0
      DO 4 J=1,NPOLE
      IF(NCUP(J).EQ.1) GO TO 4
      JJ = JJ+1
      SUM = ZERO
      DO 5 K=1,nplx
      SUM = SUM+WAMP(I,K,IG)*COEF(JJ,K)
 5    CONTINUE
      WORK(JJ) = SUM
 4    CONTINUE
      JJ = 0
      DO 6 J=1,NPOLE
      IF(NCUP(J).EQ.1) GO TO 6
      JJ = JJ+1
      WAMP(I,J,IG) = WORK(JJ)
 6    CONTINUE
 61   continue
C
C---- MAKE SURE THAT BOUNDARY AMPLITUDES OF UNCOUPLED POLES HAVE
C     CONSISTENT SIGNS
      IF(IG.GT.1) THEN
C
C---- LOOP OVER UNCOUPLED NON-ADIABATIC POLES
        DO 13 J=1,NPOLE
        IF(NCUP(J).GT.1) GO TO 13
C
C---- LOOP OVER ALL CHANNELS BELONGING TO A GIVEN TARGET
        DO 16 IT=1,NTARG
        wsum = zero
        xsum = zero
        DO 14 I=1,NCHAN
        IF(ICHL(I).NE.IT) GO TO 14
        IF(ABS(WAMP(I,J,IG)).LT.EPS.OR.ABS(WAMP(I,J,IG-1)).LT.EPS)
     1   GO TO 14
        wsum = wsum+abs(wamp(i,j,ig))
        IF(WAMP(I,J,IG)*WAMP(I,J,IG-1).LT.ZERO) 
     1        xsum = xsum+abs(wamp(i,j,ig))
 14     CONTINUE
C
C---- IF HALF OR MORE CHANNELS INDICATE A SIGN CHANGE THEN CHANGE ALL
        IF(ratio*xsum.lt.wsum) go to 16
        DO 15 I=1,NCHAN
        IF(ICHL(I).EQ.IT) WAMP(I,J,IG)=-WAMP(I,J,IG)
 15     CONTINUE
C
 16     CONTINUE
 13     CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE VHDIAG(NPOLE,NVCHAN,NLEG,RA,HMLT,AMPA,EIGEN,NCUP,PINT,
     1 IWRITE,LBUG)
C
C***********************************************************************
C
C      VHDIAG DIAGONALIZES THE HAMILTONIAN MATRIX ON A GIVEN
C      SUBRANGE, STORES ITS EIGENVALUES AND USES ITS EIGENVECTORS
C      TO COMPUTE THE SURFACE AMPLITUDES
C
C      INPUT PARAMETERS ARE
C       RA THE R-MATRIX RADIUS
C       HMLT, THE HAMILTONIAN MATRIX EVALUATED OVER THIS SUBRANGE
C       (THE UPPER TRIANGLE STORED ROW-WISE)
C       PINT, INTEGRALS OF PRODUCTS OF INHOMOG TERMS AND PRIMITIVE
C             BASIS
C       LBUG, SWITCH FOR DEBUG OUTPUT
C       EIGO,VECTO AND WORK, ARRAYS USED AS WORK SPACE
C
C      OUTPUT PARAMETERS ARE
C       AMPA  THE SURFACE AMPLITUDES
C       EIGEN, THE EIGENVALUES OF THE HAMILTONIAN
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION AMPA(NPOLE*NLEG,NVCHAN+NPOLE),EIGEN(*),HMLT(*),
     1 PINT(NLEG,NPOLE*NVCHAN),NCUP(NPOLE),
     * EIGO(npole*nleg),VECTO(npole*nleg),work(8*npole*nleg)
      DATA ZERO,ONE,EPSI/0.D0,1.D0,1.D-9/
C
C     EPSI IS THE REQUIRED ACCURACY OF THE EIGENVALUES
C
      IF(LBUG.GT.0) WRITE(IWRITE,1000)
C
C      THE HAMILTONIAN MATRIX IS DIAGONALIZED IN ROUTINE HSLDR
C      THE EIGENVALUES ARE STORED IN ARRAY EIGO AND ONE VECTOR
C      IS STORED IN ARRAY VECTO. EACH CALL TO HSLDR PRODUCES ONE
C      EIGENVECTOR.
C
      ICUP = 0
      IDIAG = 1
      KK = 0
      DO 10 IP=1,NPOLE
      IF(NCUP(IP).GT.1.AND.ICUP.NE.0) GO TO 10
C
C      FIRST MEMBER OF COUPLED SET OF POLES
      ICUP = NCUP(IP)-1
      NHDP = NCUP(IP)*NLEG
      NHSP = NHDP*(NHDP+1)/2
C
      KCOUNT=0
      DO 1 K=1,NHDP
      KK = KK+1
      CALL HSLDR(NHDP,HMLT(IDIAG),NHSP,EPSI,EIGO,VECTO,K,WORK)
      EIGEN(KK) = EIGO(K)
C
C      OPTIONAL OUTPUT OF EIGENVALUES AND EIGENVECTORS
C
      IF(LBUG.GT.0) THEN
        IF(KCOUNT.EQ.0) WRITE(IWRITE,1002)ip,(EIGO(NEIG),NEIG=1,NHDP)
        KCOUNT=KCOUNT+1
        IF(LBUG.GT.2) THEN
          WRITE(IWRITE,1003) KCOUNT
          WRITE(IWRITE,1001) (VECTO(NVEC),NVEC=1,NHDP)
        ENDIF
      ENDIF
C
C      DETERMINE THE SURFACE AMPLITUDES AT RA AND STORE THEM IN
C      MATRIX AMPA
C
      DO 2 I=1,NVCHAN+NPOLE
      AMPA(KK,I) = ZERO
 2    CONTINUE
C
      IK = 0
      I1 = NVCHAN+IP
      DO 31 I=I1,I1+ICUP
      DO 3 J=1,NLEG
      ROOTF=DSQRT((Dble(2*J-1))/RA)
      IK=IK+1
      AMPA(KK,I) = AMPA(KK,I)+VECTO(IK)*ROOTF
 3    CONTINUE
 31   continue
C
      IK = -NLEG
      IPQ = (IP-1)*NVCHAN
      DO 62 I=1,NCUP(IP)
      IK = IK+NLEG
      DO 61 L=1,NVCHAN
      IPQ = IPQ+1
      DO 6 J=1,NLEG
      AMPA(KK,L) = AMPA(KK,L)+VECTO(IK+J)*PINT(J,IPQ)
 6    CONTINUE
 61   continue
 62   continue
C
C      OPTIONAL OUTPUT OF SURFACE AMPLITUDES
C
      IF(LBUG.LT.2) GO TO 1
      WRITE(IWRITE,1004) kk,RA
      WRITE(IWRITE,1001) (AMPA(KK,I),I=1,NVCHAN+NPOLE)
C
 1    CONTINUE
      IDIAG = IDIAG+NHDP*(NHDP+1)/2
 10   CONTINUE
C
 1000 FORMAT(//' SUBROUTINE VHDIAG'/' ----------------- ')
 1001 FORMAT(1X,8F14.7)
 1002 FORMAT(/5X,'Eigenvalues in Rydberg for pole',i3/(1X,8F14.7))
 1003 FORMAT(/5X,'EIGENVECTOR',I5/)
 1004 FORMAT(/5X,'AMPLITUDE',I4,' AT=',F10.5,3X,'au')
C
      RETURN
      END
      SUBROUTINE DISINI(IREAD,IWRITE,RMASS,EBASE,NDIS,ND2,MDMAX,CF,
     1 RBOX,RMAX,EDIS,ITRG,LBUG,IFAIL)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C      DISINI INITIALIZES CALCULATION IN DISSOCIATING CHANNELS
C
C***********************************************************************
C
      PARAMETER (LAMAX=6)
      DIMENSION EDIS(NDIS),ITRG(NDIS),CF(ND2,lamax),C(LAMAX)
C***********************************************************************
C
C     NAMELIST/DISDAT/ INPUT (One NAMELIST per dissociating state)
C       EINF = ASYMPTOTIC VALUE OF DISSOCIATION CURVE IN AU (ABSOLUTE)
C       C    = COEFFICIENTS OF MULTIPOLE EXPANSION OF POTENTIAL 
C              ( C(5) is coefficient of 1/R**6 etc.)
C       RA   = radius at which multipole expansion becomes valid
C       RE,D,DE,BETA are coefficients of intermediate range Morse potl
C       V(R) = D*(1.-exp(-BETA*(R-RE)))**2+DE
C
      NAMELIST/DISDAT/EINF,C,EPSD,RE,RA,BETA,D,DE
      DATA ZERO/0.D0/,TWO/2.D0/,RA,RE,BETA,D,DE/5*0.D0/,TOL/1.D-8/
C
      TWOM = TWO*RMASS
      EPSD = 1.D-8
      MDMIN = LAMAX
      MDMAX = 0
      RMAX = RBOX
      DO 10 I=1,ND2
      DO 1 K=1,LAMAX
      CF(I,K) = ZERO
 1    continue
 10   continue
C
      ISQ = 0
      NSQ = NDIS*(NDIS+1)/2
      DO 2 I=1,NDIS
      NLAM = 0
      LAMIN = 0
      DO 3 LAM=1,LAMAX
      C(LAM) = ZERO
 3    continue
      READ(IREAD,DISDAT)
C
C---- CHECK INPUT DATA
      IF(RA.GT.ZERO.AND.RA.GT.RBOX) THEN
        IMORSE = 1
        IF(ABS(RE*BETA).LT.TOL) THEN
          WRITE(IWRITE,99) RA,RE,BETA,D,DE
          IFAIL = 1
        ENDIF
      ELSE
        IMORSE = 0
      ENDIF
C
      DO 4 LAM=1,LAMAX
      IF(C(LAM).NE.0.) THEN
        NLAM=LAM
      ELSE IF(NLAM.EQ.0) THEN
        LAMIN = LAM+1
      ENDIF
 4    CONTINUE
      IF(LAMIN.GT.LAMAX) LAMIN = 0
      MDMIN = MIN(MDMIN,LAMIN)
      MDMAX = MAX(MDMAX,NLAM)
      RMAX = MAX(RMAX,RA)
C
      WRITE(IWRITE,9)I,EINF,LAMIN,NLAM,(C(LAM),LAM=1,NLAM)
 9    FORMAT(/' Input data for dissociating channel',I3,2X,'Energy',
     1F10.3/2I5,8F10.5)
      IF(IMORSE.GT.0) WRITE(IWRITE,100) RBOX,RA,RE,D,DE,BETA
C
      ISQ = ISQ+I
      ITRG(I) = I
      EDIS(I) = EINF-EBASE
      ILAM = 0
      DO 5 LAM=LAMIN,NLAM
      ILAM = ILAM+1
      CF(ISQ,ILAM) = TWOM*C(LAM)
 5    continue
      IPT = NSQ+6*(I-1)
      CF(IPT+1,1) = MDMIN
      CF(IPT+2,1) = RA
      CF(IPT+3,1) = RE
      CF(IPT+4,1) = TWOM*D
      CF(IPT+5,1) = TWOM*DE
      CF(IPT+6,1) = BETA
C
 2    CONTINUE
C
 100  FORMAT(' Morse potential used between,',F5.1,' and',F5.1,
     1 '  parameters',4D12.4)
 99   FORMAT(/' INCONSISTENT DISSOCIATION DATA',5D12.4)
      RETURN
      END
      SUBROUTINE TRANSD(NDIS,NPOLE,NHD,NSTAT,NCHAN,NCUP,COEFA0,LUBND,
     1BFORM,NBSET,AMPA,TWOM,IWRITE,IFAIL)
C
C***********************************************************************
C
C     TRANSD TRANSFORMS BOUNDARY AMPLITUDES AT R=AOUT RELATING TO
C      INTERIOR ELECTRONIC WAVEFUNCTIONS INTO CORRECTLY NORMALIZED
C      AMPLITUDES FOR DISSOCIATING CHANNELS
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER*(*) BFORM
      INTEGER GUTOT,STOT
      DIMENSION AMPA(NHD,NPOLE),A(NPOLE,ndis),COEFA0(NPOLE,NPOLE),
     1 WORK(npole),NCUP(NPOLE),NBSET(NDIS)
      DATA ZERO/0.D0/,ONE/1.D0/
C
      ROOT2M = SQRT(TWOM)
C
C----- READ TRANSFORMATION COEFFICIENTS FROM UNIT LUDIS
C      (THIS MUST BE CHECKED FOR MORE THAN ONE DISSOCIATING CHANNEL)
C
      DO 6 ID=1,NDIS
      IF(LUBND.NE.0) THEN
        CALL READBH(LUBND,NBSET,MGVN,STOT,GUTOT,NSTAT,RGEOM,NBOUND,RR,
     1  BFORM,IPRNT,IWRITE,IFAIL)
        IF(IFAIL.NE.0) RETURN
        CALL READBC(NSTAT,ETOT,A(1,ID))
      ELSE
        DO 11 I=1,NPOLE
        A(I,ID) = ZERO
 11     continue
        A(ID,ID) = ONE
      ENDIF
C
C----- TRANSFORM COEFFICIENTS OF COUPLED POLES
      II = 0
      DO 8 I=1,NPOLE
      IF(NCUP(I).EQ.1) GO TO 8
      II = II+1
      JJ = 0
      SUM = ZERO
      DO 9 J=1,NPOLE
      IF(NCUP(J).EQ.1) GO TO 9
      JJ = JJ+1
      SUM = SUM+COEFA0(II,JJ)*A(J,ID)
 9    CONTINUE
      WORK(II) = SUM
 8    CONTINUE
      II = 0
      DO 10 I=1,NPOLE
      IF(NCUP(I).EQ.1) GO TO 10
      II = II+1
      A(I,ID) = WORK(II)
 10   CONTINUE
 6    CONTINUE
C
C----- CONSTRUCT AMPLITUDES NORMALIZED SO THAT SUPER R-MATRIX IS
C      SYMMETRIC
      DO 3 J=1,NHD
      DO 1 I=1,NDIS
      SUM = ZERO
      DO 2 K=1,NPOLE
      SUM = SUM+A(K,I)*AMPA(J,K)
 2    continue
      WORK(I) = ROOT2M*SUM
 1    continue
      DO 4 I=1,NDIS
      AMPA(J,I) = WORK(I)
 4    continue
 3    CONTINUE
C
      RETURN
      END
      SUBROUTINE SWAPPR(NGEOM,NCREF,NCHAN,NOCSF,NCROSS,NPLX,ICROSS,
     1EPOLE,WAMP,CIVEC,IGEOM,IWRITE)
C
C***********************************************************************
C
C     SWAPPR INTERCHANGES POLE POSITIONS AND BOUNDARY AMPLITUDES FOR
C            POLES WHICH ARE REQUIRED TO CROSS DIABATICALLY
C
C     NCROSS = NUMBER OF DIABATIC CROSSINGS
C     ICROSS(1,I) = SPECIFIES LABEL OF LOWER POLE AT CROSSING I
C     ICROSS(2,I) = LABEL OF GEOMETRY IMMEDIATELY PRECEDING CROSSING
C
C     IF IGEOM.LT.NCREF THEN THE POLE IP=ICROSS(1,I) IS
C       RELABELLED IP+1 FOR ALL GEOMETRIES IG=1,ICROSS(2,I) AND
C       POLE IP+1 RELABELLED IP CORRESPONDINGLY
C
C     IF IGEOM.GT.NCREF THEN POLE IP IS LABELLED IP+1 FOR
C      ALL GEOMETRIES IG=ICROSS(2,I)+1,NGEOM
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION EPOLE(NOCSF),WAMP(NCHAN,NOCSF),CIVEC(NOCSF,NOCSF),
     1ICROSS(2,NCROSS)
C
      IG = IGEOM
      IF(IG.LT.NCREF) THEN
        IC1 = 1
        IC2 = NCROSS
        IC3 = -1
      ELSE
        IC1 = NCROSS
        IC2 = 1
        IC3 = -1
      ENDIF
C
      DO 1 IC=IC1,IC2,IC3
      IP = ICROSS(1,IC)
      IP1 = IP+1
      LG = ICROSS(2,IC)
      IF((IC3.GT.0.AND.IG.GT.LG).OR.(IC3.LT.0.AND.IG.LE.LG)) GO TO 1
      IF(IG.EQ.1.OR.IG.EQ.NGEOM) WRITE(IWRITE,10) IP,IP1,LG,LG+1
      TEMP = EPOLE(IP)
      EPOLE(IP) = EPOLE(IP1)
      EPOLE(IP1) = TEMP
      DO 2 I=1,NCHAN
      TEMP = WAMP(I,IP)
      WAMP(I,IP) = WAMP(I,IP1)
      WAMP(I,IP1) = TEMP
 2    CONTINUE
      IF(IP.LE.NPLX) THEN
        DO 4 J=1,NOCSF
        TEMP = CIVEC(J,IP)
        CIVEC(J,IP) = CIVEC(J,IP1)
        CIVEC(J,IP1) = TEMP
 4      continue
      ENDIF
 1    CONTINUE
C
 10   FORMAT(/' POLES',I3,' AND',I3,' CROSS DIABATICALLY BETWEEN GEOMETR
     1IES',I3,' AND',I3)
C
      RETURN
      END
      SUBROUTINE STACKM(N1,N2,NMAT,MC1,MC2,T1,T2,T3)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     STACKM stacks two symmetric matrices into the lower 
C     triangle of one larger one 
C
C***********************************************************************
C
      DIMENSION T1(*),T2(*),T3(*)
      DATA ZERO/0.D0/
C
      K1 = 0
      K2 = 0
      K = 0
C
      DO 6 L=1,NMAT
C
      IF(L.GT.MC1) THEN
        DO 31 I=1,N1
        DO 3 J=1,I
        K = K+1
        T3(K) = ZERO
 3      continue
 31     continue
      ELSE
        DO 41 I=1,N1
        DO 4 J=1,I
        K = K+1
        K1 = K1+1
        T3(K) = T1(K1)
 4      continue
 41     continue
      ENDIF
C
      DO 11 I=N1+1,N1+N2
      DO 1 J=1,N1
      K = K+1
      T3(K) = ZERO
 1    continue
 11   continue
      IF(L.GT.MC2) THEN
        DO 21 I=N1+1,N1+N2
        DO 2 J=N1+1,I
        K2 = K2+1
        K = K+1
        T3(K) = ZERO
 2      continue
 21     continue
      ELSE
        DO 51 I=N1+1,N1+N2
        DO 5 J=N1+1,I
        K2 = K2+1
        K = K+1
        T3(K) = T2(K2)
 5      continue
 51     continue
      ENDIF
C
 6    CONTINUE
C
      RETURN
      END
      SUBROUTINE VRMAT1(NPL,NVCH,NCHAN,NVIB,NBASIS,NCUP,NQUAD,ICHL,A,B,
     1BBLOCH,TWOM,KNOTS,RK,CKE,CKW,LBUG,IWR,AMPA,EIGEN,VPOTL)
C
C***********************************************************************
C
C    VRMAT1:  ENERGY INDEPENDANT ENTRY TO NUCLEAR R-MATRIX CODE
C
C***********************************************************************
C
C      INPUT PARAMETERS ARE
C
C      NPL    = NUMBER OF ELECTRONIC R-MATRIX POLES TO BE INCLUDED
C      NCH    = NUMBER OF SCATTERING CHANNELS
C      A      = STARTING RADIUS
C      B      = FINAL RADIUS
C      NQUAD  = NUMBER OF QUADRATURE POINTS. IF NQUAD EVEN THEN GAUSS-
C               LEGENDRE USED, ELSE SIMPSONS RULE
C      NBASIS = THE NUMBER OF LEGENDRE BASIS FUNCTIONS TO BE USED.
C               IF IT IS SET TO ZERO OR IS GREATER THAN THE CURRENT
C               MAXIMUM MLEG (SEE BELOW) THEN IT IS SET TO MLEG.
C      NCUP   = COUPLING FLAGS ( SEE MAIN ROUTINE)
C      BBLOCH = PARAMETER IN BLOCH OPERATOR (USUALLY SET TO ZERO)
C      KNOTS  = NUMBER OF KNOTS IN SPLINE
C      RK     = RADII OF KNOTS
C      CK     = SPLINE COEFFS
C      LBUG   = ARRAY HOLDING DEBUG PRINT SWITCHES (SEE BELOW)
C      IWR    = LOGICAL UNIT NUMBER OF OUTPUT DEVICE
C      AMPA   = SURFACE AMPLITUDES
C      EIGEN  = EIGENVALUES OF THE HAMILTONIAN MATRICES 
C      VPOTL  = NAME OF SUBPROGRAM WHICH GENERATES THE POTENTIAL
C               MATRIX. SEE BELOW.
C
C***********************************************************************
C
C      DEBUG PRINT SWITCHES ARE
C
C      LBUG(1)=1...FOR RADII AT WHICH THE POTENTIAL MATRIX IS EVALUATED
C                  AND NUMBER OF BASIS FUNCTIONS USED
C      LBUG(1)=2...AS ABOVE BUT ROUTINE EXITS WITH THE RADII STORED
C                  IN ARRAY EIGEN BUT WITHOUT CARRYING OUT ANY
C                  FURTHER CALCULATIONS.
C      LBUG(2)=1...FOR HAMILTONIAN MATRIX ELEMENTS IN SUBROUTINE
C                  SETMTR, OVERLAPS BETWEEN INHOMOG TERMS AND
C                  PRIMITIVE BASIS IN ROUTINE SETRHS, AND EIGENVALUES 
C                  IN SUBROUTINE AMPLTD
C      LBUG(3)=2...AS ABOVE PLUS EIGENVECTORS AND SURFACE AMPLITUDES
C                  IN SUBROUTINE AMPLTD
C
C***********************************************************************
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION NCUP(NPL),RK(*),CKE(KNOTS*NPL),LBUG(2),
     1 CKW(KNOTS*NVCH*NPL),ICHL(NCHAN),AMPA((NPL+NVCH)*NQUAD*NPL),
     2 EIGEN(NQUAD*NPL),rmesh(nquad),wts(nquad),wamp(NQUAD*nchan*npl),
     * potl(npl*npl*nquad)
      double precision, allocatable :: pl(:),dpl(:),bigv(:),pint(:)
C
      NPOLE = NPL
      NVCHAN= NVCH
      IWRITE = IWR
      IF(MOD(NQUAD,2).EQ.0) THEN
        IXMAX = NQUAD/2
      ELSE
        IXMAX = (NQUAD+1)/2
      ENDIF
      MLEG = 2*IXMAX
C
C      CHECK NUMBER OF BASIS FUNCTIONS TO BE USED
C
      IF(NBASIS.LE.0.OR.NBASIS.GT.MLEG) THEN
        NLEG = MLEG
      ELSE
        NLEG = NBASIS
      ENDIF
      allocate (pl(ixmax*nleg),dpl(ixmax*nleg))
C
C      INITIALIZE DEBUG PRINTS
      IF(LBUG(1).GT.0)WRITE(IWRITE,20) A,B,NLEG
C
      RA1 = A
      RA2 = B
      NHD = NPOLE*NLEG
      NHSIZE = NHD*(NHD+1)/2
      NAMP = NHD*NQUAD
C
C      EVALUATE NORMALIZED LEGENDRE POLYNOMIALS AND THEIR
C      DERIVATIVES AT THE ABSCISSAE OF THE QUADRATURE SCHEME
C
      CALL VMESH(RA1,RA2,NQUAD,RMESH,WTS)
C
      CALL LEGNDD(PL,DPL,RMESH,NLEG,IXMAX,RA1,RA2)
C
C     SET UP POTENTIAL MATRIX
C
C     THIS IS STORED AS AN (NPOLE*NPOLE*NQUAD) ARRAY
C     THE NUMBER OF MESH POINTS (NQUAD) AND THEIR RADII ARE GENERATED
C     BY SUBROUTINE MESH. (THEY CANNOT BE CHOSEN BY THE MAIN PROGRAM)
C
      IF(LBUG(1).NE.0) WRITE(IWRITE,24)(rmesh(I),I=1,NQUAD)
      IF(LBUG(1).EQ.2) RETURN
C
      CALL VPOTL(NPOLE,NQUAD,RMESH,potl,KNOTS,RK,CKE)
C
C      SET UP MATRIX ELEMENTS OF THE HAMILTONIAN IN ARRAY BIGV.
C
      allocate (bigv(nhsize))
c
      CALL VHMAT(NPOLE,NLEG,RA1,RA2,BIGV,NQUAD,WTS,PL,DPL,potl,BBLOCH,
     * TWOM,NCUP,IWRITE,LBUG(2))
C
C      INTERPOLATE FIXED-NUCLEI BOUNDARY AMPLITUDES ON INTEGRATION MESH
C
      CALL INTERP(NCHAN*NPOLE,NQUAD,RMESH,WAMP,KNOTS,RK,CKW)
C
C      EVALUATE OVERLAP INTEGRALS BETWEEN BOUNDARY AMPLITUDES,
C      VIBRATIONAL WAVEFUNCTIONS AND PRIMITIVE BASIS FUNCTIONS
C
      allocate (pint(nleg*npole*nvchan))
      CALL VPAMP(NPOLE,NCHAN,NVIB,ICHL,NLEG,PINT,NQUAD,RMESH,WTS,PL,
     * WAMP,IWRITE,LBUG(2))
C
C      DIAGONALIZE THE HAMILTONIAN AND EVALUATE THE SURFACE AMPLITUDES
C      STORING THEM IN MATRIX AMPA AND THE EIGENVALUES IN ARRAY EIGEN.
C      IT ALSO COMBINES PRIMITIVE OVERLAP INTEGRALS INTO INTEGRALS
C      OF PRODUCTS OF BOUNDARY AMPLITUDES, VIBRATIONAL WAVEFUNCTIONS 
C      AND EIGENVECTORS
C
      RA12 = RA2-RA1
      CALL VHDIAG(NPOLE,NVCHAN,NLEG,RA12,BIGV,AMPA,EIGEN,NCUP,
     1 PINT,IWRITE,LBUG(2))
C
      deallocate (pl,dpl,bigv,pint)
      RETURN
C
C      FORMAT STATEMENTS
C
 20   FORMAT(/' Nuclear R-matrix calculation: initial radius=',F10.5,3X
     1,' final radius=',F10.5,' Number of terms in Legendre basis =',I3)
 24   FORMAT(' The potential matrix is evaluated at the following radii'
     1/(12F10.4))
C
      END
      SUBROUTINE VHMAT(NPOLE,NLEG,RA1,RA2,HMLT,NPTS,WTS,PL,DPL,V,
     1BBLOCH,TWOM,NCUP,IWRITE,LBUG)
C
C***********************************************************************
C
C     SETMTR SETS UP THE HAMILTONIAN MATRIX ON A GIVEN SUBRANGE
C
C     INPUT PARAMETERS ARE
C      RA1,RA2, THE RADII OF THE END POINTS OF THE SUBRANGE
C      XI,WTS, THE ABSCISSAE AND WEIGHTS FOR THE QUADRATURE
C      PL, NORMALIZED BASIS FUNCTIONS (LEGENDRE POLYNOMIALS)
C          EVALUATED AT THE ABSCISSAE OF THE QUADRATURE SCHEME
C      V, THE SYMMETRIC 'POTENTIAL' MATRIX EVALUATED AT THE ABSCISSAE
C      W, THE ANTISYMMETRIC 'POTENTIAL' MATRIX
C      BBLOCH, PARAMETER IN BLOCH OPERATOR
C      LBUG, SWITCH FOR DEBUG OUTPUT
C
C     OUTPUT PARAMETER IS
C      HMLT, THE UPPER TRIANGLE OF THE HAMILTONIAN MATRIX
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION V(NPOLE,NPOLE,*),HMLT(*),NCUP(NPOLE),WTS(*),
     1PL(NLEG,*),DPL(NLEG,*)
      DATA ZERO,ONE,TWO/0.D0,1.D0,2.D0/
C
      IF(LBUG.EQ.1) WRITE(IWRITE,1000)
C
      NHS = 0
      IXMAX2 = NPTS+1
      IXMAX = NPTS/2
      IF(2*IXMAX.NE.NPTS) IXMAX=IXMAX+1
      R12 = ONE/(RA2-RA1)
      DX  = TWO*R12
      R1B = ZERO
      R2B = ZERO
      IF(BBLOCH.NE.ZERO) R1B = R12*BBLOCH/RA1
      IF(BBLOCH.NE.ZERO) R2B = R12*BBLOCH/RA2
      RSQ = R12*DX
C
C      LOOP OVER THE FIRST INDEX ON CHANNELS
C
      DO 31 I=1,NPOLE
C
C      LOOP OVER THE FIRST INDEX ON LEGENDRE POLYNOMIALS
      DO 3 NN=1,NLEG
C
C      LOOP OVER THE SECOND INDEX ON CHANNELS
C
      DO 5 J=I,NPOLE
C
C      LOOP OVER THE SECOND INDEX ON LEGENDRE POLYNOMIALS
C
      M1 = 1
      IF(I.EQ.J) M1=NN
      DO 6 MM=M1,NLEG
C
      JMN = MOD(MM+NN,2)+1
      SGN = (-1)**JMN
C
C      CALCULATE CONTRIBUTION TO DIAGONAL MATRIX ELEMENTS WHICH DO NOT
C      INCLUDE THE POTENTIAL USING CLOSED FORM EXPRESSIONS
C
      IF(I.EQ.J) THEN
        ROOTMN = DSQRT((TWO*Dble(NN)-ONE)*(TWO*Dble(MM)-ONE))
        DIAG = -ROOTMN*(R2B+SGN*R1B)
        IF(JMN.EQ.1) DIAG=DIAG+RSQ*ROOTMN*Dble(NN*(NN-1))
        SUM1 = DIAG*TWOM
      ELSE
        SUM1 = ZERO
      ENDIF
C
C      CALCULATE THE MATRIX ELEMENTS OF THE POTENTIAL USING NUMERICAL
C      QUADRATURE.
C
      IF(I.EQ.J.OR.(NCUP(I).GT.1.AND.NCUP(J).GT.1)) THEN
        DO 17 IX=1,IXMAX
        SUM1 = SUM1+WTS(IX)*PL(MM,IX)*PL(NN,IX)*(V(I,J,IXMAX2-IX)
     1  -SGN*V(I,J,IX))
   17   CONTINUE
C
        NHS=NHS+1
        HMLT(NHS) = SUM1
      ENDIF
C
    6 CONTINUE
    5 CONTINUE
    3 CONTINUE
 31   continue
C
C      DEBUG OUTPUT
C
      IF(LBUG.EQ.0) GO TO 11
      WRITE(IWRITE,1001) NHS
      WRITE(IWRITE,1002)
      WRITE(IWRITE,1003) (HMLT(NV),NV=1,NHS)
 1000 FORMAT(//' SUBROUTINE VHMAT'/' -----------------')
 1001 FORMAT(/5X,' HAMILTONIAN ARRAY SIZE=',I5/)
 1002 FORMAT(/5X,' HAMILTONIAN MATRIX ELEMENTS'/)
 1003 FORMAT(1X,8F14.7)
C
 11   RETURN
C
      END
      SUBROUTINE LEGNDD(PL,DPL,R,NLEG,IXMAX,A,B)
C
C***********************************************************************
C
C     LEGNDD COMPUTES NORMALIZED LEGENDRE POLYNOMIALS AND THEIR
C     DERIVATIVES AT THE ABSCISSAE OF THE QUADRATURE SCHEME
C
C     INPUT PARAMETERS ARE
C      NLEG, MAXIMUM NUMBER OF LEGENDRE POLYNOMIALS IN THE BASIS
C      IXMAX, THE NUMBER OF ABSCISSAE
C      XI, AN ARRAY HOLDING THE ABSCISSAE
C
C     OUTPUT PARAMETERS ARE
C      PL, AN ARRAY HOLDING THE VALUES OF THE POLYNOMIALS
C      DPL, AN ARRAY HOLDING VALUES OF THEIR DERIVATIVES
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION PL(NLEG,IXMAX),DPL(NLEG,IXMAX),R(IXMAX)
      DATA ZERO,ONE,TWO,THREE/0.D0,1.D0,2.D0,3.D0/
C
      DX = ONE/(B-A)
      C = TWO*DX
      D = (B+A)*DX
      ANORM = SQRT(DX)
      TNORM = SQRT(THREE*DX)
C
C      LOOP OVER ABSCISSAE
C
      DO 11 I=1,IXMAX
C
      X = C*R(I)-D
C
      PL(1,I) = ANORM
      PL(2,I) = TNORM*X
      DPL(1,I) = ZERO
      DPL(2,I) = TNORM
C
C      GENERATE REMAINING POLYNOMIALS, UP TO ORDER NLEG-1, USING
C      RECURSION RELATION
C
      DO 1 K=2,NLEG-1
      K1=K-1
      PL(K+1,I) = (SQRT(TWO*K1+ONE)*X*PL(K,I)-K1*PL(K1,I)/
     1SQRT(TWO*K1-ONE))*SQRT(TWO*K+ONE)/dble(K)
      DPL(K+1,I) = (SQRT(TWO*K1+ONE)*PL(K,I)+DPL(K1,I)/SQRT(TWO*K1-ONE))
     1*SQRT(TWO*K+ONE)
C
    1 CONTINUE
 11   continue
C
      RETURN
      END
      SUBROUTINE VPAMP(NPOLE,NCHAN,NVIB,ICHL,NLEG,PINT,NQUAD,RQUAD,
     1 WTS,PL,WAMP,IWRITE,LBUG)
C
C***********************************************************************
C
C     VPAMP evaluates integrals of products of the boundary amplitudes,
C     vibrational wavefunctions and Legendre polynomials
C
C     INPUT PARAMETERS ARE
C      WTS, THE WEIGHTS FOR THE QUADRATURE
C      PL, NORMALIZED BASIS FUNCTIONS (LEGENDRE POLYNOMIALS)
C          EVALUATED AT THE ABSCISSAE OF THE QUADRATURE SCHEME
C      VFN, THE TARGET VIBRATIONAL WAVEFUNCTION EVALUATED ON THE MESH
C      WAMP, THE ELECTRONIC R-MATRIX BOUNDARY AMPLITUDES
C      LBUG, SWITCH FOR DEBUG OUTPUT
C
C     OUTPUT PARAMETER IS
C     PINT, THE MATRIX OF INTEGRALS
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION ICHL(NCHAN),RQUAD(NQUAD),WAMP(NQUAD,NCHAN,NPOLE),
     2 ICHV(NVIB),WTS(*),PL(NLEG,*),PINT(*),ev(nvib),nv(nvib),
     * vfn(nquad,nvib)
      DATA ZERO,ONE/0.D0,1.D0/
C
      IF(LBUG.EQ.1) WRITE(IWRITE,1000)
c
C     Get vibrational wavefunctions on integration mesh
C
      CALL RVIBR(NVIB,NQUAD,EV,ICHV,NV,VFN,x,RQUAD)
C
      IXMAX2 = NQUAD+1
      IXMAX = NQUAD/2
      IF(2*IXMAX.NE.NQUAD) IXMAX=IXMAX+1
C
      I = 0
      DO 32 IP=1,NPOLE
      DO 31 NU=1,NVIB
      DO 3 J=1,NCHAN
      IF(ICHV(NU).EQ.ICHL(J)) THEN
C
C      LOOP OVER THE INDEX ON LEGENDRE POLYNOMIALS
C
        SGN = -ONE
        DO 13 MM=1,NLEG
        I = I+1
        SGN = -SGN
        SUM1=ZERO
C
C      CALCULATE THE INTEGRALS USING NUMERICAL QUADRATURE.
C
        DO 17 IX=1,IXMAX
        SUM1 = SUM1+WTS(IX)*PL(MM,IX)*
     1  (vfn(IXMAX2-IX,nu)*WAMP(IXMAX2-IX,J,IP)+SGN*vfn(IX,nu)*
     2   WAMP(IX,J,IP))
 17     CONTINUE
C
C      STORE THE FINAL RESULT IN ARRAY 'PINT'
C
        PINT(I) = SUM1
 13     continue
C
      ENDIF
C
 3    CONTINUE
 31   continue
 32   continue
      NWAMP = I
C
C      DEBUG OUTPUT
C
      IF(LBUG.NE.0) THEN
        WRITE(IWRITE,1002)
        WRITE(IWRITE,1003) (PINT(K),K=1,NWAMP)
      ENDIF
 1000 FORMAT(//' SUBROUTINE VPAMP'/' -----------------')
 1002 FORMAT(/5X,' INTEGRAL MATRIX ELEMENTS'/)
 1003 FORMAT(1X,8F14.7)
C
      RETURN
      END
      SUBROUTINE VPOTL(NPOLE,NPTS,R,V,KNOTS,RK,CKE)
C
C***********************************************************************
C
C      POTLMX SETS UP POTENTIALS FOR USE IN VPROP USING SPLINE
C      INTERPOLATION ON MESH R(IR),IR=1,NPTS USING NAG ROUTINES E02BBF
C      AND E02BCF.  IT ASSUMES THAT THE SPLINE COEFFICIENTS HAVE BEEN
C      PREVIOUSLY SET UP IN ARRAY CK BY NAG ROUTINE E02BAF
C      V IS SYMMETRIC MATRIX, W ANTISYMMETRIC (SEE NOTES)
C
C      NCUP  = COUPLING FLAGS
C      NC    = POINTER TO SPLINE COEFFS FOR CI VECTORS
C      KNOTS,RK,CK MUST BE AS PREVIOUSLY DEFINED FOR E02BAF
C      S IS WORK SPACE
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION R(NPTS),V(NPOLE,NPOLE,NPTS),RK(KNOTS),CKE(KNOTS,NPOLE)
      DATA IFAIL,IWRITE/0,6/
C
      DO 5 IR=1,NPTS
C
      K = 0
C    The following line is a warning that should be removed once E02BBF
C    is replaced (and the line startign !NV03 uncommented).
      WRITE(IWRITE,*) 'NAG routine not replaced. Spline procedure not
     1 working in this version of the code'
      DO 41 J=1,NPOLE
      DO 4 I=1,NPOLE
      K = K+1
C
C----- INTERPOLATE ENERGY MATRIX
!NV03      CALL E02BBF(KNOTS,RK,CKE(1,K),R(IR),ER,IFAIL)
      V(I,J,IR) = ER
 4    CONTINUE
 41   continue
 5    CONTINUE
C
      RETURN
      END
