! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE T_MATRX(IFAIL)
C
C***********************************************************************
C
C     TMATRX calculates T-matrices from K-matrices
C      It is intended to be a self contained module which can be
C      run independantly from the main scattering calculation.
C      On exit, IFAIL=0 indicates succesful termination, else IFAIL=1
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXPTS=50,MAXERN=10,MAXTGT=1000)
      CHARACTER(LEN=80) NAME
      DIMENSION NKSET(MAXPTS),R(MAXPTS),NESCAT(MAXERN),
     1 EINC(2*MAXERN),Etemp(maxtgt),IPRNT(6),NVTARG(MAXTGT),
     * STARG(MAXTGT),MTARG(MAXTGT),
     2 GTARG(MAXTGT),ETARG(MAXTGT),itgord(maxtgt*maxpts),nchset(maxpts)
      integer, allocatable :: ivtarg(:),ivnu(:),ichst(:),ichord(:),
     * mvi(:),mvj(:),mvd(:),ivstg(:),ivmtg(:),ivgtg(:)
      integer, allocatable, target :: ichl(:),lchl(:),mchl(:),ivchl(:),
     * lvchl(:),mvchl(:)
      double precision, allocatable :: evib(:),tmr(:),tmi(:),tvr(:),
     * tvi(:),echl(:),evchl(:)
      double precision, allocatable, target :: enscat(:),entemp(:)
      double precision, pointer :: pen(:)
c
      CHARACTER(LEN=11) KFORM,TFORM,CFORM,VCFORM,MODDAT
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=1) IKFORM,ITFORM,ICFORM,IVCFRM
      CHARACTER(LEN=4) CEUNIT(2)
      CHARACTER(LEN=8) BLANK
      CHARACTER(LEN=20) DAYTIM
      INTEGER STOT,GUTOT,STARG,GTARG
      COMMON/INTFS/ NCHAN,ION,NVIB,NDIS,IWRITE,MGVN,STOT,GUTOT
C
C***********************************************************************
C
C     Basic data is input via namelist /TMATIN/
C      EMIN     = MINIMUM REQUIRED SCATTERING ENERGY 
C      EMAX     = MAXIMUM REQUIRED SCATTERING ENERGY
C      IEUNIT   = UNITS IN WHICH THESE ENERGIES ARE INPUT, 1= RYD, 2= EV
C      ICFORM   = 'F' IF LUCHAN IS FORMATTED, ELSE 'U'
C      IKFORM   = 'F' IF LUKMT IS FORMATTED, ELSE 'U'
C      IVCFRM   = 'F' if LUVCHN is formatted, else 'U'
C      IPRNT    = Print switches
C      ITFORM   = 'F' IF LUTMT IS FORMATTED, ELSE 'U'
C      ITGORD   =
C      IWRITE   = LOGICAL UNIT FOR PRINTED OUTPUT
C      LUCHAN   = LOGICAL UNIT FOR CHANNEL AND TARGET DATA
C      LUKMT    = LOGICAL UNIT FOR K-MATRIX input
C      LUTMT    = LOGICAL UNIT FOR T-MATRIX OUTPUT
C      LUVCHN   = Logical unit for vibrational channel output
C      MAXI     = LABEL OF HIGHEST INITIAL STATE FOR WHICH T-matrices
C                 are required
C      MAXF     = LABEL OF HIGHEST FINAL STATE FOR WHICH T-matrices
C                 are required (it is assumed that MAXF.ge.MAXI)
C      NAVGE    = 0 NO AVERAGING of T-matrices
C               = 1 T-MATRICES ARE ADIABATICALLY AVERAGED 
C      NGEOM    = NUMBER OF GEOMETRIES TO BE USED IN ADIABATIC AVERAGE
C      NCHSET   = SET NUMBERs OF CHANNEL DATA 
C      NKSET    = SET NUMBERS OF K-MATRIX INPUT
C      NREQ     = R(NREQ) IS THE EQUILIBRIUM BOND LENGTH
C      NQUAD    = Number of quadrature points to be used in adiabatic
C                 averaging
C      NTSET    = SET NUMBER FOR T-MATRIX OUTPUT
C      NVCSET   = Set number for vibrational channel output
C      NVTARG   = Number of vibrational levels for each electronic
C                 state
C      R        = BOND LENGTHS OF GEOMETRIES TO BE USED IN ADIABATIC
C                 AVERAGE
C      NAME     = TITLE FOR ANY OUTPUT
C
      NAMELIST/TMATIN/LUKMT,IEUNIT,IWRITE,MAXI,MAXF,NAME,R,NAVGE,NGEOM,
     1EMIN,EMAX,LUTMT,NTSET,LUCHAN,NCHSET,ICFORM,IKFORM,ITFORM,IPRNT,
     2NKSET,NQUAD,NVTARG,NVCSET,LUVCHN,IVCFRM,NREQ,itgord
C
C***********************************************************************
C
      DATA LUKMT/19/,IEUNIT/1/,LUTMT/12/,CEUNIT/' RYD',' EV '/
     1,NAVGE/0/,NTSET/1/,BLANK/'        '/,NGEOM/1/,
     5LUCHAN/10/,IPRNT/6*0/,NQUAD/201/,NVTARG/MAXTGT*0/,
     2LUVCHN/28/,NVCSET/1/,MAXI,MAXF/1,0/,NREQ/1/,
     3vbig/1.D+8/,ICFORM,IVCFRM,IKFORM,ITFORM/4*'U'/
      DATA ZERO/0.D0/,RYD/0.073500D0/
      DATA FORM/'FORMATTED'/
      DATA MODDAT/'16-Nov-1998'/
C
      IFAIL = 0
      k = 0
      DO 41 I=1,MAXPTS
      R(I) = ZERO
      NKSET(I) = I
      nchset(i) = i
      do 4 j=1,maxtgt
      k = k+1
      itgord(k) = 0
 4    continue
 41   continue
      IWRITE = 6
      emin = zero
      emax = vbig
      KFORM = FORM
      TFORM = FORM
      CFORM = FORM
      VCFORM = FORM
C
C---- Read basic data via namelist /TMATIN/
      READ(5,TMATIN)
      IF(ICFORM.EQ.'U') CFORM='UN'//FORM
      IF(IKFORM.EQ.'U') KFORM='UN'//FORM
      IF(ITFORM.EQ.'U') TFORM='UN'//FORM
      IF(IVCFRM.EQ.'U') VCFORM='UN'//FORM
C
C---- Date stamp run and print title
      CALL DATEST(DAYTIM)
      NAME(61:) = DAYTIM
      WRITE(IWRITE,100)MODDAT,NAME
C
      WRITE(IWRITE,11)CFORM,LUCHAN,(NCHSET(ig),ig=1,ngeom)
      WRITE(IWRITE,32)KFORM,LUKMT,(NKSET(IG),IG=1,NGEOM)
      WRITE(IWRITE,33)TFORM,LUTMT,NTSET
      IF(NGEOM.GT.1) WRITE(IWRITE,21)VCFORM,LUVCHN,NVCSET
C      
C---- Find first set of K-matrices and read dimension information
      IF(NGEOM.GT.1) WRITE(IWRITE,101)
      NERANG = MAXERN
      CALL READKH(LUKMT,NKSET(NREQ),MGVN,STOT,GUTOT,NCHAN,NVIB,NDIS,
     1NTARG,ION,NERANG,NESCAT,EINC,R(NREQ),NAPPR,KFORM,IWRITE,IPRNT(1),
     2IFAIL)
      IF(IFAIL.NE.0) RETURN
      REWIND LUKMT
C
C---- DECIDE HOW MANY initial and FINAL STATES ARE REQUIRED
      NVIBD = NVIB+NDIS
      IF(NVIBD.EQ.0) NVIBD = NTARG
      IF(MAXI.EQ.1) THEN
        MXI = 1
      ELSE 
        IF(NAVGE.EQ.1) THEN
          NV = 0
          DO 5 I=1,NTARG
          NV = NV+NVTARG(I)
          MXI = I
          IF(NV.GE.MAXI) GO TO 15
 5        CONTINUE
        ELSE
          MXI = MAXI
        ENDIF
      ENDIF
 15   IF(MAXF.EQ.0) THEN
        MXF = NVIBD
        IF(NAVGE.EQ.0) THEN
          MAXF  = NVIBD
        ELSE
          DO 7 I=1,NTARG
          MAXF = MAXF+NVTARG(I)
 7        continue
        ENDIF
      ELSE 
        IF(NAVGE.EQ.1) THEN
          NV = 0
          DO 8 I=1,NTARG
          NV = NV+NVTARG(I)
          MXF = I
          IF(NV.GE.MAXF) GO TO 16
 8        CONTINUE
        ELSE
          MXF = MAXF
        ENDIF
      ENDIF
C
C----- Assign storage for energy independant data
 16   allocate (ivtarg(nvibd),ivnu(nvibd),ichst(nvibd))
      allocate (ichl(nchan),lchl(nchan),mchl(nchan),echl(nchan))   
C
C----- READ TARGET AND CHANNEL DATA
      NCHN = NCHAN
      NDIS0 = NDIS
      CALL READTC(LUCHAN,NCHSET(nreq),NCHN,NVIB,NDIS0,Nvibd,ION,
     1 IVTARG,IVNU,ICHL,LCHL,MCHL,ECHL,STARG,
     2 MTARG,GTARG,ETARG,R(NREQ),RMASS,CFORM,IWRITE,IPRNT(1),IFAIL)
      IF(NCHN.NE.NCHAN) THEN
        WRITE(IWRITE,92)
        IFAIL = 1
      ENDIF
      IF(IFAIL.NE.0) RETURN
C
C----- Set flag to denote approximation used
      IF(NAPPR.EQ.0.AND.NAVGE.EQ.0) THEN
        RR = R(NREQ)
      ELSE
        NAPPR = NAPPR+1
        RR = ZERO
      ENDIF
c
c---- Set up default ordering of electronic states if not already set
      if(itgord(1).eq.0) then
        if(nvib.eq.0) then
          k = 0
          do 91 i=1,ngeom
          do 9 j=1,ntarg
          k = k+1
          itgord(k) = j
 9        continue
 91      continue
         else
          do 10 j=1,nvib
          itgord(j) = j
 10       continue
        endif
      endif
C
C---- NETOT is total number of K-matrices held on LUKMT for each 
C     geometry
      NETOT = 0
      DO 6 I=1,NERANG
      NETOT = NETOT+NESCAT(I)
 6    continue
C
C---- Calculate number of scattering energies in the range [EMIN,EMAX]
C     and adjust NERANG,NESCAT and EINC accordingly
      IF(IEUNIT.EQ.2) THEN
        EMIN = RYD*EMIN
        EMAX = RYD*EMAX
      ENDIF
      CALL NEWE(EMIN,EMAX,NE,NERANG,NESCAT,EINC)
C
C----- Print out range of scattering energies
      IF(IEUNIT.EQ.2) THEN
        EMINP = EMIN/RYD
        EMAXP = EMAX/RYD
      ELSE
        EMINP = EMIN
        EMAXP = EMAX
      ENDIF
      WRITE(IWRITE,104) NE,EMINP,EMAXP,CEUNIT(IEUNIT)
C
C---- Decide which subset of the T-matrix should be saved,
c     it is assumed that maxchf.ge.maxchi in subsequent code 
      NVCHAN = NCHAN-NDIS
      NSTAT  = NVIBD-NDIS
      CALL CHSUB(NVCHAN,NSTAT,MXI,MXF,MAXCHI,MAXCHF,ICHL,ichst)
C
C----- Allocate space for K- and T-matrices
      allocate (ichord(maxchf),mvi(ne),mvj(ne),mvd(ne)) 
      LTMT = MAXCHI*(MAXCHF+NDIS)
      allocate (tmr(LTMT*NGEOM*NE),tmi(LTMT*NGEOM*NE),enscat(ne))
      if(ngeom.gt.1) allocate (entemp(ne))
C
C----- Loop over geometries if adiabatic averaging is required
      IF(NGEOM.GT.1) WRITE(IWRITE,102)
      DO 2 IG=1,NGEOM
C
C---- Read target and channel data
      NCHN = NCHAN
      NDIS0 = NDIS
      CALL READTC(LUCHAN,NCHSET(ig),NCHN,NVIB,NDIS0,NTARG,ION,IVTARG,
     1 IVNU,ICHL,LCHL,MCHL,ECHL,STARG,MTARG,GTARG,etemp,
     2 r(ig),RMASS,CFORM,IWRITE,-1,IFAIL)
      IF(NCHN.NE.NCHAN) THEN
        WRITE(IWRITE,92)
        IFAIL = 1
      ENDIF
      IF(IFAIL.NE.0) RETURN
c
C---- Read K-matrix headers
c
      CALL READKH(LUKMT,NKSET(IG),MGVN,STOT,GUTOT,NCHAN,NVIB,NDIS,NTARG,
     1ION,NERANG,NESCAT,etemp,R(IG),NAPPX,KFORM,IWRITE,IPRNT(1),IFAIL)
      if(ig.ne.nreq) then
        eminx = 0.
        emaxx = vbig
        pen => entemp
      else
        eminx = emin
        emaxx = emax
        pen => enscat
      endif
c
c---- Determine consistent ordering of channels to match target states
      call REORDC(ig,maxchf,ntarg,itgord,ichl,ichord,ichst)
C
C----- CALCULATE T-MATRICES AT ALL ENERGIES
c
      WRITE(IWRITE,116)
C
      CALL KTMAT(IG,NEK,NETOT,LUKMT,NGEOM,MAXCHI,MAXCHF,EMINX,EMAXX,
     * MAXVI,MAXVJ,MVI,MVJ,MVD,pen,TMR,TMI,ichord,KFORM,IPRNT(1))
C
      WRITE(IWRITE,117)
C
      IF(NEK.NE.NE) THEN
        IF(IG.EQ.nreq.AND.NEK.LT.NE) THEN
          WRITE(IWRITE,107) NEK,NE
          NE = NEK
        ELSE
          WRITE(IWRITE,108) NEK,NE
          IFAIL = 1
          RETURN
        ENDIF
      ENDIF
 2    CONTINUE
c
      IF(NGEOM.GT.1) then
        WRITE(IWRITE,103)
        if(iprnt(2).ne.0) call PRINTT(NE,NGEOM,maxchi,MAXCHF+ndis,
     1   iwrite,entemp,TmR,TmI,mvi,mvj)
      endif
C
C---- Calculate adiabatic average if required
      IF(NAVGE.EQ.1.AND.NGEOM.GT.1) THEN
        WRITE(IWRITE,115) (I,NVTARG(I),I=1,NTARG)
C
C---- Initialize calculation of vibrational wavefunctions
        MCHAN = MAX(MAXchI,MAXchf)
        NVIB = 0
        DO 25 I=1,NTARG
        NVIB = NVIB+NVTARG(I)
 25     CONTINUE
        allocate (evib(nvib))
        CALL VIBSET(MCHAN,NVIB,NTARG,NVCHAN,NVTARG,RMASS,ETARG,
     1  ICHL,EVIB,IWRITE,IPRNT(3))
C
C---- DEFINE VIBRATIONAL CHANNELS
c
        allocate (ivchl(nvchan),lvchl(nvchan),mvchl(nvchan),
     *  evchl(nvchan),ivstg(nvchan),ivmtg(nvchan),ivgtg(nvchan))
C
        CALL VCHAN(MCHAN,NTARG,LCHL,MCHL,ICHL,NVTARG,EVIB,
     1  IVCHL,LVCHL,MVCHL,EVCHL,starg,mtarg,gtarg,ivstg,
     2  ivmtg,ivgtg,0,ZERO)
C
C---- DECIDE WHICH SUBSET OF VIBRATIONALLY RESOLVED T-MATRIX to save
c
        CALL CHSUB(NVCHAN,NVIB,MAXI,MAXF,MAXCVI,MAXCVF,IVCHL,ichst)
C
        allocate (tvr(NE*MAXCVI*MAXCVF),tvi(NE*MAXCVI*MAXCVF))
C
        CALL VIBAVG(R,MAXI,MAXF,ICHL,NGEOM,MAXCHI,MAXCHF,MAXCVI,
     1  MAXCVF,EVIB,MVI,MVJ,NQUAD,NE,enscat,EVCHL,
     2  TMR,TMI,TVR,TVI,IVTARG,IVNU,IPRNT(4))
C
C---- WRITE NEW CHANNEL FILE CONTAINING DEFINITIONS OF VIBRONIC CHANNELS
c
        NCHAN = NVCHAN
        CALL WRITCH(LUVCHN,NVCSET,VCFORM,ZERO,RMASS,IVCHL,LVCHL,MVCHL,
     *  EVCHL,nvib,ivSTG,ivMTG,ivGTG,evib,IVTARG,IVNU,NAME,IPRNT(5),
     *  IFAIL)
        IF(IFAIL.NE.0) RETURN
C
C---- Write vibrational header to T-matrix file
        CALL WRITTH(LUTMT,NAME,NTSET,MAXCvI,MAXCvF,NE,NERANG,NESCAT,
     1  EINC,NAPPR,NTARG,IvCHL,LvCHL,MvCHL,EvCHL,RR,TFORM,IPRNT(6),
     *  IFAIL)
        IF(IFAIL.NE.0) RETURN
C
C---- Write vibrationally resolved T-matrices to unit LUTMT
        CALL WRITET(LUTMT,NE,MAXCvI,MAXCvF,MVI,MVJ,MVD,tvr,tvi,enscat)
C
        deallocate (ivstg,ivmtg,ivgtg)
      else
C
C---- Write header to T-matrix file
        CALL WRITTH(LUTMT,NAME,NTSET,MAXCHI,MAXCHF,NE,NERANG,NESCAT,
     1  EINC,NAPPR,NTARG,ICHL,LCHL,MCHL,ECHL,RR,TFORM,IPRNT(6),IFAIL)
        IF(IFAIL.NE.0) RETURN
C
C---- Write T-matrices to unit LUTMT
      CALL WRITET(LUTMT,NE,MAXCHI,MAXCHF,MVI,MVJ,MVD,TMR,TMI,enscat)
C
      ENDIF
      WRITE(IWRITE,106)
C
C----- Close files and return to main routine
      CLOSE(UNIT=LUCHAN,STATUS='KEEP')
      CLOSE(UNIT=LUKMT,STATUS='KEEP')
      CLOSE(UNIT=LUTMT,STATUS='KEEP')
      deallocate (tmr,tmi,enscat,ivtarg,ivnu,ichst,ichl,lchl,mchl,
     * echl)
      IF(NAVGE.EQ.1) then
        CLOSE(UNIT=LUVCHN,STATUS='KEEP')
        deallocate (ivchl,lvchl,mvchl,evchl,tvr,tvi,evib,entemp)
      endif
      RETURN
C
 92   FORMAT(/' *** DATA ON K-MATRIX FILE IS INCOMPATIBLE WITH CHANNEL D
     1ATA ***')
 11   FORMAT(/' Input datasets:',33X,'Unit  Set numbers'/
     1' Target and channel data     LUCHAN (',A11,')',I3,5X,30I3/
     235x,30i3)
 21   FORMAT(/' Vibrational channel data    LUVCHN (',A11,')',I3,5X,I3
     1/' Non-adiabatic R-matrix data LUNRMT (',A11,')',I3,5X,I3)
 32   FORMAT(/' K-matrices',18X,'LUKMT  (',A11,')',I3,5X,30I3/(35X,30I3)
     1)
 33   FORMAT(/' Output datasets:',32X,'Unit  Set number'/
     1' T-Matrices                  LUTMT  (',A11,')',I3,5X,I3)
 100  FORMAT('1',//' Program TMATRX  (last modified ',A,' )'//A/)
 101  FORMAT(/' ',120('-')//' Data for equilibrium geometry')
 102  FORMAT(/' ',120('-')//' Looping over geometries for adiabatic aver
     1age')
 103  FORMAT(/' ',120('-')//' End of geometry loop')
 104  FORMAT(/' T-matrices will be computed for ',I3,' energies in the K
     1-matrix file from',F8.4,' to',F8.4,A4)
 105  FORMAT(10A8)
 106  FORMAT(/' *** Task successfully completed ***')
 107  FORMAT(/' Number of energies',I4,' on K-matrix file is less than N
     1E =',I4,' computed from the header data'/' Task continuing with re
     2duced NE')
 108  FORMAT(/' Number of energies',I4,' on K-matrix file is incompatibl
     1e with NE =',I4,' computed from the header data'/' Task aborted')
 115  FORMAT(/' T-matrices will be adiabatically averaged'//' Number of
     1vibrational levels for each electronic state'/(' NVTARG(',I2,' ) =
     2',I3))
 116  FORMAT(/,'Calculating T-matrices...')
 117  FORMAT(/,'...all T-matrices have been calculated')
      END
      SUBROUTINE KTMAT(IG,NE,NETOT,LUKMT,NGEOM,MAXCHI,MAXCHF,EMIN,
     1 EMAX,MAXVI,MAXVJ,MVI,MVJ,MVD,ENRYD,TR,TI,ichord,KFORM,
     2 IPRNT)
C
C***********************************************************************
C
C     KTMAT reads K-matrices from unit LUKMT and calculates T-matrices 
C     at each energy
C     Only a submatrix of the complete T-matrix need be retained
C     LUKMT is assumed to have been previously positioned by a call to 
C     READKH 
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/INTFS/ NCHAN,ION,NVIB,NDIS,IWRITE,MGVN,STOT,GUTOT
      CHARACTER(LEN=11) KFORM
      INTEGER STOT,GUTOT
      DIMENSION MVI(*),MVJ(*),MVD(*),
     1 TR(NGEOM,MAXCHI,MAXCHF+NDIS,*),TI(NGEOM,MAXCHI,MAXCHF+NDIS,*),
     2 ichord(*),ENRYD(*)
      DATA ZERO/0.D0/,EPS/1.D-8/
c ZM All large automatic arrays should go on the heap and not on the stack.
c    Ideally, this should be done everywhere in the code...
      DOUBLE PRECISION, ALLOCATABLE :: AKMAT(:), WORKR(:), WORKI(:)
C
      IF(IPRNT.NE.0) WRITE(IWRITE,11)
C
      NE = 0
C
C---- Loop over entire K-matrix file, rejecting energies which lie
C     outside [EMIN,EMAX]
C
      ALLOCATE(AKMAT(nchan*(nchan+1)/2),workr(nchan*nchan),
     $         worki(nchan*nchan),STAT=IE)
      IF (IE .ne. 0) STOP "KTMAT: memory allocation error"
c
      DO 3 IE=1,NETOT
      CALL READKM(NOPEN,NDOPEN,NCHSQ,EN,AKMAT)
      IF(EN.LT.EMIN-EPS.OR.EN.GT.EMAX+EPS.or.nopen.eq.0) GO TO 3
      NE = NE+1
      ENRYD(NE) = EN
C
C----- CALCULATE T-MATRIX
      WRITE(IWRITE,12) EN,NOPEN
      CALL TMAT(NOPEN,AKMAT,WORKR,WORKI)
C
C---- Calculate dimensions of required submatrix
      MAXVI = MIN(NOPEN-NDOPEN,MAXCHI)
      MAXVJ = MIN(NOPEN-NDOPEN,MAXCHF)
      NDIF  = NOPEN-MAXVI
      MAXJD = MAXVJ+NDOPEN
      if(ig.eq.1) then
        MVI(NE) = MAXVI
        MVJ(NE) = MAXVJ
        MVD(NE) = NDOPEN
      else
        MVI(NE) = max(MAXVI,mvi(ne))
        MVJ(NE) = max(MAXVJ,mvj(ne))
        MVD(NE) = max(NDOPEN,mvd(ne))
      endif
c
c---- Clear out all of TR and TI
      do 71 j=1,maxchf
      do 7 i=1,maxchi
      TR(IG,I,J,NE) = zero
      TI(IG,I,J,NE) = zero
 7    continue
 71   continue
C
C---- Store submatrix, appending elements corresponding to dissociating
C     channels
      K = 1
      DO 4 J=1,MAXVJ
      DO 2 I=1,MAXVI
      TR(IG,ichord(I),ichord(J),NE) = WORKR(K)
      TI(IG,ichord(I),ichord(J),NE) = WORKI(K)
      K = K+1
 2    CONTINUE
      K = K+NDIF
 4    CONTINUE
      K = NOPEN*(NOPEN-NDOPEN)
      DO 5 J=MAXVJ+1,MAXJD
      DO 6 I=1,MAXVI
      TR(IG,ichord(I),J,NE) = WORKR(K)
      TI(IG,ichord(I),J,NE) = WORKI(K)
      K = K+1
 6    CONTINUE
      K = K+NDIF
 5    CONTINUE
C
 3    CONTINUE
C
C---- End of energy loop
C
      RETURN
C
 11   FORMAT(/' Input K-matrices')
 12   FORMAT('Energy, number of open channels:',f15.8,1X,i0)
      END
      SUBROUTINE REORDC(ig,nchan,ntarg,itgord,ichl,ichord,istart)
C
C***********************************************************************
C
C     REORDC sets up vector ICHORD which maps channel ordering at
C     geometry IG on to channel ordering of reference geometry. It uses
C     the corresponding vectors, ITGORD, for target data
C
C***********************************************************************
C
      DIMENSION itgord(ntarg,*),ichl(nchan),ichord(nchan),istart(*)
C
      it = ichl(1)
      ichord(1) = istart(itgord(it,ig))
      do 6 i=2,nchan
      if(it.eq.ichl(i)) then
        ichord(i) = ichord(i-1)+1
      else
        it = ichl(i)
        ichord(i) = istart(itgord(it,ig))
      endif
 6    continue
c
      RETURN
C
      END
      SUBROUTINE CHSUB(NCHAN,NTARG,MAXI,MAXF,MAXCHI,MAXCHF,ICHL,ISTART)
C
C***********************************************************************
C
C     CHSUB determines how many channels correspond to target states
C     labelled 1...MAXI and 1...MAXF (output in NCHTGT) and sets 
C     pointers (ISTART) to first channel belonging to a given target
C
C***********************************************************************
C
      DIMENSION ICHL(NCHAN),NCHTGT(NTARG),istart(ntarg)
C
C---- Count channels
      MAXCHI = 0
      MAXCHF = 0
      DO 1 J=1,NTARG
      NCHTGT(J) = 0
 1    continue
      DO 2 I=1,NCHAN
      J = ICHL(I)
      NCHTGT(J) = NCHTGT(J)+1
 2    continue
      DO 3 J=1,NTARG
      IF(J.LE.MAXI) MAXCHI = MAXCHI+NCHTGT(J)
      IF(J.LE.MAXF) MAXCHF = MAXCHF+NCHTGT(J)
 3    CONTINUE
C
c---- Set pointer to first channel corresponding to each target state
      it = ichl(1)
      istart(1) = 1
      do 4 i=2,nchan
      if(it.eq.ichl(i)) go to 4
      it = ichl(i)
      istart(it) = i
 4    continue
c
      RETURN
      END
      SUBROUTINE PRINTT(NE,NGEOM,MAXCHI,MAXCHF,iwrite,enryd,TR,
     1 TI,mvi,mvj)
C
C***********************************************************************
C
C     PRINTT prints the fixed nuclei T-matrices elements which are to b
C     adiabatically averaged
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION ENRYD(*),mvi(*),mvj(*),
     1 TR(NGEOM,MAXCHI,MAXCHF,*),TI(NGEOM,MAXCHI,MAXCHF,*)
C
      ntim = (ngeom-1)/10+1
      DO 3 IE=1,NE
      write(iwrite,10) enryd(ie)
      ig1 = -9
      do 22 it=1,ntim
      ig1 = ig1+10
      ig2 = ig1+min(9,ngeom-1)
      DO 21 J=1,mvj(ie)
      DO 2 I=1,mvi(ie)
      write(iwrite,1) (TR(IG,i,j,iE),ig=ig1,ig2)
 2    CONTINUE
 21   continue
 22   continue
      write(iwrite,11) enryd(ie)
      ig1 = -9
      do 42 it=1,ntim
      ig1 = ig1+10
      ig2 = ig1+min(9,ngeom-1)
      DO 41 J=1,mvj(ie)
      DO 4 I=1,mvi(ie)
      write(iwrite,1) (TI(IG,i,j,iE),ig=ig1,ig2)
 4    CONTINUE
 41   continue
 42   continue
C
 3    CONTINUE
C
      RETURN
C
 1    FORMAT(10e12.4)
 10   FORMAT(/' Real part of T-matrix for energy ',f10.4,' Ryd')
 11   FORMAT(/' Imaginary part of T-matrix for energy ',f10.4,' Ryd')
      END
      SUBROUTINE VIBAVG(R,MAXI,MAXF,ICHL,NGEOM,MAXCHI,MAXCHF,MAXCVI,
     1MAXCVF,EVIB,MVI,MVJ,NQUAD,NE,ESC,ECHL,TFIXR,TFIXI,TVIBR,TVIBI,
     2IVTARG,IVNU,IPRNT)
C
C***********************************************************************
C
C     VIBAVG calculates adiabatic average of T-matrices
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/INTFS/ NCHAN,ION,NVIB,NDIS,IWRITE,MGVN,STOT,GUTOT
      INTEGER STOT,GUTOT
      DIMENSION R(NGEOM),ICHL(NCHAN),IVTARG(NVIB),ECHL(NCHAN),
     1 MVI(NE),MVJ(NE),TFIXR(NGEOM*MAXCHI*MAXCHF,NE),IVNU(NVIB),ESC(NE),
     2 EVIB(NVIB),TFIXI(NGEOM*MAXCHI*MAXCHF,NE),TVIBR(MAXCVI,MAXCVF,NE),
     4 TVIBI(MAXCVI,MAXCVF,NE),rk(ngeom+4),wk(ngeom),wk1(ngeom),
     * rquad(nquad),wts(nquad),vfn(nquad*nvib),
     * tmr(MAXCHI*MAXCHF*nquad),tmi(MAXCHI*MAXCHF*nquad)
      double precision, allocatable :: ck(:),wk2(:)
      DATA NKNOT/0/,ZERO/0.D0/
C
C---- INITIALIZE SPLINE INTERPOLATION
      MAXKNT = NGEOM+4
c     (SPLINI should be rewritten to use automatic array)
c
      CALL SPLINI(NKNOT,KNOTS,RK,MAXKNT,NGEOM,R,IWRITE)
C
C---- SET UP QUADRATURE MESH
      CALL VMESH(R(1),R(NGEOM),NQUAD,RQUAD,WTS)
C
C---- GET VIBRATIONAL WAVEFUNCTIONS
      CALL RVIBR(NVIB,NQUAD,EVIB,IVTARG,IVNU,VFN,dummy,RQUAD)
      IF(IPRNT.NE.0) CALL CHECKQ(NQUAD,NVIB,WTS,VFN,IWRITE)
C
      MCHSQ= MAXCHI*MAXCHF
      allocate (ck(mchsq*knots),wk2(4*knots))
C
C---- LOOP OVER SCATTERING ENERGIES
C
      DO 1 IE=1,NE
C
      NCHSQ = MAXCHI*MVJ(IE)
C
C----- INTERPOLATE FIXED NUCLEI MATRICES ON QUADRATURE MESH
      CALL SPLINE(NCHSQ,NGEOM,KNOTS,RK,CK,R,TFIXR(1,IE),WK,WK1,WK2)
      CALL INTERP(NCHSQ,NQUAD,RQUAD,TMR,KNOTS,RK,CK)
      CALL SPLINE(NCHSQ,NGEOM,KNOTS,RK,CK,R,TFIXI(1,IE),WK,WK1,WK2)
      CALL INTERP(NCHSQ,NQUAD,RQUAD,TMI,KNOTS,RK,CK)
C
C---- Multiply fixed nuclei matrices by vibrational wavefunctions and
C     integrate
      CALL AVGT(NQUAD,WTS,MVI(IE),MVJ(IE),ICHL,IVTARG,TMR,TMI,MAXI,MAXF,
     * MAXCHI,MAXCHF,MAXCVI,MAXCVF,VFN,TVIBR(1,1,IE),TVIBI(1,1,IE))
C     
      DO 2 I=1,MAXCVF
      IF(ESC(IE).GT.ECHL(I)) GO TO 2
      DO 4 J=1,MAXCVI
      TVIBR(J,I,IE) = ZERO
      TVIBI(J,I,IE) = ZERO
 4    CONTINUE
      IF(I.GT.MAXCVI) GO TO 2
      DO 3 J=1,MAXCVF
      TVIBR(I,J,IE) = ZERO
      TVIBI(I,J,IE) = ZERO
 3    CONTINUE
 2    CONTINUE
C
 1    CONTINUE
c
      deallocate (ck,wk2)
C
      RETURN
      END
      SUBROUTINE VIBSET(NCHAN,NVIB,NTARG,NVCHAN,NVTARG,RMASS,ETARG,ICHL,
     1 evib,IWRITE,IPRNT)
C
C***********************************************************************
C
C     VIBSET initializes calculation of vibrational wavefunctions
C      and returns NVIB = number of target vibronic levels
C      and       NVCHAN = number of vibronic scattering channels
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION NVTARG(NTARG),ICHL(NCHAN),ETARG(NTARG),evib(*),rdum(1)
      double precision, allocatable :: vfn(:)
      integer, allocatable :: ivtarg(:),ivnu(:)
      DATA RDUM/2.D0/
C
      NVCHAN = 0
      MAXVI = 0
      MAXVF = 0
      DO 3 I=1,NCHAN
      NSTAT = ICHL(I)
      NVCHAN = NVCHAN+NVTARG(NSTAT)
 3    CONTINUE
C
C---- INITIALIZE CALCULATION OF VIBRATIONAL WAVEFUNCTONS
      CALL VIBINI(5,IWRITE,NTARG,NVTARG,RMASS,ETARG,IPRNT)
C
C---- MAKE DUMMY CALL TO ESTABLISH VIBRATIONAL ENERGY LEVELS
      allocate (ivtarg(nvib),ivnu(nvib),vfn(nvib))
      CALL RVIBR(NVIB,1,Evib,IVTARG,IVNU,VFN,etemp,RDUM)
      deallocate (ivtarg,ivnu,vfn)
C
      RETURN
      END
      SUBROUTINE AVGT(NQUAD,WTS,MVI,MVJ,ICHL,IVTARG,TMATR,TMATI,MAXI,
     1 MAXF,MAXCHI,MAXCHF,MAXCVI,MAXCVJ,VFN,TVR,TVI)
C
C***********************************************************************
C
C     AVGT EVALUATES INTEGRALS REQUIRED FOR THE ADIABATIC NUCLEI APPROX
C
C     INPUT PARAMETERS ARE
C      NQUAD = NUMBER OF POINTS IN QUADRATURE SCHEME
C      WTS   = QUADRATURE WEIGHTS (ASSUMED SYMMETRIC ABOUT MID POINT)
C      NCHAN = DIMENSION OF THE MATRICES TO BE AVERAGED
C      TMAT  = THE INTERPOLATED FIXED NUCLEI MATRICES EVALUATED AT THE
C              ABSCISSAE OF THE QUADRATURE SCHEME
C      NMAT  = NUMBER OF MATRICES
C      VFN   = THE TARGET VIBRATIONAL WAVEFUNCTION EVALUATED ON MESH
C      NTARG = NUMBER OF TARGET ELECTRONIC STATES
C      ICHL  = POINTERS FROM ASYMPTOTIC FIXED NUCLEI CHANNELS TO TARGET
C              ELECTRONIC STATES
C
C     OUTPUT PARAMETER IS
C     TIJ, THE AVERAGED MATRIX
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION VFN(NQUAD,*),TVR(MAXCVI,MAXCVJ),TVI(MAXCVI,MAXCVJ)   
     1,TMATR(NQUAD,MAXCHI,MAXCHF),TMATI(NQUAD,MAXCHI,MAXCHF)
     1,WTS(*),ICHL(*),IVTARG(*)
      DATA ZERO/0.D0/
C
C----- LOOP OVER MATRICES
      NWTS = (NQUAD+1)/2
C
C----- LOOP OVER FIRST INDEX ON VIBRATIONAL LEVELS
      KI = 0
      DO 3 MU=1,MAXI
C
C----- LOOP OVER FIRST INDEX ON ELECTRONIC CHANNELS
      DO 13 I=1,MVI
      IF(IVTARG(MU).NE.ICHL(I)) GO TO 13
      KI = KI+1
C
C----- LOOP OVER SECOND INDEX ON VIBRATIONAL LEVELS
      KJ = 0
      DO 23 NU=1,MAXF
C
C----- LOOP OVER SECOND INDEX ON CHANNELS
      DO 33 J=1,MVJ
      IF(IVTARG(NU).NE.ICHL(J)) GO TO 33
      KJ = KJ+1
C
C      CALCULATE THE INTEGRALS USING NUMERICAL QUADRATURE.
C
      SUMR = ZERO
      SUMI = ZERO
      DO 4 IX=1,NWTS
      IXN = NQUAD-IX+1
      SUMR = SUMR+WTS(IX)*(VFN(IX,MU)*TMATR(IX,I,J)*VFN(IX,NU)
     1 +VFN(IXN,MU)*TMATR(IXN,I,J)*VFN(IXN,NU))
      SUMI = SUMI+WTS(IX)*(VFN(IX,MU)*TMATI(IX,I,J)*VFN(IX,NU)
     1 +VFN(IXN,MU)*TMATI(IXN,I,J)*VFN(IXN,NU))
 4    CONTINUE
C
      TVR(KI,KJ) = SUMR
      TVI(KI,KJ) = SUMI
C
   33 CONTINUE
   24 CONTINUE
   23 CONTINUE
   13 CONTINUE
    3 CONTINUE
      MVI = KI
      MVJ = KJ
C
      RETURN
      END
      SUBROUTINE TMAT(NA,TKMT,TR,TI)
      USE blas_lapack_gbl, ONLY: blasint
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     TMAT CALCULATES THE TRANSITION MATRIX FROM THE K-MATRIX
C
C     NA   = NUMBER OF OPEN CHANNELS
C     TKMT = K-MATRIX (LOWER TRIANGLE)
C     TR   = REAL PART OF T-MATRIX
C     TI   = IMAGINARY PART OF T-MATRIX
C     AKMT,A,B    WORK SPACE
C
C***********************************************************************
C
      DIMENSION TR(NA,NA),TI(NA,NA),TKMT(*)
C ZM Automatic arrays on the heap and not on the stack:
      DOUBLE PRECISION, ALLOCATABLE :: AKMT(:,:), A(:,:), B(:,:)
      INTEGER(blasint) :: INFO, N
      INTEGER(blasint), ALLOCATABLE :: IPIV(:)
      DATA ZERO,ONE,TWO/0.D0,1.D0,2.D0/
C
      ALLOCATE(A(NA,NA),AKMT(NA,NA),B(NA,NA),IPIV(NA),STAT=I)
      IF (I .ne. 0) STOP "TMAT: memory allocation error"
C
C ZM vectorizations of the assignment loops coupled with the 
C    use of DGSEV are key to performance of this routine.
      K = 0
      DO 11 I=1,NA
      DO 10 J=1,I
      K = K+1
      AKMT(I,J) = TKMT(K)
      AKMT(J,I) = TKMT(K)
 10   CONTINUE
 11   continue
      DO 12 J=1,NA
      DO 1 I=1,NA
      A(I,J) = AKMT(I,J)
      B(I,J) = ZERO
      TR(I,J) = ZERO
 1    continue
 12   continue
      DO 3 J=1,NA
      DO 21 K=1,NA
      TK = AKMT(K,J)
      DO 2 I=1,NA
      B(I,J) = B(I,J)+AKMT(I,K)*TK
 2    continue
 21   continue
      B(J,J) = B(J,J)+ONE
 3    continue
C
C      CALL MA01A(B,A,NA,NA,0,NA,NA,TR,TI)
C ZM replaced MA01A with DGESV (allows for threading in MKL)
      N = NA
      CALL DGESV(N,N,B,N,IPIV,A,N,INFO)
      IF (INFO .ne. 0) STOP "TMAT: DGESV FAILED"
C
      DO 18 J=1,NA
      DO 19 I=1,NA
      TI(I,J) = TWO*A(I,J)
   19 CONTINUE
 18   continue
C
      DO 62 J=1,NA
      DO 61 K=1,NA
      TK = TI(K,J)
      DO 6 I=1,NA
      TR(I,J) = TR(I,J)-AKMT(I,K)*TK
 6    continue
 61   continue
 62   continue
C
      RETURN
      END
