! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE T_DIP(IFAIL)
C
C*******************************************************************
C
C     MAIN DRIVING ROUTINE TO CALCULATE TRANSITION DIPOLES
C
C*******************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      PARAMETER (NOPT=1)
      PARAMETER (MAXTGT=10)
      CHARACTER(LEN=80) NAME
      CHARACTER(LEN=20) DAYTIM
      CHARACTER(LEN=11) FORM,BFORM1,BFORM2,AIFORM1,AIFORM2,TDFORM,MODDAT
      CHARACTER(LEN=1) IBFORM1,IBFORM2,IAIFRM1,IAIFRM2,ITDFORM
      INTEGER STOT1,STOT2,GUTOT1,GUTOT2,ipflg1(10),ipflg2(10),
     * mtgtm(8*maxtgt)
      double precision tgtm(2*maxtgt)
      integer, allocatable :: ichl1(:),ichl2(:),lchl1(:),lchl2(:),
     * mchl1(:),mchl2(:)
      double precision, allocatable :: ethr1(:),ethr2(:),cf1(:),
     * cf2(:),bc1(:),bc2(:),enr1(:),enr2(:),vtem1(:),vtem2(:),
     * xvec1(:),xvec2(:),e1(:),e2(:),amps1(:),amps2(:),l12(:),k12(:),
     * tmtm(:)
      DATA MODDAT/'29-NOV-1994'/
      DATA LUTARG,LUBND1,LUBND2,LUMOM,LUTRD/24,21,22,50,40/
      DATA LUAI1,LUAI2/23,24/
      DATA NBSET1,NBSET2,NAISET1,NAISET2,NMSET,NTDSET/1,1,1,1,1,1/
      DATA NTSET/1/
      DATA NWFN1I,NWFN1F,NWFN2I,NWFN2F/1,1,1,1/
      DATA NPOINTS/240/,IRAFNOS/200/
      DATA FORM,BFORM1,BFORM2,AIFORM1,AIFORM2,TDFORM/6*'FORMATTED'/
      DATA IBFORM1,IBFORM2,IAIFRM1,IAIFRM2,ITDFORM/5*'U'/
      DATA IWRITE/6/
      DIMENSION IPRNT(4),IOPCDE(7,NOPT)
      DATA IPRNT/0,0,0,0/,RAB/0.D0/,IOPCDE/4,1,0,0,3,1,0/
C
      NAMELIST/TRDIP/LUBND1,LUBND2,NBSET1,NBSET2,IBFORM1,IBFORM2,
     1LUMOM,NMSET,IWRITE,IPRNT,NWFN1I,NWFN1F,NWFN2I,NWFN2F,NAME,
     1LUTRD,ITDFORM,NTDSET,RAB,IOPCDE,LUAI1,LUAI2,IAIFRM1,IAIFRM2,
     1NAISET1,NAISET2,NTSET,NPOINTS,IRAFNOS
C
C
      READ(5,TRDIP,END=9999)
      IF (IBFORM1.EQ.'U') BFORM1='UN'//FORM
      IF (IBFORM2.EQ.'U') BFORM2='UN'//FORM
      IF (IAIFRM1.EQ.'U') AIFORM1='UN'//FORM
      IF (IAIFRM2.EQ.'U') AIFORM2='UN'//FORM
      IF (ITDFORM.EQ.'U') TDFORM='UN'//FORM
C---- Date stamp run and print title
      CALL DATEST(DAYTIM)
      NAME(61:) = DAYTIM
      WRITE(IWRITE,12)MODDAT,NAME
C
C*****READ DATA FOR 1ST SET OF BOUND STATES
C
      WRITE(IWRITE,31)LUBND1,NBSET1,BFORM1
      CALL READBH(LUBND1,NBSET1,NCHAN1,MGVN1,STOT1,GUTOT1,NSTAT1,
     1NBOUND1,RR1,BFORM1,IPRNT(1),IWRITE,IFAIL)
      IF (IFAIL.NE.0) RETURN
      allocate (bc1(NSTAT1*NBOUND1),enr1(nbound1),vtem1(nbound1),
     * xvec1(NCHAN1*NBOUND1))
      CALL READBC(NSTAT1,ENr1,VTEM1,BC1,NBOUND1,NCHAN1,XVEC1)
C
C*****READ DATA FOR 2ND SET OF BOUND STATES
C
      WRITE(IWRITE,31)LUBND2,NBSET2,BFORM2
      CALL READBH(LUBND2,NBSET2,NCHAN2,MGVN2,STOT2,GUTOT2,NSTAT2,
     1NBOUND2,RR2,BFORM2,IPRNT(1),IWRITE,IFAIL)
      IF (IFAIL.NE.0) RETURN
      allocate (bc2(NSTAT2*NBOUND2),enr2(nbound2),vtem2(nbound2),
     * xvec2(NCHAN2*NBOUND2))
      CALL READBC(NSTAT2,ENr2,VTEM2,BC2,NBOUND2,NCHAN2,XVEC2)
C
C*****TEST TO SEE IF THIS PROCESS IS ALLOWED
C
      IF (STOT1.NE.STOT2) THEN
        WRITE(IWRITE,200)STOT1,STOT2
        RETURN
      ELSEIF (ABS(MGVN1-MGVN2).GT.1) THEN
        WRITE(IWRITE,201)MGVN1,MGVN2
        RETURN
      ELSEIF (GUTOT1.EQ.GUTOT2) THEN
        WRITE(IWRITE,202)GUTOT1,GUTOT2
        RETURN
      ELSEIF (RR1.NE.RR2) THEN
        WRITE(IWRITE,203)RR1,RR2
        RETURN
      ENDIF
      IF (ABS(MGVN1-MGVN2).EQ.1) IOPCDE(7,1)=1
C
C*****READ DATA FOR 1ST SET OF ASYMPTOTIC INTEGRAL DATA
C
      WRITE(IWRITE,32)LUAI1,NAISET1,AIFORM1
      CALL READAIH(LUAI1,NAISET1,NBND1,
     1NCHAN0,NVCHAN1,ISMAX1,AIFORM1,IPRNT(3),IWRITE,IFAIL)
      IF (IFAIL.NE.0) RETURN
      IF (NCHAN0.NE.NCHAN1) THEN
        WRITE(IWRITE,400)NCHAN0,NCHAN1
        RETURN
      ENDIF
c
      allocate (ichl1(nchan1),lchl1(nchan1),mchl1(nchan1),ethr1(nchan1),
     * cf1(ISMAX1*NCHAN1*NCHAN1),e1(nbnd1),amps1(nbnd1))
      CALL READAI1(ION1,IASY1,IWRON1,MAXPTS1,EPS1,RAFEND1,RAFIN1,
     * DEGENY1,EWRON1,RMATR1,HX1,TOL1,ETHR1,ICHL1,LCHL1,MCHL1,CF1,
     1 IPFLG1,NCHAN1,NVCHAN1,ISMAX1)
      CALL READAI2(NBND1,E1,AMPS1)
      IF (NBOUND1.NE.NBND1) THEN
         WRITE(IWRITE,446) NBOUND1,NBND1
         RETURN
      ENDIF
C
C*****READ DATA FOR 2ND SET OF ASYMPTOTIC INTEGRAL DATA
C
      WRITE(IWRITE,32)LUAI2,NAISET2,AIFORM2
      CALL READAIH(LUAI2,NAISET2,NBND2,
     1NCHAN0,NVCHAN2,ISMAX2,AIFORM2,IPRNT(3),IWRITE,IFAIL)
      IF (IFAIL.NE.0) RETURN
      IF (NCHAN0.NE.NCHAN2) THEN
        WRITE(IWRITE,401)NCHAN0,NCHAN2
        RETURN
      ENDIF
c
      allocate (ichl2(nchan2),lchl2(nchan2),mchl2(nchan2),ethr2(nchan2),
     * cf2(ISMAX2*NCHAN2*NCHAN2),e2(nbnd2),amps2(nbnd2))
      CALL READAI1(ION2,IASY2,IWRON2,MAXPTS2,EPS2,RAFEND2,RAFIN2,
     * DEGENY2,EWRON2,RMATR2,HX2,TOL2,ETHR2,ICHL2,LCHL2,MCHL2,CF2,
     1 IPFLG2,NCHAN2,NVCHAN2,ISMAX2)
      CALL READAI2(NBND2,E2,AMPS2)
      IF (NBOUND2.NE.NBND2) THEN
         WRITE(IWRITE,447) NBOUND2,NBND2
         RETURN
      ENDIF
C
C*****TEST TO SEE IF THIS PROCESS IS ALLOWED
C
      IF ((RAFEND1.NE.RAFEND2).OR.(RR1.NE.RR2)) THEN
        WRITE(IWRITE,448)RAFEND1,RR1,RAFEND2,RR2
        RETURN
      ENDIF
C
C*****READ TRANSITION MATRIX
C
      allocate (tmtm(NSTAT1*NSTAT2*NOPT))
      WRITE(IWRITE,300)NMSET,LUMOM
      CALL RDTMTH(LUMOM,NMSET,NSTAT1,NSTAT2,NOPT,IOPCDE,
     1            MGVN1,MGVN2,GUTOT1,GUTOT2,STOT1,STOT2,RAB,NUCCEN,
     2            IPRNT(2),IWRITE,IFAIL)
      CALL RDTMT(LUMOM,TMTM,NSTAT1,NSTAT2,NOPT,IOPCDE,IPRNT(2),
     1           IWRITE)
      IF (IPRNT(2).NE.0) CALL WRTMT(IWRITE,NSTAT1,NSTAT2,TMTM)
      IF (IFAIL.NE.0) RETURN
C
C*****Read the N electron target data
C
      WRITE(IWRITE,11) LUTARG,NTSET,FORM
      IPRNTN=1
      CALL RDTGSB(IWRITE,LUTARG,NTSET,RR1,NDMOM,MTGTM,TGTM,
     1NUCCEN,ISMAX1,IPRNTN,IFAIL)
      IF(IFAIL.NE.0) RETURN
      IF (NDMOM.GT.2*MAXTGT) THEN
        WRITE(IWRITE,13)2*MAXTGT,NDMOM
        RETURN
      ENDIF
c
C*****Create the matrix L needed in the asymptotic region
C
      allocate (l12(NCHAN1*NCHAN2),k12(NCHAN1*NCHAN2))
      CALL MKLK12(NCHAN1,ICHL1,LCHL1,MCHL1,NCHAN2,ICHL2,LCHL2,MCHL2
     1,L12,K12,NDMOM,MTGTM,TGTM,IWRITE)
C
C*****CALCULATE TRANSITION DIPOLES
C
C*****CHARLES' FIX
        ICJG=0
        IF (MGVN1.NE.MGVN2) ICJG=1
C*****END OF CHARLES' FIX
      NDATA=(NWFN1F-NWFN1I+1)*(NWFN2F-NWFN2I+1)
      CALL WRITTDH(TDFORM,TITLE,NTDSET,LUTRD,IWRITE,NBSET1,NBSET2,
     1LUBND1,LUBND2,NBOUND1,NBOUND2,MGVN1,MGVN2,STOT1,STOT2,GUTOT1,
     1GUTOT2,NSTAT1,NSTAT2,RR1,RR2,NDATA,IFAIL,IPRNT(4))
      IF (IFAIL.NE.0) RETURN
      DO 40 I1ST=NWFN1I,NWFN1F
      DO 4 I2ND=NWFN2I,NWFN2F
        IF ((NWFN1F.GT.NBOUND1).OR.(NWFN2F.GT.NBOUND2)) THEN
          WRITE(IWRITE,14)
          STOP
        ENDIF
        EN1 = ENr1(I1ST)
        EN2 = ENr2(I2ND)
        VTEMP1 = VTEM1(I1ST)
        VTEMP2 = VTEM2(I2ND)
C
C*****CALCULATE TRANSITION DIPOLES IN INNER REGION
C
        CALL CALCTD(NSTAT1,NSTAT2,NBOUND1,NBOUND2,BC1,TMTM,
     1  BC2,IWRITE,I1ST,I2ND,TRANDIP)
C
C*****CALCULATE TRANSITION DIPOLES IN OUTER REGION
C
        CALL ASYRINT(NCHAN1,NVCHAN1,LCHL1,ION1,ISMAX1,CF1,
     1  RAFIN1,ETHR1,NBND1,AMPS1,E1,NPOINTS,RAFEND1,IRAFNOS,
     1  L12,K12,IWRITE,IPFLG1,IPFLG2,
     1  DEGENY1,EPS1,EWRON1,IASY1,IWRON1,RMATR1,HX1,TOL1,MAXPTS1,
     1  NCHAN2,NVCHAN2,LCHL2,ION2,ISMAX2,CF2,
     1  ETHR2,NBND2,AMPS2,E2,
     1  DEGENY2,EPS2,EWRON2,IASY2,IWRON2,HX2,TOL2,MAXPTS2,
     1  XVEC1,XVEC2,I1ST,I2ND,TRDIPO)
c
        TRDIPI = TRANDIP
        IF (ICJG.EQ.1) THEN
          TRDIPI=(1/SQRT(2.d0))*TRDIPI
          TRDIPO=(1/SQRT(2.d0))*TRDIPO
        ENDIF
        TRANDIP = TRDIPI + TRDIPO
        OSCST=2.*TRANDIP*TRANDIP*ABS(EN1-EN2)/3.d0
        IF (EN1.LT.EN2) THEN
          IF (MGVN2.NE.0 .AND. MGVN1.EQ.0) OSCST=OSCST*2.d0
          SMOOTH=VTEMP2*VTEMP2*VTEMP2*OSCST
        ELSE
          IF (MGVN1.NE.0 .AND. MGVN2.EQ.0) OSCST=OSCST*2.d0
          SMOOTH=VTEMP1*VTEMP1*VTEMP1*OSCST
        ENDIF
        WRITE(IWRITE,102)I1ST,EN1,I2ND,EN2,TRANDIP,OSCST,SMOOTH
        IF (IPRNT(4).EQ.1) THEN
          WRITE(IWRITE,104)I1ST,I2ND,TRDIPI,TRDIPO
        ENDIF
        IF (LUTRD.NE.0) THEN
          IF (TDFORM.EQ.'FORMATTED') THEN
            WRITE(LUTRD,103)EN1,EN2,TRANDIP,OSCST,SMOOTH
          ELSE
            WRITE(LUTRD)EN1,EN2,TRANDIP,OSCST,SMOOTH
          ENDIF
        ENDIF
 4    CONTINUE
 40   continue
c
      WRITE(IWRITE,15)
      CLOSE(UNIT=LUBND1)
      CLOSE(UNIT=LUBND2)
      CLOSE(UNIT=LUAI1)
      CLOSE(UNIT=LUAI2)
      CLOSE(UNIT=LUMOM)
      CLOSE(UNIT=LUTRD)
      deallocate (ichl1,lchl1,mchl1,ethr1,cf1,bc1,enr1,vtem1,
     *            ichl2,lchl2,mchl2,ethr2,cf2,bc2,enr2,vtem2)
      IF (IFAIL.EQ.0) WRITE(IWRITE,18)
C
 9999 RETURN
 999  WRITE(IWRITE,101)
 11   FORMAT(/' Input dataset:              Unit  Set number'/
     1' Target data          LUTARG ',I3,5X,I3,5X,A11)
 12   FORMAT(//' Program TDIP  (last modified ',A,' )'//A//)
 13   FORMAT(/'Space for target dipole moments must be increased from ',
     1I4,' to ',I4)
 14   FORMAT(/'No bound state information for transition requested')
 15   FORMAT(
     1/'----------------------------------------------------------------
     1---------')
 18   FORMAT(/' *** Task successfully completed ***')
 31   FORMAT(/' Reading bound state coefficients from unit ',I3,' set ',
     1I3,2X,A11)
 32   FORMAT(/' Reading asymptotic information from unit ',I3,' set ',
     1I3,2X,A11)
 101  FORMAT(/' RAN OUT OF SPACE ')
 102  FORMAT(/I3,F12.6,I6,F12.6,3F13.6)
 103  FORMAT(10F20.13)
 104  FORMAT(/I3,I18,F18.6,F13.6,/)
 200  FORMAT(/'TRANSITION FROM STOT = ',I3,' TO ',I3,' IS FORBIDDEN')
 201  FORMAT(/'TRANSITION FROM MGVN = ',I3,' TO ',I3,' IS FORBIDDEN')
 202  FORMAT(/'TRANSITION FROM GUTOT = ',I3,' TO ',I3,' IS FORBIDDEN')
 203  FORMAT(/'R-MATRIX RADIUS IS INCONSISTENT: RR1 = ',F10.3,' RR2 = ',
     1F10.3)
 300  FORMAT(/'READING MOMENTS FROM SET NUMBER ',I3,' ON UNIT ',I3)
 400  FORMAT(/'INCONSISTENT DATA BETWEEN LUBND1 AND LUAI1: NCHAN = ',
     1I3,I3)
 401  FORMAT(/'INCONSISTENT DATA BETWEEN LUBND2 AND LUAI2: NCHAN = ',
     1I3,I3)
 446  FORMAT(/'INCONSISTENT DATA BETWEEN LUBND1 AND LUAI1: NBOUND = ',
     1I3,I3)
 447  FORMAT(/'INCONSISTENT DATA BETWEEN LUBND2 AND LUAI2: NBOUND = ',
     1I3,I3)
 448  FORMAT(/'INCONSISTENT DATA BETWEEN LUAI1 AND LUAI2: RAFEND AND RR
     1ARE ',/2F10.3,/2F10.3)
      RETURN
      END
      SUBROUTINE CALCTD(NSTAT1,NSTAT2,NBOUND1,NBOUND2,BC1,TMTM,BC2,
     1IWRITE,I1ST,I2ND,TRANDIP)
C
C*******************************************************************
C
C     CALCTM PERFORMS THE MULTIPLICATION: < C1 | TMT | C2 >
C
C*******************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION BC1(NSTAT1,NBOUND1),BC2(NSTAT2,NBOUND2),
     1TMTM(NSTAT1,NSTAT2),TVEC(NSTAT1)
c
      TRANDIP=0.d0
      DO 2 I=1,NSTAT1
      SUM=0.d0
      DO 1 J=1,NSTAT2
      SUM=SUM + TMTM(I,J)*BC2(J,I2ND)
 1    continue
      TVEC(I)=SUM
 2    continue
      SUM=0.d0
      DO 3 I=1,NSTAT1
      SUM=SUM+BC1(I,I1ST)*TVEC(I)
 3    continue
      TRANDIP=SUM
      RETURN
      END
      SUBROUTINE ASYRINT(NCHAN1,NVCHAN1,LCHL1,ION1,ISMAX1,CF1,
     1RAFIN,ETHR1,NBOUND1,AMPS11,E1,NPNTS,RAFEND,
     1IRAFNOS,AL12,AK12,IWRITE,IPFLG1,IPFLG2,
     1DEGENY1,EPS1,EWRON1,IASY1,IWRON1,RMATR1,HX1,TOL1,MAXPTS1,
     1NCHAN2,NVCHAN2,LCHL2,ION2,ISMAX2,CF2,ETHR2,
     1NBOUND2,AMPS12,E2,
     1DEGENY2,EPS2,EWRON2,IASY2,IWRON2,HX2,TOL2,MAXPTS2,
     1XVEC1,XVEC2,I1ST,I2ND,TRDIPO)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C***********************************************************************
C     ASYRINT CALCULATES THE INTEGRALS WITH RESPENT TO R (THE RADIAL
C     COORDINATE OF THE N+1TH ELECTRON) IN THE ASYMPTOTIC REGION
C***********************************************************************
C
      DIMENSION LCHL1(NCHAN1),ETHR1(NCHAN1),CF1(NCHAN1,NCHAN1,ISMAX1),
     1 FX1(2*NVCHAN1*NVCHAN1),FXP1(2*NVCHAN1*NVCHAN1),
     1 E1(NBOUND1),AMPS11(NBOUND1),XVEC1(NCHAN1,NBOUND1),
     1 PP(NCHAN1,NCHAN2),PRP(NCHAN1,NCHAN2),y1(nchan1),dy1(nchan1),
     1 PPOLD(NCHAN1,NCHAN2),PRPOLD(NCHAN1,NCHAN2),en1(nchan1),
     1 PPNEW(NCHAN1,NCHAN2),PRPNEW(NCHAN1,NCHAN2),en2(nchan2),
     1 AL12(NCHAN1,NCHAN2),AK12(NCHAN1,NCHAN2),
     1 PMAT1(NCHAN1,NCHAN1),PMAT2(NCHAN2,NCHAN2),
     1 IPFLG1(10)
      DIMENSION LCHL2(NCHAN2),ETHR2(NCHAN2),CF2(NCHAN2,NCHAN2,ISMAX2),
     1FX2(2*NVCHAN2*NVCHAN2),FXP2(2*NVCHAN2*NVCHAN2),
     1E2(NBOUND2),AMPS12(NBOUND2),XVEC2(NCHAN2,NBOUND2),
     1IPFLG2(10),y2(nchan2),dy2(nchan2)
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,LAMAX,ICF1,INC
      double precision, pointer :: cfnag(:),ennag(:),elnag(:)
c      COMMON/NAGPT/LAMAX,IENNAG0,IELNAG0,ICF,ZZNAG
      DATA ZERO/0.D0/,ICOL/6/
C
      IF (NCHAN1.NE.NVCHAN1) WRITE(IWRITE,92)
      IF (NCHAN2.NE.NVCHAN2) WRITE(IWRITE,92)
C
      NCHSQ1 = NCHAN1*NCHAN1
      NCHSQ2 = NCHAN2*NCHAN2
C
C---  CALCULATE CHANNEL ENERGIES
      NOPEN1 = 0
      DO 31 I=1,NCHAN1
      I1=I-1
      EN1(I) = E1(I1ST)-ETHR1(I)
      IF(EN1(I) .GT. ZERO) NOPEN1=NOPEN1+1
   31 CONTINUE
      NSOL1 = 2-(NCHAN1-NOPEN1)/NCHAN1
      IGAIL1 = INT(AMPS11(I1ST)+EPS1)
      NOPEN2 = 0
      DO 32 I=1,NCHAN2
      I1=I-1
      EN2(I) = E2(I2ND)-ETHR2(I)
      IF(EN2(I) .GT. ZERO) NOPEN2=NOPEN2+1
   32 CONTINUE
      NSOL2 = 2-(NCHAN2-NOPEN2)/NCHAN2
      IGAIL2 = INT(AMPS12(I2ND)+EPS2)
C
C*****CALCULATE THE INTEGRAL IN THE ASYMPTOTIC REGION
      RAFDIF=(RAFEND-RAFIN)/FLOAT(IRAFNOS)
      DO 302 I=1,NCHAN1
      DO 301 J=1,NCHAN1
      PRP(I,J)=ZERO
      PP(I,J)=ZERO
 301  continue
 302  continue
      RAFSB=RAFEND-RAFDIF
c
      DO 300 I=1,IRAFNOS
C
        IRAD = 0
        IFAIL= 0
        CALL GAILIT(EN1,LCHL1,NCHAN1,ION1,CF1,ISMAX1,RAFSB,
     1  IWRITE,IRAD,IASY1,IGAIL1,DEGENY1,EPS1,IPFLG1,FX1,FXP1,dummy,
     1  idum,idum,IFAIL)
        IF (IFAIL.GT.1) THEN
           WRITE(IWRITE,666)
 666       FORMAT('ERROR IN GAILIT')
        ENDIF
C
C       CHECK WRONSKIAN
C
        IF(IWRON1.NE.0) CALL WRONSK(NCHAN1,NOPEN1,FX1,FXP1,
     1  IWRITE,IPFLG1(10),EWRON1)
C
        IRAD = 0
        IFAIL= 0
        CALL GAILIT(EN2,LCHL2,NCHAN2,ION2,CF2,ISMAX2,RAFSB,
     1  IWRITE,IRAD,IASY2,IGAIL2,DEGENY2,EPS2,IPFLG2,FX2,FXP2,dummy,
     1  idum,idum,IFAIL)
        IF (IFAIL.GT.1) THEN
           WRITE(IWRITE,666)
        ENDIF
C
C       CHECK WRONSKIAN
C
        IF(IWRON2.NE.0) CALL WRONSK(NCHAN2,NOPEN2,FX2,FXP2,
     1  IWRITE,IPFLG2(10),EWRON2)
C
        RAFSB=RAFSB-RAFDIF
 300  CONTINUE
C
      IF(IPFLG1(9).NE.0) THEN
C
C----- PRINT SOLUTIONS AND DERIVATIVES
         DO 14 K=1,NSOL1
         WRITE(IWRITE,17) RAFIN
 17      FORMAT(/' ASYMPTOTIC INTEGRATION: SOLUTIONS AT RAFIN=',F8.3)
         IJK=(K-1)*NCHSQ1+1
         CALL WRECMT(FX1(IJK),NCHAN1,NCHAN1,NCHAN1,NCHAN1,ICOL,IWRITE)
 14      CONTINUE
         DO 15 K=1,NSOL1
         WRITE(IWRITE,18)RAFIN
 18      FORMAT(/' ASYMPTOTIC INTEGRATION: DERIVATIVES AT RAFIN',F8.3)
         IJK=(K-1)*NCHSQ1+1
         CALL WRECMT(FXP1(IJK),NCHAN1,NCHAN1,NCHAN1,NCHAN1,ICOL,IWRITE)
 15      CONTINUE
      ENDIF
C-----
      IF(IPFLG2(9).NE.0) THEN
         DO 114 K=1,NSOL2
         WRITE(IWRITE,117) RAFIN
 117     FORMAT(/' ASYMPTOTIC INTEGRATION: SOLUTIONS AT RAFIN=',F8.3)
         IJK=(K-1)*NCHSQ2+1
         CALL WRECMT(FX2(IJK),NCHAN2,NCHAN2,NCHAN2,NCHAN2,ICOL,IWRITE)
 114     CONTINUE
         DO 115 K=1,NSOL2
         WRITE(IWRITE,118)RAFIN
 118     FORMAT(/' ASYMPTOTIC INTEGRATION: DERIVATIVES AT RAFIN',F8.3)
         IJK=(K-1)*NCHSQ2+1
         CALL WRECMT(FXP2(IJK),NCHAN2,NCHAN2,NCHAN2,NCHAN2,ICOL,IWRITE)
 115     CONTINUE
      ENDIF
C
C*****CALCULATE THE INTEGRAL IN THE PROPAGATION REGION
C     FUNCTION PROPAGATION
C
      RAFSB=RAFSB+RAFDIF
      RAFDIF=(RAFSB-RMATR1)/FLOAT(NPNTS)
      RAFINN=RAFSB-RAFDIF
c
      CALL SBINT(RAFSB,1,FX1,NCHAN1,NOPEN1,PP,PPOLD,PPNEW
     1,PRP,PRPOLD,PRPNEW,AL12,AK12,FX2,NCHAN2,NOPEN2,RAFDIF,IWRITE
     1,PMAT1,PMAT2)
C
      nchan = max(nchan1,nchan2)
      ismax = max(ismax1,ismax2)
      allocate (ennag(nchan),elnag(nchan))
      allocate (cfnag(ismax*nchan*nchan),stat=ierror)
      if(ierror.ne.0) then
        print *,' unable to allocate cfnag ',ierror
        stop
      endif
      DO 303 IP=1,NPNTS
      ZZNAG = 2*ION1
      LAMAX = ISMAX1
      DO 23 I=1,NCHAN1
      ennag(i) = en1(i)
      elnag(i) = dble(LCHL1(I)*(LCHL1(I)+1))
 23   CONTINUE
      ijk = 0
      do 42 k=1,lamax
      do 41 i=1,nchan1
      do 40 j=1,nchan1
      ijk = ijk+1
      cfnag(ijk) = cf1(i,j,k)
 40   continue
 41   continue
 42   continue
      CALL INTIN(RAFINN,RAFSB,FX1,FXP1,NCHAN1,NOPEN1,Y1,DY1,
     1 HX1,MAXPTS1,TOL1,IPFLG1(10),IWRITE)
      ZZNAG = 2*ION2
      LAMAX = ISMAX2
      DO 33 I=1,NCHAN2
      ennag(i) = en2(i)
      elnag(i) = dble(LCHL2(I)*(LCHL2(I)+1))
 33   CONTINUE
      ijk = 0
      do 52 k=1,lamax
      do 51 i=1,nchan1
      do 50 j=1,nchan1
      ijk = ijk+1
      cfnag(ijk) = cf2(i,j,k)
 50   continue
 51   continue
 52   continue
c
      CALL INTIN(RAFINN,RAFSB,FX2,FXP2,NCHAN2,NOPEN2,Y2,DY2,
     1 HX2,MAXPTS2,TOL2,IPFLG2(10),IWRITE)
c
      i = ip
      CALL SBINT(RAFSB,I,FX1,NCHAN1,NOPEN1,PP,PPOLD,PPNEW
     1 ,PRP,PRPOLD,PRPNEW,AL12,AK12,FX2,NCHAN2,NOPEN2,RAFDIF,IWRITE
     1 ,PMAT1,PMAT2)
      RAFSB=RAFINN
      RAFINN=RAFINN-RAFDIF
 303  CONTINUE
C
      IF(IPFLG1(9).NE.0) THEN
C----- PRINT SOLUTIONS AND DERIVATIVES
         DO 24 K=1,NSOL1
         WRITE(IWRITE,27) RMATR1
 27   FORMAT(/' PROPAGATION INTEGRATION: SOLUTIONS 1 AT RMATR =',F8.3)
         IJK=(K-1)*NCHSQ1+1
         CALL WRECMT(FX1(IJK),NCHAN1,NCHAN1,NCHAN1,NCHAN1,ICOL,IWRITE)
 24      CONTINUE
         DO 25 K=1,NSOL1
         WRITE(IWRITE,28)RMATR1
 28   FORMAT(/' PROPAGATION INTEGRATION: DERIVATIVES AT RMATR',F8.3)
         IJK=(K-1)*NCHSQ1+1
         CALL WRECMT(FXP1(IJK),NCHAN1,NCHAN1,NCHAN1,NCHAN1,ICOL,IWRITE)
 25      CONTINUE
      ENDIF
C-----
      IF(IPFLG2(9).NE.0) THEN
         DO 124 K=1,NSOL2
         WRITE(IWRITE,127) RMATR1
 127  FORMAT(/' PROPAGATION INTEGRATION: SOLUTIONS 2 AT RMATR =',F8.3)
         IJK=(K-1)*NCHSQ2+1
         CALL WRECMT(FX2(IJK),NCHAN2,NCHAN2,NCHAN2,NCHAN2,ICOL,IWRITE)
 124     CONTINUE
         DO 125 K=1,NSOL2
         WRITE(IWRITE,128)RMATR1
 128  FORMAT(/' PROPAGATION INTEGRATION: DERIVATIVES 2 AT RMATR',F8.3)
         IJK=(K-1)*NCHSQ2+1
         CALL WRECMT(FXP2(IJK),NCHAN2,NCHAN2,NCHAN2,NCHAN2,ICOL,IWRITE)
 125     CONTINUE
      ENDIF
C
C     ADD TWO TERMS TO GET ASYMPTOTIC DIPOLE TRANSITION MOMENT
C
      DO 131 I=1,NCHAN1
      DO 130 J=1,NCHAN2
      PP(I,J)=PP(I,J)+PRP(I,J)
 130  continue
 131  continue
C
      DO 66 I=1,NCHAN1
      TRDIPO=ZERO
      DO 67 J=1,NCHAN2
      TRDIPO=TRDIPO+PP(I,J)*XVEC2(J,I2ND)
 67   continue
      PRP(I,1)=TRDIPO
 66   continue
      TRDIPO=ZERO
      DO 68 I=1,NCHAN1
      TRDIPO=TRDIPO+PRP(I,1)*XVEC1(I,I1ST)
 68   continue
c
      RETURN
 92   FORMAT(' *** WARNING: NCHAN.NE.NVCHAN, CASE NO PROPERLY COVERED')
      STOP
      END
      SUBROUTINE SBINT(RAD,IFIRST,FX1,NCHAN1,NOPEN1,PP,PPOLD,PPNEW,
     1PRP,PRPOLD,PRPNEW,AL12,AK12,FX2,NCHAN2,NOPEN2,RAFDIF,IWRITE,
     1PMAT1,PMAT2)
C
C***********************************************************************
C     SBINT MERGES THE OPEN AND CLOSED OUTER REGION FUNCTION, CALCULATES
C     THE MATRICES PLP AND PrKP AND ADDS THIS ELEMENT TO THE INTEGRAL
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DATA ZERO/0.D0/,TWO/2.D0/
      DIMENSION FX1(NCHAN1,NCHAN1,2),PMAT1(NCHAN1,NCHAN1)
     1,PP(NCHAN1,NCHAN2),FX2(NCHAN2,NCHAN2,2),PMAT2(NCHAN2,NCHAN2)
     1,PPOLD(NCHAN1,NCHAN2),PPNEW(NCHAN1,NCHAN2),PRP(NCHAN1,NCHAN2)
     1,PRPOLD(NCHAN1,NCHAN2),PRPNEW(NCHAN1,NCHAN2)
     1,AL12(NCHAN1,NCHAN2),AK12(NCHAN1,NCHAN2)
c
C*****MERGE OPEN AND CLOSED CHANNEL SOLUTIONS, 1ST SET
      DO 10 J=1,NOPEN1
      DO 1 I=1,NCHAN1
      PMAT1(I,J) = FX1(I,J,2)
 1    continue
 10   continue
      DO 20 J=1,NCHAN1-NOPEN1
      DO 2 I=1,NCHAN1
      PMAT1(I,J+NOPEN1) = FX1(I,J+NOPEN1,1)
 2    continue
 20   continue
c
C*****MERGE OPEN AND CLOSED CHANNEL SOLUTIONS, 2ND SET
      DO 13 J=1,NOPEN2
      DO 11 I=1,NCHAN2
      PMAT2(I,J) = FX2(I,J,2)
 11   continue
 13   continue
      DO 14 J=1,NCHAN2-NOPEN2
      DO 12 I=1,NCHAN2
      PMAT2(I,J+NOPEN2) = FX2(I,J+NOPEN2,1)
 12   continue
 14   continue
c
C*****COMPUTE THE MATRIX PMAT1*PMAT2
      DO 24 I=1,NCHAN1
      DO 21 J=1,NCHAN2
      SUM1=ZERO
      SUM2=ZERO
      DO 25 K1=1,NCHAN1
      DO 22 K2=1,NCHAN2
      SUM1=SUM1+PMAT1(K1,I)*PMAT2(K2,J)*AL12(K1,K2)
      SUM2=SUM2+PMAT1(K1,I)*RAD*PMAT2(K2,J)*AK12(K1,K2)
 22   continue
 25   continue
      PPNEW(I,J)=SUM1
      PRPNEW(I,J)=SUM2
 21   continue
 24   continue
c
C*****ADD ELEMENT TO THE NORMALISATION MATRIX
      IF (IFIRST.NE.1) THEN
        DO 26 I=1,NCHAN1
        DO 23 J=1,NCHAN2
        TEMP1=(PPNEW(I,J)+PPOLD(I,J))*RAFDIF/TWO
        TEMP2=(PRPNEW(I,J)+PRPOLD(I,J))*RAFDIF/TWO
        PRP(I,J)=PRP(I,J) + TEMP2
        PP(I,J)=PP(I,J) + TEMP1
 23     continue
 26     continue
      ENDIF
c
C*****PREPARE FOR NEXT ELEMENT OF INTEGRATION
      CALL SEBEQ2(NCHAN1,NCHAN2,PPOLD,PPNEW)
      CALL SEBEQ2(NCHAN1,NCHAN2,PRPOLD,PRPNEW)
c
      RETURN
      END
      SUBROUTINE SEBEQ2(NCHAN1,NCHAN2,A,B)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C     SEBEQ2 SETS MATRIX A EQUAL TO MATRIX B
C***********************************************************************
      DIMENSION A(NCHAN1*NCHAN2),B(NCHAN1*NCHAN2)
c
      DO 1,I=1,NCHAN1*NCHAN2
      A(I)=B(I)
 1    continue
c
      RETURN
      END
      SUBROUTINE MKLK12(NCHAN1,ICHL1,LCHL1,MCHL1,NCHAN2,ICHL2,LCHL2,
     1MCHL2,AL12,AK12,NDMOM,IMTGTM,TGTM,IWRITE)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C     MKLK12 MAKES THE MATRIX L NEEDED TO PERFORM THE ASYMPTOTIC
C     INTEGRATION.
C***********************************************************************
      PARAMETER (MAXTGT=10)
      DATA ZERO/0.D0/,TWO/2.D0/
      DIMENSION LCHL1(NCHAN1),MCHL1(NCHAN1),LCHL2(NCHAN2),MCHL2(NCHAN2),
     1ICHL1(NCHAN1),ICHL2(NCHAN2),
     1AL12(NCHAN1,NCHAN2),IMTGTM(2*MAXTGT,4),TGTM(MAXTGT),
     1AK12(NCHAN1,NCHAN2)
c
      DO 11,I=1,NCHAN1
      DO 1,J=1,NCHAN2
      AK12(I,J)=ZERO
      AL12(I,J)=ZERO
 1    continue
 11   continue
C
C*****MAKE THE MATRIX L12
C
C
      DO 20 I=1,NCHAN1
      DO 2 J=1,NCHAN2
        VAL=ZERO
        M1 = ABS(MCHL1(I))
        M2 = ABS(MCHL2(J))
        IF ((LCHL1(I).EQ.LCHL2(J)).AND.(M1.EQ.M2)) THEN
C*****MATRIX ELEMENT IS NON-ZERO, SO FIND THE CORRECT VALUE
          ITARG1 = ICHL1(I)
          ITARG2 = ICHL2(J)
          DO 4 K=1,NDMOM
            IF((ITARG1.EQ.IMTGTM(K,1)).AND.(ITARG2.EQ.IMTGTM(K,3))) THEN
              VAL=TGTM(K)
            ELSEIF((ITARG1.EQ.IMTGTM(K,3)).AND.
     1             (ITARG2.EQ.IMTGTM(K,1))) THEN
              VAL=TGTM(K)
            ENDIF
 4        CONTINUE
          AL12(I,J)=VAL
        ENDIF
 2    CONTINUE
 20   continue
C
C*****MAKE THE MATRIX K12
C
C
      DO 50 I=1,NCHAN1
      DO 5 J=1,NCHAN2
C     ENSURE THAT 6J SYMBOLS ARE NON-ZERO
        IF (ICHL1(I).EQ.ICHL2(J)) THEN
          L1=LCHL1(I)
          L2=LCHL2(J)
          M1=ABS(MCHL1(I))
          M2=ABS(MCHL2(J))
          MU= ABS(M1-M2)
          IF (MU.EQ.0) THEN
            IF ((L2-L1).EQ.1) THEN
              TEMPVAR = ((TWO*L2+1)*(L1+M1+1)*(L1-M1+1))/
     1                  ((TWO*L1+1))
              TEMPVAR = DSQRT(TEMPVAR)
              AK12(I,J)=-1**M1
              AK12(I,J) = AK12(I,J)*TEMPVAR/(TWO*L1+3)
            ELSEIF ((L1-L2).EQ.1) THEN
              TEMPVAR = ((TWO*L1+1)*(L2+M2+1)*(L2-M2+1))/
     1                  ((TWO*L2+1))
              TEMPVAR = DSQRT(TEMPVAR)
              AK12(I,J)=-1**M2
              AK12(I,J) = AK12(I,J)*TEMPVAR/(TWO*L2+3)
            ENDIF
          ELSEIF (MU.EQ.1) THEN
            IF ((L2-L1).EQ.1) THEN
              IF ((M1-M2).EQ.1) M1=-1*M1
              TEMPVAR = ((TWO*L2+1)*(L1+M1+1)*(L1+M1+2)*(L1+1))/
     1                  ((TWO*L1+1)*(TWO*L1+2))
              TEMPVAR = DSQRT(TEMPVAR)
              AK12(I,J)=-1**(M1+1)
              AK12(I,J) = AK12(I,J)*TEMPVAR/(TWO*L1+3)
            ELSEIF ((L1-L2).EQ.1) THEN
              IF ((M1-M2).EQ.-1) M2=-1*M2
              TEMPVAR = ((TWO*L1+1)*(L2+M2+1)*(L2+M2+2)*(L2+1))/
     1                  ((TWO*L2+1)*(TWO*L2+2))
              TEMPVAR = DSQRT(TEMPVAR)
              AK12(I,J)=-1**(M2+1)
              AK12(I,J) = AK12(I,J)*TEMPVAR/(TWO*L2+3)
            ENDIF
          ENDIF
        ENDIF
 5    CONTINUE
 50   continue
      RETURN
c
 100  FORMAT(10D12.4)
      END
