! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE SW_INTERF(IFAIL,NFDM,DELTA_R)
      use precisn_gbl
      use couplings
      use ukrmol_interface_gbl, only: READ_UKRMOLP_BASIS,
     &                                EVAL_AMPLITUDES,
     &                                UKP_READAMP, GET_ECP_CORE_CHARGES
      use rmt_molecular_interface, only: copy_wamps, copy_channel_data
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
 
C***********************************************************************
C
C     MAXIMUM DIMENSIONS ARE SET BY THE FOLLOWING PARAMETER STATEMENT
C     VARIABLE DIMENSIONS ARE USED IN ALL LOWER LEVEL ROUTINES, EXCEPT
C     CGCOEF
 
      PARAMETER(MAXCH=5000,MAXTGT=500,MAXCID=2*maxtgt,MAXM=6,maxnuc=100,
     * maxprop=8)
c 
C     MAXCH  = MAXIMUM NUMBER OF FIXED NUCLEI SCATTERING CHANNELS
C     MAXTGT = MAXIMUM NUMBER OF TARGET ELECTRONIC STATES
C     MAXCID = MAXIMUM NUMBER OF QUARTETS LABELLING CSFS
C     MAXM   = MAXIMUM CHANNEL M-VALUE
c 
c  ZM: new arguments added for interfacing with RMT. These are:
c     NFDM: number of finite difference points in the inner region.
c     DELTA_R: spacing between the FD points.
c
      INTEGER, INTENT(IN) :: NFDM
      DOUBLE PRECISION, INTENT(INOUT) :: DELTA_R
c
      CHARACTER(LEN=1) IAFORM,IBFORM,ICFORM,IRFORM
      CHARACTER(LEN=8) BLANK,CHARCHL,cnucnam(maxnuc)
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=11) AFORM,BFORM,CHFORM,CIFORM,RFORM,MODDAT
      CHARACTER(LEN=20) DAYTIM
      CHARACTER(LEN=80) NAME
c 
      INTEGER GUTOT,GTARG,STARG,SYMTYP,STOT,QCHL
c 
      COMMON/INTFS/ NCHAN,ION,NVIB,NDIS,IWRITE,MGVN,STOT,GUTOT
c 
      DIMENSION LCHL(MAXCH),MCHL(MAXCH),ICHL(MAXCH),
     1 idchl(maxch),ECHL(MAXCH),CHARG(maxnuc),MTARG(MAXTGT),
     2 GTARG(MAXTGT),GEONUC(3,maxnuc),STARG(MAXTGT),ivtarg(1),iv(1),
     3 ETARG(MAXTGT),IDTARG(MAXTGT),dummy(2),
     4 ESHIFT(MAXTGT),NVO(MAXTGT),IPRNT(6),
     5 mcont(MAXTGT),notgt(MAXTGT),bcoef(3,1)
      double precision, allocatable :: epole(:),civ(:),wamp2(:),
     1  prop(:,:,:),fnmc(:),wamp(:),dgem(:),sfac(:),ecex(:),rcex(:)
      integer, allocatable :: idpt(:), ichannel_phases(:)
      integer, allocatable :: core_charges(:)
      integer :: lambda_max, idummy(2)
      logical :: use_pol, target_phases_exist
c ZM: are we using the UKRmol+ integrals/orbitals/amplitudes?
      logical :: ukrmolp_ints
      logical :: normalize_to_a
c 
      DIMENSION QCHL(MAXCH),IRRCHL(MAXCH),CHARCHL(MAXCH),ncontcsf(8)
c 
C Change by Laura Moore, May 2011: new variables to enable the 
C calculation of  surface amplitudes at a number of radial distances.  
C The parameters are headers used to mark the location within a file  
C (output from swedmos) of data comprising the number of points at 
C which amplitudes are to be calculated (camp_pts) and the locations
C of the amplitudes themselves (ctrueb,ctruebpt1,ctruebpt2).
C In the inner region codes, these parameters are defined in
C global_data.f90
C The code that follows in this subroutine has additional loops over 
C radial distances at which the amplitudes are to be calculated (these 
C loops are indexed by I_RADIAL_PT).  The number of radial points at
C which amplitudes are to be calculated is  NUM_PTS_NEEDING_BNDRY_AMPS
C and the distance between them is DIST_BTN_PTS_NEEDING_BNDRY_AMPS    
      CHARACTER(LEN=8), PARAMETER ::  ctrueb   ='TRUEAMPS', 
     &                                camp_pts ='AMP_PTS ', 
     &                                ctruebpt1='TRUEAMP1', 
     &                                ctruebpt2='TRUEAMP2'
      CHARACTER(LEN=8), DIMENSION(300) :: AMP_HEADER_NAME
      INTEGER :: I_RADIAL_PT,NUM_PTS_NEEDING_BNDRY_AMPS
      DOUBLE PRECISION :: RADIUS, DIST_FROM_RMATRIX_BNDRY
C*********************************************************************** 
C***********************************************************************
C
C     BASIC DATA IS INPUT VIA NAMELIST /INTFIN/
C
C      IDTARG   = ARRAY LABELLING CSFS 
C      ISMAX    = HIGHEST MULTIPOLE TO BE USED IN ASYMPTOTIC EXPANSION
C                 OF STATIC POTENTIALS
C      IWRITE   = LOGICAL UNIT FOR PRINTED OUTPUT
C      IPRNT    = DEBUG PRINT SWITCHES :
C                 (1) EXACT COPY OF OUTPUT TO LUCHAN
C                 (2) MULTIPOLE COEFFICIENTS OF ASYMPTOTIC POTENTIAL
C                 (3) INPUT CI EIGENVALUES AND FIRST ELEMENT OF EACH
C                     EIGENVECTOR
C                 (4) INPUT BOUNDARY AMPLITUDES
C                 (5) PROPERTIES DATA SKIPPED DURING SEARCH FOR CORRECT
C                     SET
C      LUBUT    = LOGICAL UNIT HOLDING BUTTLE CORRECTIONS, IF ZERO THEN
C                 NO CORRECTION IS MADE TO THE R-MATRIX
C      LUTARG   = LOGICAL UNIT HOLDING TARGET DATA
C      MGVN     = TOTAL SYMMETRY OF SYSTEM (0,1,2,3,4,....)
C      NBSET    = BUTTLE CORRECTION ORDERING
C      NPOLE    = NUMBER OF ELECTRONIC R-MATRIX POLES TO BE TREATED
C                 NON-ADIABATICALLY
C      NTARG    = NUMBER OF TARGET ELECTRONIC STATES
C      NUCCEN   = LABEL OF 'NUCLEAR' CENTRE ASSOCIATED WITH THE
C                 CONTINUUM ORBITALS
C      R        = INTERNUCLEAR SEPARATION
C      RMATR    = R-MATRIX RADIUS FOR ELECTRONIC MOTION
C      STOT     = SPIN MULTIPLICITY 2*S+1 WHERE S = TOTAL SPIN OF SYSTEM
C      NAME     = TITLE FOR ANY OUTPUT
C      NCONTCSF = NUMBER of continuum orbitals for given symmetry
C      SYMTYP   = 2 FOR POLYATOMICS
C      NOLD     = SWITCH TO READ OLD OR NEW FORMAT IN PROPERTY FILE
C
C      Note:  GUTOT is not used in polyatomic calculations, nor in the
C             other basic scattering modules.  On the other hand SYMTP
C             is required by IXSECS (and possibly other modules) to
C             distinguish between diatomic and polyatomic calculations.
C             Unfortunately GUTOT is passed to other modules but SYMTYP
C             is not.  We therefore have replaced GUTOT by SYMTYP in 
C             the data output by WRITCH
C
C*******************************************************************
 
      NAMELIST/SWINTFIN/IWRITE,LUTARG,LUBUT,LUCI,LUAMP,LUCHAN,LURMT,
     1                  ISMAX,NASET,NTSET,NCISET,NCHSET,NRMSET,
     2                  mgvn,STOT,IPRNT,NPOLE,RMATR,rgeom,
     3                  NBSET,NTARG,NAME,ICFORM,IRFORM,IBFORM,
     4                  IAFORM,ALPHA0,ALPHA2,IDTARG,
     5                  ESHIFT,NVO,NOLD,nstat0,iposit,ukrmolp_ints
C
C***********************************************************************
C
      DATA
     1 IREAD,LUTARG,LUBUT,LUAMP,LUCI,LUCHAN,LURMT/5,24,0,22,25,10,21/,
     1 IPRNT/6*0/,NUCCEN/0/,ALPHA0,ALPHA2/0.D0,0.D0/,
     1 NTSET,NBSET,NASET,NCISET,NCHSET,NRMSET/6*1/,
     1 ISMAX/2/,NTARG/1/,NPOLE/0/,NOLD/0/
     1 IDTARG/MAXTGT*0/,NVO/MAXTGT*0/
      DATA ZERO/0.D0/,one/1.d0/
      DATA BLANK/'        '/,IAFORM,IBFORM,ICFORM,IRFORM/4*'U'/
     1 ,FORM,AFORM,BFORM,CHFORM,RFORM/5*'FORMATTED'/
     2 ,CIFORM/'UNFORMATTED'/
      DATA MODDAT/'12-Jan-2004'/
C
C ZM: error checking on the argument input
      if (NFDM < 0) then
         WRITE(IWRITE,'("Error in input NFDM: NFDM < 0 but 
     & the only allowed values are either 0 or a positive number.")')
         stop
      elseif (NFDM > 0 .and. DELTA_R .le. 0.0_wp) then
         WRITE(IWRITE,'("Error in input DELTA_R: DELTA_R .le. 0.0_wp
     & but DELTA_R must be a positive number.")')
         stop
      endif
C ZM: by default we do use UKRmol+
      ukrmolp_ints = .true.
C AH: by default we don't apply
      target_phases_exist= .false.
      IFAIL  = 0
      SYMTYP = 2
      gutot  = 2
      IWRITE = 6
      NVIB  = 0
      NDIS  = 0
c ZM NSTAT, NSTAT0 were not initialized
      NSTAT = 0
      NSTAT0 = 0
      iposit=0
      ibut=0
      Rgeom = zero
      DO 5 I=1,MAXTGT
      ESHIFT(I) = ZERO
 5    continue
C
C----- GET DATE STAMP
      CALL DATEST(DAYTIM)
C
C----- READ BASIC INPUT DATA
      NAME = BLANK
      READ(iread,SWINTFIN)
c
      IF(IAFORM.EQ.'U') AFORM='UN'//FORM
      IF(IBFORM.EQ.'U') BFORM='UN'//FORM
      IF(ICFORM.EQ.'U') CHFORM='UN'//FORM
      IF(IRFORM.EQ.'U') RFORM='UN'//FORM
c 
      DO I=1,MAXCH
        CHARCHL(I) = BLANK
      END DO
C
c --- Check validity of target labels
      IF(NTARG.GT.MAXTGT) GO TO 96
      IF(IDTARG(1).EQ.0) THEN
        DO 1 I=1,NTARG
        IDTARG(I) = I
 1      continue
      else
        do 3 i=1,ntarg
        k = i
        if(idtarg(i).lt.1.or.idtarg(i).gt.ntarg) go to 970
 3      continue
      ENDIF
c 
      open(unit=luci,form=ciform)
      READ(LUCI) NT,ND,ND,NOCSF
      IF(NSTAT.EQ.0) NSTAT=NOCSF
C
C----- PRINT OUT INPUT DATA
      NAME(61:) = DAYTIM
      WRITE(IWRITE,12) MODDAT,NAME
      WRITE(IWRITE,10) mgvn,STOT
      WRITE(IWRITE,11) LUTARG,NTSET,FORM,LUAMP,NASET,AFORM,LUCI,NCISET,
     1 CIFORM,LUBUT,NBSET,BFORM
      WRITE(IWRITE,13) LUCHAN,NCHSET,CHFORM,LURMT,NRMSET,RFORM
      IF (ukrmolp_ints) THEN 
         WRITE(IWRITE,14)
         CALL READ_UKRMOLP_BASIS(LUAMP)
c ZM: it is important to evaluate the amplitudes for the R-matrix radius
c     first and to normalize the continuum functions. In the following
c     calls to EVAL_AMPLITUDES the continuum functions will not be
c     renormalized again.
         normalize_to_a = .true.
         CALL EVAL_AMPLITUDES(RMATR,normalize_to_a)
         normalize_to_a = .false.
      ELSE
         WRITE(IWRITE,18)
      ENDIF
C
C----- READ TARGET DATA
c
      allocate(prop(ntarg,ntarg,maxprop))
c
      CALL SWTARG(IWRITE,LUTARG,NTSET,R,NTARG,MTARG,STARG,GTARG,
     1 ETARG,NNUC,NUCCEN,CHARG,GEONUC,RMASS,ISMAX,maxprop,prop,IDTARG,
     2 ESHIFT,IPRNT(5),NOLD,IFAIL, iposit)
c
      IF(IFAIL.NE.0) RETURN
      EBASE = ETARG(1)
c
c----- Read header from CI file to get dimension information
c
      open(unit=luamp,form=aform)
      call READCIP(luci,nciset,nocsf,nstat,mgvn,s,sz,neltot,nnuc,
     * dummy,dummy,dummy,cnucnam,geonuc,charg,ezero,nsymt,mcont,notgt,
     * luamp,iwrite,0,nstat0,ifail,ukrmolp_ints)
c
      if (nstat0.le.0) then
         nstat0=nstat
      else
         nstat0=min(nstat0,nstat)
      endif
      if (nstat .lt. nocsf) ibut=-2
c 
C----- CALCULATE RESIDUAL CHARGE OF SYSTEM
      IF (ukrmolp_ints) THEN
         CALL GET_ECP_CORE_CHARGES(core_charges)
      ELSE
         allocate(core_charges(NNUC))
         core_charges = 0
      ENDIF
      z = one-NELTOT
      DO 2 I=1,NNUC
      z = z+CHARG(I)-core_charges(I)
 2    CONTINUE
      ion = int(z)
      write(iwrite,17) rmatr,ion
c
c----- Set up parameters describing scattering channels
      CALL SWCHANL(NTARG,MTARG,STARG,ETARG,mgvn,STOT,
     *             EBASE,NCHAN,ICHL,LCHL,MCHL,ECHL,QCHL,IRRCHL,CHARCHL,
     *             maxnmo,luamp,ukrmolp_ints)
c 
      IF(NCHAN.GT.MAXCH) GO TO 96
      IF(IFAIL.NE.0) RETURN
C
C----- CALCULATE FIXED NUCLEI ASYMPTOTIC POTENTIAL MULTIPOLE COEFFS
      IF(ISMAX.GT.0) THEN
c
        NCHSQ = NCHAN*(NCHAN+1)/2

c Z.Masin: Allocate enough space if we're incorporating polarizability: the size of fnmc depends on the largest lambda in the coupling potentials; polarizability ~r^{-4} which gives lambda=3, 
c      so we need to make sure that fnmc is allocated as if ISMAX was at least 3: ISMAX concerns only the target multipole moments; polarization is a different type of interaction, so we don't put ISMAX=3 
c      at this stage. If we put ISMAX=3 now then channel_couplings would automatically include target multipole moments up to octupoles, but that may not be what the user wants. For example one can choose 
c      to include only dipolar interaction ISMAX=1 and the polarization potential, but not to include the quadrupole (ISMAX=2) and octupole (ISMAX=3) interactions. In that case we have ISMAX = 1, but space 
c      requirements as if ISMAX=3.
        lambda_max = ismax
        use_pol = .false. !if set to .true. then channel_couplings will take into account the polarizability
        if (alpha0 .ne. 0.0d0 .or. alpha2 .ne. 0.0d0) then
           use_pol = .true.
           lambda_max = max(ismax,3) !polarizability corresponds to lambda=3
        endif

        allocate(fnmc(lambda_max*NCHSQ))

c Z.Masin: Calculate the coefficients for the coupling potentials. We take into account the target multipole moments up to lambda=ISMAX and also polarizability of the target if use_pol = .true.
        call channel_couplings(nchan,ismax,ntarg,ichl,lchl,mchl,qchl,
     1  FNMC,prop,alpha0,alpha2,use_pol,.false.) !ZM .false. is here only if using the integral codes from the dev-branch

c Z.Masin: If the polarizability has been used then make sure ISMAX is large enough so that it is taken into account in subsequent calculations.
        ismax = lambda_max
C
        IF(IPRNT(2).GT.0) THEN
          WRITE(IWRITE,20)
          DO 8 IS=1,ISMAX
          WRITE(IWRITE,27) IS
          ISS = 1+(IS-1)*NCHSQ
          CALL MATTPT(NCHAN,fnmc(ISS),IWRITE)
 8        continue
        ENDIF
      ENDIF
C
C----- STORAGE ALLOCATION FOR CI DATA AND SCATTERING AMPLITUDES
c 
      WRITE(IWRITE,15) NOCSF,NSTAT0,NPOLE,ISMAX
c
      allocate (epole(nstat),civ(nstat*nocsf),wamp2(nchan*nstat0))
      if (ibut .ne. 0) allocate(dgem(nocsf),idpt(nocsf))
c 
C---- READ CI EIGENVALUES AND EIGENVECTORS PRODUED BY CI CODE
c
      if (ibut .ne. 0) then
         call READCIP(luci,nciset,nocsf,nstat,mgvn,s,sz,neltot,nnuc,
     *    epole,civ,dgem,cnucnam,geonuc,charg,ezero,nsymt,mcont,notgt,
     *    luamp,iwrite,1,nstat0,ifail,ukrmolp_ints)
      else
         call READCIP(luci,nciset,nocsf,nstat,mgvn,s,sz,neltot,nnuc,
     *    epole,civ,dummy,cnucnam,geonuc,charg,ezero,nsymt,mcont,notgt,
     *    luamp,iwrite,1,nstat0,ifail,ukrmolp_ints)
      endif
C
      if(iprnt(4).ne.0) then
         write(iwrite,28) 
         write(iwrite,29) (epole(i),i=1,nstat0)
      endif
c
      IF(IFAIL.NE.0) RETURN
c 
C=======================================================================
C
C     READ BOUNDARY AMPLITUDE DATA FROM THE FILE PRODUCED BY SWEDMOS
C     THEN CONSTRUCT THE TRUE BOUNDARY AMPLITUDES
C
C=======================================================================
C
      allocate (wamp(nchan*maxnmo))
      wamp = 0.0_wp
      if (ibut.ne.0) then
        allocate(sfac(nchan),ecex(nocsf),rcex(nchan*nocsf))
c     determine order of the diagonal elements
        call orderd(dgem,idpt,nocsf,nstat0)
      endif
C
c --- Set up pointers for matching channels to CI vectors
      call ORDERC(nchan,ntarg,ichl,idchl,idtarg)
C
c --- construct channel phases (if we have the target phases)
c --- needed for photoionization. AH

      inquire(file='target.phases.data', exist=target_phases_exist)
      if(target_phases_exist) then
         allocate(ichannel_phases(nchan))
         call  construct_channel_phases(ichl,nchan,idtarg,ntarg, 
     &                                  ichannel_phases)

      else
         allocate(ichannel_phases(nchan))
         ichannel_phases=1
      end if
c
c ZM: Total number of points for which amplitudes need to be calculated.
c     These are the R-matrix radius + all inner region FD points needed
c     for the RTM.
      if (ukrmolp_ints) then
         NUM_PTS_NEEDING_BNDRY_AMPS = NFDM+1
      else
c
C Change by Laura Moore, May 2011: to enable read of amplitudes
C at several radial distances.  First read the number of radial 
C distances at which amplitudes are to be calculated and their
C radial spacing
         CALL READ_AMP_HEADER_INFO(NUM_PTS_NEEDING_BNDRY_AMPS,
     &                             DELTA_R,
     &                             LUAMP,camp_pts,iwrite)
      endif
C
C LRM, May 2011: Now loop over the points at which amplitudes are 
C required.  At each point, read the raw boundary amplitudes and 
C then construct the actual R-matrix amplitudes 
C First set up header names used for reading/writing the amplitudes
C and set up the loop below so that the last radial point of the loop  
C is the R-matrix boundary itself
      AMP_HEADER_NAME(1) = CTRUEB
      AMP_HEADER_NAME(2) = CTRUEBPT1
      AMP_HEADER_NAME(3) = CTRUEBPT2
C
      RADIUS = RMATR - NUM_PTS_NEEDING_BNDRY_AMPS*DELTA_R
C
      DO I_RADIAL_PT = 1, NUM_PTS_NEEDING_BNDRY_AMPS
C
         IF (I_RADIAL_PT .eq. NUM_PTS_NEEDING_BNDRY_AMPS) THEN
            RADIUS = RMATR
         ELSE
c           The smallest radius needed is RMATR-NFDM*DELTA_R
            RADIUS = RADIUS + DELTA_R
         ENDIF
C
         DIST_FROM_RMATRIX_BNDRY = 
     &   (NUM_PTS_NEEDING_BNDRY_AMPS-I_RADIAL_PT)*DELTA_R
C
         WRITE(IWRITE,'("Calculating amplitudes for radial
     & point:",i4,e25.15)')I_RADIAL_PT,RADIUS
         IF (ukrmolp_ints) THEN
c           --- Calculate raw boundary amplitudes
            CALL EVAL_AMPLITUDES(RADIUS,normalize_to_a)
            CALL UKP_READAMP(WAMP,NCHAN,IRRCHL,LCHL,MCHL,QCHL,
     &                       NCONTCSF,MCONT,iprnt(4))
         ELSE
c           --- Read raw boundary amplitudes
            CALL READAMP(LUAMP,WAMP,NCHAN,IRRCHL,CHARCHL,
     &                   ncontcsf,nsymt,mcont,iwrite,iprnt(4),
     &                   AMP_HEADER_NAME(NUM_PTS_NEEDING_BNDRY_AMPS-
     &                   I_RADIAL_PT+1))
         ENDIF
C 
C
c        --- Construct R-matrix amplitudes
         if (ibut .ne. 0) then
         CALL TRUEAMP(WAMP,WAMP2,CIV,sfac,NSTAT0,nocsf,NCHAN,
     *              ezero,epole(nstat0),iex,ecex,rcex,dgem,idpt,
     *              NCONTCSF,ichl,irrchl,idchl,nvo,IWRITE,iprnt(4),
     *              AMP_HEADER_NAME(NUM_PTS_NEEDING_BNDRY_AMPS-
     *                              I_RADIAL_PT+1),RADIUS)
         else
         CALL TRUEAMP(WAMP,WAMP2,CIV,dummy,NSTAT0,nocsf,NCHAN,
     *              ezero,epole(nstat0),iex,dummy,dummy,dummy,idummy,
     *              NCONTCSF,ichl,irrchl,idchl,nvo,IWRITE,iprnt(4),
     *              AMP_HEADER_NAME(NUM_PTS_NEEDING_BNDRY_AMPS-
     *                              I_RADIAL_PT+1),RADIUS)
         endif
c
c        --- Apply channel phases to boundary amplitudes if they exist.
c        --- needed for photoionization. AH
c
         if (target_phases_exist) then
            call apply_channel_phases(wamp2,nchan,nstat0,
     &                                ichannel_phases)
         end if
C
C        ---- WRITE R-MATRIX DATA FILE FOR THE R-MATRIX RADIUS
c
         if (I_RADIAL_PT .eq. NUM_PTS_NEEDING_BNDRY_AMPS) then
           if (ibut .ne. 0) then
              CALL WRITRM(LURMT,NRMSET,RFORM,nstat0,NOCSF,ISMAX,NPOLE,
     1             FNMC,epole,WAMP2,CIV,BCOEF,NTARG,rgeom,RMASS,RMATR,
     2             IBUT,ezero,sfac,iex,ecex,rcex,NAME,IPRNT(6),IFAIL)
           else
              if (allocated(FNMC)) then
              CALL WRITRM(LURMT,NRMSET,RFORM,nstat0,NOCSF,ISMAX,NPOLE,
     1             FNMC,epole,WAMP2,CIV,BCOEF,NTARG,rgeom,RMASS,RMATR,
     2             IBUT,ezero,dummy,iex,dummy,dummy,NAME,IPRNT(6),IFAIL)
              else
              CALL WRITRM(LURMT,NRMSET,RFORM,nstat0,NOCSF,ISMAX,NPOLE,
     1             dummy,epole,WAMP2,CIV,BCOEF,NTARG,rgeom,RMASS,RMATR,
     2             IBUT,ezero,dummy,iex,dummy,dummy,NAME,IPRNT(6),IFAIL)
              endif
           endif
         endif
c ZM: transfer the calculated amplitudes into the
c     rmt_molecular_interface module:
         if (NFDM > 0) then
            call copy_wamps(WAMP2,MGVN,STOT,nchan,nstat0,
     &                      I_RADIAL_PT,NFDM,RADIUS)
         endif
c
      END DO
C
C---- Write target and channel data
c
C     In order to retain same format as diatomic code, we redefine MCHL
c
      do 32 i=1,nchan
      mchl(i) = mchl(i)*qchl(i)
 32   continue
c
c ZM: transfer the channel data and the coupling potential coefficients
      i = sum(CHARG(1:NNUC))
      call copy_channel_data(neltot,i,MGVN,STOT,NCHAN,NSTAT0,ICHL,LCHL,
     1 MCHL,ECHL,IRRCHL,NTARG,STARG,MTARG,GTARG,ETARG,EPOLE,FNMC,ISMAX)
c
      CALL WRITCH(LUCHAN,NCHSET,CHFORM,rgeom,RMASS,ICHL,LCHL,MCHL,ECHL,
     1 NTARG,STARG,MTARG,GTARG,ETARG,IVTARG,IV,NAME,IPRNT(1),IFAIL)
C
      deallocate (epole,civ,wamp2,prop,wamp)
      if(ismax.gt.0) deallocate (fnmc)
      if(ibut.ne.0) deallocate(dgem,idpt,sfac,rcex,ecex)
      CLOSE(UNIT=LUCHAN)
      CLOSE(UNIT=LURMT)
      IF(IFAIL.EQ.0) WRITE(IWRITE,16)
      RETURN
C
 96   WRITE(IWRITE,98) NTARG,NCHAN,MAXTGT,MAXCH
 98   FORMAT(/' INPUT DATA WILL EXCEED FIXED DIMENSIONS'/' INPUT  ',
     1 2I5/' MAXIMA ',2I5)
      IFAIL = 1
      RETURN
c
 970  write(iwrite,971) k,idtarg(k)
 971  format(/' Invalid element in IDTARG',2i3)
      ifail = 1
      return
C
 10   FORMAT(/' Symmetry data',3x,'MGVN =',I2,' STOT =',I2)
 11   FORMAT(/' Input datasets:             Unit  Set number'/
     1' Target data          LUTARG ',I3,5X,I3,5X,A11/
     2' Boundary amplitudes  LUAMP  ',I3,5X,I3,5X,A11/
     3' CI data              LUCI   ',I3,5X,I3,5X,A11/
     4' Buttle corrections   LUBUT  ',I3,5X,I3,5X,A11)
 12   FORMAT(//' Program SWINTERF  ( last modified ',A,' )'//A/)
 13   FORMAT(/' Output datasets:            Unit  Set number'/
     1' Channel data         LUCHAN ',I3,5X,I3,5X,A11/
     2' R-Matrix data        LURMT  ',I3,5X,I3,5X,A11)
 14   FORMAT(/' We are using UKRmol+ input')
 18   FORMAT(/' We are using SWEDEN input')
 15   FORMAT(/' Dimension of Hamiltonian matrix           NOCSF =',I10
     1       /' Number of CSFs used to construct R-matrix NSTAT =',I5
     2       /' Number of eigenvectors to be retained     NPOLE =',I5
     3       /' Number of multipoles in potential         ISMAX =',I5)
 16   FORMAT(//' *** Task has been successfully completed ***')
 17   FORMAT(/' R-matrix radius  =',f8.2,
     *       /' Residual charge on system =',I2)
 20   FORMAT(/' Multipole coefficients for asymptotic potentials')
 27   FORMAT(/' Lambda',I3)
 28   format(/' R-matrix poles ')
 29   format(8f10.4)
c 
      END
      SUBROUTINE SWCHANL(NTARG,MTARG,STARG,ETARG,mgvn,STOT,EBASE,
     *                   NCHAN,ICHL,LCHL,MCHL,ECHL,QCHL,IRRCHL,
     *                   CHARCHL,maxnmo,luamp,ukrmolp_ints)
C***********************************************************************
C
C     CHANL SETS UP VARIABLES DEFINING ASYMPTOTIC FIXED-NUCLEI
C     SCATTERING CHANNELS.
C
C     INPUT DATA:
C          NTARG  NUMBER OF TARGET STATES TO BE CONSIDERED
C
C                 **** TARGET STATE TABLE *****
C
C          MTARG  QUANTUM NUMBER FOR EACH TARGET STATE SYMMETRY:
C                 IRREDUCIBLE REPRESENTATION NUMBER
C                 SYMMETRIES BEGIN AT 0 AND TERMINATE AT 7
C          STARG  2*S+1 QUANTUM NUMBER FOR EACH TARGET STATE
C          ETARG  ABSOLUTE ENERGY IN HARTREES FOR EACH TARGET STATE.
C
C                 **** OVERALL SCATTERING SYMMETRY DESIGNATION ****
C
C           MGVN IRREDUCIBLE REPRESENTATION NUMBER
C                    SYMMETRIES BEGIN AT 0 AND TERMINATE AT 7
C           STOT  2*S+1
C
C                 **** MISCELLANEOUS ****
C
C          EBASE  THE BASE ENERGY FOR THIS CALCULATION
C
C   UKRMOLP_INTS  ARE WE USING UKRMOL+ INPUT
C
C     OUTPUT DATA:
C           NCHAN  TOTAL NUMBER OF CHANNELS IN THE PROBLEM
C          MAXNMO  Maximum number of scattering orbitals per symmetry
C
C                  **** CHANNELS TABLE ****
C
C            ICHL  GiVES, FOR EACH CHANNEL, THE TARGET STATE TO WHICH
C                  IT IS ASSOCIATED.
C            LCHL  ANGULAR MOMENTUM QUANTUM NUMBER FOR EACH CHANNEL
C            MCHL  M VALUE FOR THE SPHERICAL HARMONIC ASSOCIATED WITH
C                  EACH CHANNEL
C            QCHL  Q VALUE FOR THE SPHERICAL HARMONIC ASSOCIATED WITH
C                  EACH CHANNEL.
C          IRRCHL  IRREDUCIBLE REPRESENTATION NUMBER FOR EACH CHANNEL
C                  SYMMETRIES BEGIN AT 1 AND TERMINATE AT 8
C                  (This must match SWEDEN not Alchemy)
C            ECHL  GIVES THE THRESHOLD, IN RYDBERGS, FOR EACH CHANNEL
C                  RELATIVE TO THE BASE ENERGY EBASE
C         CHARCHL  GIVES THE CHANNEL ANGULAR MOMENTUM DEFINITIONS IN
C                  A FORMAT IDENTICAL TO THAT USED BY MOLECULE FOR
C                  DESCRIPTION OF THE ANGULAR BEHAVIOUS OF BASIS
C                  FUNCTIONS 
C
C     LINKAGE:
C
C         CHANCH
C
C     NOTES:
C
C     THIS SUBROUTINE HAS BEEN CREATED BY AUGMENTING THE ROUTINE USED
C     IN THE DIATOMIC R-MATRIX CODE WITH NEW CODE FOR THE D2h CASES.
C
C***********************************************************************
      use ukrmol_interface_gbl, only: UKP_PREAMP
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      INTEGER  STARG,STOT,QCHL
      LOGICAL, INTENT(IN) :: ukrmolp_ints
C
      PARAMETER(TWO=2.0D+00)
      PARAMETER(IWRITE=6)
      parameter (maxtyp=84)
C
      CHARACTER(LEN=8) CHARCHL,chars(maxtyp)
C
      DIMENSION MTARG(NTARG),STARG(NTARG),ETARG(NTARG),
     *          ICHL(*),LCHL(*),MCHL(*),ECHL(*)
      DIMENSION QCHL(*),IRRCHL(*),CHARCHL(*)
C
C=======================================================================
C
C     SUBROUTINE HANDLES THE ABELIAN POINT GROUPS
C     D2h AND ITS SUBGROUPS. NOTE THAT THE GROUP TABLE IS
C     GENERATED BY SUBROUTINE MPROD.
C
C=======================================================================
C
C---- IX IS A COUNTER WHICH INCREMENTS THROUGH EACH CHANNEL
C
      IX = 1
C
C---- BEGIN LOOP OVER TARGET STATES. THE IRR FOR EACH STATE IS DEFINED
C     BY THE ENTRY IN THE ARRAY MTARG WHERE THE TOTALLY SYMMETRIC
C     REPRESENTATION IS 1, THUS d2H HAS A HIGHEST REPRESENTATION
C     NUMBER OF 8 BECAUSE IT HAS EIGHT IRREDUCIBLE REPRESENTATIONS.
C
C     THE IRR THAT WE ARE STUDYING FOR SCATTERING IS DEFINED BY MGVN.
C
C     BY THE PROPERTIES OF D2h, THEN, FOR EACH TARGET STATE THE
C     APPROPRIATE CONTINUUM IRREDUCIBLE REPRESENTATION IS GIVEN BY
C     THE PRODUCT:
C
C            (IRR TARGET) x (IRR TOTAL SCATTERING SYMMETRY)
C
C     AND THIS IS STORED IN VARIABLE IRRCONT
C
      maxnmo = 0
      DO 1 I=1,NTARG
      if(abs(stot-starg(i)).ne.1) go to 1
c
      IRRCONT=MPROD(MTARG(I)+1,mgvn+1,0)
C
C     Get channel data for each irrep from header on amplitudes file
c       nch = number of channels for this irrep
C       chars = character strings describing symmetry
c
      IF (ukrmolp_ints) THEN !UKRMOL+ INPUT
         call UKP_PREAMP(irrcont,IX,LCHL,MCHL,QCHL,nch,maxnmo)
      ELSE !SWEDEN INPUT
         call PREAMP(LUAMP,irrcont,nch,chars,maxnmo,iwrite)
C
C     Get channel quantum numbers from their character representation
c
         call CHANCH(chars,LCHL(IX),MCHL(IX),QCHL(IX),NCH)
      ENDIF
C
C........ FINALLY FILL IN THE REMAINING CHANNEL IDENTIFIERS
C
      DO 2 J=1,NCH
      ICHL(IX+J-1)=I
      ECHL(IX+J-1)=TWO*(ETARG(I)-EBASE)
      IRRCHL(IX+J-1) = IRRCONT
      charchl(ix+j-1) = chars(j)
 2    continue
C
      IX=IX+NCH
 1    continue
      NCHAN=IX-1
C
      WRITE(IWRITE,2100)
C
      DO 3 I=1,NCHAN
      if (ukrmolp_ints) charchl(i) = 'N/A'
      write(iwrite,2000) i,ichl(i),lchl(i),mchl(i),qchl(i),charchl(i),
     * irrchl(i),echl(i),echl(i)/0.073500D0
 3    continue
C
      return
C
 2100 FORMAT(/' Channel Target  l  m  q       Irr  Energy   Energy(eV)')
 2000 format(i5,i8,i5,2i3,2x,a4,i3,2f10.6)
C
      END
      INTEGER FUNCTION MPROD(M1,M2,NPMULT)
c 
C***********************************************************************
C
C     MPROD - RETURNS THE DIRECT PRODUCT OF TWO IRREDUCIBLE
C             REPRESENTATIONS M1 AND M2. THIS VERSION HANDLES THE
C              GROUP D2h AND ALL OF ITS SUBGROUPS I.E. ABELIAN
C
C     NOTE THAT ENTRY WITH NPMULT > 0 CAUSES THE GROUP MULTIPLICATION
C     TABLE TO BE PRINTED.
C
C***********************************************************************
C
      CHARACTER(LEN=4) OS(8),LIST(9),BLANK,STAR4,STAR2L,STAR12
      DIMENSION IPD2H(8,8)
C
C---- LOAD TIME INITIALIZATION OF DATA AND SPECIFICATION THAT IT IS
C     TO BE PRESERVED ACCROSS CALLS.
C
      DATA OS /' AG ',' B3U',' B2U',' B1G',' B1U',' B2G',' B3G',' AU '/
C
      DATA IPD2H / 1,2,3,4,5,6,7,8,
     1             2,1,4,3,6,5,8,7,
     2             3,4,1,2,7,8,5,6,
     3             4,3,2,1,8,7,6,5,
     4             5,6,7,8,1,2,3,4,
     5             6,5,8,7,2,1,4,3,
     6             7,8,5,6,3,4,1,2,
     7             8,7,6,5,4,3,2,1/
      DATA  BLANK /'    '/, STAR4,STAR2L,STAR12/'****','**  ',' *  '/
C
      SAVE  OS,IPD2H,BLANK,STAR4,STAR2L,STAR12
C
C---- STANDARD ENTRY - OBTAIN GROUP PRODUCT FROM THE HARDWIRED TABLE
C     THEN RETURN WITH OR WITHOUT PRINTING OF THAT TABLE.
C
      MPROD = IPD2H(M1,M2)
      IF (NPMULT .LE. 0) return
C
C---- PRINT THE GROUP MULTIPLICATION TABLE FOR D2h
C
      NCLASS = 8
      PRINT 15
      PRINT 20, (I,I=1,NCLASS)
C
      LIST(1) = BLANK
      DO 100 I=1,NCLASS
      LIST(I+1) = OS(I)
  100 CONTINUE
      PRINT 25, LIST
C
      PRINT 30, (STAR4, I=1,NCLASS), STAR2L
C
      PRINT 35, (BLANK, I=1,NCLASS), STAR12
C
      DO 120 M=1,NCLASS
      LIST(1) = OS(M)
      DO 110 N=1,NCLASS
      LIST(N+1) = OS(IPD2H(N,M))
  110 CONTINUE
      PRINT 40, LIST,STAR12
      PRINT 35,(BLANK, I=1,NCLASS), STAR12
  120 CONTINUE
      PRINT 30, (STAR4,I=1,NCLASS), STAR2L
C
C---- FUNCTION RETURN POINT
C
      RETURN
C
C---- FORMAT STATEMENTS
C
   15 FORMAT(//10X,'GROUP MULTIPLICATION TABLE FOR D2H SYMMETRY'/)
   20 FORMAT(16X,20I4)
   25 FORMAT(13X,21A4)
   30 FORMAT(14X,' **',21A4)
   35 FORMAT(14X,' * ',21A4)
   40 FORMAT(10X,A4,' * ',21A4)
 9900 FORMAT(//,10X,'**** ERROR in FUNCTION MPROD ',//)
 9910 FORMAT(10X,'Invalid M1 and/or M2 - Must be in range 1<->8',//,
     *       10X,'M1 = ',I5,' M2 = ',I5,' NPMULT = ',I5,/)
C
      END
      SUBROUTINE SWTARG(IWRITE,LUTARG,NTSET,R,NTARG,MTARG,STARG,GTARG,
     1 ETARG,NNUC,NUCCEN,CHARG,GEONUC,RMASS,ISMAX,maxprop,prop,idtarg,
     2 eshift,IPRNT,NOLD,IFAIL, iposit)
 
C***********************************************************************
C
C     SWTARG READS TARGET STATE DATA FROM A DUMPFILE ATTACHED TO UNIT
C            LUTARG
C
C     THE DUMPFILE IS DIVIDED INTO DATASETS BY HEADER CARDS BEGINNING
C     WITH KEY = 6
C     Old style files with KEY=9 can also be read
C
C     KEY = RECORD KEY = FIRST FIELD (I1)
C     GTARG is retained for compatiblity with other modules
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
c
      parameter (maxnuc=100)
c
      INTEGER GTARG,STARG
c
      character(LEN=3) catom
      CHARACTER(LEN=26) HEAD
      DIMENSION MTARG(*),STARG(*),GTARG(*),ETARG(*),IDTARG(*),
     1 prop(ntarg,ntarg,*),INX(8),GEONUC(3,*),
     2 CHARG(*),AMNUC(maxnuc),ESHIFT(*)
      dimension IP(ntarg),IRP(ntarg),rmoi(3)
      EQUIVALENCE (INX(1),KEY)
      DATA ZERO,TWO/0.0D0,2.D0/
      DATA PI/3.1415926535897932D0/,AMU/1822.832d0/
C
      REWIND LUTARG
      TRPI = TWO*SQRT(PI)
c     chargesign is +1 for electrons and -1 for positrons
      chargesign = 1.0
      if (IPOSIT.ne.0) chargesign = -1.0
C
C----- SEARCH DUMPFILE FOR REQUIRED DATASET
      IPASS = 1
   17 READ(LUTARG,11,END=40) key
C     (JDG I've DELETED THE READ FOR DIATOMIC DATA)
      IF(KEY .NE. 6) GO TO 21
C     NOLD indicates if the property file is in the NEW (NOLD=0) or OLD 
C     (NOLD=1) FORMAT. THE ONLY DIFFERENCE IS IN THE FORMAT OF THE FIRST LINE 
C     OF THE FILE.
        backspace lutarg
        if (NOLD.EQ.0) THEN
         read(lutarg,1101) KEYH,iset,NRECS,NNUC,NTARG1,nmom,ISW,rmoi
        else
         read(lutarg,1100) KEYH,iset,NRECS,NNUC,NTARG1,nmom,ISW,rmoi
        end if 
C
C     SET HEADER    ...    KEY = 6 :
C
C     FIELD
C       2   SET NUMBER
C       3   NUMBER OF RECORDS IN SET
C       4   NUMBER OF GEOMETRY RECORDS ( NNUC )
C       5   NUMBER OF RECORDS OF TARGET DATA
C       6   NUMBER OF RECORDS OF MOMENT DATA
C       7   MOMENT TYPE SWITCH, ISW
C       8   Rotational constant AX (a.u.)
C       9   Rotational constant BY (a.u.)
C      10   Rotational constant CZ (a.u.)
C
        IF(NTARG.gt.ntarg1.OR.
     1               (NTSET.NE.0.AND.Iset.NE.NTSET)) THEN
C
C----- THIS IS NOT THE REQUIRED DATA SET SO SKIP REMAINING RECORDS
         IF(IPRNT.NE.0) WRITE(IWRITE,98) NTSET,NTARG,Iset,ntarg1
 
          DO 19 J=1,inx(3)
          READ(LUTARG,11,END=21)
 19       continue
          GO TO 17
        ENDIF
        write(iwrite,188) rmoi
C
C     READ DATA DEFINING MOLECULAR GEOMETRY   ...   KEY = 8 :
C
C     FIELD
C       2   NUCLEAR SEQUENCE NUMBER (I)
C       3   Name of atom
C       4   NUCLEAR CHARGE
C       5   NUCLEAR MASS ( IN ATOMIC UNITS )
C       6
C       7
C       8
C       9   NUCLEAR POSITION, GEONUC(I)
C      10   26-CHARACTER HEADER FIELD
C
        write(iwrite,189)
        DO 8 IT=1,NNUC
        READ(LUTARG,1102,err=21) key,iseq,catom,icharg,rmass,x,y,z
        IF(KEY .NE. 8) GO TO 21
        write(iwrite,120) it,catom,icharg,x,y,z,rmass
        CHARG(ISEQ) = icharg
        AMNUC(ISEQ) = rmass
        geonuc(1,iseq) = x
        geonuc(2,iseq) = y
        geonuc(3,iseq) = z
 8      CONTINUE
        nuccen=nnuc+1
c
      ikmax = 0
C OJO NTARG1! ES NUMERO TOTAL DE ESTADOS!!!
c      it's important to note that in this case ESHIFT must be in energy order
c      and not in congen order
      DO 10 ITG=1,NTARG1
       if (ntarg1 .lt. 100) then
          READ(LUTARG,11,END=21) (INX(I),I=1,8),DNX,HEAD
       else
          READ(LUTARG,22,END=21) (INX(I),I=1,8),DNX,HEAD
       end if
       IF(KEY .NE. 5) GO TO 21
       Itarg = INX(2)
       do 24 IT=1,NTARG
        IF(Itarg.EQ.IDTARG(IT)) THEN
         ETARG(itg)=DNX+ESHIFT(itg)
         MTARG(itg)=INX(5)
         STARG(itg)=INX(6)
         GTARG(itg)=0
         ikmax=ikmax+1
        END IF
 24   CONTINUE
 10   CONTINUE
      IF(IKmax.NE.NTARG) THEN
        WRITE(IWRITE,98) IKmax,NTARG,ISET,NTARG1
        GO TO 21
      ENDIF
C---- Sort target energies into ascending order
c     ( use eshift as work space )
      call sort_outer(ntarg,ip,etarg)
      do 31 i=1,ntarg
      irp(ip(i)) = i
      eshift(i) = etarg(i)
 31   continue
      do 32 i=1,ntarg
      etarg(i) = eshift(ip(i))
 32   continue
      call swap(ntarg,ip,mtarg,eshift)
      call swap(ntarg,ip,starg,eshift)
      call swap(ntarg,ip,gtarg,eshift)
      do 33 i=1,ntarg
      if(ip(i).ne.i) go to 34
 33   continue
      go to 35
 34   write(iwrite,95) (ip(i),i=1,ntarg)
c
 
      write(iwrite,97)
      do 36 i=1,ntarg
      write(iwrite,196) i,mtarg(i),starg(i),etarg(i)    
 36   continue
C
C---- CALCULATE REDUCED MASS IN ATOMIC UNITS
 35   SUMM = ZERO
      RMASS = ZERO
      DO 2 I=1,NNUC
      AM = AMNUC(I)
      IF(AM.GT.ZERO) SUMM = SUMM+1/AM
 2    CONTINUE
      IF(SUMM.GT.ZERO) RMASS = AMU/SUMM
      WRITE(IWRITE,18)RMASS
C
C     RDTMOM DATA    ...    KEY = 1
C
C     FIELD
C       2   STATE INDEX          (I)
C       3   |M(I)|
C       4   STATE INDEX          (J)
C       5   |M(J)|
C       6   OPERATOR CENTER INDEX  KOP
C       7   OPERATOR L-VALUE       LOP
C       8   OPERATOR |M|-VALUE     MOP
C       9   TRANSITION MOMENT IN AU, ISW CONVENTION DETERMINED BY HEADER
C
      DO 52 I=1,ntarg
      DO 51 j=1,ntarg
      DO 50 k=1,maxprop
      prop(I,j,k)=ZERO
 50   continue
 51   continue
 52   continue
C
      WRITE(IWRITE,20)
      DO 60 IM=1,NMOM
       if (ntarg1 .lt. 100) then
          READ(LUTARG,11,END=21)(INX(I),I=1,8),DNX,HEAD
       else
          READ(LUTARG,222,END=21)(INX(I),I=1,8),DNX,HEAD
       end if
       IF(KEY .NE. 1) GO TO 21
       LOP=INX(7)
       MOP = INX(8)
C
      IF(LOP .LT. 1 .OR. LOP .GT. ISMAX) GO TO 60
      IF(INX(6).NE.NUCCEN) GO TO 21
c
c     CHECK THAT THIS PROPERTY CORRESPONDS TO STATES BEING RETAINED
c
       IT1 = INX(2)
       IT2 = INX(4)
       DO I=1,ntarg
          IF (ip(I).eq.IT1 .and. INX(2).eq.IT1) THEN !correct the index if states have been reordered
             IT1=I
          ENDIF
          IF (ip(I).eq.IT2 .and. INX(4).eq.IT2) THEN !correct the index if states have been reordered
             IT2=I
          ENDIF
       ENDDO
C
       DO 14 IT=1,NTARG
        IF(IT1.EQ.IDTARG(IT)) THEN
         DO 13 IIT=1,NTARG
          IF(IT2.EQ.IDTARG(IIT)) THEN
           MT1 = INX(3)
           MT2 = INX(5)
           IF(MT1.NE.MTARG(IT1) .OR. MT2.NE.MTARG(IT2)) GO TO 21
           iq = lop*lop+lop+mop
           prop(it1,it2,IQ) = chargesign * dnx
           prop(it2,it1,IQ) = chargesign * dnx
           WRITE(IWRITE,96)IT1,MT1,IT2,MT2,LOP,MOP,dnx
          ENDIF
 13    CONTINUE
        ENDIF
 14   CONTINUE
c
 60   CONTINUE
      RETURN
C
 40   IF(IPASS.EQ.1) THEN
         REWIND LUTARG
         IPASS = IPASS+1
         GO TO 17
      ELSE
         WRITE(IWRITE,23)NTSET,R
 23      FORMAT(' UNABLE TO FIND REQUIRED TARGET DATA SET',I5,F10.3)
         STOP
      ENDIF
      RETURN
C
   21 WRITE(IWRITE,66)
   66 FORMAT(' ERROR in target properties data')
      WRITE(IWRITE,111) (INX(I),I=1,8),DNX,HEAD
      IFAIL = 1
      RETURN
c
 98   FORMAT(' Required',2I5,5X,'Skipped',2I5,F10.6)
 96   FORMAT(6I5,F10.5)
 18   FORMAT(/' Reduced mass',F15.6,' au')
 188  formAT(/' Target rotational constants (a.u.)',3d15.6)
 189  format(/' Nuclear centres '/4x,'Atom',2x,'Charge ',
     * 5x,'X',9x,'Y',9x,'Z',9x,'Mass')
 120  format(i3,2x,a3,3x,i3,3x,3f10.6,2x,f10.6)
 20   FORMAT(/' Transition moments')
 95   format(/' Warning, target states on properties file were not in en
     1ergy order'/' They have been reordered to',20i3/80i4/
     2 ' Check that IDTARG uses energy ordered labels')
 196  format(3i5,f20.10)
 97   format(/' Target states '/6x,' Irrep ','Spin',5x,' Energy (au)')
   11 FORMAT(I1,7I3,D20.12,2X,A26)
   22 FORMAT(I1,i8,6I3,D20.12,2X,A26)
  222 FORMAT(I1,i8,i3,i8,4I3,D20.12,2X,A26)
  111 FORMAT(1X,I1,7I3,D20.12,2X,A26)
 1100 FORMAT(I1,6I3,1x,3D20.12)
 1101 FORMAT(I1,I3,I6,I3,I4,I6,I3,1x,3D20.12)
 1102 FORMAT(I1,I3,a3,i3,f10.4,3f20.10)
      END
      SUBROUTINE READAMP(LUAMP,WAMPS,NCHAN,IRRCHL,CHARCHL,ncontcsf,
     * nsymt,mcont,iwrite,iprint,AMP_HEADER_NAME)
c 
C***********************************************************************
C
C     READAMP - READS BOUNDARY AMPLITUDES
C
C***********************************************************************
c
      IMPLICIT double precision(a-h,o-z)
      CHARACTER(LEN=8) CHARCHL,CUNIQUE
C
      DIMENSION  WAMPS(NCHAN,*),IRRCHL(*),CHARCHL(*),
     * ncontcsf(8),mcont(*)
      double precision, allocatable :: amps(:)
C
C LRM May 2011: AMP_HEADER_NAME is a new input variable - it marks the
C location in the file output by swedmos of surface amplitudes at a 
C given radial distance
      CHARACTER(LEN=8) :: AMP_HEADER_NAME
C
      if(iprint.ne.0) WRITE(IWRITE,1000)
      if(iprint.ge.1) WRITE(IWRITE,1010) NCHAN,
     *                     (I,IRRCHL(I),CHARCHL(I),I=1,NCHAN)
C
C LRM May 2011: Do the search now for AMP_HEADER_NAME
      call search(luamp,AMP_HEADER_NAME,ifail,iwrite)
      if(ifail.ne.0)go to 994
C
C---- NFOUND IS AUGUMENTED EACH TIME WE READ IN THE AMPLITUDES FOR
C     ONE CHANNEL. OBVIOUSLY WHEN WE FINISH READING THEN SET THEN
C     WE MUST HAVE NFOUND=NCHAN !
C
      NFOUND = 0
C
C     LOOP OVER ALL SETS OF AMPLITUDES.
C
C.... HEADER CARD FOR EACH SYMMETRY
C
 400  READ(LUAMP,END=500,ERR=990) ISYM,NAO,NMO,NUNIQUE
C LRM May 2011: If ISYM and NAO are -1 then we've come to the end of
C the data for this radial point
      if((ISYM.EQ.-1).AND.(NAO.EQ.-1))go to 500
      if(iprint.gt.0) WRITE(IWRITE,2010) ISYM,NAO,NMO,NUNIQUE
c
      allocate(amps(nmo))
C
C.... BOUNDARY AMPLITUDES FOR EACH COMPONENT
C
      DO 501 K=1,NUNIQUE
      READ(LUAMP,ERR=992) CUNIQUE,(AMPS(I),I=1,NMO)
      if(iprint.gt.1)WRITE(IWRITE,2020)K,CUNIQUE,(I,AMPS(I),I=1,NMO)
C
C....... WE NOW SEEK THIS CHANNEL DEFINITION IN THE LIST
C        AND IF IT IS FOUND THEN WE COPY THE DETAILS INTO WAMP
C
      DO 1 L=1,NCHAN
      IF(IRRCHL(L).EQ.ISYM.and.CHARCHL(L).EQ.CUNIQUE) THEN
        if(nsymt.eq.0) go to 4
        do 3 i=1,nsymt
        if(isym.eq.mcont(i)+1) go to 4
 3      continue
        write(iwrite,9900)
        write(iwrite,9920) isym,nmo,(mcont(i),i=1,nsymt)
        stop 992
 4      NFOUND=NFOUND+1
        DO 2 I=1,NMO
        WAMPS(L,I) = AMPS(I)
 2      continue
        ncontcsf(isym) = nmo
        if(iprint.gt.0) WRITE(IWRITE,2810) L,ISYM,CUNIQUE,
     *                                         (WAMPS(L,I),I=1,NMO)
      endif
 1    continue
C
 501  continue
C
C.... LOOP BACK TO READ ANOTHER SYMMETRY SET
C
      deallocate(amps)
      GOTO 400
C
C---- CODE JUMPS HERE AT THE END OF THE REPEAT LOOP
C
 500  IF(NFOUND.NE.NCHAN)THEN
        WRITE(IWRITE,9900)
        WRITE(IWRITE,9910) NFOUND,NCHAN
        STOP 999
      ENDIF
C
      WRITE(IWRITE,2900)
C
      RETURN
C
C---- ERROR CONDITION HANDLER
C
C       1. ERROR ON READ OF FILE OF AMPLITUDES AT START IF A SET
C
 990  WRITE(IWRITE,9900)
      STOP 990
C
C       2. ERROR ON READ DURING MIDDLE OF A SET OF AMPLITUDES
C
 992  WRITE(IWRITE,9900)
      STOP 992
C
C       3. LRM May 2011: Header for amplitudes not found on unit luamp
C
 994  WRITE(IWRITE,9900)
      WRITE(IWRITE,9930)AMP_HEADER_NAME,luamp
      STOP 994
C
 1000 FORMAT(/,10X,'====> READAMP - READ BOUNDARY AMPS <====',/)
 1010 FORMAT(/,10X,'Searching for data on ',I3,' channels ',//,
     *         10X,'Seq No.  IRRCHL  CHARCHL ',/,
     *         10X,'-------  ------  --------',//,
     *        (10X,I6,2X,I4,7x,A8))
 2010 FORMAT(/,10X,'Symmetry number = ',I3,//,
     *         10X,'No. of basis functions = ',I3,/,
     *         10X,'No. of orbitals        = ',I3,/,
     *         10X,'No. of angular parts   = ',I3,/)
 2020 FORMAT(/,10X,'Unique component number = ',I3,/,
     *         10X,'Designation = ',A,//,
     *         10X,'Amplitudes follow : ',//,
     *         (2X,3(I5,F20.13)))
 2810 FORMAT(/1X,'Chan No. ',I2,' Symmetry = ',I2,' Angular behaviour',
     *          ' = ',A,/,(1X,5(F12.8,1X)))
 2900 FORMAT(/' **** Amplitudes file has been read successfully ',/)
 3000 FORMAT(/10X,'Begining search for the boundary amplitudes ',/,
     *        10X,'for this scattering problem ',//,
     *        10X,'No. of channels = ',I3,/)
 3010 FORMAT(10X,I3,1X,I2,1X,A)
 9900 FORMAT(/,5X,'**** Error in READAMP : ',/)
 9910 FORMAT(5X,'No. of channel amplitudes found = ',I5,/,
     *       5X,'No. required (NCHAN) = ',I3,/)
 9920 format(/' Mismatch between amplitude file SYM=',i1,3x,
     * 'NMO=',i2,3x,'and Hamiltonian data,',8i2)
C
 9930 FORMAT(/' Header ',A8,' NOT FOUND ON UNIT',I3)
C
      END
      SUBROUTINE TRUEAMP(WAMP,WAMP2,VECS,sfac,NSTAT,NKEEP,NCHAN,
     *                   ezero,etop,iex,ecex,rcex,dgem,idpt,
     *                   ncontcsf,ichl,irrchl,idchl,nvo,IWRITE,iprint,
     *                   AMP_HEADER_NAME,DIST_FROM_RMATRIX_BNDRY)
c 
C***********************************************************************
C
C     TRUEAMP - MULTIPLIES BOUNDARY AMPLITUDES DEFINED OVER
C               CHANNELS AND MOLECULAR ORBITALS (RUDIMENTARY) BY
C               THE EIGENVECTOR COEFFICIENTS FROM THE INNER REGION
C               DIAGONALIZATION TO PRODUCE THE BOUNDARY AMPLITUDES
C               AS STATED IN ALL OF THE R-MATRIX PAPERS.
C
C***********************************************************************
      IMPLICIT double precision (a-h,o-z)
c
      PARAMETER(ZERO=0.0D+00,one=1.0d+00)
C
      DIMENSION WAMP(NCHAN,*),WAMP2(NCHAN,*),VECS(NKEEP,*),nvo(*),
     *         ncontcsf(8),irrchl(nchan),ichl(nchan),idchl(nchan),
     *        sfac(nchan),ecex(*),rcex(nchan,*),dgem(nkeep),idpt(nkeep),
     *         resid(nkeep)
      integer, allocatable :: kst(:)
C
C LRM May 2011: AMP_HEADER_NAME is a new input variable - it marks the
C location in the output file of surface amplitudes at a given radial 
C distance. The radial distance itself is DIST_FROM_RMATRIX_BNDRY
C inside the R-matrix boundary
      CHARACTER(LEN=8) :: AMP_HEADER_NAME
      DOUBLE PRECISION :: DIST_FROM_RMATRIX_BNDRY
C
      allocate (kst(nchan))
      if(iprint.ne.0) then
        WRITE(IWRITE,1000)
        WRITE(IWRITE,1010) NSTAT,NKEEP,NCHAN
        WRITE(IWRITE,1020)
        DO I=1,NKEEP
           WRITE(IWRITE,1030) (VECS(I,J),J=1,NSTAT)
        END DO
      endif

c --- Initialize amplitudes
      nc1 = 0
      kcount = 0
      iex0=0
      kst0=0
      do 100 ii=1,nchan
      i = idchl(ii)
      nc = ichl(i)
      if(nc.ne.nc1) then
        nc1 = nc
        kstart = kcount+nvo(nc)
        kcount = kcount+ncontcsf(irrchl(i))+nvo(nc)
      endif
      kst(i) = kstart
      do 10 j=1,nstat
      wamp2(i,j) = zero
 10   continue
 100  continue
       if (nstat.lt.nkeep) then
         do j=1,nkeep
         rcex(i,j) = zero
         enddo
      endif
c     compute vector residuals
      if (nstat.lt.nkeep) then
         do j=1,nkeep
            sum = one
            do i=1,nstat
               sum = sum - vecs(j,i)**2
            enddo
            resid(j)=sum
         enddo
      endif
c
C---- NOW MULTIPLY ALL BOUNDARY AMPLITUDES OVER ORBITALS BY APPROPRIATE
C     CI VECTORS.
C
C     WAMP2 differs from the W_IK OF THE R-MATRIX PAPERS by a factor
c     sqrt(rmatr/2)
c     
      kk0=kst(1)
      nc=0
      iez=0
      ezero=zero
      DO 1 II=1,NCHAN
      i = idchl(ii)
      DO 30 J=1,NSTAT
c
      kk = kst(i)
      DO 32 K=1,NCONTCSF(irrchl(i))
      kk = kk+1
      WAMP2(I,J)=WAMP2(I,J) + WAMP(I,K)*VECS(KK,J)
 32   continue
 30   continue
      if (nstat .lt. nkeep) then
         sum=zero
         DO 34 K=1,NCONTCSF(irrchl(i))
         sum=sum + WAMP(I,K)**2
 34      continue
         sfac(i)=sum
c                                                                            
         kk = kst(i)
             if (kk0 .ne. kk) then
                 kk0=kk
                 iex0=iex
             else
                 iex=iex0
             end if 
         DO 36 K=1,NCONTCSF(irrchl(i))
         kk = kk+1
         if (dgem(kk) .gt. etop) then
            iex=iex+1
            rcex(I,iex)=WAMP(I,K)**2*resid(kk)
            ecex(iex)=dgem(kk)
            if (nc.ne.ichl(i)) then
               iez=iez+1
               ezero=ezero+dgem(kk)
               nc=ichl(i)
            endif
         endif
 36      continue
c
      endif
 1    continue
c
      if (nstat .lt. nkeep) then
         if (iez .gt. 0) then
            ezero=ezero/dble(iez)
         else
            ezero=etop
         endif
         icorr = iex
         write(6,*) ' Partitioned R-matrix, E0 = ',ezero,
     1                ' Eh absolute, average of',iez,' elements'
      else
         icorr = 0
         ezero=etop
      endif
c
C LRM May 2011: Output the radial distance at which the amplitudes
C have been calculated
      WRITE(IWRITE,2000) DIST_FROM_RMATRIX_BNDRY,NCHAN,NSTAT, icorr
      if(iprint.ne.0.or.nstat.le.30) then
        nwprnt = nstat
        write(iwrite,2001) nwprnt
      else
        nwprnt = 30
        write(iwrite,2002) nwprnt
      endif
      DO I=1,NCHAN
         WRITE(IWRITE,2010) I,(WAMP2(I,J),J=1,nwprnt)
      END DO
C
      deallocate (kst)
      RETURN
C
 1000 FORMAT(/,10X,'====> TRUEAMP - BUILD REAL AMPLITUDES <====',/)
 1010 FORMAT(/,10X,'No. of CI eigen states (NSTAT) = ',I5,/,
     *         10X,'No. of CSF components  (NKEEP) = ',I5,/,
     *         10X,'No. of channels        (NCHAN) = ',I5,/)
 1020 FORMAT(/,10X,'CI eigen vectors follow ',/)
 1030 FORMAT((5X,6(F11.8,1X)))
 2000 FORMAT(/,5X,'R-matrix boundary amplitudes ',//,
     *         5X,'At radial distance RMATR - ',F15.8,' Bohr radii',/,
     *         5X,'No. of channels     = ',I5,/,
     *         5X,'No. of eigenvectors = ',I5,/,
     *         5X,'No. of correction terms = ',I5,//)
 2001 format(5X,'All',i5,' R-matrix amplitudes'/)
 2002 format(5X,'First ',i2,' R-matrix amplitudes'/)
 2010 FORMAT(5X,'Channel = ',I3,1X,3(F15.8,1X),/,(19X,3(F15.8,1X)))
C
      END
      SUBROUTINE CHANCH(chars,LCHL,MCHL,QCHL,NCH)
C***********************************************************************
C
C     CHANC2v - CHANNEL BUILDER FOR POINT FULL GROUP C2v
C
C     INPUT DATA:
C            NCH NUMBER OF CHANNELS GENERATED
C            CHARS character string describing symmetry
C
C     OUTPUT DATA:
C            LCHL L VALUE FOR EACH CHANNEL
C            MCHL M VALUE FOR EACH CHANNEL
C            QCHL Q VALUE FOR EACH CHANNEL
C
C***********************************************************************
C
      parameter (maxl=6)
      INTEGER  QCHL
      character(LEN=1) charl(maxl+1),charm(maxl+1),charq(3)
      character(LEN=8) chars(*)
C
      DIMENSION  LCHL(*),MCHL(*),QCHL(*)
      data charl/'s','p','d','f','g','h','i'/
      data charm/'0','1','2','3','4','5','6'/
      data charq/'-',' ','+'/
c
      do 1 i=1,nch
      lchl(i) = 0
      mchl(i) = 0
      qchl(i) = 0
      do 2 l=0,maxl
      if(chars(i)(2:2).eq.charl(l+1)) lchl(i)=l
      if(chars(i)(3:3).eq.charm(l+1)) mchl(i)=l
      if(chars(i)(3:3).eq.'x') then
        mchl(i) = 1
        qchl(i) = 1
      endif
      if(chars(i)(3:3).eq.'y') then
        mchl(i) = 1
        qchl(i) = -1
      endif
      if(chars(i)(3:3).eq.'z') mchl(i)=0
  2   continue
      if(lchl(i).ge.2) then
        do 3 iq=1,3
        if(chars(i)(4:4).eq.charq(iq)) qchl(i)=iq-2
  3     continue
      endif
  1   continue
C
      RETURN
      END
C LRM May 2011: Update SEARCH to output a failure flag which can then
C be checked by the calling routine.  The calling routine can then 
C decide to stop the program upon error if necessary, rather than
C SEARCH stopping the program itself.  IWRITE is now also passed to
C SEARCH rather than hard-coded within SEARCH.  This is consistent
C with the arguments passed to SEARCH in the UKRMol-in suite of codes.
      SUBROUTINE SEARCH(IUNIT,A,IFAIL,IWRITE)
C***********************************************************************
C
C     Utility to search a dataset IUNIT for a header A where the dataset
C     is assumed to have MOLECULE-SWEDEN convention headers. The header
C     convention is
C
C     '********', '        ', '        ', 'ABCDEFG'
C
C     with ABCDEFG being a character string such as ONELINT etc.
C
C***********************************************************************
C
      CHARACTER(LEN=8)  A
      CHARACTER(LEN=8)  A1
      CHARACTER(LEN=32) B
C
      PARAMETER(A1='********')
C
C LRM May 2011: Set IFAIL=0 to initialize
      IFAIL=0
C
      REWIND IUNIT
c      IREC=0
C
  1   READ(IUNIT,END=990) B
C
c      IREC=IREC+1
c      WRITE(IWRITE,1500) IREC,B
C
      IF( B(1:8).EQ.A1 .AND. B(25:32).EQ.A ) return
c
      GO TO 1
C
C---- Process error condition namely, header not found by end of file.
C
 990  WRITE(IWRITE,9900) A,IUNIT
C LRM May 2011: Update IFAIL to 1 to indicate error and return
      IFAIL=1
      RETURN
C      STOP 999
C
C---- Format Statements
C
 1500 FORMAT(10X,'Record No. = ',I6,' Data = ',A)
 9900 FORMAT(/,10X,'**** Error in SEARCH: ',//,
     *       10X,'Attempt to find header (A) = ',A,' on unit = ',I3,/,
     *       10X,'has failed.',/)
C
      END
      subroutine READCIP(nftw,nciset,nocsf,nstat,irrep,s,sz,nelt,nnuc,
     * EIG,VEC,dgem,cname,geonuc,charge,ezero,nsymt,mcont,notgt,nfti,
     * nft,itime,nstat0,ifail,ukrmolp_ints)
c
      use precisn_gbl
      use ukrmol_interface_gbl, only: GET_GEOM
      implicit double precision (a-h,o-z)
C
C**********************************************************************
C
C     READCIP reads CI data from unit NFTW in format used for
C     polyatomic targets
C     Note that MGVN is the value used by CONGEN, not Molecule
C
C**********************************************************************
C
      character(LEN=8) cname(*),cname1
      CHARACTER(LEN=120) NAME
      dimension EIG(*),VEC(*),dgem(*),geonuc(3,*),charge(*),
     *          mcont(*),notgt(*)
      logical, intent(in) :: ukrmolp_ints
      real(kind=wp), allocatable :: ukp_charge(:)
      real(kind=wp), allocatable :: ukp_xnuc(:),ukp_ynuc(:),ukp_znuc(:)
      character(len=8), allocatable :: ukp_cname(:)
      integer :: nnuc1
c
c.... Find file
      call SEARCH(nftw,'CIDATA  ',ifail,nft)
      if(ifail.eq.1) go to 1800
C
 5    READ(NFTW,err=200) Nset,nrec,NAME,nnuc,nocsf,nstat,mgvn,s,sz,
     *                   nelt,e0,nsymt,(mcont(i),notgt(i),i=1,nsymt)
      go to 201
 200  nsymt=0
 201  continue
c
      IF(nset.EQ.nciset)THEN !A.Harvey 1/4/11
         if(mgvn.ne.irrep) go to 1800
      END IF

      do 1 i=1,nnuc
      read(nftw) cname(i),geonuc(1,i),geonuc(2,i),geonuc(3,i),
     *           charge(i)
 1    continue
!      if(nset.ne.nciset) go to 5  !A.Harvey 1/4/11
C
      if(itime.eq.0 .and. nset .eq. nciset) then
C....   Read integral header and check that the geometries match
        IF (ukrmolp_ints) THEN !UKRmol+ input
           call GET_GEOM(nnuc1,ukp_cname,ukp_xnuc,ukp_ynuc,ukp_znuc,
     &                   ukp_charge)
           !UKRmol+ geometry includes the scattering centre so we need to get rid of it
           if (nnuc .ne. nnuc1) go to 1900
           do ii=1,nnuc1
              if (ukp_cname(ii) .ne. cname(ii) .or.
     &            ukp_xnuc(ii) .ne. geonuc(1,ii) .or.
     &            ukp_ynuc(ii) .ne. geonuc(2,ii) .or.
     &            ukp_znuc(ii) .ne. geonuc(3,ii) .or.
     &            ukp_charge(ii) .ne. charge(ii)) go to 1900
           enddo
           deallocate(ukp_cname,ukp_xnuc,ukp_ynuc,ukp_znuc,ukp_charge)
        ELSE !SWEDEN input
           call SEARCH(nfti,'POLYAINP',ifail,nft)
C LRM May 2011: If ifail is not zero then stop program
           if(ifail.ne.0) go to 1810
           read(nfti) nnuc1
           if(nnuc.ne.nnuc1) go to 1900
           do 2 ii=1,nnuc1
              read(nfti) cname1,i,xnuc1,ynuc1,znuc1,charge1
              if(cname1.ne.cname(ii).or.xnuc1.ne.geonuc(1,ii).or.
     *          ynuc1.ne.geonuc(2,ii).or.znuc1.ne.geonuc(3,ii).or.
     *          charge1.ne.charge(ii)) go to 1900
 2         continue
        ENDIF
c
      else if (nset.EQ.nciset) then !A.Harvey 1/4/11
C....   READ CI COEFFICIENTS
        CALL CIVIO (NFTW,1,NOCSF,nstat,EIG,VEC,NALM,dgem)
        IF (NALM.NE.0) GO TO 2900
c....   Add nuclear potential to electronic eigenvalues
        do 3 i=1,nstat0
        eig(i) = eig(i)+e0
 3      continue
c....   Add nuclear pot. to diag. elements for partit R-mat case !amar
        if (nstat .lt. nocsf) then
         do i=1,nocsf
           dgem(i)=dgem(i)+e0
         enddo
        endif
        write(6,*)'Last pole include at',nstat0,
     1            ' is ',eig(nstat0),' Ryd'
      else  !A.Harvey 1/4/11
         READ(nftw)
         DO i=1, nstat
            READ(nftw)
         END DO
      endif
      READ(nftw,END=4)
 4    IF(nset.NE.nciset)GO TO 5
c
      print *, "NSET, MGVN", nset, mgvn
      return
c
 1800 WRITE (nft,1804) irrep,nftw
 1804 FORMAT(/' CIDATA for MGVN=',i1,' NOT FOUND ON UNIT',I3)
      STOP
C LRM May 2011: Stop program if 'POLYAINP' not found on unit nfti
 1810 WRITE (nft,1814) nfti
 1814 FORMAT(/' POLYAINP header NOT FOUND ON UNIT',I3)
      STOP
c
 1900 WRITE(NFT,1910)
 1910 FORMAT(/' Amplitude and SCATCI data are inconsistent ')
      write(nft,1911) cname1,cname(i),nnuc,nnuc1,xnuc1,geonuc(1,i),
     * ynuc1,geonuc(2,i),xnuc1,geonuc(3,i),charge1,charge(i)
 1911 format(1x,2a8,2i5,4(/2f10.6))
      stop
c
 2900 WRITE(NFT,2910)
 2910 FORMAT(/' UNABLE TO GET CI-TARGET VECTOR ')
      stop
c
  100 FORMAT (' SET',I4,4X,A)
  101 FORMAT (10X,'NOCSF=',I5,4X,'NSTAT=',I5,4X,'NNUC =',I5)
  102 FORMAT (10X,'EIGEN-ENERGIES',/(16X,5F20.10))
  120 FORMAT(/' Geometry data,   X         Y         Z'
     1 /(3x,a8,2x,3f10.6))
 2920 FORMAT(/' HAMILTONIAN TRANSFORMATION DATA INCONSISTENT ',2I10)
c
      end
      SUBROUTINE CIVIO (NFT,NRW,NK,NS,EI,CV,NALM,dg)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     CIVIO CONTROLS THE I/O OF CI COEFFICIENTS AND STATE DATA
C
C***********************************************************************
C
      DIMENSION EI(ns),CV(nk,ns),iphz(nk),dg(nk)
C
C     Read/Write ENERGY AND CSF SPECIFICATION FOR EACH CI STATE
C     annd then Read/Write COEFFICIENTS FOR EACH CI STATE
      NALM=0
      IF (NRW.eq.0) then
        WRITE (NFT,ERR=200) iphz,EI,dg
        do 20 i=1,ns
        WRITE (NFT,ERR=200) i,(CV(j,i),j=1,nk)
 20     continue
      else
        if (ns.eq.nk) READ  (NFT,ERR=200) iphz,EI
        if (ns.ne.nk) READ  (NFT,ERR=200) iphz,EI,dg
        do 30 i=1,ns
        READ  (NFT,ERR=200) M,(CV(j,i),j=1,nk)
 30     continue 
      endif
      return
C
 200  nalm=1
      END
      SUBROUTINE PREAMP(LUAMP,insym,nfound,csym,maxnmo,iwrite)
c 
C***********************************************************************
C
C     PREAMP - READS BOUNDARY AMPLITUDE file to get symmetry information
C
C***********************************************************************
c
      IMPLICIT double precision(a-h,o-z)
      CHARACTER(LEN=8)  CUNIQUE,csym(*)
      double precision, allocatable :: AMPS(:)
C
      call search(luamp,'TRUEAMPS',ifail,iwrite)
C LRM May 2011: Stop program if header is not found
      if(ifail.ne.0)go to 994
C
      NFOUND = 0
C
C.... HEADER CARD FOR EACH SYMMETRY
C
 400  READ(LUAMP,END=500,ERR=990) ISYM,NAO,NMO,NUNIQUE
C LRM May 2011: If ISYM and NAO are -1 then we've come to the end of
C the data for this radial point
      if((ISYM.EQ.-1).AND.(NAO.EQ.-1))go to 500
C
C.... BOUNDARY AMPLITUDES FOR EACH COMPONENT
C
      allocate(amps(nmo))
c
      maxnmo = max(maxnmo,nmo)
      if(isym.eq.insym) nfound = nunique
      DO 1 K=1,NUNIQUE
      READ(LUAMP,ERR=992) CUNIQUE,(AMPS(I),I=1,NMO)
      if(isym.eq.insym) csym(k) = cunique
  1   continue
C
C.... LOOP BACK TO READ ANOTHER SYMMETRY SET
C
      deallocate(amps)
      GOTO 400
C
 500  continue
c     WRITE(IWRITE,2900) insym,nfound
C
      RETURN
C
C---- ERROR CONDITION HANDLER
C
C       1. ERROR ON READ OF FILE OF AMPLITUDES AT START IF A SET
C
 990  WRITE(IWRITE,9900)
      STOP 990
C
C       2. ERROR ON READ DURING MIDDLE OF A SET OF AMPLITUDES
C
 992  WRITE(IWRITE,9900)
      STOP 992
C
C       3. LRM May 2011: Header 'TRUEAMPS' not found on unit luamp
C
 994  WRITE(IWRITE,9900)
      WRITE(IWRITE,9910)luamp
      STOP 994
C
 2900 FORMAT(/' Amplitudes file has been scanned successfully ',/
     *        ' Number of angular behaviours for target symmetry',i3,
     *        ' =',i3)
 9900 FORMAT(/,5X,'**** Error in PREAMP : ',/)
C
 9910 FORMAT(/' TRUEAMPS header NOT FOUND ON UNIT',I3)
      END
      subroutine ORDERC(nchan,ntarg,ichl,idchl,idtarg)
      dimension ichl(nchan),idchl(nchan),idtarg(*)
c
c      Sets up pointers for the case where target states output from
c      SCATCI are not in energy order (ie idtarg(i).ne.i for some i)
c
      k = 0
      do 2 j=1,ntarg
      do 1 i=1,nchan
      if(ichl(i).eq.idtarg(j)) then
        k = k+1
        idchl(k) = i
      endif  
 1    continue
 2    continue
c
      return
      end
      subroutine ORDERD(dgem,idpt,nocsf,nstat)
c
c      Sets up pointer energy order Hamiltonian diagonal elements.
c
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      dimension dgem(nocsf),idpt(nocsf)
c                                                                            
      do i=1,nocsf
         idpt(i)=i
      enddo
c                                                                            
      do i=1,nocsf-1
        dlow=dgem(idpt(i))
        do j=i+1,nocsf
           if (dlow .gt. dgem(idpt(j))) then
              dlow=dgem(idpt(j))
              ij=idpt(j)
              idpt(j)=idpt(i)
              idpt(i)=ij
           endif
        enddo
      enddo
c      write(6,*) 'Diagonal element number ',nstat,'at',dgem(idpt(nstat))
c
      return
      end
C
      SUBROUTINE READ_AMP_HEADER_INFO(NUM_PTS_NEEDING_BNDRY_AMPS,
     &                                DIST_BTN_PTS_NEEDING_BNDRY_AMPS,
     &                                LUAMP,camp_pts,IWRITE)
C**********************************************************************
C Change by Laura Moore, May 2011: this routine enables the
C calculation of surface amplitudes at a number of radial distances
C It reads header information output from swedmos.  This header
C information is marked by the flag CAMP_PTS and it comprises 
C the number of radial points at which the amplitudes are to be 
C calculated (NUM_PTS_NEEDING_BNDRY_AMPS) and the distance 
C between them (DIST_BTN_PTS_NEEDING_BNDRY_AMPS)
C Note that the first point is always on the R-matrix boundary
C itself and any additional points are located inside R-matrix
C boundary.  
C If the header cannot be found then assume default values
C
C OUTPUT DATA:
C     NUM_PTS_NEEDING_BNDRY_AMPS      Number of radial points at which
C                                     amplitudes are to be calculated
C
C     DIST_BTN_PTS_NEEDING_BNDRY_AMPS The distance between these points
C
C**********************************************************************
      IMPLICIT NONE
      INTENT(IN)  :: LUAMP,CAMP_PTS,IWRITE
      INTENT(OUT) :: NUM_PTS_NEEDING_BNDRY_AMPS,
     &               DIST_BTN_PTS_NEEDING_BNDRY_AMPS
      INTEGER :: NUM_PTS_NEEDING_BNDRY_AMPS,LUAMP,IWRITE,IFAIL
      DOUBLE PRECISION :: DIST_BTN_PTS_NEEDING_BNDRY_AMPS
      CHARACTER(LEN=8) :: CAMP_PTS
C      
C      
      CALL SEARCH(LUAMP,CAMP_PTS,IFAIL,IWRITE)
      IF(ifail.NE.0)THEN
C Assume default values
         NUM_PTS_NEEDING_BNDRY_AMPS=1
         DIST_BTN_PTS_NEEDING_BNDRY_AMPS=0.0
         WRITE(IWRITE,8030) LUAMP,NUM_PTS_NEEDING_BNDRY_AMPS
      ELSE
         READ(LUAMP)NUM_PTS_NEEDING_BNDRY_AMPS
         READ(LUAMP)DIST_BTN_PTS_NEEDING_BNDRY_AMPS
      END IF
C  An error check on value of NUM_PTS_NEEDING_BNDRY_AMPS
      IF ((NUM_PTS_NEEDING_BNDRY_AMPS.GT.3).OR. 
     &    (NUM_PTS_NEEDING_BNDRY_AMPS.LT.1)) THEN 
         WRITE(IWRITE,9960) NUM_PTS_NEEDING_BNDRY_AMPS,LUAMP
         STOP 9960
      END IF
C
C      
      RETURN
C
C LRM, May 2011:
 8030 FORMAT(10X,'******  WARNING IN READ_AMP_HEADER_INFO ****** : ',/,
     &       10X,' Header CAMP_PTS (defined in SW_INTERF) not',
     &       /,10X,' found in unit LUAMP.',/,10X,' Unit LUAMP ',
     &       'is unit ',I3,/,10X,' Continue using ',
     &       ' the following default value: ',/,10X,' Number of ',
     &       ' radial points at which surface amplitudes ',/,10X,
     &       ' are needed = ',I3,/,10X,' i.e. only calculate surface',
     &       ' amplitudes on the R-matrix ',/,10X,' boundary.  This',
     &       ' is OK for all runs unless you want to ',/,10X, 
     &       ' generate input for subsequent R-matrix incorporating',
     &       /,10X,' time (RMT) calculations',/,10X,
     &       ' ************************************************ ',/)
C
 9960 FORMAT(10X,' ****** ERROR in READ_AMP_HEADER_INFO ******',
     &       /,10X,' Number of radial points at which surface ',
     &       'amplitudes',/,10X,' are needed = ',I3,' but ',
     &       'NUM_PTS_NEEDING_BNDRY_AMPS',/,10X,' should be in the ',
     &       'range 1 to 3.',/,10X,' This is because ',
     &       ' header names for data on unit LUAMP',
     &       /,10X,' (unit ',I3,') are only defined in', 
     &       ' SW_INTERF',/,10X,' for up to 3 radial points.',/,
     &       10X,' The default setting is 1 to calculate amplitudes ',
     &       /,10X,' only on the R-matrix boundary - OK for all runs',
     &       /,10X,' unless you want to generate input for subsequent',
     &       /,10X,' R-matrix incorporating time (RMT) calculations',
     &       /,10X,' in which case NUM_PTS_NEEDING_BNDRY_AMPS should',
     &       /,10X,' be set to 3 in the GAUSTAIL namelist.',/)
C      
      END

C     
C     Read target phases and transform to energy order pw channel phases
C     then write the channel phases to file for reading by rsolve.
C
      
      subroutine construct_channel_phases( ichl,nchan,idtarg,ntarg,
     &                                      ichannel_phases)
      implicit none
      
!     Arguments
      integer :: nchan,ichl(nchan),idtarg(*),ntarg,
     &           ichannel_phases(nchan)      
!     Local
      integer :: ntarg2,  ichan, itarg, isym,itarg_relative, j    
      integer, allocatable :: target_phases(:), targ_sym(:), targ_ir(:) 
        
      open(UNIT=66666, FILE='target.phases.data')
      read(66666,*) ntarg2     
      
      allocate(target_phases(ntarg2),targ_sym(ntarg2),targ_ir(ntarg2))
      target_phases=1;targ_sym=0;targ_ir=0
      do itarg=1, ntarg2
         read(66666,*) targ_sym(itarg), targ_ir(itarg),
     &                 target_phases(itarg)
      end do
      close(66666)      
      
      do itarg=1,ntarg
         do ichan=1,nchan
            if(ichl(ichan).eq.idtarg(itarg)) then
               ichannel_phases(ichan) = target_phases(itarg)
      
            endif  
         end do
      end do

      open(UNIT=66666, FILE='channel.phases.data')
      
      write(66666,'(i10)') nchan
      do ichan=1,nchan
         write(66666,'(i3)') ichannel_phases(ichan)
      
      end do 
      close(66666)        

      end subroutine construct_channel_phases
      
      subroutine apply_channel_phases(wamp2,nchan,nstat0,
     &                                ichannel_phases)
      implicit none
      
!     Arguments
      integer :: nchan, nstat0, ichannel_phases(nchan)      
      double precision :: wamp2(nchan,*)
!     Local  
      integer :: ichan, istat
      
      do ichan=1, nchan
         do istat=1,nstat0      
            wamp2(ichan,istat)=ichannel_phases(ichan)*wamp2(ichan,istat)
         end do
      end do
      
      end subroutine apply_channel_phases
