! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE R_SOLVE(ifail)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     MAXIMUM DIMENSIONS ARE SET BY THE FOLLOWING PARAMETER STATEMENT
C     VARIABLE DIMENSIONS ARE USED IN ALL LOWER LEVEL ROUTINES, EXCEPT
C     VIBINI 
C
      PARAMETER (MAXPTS=30,MAXTGT=50,MAXENR=10)
C
C     MAXPTS = MAXIMUM NUMBER OF GEOMETRIES
C     MAXTGT = MAXIMUM NUMBER OF TARGET ELECTRONIC STATES
C     MAXENR = MAXIMUM NUMBER OF INPUT SCATTERING ENERGY PAIRS (E0,DE)
C
      CHARACTER(LEN=80) NAME
      CHARACTER(LEN=11) RFORM,CHFORM,WFORM,KFORM,NRFORM,VCFORM,MODDAT
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=1) IRFORM,ICFORM,IWFORM,IKFORM,INRFRM,IVCFRM
      CHARACTER(LEN=3) EUNIT(2)
      CHARACTER BLANK*8, daytim*20
      INTEGER STOT,GUTOT
      DIMENSION RK(MAXPTS+4),R(MAXPTS),IPRNT(6),ezero(maxpts),
     3 EINC(2,MAXENR),NESCAT(MAXENR),NVTARG(MAXTGT),EINR(2,MAXENR),
     5 NCHSET(MAXPTS),NRMSET(MAXPTS),ivt0(2),ivu0(2),vec(1),DUM1(1),
     7 DUM2(1,1)
      integer, allocatable :: ichord(:),ivtarg(:),ivnu(:),starg(:),
     * gtarg(:),mtarg(:),ivchl(:),lvchl(:),mvchl(:),ichl(:),ncsf(:)
      double precision, allocatable :: rvib(:),rmn(:),fx(:),fxp(:),
     * akmat(:),rres(:),ampn(:),eign(:),cf(:),evib(:),etarg(:),
     * vibfn(:),rquad(:),qwts(:),evchl(:),epole(:),wamp(:),butc(:),
     * adm(:),fv(:),fvp(:),fd(:),fdp(:),crv(:),crd(:),bloch(:),
     * amc(:),adc(:),sfac(:),ecex(:),rcex(:)
      double precision :: dummy(2), idummy(2)
      EXTERNAL POTL,DISPOT
      LOGICAL QMOLN

C
C***********************************************************************
C
C     BASIC DATA IS INPUT VIA NAMELIST /RSLVIN/
C     OTHER DATA IS INPUT VIA NAMELISTS IN ROUTINES VIBINI AND ASYM1
C
C      BBLOCH   = COEFFICIENT IN ELECTRONIC BLOCH OPERATOR
C      BIGB     = COEFFICIENT IN NUCLEAR BLOCH OPERATOR
C      EINC     = Scattering energies relative to lowest (vibrational)
C                 level of target 
C                 EINC(1,I) = initial energy in sub range I
C                 EINC(2,I) = energy increment in this subrange
C                 units are as specified by IEUNIT
C      GUTOT    = G/U SYMMETRY OF TOTAL SYSTEM +1=G, -1=U
C      ICFORM   = Formatted/unformatted switch for unit LUCHAN
C      IEUNIT   = UNITS IN WHICH INPUT SCATTERING ENERGIES ARE INPUT
C                 1= RYD, 2= EV
C      IKFORM   = Formatted/unformatted switch for unit LUKMT
C      INRFRM   = Formatted/unformatted switch for unit LUNRMT
C      IPRNT    = DEBUG PRINT SWITCHES
C                 (1) =1 Print all input data
C                 (2) =1 Print vibrational wavefuction data
C                 (3) =1 Debug output in dissociating channels
C                 (4)  not used
C                 (5) =1 Print R-matrices
C                 (6) =1 Print all output data
C      IRFORM   = Formatted/unformatted switch for unit LURMT
C      ISMAX    = Highest multipole to be used in asymptotic expansion
C                 of asymptotic potentials
C      IWFORM   = Formatted/unformatted switch for unit LUWFN
C      IWRITE   = Logical unit for printed output
C      LUCHAN   = Logical unit holding fixed nuclei channel and target 
C                 data
C      LUKMT    = LOGICAL UNIT FOR K-MATRIX OUTPUT 
C      LUWFN    = Logical unit for R-matrix and wavefunction output
C      LUNRMT   = Logical unit holding non adiabatic R-matrix data
C      LURMT    = Logical unit holding fixed nuclei R-matrix data
C      LUVCHN   = Logical unit holding vibrational/dissociating
C                 channel data
C      MDMAX    = maximum multipole to be retained in expansion of
C                 asymptotic internuclear (dissociation) potential
C      MGVN     = TOTAL SYMMETRY OF SYSTEM
C      NAME     = TITLE FOR OUTPUT
C      NCHSET   = Set numbers for input fixed nuclei channel/target
C                 data for each geometry
C      NDIS     = NUMBER OF DISSOCIATING CHANNELS
C      NERANG   = Number of subranges of scattering energies
C      NESCAT   = NUMBER OF INPUT SCATTERING ENERGIES in each subrange
C      NEWBUT   = switch on energy parameter in Buttle correction
C      NGEOM    = NUMBER OF GEOMETRIES
C      NKSET    = Set number for output K-matrices 
C      NNRSET   = Set number for input non-adiabatic R-matrix data
C      NPOLE    = NUMBER OF ELECTRONIC R-MATRIX POLES TO BE TREATED
C                 NON-ADIABATICALLY
C      NRMSET   = Set numbers for input fixed nuclei R-matrix data for
C                 each geometry
C      NRQUAD   = NUMBER OF QUADRATURE POINTS FOR INTEGRALS IN ADIABATIC
C                 APPROXIMATION ( IF =0 THEN CODE DECIDES)
C      NVCHSET  = Set number for input vibrational/dissociating channel
C                 data
C      NVTARG   = NUMBER OF VIBRATIONAL LEVELS FOR EACH TARGET STATE
C      NWSET    = Set number for output R-matrices and wavefunctions
C      R        = ARRAY HOLDING INTERNUCLEAR SEPARATIONS
C      STOT     = SPIN MULTIPLICITY 2*S+1 WHERE S = TOTAL SPIN OF SYSTEM
C
      NAMELIST/RSLVIN/LUCHAN,LURMT,LUVCHN,LUNRMT,LUKMT,LUWFN,NPOLE,NDIS,
     1                BBLOCH,BIGB,NGEOM,R,IWRITE,ISMAX,NAME,NESCAT,EINC,
     *                IPRNT,NCHSET,NRMSET,NVCSET,NNRSET,NKSET,NRQUAD,
     3                ICFORM,IRFORM,IVCFRM,INRFRM,IKFORM,NERANG,NWSET,
     4                MGVN,STOT,GUTOT,IEUNIT,NVTARG,MDMAX,IWFORM,NLPOLE,
     *                nbigset,newbut,QMOLN
C
C***********************************************************************
C
      DATA IREAD,IWRITE,LUCHAN,LURMT,LUKMT,LUWFN/5,6,10,21,19,0/,
     1 LUVCHN,LUNRMT/28,29/,IPRNT/6*0/,NERANG/1/,IEUNIT/1/,newbut/1/,
     2 NKNOT/0/,IVPROP/1/,IDPROP/1/,NPOLE/0/,NVIB/0/,NDIS/0/,
     3 EINC/MAXENR*0.D0,MAXENR*0.D0/,NVCSET,NNRSET,NKSET,NWSET/4*1/,
     4 ISMAX/-1/,BBLOCH,BIGB/2*0.D0/,NVTARG/MAXTGT*1/,NRQUAD/0/,NGEOM/1/
     5,NESCAT/MAXENR*10/,NLPOLE/1/,nbigset/1/,QMOLN/.FALSE./
      DATA ZERO/0.D0/,HALF/0.5D0/,ONE/1.D0/,TWO/2.D0/,NCOL/6/,MDMAX/-1/
      DATA FORM,CHFORM,RFORM,VCFORM,NRFORM,KFORM,WFORM/7*'FORMATTED'/
     1,ICFORM,IRFORM,IVCFRM,INRFRM,IKFORM,IWFORM/6*'U'/
      DATA EUNIT/'RYD','EV'/,RYD/0.073500D0/,BLANK/'        '/
      DATA IBACK/1/
      DATA MODDAT/'05-Jan-2004'/
C
C---- WRITE HEADER
!      WRITE(*,*)
!      WRITE(*,*) ' This is a modified version of the program that'
!      WRITE(*,*) 'allows to automatically propagate inwards or '
!      WRITE(*,*) 'outwards.'
!      WRITE(*,*) ' Modified by Jimena Gorfinkiel.'
C---- SET UP DEFAULT VALUES OF POINTERS NCHSET AND NRMSET 
      DO 111 I=1,MAXPTS
      NCHSET(I) = I
      NRMSET(I) = I
      r(i) = zero
 111  continue
C
      IFAIL = 0
      NEXT = 1
      GUTOT = 0
C
C---- Read basic data via namelist /RSLVIN/
      READ(5,RSLVIN)
      IF(ICFORM.EQ.'U') CHFORM='UN'//FORM
      IF(IRFORM.EQ.'U') RFORM='UN'//FORM
      IF(INRFRM.EQ.'U') NRFORM='UN'//FORM
      IF(IKFORM.EQ.'U') KFORM='UN'//FORM
      IF(IWFORM.EQ.'U') WFORM='UN'//FORM
      IF(IVCFRM.EQ.'U') VCFORM='UN'//FORM
C
      IF(NGEOM.GT.MAXPTS) GO TO 96
C
C---- Date stamp run and print title
      CALL DATEST(DAytim)
      NAME(61:) = DAytim
      WRITE(IWRITE,12)MODDAT,NAME,MGVN,STOT,GUTOT
      IF(NGEOM.EQ.1) THEN
        WRITE(IWRITE,20) R(1)
      ELSE
        WRITE(IWRITE,10)NDIS,(R(I),I=1,NGEOM)
      ENDIF
      IF(NCHSET(NGEOM).EQ.0.OR.NRMSET(NGEOM).EQ.0) GO TO 89
      WRITE(IWRITE,11)CHFORM,LUCHAN,(NCHSET(IG),IG=1,NGEOM)
      WRITE(IWRITE,33)RFORM,LURMT,(NRMSET(IG),IG=1,NGEOM)
      IF(NGEOM.GT.1) WRITE(IWRITE,21)VCFORM,LUVCHN,NVCSET,NRFORM,
     1LUNRMT,NNRSET
      WRITE(IWRITE,31)KFORM,LUKMT,NKSET
      IF(LUWFN.NE.0) WRITE(IWRITE,32) WFORM,LUWFN,NWSET
C
C---- Calculate total number of scattering energies, NESC and max and 
C     min energies EMIN and EMAX
      EMIN = EINC(1,1)
      EMAX = EMIN
      NESC = 0
      DO 9 IEN=1,NERANG
      NESC = NESC+NESCAT(IEN)
      EMIN = MIN(EMIN,EINC(1,IEN))
      EMAX = MAX(EMAX,EINC(1,IEN)+NESCAT(IEN)*EINC(2,IEN))
 9    CONTINUE
      WRITE(IWRITE,13) NESC,EMIN,EMAX,EUNIT(IEUNIT)
C
C---- Convert scattering energies to Rydbergs
      IF(IEUNIT.EQ.2) THEN
        EMINR = EMIN*RYD
        EMAXR = EMAX*RYD
        DO 36 IEN=1,NERANG
        EINR(1,IEN) = EINC(1,IEN)*RYD
        EINR(2,IEN) = EINC(2,IEN)*RYD
 36     continue
      ELSE
        EMINR = EMIN
        EMAXR = EMAX
        DO 37 IEN=1,NERANG
        EINR(1,IEN) = EINC(1,IEN)
        EINR(2,IEN) = EINC(2,IEN)
 37     continue
      ENDIF
C
C---- Find first fixed-nuclei R-matrix input set and read dimension 
C     information
      WRITE(IWRITE,17)
      CALL READRH(LURMT,NRMSET(nbigset),RFORM,MGVN,STOT,GUTOT,NCHANF,
     1 NVIB0,NDIS0,NTARG,ION,R(1),RMASS,RMATR,NFBUT,ISMX,nstat,NOCSF,
     2 NPLX,ezero(1),iex,IWRITE,IPRNT(1),IFAIL)
      IF(IFAIL.NE.0) RETURN
      TWOM = TWO*RMASS
C
C---- Read header on non-adiabatic R-matrix file
      IF(NGEOM.GT.1) THEN
        WRITE(IWRITE,19)
        CALL READRH(LUNRMT,NNRSET,NRFORM,MGVN,STOT,GUTOT,NCHANS,NVIB,
     1  NDISS,NTARGv,ION,ZERO,RMASS,RMATN,NNBUT,ISMVX,nstat,NHD,
     2  NPVEC,ezero(1),iex,IWRITE,IPRNT(1),IFAIL)
        IF(IFAIL.NE.0) RETURN
        IF(NDISS.NE.NDIS.AND.NDIS.GT.0) THEN
          WRITE(IWRITE,23) NDIS,NDISS
          NDIS = NDISS
        ENDIF
        NCHAN = NCHANS
        RR = ZERO
      ELSE
        NVIB = 0
        NDIS = 0
        NCHAN = NCHANF
        ntargv = ntarg
        RR = R(1)
        ISMVX = ISMX
      ENDIF
      IF(ISMAX.EQ.-1.OR.ISMAX.GT.ISMX) THEN
        ISFMAX = ISMX
      ELSE
        ISFMAX = ISMAX
      ENDIF
      WRITE(IWRITE,34) ISFMAX
      IF(NDIS.NE.0) THEN
        IF(MDMAX.EQ.-1.OR.MDMAX.GT.ISMVX) MDMAX=ISMVX
        WRITE(IWRITE,35) MDMAX
      ENDIF
      ISMAX = MAX(ISFMAX,MDMAX)
C
C---- Assign storage for fixed nuclei data
      ntv = max(ntarg,NTARGv)
      ncf = max(NCHAN,nchanf)
      allocate (etarg(ngeom*ntv),starg(ntv),mtarg(ntv),gtarg(ntv))
      allocate (evchl(ncf),lvchl(ncf),mvchl(ncf),ivchl(ncf))
      allocate (epole(nstat*ngeom),wamp(nstat*NCHANF*NGEOM),
     * ichl(nchanf),butc(3*NCHANF*NGEOM),amc(ISMAX*NCHAN*NCHAN),
     * adc(MDMAX*NDIS*NDIS),adm(5*ndis),cf(ISMAX*ncf*(ncf+1)/2),
     * ncsf(ngeom))
      if (abs(nfbut).gt.1) allocate(sfac(nchanf*ngeom),
     * ecex(iex*ngeom),rcex(iex*nchanf*ngeom))
C
C---- LOOP OVER GEOMETRIES
      WRITE(IWRITE,17)
      DO 2 IG=1,NGEOM
C
C---- Storage allocation for current geometry
      IG1 = IG-1
      IET = 1+IG1*NTARG
      IEG = 1+IG1*nstat
      IWA = 1+IG1*nstat*NCHANF
      IBUT =1+IG1*3*NCHANF
      isf  =1+IG1*nchanf
      iec  =1+IG1*iex
      irc  =1+IG1*iex*nchanf
C
C
C---- Read target and channel data 
      NCHAN0 = NCHANF
      NTARG0 = NTARG
      CALL READTC(LUCHAN,NCHSET(IG),NCHAN0,NVIB0,NDIS0,NTARG0,ION,IVT0,
     1 IVU0,ICHL,LVCHL,MVCHL,EVCHL,STARG,MTARG,GTARG,etarg(IET:),R(IG),
     * RMASS,CHFORM,IWRITE,IPRNT(1),IFAIL)
      IF(NCHAN0.NE.NCHANF.OR.NTARG0.NE.NTARG) GO TO 92
C
C---- Read R-matrix header 
      CALL READRH(LURMT,NRMSET(IG),RFORM,MGVN,STOT,GUTOT,NCHAN0,NVIB0,
     * NDIS0,NTARG0,ION,R(IG),RMASS,RMATR,NFBUT,ISMX,NCSF(ig),nci,
     2 NPLX,ezero(ig),iex,IWRITE,IPRNT(1),IFAIL)
      IF(NCHAN0.NE.NCHANF.OR.NTARG0.NE.NTARG) GO TO 92
C
C---- Read remainder of fixed nuclei R-matrix data
      if (abs(nfbut).gt.1) then
      CALL READRM(LURMT,RFORM,NCHANF,NCSF(ig),nci,ISMX,isfmax,NPLX,0,
     1 NFBUT,cf,epole(IEG:),wamp(IWA:),vec,butc(IBUT:),sfac(isf:),
     2 iex,ecex(iec:),rcex(irc:),IFAIL)
      else
      CALL READRM(LURMT,RFORM,NCHANF,NCSF(ig),nci,ISMX,isfmax,NPLX,0,
     1 NFBUT,cf,epole(IEG:),wamp(IWA:),vec,butc(IBUT:),DUM2,
     2 iex,DUM1,DUM1,IFAIL)
      endif
      IF(IFAIL.NE.0) RETURN
C
 2    CONTINUE
C
      IF(NGEOM.EQ.1) THEN
C
C---- Set up fixed nuclei calculation
        e0 = etarg(1)
        NVCHAN = NCHAN
C
      ELSE
        WRITE(IWRITE,22)
        NVCHAN = NCHAN-NDISS
        IF(NDIS.EQ.0) NCHAN = NVCHAN
C
C---- Read vibrational channel data 
        NVIBD = NVIB+NDIS
        allocate (evib(ntargv),ivtarg(nvibd),ivnu(nvibd))
c
        CALL READTC(LUVCHN,NVCSET,NCHAN,NVIB,NDIS,NTARGv,ION,IVTARG,
     1  IVNU,IVCHL,LVCHL,MVCHL,EVCHL,STARG,
     2  MTARG,GTARG,Evib,ZERO,RMASS,VCFORM,IWRITE,IPRNT(1),IFAIL)
c
        deallocate(evib,ivtarg,ivnu)
C
C---- Initialize acquisition of vibrational functions
        EBASE = zero
        CALL VIBINI(IREAD,IWRITE,NTARG,NVTARG,RMASS,ebase,IPRNT(2))
        WRITE(IWRITE,47) EBASE
C
C---- Set up quadrature scheme for integrals in adiabatic nuclei approx
        IF(NRQUAD.EQ.0) THEN
C     THIS IS A BIT ARBITRARY AND NOT THOROUGHLY TESTED
          NQUAD = 15*NVIB+1
          IF(MOD(NQUAD,2).EQ.0) NQUAD=NQUAD+1
        ELSE
          NQUAD = NRQUAD
        ENDIF
        allocate (rquad(nquad),qwts(nquad))
C
        CALL VMESH(R(1),R(NGEOM),NQUAD,RQUAD,QWTS)
C
C---- Initialize spline interpolation
        CALL SPLINI(NKNOT,KNOTS,RK,MAXPTS,NGEOM,R,IWRITE)
C
C----- GET TARGET VIBRATIONAL WAVEFUNCTIONS ON QUADRATURE MESH
c
        allocate (evib(nvibd),ivtarg(nvibd),ivnu(nvibd),ichord(nvchan),
     *  vibfn(NVIB*NQUAD))
C
       CALL RVIBR(NVIB,NQUAD,EVIB,IVTarg,IVnU,VIBFN,dum,RQUAD)
       e0 = evib(1)
C
c---- Set up pointer from VIBINI ordering to channel ordering
        if(ntarg.gt.1) call REORDI(nvchan,evchl,nvib,evib,ichord)
C
        IF(IPRNT(2).GT.0) CALL CHECKQ(NQUAD,NVIB,QWTS,VIBFN,IWRITE)
C
C---- Storage allocation for non-adiabatic data
        allocate (ampn(nstat*NCHANS),eign(nstat))
C
C---- Read rest of non-adiabatic R-matrix file
        CALL READRM(LUNRMT,NRFORM,NCHANS,nstat,NHD,ISMVX,ISMAX,0,0,0,cf,
     1  EIGn,AMPn,DUM1,DUM2,DUM1,0,DUM1,DUM1,IFAIL)
C
      ENDIF
C
C---- Save multipole coefficients as square matrix
      IF(ISMAX.GT.0) THEN
        CALL SQUARM(NVCHAN,ISMAX,cf,AMC)
        IF(NDIS.GT.0.AND.MDMAX.GT.0) THEN
C---- Unpack dissociation potential data.  This code must match
C     DISINI in VIBRMT
          ITEMPD = ISMAX*NVCHAN*(NVCHAN+1)/2+1
          ND2 = NDIS*(NDIS+1)/2+6*NDIS
          CALL SPLITM(NDIS,ND2,MDMAX,cf(ITEMPD),ADC,ADM)
        ENDIF
      ENDIF
      deallocate (cf)
C
C----- INITIALIZE ASYMPTOTIC ROUTINES FOR VIBRATIONAL CHANNELS
      IF(NVCHAN.GT.0) THEN
        RAFINV = RMATR
        SCALE = ONE
        CALL ASYM1(NVCHAN,LVCHL,ION,ISMAX,AMC,RMATR,RAFINV,
     1  SCALE,BBLOCH,EVCHL,EMINR,EMAXR,IVPROP,POTL,IWRITE)
      ENDIF
C
C----- INITIALIZE ASYMPTOTIC ROUTINES FOR DISSOCIATING CHANNELS
      IF(NDIS.GT.0) THEN
        EMINM = TWOM*EMINR
        EMAXM = TWOM*EMAXR
        IF(IVPROP.EQ.0) IDPROP=0
        RAFIND = RMATN
        SCALE = ONE/TWOM
        CALL ASYM1(NDIS,LVCHL(1+NVCHAN),0,MDMAX,ADC,RMATN,RAFIND,
     1  SCALE,BIGB,EVCHL(1+NVCHAN),EMINM,EMAXM,IDPROP,DISPOT,IWRITE)
        IF(IDPROP.NE.IVPROP) GO TO 94
      ELSE
        IDPROP = 0
      ENDIF
C
C----- INITIALIZE OUTPUT OF K-MATRICES 
      IF(LUKMT.NE.0) CALL WRITKH(LUKMT,NKSET,KFORM,NAME,MGVN,STOT,
     1 GUTOT,ION,RR,RMASS,NCHAN,NVIB,NDIS,NTARG,NERANG,NESCAT,EINR,
     2 NESC,IPRNT(6),IWRITE,IFAIL)
C
C----- Initialize output of R-matrices and wavefunctions
      IF(LUWFN.NE.0) CALL WRITWH(LUWFN,NWSET,WFORM,NAME,MGVN,STOT,
     1 GUTOT,ION,RR,RMASS,NCHAN,NVIB,NDIS,NTARG,NERANG,NESCAT,EINR,
     2 NESC,IPRNT(6),IWRITE,IFAIL)
C
C---- Store Bloch coefficients
      allocate (bloch(nvchan+ndis))
      DO 4 I=1,NVCHAN
      BLOCH(I) = BBLOCH
 4    continue
      DO 5 I=1,NDIS
      BLOCH(NVCHAN+I) = BIGB 
5     continue
C
C---- Storage allocation for energy loop
      NCHSQ= NCHAN*NCHAN
      NVCHSQ = NVCHAN*NVCHAN
      allocate (rvib(nchsq),fx(2*nchsq),fxp(2*nchsq),fv(2*nvchsq),
     * fvp(2*nvchsq),fd(2*ndis*ndis),fdp(2*ndis*ndis),akmat(nchsq),
     * rres(NGEOM*NCHANF*(NCHANF+1)/2),crv(2*NVCHSQ+NVCHAN),
     * crd(NDIS*(2*NDIS+1))) 
      if(npole.gt.0) allocate (rmn(NCHAN*(NCHAN+1)/2))
C
C-----------------------------------------------------------------------
C
C     ENERGY LOOP
C
      NRK = 0
      IEN = 0
C
      DO 50 IES=1,NERANG
      NES = NESCAT(IES)
      ENRYD = EINR(1,IES)
      DE    = EINR(2,IES)
C
      DO 40 IE=1,NES
      ETOT  = e0+HALF*ENRYD
      IF(IPRNT(5).GT.0.OR.IPRNT(6).GT.0) WRITE(IWRITE,28) ENRYD
C
      NVOPEN = 0
      NDOPEN = 0
      ifail = 0
C
C---- Calculate contribution to R-matrix from non-adiabatic poles
      IF(NPOLE.GT.0) THEN
        CALL VRMAT2(NCHAN,NHD,RMN,ETOT,AMPn,EIGn,NLPOLE)
        IF(IPRNT(5).NE.0) THEN
          WRITE(IWRITE,24) NPOLE
          CALL MATTPT(NCHAN,RMN,IWRITE)
        ENDIF
      ENDIF
C
C----- CALCULATE CONTRIBUTIONS TO FIXED NUCLEI R-MATRICES FROM HIGHER
C      POLES
      if(newbut.eq.0) nfbut=-nfbut
      if (abs(nfbut).gt.1) then
      CALL RESIDR(ETOT,NCHANF,NTARG,ETARG,NLPOLE,NPOLE,nstat,
     1     NGEOM,ncsf,ichl,WAMP,EPOLE,NFBUT,BUTC,RRES,ezero,sfac,
     2     iex,ecex,rcex,IWRITE,IFAIL)
      else
      CALL RESIDR(ETOT,NCHANF,NTARG,ETARG,NLPOLE,NPOLE,nstat,
     1     NGEOM,ncsf,ichl,WAMP,EPOLE,NFBUT,BUTC,RRES,ezero,dummy,
     2     iex,dummy,dummy,IWRITE,IFAIL)
      endif
      IF(IFAIL.NE.0) THEN
        IF(IEUNIT.EQ.2) Entop = Enryd/RYD
        IF(IFAIL.EQ.1) THEN
          WRITE(IWRITE,39) ENtop,eunit(ieunit)
          IFAIL = 0
          GO TO 50
        ELSE
          WRITE(IWRITE,38) ENtop,eunit(ieunit)
          IFAIL = 0
          GO TO 40
        ENDIF
      ELSE
        IEN = IEN+1
      ENDIF
C
C----- CALCULATE RESIDUAL R-MATRIX IN THE ADIABATIC NUCLEI APPROX. AND
C      ADD IT TO THE VIBRATIONAL R-MATRIX OBTAINED IN VRMAT2.  A SQUARE
C      MATRIX IS OUTPUT FOR INPUT TO ASYMPTOTIC CODE.
C
      IF(npole.GT.0) THEN
        CALL ADNUC(NGEOM,R,NCHANF,ICHL,NTARG,NVTARG,VIBFN,KNOTS,
     1  RK,NVCHAN,RRES,RVIB,dum,1,NQUAD,RQUAD,QWTS)
c
c---- Reorder elements to match channel labels
        if(ntarg.gt.1) call REORDV(nvchan,ichord,rvib)
c
C     Add adiabatic component of R-matrix to the non-adiabatic
        K = 0
        IJ = 0
        DO 71 I=1,NVCHAN
        DO 7 J=1,I
        K = K+1
        IJ = IJ+1
        rmn(K) = rmn(K)+rvib(IJ)
 7      continue
 71     continue
        CALL SQUARM(NCHAN,1,RMN,RVIB)
      ELSE
        CALL SQUARM(NCHAN,1,RRES,RVIB)
      ENDIF
C
      IF(IPRNT(5).GT.0) THEN
        WRITE(IWRITE,14)
        CALL WRECMT(RVIB,NCHAN,NCHAN,NCHAN,NCHAN,NCOL,IWRITE)
      ENDIF
C
C----- GET SOLUTIONS, DERIVATIVES AND GLOBAL R-MATRIX IN VIBRATIONAL
C      CHANNELS AT R=RAFINV
      IF(NVCHAN.GT.0) THEN
        CALL ASYM2(NVCHAN,NVOPEN,LVCHL,ION,ISMAX,AMC,CRV,
     1  RAFINV,EVCHL,ENRYD,FV,FVP,IVPROP,ifail)
        if(ifail.gt.1) go to 41
        ifail = 0
      ENDIF
C
C----- GET SOLUTIONS, DERIVATIVES AND GLOBAL R-MATRIX IN DISSOCIATING
C      CHANNELS AT R=RAFIND
      IF(NDIS.GT.0) THEN
        E2M = RMASS*ENRYD
        CALL ASYM2(NDIS,NDOPEN,LVCHL(1+NVCHAN),ION,MDMAX,ADC,
     1  CRD,RAFIND,EVCHL(1+NVCHAN),E2M,FD,FDP,IDPROP,ifail)
        if(ifail.gt.1) go to 41
        ifail = 0
C
C----- IF NO PROPAGATION MUST USE NUMERICAL INTEGRATION
        IF(IDPROP.EQ.0.AND.RAFIND.GT.R(NGEOM)) CALL ASYMD(E2M,NDIS,
     1  TWOM,R(NGEOM),RAFIND,EVCHL(1+NVCHAN),FD,FDP,ADM,
     2  IWRITE,IPRNT(3))
      ENDIF
C
C----- MERGE SOLUTIONS AND DERIVATIVES
      NOPEN = NVOPEN+NDOPEN
      if(nopen.eq.0) go to 40
      CALL MERGE(NCHAN,NVCHAN,NDIS,NVOPEN,NDOPEN,FX,FXP,FV,FVP,FD,FDP)
C
      if(RMATR.gt.RAFINV) IBACK=-1
C----- PROPAGATE R-MATRICES IF REQUIRED
      IF(IDPROP.GT.0.OR.IVPROP.GT.0)
     1  CALL RPROPX(NCHAN,NVCHAN,NDIS,CRV,CRD,RVIB,IPRNT(5),IWRITE,
     2  IBACK)
C
C----- COMPUTE K-MATRIX
      CALL KMAT(NCHAN,BLOCH,NOPEN,FX,FXP,RVIB,AKMAT)
C
      IF(IPRNT(6).GT.0) THEN
        WRITE(IWRITE,15)
        CALL WRECMT(AKMAT,NOPEN,NOPEN,NOPEN,NOPEN,NCOL,IWRITE)
      ENDIF
      IF(LUKMT.GT.0) CALL WRITKM(NOPEN,NDOPEN,ENRYD,AKMAT)
      IF(LUWFN.GT.0) CALL WRITWF(NCHAN,NOPEN,ENRYD,FX,FXP)
C
      NRK=NRK+1
 41   ENRYD = ENRYD+DE
 40   continue
 50   CONTINUE
C
      IF(IEN.LE.0) IFAIL=1
C
C     END OF ENERGY LOOP
C
C-----------------------------------------------------------------------
C
! DO NOT REMOVE. This is for Quantemol-N
! open a file fort.448 to write a number of energy points for which 
! K-matrices have been calculated - this is the number of energy points 
! for cross sections and eigenphases output
      IF(qmoln) THEN
        nen=448
        open (unit=nen, file='fort.448', status='unknown')
        write(nen,*) NRK
        close (nen)
      ENDIF

      write(IWRITE,48) NRK
      IF(IFAIL.EQ.0) WRITE(IWRITE,18)
c
      deallocate (rvib,fx,fxp,akmat,bloch,fv,fvp,fd,fdp,rres,crv,crd)
      deallocate (etarg,starg,mtarg,gtarg,evchl,lvchl,mvchl,ivchl)
      deallocate (epole,wamp,ichl,butc,amc,adc,adm)
      if (abs(nfbut).gt.1) deallocate(sfac,ecex,rcex)
c
      CLOSE(UNIT=LUCHAN)
      CLOSE(UNIT=LURMT)
      CLOSE(UNIT=LUKMT)
      IF(NGEOM.GT.1) THEN
        deallocate (ichord,rquad,qwts,evib,ivtarg,ivnu,vibfn,rmn,ampn,
     *              eign)     
        CLOSE(UNIT=LUVCHN)
        CLOSE(UNIT=LUNRMT)
      ENDIF
      RETURN
C
 89   WRITE(IWRITE,91) NGEOM,NCHSET(NGEOM),NRMSET(NGEOM),R(NGEOM)
 91   FORMAT(/' ERROR IN GEOMETRY RELATED DATA'/' NGEOM =',I3,'  NCHSET(
     1NGEOM) =',I3,'  NRMSET(NGEOM) =',I3,'  R(NGEOM) =',F6.3)
      GO TO 90
 92   WRITE(IWRITE,93) NCHAN0,NCHAN,NTARG0,NTARG
 93   FORMAT(' INCONSISTENT DATA ON INPUT FILES'/' NCHAN0 =',I5,5X,'NCHA
     1N =',I5,5X,'NTARG0 =',I5,5X,'NTARG =',I5)
      GO TO 90
 94   WRITE(IWRITE,95)IVPROP,IDPROP
 95   FORMAT(/' INCONSISTENT PROPAGATION FLAGS',2I5)
      GO TO 90
 96   WRITE(IWRITE,98) NTARG,NGEOM,MAXTGT,MAXPTS
 98   FORMAT(/' INPUT DATA WILL EXCEED FIXED DIMENSIONS'/' INPUT  ',
     12I5/' MAXIMA ',2I5)
      GO TO 90
 90   IFAIL = 1
      RETURN
C
 10   FORMAT(/' Vibrationally resolved calculation '//
     * ' Number of dissociating channels',I3//
     * ' Input geometries'/' R =',7F10.5,(/4X,7F10.5))
 11   FORMAT(/' Input datasets:',33X,'Unit  Set numbers'/
     1' Target and channel data     LUCHAN (',A11,')',I3,5X,30I3/(35X,30
     2I3))
 12   FORMAT(//' Program RSOLVE  (last modified ',A,' )'//A//
     1' Symmetry data  MGVN =',I2,' STOT =',I2,' GUTOT =',I2)
 13   FORMAT(/' K-matrices will be calculated for',I5,' energies in the 
     1range [',F8.4,',',F8.4,'] ',A)
 14   FORMAT(/' SUPER R-MATRIX')
 15   FORMAT(/' K-MATRIX')
 16   FORMAT(I3,12F10.5/(3X,12F10.5))
 17   FORMAT(/' *** FIXED NUCLEI DATA ***')
 18   FORMAT(/' *** Task successfully completed ***')
 19   FORMAT(/' *** NON-ADIABATIC DATA ***')
 20   FORMAT(/' Fixed nuclei calculation for R =',F6.3)
 21   FORMAT(/' Vibrational channel data    LUVCHN (',A11,')',I3,5X,I3
     1/' Non-adiabatic R-matrix data LUNRMT (',A11,')',I3,5X,I3)
 22   FORMAT(/' *** END OF FIXED NUCLEI DATA *** ')
 23   FORMAT(/' NDIS =',I2,' IS INCOMPATIBLE WITH DATA FROM VIBRMT',2X,
     1'CHANGED TO ',I2)
 24   FORMAT(/' CONTRIBUTION TO ELECTRONIC R-MATRIX FROM FIRST',I3,
     1' POLES')
 25   FORMAT(/' COUPLING R-MATRIX')
 26   FORMAT(/' NUCLEAR MOTION R-MATRIX')
 27   FORMAT(10A8)
 28   FORMAT(/100('-')//' INCIDENT ENERGY',F10.5,' RYD')
 31   FORMAT(/' Output datasets:',32X,'Unit  Set number'/
     1' K-matrices',18X,'LUKMT  (',A11,')',I3,5X,I3)
 32   FORMAT(' Wavefunction data           LUWFN  (',A11,')',I3,5X,30I3/
     1(35X,30I3))
 33   FORMAT(' Fixed nuclei R-matrix data  LURMT  (',A11,')',I3,5X,30I3/
     1(35X,30I3))
 34   FORMAT(/' Maximum multipole USED in asymptotic scattering potentia
     1ls   ISMAX =',I3)
 35   FORMAT(/' Maximum multipole USED in asymptotic dissociating potent
     1ials MDMAX =',I3)
 38   FORMAT(/' Adiabatic approx. to contribution from higher',
     * ' poles failed at E =',F7.4,1x,a/
     * ' If higher energies are required, increase NPOLE')
 39   FORMAT(/' Adiabatic approx. to contribution from lower',
     * ' poles failed at E =',F7.4,1x,a/
     * ' If lower energies are required, decrease NPOLE')
 47   FORMAT(/' Base energy used in nuclear motion code  EBASE =',F11.5,
     1' au')
 48   FORMAT(/'Number of energy points for which the K matrices have
     1 actually been calculated: ', I6)
C
      END
      SUBROUTINE reordi(nchan,echl,ntarg,etarg,ichord)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
c---- Determine consistent ordering of channels to match target states
C
C***********************************************************************
c
      dimension istart(ntarg),ichord(nchan),itgord(ntarg),
     1 etarg(ntarg),echl(nchan),iend(ntarg)
      data tol/1.d-10/,two/2.d0/
c
c---- Determine energy ordering of target states
      call SORT_OUTER(ntarg,istart,etarg)
      do 1 i=1,ntarg
      itgord(istart(i)) = i
 1    continue
c
c---- Set pointer to first channel corresponding to each target state
      do 5 it = 1,ntarg
      et = two*(etarg(it)-etarg(1))
      ifound = 0
      do 4 i=1,nchan
      if(abs(et-echl(i)).gt.tol) go to 4
      ic = i
      if(ifound.gt.0) go to 4
      ifound = 1
      istart(it) = i
 4    continue
      iend(it) = ic
 5    continue
c
      j = 0
      do 21 it=1,ntarg
      do 2 i=istart(it),iend(it)
      j = j+1
      ichord(j) = i
 2    continue
 21   continue
c
      return
      END
      SUBROUTINE reordv(nchan,ichord,rm)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      dimension work(nchan*nchan),ichord(nchan),rm(nchan*nchan)
C
C***********************************************************************
C
c---- Reorder R-matrix elements
      do 6 i=1,nchan
      do 5 j=1,i
      work(nchan*(max(ichord(i),ichord(j))-1)+min(ichord(i),ichord(j)))
     1 = rm(i*(i-1)/2+j)
 5    continue
 6    continue
      do 8 i=1,nchan
      do 7 j=1,i
      rm(i*(i-1)/2+j) = work(nchan*(i-1)+j)
 7    continue
 8    continue
c
      return
      END
      SUBROUTINE ASYM2(NCHAN,NOPEN,LCHL,ION,ISMAX,CF,CR,RAFIN,ETHR,
     1E,FX,FXP,IPROP,ifail)
C
C***********************************************************************
C
C     ASYM2 CONTAINS CALLS TO ENERGY DEPENDANT PARTS OF PROPAGATOR AND
C           ASYMPTOTIC PACKAGES
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION LCHL(NCHAN),ETHR(NCHAN),CF(NCHAN,NCHAN,*),
     1 FX(*),FXP(*),CR(*),y(nchan),dy(nchan),en(nchan),nleg0(1)
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,LAMAX,ICF1,INC
      COMMON/ASYMS/DEGENY,EPS,EWRON,NLEG,IASY,IWRITE,IPFLG(10),IWRON,
     1 RMATR,HX,TOL,MAXPTS,neigen,nampx,nrange,peigen,pampa,igail
      double precision, pointer :: cfnag(:),ennag(:),elnag(:),pampa,
     * peigen
      DATA ZERO/0.D0/,ICOL/6/
C
      NCHSQ = NCHAN*NCHAN
C
C---  CALCULATE CHANNEL ENERGIES
      NOPEN = 0
      ZZNAG = 2*ION
      LAMAX = ISMAX
      DO 31 I=1,NCHAN
      EN(I) = E-ETHR(I)
      IF(EN(I).GT.ZERO) NOPEN=NOPEN+1
   31 CONTINUE
      NSOL = 2-(NCHAN-NOPEN)/NCHAN
C
      IF(IPROP.GT.0) THEN
        NMX = NCHAN
C
C       CALL CURLYR TO GENERATE GLOBAL PROPAGATOR UP TO RADIUS RAFIN
        NHD =    NLEG*NCHAN
        IF(NEIGEN.NE.NHD*NRANGE) GO TO 90
        IF(NAMPX.NE.2*NEIGEN*NCHAN) GO TO 90
C
        nleg0(1)=nleg
        CALL CURLYR(CR,E,NCHAN,NRANGE,NLEG0,pampa,peigen,dummy,ifail)
        if(ifail.gt.1) return
C
      ENDIF
C
      IRAD = 0
      CALL GAILIT(EN,LCHL,NCHAN,ION,CF,LAMAX,RAFIN,IWRITE,IRAD,
     1 IASY,IGAIL,DEGENY,EPS,IPFLG,FX,FXP,dummy,idum,idum,ifail)
      if(ifail.gt.1) return
C
C     CHECK WRONSKIAN
C
      IF(IWRON.NE.0) CALL WRONSK(NCHAN,NOPEN,FX,FXP,IWRITE,IPFLG(10),
     1 EWRON)
C
      IF(IPFLG(9).NE.0) THEN
C
C----- PRINT SOLUTIONS AND DERIVATIVES
         DO 14 K=1,NSOL
         WRITE(IWRITE,17) RAFIN
 17      FORMAT(/' SOLUTIONS AT RAFIN=',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FX(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 14      CONTINUE
         DO 15 K=1,NSOL
         WRITE(IWRITE,18)RAFIN
 18      FORMAT(/' DERIVATIVES AT RAFIN',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FXP(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 15      CONTINUE
      ENDIF
C
      IF(IPROP.GE.0) RETURN
c
      if(igail.eq.1) then
        allocate (ennag(nchan),elnag(nchan))
        DO 32 I=1,NCHAN
        ennag(i) = en(i)
        elnag(i) = dble(LCHL(I)*(LCHL(I)+1))
 32     CONTINUE
        allocate (cfnag(lamax*nchan*nchan),stat=ierror)
        if(ierror.ne.0) then
          print *,' unable to allocate cfnag ',ierror
          stop
        endif
        ijk = 0
        do 42 k=1,lamax
        do 41 i=1,nchan
        do 40 j=1,nchan
        ijk = ijk+1
        cfnag(ijk) = cf(i,j,k)
 40     continue
 41     continue
 42     continue
      endif
C
C     FUNCTION PROPAGATION
C
      CALL INTIN(RMATR,RAFIN,FX,FXP,NCHAN,NOPEN,Y,DY,HX,MAXPTS,TOL,
     * IPFLG(10),IWRITE)
C
      IF(IPFLG(9).NE.0) THEN
C----- PRINT SOLUTIONS AND DERIVATIVES
         DO 24 K=1,NSOL
         WRITE(IWRITE,27) RMATR
 27      FORMAT(/' SOLUTIONS AT RMATR =',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FX(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 24      CONTINUE
         DO 25 K=1,NSOL
         WRITE(IWRITE,28)RMATR
 28      FORMAT(/' DERIVATIVES AT RMATR',F8.3)
         IJK=(K-1)*NCHSQ+1
         CALL WRECMT(FXP(IJK),NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
 25      CONTINUE
      ENDIF
C
      RETURN
 90   WRITE(IWRITE,91) NEIGEN,NAMPX,NLEG,NRANGE,NCHAN
 91   FORMAT(' INCONSISTENT DATA IN ASYM2',5I8)
      STOP
      END
      SUBROUTINE NAGRHS(NCHAN,R,Y,YDP)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     NAGRHS calculates the right hand sides of the asymptotic equations
C     in the form required by the NAG routine D02LAF
C
C     THE POTENTIALS ARE EXPANDED IN INVERSE POWERS OF THE RADIAL
C     DISTANCE R, WITH EXPANSION COEFFICIENTS GIVEN IN THE MATRIX CF
C
C***********************************************************************
C
      DIMENSION Y(*),YDP(NCHAN)
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,LAMAX,ICF1,INC
      double precision, pointer :: cfnag(:),ennag(:),elnag(:)
C
      DATA ZERO/0.0D0/,ONE/1.0D0/
C
      DO 1 I=1,NCHAN
      YDP(I) = (-ENnag(I)+ELnag(I)/(R*R)-ZZNAG/R)*Y(I)
 1    continue
      DO 4 I=1,NCHAN
      DO 3 K=1,LAMAX
      INC = (I-1+(K-1)*NCHAN)*NCHAN
      RK = ONE/R**(K+1)
      DO 2 J=1,NCHAN
      YDP(I) = YDP(I)+Y(J)*cfnag(INC+J)*RK
 2    continue
 3    continue
 4    continue
C
      RETURN
      END
      SUBROUTINE NAGPOT(R,Y,DY)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     NAGPOT CALCULATES THE ASYMPTOTIC POTENTIAL IN THE DISSOCIATING
C     CHANNEL. CALLING SEQUENCE IS AS REQUIRED BY NAG ROUTINE D02BAF
C
C***********************************************************************
C
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,LAMAX,ICF1,INC
      COMMON/DISPAR/DE,D,BETA,RE,TWOM,BIGKSQ,EPSD,RA
      double precision, pointer :: cfnag(:),ennag(:),elnag(:)
      DIMENSION Y(*),DY(*)
      DATA ZERO/0.D0/,ONE/1.D0/
C
C----- GAILIT SHOULD BE USED FOR ENTIRE RANGE WHERE MULTIPOLE EXPANSION
C      IS VALID
      IF(R.LE.RA) THEN
C
C---- MORSE POTENTIAL
        V = D*(ONE-EXP(-BETA*(R-RE)))**2+DE
C
      ELSE
C
C---- MULTIPOLE EXPANSION
        V = ZERO
        DO 1 K=1,LAMAX
        V = V+cfnag(ICF1+(K-1)*INC)/R**(K+1)
 1      continue
C
      ENDIF
C
      DY(1) = Y(2)
      DY(2) = (V-BIGKSQ)*Y(1)
C
      RETURN
      END
      SUBROUTINE ASYM1(NCHAN,LCHL,ION,LAMAX,CF,RMTR,RAFIN,SCALE,BLOCH,
     1ETHR,EMIN,EMAX,IPROP,POTL,IWR)
C
C***********************************************************************
C
C     ASYM1 CARRIES OUT THE ENERGY INDEPENDANT INITIALIZATION OF THE
C      ASYMPTOTIC ROUTINES.  SINCE A MODIFIED VERSION OF CFASYM IS
C      USED IN THIS CODE, WHICH DOES NOT REQUIRE SEPARATE INITIALIZATION
C      THIS ROUTINE IS LARGELY CONCERNED WITH SETTING UP THE CALL TO
C      THE PROPAGATOR PACKAGE VIA RPROP1
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      CHARACTER(LEN=14) METHOD(3)
      EXTERNAL POTL
      COMMON/ASYMS/DEGENY,EPS,EWRON,NLEG,IASY,IWRITE,IPFLG(10),IWRON,
     1 RMATR,HX,TOL,MAXPTS,neigen,nampx,nrange,peigen,pampa,igail
      DIMENSION LCHL(NCHAN),CF(NCHAN,NCHAN,*),ETHR(NCHAN),LBUG(6),
     1          nleg0(1)
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,nAMAX,ICF1,INC
      double precision, pointer :: cfnag(:),ennag(:),elnag(:)
      double precision, allocatable :: work(:),vc(:)
      double precision, allocatable, target :: eigen(:),ampa(:)
      double precision, pointer :: peigen,pampa
      save eigen,ampa
C
C***********************************************************************
C
C     DATA RELATING TO THE ASYMPTOTIC PACKAGES RPROP AND CFASYM ARE
C     INPUT VIA NAMELIST /BPROP/
C
C     EBIG   = LARGEST VALUE OF |K**2| IN ANY CHANNEL IF DIFFERENT
C              FROM VALUE INPUT FROM CALLING PROGRAM
C     ESMALL = SMALLEST VALUE OF |K**2| IF DIFFERENT FROM INPUT
C     IDISC  = LOGICAL UNIT OF SCRATCH DISC IF REQUIRED
C     IGAIL  = TYPE OF ASYMPTOTIC EXPANSION, 0=BURKE+SCHEY, 1=GAILITIS,
C              2=BESSEL/COULOMB FUNCTIONS (DEFAULT =1)
C     IPFLG  = DEBUG PRINT SWITCHES FOR CFASYM (SEE CFASYM WRITE UP)
C     IWRON  = 0 WRONSKIAN OF SOLUTIONS IN NOT CHECKED
C     LBUG   = DEBUG PRINT SWITCHES FOR RPROP (SEE COMMENTS IN RPROP1)
C     NLEG   = NUMBER OF LEGENDRE POLYNOMIALS TO BE USED IN PROPAGATION
C              (MAXIMUM AND DEFAULT = 10)
C     NRANGE = NUMBER OF SUBRANGES IN PROPAGATION (DEFAULT= 0, CODE
C               DECIDES HOW MANY)
C     RAF    = RADIUS AT WHICH CONTINUED FRACTION METHOD CAN BE USED
C              (DEFAULT RAF=RMATR)
C
      NAMELIST/BPROP/LBUG,RAF,IDISC,IGAIL,NLEG,NRANGE,ESMALL,EBIG,
     2 IPFLG,IWRON,IFPROP,HX,TOL,MAXPTS
C
C***** SOME CONVERGENCE CRITERIA HAVE BEEN RELAXED
C      FINAL EIGENPHASES ETC APPEAR GOOD TO 4 FIGURES
      DATA TINY/1.D-8/,DELTA/6.D0/,IREAD,IDISC/5,0/,MLEG/10/
      DATA ZERO/0.0D0/,HALF/0.5D0/,IFPROP/0/
      DATA METHOD/'BURKE/SCHEY','GAILITIS','COULOMB/BESSEL'/
C
C     *******     ENERGY INDEPENDANT PART OF CALCULATION     *******
C
      HX = 0.2
      TOL = 1.D-5
      MAXPTS = 200
      RAF = ZERO
      RMATR = RMTR
      NLEG = 0
      NRANGE = 0
      IWRITE = IWR
      DEGENY = 1.D-5
      IWRON = 0
      IASY = 20
      ESMALL = 0.D0
      EBIG = 0.D0
      EPS = 5.D-5
      EWRON = 5.D-5
      IGAIL = 1
      DO 8 I=1,6
      LBUG(I) = 0
 8    continue
      DO 9 I=1,10
      IPFLG(I) = 0
 9    continue
      ISPROP = IPROP
C
      READ(IREAD,BPROP)
C
      IF(RAF.GT.TINY) RAFIN = RAF
      IF(IPROP.EQ.0) RETURN
C
      IF(NLEG.GT.MLEG) GO TO 95
      IF(NLEG.EQ.0) NLEG=MLEG
      IF(ESMALL.LT.TINY) ESMALL = EMIN
      IF(EBIG.LT.TINY) EBIG = EMAX
C
C     IF THERE ARE NO LONG RANGE POTENTIALS NO PROPAGATION IS REQUIRED
C     AND SIMPLE COULOMB WAVE FUNCTIONS MAY BE USED IN ASYMPTOTIC REGION
C
      CFMAX = ZERO
      DO 32 I=1,NCHAN
      E1 = ABS(EMIN-ETHR(I))
      E2 = EMAX-ETHR(I)
      ESMALL = MIN(ESMALL,E1,ABS(E2))
      EBIG = MAX(EBIG,E2)
      DO 31 J=1,NCHAN
      DO 30 K=1,LAMAX
      COEF = ABS(CF(I,J,K))
      IF(COEF.GT.CFMAX) CFMAX=COEF
   30 CONTINUE
 31   continue
 32   continue
      IF(CFMAX .LE. TINY) IGAIL=2
      namax = lamax
C
C     DETERMINE WHETHER PROPAGATION IS REQUIRED
C
      IF(NRANGE.EQ.0) THEN
        IF(RAFIN.eq.RMATR) THEN
          IPROP = 0
          RAFIN = RMATR
        ELSE
          IPROP = 1
          NRANGE = MAX(INT(SQRT(EBIG)*ABS(RAFIN-RMATR)/DELTA+HALF),1)
        ENDIF
      ELSE
        IF(RAFIN.LE.RMATR) RAFIN=RMATR+NRANGE*DELTA/SQRT(EBIG)
        IPROP = 1
      ENDIF
      IF(IFPROP.NE.0.OR.ISPROP.LT.0) IPROP=-IPROP
C
C     PRINT DETAILS OF OPTIONS SELECTED
C
      WRITE(IWRITE,51) METHOD(IGAIL+1),RAFIN
      IF(IPROP.EQ.1) WRITE(IWRITE,52) NRANGE
      IF(IPROP.EQ.-1) WRITE(IWRITE,520) 
      IF(IPFLG(1).NE.0) WRITE(IWRITE,53)EMIN,IASY,DEGENY
C
C     ALLOCATE SPACE FROM DYNAMIC STORAGE TO PROPAGATOR PACKAGE
C
      IF(IPROP.GT.0) THEN
        NMX = NCHAN
        NHD = NCHAN*NLEG
        NBIGVC = NHD*NHD
        LPR = 10*NHD+NBIGVC
        NAMPX = 2*NHD*NCHAN*NRANGE
        NEIGEN= NHD*NRANGE
C
        allocate (vc(nbigvc),work(nbigvc))
        if(allocated(eigen)) deallocate (eigen,ampa)
        allocate (eigen(neigen),ampa(nampx))
        peigen => eigen(1)
        pampa => ampa(1)
C
        IF(IPFLG(1).NE.0) WRITE(IWRITE,8844)NRANGE,NCHAN,NLEG,IDISC,
     1  LAMAX
 8844   FORMAT(' NRANGE  =',I10,' NCHAN  =',I10,' NLEG   =',I10,/,
     1  ' IDISC  =',I2,' LAMAX  =',I10)
C
C     INITIALIZE PROPAGATOR PACKAGE
C
        nleg0(1)=nleg
        CALL RPROP1(NCHAN,RMATR,RAFIN,ETHR,NMX,NRANGE,NLEG0,EMAX,SCALE,
     1  LAMAX,ION,LCHL,CF,BLOCH,LBUG,IWRITE,IDISC,AMPA,EIGEN,
     2  NAMPX,VC,WORK,POTL)
        deallocate (work,vc)
C
      ENDIF
C
      RETURN
C
C     STORAGE OVERFLOW ... TERMINATE THE CALCULATION
C
 95   WRITE(IWRITE,96)NLEG,MLEG
 96   FORMAT(' TOO MANY BASIS FUNCTIONS, GIVEN',I3,' MAXIMUM',I3)
      STOP
 51   FORMAT(/' ASYMPTOTIC METHOD SELECTED : ',A/' EXPANSION USED AT RAD
     1IUS =',F10.4)
 52   FORMAT(/' R-MATRIX WILL BE PROPAGATED ACROSS',I3,' SUBRANGES')
 520  FORMAT(/' SOLUTIONS WILL BE PROPAGATED USING NAG ROUTINE D02LAF')
 53   FORMAT(' CONVERGENCE RADIUS FOR ENERGY,     EMIN  =',D16.8,/,
     2       ' TERMS RETAINED IN ASYMPTOTIC SERIES, IASY =',I16,/,
     4       ' MINIMUM SEPARATION FOR NONDEGENERATE',/,
     5       ' CHANNELS (RYDBERGS),               DEGENY =',D16.8,//)
      END
      SUBROUTINE RESIDR(ETOTR,NCHAN,NTARG,ETARG,NLPOLE,NUPOLE,nstat,
     1 NGEOM,nocsf,ichl,WAMP,EPOLE,IBUTTL,BCOEF,RTEMP,ezero,sfac,
     2 iex,ecex,rcex,IWRITE,IFAIL)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C      RESIDR SETS UP ELECTRONIC R-MATRIX, EXCLUDING POLES ALREADY DEALT
C      WITH, BUT INCLUDING BUTTLE TERM, AT EACH INTERNUCLEAR SEPARATION
C
C***********************************************************************
C
      DIMENSION EPOLE(nstat,NGEOM),WAMP(NCHAN,nstat,NGEOM),RTEMP(*),
     1 BCOEF(3,NCHAN,NGEOM),ETARG(NTARG,NGEOM),nocsf(ngeom),ichl(nchan),
     2 ezero(ngeom),sfac(nchan,ngeom),ecex(iex,ngeom),
     3 rcex(NCHAN,iex,NGEOM)

      DATA ZERO/0.D0/,ONE/1.D0/,TWO/2.D0/
C
      DO 1 K=1,NCHAN*(NCHAN+1)*NGEOM/2
      RTEMP(K) = ZERO
 1    continue
C
C----- CONSTRUCT CONTRIBUTION TO R-MATRIX FROM REMAINING POLES
      NP1 = 1
      ipass = 1
C
C----- If non-adiabatic calculation, check that this energy is low
C      enough for R-matrix contribution from remaining poles to be
C      treated adiabatically
C
 20   if(ipass.eq.2.or.nlpole.gt.1) then
        EDIFF = EPOLE(NP1,1)-ETOTR
        DO 5 IG=2,NGEOM
        ENEXT = EPOLE(NP1,IG)-ETOTR
        IF(EDIFF*ENEXT.LT.ZERO) GO TO 90
        EDIFF = ENEXT
 5      CONTINUE
      endif
C
      K = 0
      DO 23 IR=1,NGEOM
      if(ipass.eq.1) then
        np2 = nlpole-1
      else
        np2 = nocsf(ir)
      endif
      if (abs(ibuttl).gt.1) eps=one/(ezero(ir)-etotr)
      DO 22 I=1,NCHAN
      DO 2 J=1,I
      K = K+1
      SUM = ZERO
      if (abs(ibuttl).lt.2) then
         DO 21 KL=NP1,NP2
         SUM = SUM+WAMP(I,KL,IR)*WAMP(J,KL,IR)/(EPOLE(KL,IR)-ETOTR)
 21      continue
      else
         DO 221 KL=NP1,NP2
         SUM = SUM+WAMP(I,KL,IR)*WAMP(J,KL,IR)
     1       *(one/(EPOLE(KL,IR)-ETOTR) - eps)
221      continue
      endif
      RTEMP(K) = RTEMP(K) + SUM
 2    continue
 22   continue
 23   continue
C
      IF(ipass.eq.1) THEN
        NP1 = NUPOLE+1
        ipass = 2
        GO TO 20
      ENDIF
C
C----- ADD BUTTLE CORRECTION
      IF(abs(IBUTTL).eq.1) THEN
        K = 0
        DO 3 IR=1,NGEOM
        DO 4 I=1,NCHAN
        if(ibuttl.lt.0) then
          itgt = 1
        else
          itgt = ichl(i)
        endif
        E = TWO*(ETOTR-ETARG(itgt,IR))
        BUTTL = BCOEF(1,I,IR)+E*BCOEF(2,I,IR)+E*E*BCOEF(3,I,IR)
        K = K+I
        RTEMP(K) = RTEMP(K)+BUTTL
 4      CONTINUE
 3      CONTINUE
      ENDIF
c-----add higher poles contribution for partitioned R-matrix
      if (abs(IBUTTL).GT.1) THEN
        K = 0
        DO 33 IR=1,NGEOM
        eps=one/(ezero(ir)-etotr)
        DO 34 I=1,NCHAN
        K = K+I
        RTEMP(K) = RTEMP(K)+sfac(i,ir)*eps
        DO 35 KL=1,iex
        RTEMP(K) = RTEMP(K)+rcex(i,kl,ir)
     1       *(one/(ecex(KL,IR)-ETOTR) - eps)
      
35      continue
34      CONTINUE
33      CONTINUE
      ENDIF
      RETURN
 90   IF(ipass.eq.1) THEN
        IFAIL = 1
      ELSE
        IFAIL = 2
      ENDIF
      RETURN
      END
      SUBROUTINE VRMAT2(NCHAN,NHD,RMATRX,ETOTR,AMPA,EIGEN,NPOLE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C      VRMAT2 IS ENERGY DEPENDANT ENTRY TO NUCLEAR R-MATRIX CODE
C
C***********************************************************************
C
C     INPUT PARAMETERS ARE
C
C      ETOTR  = ENERGY OF INCIDENT PARTICLE ON LOWEST ENERGY STATE IN
C               RYDBERGS
C      AMPA,EIGEN ARE AS DEFINED IN VRMAT1
C
C***********************************************************************
C
      DIMENSION RMATRX(*),AMPA(NHD,NCHAN),EIGEN(NHD)
      DATA ZERO/0.D0/
C
      K = 0
      DO 40 M=1,NCHAN
      DO 4 N=1,M
      K = K+1
      SUM = ZERO
      DO 2 KL=NPOLE,NHD
      SUM=SUM+AMPA(KL,M)*AMPA(KL,N)/(EIGEN(KL)-ETOTR)
 2    continue
      RMATRX(K) = SUM
 4    continue
 40   continue
C
      RETURN
C
      END
      SUBROUTINE DISPOT(NDIS,LAMAX,ION,LCHL,CF,NPTS,RR,VM)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     DISPOT CALCULATES THE ASYMPTOTIC POTENTIAL IN THE DISSOCIATING
C     CHANNEL
C
C***********************************************************************
C
      DIMENSION RR(NPTS),VM(NDIS,NDIS,NPTS),CF(NDIS,NDIS,*),LCHL(*)
      DATA ZERO/0.D0/,ONE/1.D0/
C
      DO 10 IR=1,NPTS
      R = RR(IR)
C
      INC = -5
      DO 1 I=1,NDIS
C
C----- GAILIT SHOULD BE USED FOR ENTIRE RANGE WHERE MULTIPOLE EXPANSION
C      IS VALID
      INC = INC+5
      RA = CF(INC+1,1,LAMAX+1)
      IF(R.LE.RA) THEN
C
C---- MORSE POTENTIAL
        RE = CF(INC+2,1,LAMAX+1)
        D  = CF(INC+3,1,LAMAX+1)
        DE = CF(INC+4,1,LAMAX+1)
        BETA = CF(INC+5,1,LAMAX+1)
        V = D*(ONE-EXP(-BETA*(R-RE)))**2+DE
C
      ELSE
C
C---- MULTIPOLE EXPANSION
        V = ZERO
        DO 2 K=1,LAMAX
        V = V+CF(I,I,K)/R**(K+1)
 2      continue
C
      ENDIF
C
      DO 3 J=1,NDIS
      VM(I,J,IR) = ZERO
 3    continue
      VM(I,I,IR) = V
 1    CONTINUE
 10   continue
C
      RETURN
      END
      SUBROUTINE ASYMD(ETOT,NDIS,TWORM,AO,RAF,ETHR,F,DF,VM,IWRITE,
     1 LBUG)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     ASYMD solves radial equation(s) in dissociating channel(s) for
C     R .ge. AO (assumed uncoupled)
C
C***********************************************************************
C
      EXTERNAL NAGPOT
      parameter (neq=2)
      COMMON/DISPAR/DE,D,BETA,RE,TWOM,BIGKSQ,EPSD,RA
      COMMON/NAGPT/ cfnag,ennag,elnag,ZZNAG,LAMAX,ICF1,INC
      double precision, pointer :: cfnag(:),ennag(:),elnag(:)
      DIMENSION F(NDIS,NDIS,2),DF(NDIS,NDIS,2),G(2),ETHR(NDIS),
     1 VM(5,NDIS),work(14*neq),thres(neq),gp(neq),gmax(neq)
      DATA ZERO/0.D0/
C
      EPSD = 1.D-8
      do 10 i=1,neq
      thres(i) = epsd
 10   continue
c
      TWOM = TWORM
      INC = NDIS*NDIS
      ICF1 = -NDIS
      DO 3 I=1,NDIS
      RA = VM(1,NDIS)
      RE = VM(2,NDIS)
      D  = VM(3,NDIS)
      DE = VM(4,NDIS)
      BETA = VM(5,NDIS)
      ICF1 = ICF1+NDIS+1
      BIGKSQ = ETOT-ETHR(I)
      IF(BIGKSQ.LT.ZERO) THEN
        NK = 1
      ELSE
        NK = 2
      ENDIF
      DO 4 K=1,NK
      RAFIN = RAF
      G(1) = F(I,I,K)
      G(2) = DF(I,I,K)
      DO 5 J=1,NDIS
      F(I,J,K) = ZERO
      DF(I,J,K) = ZERO
 5    continue
      IFAIL = 1
C
c      CALL D02BAF(RAFIN,AO,NEQ,G,EPSD,NAGPOT,work,IFAIL)
c
C    The following line is a warning that should be removed once D02PVF
C    and D02PCF are replaced.
      WRITE(IWRITE,*) 'NAG routine not replaced. This part of the program
     1 does not work in this version of the code'
!NV-03      CALL D02PVF(neq,RAFIN,G,AO,EPSD,thres,2,'usualtask',.false.,
!NV-03     * zero,work,14*neq,IFAIL)
!NV-03      CALL D02PCF(nagpot,AO,rafin,G,gp,gmax,work,IFAIL)
c   
C      RAFIN SHOULD EQUAL A0 ON EXIT IF NO ERRORS
      IF(IFAIL.NE.0) WRITE(IWRITE,1) IFAIL,RAFIN
 1    FORMAT(/' D02BAF failed IFAIL=',I1,' at R=',F8.4)
C
      F(I,I,K) = G(1)
      DF(I,I,K) = G(2)
 4    CONTINUE
 3    CONTINUE
C
      IF(LBUG.GE.1) WRITE(IWRITE,2) RAFIN,BIGKSQ,((F(I,I,K),DF(I,I,K),
     1K=1,2),I=1,NDIS)
 2    FORMAT(/' SOLUTIONS AT R=',F6.3,'  KSQ=',F10.4,/(8D15.6))
      RETURN
      END
      SUBROUTINE SPLITM(NDIS,ND2,MDMAX,TRIANG,SQUARC,DISM)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     SPLITM unpacks data describing the potentials in the dissociating
C     channels. It must match DISINI in VIBRMT.
C
C***********************************************************************
C
      DIMENSION SQUARC(NDIS,NDIS,*),DISM(5,NDIS),TRIANG(ND2,*)
      DATA EPS/1.D-4/,ZERO/0.D0/
C
      NDSQ = NDIS*(NDIS+1)/2
      DO 11 K=1,MDMAX
      DO 10 J=1,NDIS
      DO 1 I=1,NDIS
      SQUARC(I,J,K) = ZERO
 1    continue
 10   continue
 11   continue
      LAST = NDSQ+6*(NDIS-1)+1
      MDMIN = INT(TRIANG(LAST,1)+EPS)
      II = 0
      IPT = NDSQ-5
      DO 20 I=1,NDIS
      II = II+I
      IPT = IPT+6
      KK = 0
      DO 3 K=MDMIN,MDMAX
      KK = KK+1
      SQUARC(I,I,K) = TRIANG(II,KK)
 3    continue
      DO 2 K=1,5
      DISM(K,I) = TRIANG(IPT+K,1)
 2    continue
 20   continue
C
      RETURN
      END
      SUBROUTINE INTIN(RMATR,RAFIN,FX,FX1,NP,NA,Y,DY,HX,MAXPTS,
     1 TOL,IBUG,IWRITE)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C     PERFORMS INWARD INTEGRATION FROM POINT RAFIN TO RMATR
C
      EXTERNAL NAGRHS
      LOGICAL START,ONESTP,HIGH
      DIMENSION FX(NP,NP,2),FX1(NP,NP,2),Y(NP),DY(NP)
      double precision, allocatable :: fr(:),frm(:),yr(:),wk(:)
      DATA ONESTP,HIGH/.FALSE.,.TRUE./,IFAIL/0/,ZERO/0.D0/
C
      LRWORK = 16+20*NP
      allocate (fr(np),frm(np),yr(np),wk(lrwork))
C
C     GENERATE (NP BY NP+NA)-DIMENSIONAL SOLUTION MATRIX IN REGION 2.
C     NP EQUATIONS ARE INTEGRATED INWARD NP+NA TIMES 
C
      DO 90 J=1,NP+NA
      JA = J - NP
C
C     SET THE BOUNDARY CONDITIONS-
C
      IF(J.LE.NP) THEN
        DO 30 I=1,NP
        Y(I) = FX(I,J,1)
        DY(I) = FX1(I,J,1)
   30   CONTINUE
      ELSE
        DO 40 I=1,NP
        Y(I) = FX(I,JA,2)
        DY(I) = FX1(I,JA,2)
   40   CONTINUE
      ENDIF
C
      START = .TRUE.
      FR(1) = ZERO
      FRM(1) = ZERO
C    The following line is a warning that should be removed once D02LXF
C    is replaced.
      WRITE(IWRITE,*) 'NAG routine D02LXF not replaced. This part of the
     1 program does not work in this version of the code'
!NV-03      CALL D02LXF(NP,HX,TOL,FR,FRM,MAXPTS,START,ONESTP,HIGH,WK,LRWORK,
!NV-03      * IFAIL)
C
      X = RAFIN
c
!NV-03 10   CALL D02LAF(NAGRHS,NP,X,RMATR,Y,DY,YR,WK,LRWORK,IFAIL)
C
      IF(X.LT.RMATR) GO TO 10
C    The following line is a warning that should be removed once D02LAF
C    is replaced.
  10  write(IWRITE,*)'Replacement for NAG integration routines not
     1  implemented. This part of the  program does not work in
     2  this version of the code (NV, November 2003)'
C
C     OPTIONAL DIAGNOSTICS
      IF(IBUG.NE.0) THEN
!NV-03        CALL D02LYF(NP,HNEXT,HUSED,HSTART,NSUCC,NFAIL,NATT,FR,
!NV-03     1  FRM,WK,LRWORK,IFAIL)
C    The following line is a warning that should be removed once D02LYF
C    is replaced.
        write(IWRITE,*)'Replacement for NAG integration routines
     1  (diagnostics) not implemented. This part of the  program does
     2  not work in this version of the code (NV, November 2003)'
!NV-03        WRITE(IWRITE,1001) HSTART,HUSED,HNEXT,NSUCC,NFAIL,NATT
      ENDIF
C
C     STORE THE VALUES OF THE FUNCTION AND DERIVATIVE AT THE BOUNDARY
C
      IF(J.LE.NP) THEN
        DO 80 I=1,NP
        FX(I,J,1) = Y(I)
        FX1(I,J,1) = DY(I)
   80   CONTINUE
      ELSE
        DO 81 I=1,NP
        FX(I,JA,2) = Y(I)
        FX1(I,JA,2) = DY(I)
   81   CONTINUE
      ENDIF
C
   90 CONTINUE
      deallocate (fr,frm,yr,wk)
C
      RETURN
 1001 FORMAT(/'  D02LAF DIAGNOSTICS'//'   START MESH ',D12.4,
     1 '   FINAL MESH ',D12.4,'    NEXT MESH ',D12.4/
     2 '   SUCCESSES',I5,'   FAILURES',I5,'    ATTEMPTS',I5)
      END
      SUBROUTINE MERGE(NCHAN,NVCHAN,NDIS,NVOPEN,NDOPEN,FX,FXP,FV,FVP,FD,
     1FDP)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     MERGE MERGES SOLUTIONS AND DERIVATIVES IN BOTH VIBRATIONAL AND
C      DISSOCIATING CHANNELS
C
C***********************************************************************
C
      DIMENSION FX(NCHAN,NCHAN,2),FXP(NCHAN,NCHAN,2),
     1FV(NVCHAN,NVCHAN,2),FVP(NVCHAN,NVCHAN,2),FD(*),FDP(*)
      DATA ZERO/0.D0/
C
      NOPEN = NVOPEN+NDOPEN
      DO 12 K=1,2
      DO 11 J=1,NCHAN
      DO 1 I=1,NCHAN
      FX(I,J,K) = ZERO
      FXP(I,J,K) = ZERO
 1    continue
 11   continue
 12   continue
C
C---- OPEN VIBRATIONAL CHANNELS
      DO 22 K=1,2
      DO 21 J=1,NVOPEN
      DO 2 I=1,NVCHAN
      FX(I,J,K) = FV(I,J,K)
      FXP(I,J,K) = FVP(I,J,K)
 2    continue
 21   continue
 22   continue
C
C---- PUT CLOSED CHANNEL FUNCTIONS IN CORRECT PLACES
      DO 31 J=1,NVCHAN-NVOPEN
      DO 3 I=1,NVCHAN
      FX(I,J+NOPEN,2) = FV(I,J+NVOPEN,1)
      FX(I,J+NOPEN,1) = ZERO
      FXP(I,J+NOPEN,2) = FVP(I,J+NVOPEN,1)
      FXP(I,J+NOPEN,1) = ZERO
 3    continue
 31   continue
C
C---- DISSOCIATING CHANNELS
      KJ = 0
      DO 41 K=1,2
      DO 4 J=1,NDIS
      DO 5 I=1,NDIS
      KJ = KJ+1
      IF(J.GT.NDOPEN) THEN
        IF(K.EQ.1) THEN
          FX(NVCHAN+I,NVCHAN+J,2) = FD(KJ)
          FXP(NVCHAN+I,NVCHAN+J,2) = FDP(KJ)
        ELSE
          FX(NVCHAN+I,NVCHAN+J,1) = ZERO
          FXP(NVCHAN+I,NVCHAN+J,1) = ZERO
        ENDIF
      ELSE
        FX(NVCHAN+I,NVOPEN+J,K) = FD(KJ)
        FXP(NVCHAN+I,NVOPEN+J,K) = FDP(KJ)
      ENDIF
 5    CONTINUE
 4    CONTINUE
 41   continue
C
      RETURN
      END
      SUBROUTINE POTL(NCHAN,LAMAX,ION,LCHL,CF,NBASIS,R,V)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     POTL CALCULATES THE VALUES OF THE ASYMPTOTIC POTENTIAL IN THE FORM
C     REQUIRED BY THE R-MATRIX PROPAGATOR ROUTINE RPROP.
C
C     THE POTENTIALS ARE EXPANDED IN INVERSE POWERS OF THE RADIAL
C     DISTANCE R, WITH EXPANSION COEFFICIENTS GIVEN IN THE MATRIX CF
C
C***********************************************************************
C
      DIMENSION R(NBASIS),V(NCHAN,NCHAN,NBASIS)
      DIMENSION CF(NCHAN,NCHAN,*),LCHL(NCHAN)
C
      DATA ZERO/0.0D0/,ONE/1.0D0/,TWO/2.0D0/
C
      DO 4 I=1,NCHAN
      EL2 = LCHL(I)*(LCHL(I)+1)
      DO 3 J=1,NCHAN
      DO 1 IR=1,NBASIS
      VP = ZERO
      RR = ONE/R(IR)
      IF(I.EQ.J) VP=-TWO*Dble(ION)*RR+EL2*RR*RR
      DO 2 K=1,LAMAX
      VP = VP+CF(I,J,K)*RR**(K+1)
 2    CONTINUE
      V(I,J,IR) = VP
 1    continue
 3    continue
 4    continue
C
      RETURN
      END
      SUBROUTINE SQUARM(NDIM,NMAT,TRIANG,SQUARE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     SQUARM PUTS LOWER TRIANGLES BACK INTO SQUARE MATRICES)
C
C***********************************************************************
C
      DIMENSION SQUARE(NDIM,NDIM,NMAT),TRIANG(*)
C
      K = 0
      DO 3 L=1,NMAT
      DO 2 I=1,NDIM
      DO 1 J=1,I
      K = K+1
      SQUARE(I,J,L) = TRIANG(K)
      SQUARE(J,I,L) = TRIANG(K)
 1    continue
 2    continue
 3    continue
C
      RETURN
      END
      SUBROUTINE KMAT(NCHAN,BSTO,NOPEN,F,FP,RMAT,AKMAT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     K-MATRIX CALCULATION
C
C     NCHAN        NUMBER OF CHANNELS
C     BSTO         LOGARITHMIC DERIVATIVE/MATCHING RADIUS
C     NOPEN        NUMBER OF OPEN CHANNELS
C     F, FP        EXTERNAL REGION SOLUTIONS AND DERIVATIVES
C                  (ASSUMED IN CORRECT LOCATIONS)
C     RMAT         INTERNAL REGION R-MATRIX
C
C     OUTPUT :
C     AKMAT        K-MATRIX
C
C     AA,BB        WORK SPACE, EACH OF LENGTH NCHAN*NCHAN
C     X            WORK SPACE, OF LENGTH 2*NCHAN
C
C***********************************************************************
C
      DIMENSION RMAT(NCHAN,NCHAN),AKMAT(NOPEN,NOPEN),F(NCHAN,NCHAN,2),
     X          FP(NCHAN,NCHAN,2),AA(NCHAN,NCHAN),BB(NCHAN,NCHAN),
     X          X(2*nchan),BSTO(NCHAN)
C
      DATA ZERO/0.0D0/
C
      DO 11 J=1,NCHAN
      DO 10 I=1,NCHAN
      AA(I,J) = F(I,J,2)
 10   continue
 11   continue
C
      DO 22 J=1,NCHAN
      DO 21 K=1,NCHAN
      DF = FP(K,J,2)-BSTO(K)*F(K,J,2)
      DO 20 I=1,NCHAN
      AA(I,J) = AA(I,J)-RMAT(I,K)*DF
 20   continue
 21   continue
 22   continue
C
      DO 41 J=1,NOPEN
      DO 40 I=1,NCHAN
      BB(I,J)=-F(I,J,1)
 40   continue
 41   continue
C
      DO 52 J=1,NOPEN
      DO 51 K=1,NCHAN
      DF = FP(K,J,1)-BSTO(K)*F(K,J,1)
      DO 50 I=1,NCHAN
      BB(I,J)=BB(I,J)+RMAT(I,K)*DF
   50 CONTINUE
 51   continue
 52   continue
C
C      SOLVE THE NCHAN SIMULTANEOUS EQUATIONS FOR THE K-MATRIX,
C
      IF(NCHAN.EQ.1) THEN
        BB(1,1)=BB(1,1)/AA(1,1)
      ELSE
        CALL MA01A(AA,BB,NCHAN,NOPEN,0,NCHAN,NCHAN,X,X(NCHAN+1))
      ENDIF
C
      DO 91 J=1,NOPEN
      DO 90 I=1,NOPEN
      AKMAT(I,J) = BB(I,J)
 90   continue
 91   continue
C
      RETURN
      END
      SUBROUTINE RPROPX(NCHAN,NVCHAN,NDIS,CRV,CRD,RMAT,IPFLG,IWRITE,
     1IBACK)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     RPROPX MERGES GLOBAL R-MATRICES INTO A SUPER GLOBAL R-MATRIX
C      THEN PROPAGATES THE INPUT SUPER R-MATRIX IN ONE STEP TO THE
C      REQUIRED RADII
C
C***********************************************************************
C
      DIMENSION RMAT(NCHAN,NCHAN),CRV(*),CRD(*),wk(nchan),
     * r11(nchan*(nchan+1)/2),r22(nchan*(nchan+1)/2),
     * r12(nchan*nchan)
      DATA ICOL/6/,ZERO/0.D0/
C
C     SIGN is set to 1 for propagating forward and -1 for 
C          propagating backwards
      SIGN=REAL(IBACK)
C
      NCHSQ = NCHAN*NCHAN
      NCH2 = (NCHSQ+NCHAN)/2
      NVCHSQ = NVCHAN*NVCHAN
      NVCH2 = (NVCHSQ+NVCHAN)/2
      NDSQ = NDIS*NDIS
      ND2 = (NDSQ+NDIS)/2
C
      IV11 = 1
      IV12 = IV11+NVCH2
      IV22 = IV12+NVCHSQ
      ID11 = 1
      ID12 = ID11+ND2
      ID22 = ID12+NDSQ
C
      DO 7 I=1,nch2
      r11(I) = ZERO
      r22(i) = zero
 7    continue
      do 8 i=1,nchsq
      r12(i) = zero
 8    continue
C
      K = 0
      DO 11 I=1,NVCHAN
      DO 1 J=1,I
      K = K+1
      R11(K) = CRV(IV11+K-1)
      R22(K) = CRV(IV22+K-1)
 1    continue
 11   continue
      KD = -1
      DO 21 I=1,NDIS
      K = K+NVCHAN
      DO 2 J=1,I
      KD = KD+1
      K = K+1
      R11(K) = CRD(ID11+KD)
      R22(K) = CRD(ID22+KD)
 2    continue
 21   continue
C
      KR = IV12-1
      K = -NCHAN
      DO 31 I=1,NVCHAN
      K = K+NCHAN
      DO 3 J=1,NVCHAN
      KR = KR+1
      R12(K+J) = CRV(KR)
 3    continue
 31   continue
      K = K+NCHAN
      KD = ID12-1
      DO 41 I=1,NDIS
      K = K+NVCHAN
      DO 4 J=1,NDIS
      K = K+1
      KD = KD+1
      R12(K) = CRD(KD)
 4    continue
 41   continue
C
C----- ADD LOWER TRIANGLE OF R-MULTIPLIED R-MATRIX TO R11
      K = 0
      DO 51 J=1,NCHAN
      DO 5 I=1,J
      K = K+1
      R11(K) = R11(K)+ SIGN*RMAT(I,J)
 5    continue
 51   continue
C
C----- EVALUATE MATRIX EXPRESSION TO GET LOWER TRIANGLE OF NEW
C      R-MULTIPLIED R-MATRIX
      CALL FACTOR(NCHAN,R11,WK)
      CALL MULTC(NCHAN,NCHAN,R11,R12)
      CALL MULTD(NCHAN,NCHAN,R12,R22,R11,WK)
C
C      UNPACK FINAL R-MATRIX
      K = 0
      DO 61 J=1,NCHAN
      DO 6 I=1,J
      K = K+1
      RMAT(I,J) = SIGN*R11(K)
      RMAT(J,I) = RMAT(I,J)
 6    continue
 61   continue
C
      IF(IPFLG.GT.0) THEN
        WRITE(IWRITE,1013)
 1013   FORMAT(/' FINAL R-MATRIX IS'/)
        CALL WRECMT(RMAT,NCHAN,NCHAN,NCHAN,NCHAN,ICOL,IWRITE)
      ENDIF
C
      RETURN
      END
      SUBROUTINE WRONSK(NCHAN,NOPEN,F,FP,IWRITE,IDIAG,EPS)
C
C***********************************************************************
C
C     WRONSK  PRINTS THE ASYMPTOTIC WAVEFUNCTIONS, F AND THEIR
C                    DERIVATIVES, FP, IF IDIAG IS NONZERO.
C
C             THE MULTICHANNEL WRONSKIAN RELATIONS ARE EVALUATED AND A
C             WARNING PRINTED IF THEY ARE VIOLATED BY MORE THAN EPS.
C
C             NCHAN     IS THE NUMBER OF CHANNELS
C             NOPEN     IS THE NUMBER OF OPEN CHANNELS ( ORDERED FIRST )
C             IWRITE    UNIT NUMBER OF THE PRINTER OR OUTPUT DEVICE
C
C             F,FP      ASYMPTOTIC FUNCTIONS AND DERIVATIVES
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      DIMENSION F(NCHAN,NCHAN,2),FP(NCHAN,NCHAN,2)
C
      DATA  ZERO/0.0D0/,ONE/1.0D0/
C
 1000 FORMAT(1X,4D30.15)
 1010 FORMAT(/,' REGULAR FUNCTIONS')
 1020 FORMAT(/,' REGULAR DERIVATIVES')
 1030 FORMAT(/,' IRREGULAR FUNCTIONS')
 1040 FORMAT(/,' IRREGULAR DERIVATIVES')
 1050 FORMAT(/,' MULTICHANNEL WRONSKIAN RELATIONS :',/,' I0 =',I3,/)
 1060 FORMAT(' I1 =',I3,5X,' I2 =',I3,5X,'WRONSKIAN =',D30.17)
 1070 FORMAT(' I0 =',I3,5X,' I1 =',I3,5X,' I2 =',I3,5X,'WRONSKIAN =',
     X       D30.17)
C
C     PRINT VALUES OF ASYMPTOTIC FUNCTIONS AND THEIR DERIVATIVES
C
      IF(IDIAG .EQ. 0) GO TO 50
      WRITE(IWRITE,1010)
      DO 10 I=1,NCHAN
      WRITE(IWRITE,1000) (F(I,J,1),J=1,NCHAN)
   10 CONTINUE
      WRITE(IWRITE,1020)
      DO 20 I=1,NCHAN
      WRITE(IWRITE,1000) (FP(I,J,1),J=1,NCHAN)
   20 CONTINUE
      WRITE(IWRITE,1030)
      DO 30 I=1,NCHAN
      WRITE(IWRITE,1000) (F(I,J,2),J=1,NCHAN)
   30 CONTINUE
      WRITE(IWRITE,1040)
      DO  40  I=1,NCHAN
      WRITE(IWRITE,1000) ( FP(I,J,2),J=1,NCHAN)
   40 CONTINUE
C
C     CHECK MULTICHANNEL WRONSKIAN RELATIONS FOR SOLUTIONS
C
   50 DO 82 I0=1,2
      IF(IDIAG .NE. 0) WRITE(IWRITE,1050) I0
C
      DO 81 J1=1,NCHAN
      DO 80 J2=1,NCHAN
      SUM=ZERO
      TSUM=ZERO
      DO 60 I=1,NCHAN
      SUM=SUM+FP(I,J1,1)*F(I,J2,I0)-F(I,J1,1)*FP(I,J2,I0)
   60 CONTINUE
C
      IF(IDIAG .eq. 0) then
        IF(I0.EQ.2 .AND. J1.EQ.J2 .AND. J1.LE.NOPEN) TSUM=ONE
        IF(DABS(SUM-TSUM) .gt. EPS) WRITE(IWRITE,1070)I0,J1,J2,SUM
      else
        WRITE(IWRITE,1060)J1,J2,SUM
      endif
C
   80 CONTINUE
 81   continue
 82   continue
C
      RETURN
      END
