! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE AMPLTD(RA1,RA2,HMLT,AMPA1,AMPA2,EIGEN,WORK,LBUG)
C
C***********************************************************************
C
C      AMPLTD DIAGONALIZES THE HAMILTONIAN MATRIX ON A GIVEN
C      SUBRANGE, STORES ITS EIGENVALUES AND USES ITS EIGENVECTORS
C      TO COMPUTE THE SURFACE AMPLITUDES
C
C      INPUT PARAMETERS ARE
C       RA1,RA2, THE RADII OF THE END POINTS OF THE CURRENT SUBRANGE
C       HMLT, THE HAMILTONIAN MATRIX EVALUATED OVER THIS SUBRANGE80
C       (THE UPPER TRIANGLE STORED ROW-WISE)
C       LBUG, SWITCH FOR DEBUG OUTPUT
C       EIGO,VECTO AND WORK, ARRAYS USED AS WORK SPACE
C
C      OUTPUT PARAMETERS ARE
C       AMPA1,AMPA2, THE SURFACE AMPLITUDES
C       EIGEN, THE EIGENVALUES OF THE HAMILTONIAN
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON/RPROPS/NCHAN,IWRITE,IDISC,IXMAX,NHSIZE,NHD,NLEG,MLEG
     1,IREV,INPR
      DIMENSION AMPA1(NCHAN,NHD),AMPA2(NCHAN,NHD),EIGEN(NHD)
      DIMENSION HMLT(NHD,NHD),WORK(*)
      DATA ZERO,ONE/0.D0,1.D0/,IFAIL/0/
C
      IF(LBUG.GT.0) WRITE(IWRITE,1000)
C
      RA12 = RA2-RA1
C
C      THE HAMILTONIAN MATRIX IS DIAGONALIZED BY HSLDR.
!NV-03 NAG routine F02ABF has been repalced by LAPACK routine
!NV-03 DSYEV and its LAPACK library subset (NV 15/10/03).
!NV-03 Test run on H2O (NV 27/10/03).  
C      THE EIGENVALUES ARE STORED IN ARRAY EIGEN AND ONE VECTOR
C      IS STORED IN ARRAY VECTO. EACH CALL TO HSLDR PRODUCES ONE
C      EIGENVECTOR.
C
!NV-03      CALL F02ABF(HMLT,NHD,NHD,EIGEN,HMLT,NHD,WORK,IFAIL)
            call dsyev('v','l',nhd,hmlt,nhd,eigen,work,3*nhd,ifail)
      IF(LBUG.NE.0) WRITE(IWRITE,1002) (EIGEN(NEIG),NEIG=1,NHD)
      DO 1 K=1,NHD
C
C      OPTIONAL OUTPUT OF EIGENVALUES AND EIGENVECTORS
C
      IF(LBUG.GE.2) THEN
        WRITE(IWRITE,1003) K
        WRITE(IWRITE,1002) (HMLT(NVEC,K),NVEC=1,NHD)
      ENDIF
      DO 2 I=1,NCHAN
      AMPA1(I,K) = ZERO
      AMPA2(I,K) = ZERO
 2    CONTINUE
C
C      DETERMINE THE SURFACE AMPLITUDES AT RA1 AND RA2 AND STORE
C      THESE IN MATRICES AMPA1 AND AMPA2 RESPECTIVELY.
C
      IK = 0
      SIGN = -ONE
C
C      SUM OVER THE INDEX ON LEGENDRE POLYNOMIALS
C
      DO 30 J=1,NLEG
      ROOTF=DSQRT((Dble(2*J -1))/RA12)
      SIGN = -SIGN
      ROOTS = SIGN*ROOTF
C
      DO 3 I=1,NCHAN
      IK=IK+1
      AMPA1(I,K)=AMPA1(I,K)+HMLT(ik,k)*ROOTS
      AMPA2(I,K)=AMPA2(I,K)+HMLT(ik,k)*ROOTF
C
    3 CONTINUE
 30   continue
C
C      OPTIONAL OUTPUT OF SURFACE AMPLITUDES
C
      IF(LBUG.LT.2) GO TO 1
      WRITE(IWRITE,1004) RA1
      WRITE(IWRITE,1002) (AMPA1(I,K),I=1,NCHAN)
      WRITE(IWRITE,1004) RA2
      WRITE(IWRITE,1002) (AMPA2(I,K),I=1,NCHAN)
C
 1    CONTINUE
C
 1000 FORMAT('1'/52X,'SUBROUTINE AMPLTD'/52X,' -----------------'
     1/5X,'EIGENVALUES IN RYDBERG'/)
 1002 FORMAT(1X,8F14.7)
 1003 FORMAT(/5X,'EIGENVECTOR',I5/)
 1004 FORMAT(/5X,'AMPLITUDE AT=',F10.5,3X,'A.U.'/)
C
      RETURN
      END
      SUBROUTINE PROP(ETOTR,AMPA1,AMPA2,EIGEN,NRANG,R11,R12,R22)
C
C***********************************************************************
C
C      PROP SETS UP THE CURLY R-MATRICES FOR THE GLOBAL PROPAGATOR
C
C      INPUT PARAMETERS ARE
C       ETOTR  = IMPACT ENERGY (AS IN CALL TO RPROP2)
C       AMPA1,AMPA2 ARE SURFACE AMPLITUDES FOR THE CURRENT SUBRANGE
C       EIGEN  = EIGENVALUES OF SUBRANGE HAMILTONIAN
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON/RPROPS/NCHAN,IWRITE,IDISC,IXMAX,NHSIZE,NHD,NLEG,MLEG
     1,IREV,INPR
      DIMENSION R11(*),R12(NCHAN,NCHAN),R22(*),S11(nchan*(nchan+1)/2),
     * S12(NCHAN,NCHAN),
     1 S22(nchan*(nchan+1)/2),SIGMA(NCHAN),AMPA1(NCHAN,NHD),
     * AMPA2(NCHAN,NHD),EIGEN(NHD),A(NCHAN,NCHAN),B(NCHAN,NCHAN)
      DATA ZERO/0.D0/,ONE/1.D0/
C
      NCHAN2 = NCHAN*(NCHAN+1)/2
      do 100 i=1,nchan
      sigma(i) = zero
      do 10 j=1,nchan
      s12(j,i) = zero
 10   continue
 100  continue
      do 11 k=1,nchan2
      s11(k) = zero
      s22(k) = zero
 11   continue
C
C      SUM OVER THE INDEX OF EIGENVALUES
C
      DO 3 KL=1,NHD
      EDENOM = ONE/(EIGEN(KL)-ETOTR)
C
C      COMPUTE LOWER TRIANGLES OF (SYMMETRIC) MATRICES R11 AND R22
C
c      sspr is also nag f06pqf
      call dspr('u',nchan,edenom,ampa1(1,kl),1,s11)
      call dspr('u',nchan,edenom,ampa2(1,kl),1,s22)
C
C      COMPUTE (NON-SYMMETRIC) MATRIX R12
C
c     sger is also nag f06pmf
      call dger(nchan,nchan,edenom,ampa1(1,kl),1,ampa2(1,kl),1,
     1 s12,nchan)
C
 3    CONTINUE
C
      IF(NRANG.EQ.1) THEN
        DO 1 K=1,NCHAN2
        R11(K) = R11(K)+S11(K)
        R22(K) = S22(K)
 1      continue
        DO 20 J=1,NCHAN
        DO 2 I=1,NCHAN
        R12(I,J) = S12(I,J)
 2      continue
 20     continue
      ELSE
        DO 6 K=1,NCHAN2
        R22(K) = R22(K)+S11(K)
 6      continue
        DO 70 J=1,NCHAN
        DO 7 I=1,NCHAN
        A(I,J) = R12(J,I)
        B(I,J) = S12(I,J)
 7      continue
 70     continue
C
        CALL FACTOR(NCHAN,R22,SIGMA)
        CALL MULTC(NCHAN,NCHAN,R22,A)
        CALL MULTC(NCHAN,NCHAN,R22,B)
        CALL MULTD(NCHAN,NCHAN,A,R11,R11,SIGMA)
        CALL MULTD(NCHAN,NCHAN,B,S22,R22,SIGMA)
C
        do 19 k=1,nchan
        do 18 j=1,nchan
        b(k,j) = sigma(k)*b(k,j)
 18     continue
 19     continue
c
c      (sgemm is blas 3 routine and is identical to Nag f06yaf)
        call dgemm('t','n',nchan,nchan,nchan,one,a,nchan,b,nchan,
     1   zero,r12,nchan)
C
      ENDIF
C
      RETURN
      END
      SUBROUTINE RPROP1(NCH,A,B,ETHR,NMX,MRANGE,NBASIS,EBIG,SCALE,LAMAX,
     1ION,LCHL,CF,BBLOCH,LBUG,IWR,IDISK,AMPA,EIGEN,NAMPX,BIGVEC,WORK,
     2POTL)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     RPROP1 IS THE ENERGY INDEPENDANT ENTRY TO PROPAGATOR PACKAGE
C      (GLOBAL PROPAGATOR VERSION)
C
C***********************************************************************
C
C      INPUT PARAMETERS ARE
C
C      NCH    = NUMBER OF COUPLED EQUATIONS
C      A      = STARTING RADIUS OF PROPAGATION
C      B      = FINAL RADIUS OF PROPAGATION
C      ETHR   = THRESHOLD ENERGY OF EACH CHANNEL IN RYDBERGS
C      NMX    = DIMENSION OF ARRAYS ETHR AND RMAT IN CALLING ROUTINE
C      MRANGE = NUMBER OF SUBRANGES TO BE USED IN PROPAGATION.
C               IF THIS IS SET TO ZERO THEN THE PROGRAM WILL CHOSE
C               AN APPROPRIATE VALUE BASED ON EBIG
C      NBASIS = ARRAY OF LENGTH MRANGE (OR 1 IF MRANGE=0) HOLDING
C               THE NUMBER OF BASIS FUNCTIONS TO BE USED IN EACH
C               SUBRANGE. IF ANY ELEMENT IS SET TO ZERO OR IS
C               GREATER THAN THE CURRENT MAXIMUM (MLEG SEE BELOW)
C               THEN IT IS SET TO MLEG. IF MRANGE=0 BUT NBASIS.NE.0 THEN
C               THE PROGRAM WILL USE NBASIS BASIS FUNCTIONS IN ALL
C               SUBRANGES.
C      EBIG   = LARGEST MODULUS OF ENERGY IN ANY CHANNEL OF CURRENT RUN
C               IN RYD. (USED TO DETERMINE NUMBER OF SUB-RANGES REQUIRED
C               IN PROPAGATION) ONLY REQUIRED IF MRANGE=0
C      BBLOCH = PARAMETER IN BLOCH OPERATOR (USUALLY SET TO ZERO)
C      LBUG   = ARRAY HOLDING DEBUG PRINT SWITCHES (SEE BELOW)
C      IWR    = LOGICAL UNIT NUMBER OF OUTPUT DEVICE
C      IDISK  = LOGICAL UNIT NUMBER OF SCRATCH DISC FOR TEMPORARY
C               STORAGE OF SURFACE AMPLITUDES (IF THIS IS NOT REQUIRED
C               SET IDISK=0)
C      AMPA   = ARRAY USED FOR STORAGE OF BOTH THE SURFACE AMPLITUDES
C               AND THE POTENTIAL MATRIX.
C      EIGEN  = ARRAY USED TO HOLD BOTH THE EIGENVALUES OF THE
C               HAMILTONIAN MATRICES AND THE RADII AT WHICH THE
C               POTENTIAL MATRIX IS EVALUATED.
C      NAMPX  = ACTUAL DIMENSION OF AMPA AS DECLARED IN CALLING PROGRAM
C               THIS SHOULD BE AS LARGE AS POSSIBLE AND SHOULD BE A
C               MULTIPLE OF 2*NCH*NCH
C      BIGVEC AND WORK ARE ARRAYS USED AS WORK SPACE, THEIR DIMENSIONS
C               ARE SPECIFIED BELOW
C      POTL   = NAME OF SUBPROGRAM WHICH GENERATES THE POTENTIAL
C              MATRIX. SEE BELOW.
C
C***********************************************************************
C
C      DEBUG PRINT SWITCHES ARE
C
C      LBUG(1)=1...FOR RADII AT WHICH THE POTENTIAL MATRIX IS EVALUATED
C                  AND NUMBER OF BASIS FUNCTIONS USED IN EACH SUBRANGE
C      LBUG(1)=2...AS ABOVE BUT ROUTINE EXITS WITH THE RADII STORED
C                  IN ARRAY EIGEN BUT WITHOUT CARRYING OUT ANY
C                  FURTHER CALCULATIONS.
C      LBUG(2)=1...FOR HAMILTONIAN MATRIX ELEMENTS IN SETMTR
C      LBUG(3)=1...FOR EIGENVALUES IN AMPLTD
C      LBUG(3)=2...FOR EIGENVALUES,EIGENVECTORS AND SURFACE AMPLITUDES
C                  IN AMPLTD
C      LBUG(4)=1...FOR PROPAGATED R-MATRIX AT END OF EACH SUB-RANGE.
C
C***********************************************************************
C
C      COMMON/RPROPS/ HOLDS VARIABLES LOCAL TO THIS PACKAGE, THESE ARE
C            NCHAN  = NCH
C            IWRITE = IWR
C            IDISC  = IDISK
C            IXMAX  = NUMBER OF WEIGHTS AND ABSCISSAE IN QUADRATURE
C            NHD    = DIMENSION OF HAMLITONIAN MATRIX IN  SUBRANGE
C            NHSIZE = NHD*(NHD+1)/2
C            NLEG   = NUMBER OF BASIS FUNCTIONS USED IN CURRENT SUBRANGE
C            MLEG   = MAXIMUM PERMITTED NUMBER OF BASIS FUNCTIONS
C
C***********************************************************************
C
C      PRESENT DIMENSIONS ARE SET FOR A 10-POINT GAUSS-LEGENDRE
C      QUADRATURE AND UP TO 10 BASIS FUNCTIONS (LEGENDRE POLYNOMIALS)
C      THE VARIABLE MLEG SPECIFIES THIS MAXIMUM AND IS SET BELOW
C
C***********************************************************************
C
C      DIMENSIONS OF THE ARRAYS ARE DEFINED AS FOLLOWS
C
C       ETHR(NMX),RMAT(NMX,NMX),NBASIS(MRANGE)
C       PL(MLEG,IXMAX),XI(IXMAX),WTS(IXMAX),
C       WORK(NCH*NLEG*10)
C       BIGVEC((NCH*NLEG)*(NCH*NLEG+1)/2),
C       AMPA(NAMPX),EIGEN(10*NCH*NRANG),
C       (NLEG= MAXIMUM NUMBER OF BASIS FUNCTIONS IN ANY SUBRANGE)
C         THE PROGRAM ATTEMPTS TO STORE ALL POTENTIALS AND AMPLITUDES
C         IN CORE. IT CAN DO THIS IF THE NUMBER OF SUBRANGES IN THE
C         PROPAGATION IS LESS THAN OR EQUAL TO
C             NAMPX/(4*IXMAX*NCH*NCH)
C         IF THIS IS NOT THE CASE THEN A SCRATCH FILE WILL BE REQUIRED
C         AND NAMPX SHOULD BE SET EQUAL TO 2*NCH*NCH*MAX(NLEG,IXMAX)
C         THE DIMENSION OF EIGEN CAN ALSO BE REDUCED TO 2*IXMAX*NCH.
C
C***********************************************************************
C
      COMMON/RPROPS/NCHAN,IWRITE,IDISC,IXMAX,NHSIZE,NHD,NLEG,MLEG
     1,IREV,INPR
      DIMENSION AMPA(*),EIGEN(*),XI(5),WTS(5),PL(10,5),ETHR(*),
     1 BIGVEC(*),LBUG(3),NBASIS(*),LCHL(*),CF(NCH,NCH,*),
     2 WORK(*)
C
C      ABSCISSAE AND WEIGHTS FOR GAUSS-LEGENDRE QUADRATURE8
C
      DATA XI(1)/0.973906528517172d0 /,WTS(1)/0.066671344308688d0 /
      DATA XI(2)/0.865063366688985d0 /,WTS(2)/0.149451349150581d0 /
      DATA XI(3)/0.679409568299024d0 /,WTS(3)/0.219086362515982d0 /
      DATA XI(4)/0.433395394129247d0 /,WTS(4)/0.269266719309996d0 /
      DATA XI(5)/0.148874338981631d0 /,WTS(5)/0.295524224714753d0 /
C
      DATA HALF/0.5D0/,DELTA/6.D0/,EPS/1.D-10/
C
      NCHAN = NCH
      IWRITE = IWR
      IDISC  = 0
      IXMAX = 5
      MLEG = 10
C
      RANGE =  ABS(B-A)
      IF(RANGE.LT.EPS) GO TO 75
C
C      CALCULATE THE NUMBER OF SUBRANGES IF NOT ALREADY SPECIFIED
C
      IF(MRANGE.EQ.0) THEN
        NRANGE = SQRT(EBIG)*RANGE/DELTA+HALF
        NRANGE = MAX(NRANGE,1)
      ELSE
        NRANGE = MRANGE
      ENDIF
C
C     CHECK NUMBER OF BASIS FUNCTIONS TO BE INCLUDED IN EACH SUBRANGE
C    THIS HAS BEEN MODIFIED TO PROHIBIT THE USE OF DIFFERENT NUMBERS
C   OF BASIS FUNCTIONS IN DIFFERENT SUBRANGES WHICH MAKES INTERFACING
C     MUCH EASIER
C
      IF(NBASIS(1).EQ.0) THEN
        NLEG = MLEG
        INPR = 0
C     ELSE IF (MRANGE.LE.1) THEN
      ELSE
        NLEG = NBASIS(1)
        INPR = 0
C     ELSE
C       NLEG = 0
C       DO 19 IR=1,NRANGE
C       IF(NBASIS(IR).LE.0) NBASIS(IR)=MLEG
C       IF(NBASIS(IR).GT.MLEG) NBASIS(IR)=MLEG
C       IF(NBASIS(IR).GT.NLEG) NLEG=NBASIS(IR)
C19     CONTINUE
C       INPR = 1
      ENDIF
C
C     THE FOLLOWING DIMENSIONS ARE REQUIRED BY POTL
      MHD = 2*NCHAN*IXMAX
      MINDIM = 2*NCHAN*NCHAN*MAX(NLEG,IXMAX)
      MAMP = NCHAN*MHD
      NAMPR = MAMP*NRANGE
C
C      CHECK THAT THERE IS SUFFICIENT SPACE TO STORE SURFACE AMPLITUDES
C      IF THERE IS NOT, CHECK THAT A SCRATCH DISC IS AVAILABLE.
C
      IF(2*NAMPR.GT.NAMPX) THEN
        IF(IDISK.EQ.0.OR.MINDIM.GT.NAMPX) GO TO 74
        NAMPR = MAMP
        IDISC = IDISK
        REWIND IDISC
      ENDIF
C
C      INITIALIZE DEBUG PRINTS
C
      MBUG = 0
      DO 8 I=1,3
      MBUG = MAX(MBUG,LBUG(I))
 8    continue
      IF(MBUG.GT.0) WRITE(IWRITE,20)A,B,NRANGE
      IF(LBUG(1).NE.0.AND.INPR.EQ.0) WRITE(IWRITE,21)NLEG
      IF(LBUG(1).NE.0.AND.INPR.NE.0) WRITE(IWRITE,21)(NBASIS(IR),IR=1,
     1NRANGE)
C
C     INITIALIZE FORWARD/BACKWARD PROPAGATION
C
      IF(B.GT.A) THEN
        IREV = 0
        IR2 = 1
      ELSE
        IREV = 1
        IR2 = 0
      ENDIF
      DR = RANGE/ FLOAT(NRANGE)
C
C      LEGNDR EVALUATES LEGENDRE POLYNOMIALS PL(X)
C      AT THE ABSCISSAE OF THE GAUSS-LEGENDRE QUADRATURE SCHEME
C      MLEG, THE MAXIMUM NUMBER OF POLYNOMIALS INCLUDED IN THE
C      EXPANSION IS EQUAL TO 2*IXMAX, THE NUMBER OF POINTS IN
C      THE QUADRATURE SCHEME.
C
      CALL LEGNDR(PL,XI,MLEG,IXMAX)
C
      RA2 = MIN(A,B)
      NRAMP = 1
      NREIG = 1
C
C      LOOP OVER SUBRANGES
C
      DO 2 NRANG=1,NRANGE
      RA1 = RA2
      RA2 = RA2+DR
      I1 = NRAMP+IREV*NAMPR
      I2 = NRAMP+IR2*NAMPR
      IF(INPR.NE.0) NLEG=NBASIS(NRANG)
      NHD = NCHAN*NLEG
      NHSIZE = NHD*(NHD+1)/2
      NAMP = NCHAN*NHD
C
C     SET UP POTENTIAL MATRIX
C
C     THIS IS STORED AS AN (NCHAN*NCHAN*NPTS) ARRAY AND INCLUDES THE
C     CENTRIFUGAL TERM.
C     THE NUMBER OF MESH POINTS (NPTS) AND THEIR RADII ARE GENERATED
C     BY SUBROUTINE MESH. (THEY CANNOT BE CHOSEN BY THE MAIN PROGRAM)
C     IN ORDER TO SAVE SPACE THE MESH IS STORED IN ARRAY EIGEN AND
C     THE POTENTIALS IN AMPA, THEY WILL EVENTUALLY BE OVERWRITTEN.
C     THE MATRIX IS SET UP FOR THE ENTIRE RANGE (A,B) ON THE FIRST
C     PASS THROUGH THE SUBRANGE LOOP UNLESS A SCRATCH DISC IS BEING
C     USED TO STORE THE AMPLITUDES. IN THIS CASE THE POTENTIAL MUST
C     BE SET UP SEPARATELY FOR EACH SUBRANGE AS IT WOULD OTHERWISE
C     BE OVERWRITTEN.
C
      IF(IDISC.NE.0.OR.NRANG.EQ.1) THEN
C
C     MUST CALCULATE POTENTIALS
        IF(IDISC.NE.0) THEN
          NPTS = 2*IXMAX
          CALL MESH(RA1,RA2,1,IXMAX,XI,NPTS,EIGEN)
        ELSE
          NPTS = 2*IXMAX*NRANGE
          CALL MESH(A,B,NRANGE,IXMAX,XI,NPTS,EIGEN)
        ENDIF
        IF(LBUG(1).NE.0) WRITE(IWRITE,24)(EIGEN(I),I=1,NPTS)
        IF(LBUG(2).EQ.2) GO TO 2
C
        CALL POTL(NCHAN,LAMAX,ION,LCHL,CF,NPTS,EIGEN,AMPA)
C
      ENDIF
C
C      SETMTR SETS UP MATRIX ELEMENTS OF THE HAMILTONIAN
C      ON THE SUBRANGE (RA1,RA2) IN ARRAY BIGVEC.
C
      CALL SETMTR(RA1,RA2,BIGVEC,WTS,PL,AMPA(NRAMP),ETHR,BBLOCH,
     1SCALE,LBUG(2))
C
C       AMPLTD DIAGONALIZES THE SUBRANGE HAMILTONIAN AND
C       EVALUATES THE SURFACE AMPLITUDES AT RA1 AND RA2, STORING
C      THEM IN MATRIX AMPA AND THE EIGENVALUES IN ARRAY EIGEN.
C
      CALL AMPLTD(RA1,RA2,BIGVEC,AMPA(I1),AMPA(I2),EIGEN(NREIG),WORK,
     1 LBUG(3))
C
C      WRITE AMPLITUDES TO DISC IF NECESSARY
C
      IF(IDISC.EQ.0) THEN
        DO 91 I=NREIG,NREIG+MHD-1
        EIGEN(I) = EIGEN(I)/SCALE
 91     continue
        NRAMP = NRAMP+MAMP
        NREIG = NREIG+MHD
      ELSE
        DO 92 I=1,NHD
        EIGEN(I) = EIGEN(I)/SCALE
 92     continue
        WRITE(IDISC)(AMPA(I),I=1,2*NAMP),(EIGEN(I),I=1,NHD)
      ENDIF
C
 2    CONTINUE
C
C      END OF SUBRANGE LOOP
C
      RETURN
C
C      ERROR MESSAGES
C
 74   WRITE(IWRITE,22)NCHAN,NLEG,NRANGE
      STOP
 75   WRITE(IWRITE,23)A,B,EBIG
      NRANGE = 0
      RETURN
C
C      FORMAT STATEMENTS
C
 20   FORMAT(//' R-MATRIX PROPAGATION  INITIAL RADIUS=',F10.5,3X,
     1' FINAL RADIUS=',F10.5,3X,'NO. OF RANGES=',I2/)
 21   FORMAT(' THE NUMBER OF BASIS FUNCTIONS INCLUDED IN EACH SUBRANGE
     1 IS',8I5/(20I5)/)
 22   FORMAT(/' INSUFFICIENT SPACE IN AMPA AND EIGEN FOR NCHAN=',I2,3X,
     1'NLEG=',I2,3X,'NRANGE=',I2/)
 23   FORMAT(/' NO PROPAGATION REQUIRED FOR A=',F14.7,3X,'B=',F14.7,
     13X,'EBIG=',F14.7/)
 24   FORMAT(/' THE POTENTIAL MATRIX IS EVALUATED AT THE FOLLOWING RADII
     1'/(12F10.4))
      END
      SUBROUTINE SETMTR(RA1,RA2,HMLT,WTS,PL,V,ETHR,BBLOCH,SCALE,LBUG)
C
C***********************************************************************
C
C     THIS ROUTINE SETS UP THE HAMILTONIAN MATRIX ON A GIVEN SUBRANGE
C
C     INPUT PARAMETERS ARE
C      RA1,RA2, THE RADII OF THE END POINTS OF THE SUBRANGE
C      XI,WTS, THE ABSCISSAE AND WEIGHTS FOR THE QUADRATURE
C      PL, NORMALIZED BASIS FUNCTIONS (LEGENDRE POLYNOMIALS)
C          EVALUATED AT THE ABSCISSAE OF THE QUADRATURE SCHEME
C      V, THE POTENTIAL MATRIX EVALUATED AT THE ABSCISSAE
C      ETHR, THRESHOLD ENERGIES
C      BBLOCH, PARAMETER IN BLOCH OPERATOR
C      LBUG, SWITCH FOR DEBUG OUTPUT
C
C     OUTPUT PARAMETER IS
C      HMLT, THE UPPER TRIANGLE OF THE HAMILTONIAN MATRIX
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON/RPROPS/NCHAN,IWRITE,IDISC,IXMAX,NHSIZE,NHD,NLEG,MLEG
     1,IREV,INPR
      DIMENSION ETHR(NCHAN),V(NCHAN,NCHAN,2*IXMAX+1)
     X,WTS(IXMAX),PL(MLEG,IXMAX),HMLT(NHD,NHD)
      DATA ZERO,ONE,TWO/0.D0,1.D0,2.D0/
C
C
      IF(LBUG.EQ.1) WRITE(IWRITE,1000)
C
      IXMAX2 = 2*IXMAX+1
      R12 = ONE/(RA2-RA1)
      R1B = ZERO
      R2B = ZERO
      IF(BBLOCH.NE.ZERO) R1B = R12*BBLOCH/RA1
      IF(BBLOCH.NE.ZERO) R2B = R12*BBLOCH/RA2
      RSQ = TWO*R12*R12
C
C      LOOP OVER THE FIRST INDEX ON LEGENDRE POLYNOMIALS
C
      NI = 0
      DO 30 NN=1,NLEG
C
C      LOOP OVER THE FIRST INDEX ON CHANNELS
C
      DO 3 I=1,NCHAN
      NI = NI+1
C
C      LOOP OVER THE SECOND INDEX ON LEGENDRE POLYNOMIALS
C
      DO 5 MM=NN,NLEG
      JMN = MOD(MM+NN,2)+1
      SGN = (-1)**JMN
C
C      CALCULATE MATRIX ELEMENTS WHICH DO NOT INCLUDE THE POTENTIAL
C      USING CLOSED FORM EXPRESSIONS
C
      ROOTMN = DSQRT((TWO*Dble(NN)-ONE)*(TWO*Dble(MM)-ONE))
      DIAG = -ROOTMN*(R2B+SGN*R1B)
      IF(NN.EQ.MM) DIAG=DIAG+ETHR(I)
      IF(JMN.EQ.1) DIAG=DIAG+RSQ*ROOTMN*Dble(NN*(NN-1))
      J1 = 1
      IF(MM.EQ.NN) J1=I
C
C      LOOP OVER THE SECOND INDEX ON CHANNELS
C
      DO 6 J=J1,NCHAN
      MJ = (MM-1)*NCHAN+J
      SUM1=ZERO
C
      IF(I.EQ.J) SUM1=DIAG
C
C      CALCULATE THE MATRIX ELEMENTS OF THE POTENTIAL USING NUMERICAL
C      (GAUSS-LEGENDRE) QUADRATURE.
C
      DO 17 IX=1,IXMAX
      SUM1 = SUM1+WTS(IX)*PL(MM,IX)*PL(NN,IX)*(V(I,J,IXMAX2-IX)-SGN*
     1V(I,J,IX))
   17 CONTINUE
C
C      STORE THE FINAL RESULT IN ARRAY 'HMLT'
C
      HMLT(NI,MJ) = SCALE*SUM1
      HMLT(MJ,NI) = HMLT(NI,MJ)
C
    6 CONTINUE
    5 CONTINUE
    3 CONTINUE
 30   continue
C
C      DEBUG OUTPUT
C
      IF(LBUG.EQ.0) GO TO 11
      WRITE(IWRITE,1001) nhd
      WRITE(IWRITE,1002)
      do 1100 nv=1,nhd
      WRITE(IWRITE,1003) (HMLT(mv,nv),mv=1,nhd)
 1100 continue
 1000 FORMAT(//52X,' SUBROUTINE SETMTR'/52X,' -----------------')
 1001 FORMAT(/5X,' HAMILTONIAN ARRAY SIZE=',I5//)
 1002 FORMAT(/5X,' HAMILTONIAN MATRIX ELEMENTS'//)
 1003 FORMAT(1X,8F14.7)
C
 11   RETURN
C
      END
      SUBROUTINE CURLYR(CR,ETOTR,NCHAN,NRANGE,NBASIS,AMPA,EIGEN,cv,
     1              ifail)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C      CURLYR CALCULATES GLOBAL R-MATRIX FOR PROPAGATION ACROSS ENTIRE
C       RANGE
C
C***********************************************************************
C
C     INPUT PARAMETERS ARE
C
C      ETOTR  = ENERGY OF INCIDENT PARTICLE ON LOWEST ENERGY STATE IN
C               RYDBERGS
C      NCHAN,NBASIS,AMPA,EIGEN ARE AS DEFINED IN RPROP1
C
C      OUTPUT: CR(NCHAN*(2*NCHAN+1))
C
C***********************************************************************
C
      COMMON/RPROPS/NCH,IWRITE,IDISC,IXMAX,NHSIZE,NHD,NLEG,MLEG
     1,IREV,INPR
      DIMENSION NBASIS(*),CR(*),AMPA(*),EIGEN(*)
      DATA ZERO/0.D0/,EPS/1.D-10/
C
      IF(NRANGE.EQ.0) RETURN
C
C----- STORAGE ALLOCATION
      NCH = NCHAN
      NCHSQ = NCHAN*NCHAN
      NCH2 = 2*NCHSQ+NCHAN
      NCHAN2 = (NCHSQ+NCHAN)/2
      MHD = 2*NCHAN*IXMAX
      MAMP = NCHAN*MHD
      IR11 = 1
      IR12 = IR11+NCHAN2
      IR22 = IR12+NCHSQ
      ISIGN = 1-2*IREV
      NAMPR = MAMP*NRANGE
      ifail = 1
C
C     SET UP POINTERS TO SUBRANGE EIGENVALUES AND SURFACE AMPLITUDES
C
      NRAMP= 1
      NREIG = 1
      IF(IDISC.NE.0) REWIND IDISC
      IF(IREV.EQ.1.AND.IDISC.EQ.0) THEN
        NRAMP = MAMP*(NRANGE-1)+1
        NREIG = MHD*(NRANGE-1)+1
      ENDIF
C
      DO 2 K=1,NCH2
      CR(K) = ZERO
 2    continue
C
      NHD = MLEG*NCHAN
      IHD = NHD
C
C      PROPAGATE ACROSS SUBRANGES
C
      DO 15 JR=1,NRANGE
C
C      PICK UP EIGENVALUES AND AMPLITUDES, READING THEM FROM DISC IF
C      NECESSARY
C
      IF(INPR.NE.0) NHD=NBASIS(JR)*NCHAN
      NAMP = NHD*NCHAN
      IF(IDISC.NE.0) THEN
        IF(IREV.EQ.0) THEN
          READ(IDISC)(AMPA(I),I=1,2*NAMP),(EIGEN(I),I=1,NHD)
        ELSE
          REWIND IDISC
          NR = NRANGE-JR+1
          DO 13 IR=1,NR
          IF(INPR.NE.0) IHD=NBASIS(IR)*NCHAN
          IAMP = IHD*NCHAN
          READ(IDISC)(AMPA(I),I=1,2*IAMP),(EIGEN(I),I=1,IHD)
 13       continue
        ENDIF
      ENDIF
C
C      CHECK THAT NO ENERGY DENOMINATOR IS ZERO
C
      IEG = NREIG-1
      DO 5 NEIG=1,NHD
      IEG = IEG+1
      IF( ABS(EIGEN(IEG)-ETOTR).LT.EPS) GO TO 16
 5    CONTINUE
C
C      CALL PROP TO ADD THE CONTIBUTIONS FROM THE CURRENT SUBRANGE
C
      NRANG = JR
C
      CALL PROP(ETOTR,AMPA(NRAMP),AMPA(NRAMP+NAMPR),EIGEN(NREIG),NRANG,
     1CR(IR11),CR(IR12),CR(IR22))
C
      IF(IDISC.EQ.0) THEN
        NRAMP = NRAMP+MAMP*ISIGN
        NREIG = NREIG+MHD*ISIGN
      ENDIF
C
 15   CONTINUE
C
C      END OF SUBRANGE LOOP
C
      RETURN
C
 16   WRITE(IWRITE,1007)ETOTR,EIGEN(IEG)
      ifail = 3
      return
C
 1007 FORMAT(/' ENERGY',F14.7,' TOO CLOSE TO EIGENVALUE',F14.7)
C
      END
      SUBROUTINE FACTOR(NDIM,B,SIGMA)
C
C***********************************************************************
C
C     FACTOR MAKES CHOLESKY TYPE FACTORIZATION OF MATRIX B
C     AS DESCRIBED BY NESBET J.COMP.PHYS 8 (1971) 483
C     ONLY LOWER TRIANGLE OF B IS REQUIRED,
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION B(*),SIGMA(NDIM)
      DATA ONE/1.D0/
C
C-----REPLACES B WITH ITS (LOWER) TRIANGULAR FACTORIZATION
C     NESBET EQUATIONS 12 AND 13
      KIJ = 0
      DO 610 I=1,NDIM
      II = KIJ
      JJ = 0
      DO 609 J=1,I-1
      Q = B(KIJ+J)
      DO 604 NU=1,J-1
      Q = Q-B(II+NU)*SIGMA(NU)*B(JJ+NU)
 604  CONTINUE
      JJ = JJ+J
      B(KIJ+J) = Q/(B(JJ)*SIGMA(J))
 609  CONTINUE
      KIJ = KIJ+I
      Q = B(KIJ)
      DO 704 NU=1,I-1
      Q = Q-B(II+NU)*SIGMA(NU)*B(II+NU)
 704  CONTINUE
      SIGMA(I) = DSIGN(ONE,Q)
      B(KIJ) = DSQRT(DABS(Q))
 610  CONTINUE
C
      RETURN
      END
      SUBROUTINE MULTC(NDIM,NF,B,C)
C
C***********************************************************************
C
C     MULTC IS PART OF CHOLESKY PACKAGE
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION B(*),C(NDIM,NF)
C
C-----REPLACES C BY MATRIX DEFINED BY NESBET EQUATION 14
      DO 665 ICH=1,NF
      C(1,ICH) = C(1,ICH)/B(1)
      KIJ = 1
      DO 664 I=2,NDIM
      Q = C(I,ICH)
      DO 663 K=1,I-1
      Q = Q-C(K,ICH)*B(KIJ+K)
 663  continue
      KIJ=KIJ+I
      C(I,ICH) =  Q/B(KIJ)
 664  continue
 665  continue
C
      RETURN
      END
      SUBROUTINE MULTD(NDIM,NF,C,A,D,SIGMA)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     MULTD IS PART OF CHOLESKY PACKAGE
C
C***********************************************************************
C
      DIMENSION A(*),D(*),C(NDIM,NF),SIGMA(NDIM)
C
C-----SETS UP FINAL MATRIX IN D USING NESBET EQUATION 11
      KKA = 0
      DO 622 ICH=1,NF
      DO 623 JCH=1,ICH
      Q = A(KKA+JCH)
      DO 620 K=1,NDIM
      Q = Q-C(K,ICH)*SIGMA(K)*C(K,JCH)
 620  CONTINUE
      D(KKA+JCH) = Q
 623  CONTINUE
      KKA = KKA+ICH
 622  CONTINUE
C
      RETURN
      END
      SUBROUTINE LEGNDR(PL,XI,NLEG,IXMAX)
C
C***********************************************************************
C
C     THIS SUBROUTINE COMPUTES NORMALIZED LEGENDRE POLYNOMIALS AT THE
C     ABSCISSAE OF THE QUADRATURE SCHEME
C
C     INPUT PARAMETERS ARE
C      NLEG, MAXIMUM NUMBER OF LEGENDRE POLYNOMIALS IN THE BASIS
C      IXMAX, THE NUMBER OF ABSCISSAE
C      XI, AN ARRAY HOLDING THE ABSCISSAE
C
C     OUTPUT PARAMETER IS
C      PL, AN ARRAY HOLDING THE VALUES OF THE POLYNOMIALS
C
C***********************************************************************
C
      IMPLICIT double precision(A-H,O-Z)
      DIMENSION PL(NLEG,IXMAX),XI(IXMAX)
      DATA HALF,ONE,ONEP5,TWO/0.5D0,1.D0,1.5D0,2.D0/
C
      NLEG1 = NLEG-1
C
C      LOOP OVER ABSCISSAE
C
      DO 1 I=1,IXMAX
      X=XI(I)
C
      PL(1,I) = SQRT(HALF)
      PL(2,I) = SQRT(ONEP5)*X
C
C      GENERATE REMAINING POLYNOMIALS, UP TO ORDER NLEG-1, USING
C      RECURSION RELATION
C
      DO 2 K=2,NLEG1
      K1=K-1
      PL(K+1,I)=(SQRT(TWO*K1+ONE)*X*PL(K,I)-K1*PL(K1,I)/SQRT(TWO*K1
     1-ONE))*SQRT(TWO*K+ONE)/dble(K)
 2    continue
    1 CONTINUE
C
      RETURN
      END
      SUBROUTINE MESH(A,B,NRANGE,IXMAX,XI,NPTS,R)
C
C***********************************************************************
C
C      THIS ROUTINE SETS UP THE MESH AT WHICH POTENTIALS ARE REQUIRED
C      THE RADII ARE STORED IN ARRAY R
C
C      INPUT PARAMETERS ARE
C       A      = STARTING PROPAGATION RADIUS
C       B      = FINAL RADIUS
C       NRANGE = NUMBER OF SUBRANGES
C       IXMAX  = NUMBER OF ABSCISSAE IN QUADRATURE SCHEME
C       XI     = ABSCISSAE
C
C      OUTPUT
C       NPTS   = NUMBER OF POINTS IN MESH
C       R(NPTS)= RADII
C
C***********************************************************************
C
      IMPLICIT double precision (A-H,O-Z)
      DIMENSION XI(IXMAX),R(NPTS)
      DATA HALF/0.5D0/,TWO/2.D0/
C
      RA2 = DMIN1(A,B)
      DR2 = HALF*DABS(A-B)/Dble(NRANGE)
      I1 = -IXMAX
C
C      LOOP OVER SUBRANGES
C
      DO 31 NRANG=1,NRANGE
      RA1 = RA2
      RA2 = RA2+TWO*DR2
      RMID = RA1+DR2
      I1 = I1+IXMAX
      I2 = I1+2*IXMAX+1
C
C      LOOP OVER ABSCISSAE
C
      DO 30 IX=1,IXMAX
      I1 = I1+1
      I2 = I2-1
      R(I1) = RMID-DR2*XI(IX)
      R(I2) = RMID+DR2*XI(IX)
 30   CONTINUE
 31   continue
C
      RETURN
      END
      SUBROUTINE HSLDR(N,A,LENGTH,EPSI,EIG,X,NO,WORK)
      IMPLICIT double precision (A-H,O-Z)
C
C      THIS SUBROUTINE ACCEPTS THE UPPER TRIANGLE OF AN N*N SYMMETRIC
C      MATRIX AND ON THE FIRST CALL DETERMINES ALL THE EIGENVALUES AND
C      THE FIRST EIGENVECTOR.  ON EACH FURTHER CALL ONE MORE OF THE
C      REMAINING EIGENVECTORS IS CALCULATED.
C
C      DEFINITION OF THE ARGUMENTS.
C      N........... THE DIMENSION OF THE SYMMETRIC MATRIX TO BE
C                   DIAGONALISED.
C      A........... THE LINEAR ARRAY CONTAINING THE UPPER TRIANGLE OF
C                   THE ORIGINAL MATRIX ,OVERWRITTEN ON RETURN BY THE
C                   MAIN DIAGONAL ELEMENTS OF THE TRI-DIAGONAL MATRIX
C                   AND DETAILS OF THE TRANSFORMING MATRICES.
C      LENGTH...... =(N*(N+1))/2 , THE DIMENSION OF THE ARRAY A.
C      EPSI........ THE ACCURACY TO WHICH THE EIGENVALUES ARE TO BE
C                   DETERMINED.
C      EIG......... THIS ARRAY CONTAINS THE EIGENVALUES ON RETURN.
C      X........... THIS ARRAY CONTAINS ONE EIGENVECTOR ON RETURN.
C      NO.......... THIS RUNS FROM 1 TO N AND SPECIFIES WHICH
C                   EIGENVECTOR IS STORED IN X ON RETURN
C      WORK........ WORK SPACE OF DIMENSION (N,8)
C
      DIMENSION A(LENGTH),EIG(N),X(N),WORK(N,8)
      DATA ZERO/0.0D0  /, ONE/1.0D0  /
C
      if(n.eq.1) then
        x(1) = one
        eig(1) = a(1)
      else if (n.eq.2) then
        WORK(1,2)=A(1)
        WORK(2,2)=A(3)
        WORK(1,1)=A(2)
        WORK(2,1) = zero
        GO TO 4
      endif
c
C      IF THE FIRST EIGENVECTOR HAS ALREADY BEEN FOUND THE
C      TRI-DIAGONALISING AND EIGENVALUE SUBROUTINES ARE SKIPPED ROUND.
C
    3 IF(NO.NE.1) GO TO 5
C
C      THE TRI-DIAGONALISING SUBROUTINE IS ENTERED.
C
      CALL HOUSE(N,A,LENGTH,WORK,WORK(1,2))
C
C      THE ELEMENTS OF THE TRI-DIAGONAL MATRIX ARE USED TO DETERMINE
C      THE EIGENVALUES.
C
    4 CALL EIGEN(N,EIG,EPSI,WORK,WORK(1,2),WORK(1,3))
C
C      THE EIGENVECTOR OF THE TRI-DIAGONAL MATRIX CORRESPONDING TO A
C      PARTICULAR EIGENVALUE IS DETERMINED.
C
 5    EIGNO = EIG(NO)
      CALL VECTOR(N,EIGNO,X)
      IF(N.EQ.2) GO TO 6
C
C      THE CORRESPONDING EIGENVECTOR OF THE ORIGINAL MATRIX IS FOUND.
C
      CALL EIGVEC(N,A,LENGTH,X)
C
C      NORMALIZING THE EIGENVECTOR.
C
    6 APP=ZERO
      DO 7 I=1,N
      APP=APP+X(I)*X(I)
    7 CONTINUE
      APP= DSQRT(APP)
      DO 8 I=1,N
      X(I)=X(I)/APP
    8 CONTINUE
C
    9 RETURN
      END
      SUBROUTINE HOUSE(N,A,LENGTH,P,R)
      IMPLICIT double precision (A-H,O-Z)
C
C      THIS SUBROUTINE ACCEPTS THE UPPER TRIANGLE OF ELEMENTS OF A
C      SYMMETRIC MATRIX, STORED IN THE LINEAR ARRAY A, AND USING THE
C      HOUSEHOLDER METHOD REDUCES THIS TO TRI-DIAGONAL FORM, STORING
C      THE NEW MAIN DIAGONAL ELEMENTS IN POSITION IN A AND ALSO IN THE
C      ARRAY R, AND THE SUPER-DIAGONAL ELEMENTS IN THE ARRAY P. DETAILS
C      OF THE TRANSFORMING MATRICES ARE OVERWRITTEN IN THE REDUNDANT
C      SPACE OF A. N AND LENGTH ARE AS DEFINED IN SUBROUTINE HSLDR.
C
      DIMENSION A(LENGTH),P(N),R(N)
      DATA EPSI/1.0D-9/
      DATA ZERO/0.0D0  /, HALF/0.5D0  / ,ONE/1.D0  /
C
      N1=N-1
      N2=N-2
      NAN=(N*(N+1))/2
      NAN1=NAN-1
C
C      EACH TIME THROUGH THIS LOOP ONE MORE ROW OF THE MATRIX IS
C      TRANSFORMED TO TRI-DIAGONAL FORM.
C
      DO 11 K=1,N2
      DO 1 J=K,N
      P(J)=ZERO
    1 CONTINUE
C
C      KB IS THE NUMBER OF ELEMENTS IN THE FIRST (K-1) ROWS OF THE
C      UPPER TRIANGLE
C
      NJ = N-K
      KC=((K-1)*(2*N-K+2))/2+1
      KC1 = KC+1
C
C      KD IS THE NUMBER OF ELEMENTS IN THE FIRST K ROWS OF THE UPPER
C      TRIANGLE
C
      KD = KC+NJ
C
C      THE SQUARE ROOT OF THE SUM OF THE SQUARES OF THE REMAINING
C      OFF DIAGONAL ELEMENTS IN ROW K IS FOUND AND STORED IN SUM.
C
      SUM=ZERO
      DO 2 J=KC1,KD
      SUM=SUM+A(J)*A(J)
    2 CONTINUE
      SUM= SQRT(SUM)
      IF(SUM.LT.EPSI) GO TO 100
C
C      SUM IS GIVEN THE SAME SIGN AS THE SUPER DIAGONAL ELEMENT IN ROW K
C
      IF(A(KC1).LT.ZERO) SUM=-SUM
      BKR = ONE/(SUM*(SUM+A(KC1)))
C
C      THE FIRST ELEMENT OF THE VECTOR FROM WHICH THE TRANSFORMING
C      MATRIX IS DERIVED IS OVERWRITTEN ON THE OLD SUPER DIAGONAL
C      ELEMENT IN ROW K.THE REMAINING ELEMENTS ARE ALREADY IN POSITION
C      IN ROW K.
C
      A(KC1)=A(KC1)+SUM
C
C      THE SUPER DIAGONAL ELEMENT IN ROW K OF THE NEW TRI-DIAGONAL
C      MATRIX IS STORED IN ARRAY P.
C
      P(K)=-(SUM)
C
C      THE TRANSFORMATION DERIVED FROM THE (N-K) VECTOR ELEMENTS STORED
C      IN A IS NOW APPLIED TO THE LAST(N-K) ROWS OF THE MATRIX. (THE
C      LAST (N-K) SPACES OF THE ARRAY P ARE SUCCESSIVELY OVERWRITTEN IN
C      THE PROCESS).
C
      MO = KD
      LK = KC1
      DO 6 M=K,N1
      MP1 = M+1
      PMP1 = P(MP1)
      NM=N-M
      LO = KD-NM
      DO 3 L=1,NM
      PMP1 = PMP1+A(MO+L)*A(LO+L)
    3 CONTINUE
      MO = MO+NM
      IF(M.EQ.K) GO TO 5
      LK =LK+1
      LL = LK
      LOL = KC1-K
      M1=M-1
      DO 4 L=K,M1
      LL=LL+N-L
      PMP1 = PMP1+A(LL)*A(LOL+L)
    4 CONTINUE
    5 P(MP1) = PMP1*BKR
    6 CONTINUE
C
      URP=ZERO
      DO 7 L=1,NJ
      URP=URP+A(KC+L)*P(K+L)
    7 CONTINUE
      URP=HALF*URP*BKR
      DO 8 L=1,NJ
      P(K+L)=P(K+L)-A(KC+L)*URP
    8 CONTINUE
      KE = KD
      DO 10 I=1,NJ
      PIN = P(K+I)
      AIM = A(KC+I)
      DO 9 J=I,NJ
      A(KE+J)=A(KE+J)-AIM*P(K+J)-PIN*A(KC+J)
    9 CONTINUE
      KE = KE+NJ-I
   10 CONTINUE
      GO TO 120
C
 100  P(K)=-(EPSI)
      DO 101 I=KC1,KD
      A(I)=ZERO
  101 CONTINUE
C
C      THE LAST SUPER DIAGONAL ELEMENT IS ENTERED INTO THE ARRAY P.
C
  120 IF(K.EQ.N2) P(N1)=A(NAN1)
   11 CONTINUE
C
C      THE MAIN DIAGONAL ELEMENTS PICKED OUT FROM THE ARRAY A ARE
C      STORED IN THE ARRAY R.
C
      DO 12 I=1,N
      ILK=((I-1)*(2*N-I+2))/2+1
      R(I)=A(ILK)
   12 CONTINUE
C
      RETURN
      END
      SUBROUTINE EIGEN(N,EIG,EPSI,P,R,BETA)
      IMPLICIT double precision (A-H,O-Z)
C
C      THIS SUBROUTINE ACCEPTS THE ARRAYS R AND P OF MAIN AND SUPER
C      DIAGONAL ELEMENTS RESPECTIVELY. USING THE STURM SEQUENCE
C      PROPERTY A BISECTION METHOD IS APPLIED TO DETERMINE THE
C      EIGENVALUES (STORED IN THE ARRAY EIG ON RETURN) TO AN ACCURACY
C      SPECIFIED BY EPSI. N IS AS DEFINED IN THE SUBROUTINE HSLDR.
C
      DIMENSION EIG(N),P(N),R(N),BETA(N)
      DATA ZERO/0.0D0  /, HALF/0.5D0  /
C
C      CALCULATE THE AVERAGE OF THE GREATEST AND SMALLEST MAIN
C      DIAGONAL ELEMENTS STORING THE RESULT IN AMID.
C
      ASMALL=R(1)
      ALARG=R(1)
      DO 1 I=2,N
      ALARG = DMAX1(ALARG,R(I))
      ASMALL = DMIN1(ASMALL,R(I))
    1 CONTINUE
      AMID=(ALARG+ASMALL)*HALF
C
C      REDUCE EACH MAIN DIAGONAL ELEMENT BY AMID AND CALCUATE, USING
C      THE STURM SEQUENCE PROPERTY, THE EIGENVALUES OF THE CORRESPONDING
C      REDUCED TRI-DIAGONAL MATRIX.
C
      DO 2 I=1,N
      R(I)=R(I)-AMID
    2 CONTINUE
C
C      CALCULATE THE MAXIMUM INFINITY NORM G OF THE MATRIX. THE
C      EIGENVALUES LIE IN THE RANGE -G TO +G.
C
      N1 = N-1
      DA1 = DABS(P(1))
      G = DABS(R(1))+DA1
      IF(N.EQ.2) GO TO 13
      DO 3 I=2,N1
      DA2 = DABS(P(I))
      G1=DABS(R(I))+DA1+DA2
      DA1 = DA2
      G = DMAX1(G,G1)
    3 CONTINUE
 13   G1 = DABS(R(N))+DA1
      G = DMAX1(G,G1)
C
C      CALCULATE THE SQUARES OF THE SUPER DIAGONAL ELEMENTS AND STORE
C      THESE IN THE ARRAY BETA.
C
      DO 4 I=1,N1
      BETA(I)=P(I)*P(I)
    4 CONTINUE
C
C      THIS LOOP DETERMINES THE EIGENVALUES ONE AT A TIME IN ORDER OF
C      ALGEBRAIC SIZE DOWNWARDS.
C
      DO 11 K=1,N
      AL=-G
      BL=G
C
C      ONCE THROUGH THIS LOOP IS ONE BISECTION OF THE RANGE. CL1 IS THE
C      CURRENT ESTIMATE, CL THE IMMEDIATELY PREVIOUS ESTIMATE OF THE
C      EIGENVALUE.
C
      DO 9 J=1,100
      CL1=(AL+BL)*HALF
      IF(J.EQ.1) GO TO 5
C
C      IF THE EIGENVALUE HAS BEEN DETERMINED TO A SPECIFIED ACCURACY
C      EPSI, THE CALCULATION IS COMPLETE.
C
      IF(DABS(CL1-CL).LT.EPSI) GO TO 10
C
C      LSUM STORES THE NUMBER OF AGREEMENTS IN SIGN IN THE STURM
C      SEQUENCE.
C
    5 LSUM=0
      POLY  = R(1)-CL1
      IF(POLY.GT.ZERO) LSUM=LSUM+1
C
C      THIS LOOP CALCULATES ALL THE REMAINING MEMBERS OF THE STURM
C      SEQUENCE. THE NUMBER OF AGREEMENTS IN SIGN IS ALSO DETERMINED.
C
      DO 6 I=2,N
      POLY = R(I)-CL1-BETA(I-1)/POLY
      IF(POLY.GT.ZERO) LSUM=LSUM+1
    6 CONTINUE
      CL=CL1
C
C      THE NEW RANGE FOR THE EIGENVALUE (DEPENDENT ON THE VALUE OF LSUM)
C      IS DETERMINED.
C
      IF(LSUM.lt.K) then
        BL=CL1
      else
        AL=CL1
      endif
    9 CONTINUE
C
C      THE EIGENVALUE IS STORED IN THE ARRAY EIG.
C
   10 EIG(K)=CL1
C
C      RETURN TO CALCULATE THE NEXT EIGENVALUE.
C
   11 CONTINUE
C
C      THE ELEMENTS OF THE ORIGINAL TRI-DIAGONAL MATRIX ARE REGAINED
C      AND ITS EIGENVALUES FOUND.
C
      DO 12 I=1,N
      R(I)=R(I)+AMID
      EIG(I)=EIG(I)+AMID
   12 CONTINUE
C
      RETURN
      END
      SUBROUTINE VECTOR(N,EIGNO,X)
      IMPLICIT double precision (A-H,O-Z)
C
C      THIS SUBROUTINE TAKES ARRAYS R OF MAIN DIAGONAL ELEMENTS, P OF
C      SUPER DIAGONAL ELEMENTS, EIG OF EIGENVALUES, OF THE TRI-DIAGONAL
C      MATRIX , AND BY MEANS OF INVERSE ITERATIONS DETERMINES AN
C      EIGENVECTOR OF THE TRI-DIAGONAL MATRIX.
C
      LOGICAL ITER
      REAL LXCH
      DIMENSION X(N),P(N),R(N),XM(N),B(N),U(N),V(N),W(N),LXCH(N)
      DATA ZERO/0.0D0  /, ONE/1.0D0  /, EPSI/1.0D-9/
C
C      THE ARRAY RN HOLDS THE MAIN DIAGONAL ELEMENTS OF A NEW
C      TRI-DIAGONAL MATRIX.
C
C
C      BY MEANS OF GAUSSIAN ELIMINATION THE NEW TRI-DIAGONAL MATRIX
C      IS TRANSFORMED INTO UPPER TRIANGULAR FORM. THE ROW MULTIPLIERS
C      ARE STORED IN ARRAY XM. IF ROW I IS INTERCHANGED WITH ROW I+1
C      LXCH(I)=1  THE MAIN DIAGONAL ELEMENTS OF THE UPPER TRIANGULAR
C      MATRIX ARE STORED IN THE ARRAY U, THE NEXT DIAGONAL IN THE
C      ARRAY V AND THE LAST DIAGONAL IN THE ARRAY W.
C
      PA=R(1)-EIGNO
      QA=P(1)
      N1=N-1
      DO 4 I=1,N1
C
C      DETERMINE IF A ROW INTERCHANGE IS NECESSARY.
C
      GA=DABS(P(I))
      PPA=DABS(PA)
      IF(GA.LE.EPSI) GO TO 20
      IF(GA.GT.PPA) GO TO 2
C
C      NO INTERCHANGE.
C
   20 U(I)=ONE/PA
      V(I)=QA*U(I)
      W(I)=ZERO
      HA=P(I)
      PA=R(I+1)-EIGNO
      QA=P(I+1)
      LXCH(I)=ZERO
      GO TO 3
C
C      INTERCHANGE.
C
    2 U(I)=ONE/P(I)
      V(I)=(R(I+1)-EIGNO)*U(I)
      W(I)=P(I+1)*U(I)
      HA=PA
      PA=QA
      QA=ZERO
      LXCH(I)=ONE
C
C      THE ROW MULTIPLIER IS DETERMINED.
C
    3 XM(I)=HA*U(I)
C
C      ROW I IS MULTIPLIED BY XM(I) AND SUBTRACTED FROM ROW I+1.
C
      PA=PA-HA*V(I)
      QA=QA-HA*W(I)
    4 CONTINUE
C
C      THE SINGLE ELEMENT IN THE LAST ROW IS PLACED IN U(N)
C
      U(N)=ONE/PA
C
C      THE ARRAY X IS RESERVED FOR THE CURRENT ESTIMATE OF THE
C      EIGENVECTOR. AN ESTIMATE OF THE EIGENVECTOR IS OBTAINED BY BACK
C      SUBSTITUTION.
C
      X(N)=U(N)
      X(N1)= U(N1)-V(N1)*X(N)
      IF(N.EQ.2) GO TO 7
      DO 6 I=2,N1
      X(N-I)= U(N-I) -V(N-I)*X(N-I+1)-W(N-I)*X(N-I+2)
    6 CONTINUE
C
C      THE EIGENVECTOR STORED IN X IS NORMALISED.
C
    7 CALL NORM(N,X)
C
C      TO SAVE COMPUTING TIME, A FURTHER ITERATION TO YIELD A BETTER
C      ESTIMATE OF THE VECTOR CAN BE SUPPRESSED BY SETTING ITER=.TRUE.
C
  8   ITER=.FALSE.
      IF(ITER) GO TO 13
C
C      A NEW COLUMN VECTOR RELATED TO X BY EXACTLY THE SAME ROW
C      INTERCHANGES AND MULTIPLICATIONS BY WHICH THE UPPER TRIANGULAR
C      MATRIX WAS OBTAINED FROM THE NEW TRI-DIAGONAL MATRIX, IS
C      CALCULATED AND STORED IN B.
C
      DO 9 I=1,N
      B(I)=X(I)
    9 CONTINUE
      DO 11 I=1,N1
      IF(LXCH(I).EQ.ZERO) GO TO 10
      AC=B(I)
      BC=B(I+1)
      B(I)=BC
      B(I+1)=AC
   10 B(I+1)=B(I+1)-XM(I)*B(I)
   11 CONTINUE
C
C      THE NEW VECTOR STORED IN B IS NORMALISED.
C
      CALL NORM(N,B)
C
C      A NEW ESTIMATE OF THE EIGENVECTOR IS OBTAINED BY BACK-
C      SUBSTITUTION.
C
      X(N)=B(N)*U(N)
      X(N1)= B(N1)*U(N1)-V(N1)*X(N)
      IF(N.EQ.2) GO TO 14
      DO 12 I=2,N1
      X(N-I)=B(N-I)*U(N-I)-V(N-I)*X(N-I+1)-W(N-I)*X(N-I+2)
 12   CONTINUE
C
C      THE NEW ESTIMATE OF THE EIGENVECTOR IS NORMALISED.
C
 14   CALL NORM(N,X)
   13 RETURN
      END
      SUBROUTINE NORM(N,X)
      IMPLICIT double precision (A-H,O-Z)
C
C      THIS SUBROUTINE NORMALISES THE VECTOR X OF DIMENSION N SUCH THAT
C      THE LARGEST COMPONENT IS UNITY.
C
      DIMENSION X(N)
      DATA ONE/1.D0/
C
      G=DABS(X(1))
      DO 1 I=2,N
      G = DMAX1(G,DABS(X(I)))
    1 CONTINUE
      G = ONE/G
      DO 2 I=1,N
      X(I)=X(I)*G
    2 CONTINUE
C
      RETURN
      END
      SUBROUTINE EIGVEC(N,A,LENGTH,X)
      IMPLICIT double precision (A-H,O-Z)
C
C      THIS SUBROUTINE TAKES THE EIGENVECTOR OF THE TRI-DIAGONAL
C      MATRIX STORED IN X AND DETAILS OF THE MATRICES USED IN
C      TRANSFORMING THE ORIGINAL MATRIX TO TRI-DIAGONAL FORM, STORED IN
C      A, AND OBTAINS THE CORRESPONDING EIGENVECTOR OF THE ORIGINAL
C      MATRIX. N AND LENGTH ARE AS DEFINED IN THE SUBROUTINE HSLDR.
C
      DIMENSION A(LENGTH),X(N),P(N)
      DATA ZERO/0.0D0  /
C
C
C      N-2 TRANSFORMATIONS TO OBTAIN EACH EIGENVECTOR.
C
      KP1 = 1
      NK1 = N-1
      K1 = LENGTH-2
      DO 3 K=3,N
C
C      K1 IS THE NUMBER OF ELEMENTS IN THE FIRST (K-1) ROWS OF THE
C      UPPER TRIANGLE STORED IN A.
C
      K1 = K1-K
      SOP=ZERO
      KP1 = KP1+1
      NK1 = NK1-1
      DO 1 I=1,KP1
      SOP=SOP+A(K1+I)*X(NK1+I)
    1 CONTINUE
      IF(SOP.EQ.ZERO) GO TO 3
C
      SOP = SOP/(P(NK1)*A(K1+1))
      DO 2 I=1,KP1
      X(NK1+I)=X(NK1+I)+A(K1+I)*SOP
    2 CONTINUE
    3 CONTINUE
C
C      THE EIGENVECTOR OF THE ORIGINAL MATRIX IS NORMALISED.
C
      CALL NORM(N,X)
      RETURN
      END
