! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE RESON_f(ifail)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     MAXIMUM DIMENSIONS ARE SET BY THE FOLLOWING PARAMETER STATEMENT
C     VARIABLE DIMENSIONS ARE USED IN ALL LOWER LEVEL ROUTINES, EXCEPT
C     VIBINI
C
      PARAMETER (MAXPTS=30,MAXPOL=20,MAXFCH=100,MAXTGT=20,MAXENR=10)
      PARAMETER (MAXFIT=100)
C
C     MAXPTS = MAXIMUM NUMBER OF GEOMETRIES
C     MAXPOL = MAXIMUM NUMBER OF NONADIABATIC R-MATRIX POLES
C     MAXTGT = MAXIMUM NUMBER OF TARGET ELECTRONIC STATES
C     MAXENR = MAXIMUM NUMBER OF INPUT SCATTERING ENERGY PAIRS (E0,DE)
C     MAXFCH = MAXIMUM NUMBER OF FIXED NUCLEI SCATTERING CHANNELS
C     MAXFIT = Maximum number of points to used in resonance fit
C              If you ever need to change MAXFIT, change also USER
C              in COMMON/fitpar/ to 2*MAXFIT.
C
      CHARACTER(LEN=11) RFORM,CHFORM,KFORM,NRFORM,VCFORM,MODDAT
      CHARACTER(LEN=9) FORM
      CHARACTER(LEN=3) EUNIT(2)
      CHARACTER(LEN=1) IRFORM,ICFORM,IKFORM,INRFRM,IVCFRM
      CHARACTER(LEN=20) DAYTIM
      CHARACTER(LEN=80) NAME
      character(LEN=5) label
      INTEGER STOT,GUTOT,resunit,checkr,nst
      LOGICAL GETETA
      DIMENSION RK(MAXPTS+4),R(MAXPTS),IPRNT(6),ezero(maxpts),
     1 EINC(2,MAXENR),NESCAT(MAXENR),NVTARG(MAXTGT),
     2 NCHSET(MAXPTS),NRMSET(MAXPTS)
      double precision, allocatable :: en(:),phz(:),akmat(:),ethr(:),
     * evchl(:),cf(:),efit(:),etafit(:),bkmat(:)
      integer, allocatable :: ivchl(:),lvchl(:),mvchl(:)
c
C***********************************************************************
C
C     BASIC DATA IS INPUT VIA NAMELIST /RES/
C     OTHER DATA IS INPUT VIA NAMELISTS IN ROUTINES VIBINI AND ASYM1
C
C     ABVTHR   = minimum energy above a threshold which can be used in
C                fitting resonances to a Breit-Wigner profile
C     BELTHR   = minimum energy below a threshold which can be used in
C                fitting resonances to a Breit-Wigner profile
C     BBLOCH   = coefficient in electronic Bloch operator
C     DPHZ     = Smallest change in eigenphase sum that constitutes a
C                resonance
C     GETETA   = T compute grid for fitting, = F fit at supplied points
C     GUTOT    = G/U symmetry of total system +1=G, -1=U
c     IBRANCH  = Flag to construct and diagonalise time delay matrix.
c                Outputs the channel breakdown to IWRITE. (see TSCALE)
C     ICFORM   = Formatted/unformatted switch for unit LUCHAN
C     IEUNIT   = 1 energies printed in Ryd, = 2 energies printed in eV
C     IKFORM   = Formatted/unformatted switch for unit LUKMT
C     INRFRM   = Formatted/unformatted switch for unit LUNRMT
C     IPRNT    = Debug print switches
C                (1) =1 Print all input data
C                (2) =1 Print vibrational wavefuction data
C                (3) =1 Debug output in dissociating channels
C                (4) =1 Print resonance fitting information
C                (5) =1 Print R-matrices
C                (6) =1 Print all output data
C     IRFORM   = Formatted/unformatted switch for unit LURMT
C     ISMAX    = Highest multipole to be used in asymptotic expansion
C                of asymptotic potentials
C     IVCFRM   = Formatted/unformatted switch for unit LUVCHN
C     IWRITE   = Logical unit for printed output
C     LUCHAN   = Logical unit holding fixed nuclei channel and target
C                data
C     LUKMT    = Logical unit for K-matrix input
C     LUNRMT   = Logical unit holding non adiabatic R-matrix data
C     LURES    = Logical unit for K-matrix data for resonance fits
C     LURMT    = Logical unit holding fixed nuclei R-matrix data
C     LUVCHN   = Logical unit holding vibrational/dissociating
C                channel data
C     MGVN     = Total symmetry of system
C     NAME     = Title for output
C     NBACK    = Number of terms in polynomial fit to background phase
C     NCHSET   = Set numbers for input fixed nuclei channel/target
C                data for each geometry
C     NDIS     = Number of dissociating channels
C     NFIT     = Minimum number of energy points to be used in resonance
C                fit
C     NGEOM    = Number of geometries
C     NKSET    = Set number of input K-matrix
C     NNRSET   = Set number for input non-adiabatic R-matrix data
C     NPOLE    = Number of electronic R-matrix poles to be treated
C                non-adiabatically
C     NRESON   = Number of resonances to be located
C     NRMSET   = Set numbers for input fixed nuclei R-matrix data for
C                each geometry
C     NRQUAD   = Number of quadrature points for integrals in adiabatic
C                approximation ( if =0 then code decides)
C     NVCSET   = Set number for input vibrational/dissociating channel
C                data
C     NVTARG   = Number of vibrational levels for each target state
C     R        = Array holding internuclear separations
C     STOT     = Spin multiplicity 2*S+1 where S = total spin of system
C     TOL      = Tolerance parameter used in subroutine LMDIF1. Relative
C                error in the sum of squares in subroutine must be at 
C                most tol.
c     TSCALE   = (if IBRANCH != 0) Time delay matrix to be diagonalised.
c                Constructed using energy points separated by
c                gamma/TSCALE.
!     resunit  = "reson_message" (fort.410) - a unit holding resonance
!                data for the user /quantemol/
!     checkr = 0 - no real resonances
!            = 1 - some real resonances
!     nst      = label of scattering state symmetry

      NAMELIST/RES/ LUCHAN,LURMT,LUVCHN,LUNRMT,LURES,LUKMT,NPOLE,NDIS,
     1              BBLOCH,NGEOM,R,IWRITE,ISMAX,NAME,
     2              IPRNT,NCHSET,NRMSET,NVCSET,NNRSET,NKSET,NRQUAD,
     3              ICFORM,IRFORM,IVCFRM,INRFRM,IKFORM,IEUNIT,
     4              MGVN,STOT,GUTOT,NVTARG,TSCALE,IBRANCH,TOL,
     5      NRESON,NFIT,NBACK,ABVTHR,BELTHR,DPHZ,GETETA,nst,label
C
C***********************************************************************
C
      DATA IWRITE,LUCHAN,LURMT,LURES,LUKMT/6,10,21,18,19/,
     1 LUVCHN,LUNRMT/28,29/,IPRNT/6*0/,NERANG/1/,DEGENY/1.D-5/,
     2 NPOLE/0/,NVIB/0/,NDIS/0/,DPHZ/1.D0/,GETETA/.TRUE./,TSCALE/50.D0/,
     3 IBRANCH/0/,NVCSET,NNRSET,NKSET/3*1/,NGEOM/1/,ONE/1.D0/,TWO/2.D0/,
     4 ISMAX/2/,BBLOCH/0.D0/,NVTARG/MAXTGT*1/,NRQUAD/0/,
     5 ABVTHR/0.0d0/,BELTHR/0.0d0/,NRESON/20/,NFIT/20/,IEUNIT/1/,
     6 TOL/1.0D-05/
      DATA FORM,CHFORM,RFORM,VCFORM,NRFORM,KFORM/6*'FORMATTED'/,
     1 ICFORM,IRFORM,IVCFRM,INRFRM,IKFORM/5*'U'/,
     2 EUNIT/'Ryd','eV '/,TOEV/13.605D0/,ZERO/0.0D0/
      DATA MODDAT/'12-May-1997'/,resunit/410/,checkr/0/,nst/1/
C
C---- SET UP DEFAULT VALUES OF POINTERS NCHSET AND NRMSET
      DO 111 I=1,MAXPTS
      NCHSET(I) = I
      NRMSET(I) = I
 111  continue
C
      NBACK = 2
      IFAIL = 0
      R = 0
C
C---- Read basic data via namelist /RES/
      READ(5,RES)
C
      IF(NPOLE.GT.MAXPOL.OR.NGEOM.GT.MAXPTS) THEN
        WRITE(IWRITE,98) NPOLE,NTARG,NGEOM,MAXPOL,MAXTGT,MAXPTS
 98     FORMAT(/' INPUT DATA WILL EXCEED FIXED DIMENSIONS'/' INPUT  ',
     1      3I5/' MAXIMA ',3I5)
        IFAIL=1
        RETURN
      ENDIF
      NFIT=MIN(NFIT,MAXFIT)
      IF(ICFORM.EQ.'U') CHFORM='UN'//FORM
      IF(IRFORM.EQ.'U') RFORM='UN'//FORM
      IF(INRFRM.EQ.'U') NRFORM='UN'//FORM
      IF(IKFORM.EQ.'U') KFORM='UN'//FORM
      IF(IVCFRM.EQ.'U') VCFORM='UN'//FORM
C
C---- Date stamp run and print title
      CALL DATEST(DAYTIM)
      NAME(61:) = DAYTIM
      WRITE(IWRITE,12)MODDAT,NAME
 12   FORMAT(//' Program RESON  (last modified ',A,' )'//A)
      IF (IEUNIT .EQ. 1) TOEV=ONE
      IF (ABVTHR .LT. DEGENY) ABVTHR=TWO*DEGENY*TOEV
      IF (BELTHR .LT. DEGENY) BELTHR=TWO*DEGENY*TOEV
      WRITE(IWRITE,890) NRESON,ABVTHR,EUNIT(IEUNIT),
     1                  BELTHR,EUNIT(IEUNIT),NFIT,NBACK,DPHZ
 890  FORMAT(/' Automatic resonance detection and fitting requested:'
     1       /' For    NRESON =',I5,5X,' lowest resonances'
     2       /' From   ABVTHR =',F10.5,1X,A3,' above each threshold'
     3       /' Up to  BELTHR =',F10.5,1X,A3,' below each threshold'
     4       /' Using  NFIT   =',I5,5X,' energy grid points'
     5       /' And    NBACK  =',I5,5X,' terms for the background',
     6       /' Change DPHZ   =',F10.5,' constitutes a resonance.')
c
      IF(GETETA) WRITE(IWRITE,900)
 900  FORMAT(' Resonances fitted at internally computed energy points.')
      IF(.NOT. GETETA) WRITE(IWRITE,910)
 910  FORMAT(' Resonances fitted at supplied energy points.')
      if (IBRANCH .ne. 0) write(iwrite,920) TSCALE
 920  format(' Time delay matrix to be constructed and'
     1 /' diagonalised using energy difference of resonance width'
     2 /' divided by TSCALE = ',D13.5)
      IF(NGEOM.EQ.1) THEN
        WRITE(IWRITE,20) R(1)
 20   FORMAT(/' Fixed nuclei calculation for R =',F6.3)
        RR=R(1)
        write(84,240) rr,rr
 240  FORMAT(/F6.3,' Fixed nuclei calculation for R =',F6.3)
      ELSE
        WRITE(IWRITE,10)NDIS,(R(I),I=1,NGEOM)
 10   FORMAT(/' Vibrationally resolved calculation '//' Number of dissoc
     2iating channels',I3//' Input geometries R =',10F10.5,(/21X,10F10.5
     2))
       RR=ZERO
      ENDIF
      WRITE(IWRITE,11)CHFORM,LUCHAN,(NCHSET(IG),IG=1,NGEOM)
 11   FORMAT(/' Input datasets:',33X,'Unit  Set numbers'/
     1' Target and channel data     LUCHAN (',A11,')',I3,5X,30I3/(35X,30
     2I3))
      WRITE(IWRITE,33)RFORM,LURMT,(NRMSET(IG),IG=1,NGEOM)
 33   FORMAT(' Fixed nuclei R-matrix data  LURMT  (',A11,')',I3,5X,30I3/
     1(35X,30I3))
      WRITE(IWRITE,31)KFORM,LUKMT,NKSET
 31   FORMAT(' K-matrices',18X,'LUKMT  (',A11,')',I3,5X,I3)
      IF(NGEOM.GT.1) WRITE(IWRITE,21)VCFORM,LUVCHN,
     1 NVCSET,NRFORM,LUNRMT,NNRSET
 21   FORMAT(/' Vibrational channel data    LUVCHN (',A11,')',I3,5X,I3
     1/' Non-adiabatic R-matrix data LUNRMT (',A11,')',I3,5X,I3)
      WRITE(IWRITE,30) LURES
 30   FORMAT(/' Scratch dataset:',32X,'Unit'/
     1' K-matrix/eigenphase data    LURES  (UNFORMATTED)',I3)
C
C---- Find K-matrices and read dimension information
      CALL READKH(LUKMT,NKSET,MGVN,STOT,GUTOT,NCHAN,NVIB,NDIS,NTARG,
     1     ION,NERANG,NESCAT,EINC,RR,NAPPR,KFORM,IWRITE,IPRNT(1),IFAIL)
C
C---- Calculate max and min scattering energies EMIN and EMAX
      EMIN = EINC(1,1)
      EMAX = EMIN
      NESC = 0
      DO 9 IEN=1,NERANG
      NESC = NESC+NESCAT(IEN)
      EMIN = MIN(EMIN,EINC(1,IEN))
      EMAX = MAX(EMAX,EINC(1,IEN)+NESCAT(IEN)*EINC(2,IEN))
 9    CONTINUE
      WRITE(IWRITE,13) NESC,EMIN*TOEV,EMAX*TOEV,EUNIT(IEUNIT)
 13   FORMAT(/' K-matrices will be scanned for',I5,' energies in the ',
     1 'range [',F8.4,',',F8.4,'] ',A3)
C
C---- Read K-matrices and diagonalise to give table of eigenphases
      allocate (en(nesc),akmat(nchan*nchan),bkmat(nchan*nchan),
     * ethr(MAX(NTARG,NVIB)),ivchl(nchan),lvchl(nchan),mvchl(nchan),
     * evchl(nchan),cf(ISMAX*nchan*(nchan+1)/2),
     * phz(nesc),efit(MAXFIT),etafit(MAXFIT))
C
      CALL KEIGPS(NESC,LUKMT,NCHAN,EMIN,EMAX,EN,PHZ,KFORM)
C
C     INITIALISE ASYMPTOTIC SOLUTION STEP
C
      CALL RSOLVR(LUCHAN,LURMT,LUVCHN,LUNRMT,LURES,NPOLE,
     1            BBLOCH,NGEOM,R,ezero,IWRITE,ISMAX,
     2            IPRNT,NCHSET,NRMSET,NVCSET,NNRSET,NRQUAD,
     3            CHFORM,RFORM,VCFORM,NRFORM,NAME,EMIN,EMAX,
     4            MGVN,STOT,GUTOT,NVTARG,RK,ivchl,lvchl,mvchl,evchl,cf,
     5            ETHR,NTHR,NFIT,EINC,NESCAT,MAXENR,MAXPTS,NCHAN,
     6            NOPEN,EFIT,AKMAT,bkmat,ETAFIT,IFAIL,E,DE,0,GETETA)
      IF (IFAIL .NE. 0) RETURN
C
! open reson_data to write resonance parameters for the user
      if (nst.eq.1) then
       open(unit=resunit, file='reson_message', status='unknown')
      else
       open(unit=resunit, file='reson_message', position='append',
     *  status='old')
      endif
      write(resunit,*) nst,'    Scattering state symmetry is ',label

C     Perform resonance scan and fits
C
      CALL RESONC(NCHAN,NESC,NRESON,ABVTHR,BELTHR,NFIT,DPHZ,
     1            ETHR,NTHR,EN,PHZ,ION,
     2            LUCHAN,LURMT,LUVCHN,LUNRMT,LURES,NPOLE,
     3            BBLOCH,NGEOM,R,ezero,IWRITE,ISMAX,
     4            IPRNT,NCHSET,NRMSET,NVCSET,NNRSET,NRQUAD,
     5            CHFORM,RFORM,VCFORM,NRFORM,NAME,EMIN,EMAX,
     6            EUNIT(IEUNIT),TOEV,ivchl,lvchl,mvchl,evchl,cf,
     7            MGVN,STOT,GUTOT,NVTARG,RK,EINC,IBRANCH,TSCALE,
     8            GETETA,AKMAT,bkmat,NESCAT,MAXENR,MAXPTS,MAXFIT,
     *   efit,etafit,NBACK,NRFres,NFRES2,TOL,resunit,checkr,IFAIL)
      IF (IFAIL .NE. 0) RETURN
!
!      if (checkr.eq.0) then
!        write(resunit,651) nst
!      else
        write(resunit,654) 
!      endif
 651  format('*** I COULD NOT FIND REAL RESONANCES FOR SCATTERING ',
     * 'STATE SYMMETRY ',(i2),/,
     *  '*** Check eigenphases graphs and outer*.out to be sure.')
 654  format(/,'*** CHECK EIGENPHASES GRAPHS TO SEE IF RESONANCES',
     *' ARE REAL OR IF I MISSED ANY ***',/,/)
      close(resunit)
C
      IF(IFAIL.EQ.0) WRITE(IWRITE,18)
 18   FORMAT(/' *** Task successfully completed ***')
      deallocate (en,phz,akmat,bkmat,ethr,ivchl,lvchl,mvchl,evchl,cf,
     *            efit,etafit)

      RETURN
C
      END
!*******************************************************************
      SUBROUTINE RSOLVR(LUCHAN,LURMT,LUVCHN,LUNRMT,LURES,
     1             NPOLE,BBLOCH,NGEOM,R,ezero,IWRITE,ISMAX,IPRNT,NCHSET,
     *             NRMSET,NVCSET,NNRSET,NRQUAD,
     3             CHFORM,RFORM,VCFORM,NRFORM,TITLE,EMINR,EMAXR,
     4             MGVN,STOT,GUTOT,NVTARG,RK,ivchl,lvchl,mvchl,evchl,cf,
     5             ETHR,NTHR,NFIT,EINC,NESCAT,MAXENR,MAXPTS,NCHAN,
     6           NOPEN,EFIT,akmat,BKMAT,ETAFIT,IFAIL,E,DE,IFIRST,GETETA)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
      CHARACTER(LEN=80) TITLE
      CHARACTER(LEN=11) RFORM,CHFORM,NRFORM,VCFORM
      integer, allocatable :: ichord(:),ivtarg(:),ivnu(:),starg(:),
     * gtarg(:),mtarg(:),ncsf(:)
      double precision, allocatable :: rvib(:),rmn(:),amc(:),
     * rres(:),ampn(:),eign(:),evib(:),etarg(:),fx(:),fxp(:),
     * vibfn(:),rquad(:),qwts(:),epole(:),wamp(:),butc(:),
     * fv(:),fvp(:),crv(:),bloch(:),sfac(:),ecex(:),rcex(:)
      double precision :: dummy(1), dummy2(1,1)
      INTEGER STOT,GUTOT
      LOGICAL GETETA
      save
      DIMENSION RK(*),R(*),ezero(*),IPRNT(6),ETHR(*),ivchl(nchan),
     *          lvchl(nchan),mvchl(nchan),evchl(nchan),akmat(*),
     1          EFIT(*),BKMAT(*),ETAFIT(*),EINC(2,MAXENR),fd(2),fdp(2),
     2          NVTARG(*),NCHSET(*),NRMSET(*),NESCAT(MAXENR),cf(*),
     *          crd(2),ivt0(2),ivu0(2),vec(1)
      EXTERNAL POTL,DISPOT
      DATA NKNOT/0/,NCOL/6/,IVPROP/1/,IDPROP/1/,iback/1/
      DATA ZERO/0.D0/,HALF/0.5D0/,ONE/1.D0/,TWO/2.D0/,TINY/1.D-6/
      DATA dummy/0.0D0/
C
c      IF (IFIRST .GT. 0) GOTO 500
C
C     Initialisation entry (IFIRST=0) read necessary data and do
C     setup calls
C---- Find first fixed-nuclei R-matrix input set and read dimension
C     information
      if(ifirst.eq.0) WRITE(IWRITE,17)
 17   FORMAT(/' *** FIXED NUCLEI DATA ***')
      CALL READRH(LURMT,NRMSET(1),RFORM,MGVN,STOT,GUTOT,NCHANF,NVIB0,
     1 NDIS0,NTARG,ION,R(1),RMASS,RMATR,NFBUT,ISMX,nstat,NOCSF,NPLX,
     2 ezero(1),iex,IWRITE,IPRNT(1)-1,IFAIL)
      IF(IFAIL.NE.0) RETURN
      TWOM = TWO*RMASS
C
C---- Read header on non-adiabatic R-matrix file
      IF(NGEOM.GT.1) THEN
        WRITE(IWRITE,19)
 19     FORMAT(/' *** NON-ADIABATIC DATA ***')
        CALL READRH(LUNRMT,NNRSET,NRFORM,MGVN,STOT,GUTOT,NCHANS,NVIB,
     1  NDISS,NTARGv,ION,ZERO,RMASS,RMATN,NNBUT,ISMVX,nstat,NHD,
     2  NPVEC,ezero(1),iex,IWRITE,IPRNT(1)-1,IFAIL)
        IF(IFAIL.NE.0) RETURN
        NCHAN = NCHANS
        RR = ZERO
      ELSE
        NVIB = 0
        NDIS = 0
        NCHAN = NCHANF
        ntargv = ntarg
        RR = R(1)
        ISMVX = ISMX
      ENDIF
      IF(ISMAX.EQ.-1.OR.ISMAX.GT.ISMX) THEN
        ISFMAX = ISMX
      ELSE
        ISFMAX = ISMAX
      ENDIF
      if(ifirst.eq.0) WRITE(IWRITE,34) ISFMAX
34    FORMAT(/' Maximum multipole USED in asymptotic scattering',
     1        ' potentials   ISMAX =',I3)
      ISMAX = ISFMAX
C
C---- Assign storage for fixed nuclei data
      ntv = max(ntarg,NTARGv)
      if(.not.allocated(starg)) allocate (etarg(ngeom*ntv),starg(ntv),
     * mtarg(ntv),gtarg(ntv))
      if(.not.allocated(wamp)) allocate (epole(nstat*ngeom),
     * wamp(nstat*NCHANF*NGEOM),butc(3*NCHANF*NGEOM),
     * amc(ISMAX*NCHAN*NCHAN),ncsf(ngeom))
      if (abs(nfbut).gt.1.and..not.allocated(sfac)) allocate(
     * sfac(nchanf*ngeom),ecex(iex*ngeom),rcex(iex*nchanf*ngeom))
C
C---- Loop over geometries
      if(ifirst.eq.0) WRITE(IWRITE,17)
      DO 2 IG=1,NGEOM
C
C---- Storage allocation for current geometry
      IG1 = IG-1
      IET = 1+IG1*NTARG
      IEG = 1+IG1*nstat
      IWA = 1+IG1*nstat*NCHANF
      IVE = 1+IG1*NOCSF*NPLX
      IBUT =1+IG1*3*NCHANF
      isf  =1+IG1*nchanf
      iec  =1+IG1*iex
      irc  =1+IG1*iex*nchanf
C
C---- Read target and channel data
      NCHAN0 = NCHANF
      NTARG0 = NTARG
      CALL READTC(LUCHAN,NCHSET(IG),NCHAN0,NVIB0,NDIS0,NTARG0,ION,IVT0,
     1 IVU0,IVCHL,LVCHL,MVCHL,EVCHL,STARG,MTARG,
     2 GTARG,etarg(IET:),R(IG),RMASS,CHFORM,IWRITE,IPRNT(1)-1,IFAIL)
      IF(NCHAN0.NE.NCHANF.OR.NTARG0.NE.NTARG) GO TO 92
C
C---- Read R-matrix header for second and subsequent geometries
      CALL READRH(LURMT,NRMSET(IG),RFORM,MGVN,STOT,GUTOT,
     1 NCHAN0,NVIB0,NDIS0,NTARG0,ION,R(IG),RMASS,RMATR,NFBUT,ISMX,
     2 NCSF(ig),nci,NPLX,ezero(ig),iex,IWRITE,IPRNT(1)-1,IFAIL)
c
      IF(NCHAN0.NE.NCHANF.OR.NTARG0.NE.NTARG) GO TO 92
C
C---- Read remainder of fixed nuclei R-matrix data
      if (abs(nfbut).gt.1) then
         CALL READRM(LURMT,RFORM,NCHANF,NCSF(ig),nci,ISMX,ISFMAX,NPLX,0,
     1    NFBUT,cf,epole(IEG:),wamp(IWA:),vec,butc(IBUT:),sfac(isf:),
     2    iex,ecex(iec:),rcex(irc:),IFAIL)
      else
         CALL READRM(LURMT,RFORM,NCHANF,NCSF(ig),nci,ISMX,ISFMAX,NPLX,0,
     1    NFBUT,cf,epole(IEG:),wamp(IWA:),vec,butc(IBUT:),dummy,
     2    iex,dummy,dummy,IFAIL)
      endif
      IF(IFAIL.NE.0) RETURN
C
 2    CONTINUE
C
      IF(NGEOM.EQ.1) THEN
C
C---- Set up fixed nuclei calculation
        E0 = etarg(1)
        NTHR=NTARG
        DO 222 N=1,NTHR
        ETHR(N) = (ETARG(N)-E0)*TWO
 222    continue
        NVCHAN = NCHAN
C
      ELSE
        WRITE(IWRITE,22)
 22     FORMAT(/' *** END OF FIXED NUCLEI DATA *** ')
        NVCHAN = NCHAN
C
C---- Read vibrational channel data
        NVIBD = NVIB+NDIS
        allocate (evib(ntargv),ivtarg(nvibd),ivnu(nvibd))
        CALL READTC(LUVCHN,NVCSET,NCHAN,NVIB,NDIS,NTARGv,ION,IVTARG,
     1  IVNU,IVCHL,LVCHL,MVCHL,EVCHL,STARG,
     2  MTARG,GTARG,evib,ZERO,RMASS,VCFORM,IWRITE,IPRNT(2)-1,IFAIL)
        e0 = evib(1)
c
        deallocate(evib,ivtarg,ivnu)
C
C---- Initialize acquisition of vibrational functions
        EBASE = zero
        CALL VIBINI(5,IWRITE,NTARG,NVTARG,RMASS,ebase,IPRNT(2))
        WRITE(IWRITE,47) EBASE
 47   FORMAT(/' Base energy used in nuclear motion code  EBASE =',F11.5,
     1' au')
C
        EOLD=ZERO
        ETHR(1)=ZERO
        NTHR=1
        DO 223 N=2,NCHAN
        IF (evchl(N) .GT. EOLD+TINY) THEN
          NTHR=NTHR+1
          EOLD=evchl(N)
          ETHR(NTHR)=EOLD
        ENDIF
 223    CONTINUE
C
C---- Set up quadrature scheme for integrals in adiabatic nuclei approx
        IF(NRQUAD.EQ.0) THEN
C     THIS IS A BIT ARBITRARY AND NOT THOROUGHLY TESTED
          NQUAD = 15*NVIB+1
          IF(MOD(NQUAD,2).EQ.0) NQUAD=NQUAD+1
        ELSE
          NQUAD = NRQUAD
        ENDIF
        allocate (rquad(nquad),qwts(nquad))
C
        CALL VMESH(R(1),R(NGEOM),NQUAD,RQUAD,QWTS)
C
C---- Initialize spline interpolation
        CALL SPLINI(NKNOT,KNOTS,RK,MAXPTS,NGEOM,R,IWRITE)
C
C----- GET TARGET VIBRATIONAL WAVEFUNCTIONS ON QUADRATURE MESH
        allocate (evib(nvibd),ivtarg(nvibd),
     *  ivnu(nvibd),ichord(nvchan),vibfn(NVIB*NQUAD))
C
       CALL RVIBR(NVIB,NQUAD,EVIB,IVTarg,IVnU,VIBFN,dum,RQUAD)
C
c---- Set up pointer from VIBINI ordering to channel ordering
        if(ntarg.gt.1) call REORDI(nvchan,evchl,nvib,evib,ichord)
c
        IF(IPRNT(2).GT.0) CALL CHECKQ(NQUAD,NVIB,QWTS,VIBFN,IWRITE)
C
C---- Storage allocation for non-adiabatic data
        allocate (ampn(nstat*NCHANS),eign(nstat))
C
C---- Read rest of non-adiabatic R-matrix file
        CALL READRM(LUNRMT,NRFORM,NCHANS,nstat,NHD,ISMVX,ISMAX,0,0,0,
     1  cf,EIGn,AMPn,dummy,dummy2,dummy,0,dummy,dummy,IFAIL)
C
      ENDIF
c
      IF (.NOT. GETETA) RETURN
C
C---- Save multipole coefficients as square matrix
      IF(ISMAX.GT.0) CALL SQUARM(NVCHAN,ISMAX,cf,AMC)
C
C----- Initialise asymptotic routines for vibrational channels
      IF(NVCHAN.GT.0.and.ifirst.eq.0) THEN
        RAFINV = RMATR
        SCALE = ONE
        CALL ASYM1(NVCHAN,LVCHL,ION,ISMAX,AMC,RMATR,RAFINV,
     1  SCALE,BBLOCH,EVCHL,EMINR,EMAXR,IVPROP,POTL,IWRITE)
      ENDIF
C
      IDPROP = 0
C
C---- Store Bloch coefficients
      if(.not.allocated(bloch)) allocate (bloch(nvchan+ndis))
      DO 4 I=1,NVCHAN
      BLOCH(I) = BBLOCH
 4    continue
C
      NRSET=1
      NERANG=1
c
      if(ifirst.eq.0) RETURN
C
C     Energy dependent part of the calculation (IFIRST=1)
C
C----- INITIALIZE OUTPUT OF K-MATRICES
  500 ENRYD=E
C
C---- Storage allocation for energy loop
      NCHSQ= NCHAN*NCHAN
      NVCHSQ = NVCHAN*NVCHAN
      if(.not.allocated(rvib)) allocate (rvib(nchsq),fv(2*nvchsq),
     * fvp(2*nvchsq),fx(2*nchsq),fxp(2*nchsq),
     * rres(NGEOM*NCHANF*(NCHANF+1)/2),crv(2*NVCHSQ+NVCHAN))
      if(npole.gt.0.and. .not.allocated(rmn)) 
     *                allocate (rmn(NCHAN*(NCHAN+1)/2))
c
      if (nfit.ne.2) then
        EINC(1,1)=ENRYD
        EINC(2,1)=DE
        NESC=NFIT
        NERANG=1
        NESCAT(1)=NFIT
        CALL WRITKH(LURES,NRSET,'UNFORMATTED',TITLE,MGVN,STOT,
     1  GUTOT,ION,RR,RMASS,NCHAN,NVIB,NDIS,NTARG,NERANG,NESCAT,EINC,
     2  NESC,IPRNT(6),IWRITE,IFAIL)
      endif
C
      EMIN=ENRYD
      IEN = 0
      NOPOLE = 0
C
      DO 40 IE=1,NFIT
      ETOT  = E0+HALF*ENRYD
      IF(IPRNT(5).GT.0.OR.IPRNT(6).GT.0) WRITE(IWRITE,28) ENRYD
 28   FORMAT(/100('-')//' Incident energy',F10.5,' Ryd')
      IEN = IEN+1
C
      NVOPEN = 0
      NDOPEN = 0
C
C---- Calculate contribution to R-matrix from non-adiabatic poles
      IF(NPOLE.GT.0) THEN
        CALL VRMAT2(NCHAN,NHD,RMN,ETOT,AMPn,EIGn,NOPOLE)
C
        IF(IPRNT(5).NE.0) THEN
          WRITE(IWRITE,24) NPOLE
 24       FORMAT(/' Contribution to electronic R-matrix from first',I3,
     1            ' poles')
          CALL MATTPT(NCHAN,RMN,IWRITE)
        ENDIF
      ENDIF
C
C----- Calculate contributions to fixed nuclei R-matrices from higher
C      poles
      if (abs(nfbut).gt.1) then
         CALL RESIDR(ETOT,NCHANF,NTARG,ETARG,NLPOLE,NPOLE,nstat,NGEOM,
     1        ncsf,ivchl,WAMP,EPOLE,NFBUT,BUTC,RRES,ezero,sfac,
     2        iex,ecex,rcex,IFAIL)
      else
         CALL RESIDR(ETOT,NCHANF,NTARG,ETARG,NLPOLE,NPOLE,nstat,NGEOM,
     1        ncsf,ivchl,WAMP,EPOLE,NFBUT,BUTC,RRES,ezero,dummy,
     2        iex,dummy,dummy,IFAIL)
      endif
C
C----- CALCULATE RESIDUAL R-MATRIX IN THE ADIABATIC NUCLEI APPROX. AND
C      ADD IT TO THE VIBRATIONAL R-MATRIX OBTAINED IN VRMAT2.  A SQUARE
C      MATRIX IS OUTPUT FOR INPUT TO ASYMPTOTIC CODE.
C
      IF(NGEOM.GT.1) THEN
        CALL ADNUC(NGEOM,R,NCHANF,IVCHL,NTARG,NVTARG,VIBFN,KNOTS,
     1  RK,NVCHAN,RRES,RVIB,dum,1,NQUAD,RQUAD,QWTS)
c
c---- Reorder elements to match channel labels
        if(ntarg.gt.1) call REORDV(nvchan,ichord,rvib)
C
C     Add adiabatic component of R-matrix to the non-adiabatic
        K = 0
        IJ = 0
        DO 71 I=1,NVCHAN
        DO 7 J=1,I
        K = K+1
        IJ = IJ+1
        rmn(K) = rmn(K)+rvib(IJ)
 7      continue
 71     continue
        CALL SQUARM(NCHAN,1,RMN,RVIB)
      ELSE
        CALL SQUARM(NCHAN,1,RRES,RVIB)
      ENDIF
C
      IF(IPRNT(5).GT.0) THEN
        WRITE(IWRITE,14)
 14     FORMAT(/' SUPER R-MATRIX')
        CALL WRECMT(RVIB,NCHAN,NCHAN,NCHAN,NCHAN,NCOL,IWRITE)
      ENDIF
C
C----- GET SOLUTIONS, DERIVATIVES AND GLOBAL R-MATRIX IN VIBRATIONAL
C      CHANNELS AT R=RAFINV
      IF(NVCHAN.GT.0) THEN
        CALL ASYM2(NVCHAN,NVOPEN,LVCHL,ION,ISMAX,AMC,CRV,
     1  RAFINV,EVCHL,ENRYD,FV,FVP,IVPROP,ifail)
        if(ifail.gt.1) go to 40
        ifail = 0
      ENDIF
C
      NOPEN = NVOPEN
      if(nopen.eq.0) go to 40
      CALL MERGE(NCHAN,NVCHAN,NDIS,NVOPEN,NDOPEN,FX,FXP,FV,FVP,FD,FDP)
C
C----- PROPAGATE R-MATRICES IF REQUIRED
c      if(RMATR.gt.RAFINV) IBACK=-1
      IF(IVPROP.NE.0)
     1  CALL RPROPX(NCHAN,NVCHAN,NDIS,CRV,CRD,RVIB,IPRNT(5),IWRITE,
     2  IBACK)
C
C----- Compute K-matrix     
      if (nfit.ne.2.or.ie.eq.1) then       
        CALL KMAT(NCHAN,BLOCH,NOPEN,Fx,FxP,RVIB,AKMAT)
      else
        CALL KMAT(NCHAN,BLOCH,NOPEN,Fx,FxP,RVIB,BKMAT)
      endif
      if(nfit.ne.2) CALL WRITKM(NOPEN,NDOPEN,ENRYD,AKMAT)
c
      ENRYD = ENRYD+DE
 40   CONTINUE
      EMAX=ENRYD-DE
      if (nfit.eq.2) return
C
C     End of energy loop: find eigenphase sum
C
      CALL READKH(LURES,NRSET,MGVN,STOT,GUTOT,NCHAN,NVIB,NDIS,NTARG,ION,
     1            NERANG,NESCAT,EINC,RR,NAPPR,'UNFORMATTED',IWRITE,
     2            IPRNT(6)-1,IFAIL)
C
      CALL KEIGPS(NESC,LURES,NCHAN,EMIN,EMAX,EFIT,ETAFIT,'UNFORMATTED')
C
      NRSET=0
c
      deallocate (rvib,fv,fvp,rres,crv,fx,fxp)
      deallocate (etarg,starg,mtarg,gtarg,bloch)
      deallocate (epole,wamp,butc,amc,ncsf)
      if (abs(nfbut).gt.1) deallocate(sfac,ecex,rcex)
      CLOSE(UNIT=LUCHAN)
      CLOSE(UNIT=LURMT)
      IF(NGEOM.GT.1) THEN
        deallocate (ichord,rquad,qwts,evib,ivtarg,ivnu,vibfn,rmn,ampn,
     *              eign)     
        CLOSE(UNIT=LUVCHN)
        CLOSE(UNIT=LUNRMT)
      ENDIF
      RETURN
C
 92   WRITE(IWRITE,93) NCHAN0,NCHAN,NTARG0,NTARG
 93   FORMAT(' Inconsistent data on input files'/' NCHAN0 =',I5,5X,'NCHA
     1N =',I5,5X,'NTARG0 =',I5,5X,'NTARG =',I5)
      GO TO 90
 94   WRITE(IWRITE,95)IVPROP,IDPROP
 95   FORMAT(/' Inconsistent propogation flags',2I5)
 90   IFAIL = 1
      RETURN
      END
      SUBROUTINE KEIGPS(NES,LUKMT,NCHAN,EMIN,EMAX,ENRYD,TOTPHZ,KFORM)
C     Form eigenphase sum from eigenphases provided by KEIGP
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION ENRYD(*),TOTPHZ(*),PHZ(NCHAN,nes)
      CHARACTER(LEN=11) KFORM
      DATA ZERO/0.0D0/
c
      CALL KEIGP(NES,LUKMT,NCHAN,EMIN,EMAX,ENRYD,PHZ,KFORM,0,6)
C
      DO 10 I=1,NES
      TOTPHZ(I)=ZERO
 10   continue
      DO 21 J=1,NCHAN
      DO 20 I=1,NES
      TOTPHZ(I)=TOTPHZ(I)+PHZ(J,I)
 20   continue
 21   continue
      RETURN
      END
!******************************************************************
      SUBROUTINE RESONC(NCHAN,NUME,NRESON,ABVTHR,BELTHR,NFIT,DPHZ,
     1            ETHR,NTHR,EN,PHZ,ION,
     2            LUCHAN,LURMT,LUVCHN,LUNRMT,LURES,NPOLE,
     3            BBLOCH,NGEOM,R,ezero,IWRITE,ISMAX,
     4            IPRNT,NCHSET,NRMSET,NVCSET,NNRSET,NRQUAD,
     5            CHFORM,RFORM,VCFORM,NRFORM,TITLE,EMIN,EMAX,
     *            EUNIT,TOEV,ivchl,lvchl,mvchl,evchl,cf,
     *            MGVN,STOT,GUTOT,NVTARG,RK,EINC,IBRANCH,TSCALE,
     7            GETETA,AKMAT,bkmat,NESCAT,MAXENR,MAXPTS,MAXFIT,
     *    efit,etafit,NBACK,NRFIT,NFRES2,TOL,resunit,checkr,IFAIL)
C
C     SUBROUTINE RESONC searches the eigenphase list provided & locates
C     the lowest NRESON+1 resonances from ABVTHR above each threshold
C     energy until BELTHR below the next threshold.
C     The lowest NRESON resonances are fitted using a Breit-Wigner form
C     with a grid of dimension NFIT (optionally generated automatically)
C     NBACK terms are used to represent the background
C     
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      CHARACTER(LEN=80) TITLE
      CHARACTER(LEN=3) EUNIT
      CHARACTER(LEN=11) RFORM,CHFORM,NRFORM,VCFORM
      INTEGER STOT,GUTOT,resunit,checkr
      LOGICAL GETETA
      DIMENSION RK(*),R(*),ezero(*),IPRNT(6),AKMAT(*),bkmat(*),
     1          NVTARG(*),NCHSET(*),NRMSET(*),NESCAT(MAXENR),ETHR(*),
     2          PHZ(NUME),EN(NUME),ERES(NRESON+1),GAMMA(NRESON+1),
     3          ivchl(*),lvchl(*),mvchl(*),evchl(*),cf(*),efit(*),
     4          etafit(*),EINC(2,MAXENR)
      DATA PI/3.14159265358979324D0/,ZERO,HALF,ONE/0.D0,0.5D0,1.D0/,
     1 VBIGNO/1.D+30/
c
      IPRES=IPRNT(4)
C
C     Smooth the initial eigenphase sums
C
      ETAOLD = PHZ(1)
      QUAD = ZERO
      DO 1 IE=2,NUME
      ETA1 = PHZ(IE)+QUAD
      IF (ETA1.LE.ETAOLD.AND.ABS(ETA1-ETAOLD).GE.HALF) THEN
        QUAD = QUAD+PI
        ETA1 = ETA1+PI
      ENDIF
      PHZ(IE) = ETA1
      ETAOLD = ETA1
 1    continue
C
! 
C     Loop over energy regions defined by the threshold energies in Ryd
C
      IENUM=0
      Z=dble(ION)
      ETOP=ETHR(1)
      DO 50 ITARG=1,NTHR
      EBOT=ETOP
      IF (ITARG.LT.NTHR) THEN
        ETOP=ETHR(ITARG+1)
      ELSE
        Z=ZERO
        ETOP = VBIGNO
      ENDIF
      ERANGE=ETOP-EBOT
      IRES=0
   70 IF (IENUM .GE. NUME) GOTO 60
      IENUM = IENUM+1
      E1 = EN(IENUM)
      ETA1 = PHZ(IENUM)
      IF (E1 .LT. EBOT) GOTO 70
      IF (E1.GT.ETOP.OR.IENUM.GE.NUME) GOTO 60
      IENUM=IENUM+1
      E2 = EN(IENUM)
      ETA2 = PHZ(IENUM)
      IF (E2.GT.ETOP.OR.IENUM.GE.NUME) GOTO 60
      IENUM=IENUM+1
C
      SLOP1 = ZERO
 104  E3 = EN(IENUM)
      ETA3 = PHZ(IENUM)
      IENUM=IENUM+1
      IF (E3 .GT. ETOP) GOTO 110
c     fix to allow for case were no channels & all eigenphases are zero
      if (eta1.eq.eta2 .or. eta1.eq.eta3 .or. eta2 .eq. eta3) then
         slop2 = zero
         goto 10
      endif
C
      SLOP2=((E2-E1)/(ETA2-ETA1)-(E3-E2)/(ETA3-ETA2))/(ETA3-ETA1)
      IF (IPRES .GT. 0) WRITE(IWRITE,900) E2*TOEV,EUNIT,ETA2,SLOP2
  900 FORMAT(' Energy=',F10.5,1X,A3,', Eta=',D20.10,' Second deriv=',
     1       D20.10)
      IF (SLOP1*SLOP2 .GE. ZERO .OR. SLOP1 .LT. SLOP2) GOTO 10
C
C     A resonance has been detected:
C     D**2 (ENERGY) / D**2 (EIGENPHAZE) has changed sign
C
      IF (ETA2 .GE. ETA1 .AND. ETA3 .GE. ETA2) THEN
C
C     Estimate Gamma: if it is ridiculously large, we don't have
C     a genuine resonance
C
        GAM = HALF*ABS((E3-E1)*PI/(ETA3-ETA1))
C       IF (GAM .LT. HALF*ERANGE) THEN
C
C     This resonance has been successfully smoothed over
C     make an initial guess of the width from the slope at ERES
C
          IRES=IRES+1
          ERES(IRES)= E2
          GAMMA(IRES)=GAM
C       ENDIF
C
C     The eigenphase smoothing over this resonance has failed,
C     but we will try for a fit anyway
C
      ELSE
        IRES=IRES+1
        ERES(IRES)=E2
        GAMMA(IRES) = HALF*(E3-E1)
      ENDIF
C
 10   SLOP1=SLOP2
      E1=E2
      ETA1=ETA2
      E2=E3
      ETA2=ETA3
      IF (IENUM .LT. NUME .AND. IRES .LE. NRESON) GOTO 104
C
  110 IF (IRES .EQ. 0) THEN
        WRITE(IWRITE,1040) ITARG
        GO TO 50
      ENDIF
C
C     Resonance fitting section
C
      MRES = MIN(IRES,NRESON) 
      WRITE(IWRITE,1000) ITARG,IRES,MRES
C
      DO 200 I=1,MRES
      ELOW  = MAX(ERES(I)-GAMMA(I),EBOT+ABVTHR)
      EHIGH = MIN(ERES(I)+GAMMA(I),ETOP-BELTHR)
      IF (ELOW .GE. EHIGH) THEN
         WRITE(IWRITE,1030) I
         GOTO 200
      ENDIF
      IF (GETETA) THEN
C
C     Compute eigenphases at fitting grid points
C
        E=ELOW
        DE=(EHIGH-ELOW)/dble(NFIT-1)
C
C     Asymptotic solution step
C
        CALL RSOLVR(LUCHAN,LURMT,LUVCHN,LUNRMT,LURES,
     1            NPOLE,BBLOCH,NGEOM,R,ezero,IWRITE,ISMAX,
     2            IPRNT,NCHSET,NRMSET,NVCSET,NNRSET,NRQUAD,
     3            CHFORM,RFORM,VCFORM,NRFORM,TITLE,EMIN,EMAX,
     4            MGVN,STOT,GUTOT,NVTARG,RK,ivchl,lvchl,mvchl,evchl,cf,
     5            ETHR,NTHR,NFIT,EINC,NESCAT,MAXENR,MAXPTS,NCHAN,
     6            NOPEN,EFIT,AKMAT,bkmat,ETAFIT,IFAIL,E,DE,1,GETETA)
        IF (IFAIL .NE. 0) then
           write(6,*) 'Return from RSOLVR IFAIL=',ifail
           return
        endif
      ELSE
C
C     Use points between ELOW and EHIGH for fit
C
        NFIT=0
        DO 201 IE=1,NUME
        IF (EN(IE) .LT. ELOW) GOTO 201
        IF (EN(IE) .GT. EHIGH) GOTO 202
        NFIT=NFIT+1
        IF (NFIT .LE. MAXFIT) THEN
           EFIT(NFIT)=EN(IE)
           ETAFIT(NFIT)=PHZ(IE)
        ELSE
           NFIT=MAXFIT
           WRITE(IWRITE,930) MAXFIT
  930      FORMAT(/' WARNING: more than MAXFIT =',I4,' points in',
     1             ' resonance fitting region')
           GOTO 202
        ENDIF
  201   CONTINUE
  202   CONTINUE
      ENDIF
C
C     Smooth the eigenphases across any resonances
C
      ETAOLD=-PI
      ETAMAX=-PI
      ETAMIN=VBIGNO
      QUAD=ZERO
      DO 210 N=1,NFIT
C
      SUM=ETAFIT(N)+QUAD
      IF (SUM .LE. ETAOLD .AND. ABS(SUM-ETAOLD) .GE. HALF) THEN
        QUAD=QUAD+PI
        SUM=SUM+PI
      ENDIF
      ETAOLD=SUM
      ETAMAX=MAX(ETAMAX,SUM)
      ETAMIN=MIN(ETAMIN,SUM)
      ETAFIT(N)=SUM
  210 CONTINUE
      IF (IPRES .NE. 0) WRITE(IWRITE,910)
     1                  (N,EFIT(N)*TOEV,EUNIT,ETAFIT(N),N=1,NFIT)
  910 FORMAT(' Grid point',I4,' E=',F10.5,1X,A3,', Eta=',D20.10)
      WRITE(IWRITE,920) I,ELOW*TOEV,EUNIT,EHIGH*TOEV,EUNIT
  920 FORMAT(/' Resonance',I3,' is in the range ELOW =',F10.5,1X,A3,
     1        ' to EHIGH =',F10.5,1X,A3)
C
C     HAVE WE REALLY GOT A RESONANCE ?
C
      IF (ETAMAX-ETAMIN .LT. DPHZ) THEN
         WRITE(IWRITE,1050) I
        GOTO 200
      ENDIF
C     How many resonance are to be fitted ?
      NRFIT = 1
      IF (I .LT. IRES .AND. EHIGH .GT. ERES(I+1)) NRFIT = 2
C     Make sure there is enough data
      IF (NFIT .LE. NBACK+2*NRFIT) THEN
        WRITE(IWRITE,1060) I,NFIT
      ELSE
        CALL RESFIT(ERES(I),GAMMA(I),NFIT,IWRITE,IPRES,Z,ETOP,EUNIT,
     *  efit,etafit,NBACK,NRFIT,NFRES2,TOEV,TOL,resunit,checkr,IFAIL)
C
        if (nrfit.eq.1 .and. IBRANCH.ne.0) then
c        compute time delay matrix: need two more energy points
          DE=gamma(i)/TSCALE
          E=eres(i)-half*de
C
C     Asymptotic solution step
C
          CALL RSOLVR(LUCHAN,LURMT,LUVCHN,LUNRMT,LURES,NPOLE,
     1              BBLOCH,NGEOM,R,ezero,IWRITE,ISMAX,
     2              IPRNT,NCHSET,NRMSET,NVCSET,NNRSET,NRQUAD,
     3              CHFORM,RFORM,VCFORM,NRFORM,TITLE,EMIN,EMAX,
     4              MGVN,STOT,GUTOT,NVTARG,RK,ivchl,lvchl,mvchl,evchl,
     5              cf,ETHR,NTHR,2,EINC,NESCAT,MAXENR,MAXPTS,NCHAN,
     6              NOPEN,EFIT,AKMAT,bkmat,ETAFIT,IFAIL,E,DE,1,GETETA)
c
          call BRANCH(e,de,akmat,bkmat,nopen,Z,ETOP,EUNIT,toev,ivchl,
     *                lvchl,mvchl,IWRITE)
        endif
      ENDIF
  200 CONTINUE
C
   60 IENUM = IENUM-1
   50 CONTINUE
      RETURN
C
 1000 FORMAT(/' Automatic resonance fitting above target state',I3
     1           /I5,' resonances detected'
     2           /I5,' resonances to be fitted')
 1030 FORMAT(/' Resonance',I3,' too close to threshold to be fitted')
 1040 FORMAT(/' Eigenphase search found NO resonances above ITARG =',I3)
 1050 FORMAT(/' Resonance',I3,' is NOT a real resonance'/)
 1060 FORMAT(/' Resonance',I3,': NFIT =',I3,' too small for a fit')
      END
!********************************************************************
      SUBROUTINE RESFIT(ERES,GAMMA,NFIT,IWRITE,IPRES,Z,THRESH,EUNIT,
     * efit,etafit,NBACK,NRES,NFRES2,TOEV,TOL,resunit,checkr,IFAIL)
    
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      common /fitpar/ user(200),iuser(3)
      CHARACTER(LEN=3) EUNIT
      DIMENSION ERES(NRES),GAMMA(NRES),parm(nback+2*nres),
     * efit(nfit),etafit(nfit),iw(nback+2*nres),f(nfit)
      external resfn,lmdif1
      double precision, allocatable :: wa(:)
! for quantemol
      integer :: resunit,checkr
      DATA ZERO/0.D0/,QUART/0.25D0/
C
C     PERFORM BREIT-WIGNER FIT
C
      NFRES2=NRES+NRES
      NPARM=NBACK+2*NRES
      LWA = NPARM*NFIT+5*NFIT+NPARM
      allocate (wa(lwa))
C
      DO 1 I=1,NRES
      parm(I) = ERES(I)
      parm(I+NRES) = GAMMA(I)
 1    continue
      DO 2 I=2*NRES+1,NPARM
      parm(I) = ZERO
 2    continue
      do 3 i=1,nfit
      user(i) = efit(i)
      user(nfit+i) = etafit(i)
 3    continue
      iuser(1) = nback
      iuser(2) = nres
      iuser(3) = nfres2
      info=0
C
C     Print initial guesses and residues if requested
C
      IF (IPRES .GT. 0) THEN
c        CALL LSFUN1(NFIT,NPARM,parm,WORK)
        CALL RESFN(NFIT,NPARM,parm,f,info)
        WRITE(IWRITE,100)
        WRITE(IWRITE,101) EUNIT,(parm(J)*TOEV,J=1,NRES)
        WRITE(IWRITE,102) EUNIT,(parm(J)*TOEV,J=NRES+1,2*NRES)
        WRITE(IWRITE,103) (parm(J),J=2*NRES+1,NPARM)
        WRITE(IWRITE,106) f
      ENDIF
C
C     Call NAG library least squares minimisation routine
C
!      JFAIL=1
c      CALL E04FDF(NFIT,NPARM,PARM,FSUMSQ,IW,LIW,WORK,LW,JFAIL)
!      CALL E04FYF(NFIT,NPARM,RESFN,PARM,FSUMSQ,WORK,LW,iuser,user,
!     * JFAIL)
!      IF (JFAIL .NE. 0) WRITE(IWRITE,105) JFAIL
       call lmdif1(resfn,nfit,nparm,parm,f,tol,info,iw,wa,lwa)
       if (info.ne.3) write(iwrite,*) 'WARNING: LMDIF return INFO ='
     *  ,info
      IF (parm(1)+parm(NRES+1) .LT. EFIT(1) .OR.
     1    parm(1)-parm(NRES+1) .GT. EFIT(NFIT)) THEN
        WRITE(IWRITE,110)
        deallocate(wa)
        RETURN
      ENDIF
C
c      CALL LSFUN1(NFIT,NPARM,parm,WORK)
      WRITE(IWRITE,104)
      WRITE(IWRITE,101) EUNIT,(parm(J)*TOEV,J=1,NRES)
      WRITE(IWRITE,102) EUNIT,(parm(J)*TOEV,J=NRES+1,2*NRES)
      WRITE(IWRITE,103) (parm(J),J=2*NRES+1,NPARM)
      WRITE(IWRITE,106) f
c
c     compute the 'goodness' factor
      good=zero
      do 20  I=1,NFIT
      good=good+f(i)**2
 20   continue
      write(iwrite,111) good
  111 format(' Goodness factor:', d20.8)

      eres(1)=parm(1)
      gamma(1)=parm(nres+1)
C     For ions compute quantum defects relative to next threshold
      IF (Z .GT. ZERO) THEN
        IRES=0
        DO 10 J=1,NRES
        a=parm(j)
        b=parm(nres+j)
        IF (parm(J) .LT. THRESH) THEN
          IRES=IRES+1
          parm(IRES) = Z/SQRT(THRESH-parm(J))
          parm(NRES+IRES) = QUART*parm(IRES)**3*parm(NRES+J)/Z**2
          write(84,200) a,b,good,parm(IRES),parm(NRES+IRES)
  200     format(f10.4,f12.6,d18.6,f10.4,f12.6)
        else
          write(84,201) a,b,good
        ENDIF
   10   CONTINUE
        WRITE(IWRITE,107) (parm(J),J=1,IRES)
        WRITE(IWRITE,108) (parm(J),J=NRES+1,NRES+IRES)
      else
        write(84,201) (parm(j),parm(nres+j),good,j=1,nres)
  201   format(f10.4,f12.6,d18.6)
      ENDIF
!
! write resonance parameters to reson_data (fort.199)
      if (good.le.0.1d0) then
        checkr = 1
        write(resunit,104)
         if (Z .GT. ZERO) then 
! for ions
          write(resunit,107) (parm(J),J=1,IRES)
           write(resunit,108) (parm(J),J=NRES+1,NRES+IRES)
         else  
! write positions and widths
          write(resunit,101) EUNIT,(parm(J)*TOEV,J=1,NRES)
          write(resunit,102) EUNIT,(parm(J)*TOEV,J=NRES+1,2*NRES)
! write residues and goodness factor
          write(resunit,106) f
          write(resunit,111) good
         endif
      endif
!
C
      deallocate (wa)
      RETURN
C
 100  FORMAT(/' Initial estimates of resonance parameters')
 104  FORMAT(/' Fitted resonance parameters')
 101  FORMAT(' Positions / ',A3,9X,5D20.8)
 102  FORMAT(' Widths    / ',A3,9X,5D20.8)
 103  FORMAT(' Background ',6D20.8)
 105  FORMAT(/'  NAG routine E04FDF returned IFAIL=',I3,
     1        ' in routine RESFIT')
 106  FORMAT(' Residues'/(1X,10F13.7))
 107  FORMAT(' Quantum defect (n-alpha)',5D20.8)
 108  FORMAT(' Beta                    ',5D20.8)
 110  FORMAT(/' Fitting failure: fitted resonance outside energy grid'/)
      END
!**********************************************************************
      SUBROUTINE BRANCH(e,de,akmat,bkmat,nopen,z,thresh,eunit,toev,
     1                  ivchl,lvchl,mvchl,IWRITE)
c
c     Use time delay method of FT Smith (Phys Rev A, 115, 349 (1960)
c     to compute branching ratios of a resonance
C
      use precisn_gbl, only: wp
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      character(LEN=3) eunit
      dimension akmat(nopen,nopen),bkmat(nopen,nopen),ivchl(nopen),
     1          lvchl(nopen),mvchl(nopen)
      complex(wp) :: s1(nopen*nopen),s2(nopen*nopen)
c
c     first construct S-matrices from K-matrices
c
      call SMAT(nopen,AKMAT,s1)
      call SMAT(nopen,BKMAT,s2)
c
c     then construct and diagonalise the Q matrix
c
      call qdiag(s1,s2,nopen,e,de,ivchl,lvchl,mvchl,
     1           eunit,toev,thresh,z,iwrite)
C
      RETURN
      END
      SUBROUTINE SMAT(NA,AKMT,SMT)
      USE precisn_gbl, ONLY: wp
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     SMAT CALCULATES THE SCATTERING MATRIX FROM THE K-MATRIX
C     (only the open-open part is computed)
C
C     NA   = NUMBER OF OPEN CHANNELS
C     AKMT = K-MATRIX
C     SMT  = S-MATRIX
C     A,B    WORK SPACE
C
C***********************************************************************
C
      complex(wp) :: smt(na,na)
      DIMENSION A(NA,NA),AKMT(NA,NA),B(NA,NA),x(2*na)
C
      DATA ZERO,ONE,TWO/0.D0,1.D0,2.D0/
C
      DO 10 J=1,NA
      DO 1 I=1,NA
      A(I,J) = AKMT(I,J)
      B(I,J) = ZERO
 1    continue
 10   continue
      DO 3 J=1,NA
      DO 21 K=1,NA
      TK = AKMT(K,J)
      DO 2 I=1,NA
      B(I,J) = B(I,J)+AKMT(I,K)*TK
 2    continue
 21   continue
      B(J,J) = B(J,J)+ONE
 3    continue
C
      CALL MA01A(B,A,NA,NA,0,NA,NA,x,x(na+1))
C
      DO 18 J=1,NA
      DO 19 I=1,NA
      smt(I,J) = cmplx(zero,TWO*A(I,J))
   19 CONTINUE
 18   continue
C
      DO 7 J=1,NA
      DO 61 K=1,NA
      TK = TWO*A(K,J)
      DO 6 I=1,NA
      smt(I,J) = smt(I,J)-cmplx(AKMT(I,K)*TK,zero)
 6    continue
 61   continue
c
c     Have computed the T matrix defined by S = 1 + T
c     so S is given by
c
C
      smt(J,J) = CMPLX(ONE,ZERO)+smt(J,J)
 7    continue
C
c     unitarity check
c      do 17 i=1,na
c      do 17 j=1,na
c      t=zero
c      do 27 k=1,na
c   27 t=t+smt(i,k)*dconjg(smt(k,j))
c   17 tt(i,j)=t
c      write(6,666) 'S*S    ',tt
c  666 format(2x,a//(6f10.5))
C
C
      RETURN
      END
      SUBROUTINE qdiag(smt1,smt2,nopen,e,de,
     1                 ivchl,lvchl,mvchl,eunit,toev,thresh,z,iwrite)
c
c     QDIAG constructs and diagonalises the time delay matrix, Q
c     from S-matrices S1 and S2 which are at energy DE apart
c     centred about resonance energy E.
c 
      USE precisn_gbl, ONLY: wp
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      character(LEN=3) eunit
      DIMENSION eval(nopen),br(3*nopen),ivchl(nopen),lvchl(nopen),
     *          mvchl(nopen)
c      COMPLEX q(nopen,nopen),smt1(nopen,nopen),smt2(nopen,nopen)
      COMPLEX(wp) q(nopen,nopen),smt1(nopen,nopen),smt2(nopen,nopen),
     1           s1,s2,qbit
      data zero,one,two/0.0d0,1.0d0,2.0d0/,QUART/0.25D0/,eigth/8.0d0/
c
      do 11 i=1,nopen
      do 10 j=1,nopen
      s1=(smt1(i,j)+smt2(i,j))
      s2=(smt2(i,j)-smt1(i,j))/de
      smt1(i,j)=s1
      smt2(i,j)=s2
 10   continue
 11   continue
c
      do 20 i=1,nopen
      do 25 j=1,nopen
      qbit=zero
      do 30 k=1,nopen
      qbit=qbit+conjg(smt1(k,i))*smt2(k,j)
 30   continue
      q(i,j)=-cmplx(zero,one)*qbit
 25   continue
c     force the diagonal element to be real (in practice it is but
c     nag routine F02HAF is fussy).
      q(i,i)=cmplx(real(q(i,i)),zero)
 20   continue  
C
        call zheev('v','l',nopen,q,nopen,eval,smt1,nopen*nopen,br,ifail)
        if (ifail .ne. 0) write(iwrite,444) ifail
  444 format(' LAPACK routine ZHEEV returned IFAIL =',i4) 
      eres=e+de/two
C      WRITE(IWRITE,8) eres,(I,I=1,Nopen)
C    8 FORMAT(/'  Eigenvalues of Q-matrix at E =',f8.3,' Ryd',
C     1       /(' Channel',i12,5i20))
C      WRITE(IWRITE,9) (eval(I),I=1,Nopen)
C    9 FORMAT(  '        ',6D20.8)
C      WRITE(IWRITE,11)
C   11 FORMAT(/' Channel eigenvectors:')
C      DO 40 J=1,nopen
C   40 WRITE(IWRITE,12) (q(J,I),I=1,nopen)
C   12 FORMAT(/(10F12.8))
c
      gamma=eigth/eval(nopen)
      write(iwrite,104) eunit,eres*toev,gamma*toev
C     For ions compute quantum defects relative to next threshold
      IF (Z .GT. ZERO .and. e .LT. THRESH) THEN
          alpha = Z/SQRT(THRESH-eres)
          beta = QUART*alpha**3*gamma/Z**2
          write(84,200) eres,gamma,alpha,beta
  200     format(f10.4,f12.6,18x,f10.4,f12.6)
          write(iwrite,107) alpha,beta
      else
          write(84,201) e,gamma
  201     format(f10.4,f12.6)
      ENDIF
      if (ivchl(nopen) .ne. ivchl(1)) then
        ichl=-1
        ipt=0
        do 50 n=1,nopen
        if (ichl.ne.ivchl(n)) then
           ipt=ipt+1
           br(ipt)=zero
           ichl=ivchl(n)
        endif
        br(ipt)=br(ipt)+abs(q(n,nopen))**2
        write(iwrite,79) abs(q(n,nopen))**2,ivchl(n),lvchl(n),mvchl(n)
  50    continue
        write(iwrite,80) ipt,(br(n),n=1,ipt)
        write(84,202) (br(n),n=1,ipt)
  202   format(22x,6f12.6) 
      endif      
  79  format(' ratio=',D13.5,'  i=',i3,'  l=',i3,'  m=',i3)
  80  format(' Branching ratios for',i3,' target channels:',/(5d16.5))
 104  FORMAT(/' Time delay resonance parameters in ',A3,
     1       /' Position =',D20.8,' Width =',D20.8)
 107  FORMAT(' Quantum defect (n-alpha) =',D20.8,' Beta =',D20.8)
      return
      END
c
      SUBROUTINE RESFN(NFIT,NPARM,X,F,info)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      common /fitpar/ e(200),iuser(3)
      DIMENSION X(NPARM),F(NFIT)
      DATA ZERO/0.0d0/,TWO/2.0D0/
C
      nback = iuser(1)
      nfres = iuser(2)
      nfres2= iuser(3)
      DO 7 J=1,NFIT
      H=ZERO
      DO 6 I=1,NFRES
      H=H+DATAN2(X(I+NFRES),TWO*(X(I)-E(J)))
    6 CONTINUE
      DO 8 I=1,NBACK
      H=H+X(NFRES2+I)*E(J)**(I-1)
    8 CONTINUE
      F(J)=E(nfit+J)-H
    7 CONTINUE
C
      RETURN
      END
