! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      subroutine pfarm_interface(ifail)
C
C     H-file production for FARM/PFARM: either standard H.dat or with 
C       packed cf asymptotic coefficients (chosen by logical packed_cf 
C        and absolute value ratio cf_ratio (relative to the largest 
C         abs. value), both in namelist pfint (copied from qbint)
C
C      Some extraneous material from QB-interface is left in
C
      IMPLICIT double precision(A-H,O-Z)
      INTEGER STOT,GUTOT,iprnt(6)
      integer ism, isfmax
      double precision, allocatable :: wmatp(:,:),echl(:),cf(:,:),
     * buttl(:,:),etarg(:),eig(:),vec(:),asp(:,:,:)
      integer, allocatable :: LCHL(:),mchl(:),ichl(:),mtarg(:),starg(:),
     * gutarg(:),nconat(:),ivtarg(:),iv(:), kschl(:)
c partitioned R-matrix arrays:
      double precision, allocatable :: sfac(:), ecex(:), rcex(:,:)
      character(LEN=1) icform,irform
      character(LEN=6) qbfile
      character(LEN=11) form,chform,rform
      double precision, parameter  :: sqr2 = sqrt(2.0d0), two = 2.0d0 
C packed cf arrays: non zero values and channel labels
      double precision, allocatable :: cf_nz(:)
      integer, allocatable  :: ic_label(:), ir_label(:), ncf_nonzero(:)
      integer, allocatable  :: kval(:,:)
      integer ierr, npole_d
      logical packed_cf, for_pfarm
      integer, parameter   ::  nchan_choice = 400
c  semi-arbitrary choice to write abs(ibut) = 1 Buttle coefficients in order
c   1:3, 1:nchan  or 1:nchan,1:3, the latter to use (pseudo-)vector 
c   capabilities of 'modern' cores.
c
c 'minimal' rsolve data for pfarm (energies may need translating)
C      NERANG   = Number of subranges of scattering energies
C      NESCAT   = NUMBER OF INPUT SCATTERING ENERGIES in each subrange
C      NEWBUT   = switch on energy parameter in Buttle correction (normal = 1)
C      EINC     = Scattering energies relative to lowest (vibrational)
C                 level of target 
C                 EINC(1,I) = initial energy in sub range I
C                 EINC(2,I) = energy increment in this subrange
C                 units are as specified by IEUNIT
C      IEUNIT   = UNITS IN WHICH INPUT SCATTERING ENERGIES ARE INPUT
C                 1= RYD, 2= EV
C     RAF    = RADIUS AT WHICH CONTINUED FRACTION METHOD CAN BE USED
C              (DEFAULT RAF=RMATR) ie, limit of BBM propagation
      integer  nerang, nescat, newbut, ieunit, mgvn
      double precision einc(2,10), raf
c optional data for PFARM parallel runs
c     ntask_d   = number of MPI tasks for EXDIG/RMX
c     ntask_p   = number of MPI tasks for EXAS/rmprop
c if these are left as default 0 you will need to set the parallel parameters
c   manually in phzin.ctl
      integer ntask_d, ntask_p
c optional name of run
      character(LEN=20) name
c k-matrix ouptout formatted "f" or unformatted "u"
      character(LEN=1) ikform
c name of hfile
      character(LEN=6) hfile
c print formatted H file with descriptions of data
      logical detail_out

      namelist /pfint/luchan,lurmt,luh,nchset,nrmset,iprnt,iwrite,
     * icform,irform,luQB,ipert,irad,ac,rone,rr,iopt,xmin,xmax,bdx,nelt,
     * ismax,packed_cf, cf_ratio, for_pfarm, newbut, ieunit, nerang,
     * nescat, einc, ntask_d, ntask_p, raf, hfile, name, ikform, 
     * detail_out
c
      data zero/0.d0/,luchan,lurmt,luh/10,21,9/,iprnt/6*0/,iwrite/6/,
     * nchset,nrmset/1,1/,luqb/27/,ipert/0/,irad/0/,AC/0.000001d0/,
     * rone,rr/1.d0,0.d0/,iopt/1/,xmin,xmax,bdx/0.d0,10.d0,0.005d0/,
     * nelt/0/,ismax/-1/
      data qbfile/'QB.INP'/
      DATA FORM,CHFORM,RFORM/3*'FORMATTED'/,ICFORM,IRFORM/2*'U'/
      data packed_cf /.true./
      data for_pfarm /.true./
      data cf_ratio /1.0d-10/
      data newbut, ieunit, nerang /1,1,1/
      data ntask_d, ntask_p /0,0/
      data raf /0.0d0/
      data name /' pfarm moltest      '/
      data ikform /'f'/
      data hfile /'H     '/
      data detail_out/.false./  

      write(*,*) ' hi there interface'
      write (iwrite,101)
c
c --- Read input data via namelist
c
      read(5,pfint)
      if(ipert.ne.0) then
        write(iwrite,90) 
        ipert = 0
        ismax = 0
      endif
      write(*,*) 'namelist read'
      if (nerang .gt. 10) then
         write(*,*) 'nerang > 10, please change 2nd dim of einc in',
     &              ' pfarm_interface if this is coreect'
         stop
      end if 
c
      IF(ICFORM.EQ.'U') CHFORM='UN'//FORM
      IF(IRFORM.EQ.'U') RFORM='UN'//FORM

c
C ---- Read R-matrix header first to get dimension information
c
 
      call READRH(LURMT,NRMSET,RFORM,MGVN,STOT,GUTOT,NCHAN,NVIB,
     1 NDIS,NTARG,ION,RR,RMASS,RMATR,IBUT,ISM,nstat,NOCSF,NPOLE,
     2 ezero, iex, IWRITE, IPRNT(2),IFAIL)        
c   mgvn -> lrgl1 and stot -> nspn1 are taken from swinterf output, 
c   swinterf sets parity value gutot -> npty1 equal to 2
      write(*,*) 'readrh done' 
      IF(ISMAX.EQ.-1.OR.ISMAX.GT.ISM) THEN
        ISFMAX = ISM
        if (ismax .eq. -1) ismax = ism
      ELSE
        ISFMAX = ISMAX
      ENDIF
      WRITE(IWRITE,34) ISFMAX
34    FORMAT(/' Maximum multipole in asymptotic scattering potentials  
     1 ISMAX =',I3)
c
c --- Allocate arrays
c
      npole_d = npole
      if (npole .eq. 0) npole_d = 1
      allocate (lchl(nchan),mchl(nchan),ichl(nchan),echl(nchan),
     * cf(nchan*(nchan+1)/2,ismax),buttl(3,nchan))
      allocate (mtarg(ntarg),starg(ntarg),gutarg(ntarg),etarg(ntarg),
     * nconat(ntarg), kschl(nchan))
      allocate (eig(nstat),vec(nocsf*npole),wmatp(nchan,nstat))
      nvd = nvib+ndis
      if(nvd.gt.0) then
         allocate (ivtarg(nvd),iv(nvd))
      else
         allocate(ivtarg(1),iv(1))
      end if
      if (abs(ibut) .gt. 1) then
         iex_d = MAX(iex,1)
         allocate(sfac(nchan), ecex(iex_d), rcex(nchan,iex_d))
      else
c  dummy value of iex
         iex = 1
         allocate(sfac(1), ecex(iex), rcex(nchan,iex))
      end if
c
c --- Read target and channel data
c      
      call READTC(LUCHAN,NCHSET,NCHAN,NVIB,NDIS,NTARG,ION,IVTARG,
     1IV,ICHL,LCHL,MCHL,ECHL,STARG,MTARG,GUTARG,ETARG,R,RMASS,CHFORM,
     2IWRITE,IPRNT(1),IFAIL)
                  
c
c --- Read R-matrix file
c     
      call READRM(LURMT,RFORM,NCHAN,nstat, NOCSF,ISMaX,isfmax,NPOLE,0,
     1 IBUT,CF,EIG,wmatp,VEC,buttl,sfac,iex,ecex,rcex,IFAIL)    
      write(*,*) 'readrm done'
C
c --- Calculate other data needed by QB
c
      do I=1,NTARG
        NCONAT(I)=0
        do J=1,NCHAN
          IF(ICHL(J).EQ.I) NCONAT(I)=NCONAT(I)+1
        end do
      end do
c   info for PFARM namelist file: target spin for each channel
      do j = 1, nchan
         kschl(j) = starg(ichl(j))
      end do    
c      
      bsto = zero
      if(nelt.eq.0) then
        nz=1
        nelt = nz-ion
      else
        nz = nelt+ion
      endif
      more2 = 0
      if (raf .lt. rmatr) raf = rmatr
c  write out partial information for PFARM namelist file phzin.ctl
      if (for_pfarm) then
         call pfarm_namelist_data (mgvn, stot, gutot,
     &             hfile, name, ikform, nchan, kschl, nstat, 
     &             isfmax, packed_cf, newbut, ieunit, nelt, nz, 
     &             nerang, nescat, einc, ntask_d, ntask_p,
     &             rmatr, raf, ibut)      
! packed_cf option needed at present as pfarm otherwise assumes atomic 
!   symmetries
         packed_cf = .true.
      end if
c
c --- Write H-file
c
C Rather than have another option, the 'pure' formatted write is
c commented out. Please edit if you need it.      
      open(unit=luh,file=TRIM(hfile),form='unformatted',status='new')
c      open(unit=901,file='hfile_formated',form='formatted',status='new')
      if (detail_out) then
      open(unit=900,file='hfile_f_detail',form='formatted',status='new')
         WRITE(900,*)"NELT = number of electrons (scattering?)" 
         WRITE(900,*)"NZ = "
         WRITE(900,*)"NCHAN = number of scattering channels"
         write(900,*) "Note: nchan is used for the Buttle correction ",
     &                "in UKRmol rather than lrang2"
         write(900,*) "Thus UKRmol H files run 1 symmetry only"
         WRITE(900,*)"ISMAX = maximum multipole in expansion"
         WRITE(900,*)"        of asymptotic potential"
      WRITE(900,*)"NTARG = number of target electronic configurations"
         WRITE(900,*)"Rmatr = R-Matrix boundary radius"
         WRITE(900,*)"BSTO = "      
      WRITE(900,*)"DATA FORMAT: NELT,NZ,NCHAN,ISMAX,NTARG,Rmatr,BSTO"  
         WRITE(900,*)"------------------------------------------------"     
         WRITE(900,*)NELT,NZ,NCHAN,ISFMAX,NTARG,Rmatr,BSTO   
      end if
c      WRITE(901,*)NELT,NZ,NCHAN,ISFMAX,NTARG,Rmatr,BSTO   
      WRITE(luh)NELT,NZ,NCHAN,ISFMAX,NTARG,Rmatr,BSTO    
      if (for_pfarm) then
         if (detail_out) then
            write(900,*) "For PFARM, write nuclear parameters RR, RMASS"
            write(900,*) "These were used in rsolve for vibration"
            write(900,*) 
     &     "They are dummies but 'needed' in the fort.19 header info"
            write(900,*) "Also, ezero is needed if abs(ibut) = 2"
         write(900,*) "Also ibut, iex: iex is needed if abs(ibut) = 2"
         write(900,*) "Also, nchan_choice is needed if abs(ibut) = 1"
            write(900,*) "They are ignored in PFARM if not neeeded"
            write(900,*) rr, rmass, ezero, ibut, iex, nchan_choice
         end if
c         write(901,*) rr, rmass, ezero, ibut, iex, nchan_choice
         write(luh) rr, rmass, ezero, ibut, iex, nchan_choice
      end if
      if (detail_out) then
      WRITE(900,*)"------------------------------------------------" 
         WRITE(900,*)"Target Energies for each target state"             
         WRITE(900,*)"DATA FORMAT: (ETARG(I),I=1,NTARG)"
         WRITE(900,*)"------------------------------------------------" 
         WRITE(900,*)(ETARG(I),I=1,NTARG)
      end if
c      WRITE(901,*)(ETARG(I),I=1,NTARG)
      WRITE(luh)(ETARG(I),I=1,NTARG)
      if (detail_out) then
      WRITE(900,*)"------------------------------------------------" 
         WRITE(900,*)"Symmetry for each target state"               
         WRITE(900,*)"DATA FORMAT: (MTARG(I),I=1,NTARG)"
         WRITE(900,*)"------------------------------------------------"
         WRITE(900,*)(MTARG(I),I=1,NTARG)
      end if
c      WRITE(901,*)(MTARG(I),I=1,NTARG)
      WRITE(luh)(MTARG(I),I=1,NTARG)
      if (detail_out) then
      WRITE(900,*)"------------------------------------------------"         
         WRITE(900,*) "Spin angular Momentum for each target state"          
         WRITE(900,*)"DATA FORMAT: (STARG(I),I=1,NTARG)"
      WRITE(900,*)"------------------------------------------------"  
         WRITE(900,*)(STARG(I),I=1,NTARG)
      end if
c      WRITE(901,*)(STARG(I),I=1,NTARG)
      WRITE(luh)(STARG(I),I=1,NTARG)
      if (detail_out) then   
      WRITE(900,*)"------------------------------------------------" 
         WRITE(900,*) "Explanation/Definition"                 
      end if
      if (ibut .eq. 1) then
         if (detail_out) then
            write(900,*) "Standard Buttle correction: ibut = +1"
            write(900,*) "Note that outerio reads Buttle if ibut > 0" 
            if (nchan .le. nchan_choice) then
         WRITE(900,*)"DATA FORMAT: ((BUTTL(I,J),I=1,3),J=1,NCHAN) *two"
C            Note factor of 2 to match sqrt(2) factor in amplitudes 
         WRITE(900,*)"------------------------------------------------"
               WRITE(900,*)((BUTTL(I,J) * two,I=1,3),J=1,NCHAN)    
            else 
            WRITE(900,*)"DATA FORMAT: ((BUTTL(I,J),J=1,NCHAN),I=1,3)"
         WRITE(900,*)"------------------------------------------------"
               WRITE(900,*)((BUTTL(I,J) * two,J=1,NCHAN),I=1,3)
            end if
         end if
         if (nchan .le. nchan_choice) then        
c            WRITE(901,*)((BUTTL(I,J) * two,I=1,3),J=1,NCHAN)
            WRITE(luh)((BUTTL(I,J) * two,I=1,3),J=1,NCHAN)
         else 
c          WRITE(901,*)((BUTTL(I,J)* two,J=1,NCHAN),I=1,3)
            WRITE(luh)((BUTTL(I,J) * two,J=1,NCHAN),I=1,3)
         end if
      else if (abs(ibut) .gt. 1) then
         if (detail_out) then
            write(900,*) "Partitioned R-matrix correction: ibut = +-2"
            write(900,*) "I think it's always -2 in practice" 
C            Note factors of 2 to match sqrt(2) factor in amplitudes 
            WRITE(900,*)"DATA FORMAT: (sfac(J),J=1,NCHAN) * two"
            WRITE(900,*) "IF (iex > 0) THEN "
            WRITE(900,*)"DATA FORMAT: (ecex(J),J=1,iex)"
        WRITE(900,*)"DATA FORMAT: ((rcex(i,J),i=1,nchan),j=1,iex) * two"
            WRITE(900,*) "END IF"
c            WRITE(900,*) (sfac(J) * two,J=1,NCHAN)
c            WRITE(900,*) (ecex(J),J=1,iex)
c            WRITE(900,*) ((rcex(i,J) * two,i=1,nchan),j=1,iex)
         end if
c         WRITE(901,*) (sfac(J) * two,J=1,NCHAN)
         WRITE(luh) (sfac(J) * two,J=1,NCHAN)
         if (iex .gt. 0) THEN
c            WRITE(901,*) (ecex(J) * two,J=1,iex)
c           WRITE(901,*) ((rcex(i,J) * two,J=1,iex),i=1,nchan)
           WRITE(luh) (ecex(J),J=1,iex)
           WRITE(luh) ((rcex(i,J) * two,i=1,nchan),j=1,iex)
         end if
      else if (ibut .eq. 0) then
          if (detail_out) write(900,*) 
     *    "Since ibut varies, we won't bother with a dummy",
     *             "buttl(I,J) for ibut = 0"
      end if
      if (detail_out) then
      WRITE(900,*)"------------------------------------------------" 
     
         WRITE(900,*) "MGVN = Overall M symmetry of the system"
         WRITE(900,*) "STOT = Spin Multiplicity"
         WRITE(900,*) "GUTOT = g/u symmetry"
         write(900,*) "nb in UKRMOL, SWINTERF set this = 2 (ie not 0,1)"
         WRITE(900,*) "NCHAN = total number of scattering channels"
         WRITE(900,*) "NSTAT = dimension of (reduced if abs(ibut)>1)",
     *             " Hamiltonian matrix"
         WRITE(900,*) "MORE2 = "             
         WRITE(900,*)"DATA FORMAT: MGVN,STOT,GUTOT,NCHAN,NSTAT,MORE2"      
      WRITE(900,*)"------------------------------------------------" 
         WRITE(900,*)MGVN,STOT,GUTOT,NCHAN,NSTAT,MORE2
      end if
c      WRITE(901,*)MGVN,STOT,GUTOT,NCHAN,NSTAT,MORE2
      WRITE(luh)MGVN,STOT,GUTOT,NCHAN,NSTAT,MORE2
      if (detail_out) then
      WRITE(900,*)"------------------------------------------------"     
         WRITE(900,*) "Explaination/Definition"
         WRITE(900,*)"DATA FORMAT: (NCONAT(I),I=1,NTARG)"
      WRITE(900,*)"------------------------------------------------"               
         WRITE(900,*)(NCONAT(I),I=1,NTARG)
      end if
c      WRITE(901,*)(NCONAT(I),I=1,NTARG)
      WRITE(luh)(NCONAT(I),I=1,NTARG)
      if (detail_out) then
      WRITE(900,*)"------------------------------------------------" 
         WRITE(900,*) "Explaination/Definition"          
         WRITE(900,*)"DATA FORMAT: (LCHL(I),I=1,NCHAN)"
      WRITE(900,*)"------------------------------------------------" 
         WRITE(900,*)(LCHL(I),I=1,NCHAN)
      end if
c      WRITE(901,*)(LCHL(I),I=1,NCHAN)
      WRITE(luh)(LCHL(I),I=1,NCHAN) 
      if (detail_out)     
     * WRITE(900,*)"------------------------------------------------" 
      if (.not. packed_cf) then
c  full asymptotic coeffs inluding zeros needed for H file
         allocate (asp(nchan,nchan,ismax))
         do L=1,ISMAX
            k = 0
            do i=1,nchan
               do j=1,i
                  k = k+1
                  ASP(I,J,l) = cf(k,l)
                  asp(j,i,l) = cf(k,l)
               end do
            end do
         end do
         if (detail_out) then
            WRITE(900,*) "Explanation/Definition"
         write(900,*) " cf (named asp) arrays, coeffs for long-range ",
     &                 "potential: "
         WRITE(900,*) '((ASP(I,J,L),I=1,NCHAN),J=1,NCHAN),L=1,ismax)' 
c            WRITE(900,*)(((ASP(I,J,L),I=1,NCHAN),J=1,NCHAN),L=1,ismax) 
         WRITE(900,*)"------------------------------------------------" 
         end if
c         WRITE(901,*)(((ASP(I,J,L),I=1,NCHAN),J=1,NCHAN),L=1,ismax) 
         WRITE(luh)(((ASP(I,J,L),I=1,NCHAN),J=1,NCHAN),L=1,ismax) 
         deallocate(asp)
      else 
c packed asymptotic coeffs
         ismax1 = MAX(ismax,1)
         allocate(ncf_nonzero(ismax1), stat=ierr)
C harmless dummy value to be overwritten
         ncf_nonzero(1) = 0
         k = nchan*(nchan+1)/2
         big_cf_pos = MAX(MAXVAL(cf(1:k,1:ismax)), 0.0d0)
         big_cf_neg = MIN(MINVAL(cf(1:k,1:ismax)), 0.0d0)
         big_cf = MAX(big_cf_pos,ABS(big_cf_neg))
         factor_cf = cf_ratio * big_cf
         k = 0
c UKRmol stores in upper packed order
         allocate (kval(nchan,nchan), stat=ierr)
         do j = 1, nchan
            do i = 1, j
               k = k + 1
               kval(i,j) = k
               kval(j,i) = k
            end do
         end do
         do l = 1, ismax
            icf = 0
            do j = 1, nchan
               do i = j, nchan
                  k = kval(i,j)
                  if (ABS(cf(k,l)) .gt. factor_cf) icf = icf + 1
               end do
            end do
            ncf_nonzero(l) = MAX(icf,1)
         end do
         ncf_m = MAXVAL(ncf_nonzero)
         ncf_m = MAX(ncf_m,1)
         allocate (ic_label(ncf_m), stat=ierr)
         allocate (ir_label(ncf_m), stat=ierr)
         allocate (cf_nz(ncf_m), stat=ierr)               
         if (detail_out) then
            WRITE(900,*) "Explanation/Definition"
         write(900,*) " packed cf arrays (guaranteed length 1 with ",
     &                 "harmless dummy value if necessary)"
            WRITE(900,*)"DATA FORMAT: (NCF_NONZERO(L),I=1,ISMAX"
            WRITE(900,*) ncf_nonzero(1:ismax1)
            write(900,*) "data format: for each l = 1, ismax "
         WRITE(900,*)"DATA FORMAT: ir_label(1:ncf,l), ic_label(1:ncf,l)"
            WRITE(900,*)"DATA FORMAT: cf_nz(1:ncf,l)"
         end if
c         WRITE(901,*) ncf_nonzero(1:ismax1)
         write(luh) ncf_nonzero(1:ismax1)
         do l = 1, ismax
            icf = 0
C harmless dummy initial values which should be overwritten as follows
            ic_label(1) = 1
            ir_label(1) = 1
            cf_nz(1) = 0.0d0
            do j = 1, nchan
               do i = j, nchan
                  k = kval(i,j)
                  asp_val = cf(k,l)
                  if (ABS(asp_val) .gt. factor_cf) then
                     icf = icf + 1
                     ic_label(icf) = j
                     ir_label(icf) = i
                     cf_nz(icf) = asp_val  
                  end if
               end do
            end do
            ncf = MAX(ncf_nonzero(l),1)
            if (detail_out) then
               write(900,*) ir_label(1:ncf), ic_label(1:ncf)
c               write(900,*) cf_nz(1:ncf)
      WRITE(900,*)"------------------------------------------------"    
            end if
c            write(901,*) ir_label(1:ncf), ic_label(1:ncf)
c            write(901,*) cf_nz(1:ncf)
            write(luh) ir_label(1:ncf)
            write(luh) ic_label(1:ncf)
            write(luh) cf_nz(1:ncf)
         end do
         deallocate (cf_nz, ic_label, ir_label, ncf_nonzero, kval, 
     &               stat=ierr)
         if (ierr .ne. 0) then
           write(*,*) 'problem with allocation/deallocation, packed_cf'
           stop
         end if
      end if
c
      if (detail_out) then
         WRITE(900,*) "Explaination/Definition"
         WRITE(900,*)"DATA FORMAT: (EIG(I),I=1,NSTAT)"
      WRITE(900,*)"------------------------------------------------"    
c        WRITE(900,*)(EIG(I),I=1,NSTAT)
      end if
c      WRITE(901,*)(EIG(I),I=1,NSTAT)
      WRITE(luh)(EIG(I),I=1,NSTAT)
      if (detail_out) then
      WRITE(900,*)"------------------------------------------------" 
         WRITE(900,*) "Explanation/Definition"
      WRITE(900,*)"DATA FORMAT: ((WMATP(I,J),I=1,NCHAN),J=1,NSTAT)"
         WRITE(900,*)"Note: each value multipled by sqrt(2) ',
     &           ' to be consistent with H.dat au convention"
      WRITE(900,*)"------------------------------------------------" 
c         WRITE(900,*)((WMATP(I,J)*sqr2,I=1,NCHAN),J=1,NSTAT)
      WRITE(900,*)"------------------------------------------------" 
      end if
c      WRITE(901,*)((WMATP(I,J)*sqr2,I=1,NCHAN),J=1,NSTAT)
      WRITE(luh)((WMATP(I,J)*sqr2,I=1,NCHAN),J=1,NSTAT)
c
      close (unit=900)
      close (unit=901)
      close (unit=luh)
      deallocate (lchl,mchl,ichl,echl,cf,buttl)
      deallocate (mtarg,starg,gutarg,etarg,nconat,kschl)
      deallocate (eig,vec,wmatp)
      deallocate (ivtarg,iv)
      deallocate(sfac,ecex,rcex)
c
C --- set up input data for QB code on file QB.INP
C
      IPRINT = iprnt(3)
C
      open(unit=luqb,file='qbfile',form='formatted',status='new')
c
      WRITE(luqb,*)IPRINT,IRAD,IPERT
      WRITE(luqb,*)AC
      WRITE(luqb,*)RONE
      WRITE(luqb,*)IOPT
      WRITE(luqb,*)stot,mgvn,gutot
      WRITE(luqb,*)XMIN,XMAX,BDX
c
      write(iwrite,100)
c
      return
c
 90   format(//' !!! IPERT not implemented in current QB code ') 
 100  FORMAT(//' *** Task has been successfully completed ***'//)
 101  format(//' *** Interfacing to QB resonance fitting code ***')
C
      END 

      subroutine pfarm_namelist_data (mgvn, stot, gutot, 
     &                       hfile, name, ikform, 
     &                       nchan, kschl, nstat, isfmax,
     &                       packed_cf, newbut, ieunit, nelt, nz, 
     &                       nerang, nescat, einc, ntask_d, ntask_p,
     &                       rmatr, raf, ibut)
c partial namelist data for PFARM phzin.ctl file
      implicit none
      integer mgvn, stot, gutot
      character(LEN=20) name
      character(LEN=6) hfile
      character(LEN=1) ikform
      integer nchan, kschl(nchan), nstat, isfmax, newbut
      integer ieunit, nelt, nz, nerang, nescat
      integer ntask_d, ntask_p, ibut
c see top of pfarm_interface for meanings
      double precision  einc(2,10)
      logical packed_cf
      double precision rmatr, raf
      double precision ryd, factor, emax, emax_j
c conversion from eV to Rydbergs
      parameter (ryd = 0.073500D0)
      integer i, j, ne_temp(10), ion
c is the spin split?
      integer st1, st2
c parallel parameters, EXDIG/rmx
      integer nblock, nh_outer, nsqrt, num_diag_farms
c parallel parameters, EXAS/rmprop
      double precision rkmax, ansect
      integer nsect, num_en, num_man,num_min, nsp_f, num_pip
      integer num_pip_min, num_pip_max, num_asy_per, n_test, num_rm
      integer num_rm_gp, nr_test, np_rm_gather_max, num_b

      st1 = kschl(1)
      st2 = -999
      do i = 2, nchan
         if (kschl(i) .ne. st1) then
            st2 = kschl(i)
            exit
         end if 
      end do

      if (ieunit .eq. 2) then
         factor = ryd
      else
         factor = 1
      end if
c PFARM expects energy grid input in scaled Rydbergs
      ion = nz - nelt
      if (ion .gt. 1) then
         factor = factor / dble(ion * ion)
c PFARM expects final radius in scaled au
         raf = raf * dble(ion)
      end if
      do j = 1, nerang
         do i = 1, 2
            einc(i,j) = einc(i,j) * factor
         end do
      end do
      emax = 0.0d0
      do j = 1, nerang
         ne_temp(j) = nescat
         emax_j = einc(1,j) + (nescat - 1) * einc(2,j)
         emax = MAX(emax,emax_j) 
      end do
C safety measure for low-energy accuracy
      emax = MAX(emax,0.7d0)            

      if (ntask_d .ne. 0) then
C EXDIG/rmx tasks NOTE: assumes PFARM default mesh *** needs altering if 
C  PFARM general mesh is made more sophisticated ****, ie into a fine mesh 
c for molecules
         nh_outer = nchan * 10      
 10      continue
         nsqrt = NINT(sqrt(dble(ntask_d)))
         if (nsqrt * nsqrt .ne. ntask_d) then
            ntask_d = nsqrt * nsqrt
            write(*,*) 'ntask_d should be a square, ',
     &                 'it has been reset to', ntask_d
         end if  
         nblock = (nh_outer / nsqrt) / 2
c if PFARM tests change the 'OK' size from 96, this needs changing here
         nblock = MIN (nblock, 96)
         num_b = nh_outer / nblock
         if (nblock .lt. 10 .or. num_b .lt. nsqrt) then
            write(*,*) 'EXDIG/rmx block size is too small OR',
     &      ' there are too few blocks for the number of tasks:'
            nsqrt = MAX(nsqrt - 1,1)
            ntask_d = nsqrt * nsqrt
            write(*,*) 'ntask_d is reduced to ', ntask_d
            if (nsqrt .ne. 1) go to 10
         end if
         if (ntask_d .eq. 1) then
            nsqrt = 2
            ntask_d = 4
            nblock = 4
            if (nh_outer .lt. 8) then
               write (*,*) 'Hamiltonian size is <', 8, 
     &         ' This is too small for PFARM'
               stop
            end if
            write(*,*) 'Minimum size for EXDIG/rmx chosen:', 
     &       ' nblock = 4, ntask_d = 4'
         end if
         write(*,*) 'The number of MPI tasks for EXDIG/rmx has been',
     &              ' set to', ntask_d
         write(*,*) 'If this is not acceptable please rerun ',
     &              'the pfarm_interface calculation.'
         if (nsqrt .gt. 999) then
            write(*,*) 'Please reset format of "ntask_d" write from i3',
     &                 ' to accommodate value:', nsqrt, ', then rerun.'
            stop
         end if 
         num_diag_farms = 1
      end if

      if (ntask_p .ne. 0) then
         rkmax = sqrt(emax) 
c the following line needs altering if a more sophisticated sector
c generation is used
c         ansect = (raf - rmatr) * rkmax / dble(10)
c reset to match bpropg in UKRmol
         ansect = (raf - rmatr) * rkmax / dble(6)
         nsect = MAX(INT(ansect+1.0d0),2) 
         num_en = nescat * nerang
C EXAS/rmp tasks NOTE: very simplistic basic set-up. 
C This needs proper adaptation using the high-accuracy scripts. 
C It should give 'working' but UNOPTIMIZED numbers
         num_man = 1 + ntask_p / 500
         num_min = nsect + 1 + 1 + num_man
         nsp_f = 1
         if (st2 .ne. -999) then
            num_min = num_min + nsect + 1
            nsp_f = 2
         end if
         if (ntask_p .lt. num_min) then
             write(*,*) 'ntask_p (EXAS/rmprop) must be at least', 
     &                   num_min, ' for this problem'
             stop
         end if

         num_pip_max = num_en / 3
         if (num_pip_max .eq. 0) then
            write(*,*) 'Too few energies for PFARM'
            stop
         end if
         num_pip_min = 1
         num_asy_per = 3
         if (ntask_p .gt. 10) num_asy_per = num_asy_per
c think again here ?
     &                                      + MIN(2,(ntask_p - 10)/5)
         num_pip = num_pip_max
 11      continue
         n_test = num_pip * (nsp_f * nsect + num_asy_per)
         if (n_test .ge. ntask_p) then
            i = MOD(n_test, ntask_p)
            num_pip = MAX(num_pip - (i / 2 + 1), num_pip_min)
            if (num_pip .eq. num_pip_min) go to 12
            go to 11
         end if
 12      continue
         if (num_pip * num_asy_per .gt. num_en) then
            num_asy_per = MAX(num_asy_per - 1, 1)            
            go to 12
         end if
         num_rm_gp = MAX(num_pip / 10, 1)
         n_test = num_pip * (nsp_f * nsect + num_asy_per)
         num_rm = MAX((ntask_p - num_man - n_test)/ num_rm_gp, nsp_f)
 13      continue
c number of R-matrix e-values per task is set to be <= 1000 arbitraliy
         nr_test = nstat * nsp_f / num_rm
         if (nr_test > 1000) then
            num_rm = num_rm + nsp_f
            go to 13
         end if            
         i = 2
 14      continue
         j = num_rm / nsp_f
         if (i .lt. j) then
            i = i * 2
            go to 14
         end if
         np_rm_gather_max = i
         if (ABS(i/2 - j) .lt. ABS(i - j)) np_rm_gather_max = i / 2 
         n_test = num_rm * num_rm_gp + 
     &            num_pip * (nsp_f * nsect + num_asy_per) + num_man
         write(*,*) 'Based on input ntask_p =', ntask_p
         write(*,*) 'the unadjusted estimated task-farm values require',
     &              n_test,  ' tasks.'
         write(*,*) 'These may be adjusted by PFARM,  but reset them ',
     &       ' in phzin.ctl if the two final values are not close.' 
      end if


      open (unit=763, file='partial_phzin.ctl') 
      write(763,'(3a)') '&phzin  title = "', Trim(name), '"'     
      if (ntask_d .ne. 0) write(763,'(2(a,i3),a,i3)')
     &       '        p =', nsqrt, ' q =', nsqrt, '  nblock =', nblock 
      write(763,'(a,i2)') '        num_sect_diag_grids =', 
     &                                               num_diag_farms    

      write(763,'(a)') '        molecule_format = .true.'
      if (packed_cf) then
         write(763,'(a)') '        packed_cf = .true.'
      else
         write(763,'(a)') '        packed_cf = .false.'
      end if
      write(763,'(a,i2)') '        lrgl1 =', mgvn    
      write(763,'(a,i2)') '        nspn1 =', stot
      write(763,'(a,i2)') '        npty1 =', gutot    
      if (st2 .ne. -999) then 
         write(763,*) '        split_prop = .true.'
      else
         write(763,*) '        split_prop = .false.'
      end if
      write(763,'(a,i2)') '        n_lambda =', isfmax
      write(763,'(2(a,i3))') '        nelc =', nelt, ' nz =', nz  
      write(763,'(a,e14.6)') '        rafin =', raf
      if (ibut .eq. 0) then
         write(763,'(a)') '        buttle = .false.'
         if (newbut .ne. 1) newbut = 1
c newbut = 1 is default in rsolve and hence in pfarm (for UKRmol only)
c Since buttle = .false. here we set newbut to default for simplicity
      else if (ibut .eq. 1) then
         write(763,'(a)') '        buttle = .true.'
      else if (abs(ibut) .eq. 2) then
         write(763,'(a)') '        buttle = .false.'
         if (newbut .ne. 1) newbut = 1
         write(763,*) '        partitioned = .true.'
      end if
      if (newbut .eq. 0) write(763,'(a,i2)') '        newbut =', newbut
      if (ikform .eq. 'f' .or. ikform .eq. 'F') 
     &       write(763,'(a)') '        km_form = .true.'
      write(763,'(3a)') '        filh = "', Trim(hfile), '"'     
      if (nescat .gt. 999999) then
         write(*,*) 'nescat > 999999: please adjust format',
     &              ' of write in pfarm_namelist_data from i6'
         stop
      end if           
c you may wish to tidy the spare spaces manually
      write(763,'(a,i3,10(a,i6))') '        ne =', nerang, 
     &                             (',',ne_temp(j), j = 1, nerang)
      if (ion .gt. 1 .or. ieunit .eq. 2) then
         write(763,'(a,20e18.10)') '        esc =',
     &              ((einc(i,j), i = 1, 2), j = 1, nerang)
      else
         write(763,'(a,20e14.6)') '        esc =',
     &              ((einc(i,j), i = 1, 2), j = 1, nerang)
      end if
      write(763,'(a,e14.6)') '        emax =', emax
      if (ntask_p .gt. 0) then
         write(763,'(a,i4)') '        num_rm_gen =', num_rm * num_rm_gp
         write(763,'(a,i4)') '        num_asy_per_pipe =', 
     &                                    num_asy_per
         write(763,'(a,i4)') '        np_rm_gather_max =', 
     &                                    np_rm_gather_max
         write(763,'(a,i3)') '        np_managers =', num_man
      end if
      close (unit=763)
      return
      end
