! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-out (UKRmol+ suite).
!
!     UKRmol-out is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-out is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-out (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
!
      SUBROUTINE VIBINI(IREAD,IWRITE,NTARG,NVTARG,RMASS,BASE,LBUG)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     VIBINI INITIALIZES THE CALCULATION OF VIBRATIONAL WAVEFUNCTIONS
C
C     THESE MAY EITHER BE READ IN DIRECTLY OR CALCULATED FROM THE CLOSED
C     FORM EXPRESSIONS FOR MORSE FUNCTIONS
C     THE FORMAT FOR DIRECT INPUT IS CONSISTENT WITH THE PROGRAM OF
C     LEROY (1980) AS MODIFIED BY J TENNYSON AND LA MORGAN (1985)
C
C     IREAD = LOGICAL UNIT FOR BASIC INPUT
C     IWRITE= LOGICAL UNIT FOR OUTPUT
C     NTARG = NUMBER OF TARGET ELECTRONIC CONFIGURATIONS
C     NVTARG= NUMBER OF VIBRATIONLAL LEVELS FOR EACH ELECTRONIC STATE
C     RMASS = REDUCED MASS OF TARGET IN A.U.
C     EBASE = BASE ENERGY IN A.U.
C     LBUG  = SWITCH ON EXTRA OUTPUT
C
C***********************************************************************
C
      PARAMETER (MAXTGT=10,MAXVIB=100)
      DIMENSION DEV(MAXTGT),BETAV(MAXTGT),REV(MAXTGT),WV(MAXTGT),
     1E0V(MAXTGT),AV(MAXTGT),IVIB(MAXVIB),EVIB(MAXVIB),C0(MAXVIB),
     2NU(MAXVIB),CURV(*),LV(MAXTGT),
     3NVTARG(NTARG),ETARG(NGEOM,*),EIG(NGEOM,NSTAT),R(*)
      DIMENSION ECHV(NIV),ICHV(NIV),NCHV(NIV),VIBR(NQUAD,NIV)
      double precision, allocatable :: VIBF(:)
      SAVE
C
C***********************************************************************
C
C     INPUT VIA NAMELIST /VIBIN/ IS
C     LUVIB = 0 IF MORSE FUNCTIONS ARE TO BE CALCULATED
C               OTHERWISE READ, FROM UNIT LUVIB, NUMERICAL FUNCTIONS 
C               PRODUCED BY PROGRAM 'LEROY' 
C     LEROY = 0 FOR OLD VERSION OF LEROY WHICH DOES NOT OUTPUT POTENTIAL
C           = 1 FOR VERSION WHICH DOES
C
C     PARAMETERS OF MORSE POTENTIAL ARE DEFINED AS
C          V(R) = E0 + DE*(1-EXP(-BETA*(R-RE)))**2
C     WHERE E0 IS ABSOLUTE ENERGY IN AU
C     ALL OTHER PARAMETERS IN AU
C
C     ALTERNATIVELY MORSE POTENTIAL CAN BE SPECIFIED IN TERMS OF
C       W = OMEGAe,  A = OMEGAe/OMEGAeXe
C
      NAMELIST/VIBIN/DE,BETA,RE,W,A,E0,LUVIB,LEROY,ebase
C
      DATA LUVIB/0/,LEROY/1/
      DATA ZERO,ONE,TWO/0.D0,1.D0,2.D0/,QUART,HALF/0.25D0,0.5D0/,
     1 EPS/1.0D-6/,angst/0.52917706d0/,cm1/219475.D0/,tol/1.d-9/,
     2 sqangs/0.72744557d0/
C
      NFTA = IWRITE
      IBUG = LBUG
      NTRG = NTARG
      IRED = IREAD
      IEV = 0
C
      if(ntarg.gt.maxtgt) then
        write (iwrite,98) ntarg,maxtgt
        stop
      endif
c
      DO 6 I=1,NTRG
      LV(I) = 0
      IF(NVTARG(I).EQ.0) GO TO 6
      W = ZERO
      A = ZERO
      BETA = ZERO
      DE = ZERO
      LUVIB = 0
      ebase = zero
      READ(IRED,VIBIN)
C
      if(abs(ebase).lt.tol) ebase=base
      base = ebase
      LV(I) = LUVIB
      IF(LUVIB.EQ.0) THEN
C
        REV(I) = RE
        E0V(I) = E0-EBASE
        IF(W.EQ.ZERO) THEN
          IF(A.NE.ZERO) THEN
            AV(I) = A
            WRITE(IWRITE,1007)
          ELSE
            AV(I) = TWO*SQRT(TWO*RMASS*DE)/BETA
          ENDIF
          BETAV(I) = BETA
          DEV(I) = DE
          WV(I) = BETA*SQRT(TWO*DE/RMASS)
        ENDIF
        IF(BETA.EQ.ZERO) THEN
          IF(DE.NE.ZERO) THEN
            DEV(I) = DE
            WRITE(IWRITE,1007)
          ELSE
            DEV(I) = QUART*A*W
          ENDIF
          AV(I) = A
          WV(I) = W
          BETAV(I) = SQRT(TWO*RMASS*W/A)
        ENDIF
        WRITE(IWRITE,1002)I,NVTARG(I),E0V(I),DEV(I),
     1  BETAV(I),REV(I),WV(I),AV(I)
C
        DO 1 N=0,NVTARG(I)-1
        IEV = IEV+1
        if(iev.gt.maxvib) then
          write (iwrite,98)iev,maxvib
          stop
        endif
C
C----- VIBRATIONAL LEVELS
        HALFNW = (dble(N)+HALF)*WV(I)
        IVIB(IEV) = I
        NU(IEV)   = N
        EVIB(IEV) = E0V(I)+HALFNW-(HALF*HALFNW)**2/DEV(I)
C
C----- NORMALIZATION CONSTANT FOR SPECIAL CASE B=ALPHA
        EN = N
        ALPH = AV(I)-EN-EN-ONE
        S = ONE
        C = ONE
        DO J=1,N
          AJ = J
          C = (EN-AJ+ONE)/(EN-AJ+ALPH)*C
          S = S+C
        END DO
        C0(IEV) = LOG_GAMMA(EN+ALPH+ONE)-LOG_GAMMA(ALPH+ONE)-HALF*(
     1  LOG_GAMMA(EN+ONE)+LOG_GAMMA(EN+ALPH)+LOG(S)-LOG(BETAV(I)))
C
 1      CONTINUE
C
      ELSE
C
C----- INITIALIZE READING OF NUMERICAL WAVEFUNCTIONS 
C
        REWIND LUVIB
        DO N=1,NVTARG(I)
          IEV = IEV+1
          IVIB(IEV) = I
        END DO
C
      ENDIF
C
 6    CONTINUE
      RETURN
C
      ENTRY EXPTVE(NGEOM,NSTAT,R,EIG,ETARG,CURV,dummy)
C
C***********************************************************************
C
C    EXPTVE ADJUSTS R-MATRIX POLE POSITIONS IF POTENTIAL USED TO
C    GENERATE VIBRATIONAL WAVEFUNCTIONS DIFFERS FROM INPUT TARGET DATA
C
C***********************************************************************
C
      WRITE(NFTA,1001) EBASE
C
      IT = 1
      LUVIB = LV(IT)
      IF(LUVIB.EQ.0) THEN
C
C----- CALCULATE MORSE CURVE
        DO IG=1,NGEOM
        CURV(IG) = E0V(IT)+DEV(IT)*(ONE-EXP(-BETAV(IT)*(R(IG)-REV(IT))
     1  ))**2
        END DO
      ELSE
C
C----- READ POTENTIALS FROM LUVIB, CURRENT FORMAT AND SCALING IS THAT
C      OF LEROY
        IF(LEROY.GT.0) THEN
          READ(LUVIB)NSTEP,RFIRST,RSTEP
          RLAST= RFIRST+(NSTEP-1)*RSTEP
          IF(R(1).LT.RFIRST-EPS .OR. R(NGEOM).GT.RLAST+EPS) THEN
            WRITE(NFTA,1000) RFIRST,RLAST,R(1),R(NGEOM)
            STOP
          ENDIF
          allocate (vibf(nstep))
          READ(LUVIB) (VIBF(J),J=1,NSTEP)
C
C----- LINEARLY INTERPOLATE AT REQUIRED MESH POINTS
          IX = 2
          COEF0 = ONE/RSTEP
          RM = RFIRST
          RP = RFIRST+RSTEP
          DO 10 K=1,NGEOM
          RX = R(K)
 13       IF(RX.GT.RP) THEN
            RM = RP
            RP = RP+RSTEP
            IX=IX+1
            GO TO 13
          ELSE
            CURV(K) = COEF0*((RX-RM)*VIBF(IX)+(RP-RX)*VIBF(IX-1))-EBASE
          ENDIF
 10       CONTINUE
          deallocate (vibf)
C
        ELSE
          WRITE(NFTA,1006)
        ENDIF
      ENDIF
C
      IF(IBUG.GT.0) WRITE(NFTA,1005)(CURV(IG),IG=1,NGEOM)
      DO IG=1,NGEOM
        EDIFF = CURV(IG)-ETARG(IG,IT)
        ETARG(IG,IT) = CURV(IG)
        DO J=1,NSTAT
          EIG(IG,J) = EIG(IG,J)+EDIFF
        END DO
      END DO
C
      RETURN
C
      ENTRY RVIBR(NIV,NQUAD,ECHV,ICHV,NCHV,VIBR,dummy,R)
C
C***********************************************************************
C
C     RVIBR READS OR CALCULATES VIBRATIONAL WAVEFUNCTIONS
C      NIV   = TOTAL NUMBER OF VIBRATIONAL WAVEFUNCTIONS
C      NQUAD = NUMBER OF POINTS AT WHICH FUNCTIONS ARE REQUIRED
C      ECHV  = VIBRATIONAL ENERGY LEVELS RELATIVE TO EBASE
C      ICHV  = ELECTRONIC STATE TO WHICH EACH VIBRATIONAL STATE BELONGS
C      NCHV  = VIBRATIONAL QUANTUM NUMBER
C      VIBR  = OUTPUT WAVEFUNCTIONS
C      VIBF  = WORKSPACE OF DIMENSION AT LEAST NSTEP WHERE NSTEP IS
C              NUMBER OF POINTS AT WHICH NUMERICAL FUNCTIONS WERE
C              CALCULATED
C      R     = ARRAY HOLDING RADIII AT WHICH WAVEFUNCTIONS ARE REQUIRED
C
C***********************************************************************
C
C
C      CALCULATE MORSE WAVEFUNCTIONS ON MESH
C
      IF(IBUG.GT.0) WRITE(NFTA,1010)(WV(I),I=1,NTRG)
      IF(IBUG.GT.0) WRITE(NFTA,1011)
      DO 9 IT=1,NTRG
      LUVIB = LV(IT)
      IF(LUVIB.EQ.0) THEN
        DO 4 J=1,NIV
        I = IVIB(J)
        IF(I.NE.IT) GO TO 4
        ICHV(J) = I
        NCHV(J) = NU(J)
        ECHV(J) = EVIB(J)+ebase
        IF(IBUG.GT.0) WRITE(NFTA,1030) J,I,NCHV(J),ECHV(J)
C
        CALL MORSFN(AV(I),BETAV(I),REV(I),NU(J),R,NQUAD,C0(J),
     1  VIBR(1,J))
C
 4      CONTINUE
C
      ELSE
C
C----- READ NUMERICAL FUNCTIONS FROM UNIT LUVIB AND INTERPOLATE
C
        REWIND LUVIB
C
C----- LOOP OVER VIBRATIONAL WAVEFUNCTIONS
        do 60 iv=1,niv
        if(ivib(iv).ne.it) go to 60
        read(luvib,731,end=9) 
        read(luvib,730) nv,ev,nstep
        read(luvib,732) rfirst,rstep 
        rfirst = rfirst/angst
        rstep = rstep/angst
        allocate (vibf(nstep))
        read(luvib,702) (rdum,vibf(j),j=1,nstep)
        ichv(iv) = ivib(iv)
        nchv(iv) = nv
        echv(iv) = ev/cm1+ebase
c
        IF(IBUG.GT.0) WRITE(NFTA,1030) Iv,ICHV(Iv),NCHV(Iv),ECHV(Iv)
C
        RLAST= RFIRST+(NSTEP-1)*RSTEP
        IF(R(1).LT.RFIRST-EPS.and.abs(vibf(1)).gt.tol) then
          WRITE(NFTA,1000) RFIRST,RLAST,R(1),R(NQUAD)
          STOP
        ENDIF
        if(R(NQUAD).GT.RLAST+EPS.and.abs(vibf(nstep)).gt.tol) THEN
          WRITE(NFTA,1000) RFIRST,RLAST,R(1),R(NQUAD)
          STOP
        else
          n = (r(nquad)-rlast)/rstep+1
          do i=nstep+1,nstep+n
            vibf(i) = zero
          end do
        endif
C
C----- LINEARLY INTERPOLATE AT REQUIRED MESH POINTS
        IX = 2
        COEF0 = sqangs/RSTEP
        RM = RFIRST
        RP = RFIRST+RSTEP
        DO 50 K=1,NQUAD
        RX = R(K)
 30     IF(RX.GT.RP) THEN
          RM = RP
          RP = RP+RSTEP
          IX=IX+1
          GO TO 30
        ELSE
          VIBR(K,Iv)=COEF0*((RX-RM)*VIBF(IX)+(RP-RX)*VIBF(IX-1))
        ENDIF
 50     CONTINUE
C
 60     CONTINUE
        deallocate (vibf)
C
      ENDIF
C
 9    CONTINUE
      RETURN
 1002 FORMAT(/' Parameters for Morse vibrational wavefunctions for targe
     1t state',I2/I5,6F10.4)
 1003 FORMAT(/' NUMERICAL WAVEFUNCTIONS READ FROM UNIT',I3,'   NLEV=',I2
     1,'  NSTATE=',I2,'  Re=',F6.3,'  OMEGA=',F7.4)
 1004 FORMAT(/' INSUFFICIENT VIBRATIONAL LEVELS, NLEV =',I3,' NVTARG =',
     1I3)
 1001 FORMAT(' TARGET ENERGIES AND R-MATRIX POLES ADJUSTED TO FIT INPUT
     1VIBRATIONAL DATA ( RELATIVE TO',F10.5,' AU )')
 1006 FORMAT(/' THE REQUIRED POTENTIALS ARE NOT AVAILABLE AND SO NO ADJU
     1STMENTS HAVE BEEN MADE')
 1005 FORMAT(10D12.4)
 1007 FORMAT(/' WARNING MORSE POTENTIAL IS OVER DETERMINED, PARAMETERS M
     1AY BE INCONSISTENT')
 1010 FORMAT(/' Target vibrational wavefunctions'/' Omega =',10F10.4)
 1011 FORMAT(/9X,'Target',1X,' v',4X,'Energy (au)')
 1030 FORMAT(I4,I10,I4,D16.8)
 1000 FORMAT(//,' INPUT ERROR IN RVIBR ',/,' RFIRST =',D16.8,' RLAST =',
     1D16.8,' AIN =',D16.8,' AOUT =',D16.8,//)
 98   format(/' INPUT DATA EXCEEDS FIXED DIMENSIONS IN VIBINI',2i5)
 730  format(11x,i3,13x,f12.4,20x,i6)
 731  format(55x,i4,11x,i3)
 732  format(15x,f12.8,8x,f12.8)
 702  FORMAT((1X,4(f9.4,f10.6)))
      END
      SUBROUTINE NEWE(EMIN,EMAX,NE,MAXNE,NEREP,EINC)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     NEWE recomputes energy parameters MAXNE,NEREP and EINC for energy
C     range [ EMIN, EMAX ] and returns total number of energies NE in
C     this range.  Alternatively, if the range specified by MAXNE etc.
C     is smaller, then EMIN and EMAX are adjusted.
C
C***********************************************************************
C
      DIMENSION NEREP(MAXNE),EINC(2,MAXNE)
      data tiny/1.d-13/
C
      NE = 0
      NJ = 0
      EMIN0 = EMAX
      EMAX0 = EMIN
C
C---- Loop over energy subranges
      DO 2 I=1,MAXNE
      EMIN1 = EMAX
      EMAX1 = EMIN
      EN = EINC(1,I)
      DE = EINC(2,I)
      NEI = 0
      NEJ = 0
C
C---- Loop over energies in current subrange
      DO J=1,NEREP(I)
        IF(EN.LT.EMIN-tiny.OR.EN.GT.EMAX+tiny) CYCLE
        NEI = NEI+1
        EMIN1 = MIN(EN,EMIN1)
        EMAX1 = MAX(EN,EMAX1)
        EN = EN+DE
      END DO
C
C---- Update NEREP and EINC if not all energies lie in [EMIN,EMAX]
      NE = NE+NEI
      IF(NEI.ne.NEJ) then
        NJ = NJ+1
        NEREP(NJ) = NEI-NEJ
        NEJ = NEJ+NEI
        EINC(1,NJ) = EMIN1
        EINC(2,NJ) = DE
      endif
      emin0 = min(emin0,emin1)
      emax0 = max(emax0,emax1)
 2    CONTINUE
C
C---- Update number of subranges and energy limits
      MAXNE = NJ
      EMIN = EMIN0
      EMAX = EMAX0
C
      RETURN
      END
      SUBROUTINE VCHAN(NCHAN,NTARG,LCHL,MCHL,ICHL,NVTARG,EVIB,IVCHL,
     1LVCHL,MVCHL,EVCHL,starg,mtarg,gtarg,vstgt,vmtgt,vgtgt,NDIS,RMASS)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C     VCHAN SETS UP PARAMETERS SPECIFYING ASYMPTOTIC SCATTERING CHANNELS
C
C     NCHAN  = NUMBER OF FIXED NUCLEI SCATTERING CHANNELS
C     NTARG  = NUMBER OF TARGET STATES
C     LCHL   = FIXED NUCLEI CHANNEL ANGULAR MOMENTA
C     ICHL   = POINTER TO TARGET STATE OF F.N. CHANNEL
C     NVTARG = NUMBER OF VIBRATIONAL LEVELS FOR EACH TARGET STATE
C     EVIB   = VIBRATIONAL ENERGY LEVELS IN AU
C     IVCHL  = POINTER TO TARGET VIBRATIONAL LEVEL FOR VIBR. CHANNELS
C     LVCHL  = ANGULAR MOMENTA OF VIBRATIONAL CHANNELS
C     MVCHL  = SYMMETRY
C     EVCHL  = THRESHOLDS OF VIBRATIONAL CHANNELS IN RYD
C
C***********************************************************************
C
      DIMENSION NVTARG(NTARG),EVIB(*),LVCHL(*),LCHL(NCHAN),ICHL(NCHAN),
     1MCHL(NCHAN),EVCHL(*),IVCHL(*),MVCHL(*),vstgt(*),vmtgt(*),vgtgt(*),
     2starg(ntarg),gtarg(*),mtarg(*)
      integer starg,gtarg,vgtgt,vstgt,vmtgt
      DATA TWO/2.D0/
C
      K = 0
      IEV = 0
      DO I=1,NTARG
      DO NU=1,NVTARG(I)
      IEV = IEV+1
      vstgt(iev) = starg(i)
      vmtgt(iev) = mtarg(i)
      vgtgt(iev) = gtarg(i)
      DO 2 J=1,NCHAN
      IF(I.EQ.ICHL(J)) THEN
        K = K+1
        IVCHL(K) = IEV
        LVCHL(K) = LCHL(J)
        MVCHL(K) = MCHL(J)
        EVCHL(K) = TWO*(EVIB(IEV)-EVIB(1))
      ENDIF
 2    CONTINUE
      END DO  ! NU
      END DO  ! I
C
      DO 3 I=1,NDIS
      K = K+1
      IVCHL(K) = IEV+I
      LVCHL(K) = 0
      MVCHL(K) = 0
      EVCHL(K) = TWO*RMASS*(EVIB(IEV+I)-EVIB(1))
 3    CONTINUE
C
      RETURN
      END
      SUBROUTINE MA01A(A,B,M,N,M1,IAC,IBC,C,IND)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C      SOLUTION OF SIMULTANEOUS EQUATIONS AND OR MATRIX INVERSION
C
C
C      A           THE M*M MATRIX OF LEFT HAND SIDES OR THE MATRIX BEING
C                  INVERTED. OVERWRITTEN ON EXIT BY THE INVERSE MATRIX
C
C      B           THE M*N MATRIX OF THE RIGHT HAND SIDES. OVERWRITTEN
C                  ON EXIT BY SOLUTIONS
C
C      M           THE ORDER OF THE A-MATRIX. THIS MUST BE GREATER
C                  THAN 1 AND NOT GREATER THAN 100.THE UPPER LIMIT
C                  CAN BE EXTENDED BY RECOMPILING WITH LARGER
C                  DIMENSIONS FOR THE PRIVATE ARRAYS C AND IND
C
C      N           THE NUMBER OF THE RIGHT HAND SIDES IN THE
C                  SIMULTANEOUS EQUATIONS
C
C      IAR,IAC     DEFINE THE DIMENSIONS OF THE ARRAY WHERE THE A-MATRIX
C                  IS STORED
C
C      IBR,IBC     DEFINE THE DIMENSIONS OF THE ARRAY WHERE THE B-MATRIX
C                  IS STORED
C
C
C      M1          =0 ONLY SIMULTANEOUS EQUATIONS ARE SOLVED IF N.GT.0
C                       IF N=0 A FURTHER ENTRY TO MA01A WITH M1.LT.0
C                       REQUIRED TO OBTAIN THE INVERSE OF A
C                  .GT.0 MATRIX INVERSION. IN ADDITION SIMULTANEOUS
C                       EQUATIONS ARE SOLVED IF N.GT.0
C                  .LT.0 ONLY USED IF PREVIOUS ENTRY TO MA01A
C                       WITH M1=0. IN THIS CASE THE MATRIX INVERSION IS
C                       COMPLETED
C
C
      DIMENSION A(IAC,IAC),B(IAC,IBC),C(*),IND(*)
C
      IF(M1 < 0)GO TO 65
      AMAX=0.0
C
C      FIND THE FIRST PIVOTAL ELEMENT AND STORE THE CORRESPONDING ROW
C      NUMBER IN I4. IND DEFINES THE ORDER OF THE ROWS OF THE ORIGINAL
C      A-MATRIX BEFORE ROW INTERCHANGE
C
      DO 2 I=1,M
      IND(I)=I
      IF(ABS (A(I,1)) <= AMAX) THEN
        GO TO 2
      ELSE
        GO TO 3
      END IF
    3 AMAX=ABS (A(I,1))
      I4=I
    2 CONTINUE
      MM=M-1
C
C      EACH TIME THROUGH THE FOLLOWING LOOP THE A-MATRIX IS
C      REDUCED BY ONE
C
      DO 111 J=1,MM
C
C      INTERCHANGE THE I4TH AND THE JTH ROWS OF THE A-MATRIX AND STORE
C      ORDER IN IND IF I4 .NE.J
C
      IF(I4 <= J)GO TO 6
      ISTO=IND(J)
      IND(J)=IND(I4)
      IND(I4)=ISTO
      DO 5 K=1,M
      STO=A(I4,K)
      A(I4,K)=A(J,K)
      A(J,K)=STO
    5 CONTINUE
C
C      INTERCHANGE THE I4TH AND THE JTH ROWS OF THE B-MATRIX IF N.GT. 0
C
      IF(N <= 0)GO TO 6
      DO 8 K=1,N
      STO=B(I4,K)
      B(I4,K)=B(J,K)
      B(J,K)=STO
    8 CONTINUE
C
C      THE JTH ROW NOW CONTAINS THE PIVOTAL ELEMENT IN THE JTH POSITION
C      ELIMINATE THE JTH ELEMENT FROM EACH OF THE REMAINING ROWS OF THE
C      A-MATRIX AND THE B-MATRIX AND STORE THE MULTIPLIERS IN THE LOWER
C      TRIANGLE
C
    6 AMAX=0.0
      J1=J+1
      DO 11 I=J1,M
      A(I,J)=A(I,J)/A(J,J)
      DO 10 K=J1,M
      A(I,K)=A(I,K)-A(I,J)*A(J,K)
      IF (K > J1)GO TO 10
C
C      FIND THE NEXT PIVOTAL ELEMENT AND STORE THE CORRESPONDING ROW
C      NUMBER IN I4
C
      IF(ABS (A(I,K)) <= AMAX) GO TO 10
   17 AMAX=ABS (A(I,K))
      I4=I
   10 CONTINUE
    9 IF(N <= 0)GO TO 11
      DO 13 K=1,N
      B(I,K)=B(I,K)-A(I,J)*B(J,K)
   13 CONTINUE
   11 CONTINUE
  111 CONTINUE
C
C      THE ELIMINATION IS NOW COMPLETE AND THE A-MATRIX HAS BEEN
C      REDUCED TO THE PRODUCT OF AN UPPER AND LOWER TRIANGLE MATRIX
C
      IF(N <= 0)GO TO 18
C
C      NOW CARRY OUT THE BACK SUBSTITUTION AND STORE RESULT IN THE
C      B-MATRIX IF THERE IS AT LEAST ONE RIGHT HAND SIDE
C
      DO 127 I1=1,M
      DO 227 J=1,N
      I=M+1-I1
      IF(M <= I)GO TO 327
      I2=I+1
      DO 32 K=I2,M
      B(I,J)=B(I,J)-A(I,K)*B(K,J)
   32 CONTINUE
  327 B(I,J)=B(I,J)/A(I,I)
  227 CONTINUE
  127 CONTINUE
   18 IF(M1 <= 0)GO TO 64
C
C      REPLACE THE A-MATRIX BY ITS INVERSE WHEN M1.NE. ZERO
C
C      FIRST INVERT THE LOWER TRIANGLE MATRIX AND STORE ON ITSELF
C
   65 DO 140 I1=1,MM
      I=M+1-I1
      I2=I-1
      DO 41 J1=1,I2
      J=I2+1-J1
      J2=J+1
      W1=-A(I,J)
      IF(I2 < J2) GO TO 141
      DO 42 K=J2,I2
      W1=W1-A(K,J)*C(K)
   42 CONTINUE
  141 C(J)=W1
   41 CONTINUE
      DO 40 K=1,I2
      A(I,K)=C(K)
   40 CONTINUE
  140 CONTINUE
C
C      NOW INVERT THE UPPER TRIANGLE MATRIX AND FORM THE ORIGINAL
C      A-MATRIX APART 6ROM COLUMN INTERCHANGE. THIS OVERWRITES THE
C      ORIGINAL A-MATRIX
C
      DO 150 I1=1,M
      I=M+1-I1
      I2=I+1
      W=1.0/A(I,I)
      DO 56 J=1,M
      IF (I < J) THEN
       GO TO 52
      ELSE IF (I == J) THEN
        GO TO 53
      ELSE
        GO TO 54
      END IF
   52 W1=0.0
      GO TO 55
   53 W1=1.0
      GO TO 55
   54 W1=A(I,J)
   55 IF(I1 <= 1) GO TO 156
      DO 58 K=I2,M
      W1=W1-A(I,K)*A(K,J)
   58 CONTINUE
  156 C(J)=W1
   56 CONTINUE
      DO 50 J=1,M
      A(I,J)=C(J)*W
   50 CONTINUE
  150 CONTINUE
C
C      RE-ORDER THE COLUMNS OF THE INVERSE A-MATRIX TO COINCIDE WITH
C      THE ORDER OF THE ROWS OF THE A-MATRIX ON INPUT
C
      DO 60 I=1,M
   63 IF(IND(I) == I)GO TO 60
      J=IND(I)
      DO 62 K=1,M
      STO=A(K,I)
      A(K,I)=A(K,J)
      A(K,J)=STO
   62 CONTINUE
      ISTO=IND(J)
      IND(J)=J
      IND(I)=ISTO
      GO TO 63
   60 CONTINUE
   64 RETURN
      END
      SUBROUTINE SPLINE(N,NPTS,KNOTS,RK,CK,R,V,dummy,dummy1,dummy2)
C
C***********************************************************************
C
C      SPLINE SETS UP SPLINE INTERPOLATION OF VECTOR V OF LENGTH N
C        WHICH IS GIVEN ON MESH R(NPTS)
C        USES NAG ROUTINE E02BAF
C        KNOTS AND RK ARE SET UP PRIOR TO CALL
C        SPLINE COEFFICIENTS ARE OUTPUT IN CK
C        W,WORK1 AND WORK2 ARE WORK SPACE
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION R(NPTS),V(NPTS,N),W(NPTS),RK(KNOTS),CK(KNOTS,*),
     1 WORK1(NPTS),WORK2(4,KNOTS)
      DATA ONE,IWRITE/1.D0,6/
C
C    The following line is a warning that should be removed once E02BAF
C    is replaced.
      WRITE(IWRITE,*) 'NAG routine not replaced. Spline procedure not 
     1 working in this version of the code'
      DO I=1,NPTS
        W(I) = ONE
      END DO
C
      IFAIL = 0
      DO 4 K=1,N
!NV03      CALL E02BAF(NPTS,KNOTS,R,V(1,K),W,RK,WORK1,WORK2,CK(1,K),SS,IFAIL)
 4    CONTINUE
C
      RETURN
      END
      SUBROUTINE SPLINI(NKNOT,KNOTS,RK,MAXKNT,NGEOM,R,IWRITE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION RK(MAXKNT),R(NGEOM)
C
C***********************************************************************
C
C     SPLINI INITIALIZES SPLINE INTERPOLATIONS FOR USE BY NAG ROUTINES
C
C      NKNOT = NUMBER OF INTERIOR KNOTS IN SPLINE
C              IF NKNOT=0 THEN KNOTS ARE CHOSEN BY CODE FOLLOWING NAG
C              RECOMMENDATIONS, (THIS IS THE PREFERRED OPTION)
C      KNOTS = TOTAL NUMBER OF KNOTS
C      RK    = ARRAY HOLDING POSITIONS OF KNOTS
C      MAXKNT= DIMENSION OF RK
C      R     = ARRAY HOLDING INPUT INTERNUCLEAR SEPARATIONS
C      NGEOM = NUMBER OF INPUT GEOMETRIES
C      IWRITE= LOGICAL UNIT FOR ERROR MESSAGES
C
C***********************************************************************
C
      IF(NGEOM.LT.4) THEN
        WRITE(IWRITE,10)NGEOM
 10     FORMAT(/' SPLINE INTERPOLATION REQUIRES AT LEAST 4 GEOMETRIES',
     1   5X,'NGEOM =',I2)
         STOP
      ENDIF
C
      IF(NKNOT.EQ.0) THEN
        KNOTS = NGEOM+4
      ELSE
        KNOTS = NKNOT+8
      ENDIF
      IF(KNOTS.GT.MAXKNT) THEN
         WRITE(IWRITE,11) NKNOT
 11      FORMAT(/' TOO MANY KNOTS, NKNOT =',I3)
         STOP
      ELSE IF (NKNOT.EQ.0) THEN
         DO I=3,NGEOM-2
           RK(I+2) = R(I)
         END DO
      ENDIF
C
      RETURN
      END
      SUBROUTINE VMESH(A,B,NQUAD,RQUAD,WTS)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     MESH SETS UP QUADRATURE MESH AND WEIGHTS FOR INTEGRATIONS REQUIRED
C     IN THE ADIABATIC NUCLEI APPROXIMATION (AND POSSIBLY ELSEWHERE)
C
C     A,B ARE LIMITS OF QUADRATURE
C     NQUAD        = NUMBER OF MESH POINTS, IF THIS IS ODD SIMPSONS RULE
C                    IS USED, ELSE GAUSS LEGENDRE
C     RQUAD(NQUAD) = MESH POINTS
C     WTS(DIM)     = WEIGHTS FOR QUADRATURE
C     THE QUADRATURE SCHEME IS ASSUMED TO BE SYMMETRIC ABOUT THE MID-
C     POINT OF THE RANGE, HENCE 'DIM' = NQUAD/2 FOR A GAUSSIAN SCHEME
C                           OR        = (NQUAD+1)/2 FOR NEWTON-COTES
C     HOWEVER NAG ROUTINE D01BCF REQUIRES 'DIM' = NQUAD THOUGH THE
C     REMAINDER CAN BE DISCARDED
C
C***********************************************************************
C
      DIMENSION RQUAD(NQUAD),WTS(*)
      DATA C,D/0.D0,0.D0/,IFAIL/0/
      DATA HALF,THREE,IWRITE/0.5D0,3.D0,6/
C
      IF(MOD(NQUAD,2).NE.0) THEN
C
C----- SIMPSONS RULE
        NWTS = (NQUAD+1)/2
        NQ1 = NQUAD-1
        H = (B-A)/dble(NQ1)
C
        RQUAD(1) = A
        DO I=2,NQ1
          RQUAD(I) = RQUAD(I-1)+H
        END DO
        RQUAD(NQUAD) = B
C
        WT1 = H/THREE
        WTT = WT1+WT1
        WTI = WTT+WTT
        WTS(1) = WT1
        DO I=2,NWTS
          WTS(I) = WTI
          WTT = -WTT
          WTI = WTI+WTT
        END DO
        WTS(NWTS) = HALF*WTS(NWTS)
C
      ELSE
C
C---- GAUSS-LEGENDRE
C     (NAG ROUTINE D01BCF WILL ALSO RETURN OTHER GAUSSIAN SCHEMES IF
C     REQUIRED )
        ITYPE = 0
!NV03        CALL D01BCF(ITYPE,A,B,C,D,NQUAD,WTS,RQUAD,IFAIL)
C 
C    The following line is a warning that should be removed once D01BCF
C    is replaced.
      WRITE(IWRITE,*) 'NAG routine D01BCF not replaced. This part of the
     1 program does not work in this version of the code' 
      ENDIF
C
      RETURN
      END
      SUBROUTINE INTERP(N,NPTS,R,FR,KNOTS,RK,CK)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C      INTERP EVALUATES VECTOR FR OF LENGTH N AT MESH POINTS
C      R(I),I=1,NPTS USING SPLINE INTERPOLATION
C      ASSUMES COEFFS HAVE BEEN PREVIOUSLY SET UP IN ARRAY CK
C      KNOTS AND RK ARE AS DEFINED IN SPLINI
C
C***********************************************************************
C
      DIMENSION R(NPTS),FR(NPTS,N),RK(KNOTS),CK(KNOTS,N)
      DATA IFAIL,IWRITE/0,6/
C
C    The following line is a warning that should be removed once E02BBF
C    is replaced.
      WRITE(IWRITE,*) 'NAG routine not replaced. Spline interpolation
     1 does not work in this version of the code' 
C
      DO I=1,N
        DO IR=1,NPTS
!NV03      CALL E02BBF(KNOTS,RK,CK(1,I),R(IR),ER,IFAIL)
          FR(IR,I) = ER
        END DO
      END DO
C
      RETURN
      END
      SUBROUTINE CHECKQ(NQUAD,NVIB,WTS,VFN,IWRITE)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     CHECKQ CHECKS THAT QUADRATURE SCHEME IS ADEQUATE BY COMPUTING
C     OVERLAPS OF TARGET VIBRATIONAL WAVEFUNCTIONS
C     NOTE THAT OVERLAP MATRIX MAY NOT BE EXACTLY A UNIT MATRIX IF THE
C     RANGE OF THE QUADRATURE IS TOO SMALL
C
C***********************************************************************
C
      DIMENSION WTS(NQUAD),VFN(NQUAD,NVIB)
      DATA ZERO/0.D0/
C
      WRITE(IWRITE,1) NQUAD
 1    FORMAT(/' QUADRATURE CHECK, NUMBER OF POINTS =',I4/' OVERLAPS OF
     1VIBRATIONAL WAVEFUNCTIONS')
C
      IF(MOD(NQUAD,2).NE.0) THEN
        NWTS = (NQUAD+1)/2
      ELSE
        NWTS = NQUAD/2
      ENDIF
C
      DO MU=1,NVIB
      DO NU=1,MU
      SUM = ZERO
      DO 4 IX=1,NWTS
      IXN = NQUAD-IX+1
      SUM = SUM+WTS(IX)*(VFN(IX,MU)*VFN(IX,NU)+VFN(IXN,MU)*VFN(IXN,NU))
 4    CONTINUE
      WRITE(IWRITE,2) MU,NU,SUM
 2    FORMAT(2I5,D12.4)
      END DO  ! NU
      END DO  ! MU
C
      RETURN
      END
      SUBROUTINE MORSFN(A,BETA,RE,N,RR,NPTS,C0,HFN)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C***********************************************************************
C
C     COMPUTES MORSE WAVEFUNCTION HFN ON MESH RR(NPTS)
C         N = QUANTUM NUMBER
C
C***********************************************************************
C
      DIMENSION RR(NPTS),HFN(NPTS)
      DATA ZERO,HALF,ONE/0.D0,0.5D0,1.D0/
C
      ALPHA = A-N-N-1
C
C----- SPECIAL CASE B=ALPHA ONLY (THE REST OF THE CODE IS QUITE GENERAL)
      B = ALPHA
C
      DO 4 IR=1,NPTS
      R = RR(IR)
C
      BR = BETA*(R-RE)
      YLOG = LOG(A)-BR
      Y = A*EXP(-BR)
C
C----- OBTAIN LAGUERRE FUNCTION BY SUMMING SERIES
C
      ALG = ONE
      AJ = ZERO
      ANJ = Dble(N+1)
      DO J=1,N
        AJ = AJ+ONE
        ANJ = ANJ-ONE
        ALG = ONE-AJ*Y*ALG/(ANJ*(ANJ+ALPHA))
      END DO
C
      HFN(IR) = ALG*EXP(HALF*(B*YLOG-Y)+C0)
 4    CONTINUE
C
      RETURN
      END
      SUBROUTINE ADNUC(NGEOM,R,NCHAN,ICHL,NTARG,NVTARG,VIBFN,KNOTS,RK,
     1NVCHAN,RFIX,RVIB,CV,NMAT,NQUAD,RQUAD,WTS)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C
C      ADNUC CALCULATES EITHER THE ADIABATIC NUCLEI APPROXIMATION TO THE
C      SET OF MATRICES RFIX(R)
C
C      RFIX  = FIXED NUCLEI MATRICES TO BE AVERAGED (LOWER TRIANGLES,
C              INPUT AS (((RFIX(I,J,K),I=1,NGEOM),J=1,NCHAN*(NCHAN+1)/2)
C                         ,K=1,NMAT)
C      RVIB  = OUTPUT MATRICES (LOWER TRIANGLES)
C      NQUAD,RQUAD,WTS DEFINE THE QUADRATURE SCHEME (SEE VMESH)
C      KNOTS,RK, SPECIFY THE SPLINE INTERPOLATION (SEE SPLINI)
C      NTARG = NUMBER OF TARGET ELECTRONIC STATES
C      NVTARG= NUMBER OF VIBRATIONAL LEVELS FOR EACH ELECTRONIC STATE
C      ICHL  = POINTERS FROM ASYMPTOTIC FIXED NUCLEI CHANNELS TO TARGET
C              STATES
C      CV    = WORK SPACE (LARGE ARRAY)
C
C***********************************************************************
C
      DIMENSION RK(*),R(NGEOM),CV(*),RVIB(NVCHAN*(NVCHAN+1)/2*NMAT),
     1 NVTARG(NTARG),VIBFN(NQUAD,*),ICHL(NCHAN),WTS(*),RQUAD(NQUAD),
     * RFIX(NCHAN*(NCHAN+1)/2*NMAT,NGEOM),
     * RMAT(NQUAD*NCHAN*(NCHAN+1)*NMAT/2),
     * CKR(knots*NCHAN*(NCHAN+1)*NMAT/2),
     * RT(ngeom*NCHAN*(NCHAN+1)/2*NMAT)
C
      NCHSQ= NCHAN*(NCHAN+1)*NMAT/2
C
C---- TRANSPOSE RFIX SO THAT GEOMETRIES ARE CONTIGUOUS
      IR = 0
      DO I=1,NCHSQ
        DO IG=1,NGEOM
          IR = IR+1
          RT(IR) = RFIX(I,IG)
        END DO
      END DO
C
      CALL SPLINE(NCHSQ,NGEOM,KNOTS,RK,CKR,R,RT,dum,dum,dum)
C
C----- INTERPOLATE FIXED NUCLEI MATRICES ON QUADRATURE MESH
      CALL INTERP(NCHSQ,NQUAD,RQUAD,RMAT,KNOTS,RK,CKR)
C
C---- Multiply fixed nuclei matrices by vibrational wavefunctions and
C     integrate
      CALL AVGR(NQUAD,WTS,NCHAN,NMAT,ICHL,RMAT,NTARG,NVTARG,VIBFN,RVIB)
C
      RETURN
      END
      SUBROUTINE AVGR(NQUAD,WTS,NCHAN,NMAT,ICHL,RMAT,NTARG,NVTARG,VFN,
     1RIJ)
C
C***********************************************************************
C
C     AVGR EVALUATES INTEGRALS REQUIRED FOR THE ADIABATIC NUCLEI APPROX
C
C     INPUT PARAMETERS ARE
C      NQUAD = NUMBER OF POINTS IN QUADRATURE SCHEME
C      WTS   = QUADRATURE WEIGHTS (ASSUMED SYMMETRIC ABOUT MID POINT)
C      NCHAN = DIMENSION OF THE MATRICES TO BE AVERAGED
C      RMAT  = THE INTERPOLATED FIXED NUCLEI MATRICES EVALUATED AT THE
C              ABSCISSAE OF THE QUADRATURE SCHEME
C      NMAT  = NUMBER OF MATRICES
C      VFN   = THE TARGET VIBRATIONAL WAVEFUNCTION EVALUATED ON MESH
C      NTARG = NUMBER OF TARGET ELECTRONIC STATES
C      NVTARG= NUMBER OF VIBRATIONAL LEVELS FOR EACH ELECTRONIC STATE
C      ICHL  = POINTERS FROM ASYMPTOTIC FIXED NUCLEI CHANNELS TO TARGET
C              STATES
C
C     OUTPUT PARAMETER IS
C     RIJ, THE AVERAGED MATRIX
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION VFN(NQUAD,*),RIJ(*),RMAT(NQUAD,NCHAN*(NCHAN+1)*NMAT/2),
     1WTS(*),NVTARG(NTARG),ICHL(NCHAN)
      DATA ZERO/0.D0/
C
      NCHSQ = NCHAN*(NCHAN+1)/2
C
C----- LOOP OVER MATRICES
      K = 0
      DO LAM=1,NMAT
C
C----- LOOP OVER FIRST INDEX ON VIBRATIONAL LEVELS
      MU = 0
      DO IM=1,NTARG
      DO MV=1,NVTARG(IM)
      MU = MU+1
C
C----- LOOP OVER FIRST INDEX ON ELECTRONIC CHANNELS
      KS = 0
      DO 13 I=1,NCHAN
      IF(IM.NE.ICHL(I)) GO TO 13
C
C----- LOOP OVER SECOND INDEX ON VIBRATIONAL LEVELS
      NU = 0
      DO 23 IN=1,NTARG
      DO 24 NV=1,NVTARG(IN)
      NU = NU+1
      IF(NU.GT.MU) GO TO 24
      IF(MU.EQ.NU) THEN
         NCH = I
      ELSE
         NCH = NCHAN
      ENDIF
C
C----- LOOP OVER SECOND INDEX ON CHANNELS
      DO 33 J=1,NCH
      IF(IN.NE.ICHL(J)) GO TO 33
      K = K+1
      IF(I.GE.J) THEN
         KR = I*(I-1)/2+J+(LAM-1)*NCHSQ
      ELSE
         KR = J*(J-1)/2+I+(LAM-1)*NCHSQ
      ENDIF
C
C      CALCULATE THE INTEGRALS USING NUMERICAL QUADRATURE.
C
      IF(MOD(NQUAD,2).NE.0) THEN
        NWTS = (NQUAD+1)/2
      ELSE
        NWTS = NQUAD/2
      ENDIF
      SUM = ZERO
      DO 4 IX=1,NWTS
      IXN = NQUAD-IX+1
      SUM = SUM+WTS(IX)*(VFN(IX,MU)*RMAT(IX,KR)*VFN(IX,NU)
     1 +VFN(IXN,MU)*RMAT(IXN,KR)*VFN(IXN,NU))
 4    CONTINUE
C
      RIJ(K) = SUM
C
   33 CONTINUE
   24 CONTINUE
   23 CONTINUE
   13 CONTINUE
      END DO  ! MV
      END DO  ! IM
      END DO  ! LAM
C
      RETURN
      END
      subroutine DATEST(daytim)
      character daytim*20,date*8,time*10,zone*5
      integer val(8)
c
      CALL DATE_and_TIME(DAte,time,zone,val)
      daytim = DAte//'  '//TIMe
      return
      end
      SUBROUTINE CGCOEF(J1,J2,J3,M1,M2,M3,C)
C
C***********************************************************************
C
C     CGCOEF COMPUTES THE CLEBSCH-GORDAN COEFFICIENT
C            C(JJ1,MM1,JJ2,MM2,JJ3,MM3)
C            WHERE
C                 J1 = 2 * JJ1 + 1
C                 M1 = 2 * MM1 + 1 .. ETC
C
C            DEFINITION CORRESPONDS TO THAT OF M.E. ROSE
C
C***********************************************************************
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      PARAMETER (JSMAX=100)
      DIMENSION BINOM((JSMAX*JSMAX+3*JSMAX+4)/2),IND(JSMAX+2)
      DIMENSION J(3),K(3),L(3)
      save
      DATA ZERO,ONE/0.D0,1.D0/
C
      JS = (J1 + J2 + J3 - 1) / 2
      J(1) = J1
      J(2) = J2
      J(3) = J3
      K(1) = JS - J2
      K(2) = JS - J3
      K(3) = JS - J1
C
      C=ZERO
C
      M = M3
      IF (J3-1 .LT. IABS(M-1)) RETURN
      IF (J1-1 .LT. IABS(M1-1)) RETURN
      DO 50 I = 1, 3
      IF (K(I) .LT. 0) RETURN
   50 CONTINUE
C
      A = ONE/ (BINOM(IND(JS+1)+K(2)) * BINOM(IND(J3)+K(1)))
      L(3) = (J3 + M3 - 2) / 2
      M2Q = M3 - M1 + 1
      IF(M2Q.NE.M2) GO TO 100
      IF (IABS(M2-1) .GT. J2-1) GO TO 100
      L(1) = (J1 - M1) / 2
      L(2) = (J2 + M2 - 2) / 2
      B = A
      DO II = 1, 3
        B = BINOM(IND(J(II))+K(II)) / BINOM(IND(J(II))+L(II)) * B
      END DO
      B = DSQRT(B)
C
C     SUM OVER NU
C
      I1 = MAX0(L(1)-K(1),L(2)-K(3),0)
      I2 = MIN0(L(1),L(2),K(2))
      T = ZERO
      IF (I2 .LT. I1) GO TO 201
      LBL = IND(K(2)+1) + I1
      LBH = IND(K(2)+1) + I2
      LB1 = IND(K(1)+1) + L(1) - I1
      LB2 = IND(K(3)+1) + L(2) - I1
      DO LB = LBL, LBH
        T = BINOM(LB) * BINOM(LB1) * BINOM(LB2) - T
        LB1 = LB1 - 1
        LB2 = LB2 - 1
      END DO
  201 C = B * T * (-ONE) ** I2
  100 CONTINUE
C
      RETURN
C
C                     ********************
C
      ENTRY ICGCF
C
C     ENTRY ICGCF IS USED TO COMPUTE THE ARRAYS BINOM AND IND
C                 BINOM CONTAINS BINOMIAL COEFFICIENTS
C                 IND(I+1) + J GIVES THE LOCATION OF THE BINOMIAL
C                 COEFFICIENT (I,J) WITHIN THE ARRAY BINOM
C
C     ICGCF MUST BE CALLED BEFORE THE FIRST CALL TO CGCOEF
C
C
      IND(1) = 1
      IND(2) = 1
      BINOM(1) = ONE
      BINOM(2) = ONE
      LB = 3
      LB1 = 1
      JS = JSMAX + 1
      DO I = 2, JS
        DO JJ = 2, I
          BINOM(LB) = BINOM(LB1) + BINOM(LB1+1)
          LB = LB + 1
          LB1 = LB1 + 1
        END DO
        IND(I+1) = LB1
        BINOM(LB) = ONE
        LB = LB + 1
      END DO
C
      RETURN
      END
      subroutine sort_outer(n,ip,x)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
c
c-----sorts elements of X and outputs pointer in IP
c
      dimension x(n),ip(n)
c
      do i=1,n
        ip(i) = i
      end do
 3    i=1
      nswop = 0
      j = ip(1)
 1    if(i.eq.n) go to 2
      xlast = x(j)
      i = i+1
      j = ip(i)
      if(x(j).ge.xlast) go to 1
      ip(i) = ip(i-1)
      ip(i-1) = j
      nswop = nswop+1
      go to 1
 2    if(nswop.ne.0) go to 3
      return
      end
      subroutine swap(n,ip,in)
c
c-----swaps elements of IN using pointer IP, temp is work space
c
      integer in(n),temp(n),ip(n)
c
      do i=1,n
        temp(i) = in(i)
      end do
      do i=1,n
        in(i) = temp(ip(i))
      end do
      return
      end

      SUBROUTINE print_ukrmol_header (unit)
      USE version_control, ONLY: print_git_revision
      INTEGER, INTENT(IN) :: unit
      WRITE(unit, '("+--------------------------------------------------!
     *-----------------------+")')
      WRITE(unit, '("|              _              |                    !
     *                       |")')
      WRITE(unit, '("| || || ||//  | \          |  | University College !
     *London (C) 1994 - 2020 |")')
      WRITE(unit, '("| || || ||    | / |/\/\ /\ |  | Open University    !
     *       (C) 2007 - 2020 |")')
      WRITE(unit, '("| \\_// ||\\  | \ | | | \/ |  |                    !
     *                       |")')
      WRITE(unit, '("|                             |                    !
     *                       |")')
      CALL print_git_revision(unit)
      END SUBROUTINE print_ukrmol_header
